#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc ClearPrefs {} {
    global prefs
    if {[tk_messageBox -type okcancel -default cancel \
	     -message "Clear Preferences?"] == "ok"} {
	catch {file delete -force $prefs(file)}
	catch {file delete -force $prefs(file,alt)}
    }
}

proc UpdatePrefsMenu {} {
    UpdateMarkerPrefsFormatMenu
}

proc LoadPrefs {} {
    global prefs
    global ds9
    global tcl_platform

    if {$tcl_platform(platform) != "windows"} {
	if {[file exists $prefs(file)]} {
	    catch {source $prefs(file)}
	} elseif {[file exists $prefs(file,alt)]} {
	    catch {source $prefs(file,alt)}
	} elseif {[file exists $prefs(file,local)]} {
	    catch {source $prefs(file,local)}
	} elseif {[file exists $prefs(file,opt)]} {
	    catch {source $prefs(file,opt)}
	}
    } else {
	if {[file exists $prefs(file)]} {
	    catch {source $prefs(file)}
	} elseif {[file exists $prefs(file,alt)]} {
	    catch {source $prefs(file,alt)}
	}
    }
 
    # now fix any backward compatibility issues
    global ds9
    if {$ds9(dialog) == "blueplate"} {
	set ds9(dialog) windows
    }
    
    global bin
    if {[lindex $bin(factor) 1] == {}} {
	set bin(factor) "$bin(factor) $bin(factor)"
    }
    
    global mosaic
    if [info exists mosaic(fast)] {
	set ds9(mosaic,fast) $mosaic(fast)
    }
    
    global marker
    if [info exists prefs(shape)] {
	set prefs(marker,shape) $prefs(shape)
	set marker(shape) $prefs(shape)
    }
    global circle
    if [info exists circle] {
	set marker(circle,radius) $circle(radius)
    }    
    global ellipse
    if [info exists ellipse] {
	set marker(ellipse,radius1) $ellipse(radius1)
	set marker(ellipse,radius2) $ellipse(radius2)
    }
    global box
    if [info exists box] {
	set marker(box,width) $box(width)
	set marker(box,height) $box(height)
    }
    global projection
    if [info exists projection(thick)] {
	set marker(projection,thick) $projection(thick)
    }    
    global annulus
    if [info exists annulus] {
	set marker(annulus,inner) $annulus(inner)
	set marker(annulus,outer) $annulus(outer)
	set marker(annulus,annuli) $annulus(annuli)
    }    
    global boxannulus
    if [info exists boxannulus] {
	set marker(boxannulus,size1) $boxannulus(size1)
	set marker(boxannulus,size2) $boxannulus(size2)
	set marker(boxannulus,size3) $boxannulus(size3)
	set marker(boxannulus,annuli) $boxannulus(annuli)
    }    
    global ellipseannulus
    if [info exists ellipseannulus] {
	set marker(ellipseannulus,radius1) $ellipseannulus(radius1)
	set marker(ellipseannulus,radius2) $ellipseannulus(radius2)
	set marker(ellipseannulus,radius3) $ellipseannulus(radius3)
	set marker(ellipseannulus,annuli) $ellipseannulus(annuli)
    }    
    global panda
    if [info exists panda] {
	set marker(panda,inner) $panda(inner)
	set marker(panda,outer) $panda(outer)
	set marker(panda,annuli) $panda(annuli)
	set marker(panda,ang1) $panda(ang1)
	set marker(panda,ang2) $panda(ang2)
	set marker(panda,angnum) $panda(angnum)
    }
}

proc SavePrefs {} {
    global ds9
    global prefs
    global message

    # open prefs file
    set file [open $prefs(file) w]
    if {$file == {}} {
	tk_messageBox -message \
	    "$message(error,prefs,save)" \
	    -type ok -icon error
	return
    }

    puts $file "global ds9"
    puts $file "global prefs"

    # File prefs
    puts $file ""
    puts $file "\# File prefs"
    global ps
    puts $file "global ps"
    puts $file "set prefs(ps,dest) $prefs(ps,dest)"
    puts $file "set ps(dest) $prefs(ps,dest)"
    puts $file "set prefs(ps,cmd) $prefs(ps,cmd)"
    puts $file "set ps(cmd) $prefs(ps,cmd)"
    puts $file "set prefs(ps,filename) $prefs(ps,filename)"
    puts $file "set ps(filename) $prefs(ps,filename)"
    puts $file "set prefs(ps,color) $prefs(ps,color)"
    puts $file "set ps(color) $prefs(ps,color)"
    puts $file "set prefs(ps,level) $prefs(ps,level)"
    puts $file "set ps(level) $prefs(ps,level)"
    puts $file "set prefs(ps,interpolate) $prefs(ps,interpolate)"
    puts $file "set ps(interpolate) $prefs(ps,interpolate)"
    puts $file "set prefs(ps,resolution) $prefs(ps,resolution)"
    puts $file "set ps(resolution) $prefs(ps,resolution)"

    puts $file "set prefs(ps,orient) $prefs(ps,orient)"
    puts $file "set ps(orient) $prefs(ps,orient)"
    puts $file "set prefs(ps,scale) $prefs(ps,scale)"
    puts $file "set ps(scale) $prefs(ps,scale)"
    puts $file "set prefs(ps,size) $prefs(ps,size)"
    puts $file "set ps(size) $prefs(ps,size)"
    puts $file "set prefs(ps,width) $prefs(ps,width)"
    puts $file "set ps(width) $prefs(ps,width)"
    puts $file "set prefs(ps,height) $prefs(ps,height)"
    puts $file "set ps(height) $prefs(ps,height)"

    # Edit prefs
    puts $file ""
    puts $file "\# Edit prefs"
    puts $file "set prefs(ds9,mode) $prefs(ds9,mode)"
    puts $file "set ds9(mode) $prefs(ds9,mode)"

    # Frame prefs
    puts $file ""
    puts $file "\# Frame prefs"
    global canvas
    puts $file "global canvas"
    puts $file "set canvas(auto) $canvas(auto)"
    puts $file "set canvas(size) $canvas(size)"
    global tile
    puts $file "global tile"
    puts $file "set prefs(tile,mode) $prefs(tile,mode)"
    puts $file "set tile(mode) $prefs(tile,mode)"
    global blink
    puts $file "global blink"
    puts $file "set prefs(blink,interval) $prefs(blink,interval)"
    puts $file "set blink(interval) $prefs(blink,interval)"

    # Bin prefs
    puts $file ""
    puts $file "\# Bin prefs"
    global bin
    puts $file "global bin"
    puts $file "set prefs(bin,function) $prefs(bin,function)"
    puts $file "set bin(function) $prefs(bin,function)"
    puts $file "set prefs(bin,factor) \{$prefs(bin,factor)\}"
    puts $file "set bin(factor) \{$prefs(bin,factor)\}"
    puts $file "set prefs(bin,depth) $prefs(bin,depth)"
    puts $file "set bin(depth) $prefs(bin,depth)"
    puts $file "set prefs(bin,buffersize) $prefs(bin,buffersize)"
    puts $file "set bin(buffersize) $prefs(bin,buffersize)"
    puts $file "set prefs(bin,smooth) $prefs(bin,smooth)"
    puts $file "set bin(smooth) $prefs(bin,smooth)"
    puts $file "set prefs(bin,smooth,function) $prefs(bin,smooth,function)"
    puts $file "set bin(smooth,function) $prefs(bin,smooth,function)"

    # Zoom prefs
    puts $file ""
    puts $file "\# Zoom prefs"
    global current
    puts $file "global current"
    global wcs
    puts $file "global wcs"
    puts $file "set prefs(wcs,align) $prefs(wcs,align)"
    puts $file "set wcs(align) $prefs(wcs,align)"
    puts $file "set prefs(wcs,align,system) $prefs(wcs,align,system)"
    puts $file "set wcs(align,system) $prefs(wcs,align,system)"
    puts $file "set prefs(wcs,align,sky) $prefs(wcs,align,sky)"
    puts $file "set wcs(align,sky) $prefs(wcs,align,sky)"
    puts $file "set prefs(zoom) $prefs(zoom)"
    puts $file "set current(zoom) $prefs(zoom)"
    puts $file "set prefs(orient) $prefs(orient)"
    puts $file "set current(orient) $prefs(orient)"
    puts $file "set prefs(rotate) $prefs(rotate)"
    puts $file "set current(rotate) $prefs(rotate)"

    # Scale prefs
    puts $file ""
    puts $file "\# Scale prefs"
    global current
    puts $file "global current"
    global scale
    puts $file "global scale"
    puts $file "set prefs(scale) $prefs(scale)"
    puts $file "set scale(type) $prefs(scale)"
    puts $file "set prefs(scale,mode) $prefs(scale,mode)"
    puts $file "set scale(mode) $prefs(scale,mode)"
    puts $file "set prefs(scale,scope) $prefs(scale,scope)"
    puts $file "set scale(scope) $prefs(scale,scope)"
    puts $file "set prefs(scale,datasec) $prefs(scale,datasec)"
    puts $file "set scale(datasec) $prefs(scale,datasec)"

    global minmax
    puts $file "global minmax"
    puts $file "set prefs(minmax,mode) $prefs(minmax,mode)"
    puts $file "set minmax(mode) $prefs(minmax,mode)"
    puts $file "set prefs(minmax,sample) $prefs(minmax,sample)"
    puts $file "set minmax(sample) $prefs(minmax,sample)"

    # Color prefs
    puts $file ""
    puts $file "\# Color prefs"
    global colorbar
    puts $file "global colorbar"
    puts $file "set prefs(colorbar,map) $prefs(colorbar,map)"
    puts $file "set colorbar(map) $prefs(colorbar,map)"
    puts $file "set prefs(colorbar,invert) $prefs(colorbar,invert)"
    puts $file "set colorbar(invert) $prefs(colorbar,invert)"

    # Region prefs
    puts $file ""
    puts $file "\# Region prefs"
    global marker
    puts $file "global marker"
    puts $file "set prefs(marker,shape) \{$prefs(marker,shape)\}"
    puts $file "set marker(shape) \{$prefs(marker,shape)\}"
    puts $file "set prefs(marker,color) $prefs(marker,color)"
    puts $file "set marker(color) $prefs(marker,color)"
    puts $file "set prefs(marker,width) $prefs(marker,width)"
    puts $file "set marker(width) $prefs(marker,width)"

    puts $file "set prefs(marker,edit) $prefs(marker,edit)"
    puts $file "set marker(edit) $prefs(marker,edit)"
    puts $file "set prefs(marker,move) $prefs(marker,move)"
    puts $file "set marker(move) $prefs(marker,move)"
    puts $file "set prefs(marker,rotate) $prefs(marker,rotate)"
    puts $file "set marker(rotate) $prefs(marker,rotate)"
    puts $file "set prefs(marker,delete) $prefs(marker,delete)"
    puts $file "set marker(delete) $prefs(marker,delete)"
    puts $file "set prefs(marker,fixed) $prefs(marker,fixed)"
    puts $file "set marker(fixed) $prefs(marker,fixed)"
    puts $file "set prefs(marker,include) $prefs(marker,include)"
    puts $file "set marker(include) $prefs(marker,include)"
    puts $file "set prefs(marker,source) $prefs(marker,source)"
    puts $file "set marker(source) $prefs(marker,source)"
    puts $file "set prefs(marker,font) $prefs(marker,font)"
    puts $file "set marker(font) $prefs(marker,font)"
    puts $file "set prefs(marker,font,size) $prefs(marker,font,size)"
    puts $file "set marker(font,size) $prefs(marker,font,size)"
    puts $file "set prefs(marker,font,style) $prefs(marker,font,style)"
    puts $file "set marker(font,style) $prefs(marker,font,style)"

    puts $file "set prefs(marker,format) $prefs(marker,format)"
    puts $file "set marker(format) $prefs(marker,format)"
    puts $file "set prefs(marker,strip) $prefs(marker,strip)"
    puts $file "set marker(strip) $prefs(marker,strip)"
    puts $file "set prefs(marker,wcs) $prefs(marker,wcs)"
    puts $file "set marker(wcs) $prefs(marker,wcs)"
    puts $file "set prefs(marker,system) $prefs(marker,system)"
    puts $file "set marker(system) $prefs(marker,system)"
    puts $file "set prefs(marker,sky) $prefs(marker,sky)"
    puts $file "set marker(sky) $prefs(marker,sky)"
    puts $file "set prefs(marker,skyformat) $prefs(marker,skyformat)"
    puts $file "set marker(skyformat) $prefs(marker,skyformat)"

    puts $file "set marker(dialog,system) $marker(dialog,system)"
    puts $file "set marker(dialog,sky) $marker(dialog,sky)"
    puts $file "set marker(dialog,skyformat) $marker(dialog,skyformat)"
    puts $file "set marker(dialog,dist,system) $marker(dialog,dist,system)"
    puts $file "set marker(dialog,dist,format) $marker(dialog,dist,format)"

    puts $file "set marker(circle,radius) $marker(circle,radius)"
    puts $file "set marker(ellipse,radius1) $marker(ellipse,radius1)"
    puts $file "set marker(ellipse,radius2) $marker(ellipse,radius2)"
    puts $file "set marker(box,width) $marker(box,width)"
    puts $file "set marker(box,height) $marker(box,height)"
    puts $file "set marker(polygon,width) $marker(polygon,width)"
    puts $file "set marker(polygon,height) $marker(polygon,height)"
    puts $file "set marker(projection,thick) $marker(projection,thick)"
    puts $file "set marker(annulus,inner) $marker(annulus,inner)"
    puts $file "set marker(annulus,outer) $marker(annulus,outer)"
    puts $file "set marker(annulus,annuli) $marker(annulus,annuli)"
    puts $file "set marker(ellipseannulus,radius1) $marker(ellipseannulus,radius1)"
    puts $file "set marker(ellipseannulus,radius2) $marker(ellipseannulus,radius2)"
    puts $file "set marker(ellipseannulus,radius3) $marker(ellipseannulus,radius3)"
    puts $file "set marker(ellipseannulus,annuli) $marker(ellipseannulus,annuli)"
    puts $file "set marker(boxannulus,size1) $marker(boxannulus,size1)"
    puts $file "set marker(boxannulus,size2) $marker(boxannulus,size2)"
    puts $file "set marker(boxannulus,size3) $marker(boxannulus,size3)"
    puts $file "set marker(boxannulus,annuli) $marker(boxannulus,annuli)"
    puts $file "set marker(panda,inner) $marker(panda,inner)"
    puts $file "set marker(panda,outer) $marker(panda,outer)"
    puts $file "set marker(panda,annuli) $marker(panda,annuli)"
    puts $file "set marker(panda,ang1) $marker(panda,ang1)"
    puts $file "set marker(panda,ang2) $marker(panda,ang2)"
    puts $file "set marker(panda,angnum) $marker(panda,angnum)"

    # WCS prefs
    puts $file ""
    puts $file "\# wcs prefs"
    global wcs
    puts $file "global wcs"
    puts $file "set prefs(wcs,system) $prefs(wcs,system)"
    puts $file "set wcs(system) $prefs(wcs,system)"
    puts $file "set prefs(wcs,sky) $prefs(wcs,sky)"
    puts $file "set wcs(sky) $prefs(wcs,sky)"
    puts $file "set prefs(wcs,skyformat) $prefs(wcs,skyformat)"
    puts $file "set wcs(skyformat) $prefs(wcs,skyformat)"

    # Analysis prefs
    puts $file ""
    puts $file "\# Analysis prefs"
    global graphHorz
    puts $file "global graphHorz"
    puts $file "set graphHorz(grid) $graphHorz(grid)"
    puts $file "set graphHorz(log) $graphHorz(log)"
    global graphVert
    puts $file "global graphVert"
    puts $file "set graphVert(grid) $graphVert(grid)"
    puts $file "set graphVert(log) $graphVert(log)"
    global contour
    puts $file "global contour"
    puts $file "set prefs(contour,method) $prefs(contour,method)"
    puts $file "set contour(method) $prefs(contour,method)"
    puts $file "set prefs(contour,color) $prefs(contour,color)"
    puts $file "set contour(color) $prefs(contour,color)"
    puts $file "set prefs(contour,width) $prefs(contour,width)"
    puts $file "set contour(width) $prefs(contour,width)"
    global nsvr
    puts $file "global nsvr"
    puts $file "set nsvr(server) \{$nsvr(server)\}"
    global dss
    puts $file "global dss"
    puts $file "set dss(server) \{$dss(server)\}"
    global hv
    puts $file "global hv"
    foreach n {1 2 3 4} {
	puts $file "set hv(archive,menu,$n) \{$hv(archive,menu,$n)\}"
	puts $file "set hv(archive,url,$n) \{$hv(archive,url,$n)\}"
    }
    global vo
    puts $file "global vo"
    puts $file "set vo(server) \{$vo(server)\}"
    puts $file "set prefs(vo,hv) $prefs(vo,hv)"
    puts $file "set vo(hv) $prefs(vo,hv)"

    puts $file "set prefs(analysis,user) \{$prefs(analysis,user)\}"
    puts $file "set ds9(analysis,user)  \{$prefs(analysis,user)\}"
    puts $file "set prefs(analysis,user2)  \{$prefs(analysis,user2)\}"
    puts $file "set ds9(analysis,user2)  \{$prefs(analysis,user2)\}"
    puts $file "set prefs(analysis,user3)  \{$prefs(analysis,user3)\}"
    puts $file "set ds9(analysis,user3)  \{$prefs(analysis,user3)\}"
    puts $file "set prefs(analysis,user4)  \{$prefs(analysis,user4)\}"
    puts $file "set ds9(analysis,user4)  \{$prefs(analysis,user4)\}"

    global analysis
    puts $file "global analysis"
    puts $file "set prefs(analysis,log) $prefs(analysis,log)"
    puts $file "set analysis(log) $prefs(analysis,log)"

    puts $file ""
    puts $file "\# Analysis Plot prefs"
    puts $file "set prefs(ap,grid) $prefs(ap,grid)"
    puts $file "set prefs(ap,grid,log) $prefs(ap,grid,log)"

    puts $file "set prefs(ap,discrete) $prefs(ap,discrete)"
    puts $file "set prefs(ap,discrete,symbol) $prefs(ap,discrete,symbol)"
    puts $file "set prefs(ap,discrete,color) $prefs(ap,discrete,color)"

    puts $file "set prefs(ap,linear) $prefs(ap,linear)"
    puts $file "set prefs(ap,linear,width) $prefs(ap,linear,width)"
    puts $file "set prefs(ap,linear,color) $prefs(ap,linear,color)"
    puts $file "set prefs(ap,linear,dash) $prefs(ap,linear,dash)"

    puts $file "set prefs(ap,step) $prefs(ap,step)"
    puts $file "set prefs(ap,step,width) $prefs(ap,step,width)"
    puts $file "set prefs(ap,step,color) $prefs(ap,step,color)"
    puts $file "set prefs(ap,step,dash) $prefs(ap,step,dash)"

    puts $file "set prefs(ap,quadratic) $prefs(ap,quadratic)"
    puts $file "set prefs(ap,quadratic,width) $prefs(ap,quadratic,width)"
    puts $file "set prefs(ap,quadratic,color) $prefs(ap,quadratic,color)"
    puts $file "set prefs(ap,quadratic,dash) $prefs(ap,quadratic,dash)"

    puts $file "set prefs(ap,error,width) $prefs(ap,error,width)"
    puts $file "set prefs(ap,error,color) $prefs(ap,error,color)"
    puts $file "set prefs(ap,error,style) $prefs(ap,error,style)"

    puts $file "set prefs(ap,titleFont) $prefs(ap,titleFont)"
    puts $file "set prefs(ap,titleSize) $prefs(ap,titleSize)"
    puts $file "set prefs(ap,titleStyle) $prefs(ap,titleStyle)"

    puts $file "set prefs(ap,textlabFont) $prefs(ap,textlabFont)"
    puts $file "set prefs(ap,textlabSize) $prefs(ap,textlabSize)"
    puts $file "set prefs(ap,textlabStyle) $prefs(ap,textlabStyle)"

    puts $file "set prefs(ap,numlabFont) $prefs(ap,numlabFont)"
    puts $file "set prefs(ap,numlabSize) $prefs(ap,numlabSize)"
    puts $file "set prefs(ap,numlabStyle) $prefs(ap,numlabStyle)"

    # Language prefs
#    puts $file ""
#    puts $file "\# Language prefs"
#    puts $file "set ds9(language) $ds9(language)"

    # Background Color prefs
    puts $file ""
    puts $file "\# Background Color prefs"
    puts $file "set ds9(bg,color) $ds9(bg,color)"

    # Blank/Inf/NaN Color prefs
    puts $file ""
    puts $file "\# Blank/Inf/NaN Color prefs"
    puts $file "set ds9(nan,color) $ds9(nan,color)"

    # View prefs
    puts $file ""
    puts $file "\# View prefs"
    global info
    puts $file "global info"
    puts $file "set info(view) $info(view)"
    global panner
    puts $file "global panner"
    puts $file "set panner(view) $panner(view)"
    global magnifier
    puts $file "global magnifier"
    puts $file "set magnifier(view) $magnifier(view)"
    global buttons
    puts $file "global buttons"
    puts $file "set buttons(view) $buttons(view)"
    global colorbar
    puts $file "global colorbar"
    puts $file "set colorbar(view) $colorbar(view)"

    # Info Panel prefs
    puts $file ""
    puts $file "\# Infomation Panel prefs"
    global info
    puts $file "global info"
    puts $file "set info(filename) $info(filename)"
    puts $file "set info(object) $info(object)"
    puts $file "set info(minmax) $info(minmax)"

    foreach l {{} A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	puts $file "set info(wcs$l) $info(wcs$l)"
    }

    puts $file "set info(detector) $info(detector)"
    puts $file "set info(amplifier) $info(amplifier)"
    puts $file "set info(physical) $info(physical)"
    puts $file "set info(image) $info(image)"
    puts $file "set info(frame) $info(frame)"

    # Default Font prefs
    puts $file ""
    puts $file "\# Font prefs"
    puts $file "set prefs(font) $prefs(font)"
    puts $file "set prefs(font,size) $prefs(font,size)"
    puts $file "set prefs(font,style) $prefs(font,style)"
    puts $file "if \{\$prefs\(font\) \!\= \"default\"\} \{"
    puts $file "option add *font \{$prefs(font) $prefs(font,size) $prefs(font,style)\}"
    puts $file "\}"

    # Mosaic prefs
    puts $file ""
    puts $file "\# Mosaic prefs"
    puts $file "set ds9(mosaic,fast) $ds9(mosaic,fast)"

    # Panner prefs
    puts $file ""
    puts $file "\# Panner prefs"
    global panner
    puts $file "global panner"
    puts $file "set panner(compass,image) $panner(compass,image)"
    puts $file "set panner(compass,wcs) $panner(compass,wcs)"
    puts $file "set panner(compass,wcs,system) $panner(compass,wcs,system)"
    puts $file "set panner(compass,wcs,sky) $panner(compass,wcs,sky)"

    # Magnifier prefs
    puts $file ""
    puts $file "\# Magnifier prefs"
    global magnifier
    puts $file "global magnifier"
    puts $file "set magnifier(region) $magnifier(region)"
    puts $file "set magnifier(cursor) $magnifier(cursor)"
    puts $file "set magnifier(zoom) $magnifier(zoom)"

    # Truecolor Colorbar prefs
    puts $file ""
    puts $file "\# Truecolor Colorbar prefs"
    global colorbar
    puts $file "global colorbar"
    puts $file "set colorbar(area) $colorbar(area)"
    puts $file "set colorbar(mode) $colorbar(mode)"

    # Dialog prefs
    puts $file ""
    puts $file "\# Dialog prefs"
    puts $file "global ds9"
    puts $file "set ds9(dialog) $ds9(dialog)"

    # PanZoom prefs
    puts $file ""
    puts $file "\# PanZoom prefs"
    global panzoom
    puts $file "global panzoom"
    puts $file "set panzoom(mode) $panzoom(mode)"

    # Print Coordinates prefs
    puts $file ""
    puts $file "\# Print Coordinates prefs"
    global coord
    puts $file "global coord"
    puts $file "set coord(value) $coord(value)"
    puts $file "set coord(image) $coord(image)"
    puts $file "set coord(physical) $coord(physical)"
    puts $file "set coord(amplifier) $coord(amplifier)"
    puts $file "set coord(detector) $coord(detector)"
    foreach l {{} A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	puts $file "set coord(wcs$l) $coord(wcs$l)"
    }
    puts $file "set coord(sky) $coord(sky)"
    puts $file "set coord(skyformat) $coord(skyformat)"

    # Examine prefs
    puts $file ""
    puts $file "\# Examine prefs"
    global examine
    puts $file "global examine"
    puts $file "set examine(mode) $examine(mode)"
    puts $file "set examine(zoom) $examine(zoom)"

    # Misc prefs
    puts $file ""
    puts $file "\# Misc prefs"
    global menu
    puts $file "global menu"
    puts $file "set ds9(tmpdir) $ds9(tmpdir)"
    puts $file "set ds9(cursor) $ds9(cursor)"
    puts $file "set ds9(automarker) $ds9(automarker)"
    puts $file "set ds9(amp,det) $ds9(amp,det)"
    puts $file "set ds9(xpa) $ds9(xpa)"

    # HTTP prefs
    puts $file ""
    puts $file "\# HTTP prefs"
    global http
    puts $file "global http"
    puts $file "set http(proxy) $http(proxy)"
    puts $file "set http(proxy,host) $http(proxy,host)"
    puts $file "set http(proxy,port) $http(proxy,port)"
    puts $file "set http(auth) $http(auth)"
    puts $file "set http(auth,user) $http(auth,user)"
    puts $file "set http(auth,passwd) $http(auth,passwd)"

    # and close
    close $file

    # make sure old prefs files are removed
    catch {file delete -force $prefs(file,alt)}
}

proc ProcessPrefsCmd {varname iname} {
    upvar $varname var
    upvar $iname i

    global prefs
    global ds9
    global wcs

    switch -- [string tolower [lindex $var $i]] {
	mosaicfast {
	    incr i
	    set ds9(mosaic,fast) [FromYesNo [lindex $var $i]]
	    ChangeMosaicFast
	}
	bgcolor {
	    incr i
	    set ds9(bg,color) [lindex $var $i]
	    ChangeBackgroundColor
	}
	nancolor {
	    incr i
	    set ds9(nan,color) [lindex $var $i]
	    ChangeNaNColor
	}
    }
}
