/* callbacks.c - Callback functions for interface as generated by Glade
 *
 * Copyright (C) 2000  Jochen Voss.  */

static const  char  rcsid[] = "$Id: callbacks.c,v 1.17 2002/01/09 20:42:03 voss Rel $";

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdlib.h>

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "sandcommon.h"
#include "sand-window.h"


void
on_about2_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_widget_show (create_about1 ());
}


void
on_custom_entry_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget *entry = lookup_widget (GTK_WIDGET(editable), "bxxx");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (entry), TRUE);
}


void
apply_settings                         (GnomePropertyBox *gnomepropertybox,
                                        gint             page,
                                        gpointer         user_data)
{
  struct timer *timer;

  timer = gtk_object_get_data (GTK_OBJECT(gnomepropertybox), "sanduhr-timer");
  g_assert (timer);

  properties_to_timer (GTK_WIDGET (gnomepropertybox), page, timer);
}


void
settings_changed                       (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget *settings = lookup_widget (GTK_WIDGET(editable), "properties");
  gnome_property_box_changed (GNOME_PROPERTY_BOX (settings));
}


void
on_snd_entry_changed                   (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget *entry = lookup_widget (GTK_WIDGET(editable), "snd_alarm");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (entry), TRUE);
}


void
on_cmd_entry_changed                   (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget *entry = lookup_widget (GTK_WIDGET(editable), "cmd_alarm");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (entry), TRUE);
}


void
on_corba_entry_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget *entry = lookup_widget (GTK_WIDGET(editable), "corba_alarm");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (entry), TRUE);
}


void
on_settings_help                       (GnomePropertyBox *gnomepropertybox,
                                        gint             page,
                                        gpointer         user_data)
{
  GnomeHelpMenuEntry timespec_help = { "sanduhr", "usage.html#TIMESPEC" };
  GnomeHelpMenuEntry preferences_help = { "sanduhr", "prefs.html" };

  switch (page) {
  case 0:
    gnome_help_display (NULL, &timespec_help);
    break;
  default:
    gnome_help_display (NULL, &preferences_help);
    break;
  }
}

void
on_init_help_button_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  GnomeHelpMenuEntry timespec_help = { "sanduhr", "usage.html#TIMESPEC" };

  gnome_help_display (NULL, &timespec_help);
  gtk_signal_emit_stop_by_name (GTK_OBJECT (button), "clicked");
}

void
on_properties1_activate               (GtkMenuItem     *menuitem,
				       gpointer         user_data)
{
  GtkWidget *settings;
  struct timer *timer;

  settings = create_properties ();
  timer = user_data;
  g_assert (timer);
  
  gtk_object_set_data (GTK_OBJECT (settings), "sanduhr-timer", timer);
  gnome_dialog_set_parent (GNOME_DIALOG (settings),
			   GTK_WINDOW (timer->window));

  timer->prop_windows = g_slist_prepend (timer->prop_windows, settings);
  prepare_properties_dialog (settings, timer);
  
  gtk_widget_show (settings);
}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_main_quit ();
}


void
on_preferences1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *dialog;

  dialog = create_preferences ();
  prepare_preferences_dialog (dialog);

  main_loop_ref ();
  gtk_signal_connect (GTK_OBJECT (dialog),
		      "hide",
		      GTK_SIGNAL_FUNC (window_destroy_cb),
		      NULL);
  
  gtk_widget_show (dialog);
}

gint
on_settings_close                      (GnomeDialog     *gnomedialog,
                                        gpointer         user_data)
{
  struct timer *timer;

  timer = gtk_object_get_data (GTK_OBJECT(gnomedialog), "sanduhr-timer");
  g_assert (timer);

  timer->prop_windows = g_slist_remove (timer->prop_windows, gnomedialog);

  return  FALSE;
}


void
pref_changed                           (GtkWidget       *control,
                                        gpointer         user_data)
{
  GtkWidget *pref = lookup_widget (control, "preferences");
  gnome_property_box_changed (GNOME_PROPERTY_BOX (pref));
}


void
on_preferences_apply                   (GnomePropertyBox *gnomepropertybox,
                                        gint             page,
                                        gpointer         user_data)
{
  decode_preferences (GTK_WIDGET (gnomepropertybox), page);
}


void
on_preferences_help                    (GnomePropertyBox *gnomepropertybox,
                                        gint             page,
                                        gpointer         user_data)
{
  GnomeHelpMenuEntry preferences_help = { "sanduhr", "prefs.html" };
  gnome_help_display (NULL, &preferences_help);
}


void
on_pref_file_changed                   (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget *entry = lookup_widget (GTK_WIDGET(editable), "snd_pref");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (entry), TRUE);
}


void
on_pref_cmd_changed                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget *entry = lookup_widget (GTK_WIDGET(editable), "cmd_pref");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (entry), TRUE);
}

void
on_color_pref_color_set                (GnomeColorPicker *gnomecolorpicker,
                                        guint            arg1,
                                        guint            arg2,
                                        guint            arg3,
                                        guint            arg4,
                                        gpointer         user_data)
{
  GtkWidget *pref = lookup_widget (GTK_WIDGET (gnomecolorpicker),
				   "preferences");
  gnome_property_box_changed (GNOME_PROPERTY_BOX (pref));
}
