
#ifndef SH_TIGER_H
#define SH_TIGER_H 

#include "config_xor.h"
#include "slib.h"
#include "samhain.h"

typedef enum {
  TIGER_FILE,
  TIGER_FD,
  TIGER_DATA
} TigerType;

extern SL_TICKET tiger_fd;

/* the checksum function
 */
/*@owned@*/ char * sh_tiger_hash (char * filename, TigerType what, 
				  unsigned long Length);

/* NEW Thu Oct 18 19:59:08 CEST 2001
 */
int sh_tiger_hashtype (char * c);
char * sh_tiger_generic_hash (char * filename, TigerType what, 
			      unsigned long Length, int timeout);

UINT32 * sh_tiger_hash_uint32 (char * filename, 
			       TigerType what, 
			       unsigned long Length);

/* get the type of hash function used
 */
int sh_tiger_gethashtype ();

/* GnuPG-like format
 */
/*@owned@*/ char * sh_tiger_hash_gpg (char * filename, TigerType what, 
			  unsigned long Length);
#endif
