/* LocaleInformation_af.java --
   Copyright (C) 2005  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_af extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "ZAR";

  private static final String currenciesDisplayNameValues = "Rand";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "\u00A6");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "ZAR";

  private static final String currenciesSymbolValues = "R";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "\u00A6");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "Jan",
    "Feb",
    "Mar",
    "Apr",
    "Mei",
    "Jun",
    "Jul",
    "Aug",
    "Sep",
    "Okt",
    "Nov",
    "Des",
    null,
  };

  private static final String[] months = {
    "Januarie",
    "Februarie",
    "Maart",
    "April",
    "Mei",
    "Junie",
    "Julie",
    "Augustus",
    "September",
    "Oktober",
    "November",
    "Desember",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "So",
    "Ma",
    "Di",
    "Wo",
    "Do",
    "Vr",
    "Sa",
  };

  private static final String[] weekdays = {
    null,
    "Sondag",
    "Maandag",
    "Dinsdag",
    "Woensdag",
    "Donderdag",
    "Vrydag",
    "Saterdag",
  };

  private static final String[] eras = {
    "v.C.",
    "n.C.",
  };

  private static final String[] ampms = {
    "vm.",
    "nm.",
  };

  private static final String territoriesKeys = "AU\u00A6TD\u00A6AT\u00A6GW\u00A6AR\u00A6MZ\u00A6MY\u00A6MX\u00A6GR\u00A6AM\u00A6ZA\u00A6MV\u00A6GQ\u00A6AL\u00A6SY\u00A6GN\u00A6MR\u00A6GM\u00A6SV\u00A6AG\u00A6AF\u00A6ST\u00A6AE\u00A6MN\u00A6YU\u00A6MK\u00A6SO\u00A6GE\u00A6MH\u00A6MG\u00A6GB\u00A6SK\u00A6GA\u00A6SI\u00A6SG\u00A6MA\u00A6SE\u00A6SD\u00A6SC\u00A6SB\u00A6SA\u00A6YE\u00A6LY\u00A6FR\u00A6LV\u00A6LU\u00A6LT\u00A6LR\u00A6FM\u00A6RU\u00A6FJ\u00A6RO\u00A6LB\u00A6KZ\u00A6ET\u00A6ES\u00A6KW\u00A6KR\u00A6KP\u00A6KN\u00A6KM\u00A6EH\u00A6EG\u00A6EE\u00A6KH\u00A6KG\u00A6KE\u00A6DZ\u00A6QA\u00A6DO\u00A6DK\u00A6JO\u00A6DJ\u00A6JM\u00A6DE\u00A6PL\u00A6VN\u00A6PH\u00A6PG\u00A6CZ\u00A6CY\u00A6CV\u00A6CU\u00A6VC\u00A6VA\u00A6IT\u00A6IS\u00A6CN\u00A6CM\u00A6IQ\u00A6CL\u00A6UZ\u00A6IN\u00A6CI\u00A6CH\u00A6CG\u00A6CF\u00A6US\u00A6CA\u00A6IE\u00A6ID\u00A6BY\u00A6BT\u00A6BR\u00A6UA\u00A6NZ\u00A6HU\u00A6HT\u00A6BO\u00A6BN\u00A6HR\u00A6TZ\u00A6NR\u00A6BH\u00A6BG\u00A6BF\u00A6TT\u00A6NO\u00A6BE\u00A6BD\u00A6TR\u00A6NL\u00A6BA\u00A6TN\u00A6TM\u00A6TJ\u00A6NE\u00A6AZ\u00A6ZM\u00A6NA";

  private static final String territoriesValues = "Australi\u00eb\u00A6Tsjaad\u00A6Oostenryk\u00A6Guinee-Bissau\u00A6Argentini\u00eb\u00A6Mosambiek\u00A6Maleisi\u00eb\u00A6Meksiko\u00A6Griekeland\u00A6Armeni\u00eb\u00A6Suid-Afrika\u00A6Maldive\u00A6Ekwatoriaal-Guinee\u00A6Albani\u00eb\u00A6Siri\u00eb\u00A6Guinee\u00A6Mouritani\u00eb\u00A6Gambi\u00eb\u00A6Salvador\u00A6Antigua en Barbuda\u00A6Afganistan\u00A6Sao Tome en Principe\u00A6Verenigde Arabiese Emirate\u00A6Mongoli\u00eb\u00A6Serwi\u00eb\u00A6Macedoni\u00eb\u00A6Somali\u00eb\u00A6Georgi\u00eb\u00A6Marshall-eilande\u00A6Madagaskar\u00A6Groot-Brittanje\u00A6Slowakye\u00A6Gaboen\u00A6Sloweni\u00eb\u00A6Singapoer\u00A6Marokko\u00A6Swede\u00A6Soedan\u00A6Seychelle\u00A6Solomon Eilande\u00A6Saoedi-Arabi\u00eb\u00A6Jemen\u00A6Libi\u00eb\u00A6Frankryk\u00A6Letland\u00A6Luxemburg\u00A6Litaue\u00A6Liberi\u00eb\u00A6Mikronesi\u00eb\u00A6Rusland\u00A6Fidji\u00A6Roemeni\u00eb\u00A6Libanon\u00A6Kasakstan\u00A6Ethiopi\u00eb\u00A6Spanje\u00A6Koeweit\u00A6Suid-Korea\u00A6Noord-Korea\u00A6Saint Kitts en Nevis\u00A6Comore\u00A6Wes-Sahara\u00A6Egipte\u00A6Estland\u00A6Kambodja\u00A6Kirgisi\u00eb\u00A6Kenia\u00A6Algeri\u00eb\u00A6Katar\u00A6Dominikaanse Republiek\u00A6Denemarke\u00A6Jordani\u00eb\u00A6Djiboeti\u00A6Jamaika\u00A6Duitsland\u00A6Pole\u00A6Vi\u00ebtnam\u00A6Filippyne\u00A6Papoea Nieu-Guinee\u00A6Tjeggiese Republiek\u00A6Ciprus\u00A6Kaap Verde\u00A6Kuba\u00A6Saint Vincent en die Grenadine\u00A6Vatikaan\u00A6Itali\u00eb\u00A6Ysland\u00A6Sjina\u00A6Kameroen\u00A6Irak\u00A6Chili\u00A6Oesbekistan\u00A6Indi\u00eb\u00A6Ivoorkus\u00A6Switserland\u00A6Kongo\u00A6Sentraal-Afrikaanse Republiek\u00A6Verenigde State van Amerika\u00A6Kanada\u00A6Ierland\u00A6Indonesi\u00eb\u00A6Wit-Rusland\u00A6Bhoetan\u00A6Brasili\u00eb\u00A6Oekraine\u00A6Nieu-Seeland\u00A6Hongarye\u00A6Ha\u00efti\u00A6Bolivi\u00eb\u00A6Broenei\u00A6Kroasi\u00eb\u00A6Tanzani\u00eb\u00A6Naoeroe\u00A6Bahrein\u00A6Bulgarye\u00A6Boerkina Fasso\u00A6Trinidad en Tobago\u00A6Noorwe\u00eb\u00A6Belgi\u00eb\u00A6Bangladesj\u00A6Turkye\u00A6Nederland\u00A6Bosni\u00eb en Herzegowina\u00A6Tunisi\u00eb\u00A6Turkmeni\u00eb\u00A6Tadjikistan\u00A6Nigeri\u00eb\u00A6Aserbeidjan\u00A6Zambi\u00eb\u00A6Namibi\u00eb";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(territoriesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "af";

  private static final String languagesValues = "Afrikaans";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(languagesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "\u00a0" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
