/*
*  Rubrica
*  file: sort.c
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gnome.h>
#include <gconf/gconf-client.h>

#include "rubrica.h"
#include "prefer.h"
#include "card.h"
#include "sort.h"


void rubrica_sort_init(void)
{
  GConfClient *client;

  client = gconf_client_get_default();  

  gconf_client_notify_add(client, RUBRICA_KEY_SORT_TYPE, 
			  rubrica_sort_notify_sort_type_changes,
			  NULL, NULL, NULL);

  gconf_client_notify_add(client, RUBRICA_KEY_SORT_DIRECTION, 
			  rubrica_sort_notify_sort_direction_changes,
			  NULL, NULL, NULL);
  g_object_unref(client);
}


RubricaSortType rubrica_sort_get_sort_type(void)
{
  return rubrica_preferences_get_sort_type();
}


RubricaSortDirectionType rubrica_sort_get_sort_direction(void)
{
  return rubrica_preferences_get_sort_direction();
}


void rubrica_sort_set_sort_type(RubricaSortType type)
{
  GConfClient *client;

  client = gconf_client_get_default();  
  gconf_client_set_int(client, RUBRICA_KEY_SORT_TYPE, type, NULL);;
  g_object_unref(client);
}


void rubrica_sort_set_sort_direction(RubricaSortDirectionType direction)
{
  GConfClient *client;

  client = gconf_client_get_default();  
  gconf_client_set_int(client, RUBRICA_KEY_SORT_DIRECTION, direction, NULL);
  g_object_unref(client);
}

void rubrica_sort_notify_sort_type_changes(GConfClient *client, guint cnxn_id, 
					   GConfEntry *entry, gpointer data)
{
  Rubrica *rubrica;
  GtkWidget *view;
  GtkTreeModel *model;  
  RubricaSortType type;
  RubricaSortDirectionType sorting;

  rubrica = rubrica_get_current_rubrica();
  view = rubrica_get_view(rubrica);
  model = gtk_tree_view_get_model(GTK_TREE_VIEW(view));
  type = gconf_value_get_int(entry->value);
 
  g_return_if_fail(GTK_IS_TREE_MODEL(model));
  g_return_if_fail(GTK_IS_TREE_VIEW(view));

  if (rubrica_sort_get_sort_direction() == SORT_ASCENDING)
    sorting = GTK_SORT_ASCENDING;
  else
    sorting = GTK_SORT_DESCENDING;

  if (type == SORT_ALPHA)
    gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(model), 
					 CARD_COLUMN, sorting);
  else
    gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(model), 
					 RUBRICA_COLUMN, sorting);    
}

void 
rubrica_sort_notify_sort_direction_changes(GConfClient *client, guint cnxn_id, 
					   GConfEntry *entry, gpointer data)
{
  Rubrica *rubrica;
  GtkWidget *view;
  GtkTreeModel *model;
  RubricaSortType sort;
  RubricaSortDirectionType type;

  rubrica = rubrica_get_current_rubrica();
  view = rubrica_get_view(rubrica);
  model = gtk_tree_view_get_model(GTK_TREE_VIEW(view));
  type = gconf_value_get_int(entry->value);

  g_return_if_fail(GTK_IS_TREE_MODEL(model));
  g_return_if_fail(GTK_IS_TREE_VIEW(view));

  if (rubrica_sort_get_sort_type == SORT_ALPHA)
    sort = CARD_COLUMN;
  else
    sort = RUBRICA_COLUMN;

  if (gtk_tree_sortable_get_sort_column_id(GTK_TREE_SORTABLE(model), 
					   NULL, NULL))
    {
      if (type == SORT_ASCENDING)
	gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(model), sort, 
					     GTK_SORT_ASCENDING);
      else
	gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(model), sort, 
					     GTK_SORT_DESCENDING);
    }
  g_object_unref(client);
}



gint  rubrica_sort_alfa(GtkTreeModel *model, GtkTreeIter *iter_a, 
			GtkTreeIter *iter_b, gpointer data)
{
  gchar *str_a, *str_b;

  g_return_val_if_fail(GTK_IS_TREE_MODEL(model), 0);

  gtk_tree_model_get(model, iter_a, GPOINTER_TO_INT(data), &str_a, -1);
  gtk_tree_model_get(model, iter_b, GPOINTER_TO_INT(data), &str_b, -1);

  return strcmp(str_a, str_b);  
}


gint  rubrica_sort_date(GtkTreeModel *model, GtkTreeIter *iter_a, 
			GtkTreeIter *iter_b, gpointer data)
{
  RubricaItem *item_a, *item_b;
  time_t time_a, time_b;

  g_return_val_if_fail(GTK_IS_TREE_MODEL(model), 0);

  gtk_tree_model_get(model, iter_a, GPOINTER_TO_INT(data), &item_a, -1);
  gtk_tree_model_get(model, iter_b, GPOINTER_TO_INT(data), &item_b, -1);

  if (rubrica_sort_get_sort_type() == SORT_CREATION_DATE)
    {
      time_a = item_a->created;
      time_b = item_b->created;
    }
  else  /* SORT_MODIFICATION_DATE */
    {
      time_a = item_a->last_change;
      time_b = item_b->last_change;      
    }
  
  if (time_a > time_b)
    return 1;
  if (time_a < time_b)
    return -1;
  
  return 0;
}
