/*
*  program name: Rubrica <http://digilander.iol.it/nfragale/download.html>
*  file: card.h
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef __RUBRICA_CARD_H
#define __RUBRICA_CARD_H

#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include "rubrica.h"


enum
  {
    PIXMAP_COLUMN,
    CARD_COLUMN,
    FIRST_NAME_COLUMN,
    LAST_NAME_COLUMN,
    PROFESSION_COLUMN,
    CITY_COLUMN,
    COUNTRY_COLUMN,
    WEB_CARD_COLUMN,
    EMAIL_CARD_COLUMN,
    TELEPHONE_COLUMN,
    COMPANY_COLUMN,
    ASSIGMENT_COLUMN,
    CATEGORIES_COLUMN,
    RUBRICA_COLUMN,
    COLUMNS
  };



GtkWidget* rubrica_card_get_notebook(void);
gint rubrica_card_get_current_notebook_page(void);
GtkWidget* rubrica_card_get_nth_parent(gint page);

GtkTreeView *rubrica_card_get_view(GtkWidget *child);
GtkTreeView *rubrica_card_get_current_view(void);
void rubrica_card_set_view(GtkWidget *view);

GtkWidget *rubrica_card_get_current_child(void);
gint rubrica_card_get_pages(void);
void rubrica_card_update_tab_name(GtkWidget *child, gchar *str);

Rubrica *rubrica_card_get_rubrica_from_view(GtkTreeView *view);
RubricaItem* rubrica_card_get_nth_item(GtkTreeView *view, gint n);

GtkWidget* rubrica_card_interface_creation(RubricaInfoChild *info);
GtkTreeModel* rubrica_card_create_model(void);
GtkWidget* rubrica_card_new_view(GtkTreeModel *model);
void rubrica_card_add_columns(GtkTreeView *view);
void rubrica_card_set_column_attributes(GConfClient *client, GtkTreeView *view,
					gchar *key, gint col);

gint rubrica_card_add_page_view(gchar *filename);
void rubrica_card_set_tab_name(gchar *name);
void rubrica_card_append_page(GtkWidget *child, GtkWidget *label);
void rubrica_card_remove_page(gint page);

void rubrica_card_append_item(Rubrica *rubrica, RubricaItem *r);
void rubrica_card_insert_item(Rubrica *rubrica, RubricaItem *r, gint index);
void rubrica_card_modify_item(Rubrica *rubrica, RubricaItem *r, gint index);
gboolean rubrica_card_remove_selected_item(Rubrica *rubrica);
gboolean rubrica_card_remove_last_item(Rubrica *rubrica);
gboolean rubrica_card_remove_nth_item(Rubrica *rubrica, gint n);

gboolean rubrica_card_free_memory(GtkTreeModel *model, GtkTreePath *path, 
				  GtkTreeIter *iter, gpointer data);

RubricaItem *rubrica_card_item_cut(Rubrica *rubrica);
RubricaItem *rubrica_card_item_copy(Rubrica *rubrica);
RubricaItem *rubrica_card_clone_item(RubricaItem *item);


void rubrica_card_row_selected(GtkTreeSelection *select, gpointer data);
void rubrica_card_row_activated(GtkTreeView *tree_view, GtkTreePath *path,
				GtkTreeViewColumn *column);

gint rubrica_card_popup_call(GtkWidget *widget, GdkEvent *event);
void rubrica_card_detach_menu(GtkWidget *attach_widget, GtkMenu *menu);

#endif
