
// -*-objc-*-

#import "RSSReaderRemWindowDelegate.h"

@implementation RSSReaderRemWindowDelegate

-(void) dealloc
{
  RELEASE(window);
  RELEASE(feed);
}

// no retains, no releases
-(void) setWindow: (NSWindow*) win
{
  window = win;
}

-(void) setFeed: (RSSFeed*) rssfeed
{
  RELEASE(feed);
  feed = RETAIN(rssfeed);
#ifdef DEBUG
  NSLog(@"RSSReaderRemWindowDelegate: setFeed: %@ (rc=%d)",
	[feed description], [feed retainCount]);
#endif
}

// button delegates
-(void) okayClicked: (id) sender
{
  NSLog(@"should delete %@", [feed description]);
  
  [[[NSApp delegate] RSSFeeds] removeFeed: feed];
  
  /*
  RSSFeedList* feeds;
  RSSFeed* feed;
  
  NSLog(@"Adding feed %@ with url %@",
	[nameField stringValue], [urlField stringValue] );
  
  feeds = [[NSApp delegate] RSSFeeds];
  
  feed = [ [ RSSFeed alloc ]
	   initWithFetcher:
	     [ [ HTTPFetcher alloc]
	       initWithURL: [urlField stringValue] ] ];
  
  
  if (feed == nil)
    {
      NSLog(@"Error while initializing feed.");
    }
  else if ([feed fetch])
    {
      NSLog(@"Error when getting feed...");
    }
  else
    {
      NSLog(@"adding feed %@ to %@", [feed description], [feeds description]);
      [feeds addFeed: feed];
      NSLog(@"feed added.");
    }
  */
  [[NSApp delegate] reloadTable];
  NSLog(@"table rebuilt.");
  [window close];
}

-(void) cancelClicked: (id) sender
{
  [window close];
}

@end

