#include "sub_process.h"

#include "../../common.h"
#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <unistd.h>
#include <csignal>
#include <sys/types.h>
#include <sys/wait.h>
using namespace std;

SubProcess::SubProcess(const string& cmd)
        : pid(0),
          terminated(false)
{
        /* some of this code is from tview by Andrew Tridgell tridge@samba.anu.edu.au */

	int fd1[2], fd2[2];
	if (pipe(fd1) || pipe(fd2)) {
	    	cerr << "Error creating Pipes" << endl;
		close(fd1[0]);
		close(fd1[1]);
		close(fd2[0]);
		close(fd2[1]);
		return;
	}

	pid = fork();

	if (pid) {
                // parent process
	    	fd_from = fd1[0];
		fd_to = fd2[1];
		close(fd1[1]);
		close(fd2[0]);
	} else {
	    	// child process
	    	close(0);
		close(1);

		if (dup(fd2[0]) != 0 || dup(fd1[1]) != 1) {
		    	cerr << "Error generating Pipes" << endl;
		}
		close(fd1[0]);
		close(fd1[1]);
		close(fd2[0]);
		close(fd2[1]);
                system(cmd.c_str());
                _exit(0);
	}
        rpdbgmsg("subprocess created.  pid = " << pid);
	return;
}
        
SubProcess::~SubProcess()
{
    	if (pid) {
	    	close(fd_from);
		close(fd_to);
                if (running()) {
                        kill(pid,SIGINT);
                        kill(pid,SIGINT);
                }
                if (running()) {
                        kill(pid,SIGKILL);
                        kill(pid,SIGKILL);
                }
                if (running())
                        cerr << "failed to terminate child process " << pid << endl;
                rpdbgmsg("subprocess destroyed.  pid = " << pid);
	}
}

bool SubProcess::running()
{
        if (terminated || !pid)
                return false;
        if (waitpid(pid, 0, WNOHANG) > 0) {
                terminated = true;
                return false;
        }
        return true;
}
