#ifndef GRAPH_H
#define GRAPH_H

#include "../../module.h"
#include "../../rootwindow.h"
#include "../../drawing_area.h"

#include <vector>
using namespace std;

typedef unsigned long Pixel;

class Graph : public Module, public DrawingArea
{
public:
        Graph();
        ~Graph();
        void outputReceived(const DataSetMap& output);
        
        string getName() {
                return "Graph";
        }
                        
        virtual const DataSetMap& get_module_info() {
                return get_module_info_instance();
        }
        static const DataSetMap &get_module_info_instance();

        static void destroy_module_info() {
                if (moduleInfo)
                        delete moduleInfo;
                moduleInfo = 0;
        }                
        void service();
private:
        static DataSetMap* moduleInfo;
                        
private:
        Pixel getColour(const string& colourName);
        void setSize(int newLength, int newWidth);
        void setPosition(int newx, int newy);
        double getAutoscale();
        
        void redraw(XExposeEvent *ev);
        bool update_pixmap();

        int loopCount;
        int displayallow;

        Display* disp;
        
        vector<string> sources;
        vector<Pixel> colours;
        bool autoscale;

        bool knownUpdateKey;
                
        vector<vector<int> > values;

        int max_num_data;

        int pixmap_width, pixmap_height;
        Pixmap pixmap;

        double last_scale; // scaling factor used last time we did a redraw
        int next_value; // index into values that we need to draw next
        int next_draw;  // index into the pixmap where we next draw

        bool transparent;
        
        int skip_count, redraw_skip;

        bool full_redraw_required;

        Pixel background_colour;
        
protected:
        void updated(const string& keyName, const DataSet& data);
};

#endif
