#ifndef MODULE_TREE_DISPLAY_H
#define MODULE_TREE_DISPLAY_H

#include <vector>
using namespace std;

#include <gtk/gtk.h>
#include "configuration.h"
#include "../path.h"
#include "pathed_tree.h"

class ModuleTreeDisplay;

class Configuration;

class ModuleTreeDisplay : public PathedTreeListener
{
public:
        ModuleTreeDisplay(Configuration& parent_);
        virtual ~ModuleTreeDisplay();
        void load();
        GtkWidget* getWidget() {return vbox;};
        void rowSelect(GList* node);

        void setNewModuleType(const string& modTypeName);
        void newModule();
        void delModule();
        void node_selected(const Path& path);
        void module_type_selected();

private:
        void renumber();
        void tree_visit(GtkCTreeNode *node);
        GtkCTreeNode *last_visited;
        
private:
        Path mod;
        PathedTree tree;
        Configuration& parent;
        GtkWidget* menu; // for selecting the type of a new module
        GtkWidget* vbox;
        string newModTypeName;
        
        void expandNode(const Path& moduleNode);
};

#endif
