#ifndef MODIFIERENTRY_H
#define MODIFIERENTRY_H

#include "../datasetmap.h"
#include "modifierentrylistener.h"
#include "../path.h"

#include <gnome.h>
#include <string>
using namespace std;

class ModifierEntry
{
public:
        ModifierEntry(const string& varName, const Path& mod_,
                      ModifierEntryListener& parent_, bool owner);
        virtual ~ModifierEntry() {};
        GtkWidget* getWidget() {
                return vbox;
        }
        bool isValid() {
                return vbox;
        }

        virtual DataSet getValue() = 0;
        virtual void setValue(const DataSet& value) = 0;
        virtual void apply();
        virtual void reload();
        virtual void cancel();
        void changed();

        static ModifierEntry* createByTypeName(const string& typeName, const string& varName,
                                               const Path& mod_, ModifierEntryListener& parent_,
                                               bool owner);

        const string& getName() {return name;}

        ModifierEntryListener& getParent() {return parent;}
        
protected:
        string name;
        GtkWidget* vbox;
        GtkWidget* hbox;
        Path mod;
        ModifierEntryListener& parent;
};

#endif
