/*
 * robsound.h
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

/** @file
  * Declares Sound output related classes
  */
#ifndef __RT_SOUND__
#define __RT_SOUND__

#include "robfrontend.h"
#include "robmanage.h"
#include "robbase.h"

#include <rtsystem.h>

using namespace lrt;

namespace rt {

class SoundPlugin : public FrontendPlugin  
{
public:
	virtual FpInterpretePos getInterpretePos();
	virtual String getName();
	virtual String getHelpText();
	bool canPlay(bool checkSilent = true);
	virtual bool interpreteParams(const Array<String>& params, Array<bool>& used);
	virtual void fillOptions(SimOptions& options);
	SoundPlugin(Frontend* parent);
	~SoundPlugin() {}
private:
	bool isSoundInstalled(const String& name, bool checkSilent = true);
};

class SoundTourDisplayer : public TourDisplayer
{
public:
	virtual void init(const TourInitInfo&);
	virtual TourStatusType update(const Array<TourResult>& status);
	virtual void exit(TourStatusType exitType, const Array<TourResult>& result);
};

class SoundSimSupervisor : public SimSupervisor 
{
public:
	SoundSimSupervisor();
	virtual SimSuperPosition getPreferredPosition();
	virtual unsigned long getStepCycles();
	virtual GameState exec(Simulation* const curSim);
	virtual void exitSim(Simulation* const curSim, const GameState& simResult);
private:
	int cycles;
	static const int minMillis, maxMillis;
	Time lastTime;
	GameState retState;
};

} // namespace

#endif

