#include <string.h>
#include <stdio.h>
#include <time.h>
#include <assert.h>

#include "troff_generator.h"
#include "util.h"
#include "robodoc.h"
#include "items.h"
#include "headers.h"
#include "generator.h"

/****h* ROBODoc/TROFF_Generator
 * FUNCTION
 *   Generator for TROFF output.
 * NOTE
 *   Not finished.
 ******
 */

char               *
RB_TROFF_Get_Default_Extension( void )
{
    return ".troff";
}


/****f* TROFF_Generator/RB_TROFF_Generate_Doc_Start
 * NAME
 *   RB_TROFF_Generate_Doc_Start --
 ******
 */

void
RB_TROFF_Generate_Doc_Start( FILE * dest_doc, char *src_name, char *name,
                             char toc )
{
    /* Append document type and title */
    fprintf( dest_doc, ".\\\" Source: %s \n", src_name );
    {
        static const char   copyright_text[]
            = COMMENT_ROBODOC COMMENT_COPYRIGHT;
        size_t              i = 0;
        char                previous_char = '\n';
        char                current_char = copyright_text[i];

        while ( current_char )
        {
            if ( previous_char == '\n' )
            {
                fprintf( dest_doc, ".\\\" " );
            }
            else if ( ( current_char == '-' ) && ( previous_char == '-' ) )
            {
                /* avoid "--" inside SGML-comment, and use "-_" instead; this
                 * looks a bit strange, but one should still be able to figure
                 * out what is meant when reading the output */
                current_char = '_';
            }
            fputc( current_char, dest_doc );
            i += 1;
            previous_char = current_char;
            current_char = copyright_text[i];
        }
    }

    /* append heading */
    fprintf( dest_doc, ".\\\" t\n" );
    fprintf( dest_doc, ".\\\" @(#)%s.3\n", src_name );
    fprintf( dest_doc, ".TH %s 1 \"", src_name );
    {
        time_t              ttp;
        char                timeBuffer[255];

        time( &ttp );
        strftime( timeBuffer, 255, "%a %b %d %Y", localtime( &ttp ) );
        fprintf( dest_doc, "%s", timeBuffer );
    }
    fprintf( dest_doc, "\" %s 3\n", src_name );
    fprintf( dest_doc,
             ".PM Generated from %s with ROBODoc v" VERSION " on ",
             src_name );
    RB_TimeStamp( dest_doc );
    fprintf( dest_doc, "\n" );
}

/****f* TROFF_Generator/RB_TROFF_Generate_Doc_End
 * NAME
 *   RB_TROFF_Generate_Doc_End --
 *****
 */

void
RB_TROFF_Generate_Doc_End( FILE * dest_doc, char *name )
{

}

/****f* TROFF_Generator/RB_TROFF_Generate_Header_Start
 * NAME
 *   RB_TROFF_Generate_Header_Start
 ******
 */

void
RB_TROFF_Generate_Header_Start( FILE * dest_doc,
                                struct RB_header *cur_header )
{
    if ( cur_header->name )
    {
#if 0
        fprintf( dest_doc, ".TH \"%s\" 1 \"", cur_header->function_name );
        RB_TimeStamp( dest_doc );
        fprintf( dest_doc, "\" \"%s\" 3\n", cur_header->name );
#else
        fprintf( dest_doc, ".SH %s\n", cur_header->name );
#endif
    }
}


/****f* TROFF_Generator/RB_TROFF_Generate_Header_End
 * NAME
 *   RB_TROFF_Generate_Header_End --
 *****
 */
void
RB_TROFF_Generate_Header_End( FILE * dest_doc, struct RB_header *cur_header )
{
    fprintf( dest_doc, "\n.PP\n" );
}


/****f* TROFF_Generator/RB_TROFF_Generate_Empty_Item
 * NAME
 *   RB_TROFF_Generate_Empty_Item --
 ******
 */

void
RB_TROFF_Generate_Empty_Item( FILE * dest )
{
    /* Empty */
}



void
RB_TROFF_Generate_Char( FILE * dest_doc, int c )
{
    switch ( c )
    {
    case '\n':
        assert( 0 );
        break;
    case '\t':
        assert( 0 );
        break;
    case '\\':
    case '-':
    case '.':
        fputc( '\\', dest_doc );
        fputc( c, dest_doc );
        break;
    default:
        fputc( c, dest_doc );
    }
}
