/*
 *  windows-list.c        - 
 *
 *  Created: 20020126
 *
 *  Copyright (c) 2001, 2002 by Tomasz Trojanowski
 *  All rights reserved
 *
 *  $Id: windows-list.c,v 1.10 2002/03/19 23:14:16 tomek Exp $
 *
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <windows-list.h>

#include <appointment-window.h>
#include <contact-window.h>

static GList *appointment_windows_list = NULL;
static GList *contact_windows_list = NULL;

/* Funkcja wstawia dane okienko do listy okienek terminw. */
void add_appointment_window(GtkWidget *window)
{
    g_assert(window != NULL);
    
    appointment_windows_list = g_list_append(appointment_windows_list, (gpointer)window);
}

/* Funkcja usuwa dane okienko z listy okienek terminw. */
void remove_appointment_window(GtkWidget *window)
{
    g_assert(window != NULL);
    
    appointment_windows_list = g_list_remove(appointment_windows_list, (gpointer)window);
}

/* Pomocnicza funkcja zwrotna wykorzystywaniu przy wyszukiwaniu okienka terminu przechowujacego
   dane kontaktu o okrelonym identyfikatorze. */
static gint is_appointment_id_callback(GtkWidget *window, gint id)
{
    appointment_data *data;

    g_assert(window != NULL);
    g_assert(id != 0);
    
    /* Pobieranie wskanika do struktury danych kontaktu. */
    data = (appointment_data *)gtk_object_get_data(GTK_OBJECT(window), "data");
    g_assert(data != NULL);

    /* Poniewa funkcja ma zwraca 0 jeeli dany obiekt zosta znaleziony. */
    return (data->id != id);
}

/* Funkcja wyszukuje okienko o zadanym identyfikatorze terminu w licie okienek terminu. */
GtkWidget *find_appointment_window_id(gint id)
{
    GtkWidget *result = NULL;
    GList *list = NULL;

    g_assert(id != 0);
    
    /* Wyszukiwanie okienka o zadanym identyfikatorze terminu w licie okienek terminu. */
    list = g_list_find_custom(appointment_windows_list, (gpointer)id,
	                      (GCompareFunc)is_appointment_id_callback);
    if (list)
	result = GTK_WIDGET(g_list_nth_data(list, 0));
    
    return result;
}

/* Funkcja wstawia dane okienko do listy okienek kontaktw. */
void add_contact_window(GtkWidget *window)
{
    g_assert(window != NULL);
    
    contact_windows_list = g_list_append(contact_windows_list, (gpointer)window);
}

/* Funkcja usuwa dane okienko z listy okienek kontaktw. */
void remove_contact_window(GtkWidget *window)
{
    g_assert(window != NULL);
    
    contact_windows_list = g_list_remove(contact_windows_list, (gpointer)window);
}

/* Pomocnicza funkcja zwrotna wykorzystywaniu przy wyszukiwaniu okienka kontaktu przechowujacego
   dane kontaktu o okrelonym identyfikatorze. */
static gint is_contact_id_callback(GtkWidget *window, gint id)
{
    contact_data *data;

    g_assert(window != NULL);
    g_assert(id != 0);
    
    /* Pobieranie wskanika do struktury danych kontaktu. */
    data = (contact_data *)gtk_object_get_data(GTK_OBJECT(window), "data");
    g_assert(data != NULL);

    /* Poniewa funkcja ma zwraca 0 jeeli dany obiekt zosta znaleziony. */
    return (data->id != id);
}

/* Funkcja wyszukuje okienko o zadanym identyfikatorze kontaktu w licie okienek kontaktu. */
GtkWidget *find_contact_window_id(gint id)
{
    GtkWidget *result = NULL;
    GList *list = NULL;

    g_assert(id != 0);
    
    /* Wyszukiwanie okienka o zadanym identyfikatorze kontaktu w licie okienek kontaktu. */
    list = g_list_find_custom(contact_windows_list, (gpointer)id,
	                      (GCompareFunc)is_contact_id_callback);
    if (list)
	result = GTK_WIDGET(g_list_nth_data(list, 0));
    
    return result;
}

/* Pomocnicza funkcja zwrotna wykorzystywana przy zamykaniu wszystkich okienek. */
static void close_appointment_callback(GtkWidget *window, GList **new_list)
{
    appointment_data *data;
    
    /* Pobieranie wskanika do struktury danych terminu. */
    data = (appointment_data *)gtk_object_get_data(GTK_OBJECT(window), "data");
    g_assert(data != NULL);
    
    /* Wywoywanie funkcji zamykajcej okiekno terminu. Jeeli zamykanie si nie powiedzie
       wstawianie adresu okienka do nowej listy. */
    if (!close_appointment_window(data, FALSE))
        *new_list = g_list_append(*new_list, (gpointer)window);
}

/* Pomocnicza funkcja zwrotna wykorzystywana przy zamykaniu wszystkich okienek. */
static void close_contact_callback(GtkWidget *window, GList **new_list)
{
    contact_data *data;
    
    /* Pobieranie wskanika do struktury danych kontaktu. */
    data = (contact_data *)gtk_object_get_data(GTK_OBJECT(window), "data");
    g_assert(data != NULL);
    
    /* Wywoywanie funkcji zamykajcej okiekno kontaktu. Jeeli zamykanie si nie powiedzie
       wstawianie adresu okienka do nowej listy. */
    if (!close_contact_window(data, FALSE))
        *new_list = g_list_append(*new_list, (gpointer)window);
}

/* Funkcja zamyka wszystkie okienka z wyktkiem okienka gwnego programu. Zwraca warto
   logiczn okrelajc, czy wszystkie okienka zostay zamkniete. */
gboolean close_all_windows()
{
    GList *new_list = NULL;

    /* Zamykanie wszystkich okienek terminw. */
    g_list_foreach(appointment_windows_list, (GFunc)close_appointment_callback, &new_list);
    
    /* Przepisanie nowej listy w miejsce starej i zwalnianie pamici zajmowanej przez star
       list. */
    g_list_free(appointment_windows_list);
    appointment_windows_list = new_list;

    new_list = NULL;

    /* Zamykanie wszystkich okienek kontaktw. */
    g_list_foreach(contact_windows_list, (GFunc)close_contact_callback, &new_list);
    
    /* Przepisanie nowej listy w miejsce starej i zwalnianie pamici zajmowanej przez star
       list. */
    g_list_free(contact_windows_list);
    contact_windows_list = new_list;

    if (appointment_windows_list == NULL && contact_windows_list == NULL)
        return TRUE;
    
    return FALSE;
}
