#ifndef _hexonet_Connection_h_
#define _hexonet_Connection_h_


class Connection
{
  public:
    Connection();
    virtual ~Connection();

    virtual int send( unsigned char* _data, unsigned int _size );
    virtual int receive( unsigned char* _data, unsigned int _size );
    virtual bool isAlive();
};


class Buffer
{
  public:
    unsigned char* data;
    unsigned int pos;
    unsigned int end;
    unsigned int size;
};



class BufferedConnection: public Connection
{
  public:
    BufferedConnection( unsigned int _receiverSize = 8192,
                        unsigned int _senderSize = 8192,
                        unsigned int _senderSizeDelta = 2048 );
    virtual ~BufferedConnection();

    virtual int send( unsigned char* _data, unsigned int _size );
    virtual int receive( unsigned char* _data, unsigned int _size );

    bool resizeSenderBuffer( unsigned int _senderSize = 8192 );
    bool resizeReceiverBuffer( unsigned int _receiverSize );
    
    bool hasSenderBufferData() { return senderBuffer.pos < senderBuffer.end; }
    bool hasReceiverBufferData() { return receiverBuffer.pos < receiverBuffer.end; }

    unsigned int senderSizeDelta;
    Buffer senderBuffer;
    Buffer receiverBuffer;
};


#endif // _hexonet_Connection_h_
