\name{Ruuid-class}
\docType{class}
\alias{Ruuid-class}
\alias{Ruuid}
\alias{stringRep}
\alias{uuid}
\title{Class "Ruuid": A class to manage UUID values}
\description{ Class \code{Ruuid} wraps and handles the UUID values for
  the user within R.}
\section{Objects from the Class}{
  Objects are not intended to be directly created.  A user can retrieve
  a new instantiation of this class with the \code{getuuid} function.
}
\section{Slots}{
  \describe{
    \item{\code{stringRep}:}{Object of class \code{"character"} A human
      readable string representation of the ID}
    \item{\code{uuid}:}{Object of class \code{"uuidt"} Contains the
      actual UUID value.}
  }
}

\section{Methods}{
  \describe{
    \item{stringRep}{Retrieves the string representation of the UUID}
    \item{uuid}{Retrieves the \code{"uuidt"} object}
    \item{print}{Outputs the string representation of the UUID}
    \item{as.character}{Returns the string representation of the UUID}
    \item{==}{Returns true if both arguments are \code{Ruuid} objects
      and have the same string representation.}
    \item{!=}{Returns true if both arguments are \code{Ruuid} objects
      and have different string representations.}
   }
  }
\references{Theodore Ts'o's Universally Unique ID library\cr
  \url{http://web.mit.edu/tytso/www/home.html}}
\author{R. Gentleman and Jeff Gentry}
\seealso{\code{\link{getuuid}}, \code{\link{uuidt}}}
\examples{
z <- getuuid()
z
class(z)
}
\keyword{classes}
