\name{genRepos}
\alias{genRepos}
\alias{genPkgRepos}
\alias{genVigRepos}
\alias{buildPkgDf}
\alias{buildVigDf}
\alias{addOsSpecific}
\title{A function to create a repository}
\description{
  This functionality provides the user with the means to generate a
  repository out of a set of files.
}
\usage{
genRepos(repName, urlBase, urlPath, repType=c("package","vignette"),
         repRelLevel=c("release","devel"), dir = ".")
}
\arguments{
  \item{repName}{The name of the repository}
  \item{urlBase}{A base URL for the repository (e.g. http://www.bioconductor.org/)}
  \item{urlPath}{A path from the urlBase (e.g. packages/download/)}
  \item{repType}{The type of repository, either package or vignette.
    Defaults to package}
  \item{repRelLevel}{The default release level for packages in this
    repository.  Packages that don't have a \code{ReleaseLevel} field in
    their \code{DESCRIPTION} file will be of this release level.  The
    default is \code{release}.}
  \item{dir}{The directory to create the repository in}
}
\details{
  For more detailed information, the user is directed to the vignette
  file "HOWTO set up a simple R repository" in the \code{reposTools}
  package.  To do this, you can use the \code{vignette} command in the
  \code{annotate} package: vignette("HOWTO set up a simple R repository", package="reposTools").  

  genRepos is passed basic information about the repository as well as
  indicators as to what should be autogenerated or manually inputed, and
  will create two files:  One file 'replisting', which contains a matrix
  of repository information and the other 'repdatadesc.rda' which
  contains a data.frame representing the files to be distributed.  These
  two special files are accessed by client functions.
}
\value{
  genRepos returns a list containing basic information about the
  repository generated.
}
\author{Jeff Gentry}
\seealso{\code{\link{install.packages2}},\code{\link{ReposEntry}}}

\examples{
}
\keyword{utilities}
