winConvertSourceRepos <- function(repEntry, pkgs, destDir, recurse=TRUE,
                                  searchOptions=TRUE,
                                  errorLog="error.log",
                                  origFileDir) {
    if (.Platform$OS.type != "windows")
        stop("This function is for Windows systems only")
    if (missing(destDir))
        stop("no destination directory specified")
    if (missing(repEntry) && missing(pkgs))
        stop("Need to provide either/both of repEntry or pkgs")
    if(!missing(repEntry) && (repType(repEntry) != "package"))
        stop("winConvertSourceRepos requires a package repository")

    if (missing(pkgs) || is.null(pkgs) )
	pkgs <- repPkgInfos(repEntry)

    ret <- try(setwd(destDir))
    if (is(ret,"try-error"))
        stop(paste(destDir,"does not seem to be a valid directory"))

    cDir <- getwd()
    on.exit(setwd(cDir),add=TRUE)
    if (missing(origFileDir)) {
        tmpDir <- tempfile()
        on.exit(unlink(tmpDir,recursive=TRUE),add=TRUE)
        dir.create(tmpDir)
    }
    else
        tmpDir <- origFileDir

    ## Error log
    errorLog <- file.path(cDir, errorLog)

    ## Download package files to tmp directory
    ret <- lapply(pkgs, function(x) {downloadFile(repEntry, pkgName(x),
                                                  stringRep(pkgVersion(x)),
                                                  "Source", dest=tmpDir)})
    if (length(ret) != length(pkgs))
        stop("Error downloading requested files")
    gc()
    setwd(tmpDir)
    pkgs <- dir(tmpDir)
    repObjs <- repObjects(repEntry, type="Source", files=TRUE)
    repFiles <- repObjs[,"filenames"]
    ## Filter out any packages that weren't downloaded for some reason
    repObjs <- repObjs[match(pkgs,repFiles),]
    if (length(repObjs) == 0) {
        return(NULL)
    }
    for (i in 1:nrow(repObjs)) {
        pkg <- repObjs[i,"pkg"]
        vers <- repObjs[i,"vers"]
        file <- repObjs[i,"filenames"]

        system(paste("Rcmd install --build",file))

        outFile <- paste(pkg,"_", vers, ".zip",sep="")
        file.copy(outFile,file.path(cDir,outFile),overwrite=TRUE)
    }

    download.file(paste(repURL(repEntry), "repThemes.rda", sep="/"),
                  file.path(destDir, "repThemes.rda"))
}

