// 
// $Id: qaregexplanguage.hpp,v 1.1 2000/06/12 10:53:28 amos-cvs Exp $
//
// Definition of QaRegExpLanguage class
//
// Jan Borsodi <jb@ez.no>
// Created on: <12-Jun-2000 12:17:33 amos>
//
// Copyright (C) Jan Borsodi.  All rights reserved.

#ifndef QAREGEXPLANGUAGE_HPP
#define QAREGEXPLANGUAGE_HPP

#include <qstring.h>

class QaRegExpLanguage
{
public:
    enum MatchType
    {
        Normal,
        Multiple,
        Split
    };
    QaRegExpLanguage();
    virtual ~QaRegExpLanguage();

    virtual QString fromPlainText( const QString &str, bool code, MatchType type );

    QString wordCharacters() const;
    QString characters() const;
    QString capitalCharacters() const;
    QString nonCapitalCharacters() const;
    QString identifiers() const;

private:
};


#endif // QAREGEXPLANGUAGE_HPP
