#ifndef _rfield_h
#define _rfield_h

#include "allegro.h"

class RFont;
class RMenu;

class RField{
public:
	RField( bool selectable, bool perm, int return_val, RMenu * who, int number, SAMPLE * play_me );
	
	//selectable
	virtual bool Ok();

	virtual bool Title();

	//return value
	virtual int Val();

	//returns place in list
	virtual int Place();

	//add RField to list
	virtual void Add( RField * rf );

	//sets the next menu when chosen
	virtual void setMenu( RMenu * nx );

	virtual int Size();

	//called when field is selected from menu
	virtual void Selected();

	virtual void Draw( BITMAP * work, int x, int y, int col );

	//returns true if container = obj
	virtual bool equiv( void * obj );
	
	virtual RField * Next();
	virtual RField * Prev();
	virtual RMenu * NextMenu();

	virtual ~RField();

protected:
	bool select;
	int ret;
	int num;

	bool title;

	RField * next, * prev;
	RMenu * menu_next;
	SAMPLE * smp;
	
};

class RField_Name: public RField {
public:
	RField_Name( RFont * f_font, char * name, bool selectable, bool perm, int return_val, RMenu * who, int number, SAMPLE * pl );
	virtual bool equiv( void * obj );
	virtual void Draw( BITMAP * work, int x, int y, int col );
	virtual int Size();
	virtual ~RField_Name();
protected:
	char * handle;
	RFont * field_font;
};

class RField_Bitmap: public RField {
public:
	RField_Bitmap( BITMAP * look, bool selectable, bool perm, int return_val, RMenu * who, int number, SAMPLE * pl );
	virtual bool equiv( void * obj );
	virtual void Draw( BITMAP * work, int x, int y, int col );
	virtual int Size();
	virtual ~RField_Bitmap();
protected:
	BITMAP * scene;
};

#endif
