#include "gunobj.h"
#include "gun_spread.h"
#include "hull_weapon_spread.h"
#include "weaponobj.h"
#include "spaceobj.h"
#include "defs.h"

WeaponSpreadGun::WeaponSpreadGun( int z, int d, SAMPLE * _smp, int al ):
WeaponObject( d, "Spread Gun", 31500, al, z, 4 ) {
	smp = _smp;
}


WeaponObject * WeaponSpreadGun::copy() {
	return new WeaponSpreadGun( strength, dir, smp, alignment );
}


void WeaponSpreadGun::MakeShot(int x, int y, vector< SpaceObject * > * Ammo, vector< SpaceObject * > * fight) {
	if ( smp != NULL )
		play_sample( smp, 255, 128, 1000, false );

	shot_counter = 5;
	int ang = (strength+1) * 30;
	int ds = 50 / (strength+2);

	for ( int q = 0; q < ang; q += ds ) {
		Ammo->push_back( new WeaponNode((int)(x+tcos[(90+q+360)%360]),(int)(y+tsine[(90+q+360)%360]),tcos[(90+q+360)%360]*2.6,tsine[(90+q+360)%360]*2.6, new Spread_WHull(7), alignment ) );
		Ammo->push_back( new WeaponNode((int)(x+tcos[(90-q+360)%360]),(int)(y+tsine[(90-q+360)%360]),tcos[(90-q+360)%360]*2.6,tsine[(90-q+360)%360]*2.6, new Spread_WHull(7), alignment ) );
	}

}
