/*
 * QTPixmap GTK engine
 *
 * This is a hacked/modified version of the Pixmap GTK engine. Modified to use
 * ~/.qt/qtrc to get colour information to recolour widgets.
 *
 * Changes are (C) Craig Drummond 2002 - Craig.Drummond@@lycos.co.uk
 *
 */

static GCache *pixbuf_cache = NULL;

static gpointer pixbuf_cache_dup_key(struct image_file *f)
{
    struct image_file *n=g_malloc(sizeof(struct image_file));

    n->name=g_strdup(f->name);
    n->color=f->color;
    if(COLOR_APP==n->color)
    {
        n->c.rgb.r=f->c.rgb.r;
        n->c.rgb.g=f->c.rgb.g;
        n->c.rgb.b=f->c.rgb.b;
    }
    else
        n->c.mod=f->c.mod;

    return n;
}

static void pixbuf_cache_dest_key(struct image_file *f)
{
    g_free(f->name);
    g_free(f);
}

static guint pixbuf_cache_hash_key(gconstpointer k)
{
    struct image_file *f=(struct image_file *)k;
    int               hash=COLOR_APP==f->color ? f->c.rgb.r<<16 + f->c.rgb.g<<8 + f->c.rgb.b : f->c.mod;

    return g_str_hash(f->name)+g_int_hash(&(f->color))+g_int_hash(&hash);
}

static gboolean pixbuf_cache_key_equal(gconstpointer k1, gconstpointer k2)
{
    struct image_file *a=(struct image_file *)k1,
                      *b=(struct image_file *)k2;

    return a->color==b->color &&
           ( (COLOR_APP==a->color && a->c.rgb.r==b->c.rgb.r && a->c.rgb.g==b->c.rgb.g && a->c.rgb.b==b->c.rgb.b) ||
             (COLOR_APP!=a->color && a->c.mod==b->c.mod) ) &&
           g_str_equal(a->name, b->name);
}
