# Written by Hyriand
# see LICENSE.txt for license information

from qt import *

import torrentwindow
import torrentsettings

from BitTornado.BT1 import download
from thread import start_new_thread
from threading import Event, Timer

import os, sys, pickle, urllib, pwd, socket, time, select

CONFIG = os.path.expanduser("~/.qtorrent")
VERSION = "0.9.6.1"
CONTROLSOCK = "/tmp/qtorrent." + pwd.getpwuid(os.getuid())[0]

class TorrentSettings(torrentsettings.TorrentSettings):
    def __init__(self, parent = None, name = None):
        torrentsettings.TorrentSettings.__init__(self, parent, name)
        
        self.mParent = parent
        
        self.mOptions = {
          "max_uploads": [0, self.WMaxUploads],
          "keepalive_interval": [0, self.WKeepAlive],
          "download_slice_size": [0, self.WDownSlice],
          "request_backlog": [0, self.WRequestBacklog],
          "max_message_length": [0, self.WMaxMessage],
          "ip": [1, self.WIP],
          "ipv6_enabled": [2, self.WIPV6],
          "ipv6_binds_v4": [2, self.WIPV6toV4],
          "alloc_rate": [0, self.WAllocRate],
          "security": [2, self.WSecurity],
          "auto_kick": [2, self.WAutoKick],
          "max_files_open": [0, self.WMaxFiles],
          "minport": [0, self.WMinPort],
          "maxport": [0, self.WMaxPort],
          "timeout": [0, self.WTimeout],
          "timeout_check_interval": [0, self.WTimeoutCheck],
          "max_slice_length": [0, self.WMaxSlice],
          "max_rate_period": [0, self.WMaxRatePeriod],
          "bind": [1, self.WBind],
          "upload_rate_fudge": [0, self.WRateFudge],
          "rerequest_interval": [0, self.WRerequest],
          "min_peers": [0, self.WMinPeers],
          "http_timeout": [0, self.WHTTPTimeout],
          "max_initiate": [0, self.WMaxInitiate],
          "max_upload_rate": [0, self.WMaxUploadRate],
          "upload_unit_size": [0, self.WUploadUnit],
          "snub_time": [0, self.WSnubTime],
          "rarest_first_cutoff": [0, self.WRarest],
          "min_uploads": [0, self.WMinUploads],
          "rarest_first_priority_cutoff": [0, self.WRarestPrio],
          "round_robin_period": [0, self.WRRPeriod],
          "max_connections": [0, self.WMaxConns],
          "lock_files": [2, self.WLock],
          "lock_while_reading": [2, self.WReadLock],
        }
        
        verify = [0,0,0]
        
        for o in download.defaults:
            if not self.mOptions.has_key(o[0]):
                if o[0] == "check_hashes":
                    verify[0] = o[1]
                elif o[0] == "double_check":
                    verify[1] = o[1]
                elif o[0] == "triple_check":
                    verify[2] = o[1]
                elif o[0] == "alloc_type":
                    self.WAllocStrat.setCurrentItem(["normal", "background", "pre-allocate", "sparse"].index(o[1]))
                continue
            opt = self.mOptions[o[0]]
            if opt[0] == 0:
                default = str(o[1])
                opt[1].setValue(o[1])
            elif opt[0] == 1:
                default = o[1]
                opt[1].setText(o[1])
            elif opt[0] == 2:
                default = o[1] and "yes" or "no"
                opt[1].setOn(o[1])
            
            QToolTip.add(opt[1], o[2] + " (default: <b>%s</b>)" % default)
        
        if verify[2]:
            self.WVerify.setCurrentItem(3)
        elif verify[1]:
            self.WVerify.setCurrentItem(2)
        elif verify[0]:
            self.WVerify.setCurrentItem(1)
        else:
            self.WVerify.setCurrentItem(0)
        
    def config(self):
        dict = {}
        for key in self.mOptions.keys():
            opt = self.mOptions[key]
            if opt[0] == 0:
                dict[key] = opt[1].value()
            elif opt[0] == 1:
                dict[key] = str(opt[1].text())
            elif opt[0] == 2:
                dict[key] = opt[1].isOn()
        
        if self.WVerify.currentItem() == 0:
            dict["triple_check"] = 0
            dict["double_check"] = 0
            dict["check_hashes"] = 0
        elif self.WVerify.currentItem() == 1:
            dict["triple_check"] = 0
            dict["double_check"] = 0
            dict["check_hashes"] = 1
        elif self.WVerify.currentItem() == 2:
            dict["triple_check"] = 0
            dict["double_check"] = 1
            dict["check_hashes"] = 1
        else:
            dict["triple_check"] = 1
            dict["double_check"] = 1
            dict["check_hashes"] = 1
        
        if self.WAllocStrat.currentItem() == 0:
            dict["alloc_type"] = "normal"
        elif self.WAllocStrat.currentItem() == 1:
            dict["alloc_type"] = "background"
        elif self.WAllocStrat.currentItem() == 2:
            dict["alloc_type"] = "pre-allocate"
        else:
            dict["alloc_type"] = "sparse"
            
        return dict
    
    def setConfig(self, dict):
        for key in dict.keys():
            if not self.mOptions.has_key(key):
                continue
                
            opt = self.mOptions[key]
            if opt[0] == 0:
                opt[1].setValue(dict[key])
            elif opt[0] == 1:
                opt[1].setText(dict[key])
            elif opt[0] == 2:
                opt[1].setOn(dict[key])
        
        if dict.has_key("triple_check") and dict["triple_check"]:
            self.WVerify.setCurrentItem(3)
        elif dict.has_key("double_check") and dict["double_check"]:
            self.WVerify.setCurrentItem(2)
        elif dict.has_key("check_hashes") and dict["check_hashes"]:
            self.WVerify.setCurrentItem(1)
        else:
            self.WVerify.setCurrentItem(0)
                
    def ok(self):
        self.mParent.setConfig(self.config())
        self.hide()
    
    def cancel(self):
        self.hide()
    

class TorrentControl:
    def __init__(self):
    	self.command = None
        self.mRunFlag = Event()
        self.mNotifyFlag = Event()
        self.mNotifyFlag.set()
        
        try:
            os.remove(CONTROLSOCK)
        except:
            pass
        
        self.socket = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
        self.socket.setblocking(1)
        self.socket.bind(CONTROLSOCK)
        self.socket.listen(1)
    
    def start(self):
        self.mRunFlag.set()
        start_new_thread(self.run, ())
    
    def stop(self):
        self.mRunFlag.clear()
    
    def join(self):
        self.stop()
        self.mRunFlag.wait()
        
        try:
            os.remove(CONTROLSOCK)
        except:
            pass
    
    def run(self):
        while self.mRunFlag.isSet():
            (infd, outfd, exfd) = select.select([self.socket], [], [], 0.5)
            if infd:
                sock = self.socket.accept()[0]
                command = ""
                while command[-1:] != '\n':
                    data = sock.recv(8192)
                    if not data:
                        command = None
                        break
                    command = command + data
                sock.close()
                self.command = command
                
                if self.command:
                    self.mNotifyFlag.clear()
                    self.mNotifyFlag.wait()
        self.mRunFlag.set()
    
class TorrentRunner:
    def __init__(self, config, torrent, listitem):
        self.mDownload = download.Download()
        self.mDownload.filedatflag.set()
        
        self.config = config.copy()
        self.mTorrent = torrent
        self.mListItem = listitem
        
        self.mMinUploads = self.config["min_uploads"]
        self.mMaxUploads = self.config["max_uploads"]
        self.mMaxUploadRate = self.config["max_upload_rate"]
        
        self.mFilename = os.path.split(torrent)[-1]
        self.mFilesize = 0
        self.mFraction = 0.0
        self.mUpCurrent = 0.0
        self.mDownCurrent = 0.0
        self.mUpTop = 0.0
        self.mDownTop = 0.0
        self.mUpTotal = 0.0
        self.mDownTotal = 0.0
        self.mAutoPause = 0
        self.mListenPort = "unknown"
        self.mSeeds = 0
        self.mClients = 0
        self.mCopies = 0.0
        self.mRatio = 0.0
        self.mClientStats = (0, 0.0)
        self.mNumHave = 0
        self.mNumPieces = 0
        self.mStatus = "initialising"
        self.mLastReannounce = time.time()
        
        self.mLIStatus = "initialising"
        self.mLIRemaining = -1
        self.mLastError = ""
        
        self.mActive = 0
        self.mFinished = 0
        self.mFailed = 0
        self.mPaused = 0
        
        self.mKillFlag = Event()
        self.mFileSet = Event()
        self.mWantFile = Event()
        self.mWantDir = Event()
        self.mUpdated = Event()
        self.mTimer = None
        
        self.mFileSaveAs = None
        
    def start(self):
        args = []
        for key in self.config.keys():
            if key == "report_hash_failures":
                continue
            args += ["--"+key, self.config[key]]
        args += [self.mTorrent]
        
        start_new_thread(self.run, (args,))

    def run(self, args):
        self.mActive = 1
        self.mUpdated.set()
        self.mDownload.download(args, self.chooseFile, self.display, self.finished, self.error, self.mKillFlag, 100)
        self.mActive = 0
        self.mListenPort = "unknown"
        self.mUpdated.set()
        if not self.mFinished:
            self.failed()
    
    def stop(self):
        self.mKillFlag.set()
        if self.mTimer:
            self.mTimer.cancel()
            
    def reset(self):
        self.mUpCurrent = self.mDownCurrent = 0.0
        self.mSeeds = self.mClients = self.mCopies = 0
        self.mClientStats = (0, 0.0)
        self.mRatio = 0.0
        self.mUpdated.set()
        
    def chooseFile(self, default, size, saveas, dir):
        if not self.mFileSet.isSet():
            self.mFilesize = size
            self.mFilename = default
            self.mUpdated.set()
            
            if dir:
                self.mWantDir.set()
            else:
                self.mWantFile.set()
                
            self.mFileSet.wait()
        
        if not self.mFileSaveAs:
            self.mLastError = "aborted"
            self.mUpdated.set()
        
        return self.mFileSaveAs

    def finished(self):
        self.mLIRemaining = -2
        self.mDownCurrent = 0.0
        self.mFinished = 1
        self.mFraction = 1.0
        self.mUpdated.set()
        if self.mAutoPause:
            if self.mTimer:
                self.mTimer.cancel()
            self.mTimer = Timer(self.mAutoPause * 60.0, self.pause, [], {"force":1})
            self.mTimer.start()

    def error(self, error):
        self.mLastError = error
        self.mUpdated.set()
    
    def failed(self):
        self.mFailed = 1
        self.mUpdated.set()
        self.reset()
        
    def display(self, fractionDone = None,
            timeEst = None, downRate = None, upRate = None,
            activity = None, statistics = None, spew = None, sizeDone = None,
            **kws):
        
        if kws.has_key("listen_port"):
            self.mListenPort = str(kws["listen_port"])
        
        if not fractionDone is None:
            self.mFraction = fractionDone
        if not activity is None:
            self.mStatus = activity
        if not downRate is None:
            self.mDownCurrent = downRate
        if not upRate is None:
            self.mUpCurrent = upRate
        if not timeEst is None:
            self.mStatus = "still remaining: %i:%02i:%02i" % (timeEst / (60*60), (timeEst / 60) % 60, timeEst % 60)
            self.mLIRemaining = "%i:%02i:%02i" % (timeEst / (60*60), (timeEst / 60) % 60, timeEst % 60)
            self.mLIStatus = "downloading"
        
        if self.mDownCurrent > self.mDownTop:
            self.mDownTop = self.mDownCurrent
        if self.mUpCurrent > self.mUpTop:
            self.mUpTop = self.mUpCurrent
            
        if not statistics is None:
            self.mRatio = statistics.shareRating
            if not self.mFinished:
                self.mSeeds = statistics.numSeeds
                self.mCopies = statistics.numCopies2
            else:
                self.mSeeds = statistics.numOldSeeds
                self.mCopies = statistics.numCopies
            self.mClients = statistics.numPeers
            self.mClientStats = (statistics.percentDone, statistics.torrentRate)
            self.mNumHave = statistics.picker.numgot
            self.mNumPieces = statistics.picker.numpieces
            self.mDownTotal = statistics.downTotal
            self.mUpTotal = statistics.upTotal
            
        self.mUpdated.set()
        
    def setMaxUploads(self, max):
        if max == self.mMaxUploads:
            return
            
        self.mMaxUploads = max
        self.config["max_uploads"] = max
        self.mDownload.setConns(max)
        self.mUpdated.set()

    def setMaxUploadRate(self, max):
        if max == self.mMaxUploadRate:
            return
            
        self.mMaxUploadRate = max
        self.config["max_upload_rate"] = max
        self.mDownload.setUploadRate(max * 1024)
        self.mUpdated.set()
    
    def setAutoPause(self, timeout):
        self.mAutoPause = timeout
        if self.mFinished:
            if self.mTimer:
                self.mTimer.cancel()
            if timeout:
                self.mTimer = Timer(timeout * 60.0, self.pause, [], {"force":1})
                self.mTimer.start()
            else:
                self.mTimer = None
        self.mUpdated.set()
        
    def pause(self, force = 0):
        if self.mTimer:
            self.mTimer.cancel()
            self.mTimer = None
        if not self.mPaused:
            self.mPaused = 1
            self.mDownload.Pause()
            self.reset()
        elif self.mPaused == 1 and not force:
            self.mPaused = 0
            self.mDownload.Unpause()
        self.mUpdated.set()
        
    def reannounce(self):
        if time.time() > self.mLastReannounce + 60:
            self.mDownload.reannounce()
            self.mLastReannounce = time.time()


class TorrentWindow(torrentwindow.TorrentWindow):
    def __init__(self, parent = None):
        torrentwindow.TorrentWindow.__init__(self, parent)
        self.statusBar().hide()
        self.WTorrents.setColumnWidthMode(0, QListView.Manual)
        self.WTorrents.setColumnWidth(0, self.sizeHint().width() / 2)
        
        self.mWasMinimized = 1
        
        self.connect(self.WDropper, PYSIGNAL("urisDropped(const QString&)"), self.slotUrisDropped)
        self.connect(self.WDropper, SIGNAL("clicked()"), self.openFile)
        self.connect(self.historyMenu, SIGNAL("aboutToShow()"), self.showHistory)
        self.connect(self.historyMenu, SIGNAL("activated(int)"), self.doHistory)

        self.mSettings = TorrentSettings(self)
        self.mSettings.resize(self.mSettings.minimumSize())
        
        try:
            f = open(CONFIG, "r")
            self.mConfig = pickle.load(f)
            f.close()
        except Exception, e:
            print "Warning:", e
            self.mConfig = self.mSettings.config()
        
        self.mTorrents = []
        self.mCurrent = -1
        
        self.mControlSock = TorrentControl()
        self.mControlSock.start()
        
        self.mTimer = QTimer(self)
        self.connect(self.mTimer, SIGNAL("timeout()"), self.update)
        self.mTimer.start(500)
        
        self.goToList()
        
    def goToStats(self):
        self.mCurrent = -1
        self.update()
        self.WStack.raiseWidget(self.WStats)
    
    def goToList(self):
        self.mCurrent = -2
        self.update(1)
        self.WStack.raiseWidget(self.WListPage)
        
    def newTorrent(self, fn):
        for torrent in self.mTorrents:
            if torrent.mTorrent == fn:
                self.mCurrent = self.mTorrents.index(torrent)
                self.update(1)
                self.WStack.raiseWidget(self.WTorrentPage)
                break
        else:
            li = QListViewItem(self.WTorrents)
            li.setText(8, fn)
            torrent = TorrentRunner(self.mConfig, fn, li)
            self.mTorrents.append(torrent)
            if self.mCurrent >= 0:
                self.mCurrent = self.mTorrents.index(torrent)
                self.update(1)
            
            if not [h[0] for h in self.history() if h[0] == fn]:
                self.setHistory(fn, None)
                
            torrent.start()
    
    def openFile(self):
        fn = QFileDialog.getOpenFileName(None, "*.torrent")
        if fn:
            self.newTorrent(str(fn))
    
    def openURL(self):
        url = QInputDialog.getText("Open URL...", "URL")
        if url[1]:
            self.newTorrent(str(url[0]).replace(" ", "%20"))
            
    def nextPage(self):
        if not self.mTorrents:
            self.goToList()
        else:
            self.mCurrent = (self.mCurrent + 1) % len(self.mTorrents)
            self.update(1)
            self.WStack.raiseWidget(self.WTorrentPage)

    def prevPage(self):
        if not self.mTorrents:
            self.goToList()
        else:
            self.mCurrent = (self.mCurrent - 1) % len(self.mTorrents)
            self.update(1)
            self.WStack.raiseWidget(self.WTorrentPage)
    
    def exit(self):
        self.close()
        
    def closeTorrent(self, ix):
        torrent = self.mTorrents[ix]
        del self.mTorrents[ix]
        self.WTorrents.takeItem(torrent.mListItem)
        torrent.stop()
    
    def doClose(self, term = 0):
        if term:
            if self.mTorrents and QMessageBox.warning(self, "Warning!", "This will close all open torrents. Continue?",
                                                      QMessageBox.Yes, QMessageBox.No) == QMessageBox.No:
                return 0
            for torrent in self.mTorrents:
                torrent.stop()
            return 1
        elif self.mCurrent == -1:
            self.close()
        elif self.mCurrent == -2:
            child = self.WTorrents.firstChild()
            torrents = []
            while child:
                if child.isSelected():
                    torrents.append(child.text(8))
                child = child.nextSibling()
            for torrent in torrents:
                for t in self.mTorrents:
                    if t.mTorrent == torrent:
                        self.closeTorrent(self.mTorrents.index(t))
                        break
        else:
            self.closeTorrent(self.mCurrent)
            self.mCurrent -= 1
            self.nextPage()
        
    def close(self, a = 0):
        if self.doClose(1):
            self.mControlSock.join()
            return torrentwindow.TorrentWindow.close(self, a)
        return 0
    
    def showSettings(self):
        self.mSettings.setConfig(self.mConfig)
        self.mSettings.show()

    def setConfig(self, dict):
        self.mConfig = dict
        try:
            f = open(CONFIG, "w")
            pickle.dump(self.mConfig, f)
            f.close()
        except Exception, e:
            print "Warning:", e
    
    def updateTorrent(self, force = 0):
        tor = self.mTorrents[self.mCurrent]
        
        if not force and not tor.mUpdated.isSet():
            return
            
        if tor.mFailed:
            status = "failed (%s)" % tor.mLastError
        elif tor.mPaused:
            status = "paused"
        elif tor.mFinished:
            status = "seeding"
        else:
            status = tor.mStatus

        self.WFilename.setText(tor.mFilename)
        self.WFilesize.setText("%.1f MB / %.1f MB (%i of %i pieces)" % ((tor.mFilesize * tor.mFraction) / (1024.0*1024.0), tor.mFilesize / (1024.0*1024.0), tor.mNumHave, tor.mNumPieces))
        self.WStatus.setText(status)
        self.WProgress.setProgress(tor.mFraction * 100)
        self.WUpCurrent.setText("%.1f KB/s" % (tor.mUpCurrent / 1024.0))
        self.WDownCurrent.setText("%.1f KB/s" % (tor.mDownCurrent / 1024.0))
        self.WUpTop.setText("(%.1f KB/s)" % (tor.mUpTop / 1024.0))
        self.WDownTop.setText("(%.1f KB/s)" % (tor.mDownTop / 1024.0))
        self.WUpped.setText("%.1f MB" % (tor.mUpTotal / (1024.0 * 1024.0)))
        self.WDowned.setText("%.1f MB" % (tor.mDownTotal / (1024.0 * 1024.0)))
        
        if tor.mUpTop == 0.0:
            self.WUpRatio.setProgress(0, 1024)
        else:
            self.WUpRatio.setProgress(tor.mUpCurrent, tor.mUpTop)
            
        if tor.mDownTop == 0.0:
            self.WDownRatio.setProgress(0, 1024)
        else:
            self.WDownRatio.setProgress(tor.mDownCurrent, tor.mDownTop)
        
        if tor.mRatio == -1.0:
            self.WRatio.setText("oo")
        else:
            self.WRatio.setText("%.3f" % tor.mRatio)
            
        self.WSeeds.setText(str(tor.mSeeds))
        self.WClients.setText(str(tor.mClients))
        self.WCopies.setText("(+%.1f copies)" % tor.mCopies)
        self.WClientStats.setText("(%i%% @ %.1f KB/s)" % (tor.mClientStats[0], tor.mClientStats[1] / 1024.0))
        
        if force:
            self.WMaxUploads.setValue(tor.mMaxUploads)
            self.WMaxUploads.setMinValue(tor.mMinUploads)
            self.WMaxUploadRate.setValue(tor.mMaxUploadRate)
        
        self.WListenPort.setText(str(tor.mListenPort))
        
        self.WPause.setEnabled(not tor.mFailed)
        
        tor.mUpdated.clear()

    def updateList(self, force = 0):
        for tor in self.mTorrents:
            if not force and not tor.mUpdated.isSet():
                continue
                
            if tor.mFailed:
                status = "failed"
            elif tor.mPaused:
                status = "paused"
            elif tor.mFinished:
                status = "seeding"
            else:
                status = tor.mLIStatus
            tor.mListItem.setText(0, tor.mFilename)
            tor.mListItem.setText(1, status)
            tor.mListItem.setText(2, "%i%%" % (int(tor.mFraction * 100)))
            if tor.mLIRemaining == -2:
                tor.mListItem.setText(3, "")
            elif tor.mLIRemaining == -1:
                tor.mListItem.setText(3, "unknown")
            else:
                tor.mListItem.setText(3, tor.mLIRemaining)
            tor.mListItem.setText(4, "%.1f" % (tor.mDownCurrent / 1024.0))
            tor.mListItem.setText(5, "%.1f" % (tor.mUpCurrent / 1024.0))
            if tor.mFilesize == 0:
                tor.mListItem.setText(6, "unknown")
            else:
                tor.mListItem.setText(6, "%.1f" % (tor.mFilesize / (1024.0 * 1024.0)))
            tor.mListItem.setText(7, tor.mLastError)
            tor.mUpdated.clear()
        
    def update(self, force = 0):
        if not self.mControlSock.mNotifyFlag.isSet():
            url = self.mControlSock.command.split("\n")[0]
            self.mControlSock.mNotifyFlag.set()
            self.newTorrent(url)
        
        if self.mCurrent == -2:
            self.updateList(force)
        elif self.mCurrent >= 0:
            self.updateTorrent(force)
        
        active = 0
        paused = 0
        finished = 0
        failed = 0
        uprate = 0.0
        downrate = 0.0
        uptotal = 0.0
        downtotal = 0.0
        
        for t in self.mTorrents:
            if t.mWantFile.isSet() or t.mWantDir.isSet():
                h_fn = [h[1] for h in self.history() if h[0] == t.mTorrent] or [None]
                if h_fn[0] is None:
                    if t.mWantFile.isSet():
                        t.mWantFile.clear()
                        fn = QFileDialog.getSaveFileName(t.mFilename)
                    else:
                        t.mWantDir.clear()
                        fn = QFileDialog.getExistingDirectory()
                    if fn:
                        t.mFileSaveAs = str(fn)
                    else:
                        t.mFileSaveAs = None
                    
                    self.setHistory(t.mTorrent, t.mFileSaveAs)
                else:
                    t.mWantFile.clear()
                    t.mWantDir.clear()
                    t.mFileSaveAs = h_fn[0]
                    
                t.mFileSet.set()
            
            if t.mActive and not t.mPaused:
                active += 1
                uprate += t.mUpCurrent
                downrate += t.mDownCurrent
            if t.mFinished:
                finished += 1
            if t.mFailed:
                failed += 1
            if t.mPaused:
                paused += 1
            uptotal += t.mUpTotal
            downtotal += t.mDownTotal

        if self.mCurrent == -1:
            self.WActive.setText(str(active))
            self.WPaused.setText(str(paused))
            self.WFinished.setText(str(finished))
            self.WFailed.setText(str(failed))
            self.WUpRate.setText("%.1f KB/s" % (uprate / 1024.0))
            self.WDownRate.setText("%.1f KB/s" % (downrate / 1024.0))
            self.WUpTotal.setText("%.1f MB" % (uptotal / (1024.0 * 1024.0)))
            self.WDownTotal.setText("%.1f MB" % (downtotal / (1024.0 * 1024.0)))
        
        if self.isMinimized():
            self.setCaption("QTorrent (D:%.1f U:%.1f)" % (downrate / 1024.0, uprate / 1024.0))
            self.mWasMinimized = 1
        elif self.mWasMinimized:
            self.setCaption("QTorrent " + VERSION)
            self.mWasMinimized = 0
                
    def slotUrisDropped(self, uris):
        for i in str(uris).split("\n"):
            if i:
                self.newTorrent(i.strip())
               
    def pause(self):
        if self.mCurrent == -1:
            if self.mTorrents and QMessageBox.warning(self, "Warning!", "This will pause all active torrents. Continue?",
                                                      QMessageBox.Yes, QMessageBox.No) == QMessageBox.Yes:
                for t in self.mTorrents:
                    t.pause()
        elif self.mCurrent == -2:
            child = self.WTorrents.firstChild()
            torrents = []
            while child:
                if child.isSelected():
                    torrents.append(child.text(8))
                child = child.nextSibling()
            for torrent in torrents:
                for t in self.mTorrents:
                    if t.mTorrent == torrent:
                        t.pause(1)
                        break
        else:
            self.mTorrents[self.mCurrent].pause()
    
    def doubleClicked(self, item):
        if not item:
            return
        torrent = item.text(8)
        for t in self.mTorrents:
            if t.mTorrent == torrent:
                self.mCurrent = self.mTorrents.index(t)
                self.update(1)
                self.WStack.raiseWidget(self.WTorrentPage)
                break
    
    def setMaxUploads(self, max):
        if self.mCurrent < 0:
            return
        self.mTorrents[self.mCurrent].setMaxUploads(max)
    
    def setMaxUploadRate(self, max):
        if self.mCurrent < 0:
            return
        self.mTorrents[self.mCurrent].setMaxUploadRate(max)
    
    def setAutoPause(self, timeout):
        if self.mCurrent < 0:
            return
        self.mTorrents[self.mCurrent].setAutoPause(timeout)
        
    def reannounce(self):
        if self.mCurrent < 0:
            return
        self.mTorrents[self.mCurrent].reannounce()
    
    def history(self):
        try:
            f = open(CONFIG + ".history", "r")
            r = pickle.load(f)
            f.close()
        except Exception, e:
            print "Warning:", e
            r = []
        return r
    
    def saveHistory(self, history):
        try:
            f = open(CONFIG + ".history", "w")
            pickle.dump(history, f)
            f.close()
        except Exception, e:
            print "Warning:", e
            
    def setHistory(self, torrent, saveas):
        history = self.history()
        for h in history:
            if h[0] == torrent:
                history.remove(h)
                break
        history = [[torrent, saveas]] + history
        self.saveHistory(history)
    
    def clearHistory(self):
        self.saveHistory([])
    
    def showHistory(self):
        for i in range(self.historyMenu.count() - 2):
            self.historyMenu.removeItemAt(2)
        ix = 0
        self.mHistory = self.history()
        for t in self.mHistory:
            if t[0].find("://"):
                title = urllib.unquote(t[0].split("/")[-1])
            else:
                title = os.path.split(t[0])[-1]
            self.historyMenu.insertItem(title, ix)
            ix += 1
    
    def doHistory(self, id):
        if id >= 0:
            h = self.mHistory[id]
            self.setHistory(h[0], h[1])
            self.newTorrent(h[0])
        
    def about(self):
        QMessageBox.about(self, "QTorrent",
"""QTorrent %s by Hyriand (Copyright 2004)

(uses TheSHAD0W's BitTornado 0.0.1)""" % VERSION)
