/***************************************************************************
                          ptext.cpp  -  description
                             -------------------
    begin                : Tue Apr 17 22:27:58 CEST 2001
    copyright            : (C) 2001 by Johan Maes ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ptext.h"
#include <qpainter.h>
#include "qsstvglobal.h"
#include <qmultilineedit.h>
#include <qfontdialog.h>
#include <qspinbox.h>

static int shadowOffset=0;
static QFont f("times");
static QString localstr;

//#define DEBUGPTEXT

ptext::ptext (QWidget* parent,const char* name)	:
	textForm( parent, name )
{
	editBox->setText(localstr);
	shadowSpinBox->setValue(shadowOffset);
	
/*  int i=0;
  while(families[i])
    {
      fontCombo->insertItem(families[i++]);
    }
  fontCombo->setCurrentItem(fontc);
  pointSizeBox->setValue(spinb);
  shadowOffsetBox->setValue(shadowOffset);
  boldButton->setChecked(bbold);
  shadowButton->setChecked(bshadow);
  italicButton->setChecked(bitalic);
*/
}


ptext::~ptext()
{

}





/*
void ptext::pointSizeChanged(int val)
{
  spinb=val;  
}

void ptext::fontChanged(int val)
{
  fontc=val;  
}

void ptext::shadowOffsetChanged(int val)
{
  shadowOffset=val;
}


void ptext::boldClicked(bool s)
{
  bbold=s;
}

void ptext::italicClicked(bool s)
{
  bitalic=s;
}

void ptext::shadowClicked(bool s)
{
  bshadow=s;
}
*/

void ptext::accept()
{
	shadowOffset=shadowSpinBox->value();
	localstr=editBox->text();
	textForm::accept();
}

void ptext::fontSelect_slot()
{
	bool ok;
  f = QFontDialog::getFont( &ok,f, this );
  if ( ok )
  	{
    	// the user selected a valid font
    	editBox->setFont(f);
    }
}

void ptext::draw(QPainter *p,QPoint pt ,QColor fgColor,bool erase)
{
  QRect br,v;
  p->setPen(fgColor);
  p->setRasterOp(XorROP);
  p->setFont(f);
  p->setPen(XORCOLOR);
  v=QRect(0,0,800,600);
  br=p->boundingRect(0,0,8000,1000,AlignLeft|AlignTop|DontClip,localstr);
  if(erase)
    {
#ifdef DEBUGPTEXT
      debug("%d %d %d %d",br.x(),br.y(),br.width(),br.height());
#endif
      p->drawText(vold,AlignLeft|AlignTop|DontClip,localstr);
    }
  v.moveTopLeft(QPoint(pt.x()-br.width()/2,pt.y()-br.height()/2));
  p->drawText(v,AlignLeft|AlignTop|DontClip,localstr);
  vold=v;
}

void ptext::fixText(QPainter *p,QColor fgColor,QColor bgColor)
{
  p->setFont(f);
  QFontMetrics fm(f);
  if (shadowOffset)
    {
      vold.moveBy(shadowOffset,shadowOffset);
      p->setPen(bgColor);
      p->drawText(vold,AlignLeft|AlignTop|DontClip,localstr);
      vold.moveBy(-shadowOffset,-shadowOffset);
    }
  p->setPen(fgColor);
  p->drawText(vold,AlignLeft|AlignTop|DontClip,localstr);
  vold=QRect(0,0,0,0);
}    





