from Pyro.protocol import DefaultConnValidator
import Pyro.constants
import md5


# Example username/password database:
EXAMPLE_ALLOWED_USERS = {
	"irmen": "secret",
	"guest": "guest",
	"root": "change_me",
}

#
#	Example login/password validator.
#	Passwords are munged using md5 with challenge,
#	so they cannot be spied upon.
#
class UserLoginConnValidator(DefaultConnValidator):

	def _xform(self, s):
		return md5.md5(s).digest()

	def acceptIdentification(self, daemon, connection, token, challenge):
		login, password = token.split(':', 1)
		realpass = EXAMPLE_ALLOWED_USERS.get(login)
		# Check if the username/password is valid.
		if realpass and self._xform(self._xform(realpass)+challenge) == password:
			print "ALLOWED", login
			connection.authenticated=login  # store for later reference by Pyro object
			return(1,0)
		print "DENIED",login
		return (0,Pyro.constants.DENIED_SECURITY)
		
	def createAuthToken(self, authid, challenge, peeraddr, URI, daemon):
		return "%s:%s" % (authid[0], self._xform(authid[1]+challenge))

	def mungeIdent(self, ident):
		# ident is tuple (login, password), the client sets this.
		return (ident[0], self._xform(ident[1]))
		
