#!/usr/bin/perl
# $Id: cpronto.pl,v 1.5 2001/04/11 06:08:26 muhri Exp $

# ok, ill try to comment it this time, but no promises
# no, the widgets arent commented, but its rather self explanitory anyways
# as usual, dont fsck with this, but if you do, use normal (8 space) tabs _everywhere_
# dont even think of using anything but $command = $conn->prepare; $command->execute()
#
# -ishamael

BEGIN {
	$libpath = $0;
	$libpath =~ s!/[^/]+$!!;
	$libpath =~ s!/bin$!/lib/pronto!;
	if (! -e $libpath) { die "Can't find required files in $libpath"; };
}

use lib "$libpath";
use lib "$libpath/modules/lib/perl5/site_perl/5.005";


use Pronto::CPronto;
use Pronto::Data::Message;
use Pronto::Get;
use MIME::Parser;
use Text::Wrap;
use MIME::Types;
use File::Copy;
use strict;

use vars qw(%prefs $libpath $conn);
require "prontolib.pl";

&read_prefs();

my $version = "0.3"; #yippie!
my %foldername_to_id;
my %folder_id_to_list_position;

#create the conn connection
$conn = &open_db_conn();

my $parser = new MIME::Parser;
$parser->output_dir("$prefs{'MailDir'}/tmp/");

my $i;

#create a new CPronto element, this is really just a hash ref for me to throw widgets in
# and keep track of rows/cols, it really serves no extreme purpose.
# oh, yeah, it sets terminal stuff up.

my $cpronto = new Pronto::CPronto;
$cpronto->{border} = new Pronto::CPronto::Box(	x	=>	0,
						y	=>	0,
						rows	=>	$cpronto->{rows}-1,
						cols	=>	$cpronto->{cols}-1);
$cpronto->{button_box} = new Pronto::CPronto::Box(	x	=>	1,
							y	=>	$cpronto->{rows}-5,
							rows	=>	2,
							cols	=>	$cpronto->{cols}-3);
$cpronto->{second_button_box} = new Pronto::CPronto::Box(	x	=>	1,
								y	=>	$cpronto->{rows}-7,
								rows	=>	2,
								cols	=>	$cpronto->{cols}-3);
$cpronto->{status_box} = new Pronto::CPronto::Box(	x	=>	1,
							y	=>	$cpronto->{rows}-3,
							rows	=>	2,
							cols	=>	$cpronto->{cols}-3);

# GLOBAL WIDGETS
$cpronto->{quit_button} = new Pronto::CPronto::Button(	label	=>	"Quit",
							x	=>	$cpronto->{cols}-8,
							y	=>	$cpronto->{rows}-4);
$cpronto->{new_button} = new Pronto::CPronto::Button(	label	=>	"New",
							x	=>	$cpronto->{cols}-13,
							y	=>	$cpronto->{rows}-4);
$cpronto->{list_button} = new Pronto::CPronto::Button(	label	=>	"Folders",
							x	=>	$cpronto->{cols}-22,
							y	=>	$cpronto->{rows}-4);
$cpronto->{check_button} = new Pronto::CPronto::Button(	label	=>	"Check/Send",
							x	=>	$cpronto->{cols}-34,
							y	=>	$cpronto->{rows}-4);
$cpronto->{help_button} = new Pronto::CPronto::Button(	label	=>	"Help",
							x	=>	$cpronto->{cols}-40,
							y	=>	$cpronto->{rows}-4);


# FOLDER LIST WIDGETS
$cpronto->{folder_list} = new Pronto::CPronto::List(	titles	=>	["Folder","Msg","New"],
							x	=>	1,
							y	=>	1,
							height	=>	$cpronto->{rows}-11,
							widths	=>	[0,20,5,5]);
$cpronto->{folder_list}->{ok_button} = new Pronto::CPronto::Button(	label	=>	"Ok",
									x	=>	2,
									y	=>	$cpronto->{rows}-6);
$cpronto->{folder_list}->{delete_button} = new Pronto::CPronto::Button(	label	=>	"Delete",
									x	=>	6,
									y	=>	$cpronto->{rows}-6);
$cpronto->{folder_list}->{add_button} = new Pronto::CPronto::Button(	label	=>	"Add folder",
									x	=>	14,
									y	=>	$cpronto->{rows}-6);


# MESSAGE LIST WIDGETS
$cpronto->{message_list} = new Pronto::CPronto::List(	titles	=>	["New","Status","","From","Subject","Date"],
							x	=>	1,
							y	=>	1,
							height	=>	$cpronto->{rows}-11,
							widths	=>	[0,4,7,0,int(($cpronto->{cols}-14)/3),int(($cpronto->{cols}-14)/3),int(($cpronto->{cols}-14)/3)-1]);
$cpronto->{message_list}->{ok_button} = new Pronto::CPronto::Button(	label	=>	"Ok",
									x	=>	2,
									y	=>	$cpronto->{rows}-6);
$cpronto->{message_list}->{delete_button} = new Pronto::CPronto::Button(label	=>	"Delete",
									x	=>	6,
									y	=>	$cpronto->{rows}-6);
$cpronto->{message_list}->{reply_button} = new Pronto::CPronto::Button(	label	=>	"Reply",
									x	=>	14,
									y	=>	$cpronto->{rows}-6);
$cpronto->{message_list}->{replyall_button} = new Pronto::CPronto::Button(	label	=>	"Reply to all",
										x	=>	21,
										y	=>	$cpronto->{rows}-6);

$cpronto->{message_list}->{for_button} = new Pronto::CPronto::Button(	label	=>	"Forward",
									x	=>	21,
									y	=>	$cpronto->{rows}-6);
$cpronto->{message_list}->{move_button} = new Pronto::CPronto::Button(	label	=>	"Move",
									x	=>	30,
									y	=>	$cpronto->{rows}-6);
$cpronto->{message_list}->{copy_button} = new Pronto::CPronto::Button(	label	=>	"Copy",
									x	=>	36,
									y	=>	$cpronto->{rows}-6);
$cpronto->{message_list}->{server_button} = new Pronto::CPronto::Button(label	=>	"Server Status",
									x	=>	42,
									y	=>	$cpronto->{rows}-6);


# TEXT BOX WIDGETS
$cpronto->{text_box} = new Pronto::CPronto::Text(	text	=>	"",
							x	=>	1,
							y	=>	7,
							editable=>	0,
							height	=>	$cpronto->{rows}-15,
							width	=>	$cpronto->{cols}-3,
							xpos	=>	0,
							ypos	=>	0,
							position=>	0,
							top_line=>	0,
							current_line	=>	0);
$cpronto->{text_box}->{from_entry} = new Pronto::CPronto::Entry(text	=>	"",
								editable=>	0,
								limit	=>	$cpronto->{cols}-16,
								x	=>	13,
								y	=>	1);
$cpronto->{text_box}->{from_label} = new Pronto::CPronto::Label(text	=>	"From",
								x	=>	1,
								y	=>	1);
$cpronto->{text_box}->{to_entry} = new Pronto::CPronto::Entry(	text	=>	"",
								limit	=>	$cpronto->{cols}-16,
								editable=>	0,
								x	=>	13,
								y	=>	2);
$cpronto->{text_box}->{to_label} = new Pronto::CPronto::Label(	text	=>	"To",
								x	=>	1,
								y	=>	2);

								editable=>	0,
$cpronto->{text_box}->{subj_entry} = new Pronto::CPronto::Entry(text	=>	"",
								limit	=>	$cpronto->{cols}-16,
								x	=>	13,
								y	=>	3);
$cpronto->{text_box}->{subj_label} = new Pronto::CPronto::Label(text	=>	"Subject",
								x	=>	1,
								y	=>	3);
$cpronto->{text_box}->{cc_entry} = new Pronto::CPronto::Entry(	text	=>	"",
								limit	=>	$cpronto->{cols}-16,
								editable=>	0,
								x	=>	13,
								y	=>	4);
$cpronto->{text_box}->{cc_label} = new Pronto::CPronto::Label(	text	=>	"Cc",
								x	=>	1,
								y	=>	4);
$cpronto->{text_box}->{att_entry} = new Pronto::CPronto::Entry(	text	=>	"",
								limit	=>	$cpronto->{cols}-16,
								x	=>	13,
								y	=>	5,
								editable=>	0);
$cpronto->{text_box}->{att_label} = new Pronto::CPronto::Label(	text	=>	"Attachments",
								x	=>	1,
								y	=>	5);

$cpronto->{text_box}->{ok_button} = new Pronto::CPronto::Button(label	=>	"Send",
								x	=>	2,
								y	=>	$cpronto->{rows}-6);
$cpronto->{text_box}->{cancel_button} = new Pronto::CPronto::Button(	label	=>	"Cancel",
									x	=>	8,
									y	=>	$cpronto->{rows}-6);
$cpronto->{text_box}->{att_button} = new Pronto::CPronto::Button(	label	=>	"View attachments",
									x	=>	16,
									y	=>	$cpronto->{rows}-6);
$cpronto->{text_box}->{book_button} = new Pronto::CPronto::Button(	label	=>	"Address Book",
									x	=>	16,
									y	=>	$cpronto->{rows}-6);

# ATTACHMENT LIST WIDGETS
$cpronto->{att_list} = new Pronto::CPronto::List(	titles	=>	["Attachment","Type","Size"],
							x	=>	1,
							y	=>	1,
							height	=>	$cpronto->{rows}-11,
							widths	=>	[0,20,20,5]);
$cpronto->{att_list}->{save_button} = new Pronto::CPronto::Button(	label	=>	"Save",
									x	=>	2,
									y	=>	$cpronto->{rows}-6);
$cpronto->{att_list}->{cancel_button} = new Pronto::CPronto::Button(	label	=>	"Cancel",
									x	=>	8,
									y	=>	$cpronto->{rows}-6);
$cpronto->{att_list}->{save_label} = new Pronto::CPronto::Label(	text	=>	"Where?",
									x	=>	int($cpronto->{cols}/2)-6,
									y	=>	int($cpronto->{rows}/2)-4);
$cpronto->{att_list}->{save_box} = new Pronto::CPronto::Box(	rows	=>	2,
								cols	=>	60,
								x	=>	int($cpronto->{cols}/2)-31,
								y	=>	int($cpronto->{rows}/2)-4);

$cpronto->{att_list}->{save_entry} = new Pronto::CPronto::Entry(editable=>	1,
								limit	=>	57,
								x	=>	int($cpronto->{cols}/2)-30,
								y	=>	int($cpronto->{rows}/2)-3);

# ADDRESS BOOK
$cpronto->{book_list} = new Pronto::CPronto::List(	titles	=>	["Alias","Address","Public Key",""],
							x	=>	1,
							y	=>	1,
							height	=>	$cpronto->{rows}-11,
							widths	=>	[0,20,30,20,0]);
$cpronto->{book_list}->{select_button} = new Pronto::CPronto::Button(	label	=>	"Select",
									x	=>	1,
									y	=>	$cpronto->{rows}-6);
$cpronto->{book_list}->{back_button} = new Pronto::CPronto::Button(	label	=>	"Back",
									x	=>	9,
									y	=>	$cpronto->{rows}-6);

# OTHER WIDGETS

$cpronto->{mc_label} = new Pronto::CPronto::Label(	text	=>	"Where?",
							x	=>	int($cpronto->{cols}/2)-6,
							y	=>	int($cpronto->{rows}/2)-4);

$cpronto->{mc_box} = new Pronto::CPronto::Box(	rows	=>	9,
							cols	=>	16,
							x	=>	int($cpronto->{cols}/2)-7,
							y	=>	int($cpronto->{rows}/2)-4);

$cpronto->{mc_list} = new Pronto::CPronto::List(	titles	=>	["Folders        "],
							x	=>	int($cpronto->{cols}/2)-6,
							y	=>	int($cpronto->{rows}/2)-3,
							widths	=>	[0,14],
							height	=>	6);




$cpronto->{folders} = ();
$cpronto->{addresses} = ();
$cpronto->{messages} = ();
#this will read the boxlist table in your conn, and put the results in my $cpronto->{folders};
&show_folders();

#connect signals to callbacks (damn, just like gtk *grin*)
$cpronto->{folder_list}->signal_connect("activate",\&show_messages);
$cpronto->{folder_list}->{ok_button}->signal_connect("activate",\&show_messages);
$cpronto->{message_list}->signal_connect("activate",\&read_message);
$cpronto->{message_list}->{ok_button}->signal_connect("activate",\&read_message);
$cpronto->{message_list}->{reply_button}->signal_connect("activate",\&reply_message);
$cpronto->{message_list}->{replyall_button}->signal_connect("activate",\&reply_message);
$cpronto->{message_list}->{delete_button}->signal_connect("activate",\&delete_message);
$cpronto->{message_list}->{for_button}->signal_connect("activate",\&forward_message);
$cpronto->{message_list}->{move_button}->signal_connect("activate",\&move_message);
$cpronto->{message_list}->{copy_button}->signal_connect("activate",\&copy_message);
$cpronto->{message_list}->{server_button}->signal_connect("activate",\&change_msgs_server_status);
$cpronto->{quit_button}->signal_connect("activate",\&quit);
$cpronto->{new_button}->signal_connect("activate",\&compose);
$cpronto->{list_button}->signal_connect("activate",\&show_folders);
$cpronto->{check_button}->signal_connect("activate",\&check_mail);
$cpronto->{help_button}->signal_connect("activate",\&help);
$cpronto->{mc_list}->signal_connect("unfocus",\&regain_focus);
$cpronto->{text_box}->{att_button}->signal_connect("activate",\&view_attachments);
$cpronto->{text_box}->{book_button}->signal_connect("activate",\&addy_book);
$cpronto->{att_list}->{cancel_button}->signal_connect("activate",\&read_message);
$cpronto->{att_list}->{save_button}->signal_connect("activate",\&save_att);
$cpronto->{att_list}->signal_connect("activate",\&save_att);
$cpronto->{att_list}->{save_entry}->signal_connect("unfocus",\&regain_focus);
$cpronto->{book_list}->{back_button}->signal_connect("activate",\&back_to_compose);
$cpronto->{book_list}->{select_button}->signal_connect("activate",\&select_addy);
$cpronto->{book_list}->signal_connect("activate",\&select_addy);

$cpronto->signal_connect("signal_q",\&quit);
$cpronto->signal_connect("signal_Q",\&quit);
$cpronto->signal_connect("signal_l",\&show_folders);
$cpronto->signal_connect("signal_L",\&show_folders);
$cpronto->signal_connect("signal_N",\&compose);
$cpronto->signal_connect("signal_n",\&compose);
$cpronto->signal_connect("signal_C",\&copy_message);
$cpronto->signal_connect("signal_c",\&copy_message);
$cpronto->signal_connect("signal_m",\&move_message);
$cpronto->signal_connect("signal_M",\&move_message);
$cpronto->signal_connect("signal_r",\&reply_message);
$cpronto->signal_connect("signal_R",\&reply_message);
#$cpronto->signal_connect("signal_y",\&reply_message);
#$cpronto->signal_connect("signal_Y",\&reply_message);
$cpronto->signal_connect("signal_d",\&delete_message);
$cpronto->signal_connect("signal_D",\&delete_message);
$cpronto->signal_connect("signal_s",\&change_msgs_server_status);
$cpronto->signal_connect("signal_S",\&change_msgs_server_status);
$cpronto->signal_connect("signal_f",\&forward_message);
$cpronto->signal_connect("signal_F",\&forward_message);
$cpronto->signal_connect("signal_x",\&check_mail);
$cpronto->signal_connect("signal_X",\&check_mail);
$cpronto->signal_connect("signal_v",\&view_attachments);
$cpronto->signal_connect("signal_V",\&view_attachments);
$cpronto->signal_connect("signal_a",\&addy_book);
$cpronto->signal_connect("signal_A",\&addy_book);
$cpronto->signal_connect("signal_w",\&redraw_screen);
$cpronto->signal_connect("signal_w",\&redraw_screen);
$cpronto->signal_connect("signal_h",\&help);
$cpronto->signal_connect("signal_H",\&help);


#init 
$cpronto->{border}->show();
$cpronto->{button_box}->show();
$cpronto->{second_button_box}->show();
$cpronto->{status_box}->show();
$cpronto->change_widget($cpronto->{folder_list});
for ($i = 0; $i < $cpronto->{num_widgets}; $i++) {
	$cpronto->{widgets}[$i]->show();
}

$cpronto->{status} = 0;
$cpronto->{current_folderid} = -1;
$cpronto->main_loop();


sub redraw_screen {
	my ($i,$j);


	$cpronto->clear();
	$cpronto->{border}->show();
	$cpronto->{second_button_box}->show();
	$cpronto->{button_box}->show();
	$cpronto->{status_box}->show();

	$j = $cpronto->{num_widgets};
	for ($i = 0; $i < $j; $i++) {
		$cpronto->{widgets}[$i]->show();
	}
}

sub addy_book {
	if ($cpronto->{status} != 3) {
		return;
	}
	my ($i,$j);

	$j = $#{$cpronto->{addresses}};
	for ($i = 0; $i <= $j; $i++) {
		$cpronto->{book_list}->del_row(0);
	}

	&read_addresses();

	for ($i = 0; $i <= $#{$cpronto->{addresses}}; $i++) {
		$cpronto->{book_list}->add_row($i,\@{$cpronto->{addresses}[$i]});
	}
	
	$j = $cpronto->{num_widgets};
	for ($i = 0; $i < $j; $i++) {
		$cpronto->{widgets}[0]->hide();
		$cpronto->remove_widget($cpronto->{widgets}[0]);
	}

	$cpronto->add_widget($cpronto->{book_list});
	$cpronto->add_widget($cpronto->{book_list}->{select_button});
	$cpronto->add_widget($cpronto->{book_list}->{back_button});
	$cpronto->add_widget($cpronto->{list_button});
	$cpronto->add_widget($cpronto->{new_button});
	$cpronto->add_widget($cpronto->{quit_button});

	$cpronto->change_widget($cpronto->{book_list});

	$j = $cpronto->{num_widgets};
	for ($i = 0; $i < $j; $i++) {
		$cpronto->{widgets}[$i]->show();
	}
#	$cpronto->{book_list}->select_row(0);
	$cpronto->change_widget($cpronto->{book_list});
	$cpronto->{book_list}->focus();
	return;
}

sub select_addy {
	my ($to,$i);
	$i = $cpronto->{text_box}->{to_entry}->get_text();
	$to = $cpronto->{book_list}->get_item_data($cpronto->{book_list}->get_selected(),1);
	if ($i ne "") {
		$i = $i.", ";
	}
	$to = $i.$to;
	$cpronto->{text_box}->{to_entry}->set_text($to);
	&back_to_compose();
	return;
}

sub back_to_compose {
	my ($i,$j,$from,$to,$subj,$cc,$att);
	$from = $cpronto->{text_box}->{from_entry}->get_text();
	$to = $cpronto->{text_box}->{to_entry}->get_text();
	$subj = $cpronto->{text_box}->{subj_entry}->get_text();
	$cc = $cpronto->{text_box}->{cc_entry}->get_text();
	$att = $cpronto->{text_box}->{att_entry}->get_text();

	&init_text_widget(1);
	&display_dialog_message("Compose new message");

	$cpronto->change_widget($cpronto->{text_box}->{to_entry});
	$cpronto->{text_box}->set_text("");
	$j = $cpronto->{num_widgets};
	for ($i = 0; $i < $j; $i++) {
		$cpronto->{widgets}[$i]->show();
	}
	$cpronto->{text_box}->{type} = 0;
	$cpronto->{text_box}->{from_entry}->set_text($from);
	$cpronto->{text_box}->{from_entry}->show();
	$cpronto->{text_box}->{to_entry}->set_text($to);
	$cpronto->{text_box}->{to_entry}->show();
	$cpronto->{text_box}->{subj_entry}->set_text($subj);
	$cpronto->{text_box}->{subj_entry}->show();
	$cpronto->{text_box}->{cc_entry}->set_text($cc);
	$cpronto->{text_box}->{cc_entry}->show();
	$cpronto->{text_box}->{att_entry}->set_text($att);
	$cpronto->{text_box}->{att_entry}->show();

	$cpronto->{text_box}->{to_entry}->focus();
	return;
}

sub read_addresses {
	my ($command,@a,$i);

	$cpronto->{addresses} = ();

	$command = $conn->prepare("select alias,address,public_key,id from addresses");
	$command->execute();
	my $i = 0;
	while (@a = $command->fetchrow_array()) {
		@{$cpronto->{addresses}[$i]} = @a;
		$i++;
	}
	$command->finish();
	return;
}

sub help {
	my ($i,$j);

	&init_text_widget(0);
	$cpronto->remove_widget($cpronto->{text_box}->{att_entry});
	$cpronto->remove_widget($cpronto->{text_box}->{att_label});
	$cpronto->remove_widget($cpronto->{text_box}->{cc_label});
	$cpronto->remove_widget($cpronto->{text_box}->{att_button});
	$cpronto->remove_widget($cpronto->{text_box}->{cc_entry});

	&display_dialog_message("Help dialog");

	$cpronto->change_widget($cpronto->{text_box});

	$cpronto->{text_box}->set_text("Welcome to cpronto $version\n\nThis is the Curses/console/command-line version of Pronto.\n\nHow to use:\nYou can push the [TAB] key to switch between the items on the screen.\nThe current item should is highlighted or stands out in some way.\nAll key presses, except the [TAB] key and global hotkeys will be directed to\nthe current item, which will handle them as it needs to (that is, pressing\nthe down arrow in an Entry has no effect, but pressing it in a List will\nscroll the list down one row).\n\nHotkeys:\n
q - Quit
w - refresh screen
l - List folders
n - compose New message
c - Copy message
m - Move message
r - Reply to message
f - Forward message
x - check mail
v - View attachments
a - Address book
s - change Server status
h - help

If there are any complaints/suggestions, please direct them to the Pronto\nmailing list - pronto\@muhri.net.\n\nIf cpronto, for some reason, crashes and your terminal is messed up, use\nthe 'reset' command to fix it.\n\n");
	$cpronto->{text_box}->{from_entry}->set_text("cpronto");
	$cpronto->{text_box}->{to_entry}->set_text("the user");
	$cpronto->{text_box}->{subj_entry}->set_text("cpronto $version help");


	$j = $cpronto->{num_widgets};
	for ($i = 0; $i < $j; $i++) {
		$cpronto->{widgets}[$i]->show();
	}

	$cpronto->{text_box}->focus();
	return;
}


sub save_att {
	my ($row,$att);
	$row = $cpronto->{att_list}->get_selected();
	$att = $cpronto->{att_list}->get_item_data($row,0);
	if ($att eq "") {
		return;
	}
	&display_dialog_message("Saving $att");
	
	$cpronto->add_widget($cpronto->{att_list}->{save_entry});
	$cpronto->change_widget($cpronto->{att_list}->{save_entry});
	$cpronto->{att_list}->{save_box}->show();
	$cpronto->{att_list}->{save_label}->show();
	$cpronto->{att_list}->{save_entry}->show();
	$cpronto->{att_list}->{save_entry}->focus();
	$cpronto->{att_list}->{save_entry}->signal_connect("activate",\&save_att_cb);
	$cpronto->signal_connect("signal_n27",\&cancel_save);
	return;
}

sub save_att_cb {
	my ($att,$where);
	$att = $cpronto->{att_list}->get_item_data($cpronto->{att_list}->get_selected(),0);
	$where = $cpronto->{att_list}->{save_entry}->get_text();
	copy("$ENV{'HOME'}/.pronto/tmp/$att","$where");
	&cancel_save();
	return;
}

sub cancel_save {
	$cpronto->signal_connect("signal_n27",\&blank);
	$cpronto->{att_list}->{save_entry}->hide();
	$cpronto->{att_list}->{save_box}->hide();
	$cpronto->{att_list}->{save_label}->hide();
	&view_attachments();
	return;
}

sub view_attachments {
	if ($cpronto->{status} != 3) {
		return;
	}
	my ($i,$j);
	$j = $cpronto->{num_widgets};
	for ($i = 0; $i < $j; $i++) {
		$cpronto->{widgets}[0]->hide();
		$cpronto->remove_widget($cpronto->{widgets}[0]);
	}
	$j = $cpronto->{att_list}->{num_rows};
	for ($i = 0; $i <= $j; $i++) {
		$cpronto->{att_list}->del_row(0);
	}

	$cpronto->add_widget($cpronto->{att_list});
	$cpronto->add_widget($cpronto->{att_list}->{save_button});
	$cpronto->add_widget($cpronto->{att_list}->{cancel_button});


	for ($i = 0; $i <= $#{$cpronto->{text_box}->{attachments}}; $i++) {
		$cpronto->{att_list}->add_row($i,\@{$cpronto->{text_box}->{attachments}[$i]});
	}

	$j = $cpronto->{num_widgets};
	for ($i = 0; $i < $j; $i++) {
		$cpronto->{widgets}[$i]->show();
	}
	$cpronto->change_widget($cpronto->{att_list});
	$cpronto->{att_list}->focus();
	return;
}

sub regain_focus {
	if ($cpronto->{current} == 0) {
		$cpronto->{current} = $cpronto->{num_widgets}-2;
	} else {
		$cpronto->{current}--;
	}
	return;
}

sub cancel_mc {
	my ($row,$i,$j);
	$row = $cpronto->{message_list}->get_selected();
	$cpronto->{mc_list}->hide();
	$cpronto->{mc_label}->hide();
	$cpronto->{mc_box}->hide();
	$cpronto->remove_widget($cpronto->{mc_list});
	$cpronto->change_widget($cpronto->{message_list});
	$j = $cpronto->{num_widgets};
	for ($i = 0; $i < $j; $i++) {
		$cpronto->{widgets}[$i]->unfocus();
	}
	$cpronto->{message_list}->focus();
	$cpronto->{message_list}->redraw();
	$cpronto->signal_connect("signal_n27",\&blank);
	return;
}

sub move_message {
	if ($cpronto->{widgets}[$cpronto->{current}] != $cpronto->{message_list} && $cpronto->{widgets}[$cpronto->{current}] != $cpronto->{message_list}->{move_button}) {
		return;
	}
	$cpronto->add_widget($cpronto->{mc_list});
	$cpronto->change_widget($cpronto->{mc_list});
	&read_folders();
	for ($i = 0; $i <= $#{$cpronto->{folders}}; $i++) {
		$cpronto->{mc_list}->add_row($i,\@{$cpronto->{folders}[$i]});
	}

	$cpronto->{mc_box}->show();
	$cpronto->{mc_label}->show();
	$cpronto->{mc_list}->show();
	$cpronto->{mc_list}->focus();
	$cpronto->{mc_list}->signal_connect("activate",\&move_message_cb);
	$cpronto->signal_connect("signal_n27",\&cancel_mc);
	return;
}

sub move_message_cb {
	my ($row,$messageid,$folderid);
	$row = $cpronto->{message_list}->get_selected();
	$messageid = $cpronto->{message_list}->get_item_data($row,2);
	$folderid = $foldername_to_id{$cpronto->{mc_list}->get_item_data($cpronto->{mc_list}->get_selected(),0)};

	&Pronto::Data::Message::move($folderid,($messageid));

	&display_dialog_message("Moved $messageid");
	$cpronto->{message_list}->del_row($row);
	&cancel_mc();
	return;
}

sub copy_message {
	if ($cpronto->{widgets}[$cpronto->{current}] != $cpronto->{message_list} && $cpronto->{widgets}[$cpronto->{current}] != $cpronto->{message_list}->{copy_button}) {
		return;
	}
	$cpronto->add_widget($cpronto->{mc_list});
	$cpronto->change_widget($cpronto->{mc_list});
	&read_folders();
	for ($i = 0; $i <= $#{$cpronto->{folders}}; $i++) {
		$cpronto->{mc_list}->add_row($i,\@{$cpronto->{folders}[$i]});
	}

	$cpronto->{mc_box}->show();
	$cpronto->{mc_label}->show();
	$cpronto->{mc_list}->show();
	$cpronto->{mc_list}->focus();
	$cpronto->{mc_list}->signal_connect("activate",\&copy_message_cb);
	$cpronto->signal_connect("signal_n27",\&cancel_mc);
	return;
}

sub copy_message_cb {
	my ($row,$messageid,$folderid);
	$row = $cpronto->{message_list}->get_selected();
	$messageid = $cpronto->{message_list}->get_item_data($row,2);
	$folderid = $foldername_to_id{$cpronto->{mc_list}->get_item_data($cpronto->{mc_list}->get_selected(),0)};

	&Pronto::Data::Message::copy($folderid,($messageid));

	&display_dialog_message("Copied $messageid");
	&cancel_mc();
	return;
}


sub delete_message {
	if ($cpronto->{widgets}[$cpronto->{current}] != $cpronto->{message_list} && $cpronto->{widgets}[$cpronto->{current}] != $cpronto->{message_list}->{delete_button}) {
		return;
	}
	my ($messageid,$row,$command);

	$row = $cpronto->{message_list}->get_selected();
	$messageid = $cpronto->{message_list}->get_item_data($row,2);
	$cpronto->{message_list}->del_row($row);

	&Pronto::Data::Message::delete(($messageid));

	&display_dialog_message("Deleted $messageid");
	$cpronto->{message_list}->redraw();
	return;
}

sub change_msgs_server_status {
	if ($cpronto->{widgets}[$cpronto->{current}] != $cpronto->{message_list} && $cpronto->{widgets}[$cpronto->{current}] != $cpronto->{message_list}->{server_button}) {
		return;
	}
	my ($messageid,$row,$current_status,$command, $selectedtask);

	$row = $cpronto->{message_list}->get_selected();
	$messageid = $cpronto->{message_list}->get_item_data($row,2);
	$current_status = $cpronto->{message_list}->get_item_data($row,6);
	if($current_status != 0) {
		if($current_status == 2 || $current_status == 1) {
			&Pronto::Data::Message::set_server_status(($messageid),3);
			$selectedtask = "Delete from server :";
			$cpronto->{message_list}->set_item_data($row,6,3);

		} elsif ($current_status == 3) {
			&Pronto::Data::Message::set_server_status(($messageid),4); 
			$selectedtask = "Fetch from server :";
			$cpronto->{message_list}->set_item_data($row,6,4);

		} elsif ($current_status == 4) {
			&Pronto::Data::Message::set_server_status(($messageid),5);
			$cpronto->{message_list}->set_item_data($row,6,5);
			$selectedtask = "Fetch & Delete from server :";
			
		} elsif ($current_status == 5) {
			&Pronto::Data::Message::set_server_status(($messageid),2);
			$cpronto->{message_list}->set_item_data($row,6,2);
			$selectedtask = "Leave on server :";
		}
	}
	if(defined $selectedtask) {
		&show_messages(1);
		&display_dialog_message("$selectedtask $messageid");
		$cpronto->{message_list}->select_row($row);
	}
	return;
}

sub init_text_widget {
	my ($editable) = @_;
	my ($i,$j);
	$j = $cpronto->{num_widgets};
	for ($i = 0; $i < $j; $i++) {
		$cpronto->{widgets}[0]->hide();
		$cpronto->remove_widget($cpronto->{widgets}[0]);
	}
	
	$cpronto->add_widget($cpronto->{text_box}->{from_entry});
	$cpronto->add_widget($cpronto->{text_box}->{to_entry});
	$cpronto->add_widget($cpronto->{text_box}->{subj_entry});
	$cpronto->add_widget($cpronto->{text_box}->{cc_entry});
	$cpronto->add_widget($cpronto->{text_box}->{att_entry});
	$cpronto->add_widget($cpronto->{text_box}->{from_label});
	$cpronto->add_widget($cpronto->{text_box}->{to_label});
	$cpronto->add_widget($cpronto->{text_box}->{subj_label});
	$cpronto->add_widget($cpronto->{text_box}->{cc_label});
	$cpronto->add_widget($cpronto->{text_box}->{att_label});
	$cpronto->add_widget($cpronto->{text_box});
	if ($editable == 1) {
		$cpronto->{text_box}->{ok_button}->{label} = "Send";
	} else {
		$cpronto->{text_box}->{ok_button}->{label} = "Back";
	}

	$cpronto->add_widget($cpronto->{text_box}->{ok_button});
	$cpronto->add_widget($cpronto->{text_box}->{cancel_button});
	if ($editable == 0) {
		$cpronto->add_widget($cpronto->{text_box}->{att_button});
	} elsif ($editable == 1) {
		$cpronto->add_widget($cpronto->{text_box}->{book_button});
	}
	$cpronto->add_widget($cpronto->{list_button});
	$cpronto->add_widget($cpronto->{new_button});
	$cpronto->add_widget($cpronto->{quit_button});

	$cpronto->{text_box}->{editable} = $editable;
	$cpronto->{text_box}->{xpos} = 0,
	$cpronto->{text_box}->{ypos} = 0,
	$cpronto->{text_box}->{current_line} = 0;
	$cpronto->{text_box}->{top_line} = 0;
	$cpronto->{text_box}->{position} = 0;
	$cpronto->{text_box}->{from_entry}->{editable} = $editable;
	$cpronto->{text_box}->{to_entry}->{editable} = $editable;
	$cpronto->{text_box}->{subj_entry}->{editable} = $editable;
	$cpronto->{text_box}->{cc_entry}->{editable} = $editable;
	$cpronto->{text_box}->{att_entry}->{editable} = $editable;
	$cpronto->{text_box}->{from_entry}->set_text("");
	$cpronto->{text_box}->{to_entry}->set_text("");
	$cpronto->{text_box}->{subj_entry}->set_text("");
	$cpronto->{text_box}->{cc_entry}->set_text("");
	$cpronto->{text_box}->{att_entry}->set_text("");
	$cpronto->{text_box}->{attachments} = ();

	if ($cpronto->{status} == 0) {
		$cpronto->{text_box}->{cancel_button}->signal_connect("activate",\&show_folders);
	} elsif ($cpronto->{status} == 1) {
		$cpronto->{text_box}->{cancel_button}->signal_connect("activate",\&show_messages);
	}

	if ($editable == 1) {
		$cpronto->{text_box}->{ok_button}->signal_connect("activate",\&send);
	} else {
		$cpronto->{text_box}->{ok_button}->signal_connect("activate",\&{$cpronto->{text_box}->{cancel_button}->{activate}});
	}
	$cpronto->{status} = 3;
	return;
}

sub send {
	my ($from,$to,$cc,$bcc,$subject,$body,$sender,$att) = ("","","","","","","");
	my ($messageid);
	my $action = $cpronto->{text_box}->{type};
	&display_dialog_message("Sending message");
	$messageid = $cpronto->{message_list}->get_item_data($cpronto->{message_list}->get_selected(),2);
	#be paranoid
	if (!$messageid && $action !=0) {
		&display_dialog_message("Erm, something is horribly wrong");
		return 1;
	}	

#	$cpronto->{text_box}->{type};   0 = new;  1 = reply; 2 = forward
	$to = $cpronto->{text_box}->{to_entry}->get_text();
	$from = $cpronto->{text_box}->{from_entry}->get_text();
	$subject = $cpronto->{text_box}->{subj_entry}->get_text();
	$cc = $cpronto->{text_box}->{cc_entry}->get_text();
	$att = $cpronto->{text_box}->{att_entry}->get_text();
	$body = $cpronto->{text_box}->get_text();

	#check for a to
	if ($to eq "") { 
		&display_dialog_message("You gotta send the message to some one !");
		return 1;
	}	
	my ($defaultmime,$defaultenc,$replymessage,$sql,$query,@row,$acctid,$mimemail,$mimetype,$mimeencode);

	$defaultmime = "application/x-unknown";
	$defaultenc = "base64";
	#get default account info to reply
	$sql = "select id,friendly,reply from accounts where def = 'y'";
	$query=$conn->prepare($sql);
	$query->execute();
	if (@row = $query->fetchrow_array()) {
		 $acctid = $row[0];
		 $from = "$row[1] <$row[2]>";
	} else {
		&display_dialog_message("Could not extract account info");
		return 1;
	}	
	#are we replying or forwarding, if so check for the subject so we dont relpicate Re's and fw's
	if ($action == 1) {
		unless ($subject =~ /^Re: /i) { $subject = "Re: ".$subject; }
	} elsif ($action == 2) {
		unless ($subject =~ /^Fw: /i) { $subject = "Fw: ".$subject; }
	}

	$Text::Wrap::columns = $prefs{'WrapAfter'};
	$body =~ s!(^[^>|+#}=):\%\@\$\?\r\n].*$)! &Text::Wrap::wrap("","",$1) !gem;

	my $date = &date_now;
	my $localdate = &date_to_localdate($date);
	my $msgid = scalar(localtime) . "\@$from";

	$mimemail = build MIME::Entity(	From		=>	$from,
					To		=>	$to,
	 				CC		=>	$cc,
					'Reply-To'	=>	$from,
					Subject		=>	$subject,
					'X-Mailer'	=>	"CPronto ".$version,
					Date		=>	&UnixDate(&ParseDateString("epoch ".time()),"%d %b %Y %H:%M:%S %Z"),
					Data		=>	$body);
	if ($action == 1) {
		$sql = "select msgid,ref from messages where id = '$messageid'";
		$query = $conn->prepare($sql);
		$query->execute();
		my ($replyid,$ref) = $query->fetchrow_array();
		$mimemail->head->add('In-Reply-To',$replyid);  
	
		if (!$ref) {
      			$mimemail->head->add('References',$replyid);
		} else {
			$mimemail->head->add('References',$ref);
		}
	}
	if ($att ne "") { 
		my @attach = split(/,/,$att);
		my $tmp;
		if (scalar(@attach)>0) {
			for ($tmp = 0; $tmp<scalar(@attach); $tmp++){
				if (-f "$attach[$tmp]") {
					($mimetype,$mimeencode) = MIME::Types::by_suffix($attach[$tmp]);
					if (!defined $mimetype || $mimetype eq ""){
						$mimetype = $defaultmime;
						$mimeencode = $defaultenc;
					}
					$mimemail->attach( 	Path=>$attach[$tmp],
								Type=>$mimetype,
							       	Encoding=>$mimeencode);
				}		       
		       }
	       }
	}
	$body = $mimemail->as_string;

	my $folder = 2;
	my $priority="normal";
	my $tmp;
	if ($prefs{'MsgInDB'} eq "n") {
		$sql = "insert into messages (id, accountid, sentfrom, sentto, subject, cc, bcc,
		         localdate, boxid, contenttype, date, msgid, friendly, priority) values
		         (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
		$query=$conn->prepare($sql);
		my $newid = &newid('messages', $conn);
		$query->execute($newid, $acctid, $from, $to, $subject, $cc, $bcc, $localdate, $folder, $mimemail->mime_type(), $date,$msgid,&process_from($to),$priority);
		$tmp = filename_to_tree("$prefs{'MailDir'}/$newid");
		open(TMP,">$tmp");
        	print TMP $body;
		close(TMP);
	} else {
		$sql = "insert into messages (id, accountid, sentfrom, sentto, subject, cc, bcc,
		         localdate, boxid, contenttype, date, msgid, friendly, priority) values
		         (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
		$query = $conn->prepare($sql);
		my $newid = &newid('messages', $conn);
		$query->execute($newid, $acctid, $from, $to, $subject, $cc, $bcc, $localdate, $folder, $mimemail->mime_type(), $date,$msgid,&process_from($to),$priority);

		$sql = "insert into message_sources (id,bodytext) values (?,?)";
		$query=$conn->prepare($sql);
		$query->execute($newid,$body);
		$query->finish();
		
	}
	if ($action !=0) {
		$sql = "update messages set replyf = '$action' where id = $messageid";
		$query = $conn->prepare($sql);
		$query->execute();
		$query->finish()
       	}

	if ($prefs{'SendImmediately'} eq "y") { 
		&send_out();
	}
	
	&{$cpronto->{text_box}->{cancel_button}->{activate}};
	return;
}

sub compose {
	my ($i,$j,$command,$from);
	&init_text_widget(1);
	&display_dialog_message("Compose new message");

	$cpronto->change_widget($cpronto->{text_box}->{to_entry});
	$cpronto->{text_box}->set_text("");
	$j = $cpronto->{num_widgets};
	for ($i = 0; $i < $j; $i++) {
		$cpronto->{widgets}[$i]->show();
	}
	$command = $conn->prepare("select friendly from accounts where def = 'y'");
	$command->execute();
	($from) = $command->fetchrow_array();
	$command->finish();

	$cpronto->{text_box}->{type} = 0;
	$cpronto->{text_box}->{from_entry}->set_text($from);
	$cpronto->{text_box}->{from_entry}->show();
	$cpronto->{text_box}->{to_entry}->focus();
	return;
}

sub forward_message {
	if ($cpronto->{widgets}[$cpronto->{current}] != $cpronto->{message_list} && $cpronto->{widgets}[$cpronto->{current}] != $cpronto->{message_list}->{for_button}) {
		return;
	}

	my ($messageid,$i,$j,$text,$from,$to,$subj,$cc,$command);
	$messageid = $cpronto->{message_list}->get_item_data($cpronto->{message_list}->get_selected(),2);

	&init_text_widget(1);
	&display_dialog_message("Forwarding $messageid");
	
	$cpronto->change_widget($cpronto->{text_box}->{to_entry});
	$text = get_message_text(0,2,$messageid);
	
	$command = $conn->prepare("select subject,cc from messages where id = ?");
	$command->execute($messageid);
	($subj,$cc) = $command->fetchrow_array();
	$command->finish();

	$command = $conn->prepare("select friendly from accounts where def = 'y'");
	$command->execute();
	($from) = $command->fetchrow_array();
	$command->finish();

	$cpronto->{text_box}->set_text("$text");
	$cpronto->{text_box}->{from_entry}->set_text($from);
	
	unless ($subj =~ /^Fw: /i) {
		$subj = "Fw: " . $subj;
	}
	
	$cpronto->{text_box}->{subj_entry}->set_text($subj);

	$j = $cpronto->{num_widgets};
	for ($i = 0; $i < $j; $i++) {
		$cpronto->{widgets}[$i]->show();
	}
	$cpronto->{text_box}->{type} = 2;

	$cpronto->{text_box}->{to_entry}->focus();
	return;
}

sub reply_message {
	if ($cpronto->{widgets}[$cpronto->{current}] != $cpronto->{message_list} && $cpronto->{widgets}[$cpronto->{current}] != $cpronto->{message_list}->{reply_button}) {
		return;
	}

	my ($messageid,$i,$j,$text,$from,$to,$subj,$cc,$command);
	$messageid = $cpronto->{message_list}->get_item_data($cpronto->{message_list}->get_selected(),2);
	&init_text_widget(1);

	&display_dialog_message("Replying to $messageid");

	$cpronto->change_widget($cpronto->{text_box});
	$text = get_message_text(0,1,$messageid);
	
	$command = $conn->prepare("select sentfrom,replyto,subject,cc from messages where id = ?");
	$command->execute($messageid);
	($from,$to,$subj,$cc) = $command->fetchrow_array();
	$command->finish();
	if (!$to) {
		$to = $from;
	}

	$command = $conn->prepare("select friendly from accounts where def = 'y'");
	$command->execute();
	($from) = $command->fetchrow_array();
	$command->finish();

	$cpronto->{text_box}->set_text("$text");
	$cpronto->{text_box}->{from_entry}->set_text($from);
	$cpronto->{text_box}->{to_entry}->set_text($to);
	
	unless ($subj =~ /^Re: /i) {
		$subj = "Re: " . $subj;
	}	
	
	$cpronto->{text_box}->{subj_entry}->set_text($subj);

	$j = $cpronto->{num_widgets};
	for ($i = 0; $i < $j; $i++) {
		$cpronto->{widgets}[$i]->show();
	}
	$cpronto->{text_box}->{type} = 1;

	$cpronto->{text_box}->focus();
	return;
}

sub read_message {
	my ($messageid,$i,$j,$text,$from,$to,$subj,$cc,$command,$new,$att,@a);
	$messageid = $cpronto->{message_list}->get_item_data($cpronto->{message_list}->get_selected(),2);
	$new = $cpronto->{message_list}->get_item_data($cpronto->{message_list}->get_selected(),0);
	if ($new eq "New") {
		$cpronto->{message_list}->set_item_data($cpronto->{message_list}->get_selected(),0,"");
		$command = $conn->prepare("update messages set newmsg = 'n' where id = ?");
		$command->execute($messageid);
		$command->finish();
	}

	&init_text_widget(0);
	&display_dialog_message("Reading $messageid");

	$cpronto->change_widget($cpronto->{text_box});
	$text = &get_message_text(0,0,$messageid);

	$command = $conn->prepare("select friendly,sentto,subject,cc from messages where id = ?");
	$command->execute($messageid);
	($from,$to,$subj,$cc) = $command->fetchrow_array();
	$command->finish();

	$att = "";
	for ($i = 0; $i <= $#{$cpronto->{text_box}->{attachments}}; $i++) {
		$att = $att.", $cpronto->{text_box}->{attachments}[$i][0]";
	}
	substr($att,0,2) = "";

	$cpronto->{text_box}->set_text($text);
	$cpronto->{text_box}->{from_entry}->set_text($from);
	$cpronto->{text_box}->{to_entry}->set_text($to);
	$cpronto->{text_box}->{subj_entry}->set_text($subj);
	$cpronto->{text_box}->{cc_entry}->set_text($cc);
	$cpronto->{text_box}->{att_entry}->set_text($att);


	$j = $cpronto->{num_widgets};
	for ($i = 0; $i < $j; $i++) {
		$cpronto->{widgets}[$i]->show();
	}
	$cpronto->{text_box}->focus();
	return;
}

sub show_messages {
	my ($refreshlist) = @_;
	my ($folderid,$foldername,$i,$j);
	$foldername = $cpronto->{folder_list}->get_item_data($cpronto->{folder_list}->get_selected(),0);
	$folderid = $foldername_to_id{$foldername};
	&display_dialog_message("Messages in $foldername");

	$j = $cpronto->{num_widgets};
	for ($i = 0; $i < $j; $i++) {
		$cpronto->{widgets}[0]->hide();
		$cpronto->remove_widget($cpronto->{widgets}[0]);
	}
	$cpronto->add_widget($cpronto->{message_list});
	$cpronto->add_widget($cpronto->{message_list}->{ok_button});
	$cpronto->add_widget($cpronto->{message_list}->{delete_button});
	$cpronto->add_widget($cpronto->{message_list}->{reply_button});
#	$cpronto->add_widget($cpronto->{message_list}->{replyall_button});
	$cpronto->add_widget($cpronto->{message_list}->{for_button});
	$cpronto->add_widget($cpronto->{message_list}->{move_button});
	$cpronto->add_widget($cpronto->{message_list}->{copy_button});
	$cpronto->add_widget($cpronto->{message_list}->{server_button});
	$cpronto->add_widget($cpronto->{help_button});
	$cpronto->add_widget($cpronto->{check_button});
	$cpronto->add_widget($cpronto->{list_button});
	$cpronto->add_widget($cpronto->{new_button});
	$cpronto->add_widget($cpronto->{quit_button});

	$cpronto->change_widget($cpronto->{message_list});

	if (($cpronto->{current_folderid} != $folderid) || $refreshlist) {
		$cpronto->{current_folderid} = $folderid;
		my $j = $#{$cpronto->{messages}};
		for ($i = 0; $i <= $j; $i++) {
			$cpronto->{message_list}->del_row(0);
		}
		&read_messages($folderid);
		for ($i = 0; $i <= $#{$cpronto->{messages}}; $i++) {
			$cpronto->{message_list}->add_row($i,\@{$cpronto->{messages}[$i]});
		}
	}
	$j = $cpronto->{num_widgets};
	for ($i = 0; $i < $j; $i++) {
		$cpronto->{widgets}[$i]->show();
	}
	$cpronto->{status} = 1;
	$cpronto->{message_list}->focus();
	return;
}

sub show_folders {
	my ($i,$j);
	$j = $#{$cpronto->{folders}};
	for ($i = 0; $i <= $j; $i++) {
		$cpronto->{folder_list}->del_row(0);
	}
	&read_folders();
	for ($i = 0; $i <= $#{$cpronto->{folders}}; $i++) {
		$cpronto->{folder_list}->add_row($i,\@{$cpronto->{folders}[$i]});
	}

	&display_dialog_message("Folders");

	$j = $cpronto->{num_widgets};
	for ($i = 0; $i < $j; $i++) {
		$cpronto->{widgets}[0]->hide();
		$cpronto->remove_widget($cpronto->{widgets}[0]);
	}
	$cpronto->add_widget($cpronto->{folder_list});
	$cpronto->add_widget($cpronto->{folder_list}->{ok_button});
#	$cpronto->add_widget($cpronto->{folder_list}->{delete_button});
#	$cpronto->add_widget($cpronto->{folder_list}->{add_button});
	$cpronto->add_widget($cpronto->{help_button});
	$cpronto->add_widget($cpronto->{check_button});
	$cpronto->add_widget($cpronto->{list_button});
	$cpronto->add_widget($cpronto->{new_button});
	$cpronto->add_widget($cpronto->{quit_button});

	$cpronto->change_widget($cpronto->{folder_list});

	$j = $cpronto->{num_widgets};
	for ($i = 0; $i < $j; $i++) {
		$cpronto->{widgets}[$i]->show();
	}
	$cpronto->{status} = 0;
	$cpronto->{folder_list}->focus();
	return;
}

sub read_folders {
	my ($command,$i,@a);

	$command = $conn->prepare("select name,id from boxlist");
	$command->execute();
	$i = 0;
	$cpronto->{folders} = ();
	while (@a = $command->fetchrow_array()) {
		if ($a[1] >= 1000) {
			#FIX
			#write vfolder stuff
			next;
		}
		if ($a[0] eq "Folders") {
			#not really a folder
			next;
		}
		$cpronto->{folders}[$i][0] = $a[0];
		$foldername_to_id{$a[0]} = $a[1];
		$folder_id_to_list_position{$a[1]} = $i;
		$i++;
	}
	$command->finish();
	for ($i = 0; $i <= $#{$cpronto->{folders}}; $i++) {
		$cpronto->{folders}[$i][1] = 0;
		$cpronto->{folders}[$i][2] = 0;
		$command = $conn->prepare("select newmsg from messages where boxid=?");
		$command->execute($foldername_to_id{$cpronto->{folders}[$i][0]});
		while (@a = $command->fetchrow_array()) {
			if (($a[0]) and ($a[0] eq "y")) {
				$cpronto->{folders}[$i][2]++;
			}
			$cpronto->{folders}[$i][1]++;
		}
		$command->finish();
	}
	return;
}

sub read_messages {
	my ($folderid) = @_;
	my ($command,$i,@a);
#	display_dialog_message("Folder id is $folderid");
	$cpronto->{messages} = ();
	$command = $conn->prepare("select newmsg,replyf,contenttype,id,friendly,subject,localdate,serverstat from messages where boxid=? order by localdate desc");
	$command->execute($folderid);
	while (@a = $command->fetchrow_array()) {
		$cpronto->{messages}[$i] = [ @a ];
		$cpronto->{messages}[$i][0] =~ s/n/   /;
		$cpronto->{messages}[$i][0] =~ s/y/New/;
		if ($cpronto->{messages}[$i][1] == 1) {
				$cpronto->{messages}[$i][1] = "R";
		} elsif ($cpronto->{messages}[$i][1] == 2) {
				$cpronto->{messages}[$i][1] = "F";
		} else {
				$cpronto->{messages}[$i][1] = " ";
		}
		if (($a[2]) && ($a[2] !~ /text/i) && ($a[2] !~ /alternative/i) && ($a[2] !~ /multipart\/report/i)) {
			$cpronto->{messages}[$i][1] .= "A";
		} else { 
			$cpronto->{messages}[$i][1] .= " ";
		}
		if (defined $a[7] && $a[7] == 1) { 
			$cpronto->{messages}[$i][1] .= "P";	# Message is still on server and has NOT been fetched.
								# 
		} elsif (defined $a[7] && ($a[7] == 2 || $a[7] == 6)) { 
			$cpronto->{messages}[$i][1] .= "S"; 	# Message is still on server and has been fetched. 
								#
		} elsif (defined $a[7] && $a[7] == 3) { 
			$cpronto->{messages}[$i][1] .= "d";	# Message is flagged for deletion. 
								#
		} elsif (defined $a[7] && $a[7] == 4) { 
			$cpronto->{messages}[$i][1] .= "f";	# Message is flagged for fetching. 
								#
		} elsif (defined $a[7] && $a[7] == 5) { 
			$cpronto->{messages}[$i][1] .= "D";	# Message is flagged for fetching & deletion. 
								#
		} else { 
			$cpronto->{messages}[$i][1] .= " ";	# Message is not on server.
								#
		}
		
		splice(@{$cpronto->{messages}[$i]},2,1);
		$cpronto->{messages}[$i][5] = &localdate_to_displaydate($a[6]);
		$i++;
	}
	$command->finish();
}


sub quit {
	$conn->disconnect();
	$cpronto->clear();
	$cpronto->quit();
	for ($i = 0; $i <= $#{$cpronto->{widgets}}; $i++) {
		$cpronto->remove_widget($cpronto->{widgets}[0]);
	}
	exit();
}

sub get_message_text {
	my ($vtype,$format,$msgid) = @_;
	my ($command,$entity,@parts,$num_parts,$type,$body,$view_part,$file,%entity,$part,$io,$i,@a,@otherparts);
	if ($main::prefs{'MsgInDB'} eq "n") {
       		$file = &filename_to_tree("$prefs{'MailDir'}/$msgid");
		if (open (FILE,"<$file")) {
		} else {
			&display_dialog_message("Unable to open msg file for parsing");
			return 1;
		}
	 } else {
		$command = $conn->prepare("select bodytext from message_sources where id = ?");
		$command->execute($msgid);
		$file = $command->fetchrow_array();
		open(TMP,">$main::prefs{'MailDir'}/tmp/dump");
		print TMP $file;
		close(TMP);
		open(FILE,"<$main::prefs{'MailDir'}/tmp/dump");
		$command->finish();
	}
	$entity{$msgid}=$parser->read(\*FILE);
	close(FILE);

	if (defined $entity{$msgid}) {

		if ($vtype == 1) {    # the viewer wants a header.....
			$body = $entity{$msgid}->stringify_header;
			$type = "text/plain";
			return $body;
		} else {        # the viewer wants the body
			$num_parts=$entity{$msgid}->parts;
		}

		if ($num_parts == 0) { # single part message
			$parts[0] = $entity{$msgid};
		} else { # multipart message
			@parts = $entity{$msgid}->parts;
		}
			    
		$i = 0;
		foreach $part (@parts) {
			$type = $part->mime_type;
			my $rec_filename = $part->head->recommended_filename;
       			if ($rec_filename ne "") {
				@a = stat("$ENV{'HOME'}/.pronto/tmp/$_");
				$a[7] = $a[7]/1024;
				$cpronto->{text_box}->{attachments}[$i][0] = $rec_filename;
				$cpronto->{text_box}->{attachments}[$i][1] = $type;
				$cpronto->{text_box}->{attachments}[$i][2] = $a[7];
				$i++;
			}
			if ($type =~ /multipart/i or $type=~ /message\/rfc/i) {   # this is a multipart part, so lets flatten
				push @parts, $part->parts;
			}
			if (($vtype == 0) and ($type =~ /text\/html/i)) {   #  we are looking for an HTML part and found one!
				if (not defined $view_part) { 
					$view_part = $part; 
				}  # we only want the FIRST HTML part...
			} elsif ($type =~ /text\/plain/i) {                  # we are looking for TEXT parts...
				if (not defined $view_part) { 
					$view_part = $part; 
				} else {
					push @otherparts,$part;
				}	
			}
		}	
			
       		if (defined $view_part) {
			if ($io=$view_part->open("r")) {
	       			$body="";
	       			undef $/;
	       			$body=$io->getline;
	       			$/="\n";
	       			$io->close;
	       			$type=$view_part->mime_type;
	       		} 
       			if (scalar(@otherparts)>0) {
       				foreach my $extra (@otherparts) {
       					if ($io=$extra->open("r")) {
       						$body=$body."\n\n --- Next Part --- \n\n";
       						undef $/;
       						my $next = $io->getline;
       						$/="\n";
       						$io->close;
       						$body = $body . $next
       					}
       				}	
       			}
       		} else { 
       			$body = "No viewable part found.";
			$type="text/plain";
       		}
		
       	} else { #appearntly Parser barfed.
			$body = "Unable to decode message. Please contact Pronto maintainers at pronto\@muhri.net.";
			$type = "text/plain";
       	}
	

	$Text::Wrap::columns = $cpronto->{cols}-3;
	$body = &Text::Wrap::wrap("","",$body);

	if ($format == 0) {
		return $body;
	} elsif ($format == 1) {
		if (defined $prefs{'QuoteWith'}) {
			$body = $prefs{'QuoteWith'}  . $body;
			$body =~ s/\n/\n$prefs{'QuoteWith'} /g;
		}
		$command = $conn->prepare("select date,friendly from messages where id = ?");
		$command->execute($msgid);
		my ($quotedate, $quotename) = ($command->fetchrow_array());
		my $prefix = $prefs{'QuoteHeader'};
		$prefix =~ s/%n/$quotename/g;
		$prefix =~ s/%d/$quotedate/g;
		unless (!$prefix) { 
			$body = $prefix . "\n\n" . $body; 
		}
		$command->finish();
		return $body;
	} else {
		if ($prefs{'ForwardHeader'} eq "y") {
			$command = $conn->prepare("select date,replyto,sentfrom,subject,sentto from messages where id = ?");
				$command->execute($msgid);
			my ($fdate, $reply, $from, $subject, $to) = ($command->fetchrow_array());
			if (!$reply) { 
				$reply = $from;
			}
			$command->finish();
			my $forwardheader = "  \n\n--- Forwarded Message ---\n From: $reply\n To: $to\n Sent: $fdate\n Subject: $subject";
			$body = $forwardheader . "\n\n" . $body;
		}
		return ($body);
	}
}

sub display_dialog_message {
	my ($message) = @_;
	$cpronto->addstring($cpronto->{rows}-2,2," "x($cpronto->{cols}-5));
	$cpronto->addstring($cpronto->{rows}-2,2,"$message");
	return;
}

sub send_out {
	open(TMP,"prontosend 2>&1 |");
	while (<TMP>) {
		if (/error/i) { 
			&display_dialog_message("An error occured while sending!"); 
		}
	}
	close(TMP);
	return;
}	

sub check_mail {
	my ($i,$j);
	&display_dialog_message("Checking Mail");
 	if (open(TMP,"<$prefs{'MailDir'}/prontoget.running")) {
		my $proc = <TMP>;
		if(kill(0,$proc)) {
			&display_dialog_message("Prontoget is already running.");
                	return;
        	}
		else {
			close(TMP);
                	unlink "$prefs{'MailDir'}/prontoget.running";
        	}

	}

	$Pronto::Get::inter = 0; 
	$Pronto::Get::called_from_get = 0; 
	&Pronto::Get::get();

	if ($prefs{'SendImmediately'} eq "n") {
		&display_dialog_message("Sending Mail");
		&send_out();
       	}
	if ($cpronto->{status} == 0) {
		$cpronto->{current_folderid} = -1;
		&read_folders();
		&show_folders();
		return;
	} elsif ($cpronto->{status} == 1) {
		$cpronto->{current_folderid} = -1;
		&show_messages();
		return;
	}
	return;
}

sub blank {
	return;
}
