#ifndef INCLUDE_SUPPORT_H
#define INCLUDE_SUPPORT_H
/* ----------------------------------------------------------------------------
 * support.h
 * prototypes and definitions for glade-2 support functions.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "gettext_macros.h"

/* public prototypes. */
GtkWidget* lookup_widget (GtkWidget *widget, const gchar *widget_name);
void add_pixmap_directory (const gchar *directory);

/* private prototypes */
GtkWidget* create_pixmap (GtkWidget *widget, const gchar *filename);
GdkPixbuf* create_pixbuf (const gchar *filename);
void glade_set_atk_action_description (AtkAction *action, const gchar *action_name, const gchar *description);

#endif    /* INCLUDE_SUPPORT_H */
