<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html"/>
<xsl:template match="/">
   <xsl:apply-templates />
</xsl:template>

<xsl:template match="pointless">
<html>
<head>
   <title><xsl:value-of select="title/text()"/></title>
   <link rel="stylesheet" type="text/css" href="pointlesshtml.css" />
   <style type="text/css">
      div.slide { background-image: url(<xsl:value-of select="/pointless/background/@src"/>); }
   </style>
</head>
<body>
   <h1><xsl:value-of select="title/text()"/></h1>
   <xsl:apply-templates select="slide"/>
</body>
</html>
</xsl:template>

<xsl:template match="pointless/title">
   
</xsl:template>

<xsl:template match="background" />

<xsl:template match="fonts" />

<xsl:template match="slide">
<div class="slide">
   <span class="name"><xsl:value-of select="name"/></span>
<xsl:apply-templates />
</div>
</xsl:template>

<xsl:template match="name" />

<xsl:template match="par">
<p>
<xsl:apply-templates />
</p>
</xsl:template>

<xsl:template match="note">
<div class="note">
<xsl:value-of select="." />
</div>
</xsl:template>


<xsl:template match="slide/title">
<center><h2><xsl:apply-templates /></h2></center>
</xsl:template>

<xsl:template match="centre">
<center><xsl:apply-templates /></center>
</xsl:template>

<xsl:template match="em"><i><xsl:apply-templates /></i></xsl:template>
<xsl:template match="large"><span class="large"><xsl:apply-templates /></span></xsl:template>
<xsl:template match="small"><span class="small"><xsl:apply-templates /></span></xsl:template>

<xsl:template match="list">
<ul>
<xsl:apply-templates />
</ul>
</xsl:template>

<xsl:template match="li"><li><xsl:apply-templates /></li></xsl:template>

<xsl:template match="image">
   <xsl:if test="@pos=''">
      <img src="{@src}" alt="{@alt}"/>
   </xsl:if>
   <xsl:if test="@pos='=center'">
      <center><img src="{@src}" alt="{@alt}"/></center>
   </xsl:if>
</xsl:template>

<xsl:template match="step"/>
<xsl:template match="br"><br /></xsl:template>

</xsl:stylesheet>
