/*
     PLIB - A Suite of Portable Game Libraries
     Copyright (C) 1998,2002  Steve Baker

     This library is free software; you can redistribute it and/or
     modify it under the terms of the GNU Library General Public
     License as published by the Free Software Foundation; either
     version 2 of the License, or (at your option) any later version.

     This library is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     Library General Public License for more details.
 
     You should have received a copy of the GNU Library General Public
     License along with this library; if not, write to the Free
     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

     For further information visit http://plib.sourceforge.net

     $Id: ssgLoadMDL_BGLTexture.cxx,v 1.5 2002/09/02 06:05:48 sjbaker Exp $
*/

//===========================================================================
//
// File: ssgLoadMDL_BGLTexture.cxx
//
// Created: Jun 1 22:20:31 2002
//
// Author: Thomas Engh Sevaldrud <tse@math.sintef.no>
//         Juergen Marquardt <juergen_marquardt@t-online.de>
//
// Revision: $Id: ssgLoadMDL_BGLTexture.cxx,v 1.5 2002/09/02 06:05:48 sjbaker Exp $
//
// Description:
//
// Changes:  by Juergen Marquardt
//           - separated from ssgLoadMDL
//             it's now used by ssgLoadMDL and ssgLoadBGL
//           - added support for translucatant textures
//           - rindex replaced by strrchr
//
//===========================================================================

#include "ssgLocal.h"
#include "ssgMSFSPalette.h"

//===========================================================================
// Texture palette values (from fs5.pal)
// Alpha channel added for more efficient
// rendering on 3dfx hardware.

unsigned const char ssgFsTexPalette[1024] = {
  0x00, 0x00, 0x00, 0xff,
  0x08, 0x08, 0x08, 0xff,
  0x10, 0x10, 0x10, 0xff,
  0x18, 0x18, 0x18, 0xff,
  0x20, 0x20, 0x20, 0xff,
  0x28, 0x28, 0x28, 0xff,
  0x30, 0x30, 0x30, 0xff,
  0x38, 0x38, 0x38, 0xff,
  0x41, 0x41, 0x41, 0xff,
  0x49, 0x49, 0x49, 0xff,
  0x51, 0x51, 0x51, 0xff,
  0x59, 0x59, 0x59, 0xff,
  0x61, 0x61, 0x61, 0xff,
  0x69, 0x69, 0x69, 0xff,
  0x71, 0x71, 0x71, 0xff,
  0x79, 0x79, 0x79, 0xff,
  0x82, 0x82, 0x82, 0xff,
  0x8a, 0x8a, 0x8a, 0xff,
  0x92, 0x92, 0x92, 0xff,
  0x9a, 0x9a, 0x9a, 0xff,
  0xa2, 0xa2, 0xa2, 0xff,
  0xaa, 0xaa, 0xaa, 0xff,
  0xb2, 0xb2, 0xb2, 0xff,
  0xba, 0xba, 0xba, 0xff,
  0xc3, 0xc3, 0xc3, 0xff,
  0xcb, 0xcb, 0xcb, 0xff,
  0xd3, 0xd3, 0xd3, 0xff,
  0xdb, 0xdb, 0xdb, 0xff,
  0xe3, 0xe3, 0xe3, 0xff,
  0xeb, 0xeb, 0xeb, 0xff,
  0xf7, 0xf7, 0xf7, 0xff,
  0xff, 0xff, 0xff, 0xff,
  0x15, 0x05, 0x05, 0xff,
  0x2a, 0x0a, 0x0a, 0xff,
  0x3f, 0x0f, 0x0f, 0xff,
  0x54, 0x14, 0x14, 0xff,
  0x69, 0x19, 0x19, 0xff,
  0x7e, 0x1e, 0x1e, 0xff,
  0x93, 0x23, 0x23, 0xff,
  0xa8, 0x28, 0x28, 0xff,
  0xbd, 0x2d, 0x2d, 0xff,
  0xd2, 0x32, 0x32, 0xff,
  0xe7, 0x37, 0x37, 0xff,
  0xfc, 0x3c, 0x3c, 0xff,
  0x05, 0x15, 0x05, 0xff,
  0x0a, 0x2a, 0x0a, 0xff,
  0x0f, 0x3f, 0x0f, 0xff,
  0x14, 0x54, 0x14, 0xff,
  0x19, 0x69, 0x19, 0xff,
  0x1e, 0x7e, 0x1e, 0xff,
  0x23, 0x93, 0x23, 0xff,
  0x28, 0xa8, 0x28, 0xff,
  0x2d, 0xbd, 0x2d, 0xff,
  0x32, 0xd2, 0x32, 0xff,
  0x37, 0xe7, 0x37, 0xff,
  0x3c, 0xfc, 0x3c, 0xff,
  0x00, 0x07, 0x17, 0xff,
  0x00, 0x0f, 0x28, 0xff,
  0x00, 0x17, 0x3a, 0xff,
  0x00, 0x28, 0x54, 0xff,
  0x00, 0x40, 0x68, 0xff,
  0x00, 0x47, 0x7a, 0xff,
  0x00, 0x57, 0x8f, 0xff,
  0x00, 0x63, 0x9c, 0xff,
  0x00, 0x70, 0xb3, 0xff,
  0x00, 0x80, 0xc7, 0xff,
  0x00, 0x8f, 0xd7, 0xff,
  0x00, 0x99, 0xe6, 0xff,
  0x1c, 0x0e, 0x00, 0xff,
  0x38, 0x1c, 0x00, 0xff,
  0x54, 0x2a, 0x00, 0xff,
  0x70, 0x38, 0x00, 0xff,
  0x8c, 0x46, 0x00, 0xff,
  0xa8, 0x54, 0x00, 0xff,
  0xc4, 0x62, 0x00, 0xff,
  0xe0, 0x70, 0x00, 0xff,
  0xfc, 0x7e, 0x00, 0xff,
  0x1c, 0x1c, 0x00, 0xff,
  0x38, 0x38, 0x00, 0xff,
  0x54, 0x54, 0x00, 0xff,
  0x70, 0x70, 0x00, 0xff,
  0x8c, 0x8c, 0x00, 0xff,
  0xa8, 0xa8, 0x00, 0xff,
  0xc4, 0xc4, 0x00, 0xff,
  0xe0, 0xe0, 0x00, 0xff,
  0xfc, 0xfc, 0x00, 0xff,
  0x19, 0x15, 0x10, 0xff,
  0x32, 0x2a, 0x20, 0xff,
  0x4b, 0x3f, 0x30, 0xff,
  0x64, 0x54, 0x40, 0xff,
  0x7d, 0x69, 0x50, 0xff,
  0x96, 0x7e, 0x60, 0xff,
  0xaf, 0x93, 0x70, 0xff,
  0xc8, 0xa8, 0x80, 0xff,
  0xe1, 0xbd, 0x90, 0xff,
  0x1c, 0x0b, 0x07, 0xff,
  0x38, 0x16, 0x0e, 0xff,
  0x54, 0x21, 0x15, 0xff,
  0x70, 0x2c, 0x1c, 0xff,
  0x8c, 0x37, 0x23, 0xff,
  0xa8, 0x42, 0x2a, 0xff,
  0xc4, 0x4d, 0x31, 0xff,
  0xe0, 0x58, 0x38, 0xff,
  0xfc, 0x63, 0x3f, 0xff,
  0x11, 0x16, 0x09, 0xff,
  0x22, 0x2c, 0x12, 0xff,
  0x33, 0x42, 0x1b, 0xff,
  0x44, 0x58, 0x24, 0xff,
  0x55, 0x6e, 0x2d, 0xff,
  0x66, 0x84, 0x36, 0xff,
  0x77, 0x9a, 0x3f, 0xff,
  0x88, 0xb0, 0x48, 0xff,
  0x99, 0xc6, 0x51, 0xff,
  0x00, 0x3a, 0x68, 0xff,
  0x00, 0x57, 0x70, 0xff,
  0x2b, 0x70, 0x80, 0xff,
  0xff, 0x00, 0x00, 0xff,
  0x40, 0xff, 0x40, 0xff,
  0x00, 0x00, 0xc0, 0xff,
  0x00, 0x69, 0x69, 0xff,
  0xff, 0x80, 0x00, 0xff,
  0xff, 0xff, 0x00, 0xff,
  0x51, 0x51, 0x51, 0xff,
  0x79, 0x79, 0x79, 0xff,
  0x92, 0x92, 0x92, 0xff,
  0xaa, 0xaa, 0xaa, 0xff,
  0xc3, 0xc3, 0xc3, 0xff,
  0xe3, 0xe3, 0xe3, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0x00, 0x00, 0x00, 0xff,
  0xc0, 0xc0, 0xff, 0xff,
  0xc8, 0xc8, 0xff, 0xff,
  0xd0, 0xd0, 0xff, 0xff,
  0xd8, 0xd8, 0xff, 0xff,
  0xe0, 0xe0, 0xff, 0xff,
  0xe8, 0xe8, 0xff, 0xff,
  0xf0, 0xf0, 0xff, 0xff,
  0xf8, 0xf8, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff,
  0x10, 0x48, 0x10, 0xff,
  0x20, 0x50, 0x20, 0xff,
  0x30, 0x58, 0x30, 0xff,
  0x40, 0x60, 0x40, 0xff,
  0x50, 0x68, 0x50, 0xff,
  0x60, 0x70, 0x60, 0xff,
  0x70, 0x78, 0x70, 0xff,
  0x78, 0x7c, 0x78, 0xff,
  0x80, 0x80, 0x80, 0xff,
  0x80, 0x80, 0x80, 0xff,
  0x80, 0x80, 0x80, 0xff,
  0x80, 0x80, 0x80, 0xff,
  0x80, 0x80, 0x80, 0xff,
  0x80, 0x80, 0x80, 0xff,
  0x80, 0x80, 0x80, 0xff,
  0x80, 0x80, 0x80, 0xff,
  0x21, 0x8c, 0xbd, 0xff,
  0x39, 0x84, 0xa5, 0xff,
  0xbd, 0x42, 0x42, 0xff,
  0x9c, 0x42, 0x42, 0xff,
  0x84, 0x4a, 0x4a, 0xff,
  0x21, 0x52, 0x6b, 0xff,
  0xd6, 0x5a, 0x52, 0xff,
  0xbd, 0x5a, 0x52, 0xff,
  0xa5, 0x5a, 0x52, 0xff,
  0x7b, 0x39, 0x31, 0xff,
  0x63, 0x39, 0x31, 0xff,
  0x6b, 0x4a, 0x42, 0xff,
  0x7b, 0x5a, 0x52, 0xff,
  0xb5, 0x5a, 0x42, 0xff,
  0x4a, 0x31, 0x29, 0xff,
  0xbd, 0x73, 0x5a, 0xff,
  0x8c, 0x5a, 0x31, 0xff,
  0x21, 0x31, 0x4a, 0xff,
  0xb5, 0x73, 0x31, 0xff,
  0x63, 0x42, 0x21, 0xff,
  0xa5, 0x73, 0x42, 0xff,
  0x31, 0x29, 0x21, 0xff,
  0xa5, 0x8c, 0x73, 0xff,
  0xbd, 0xa5, 0x8c, 0xff,
  0x39, 0x63, 0x7b, 0xff,
  0xb5, 0x6b, 0x18, 0xff,
  0xce, 0x7b, 0x21, 0xff,
  0x9c, 0x63, 0x21, 0xff,
  0x94, 0x6b, 0x31, 0xff,
  0x6b, 0x52, 0x31, 0xff,
  0x21, 0x21, 0x39, 0xff,
  0x21, 0x73, 0xa5, 0xff,
  0xd6, 0xd6, 0x21, 0xff,
  0xad, 0xad, 0x21, 0xff,
  0xc6, 0xc6, 0x29, 0xff,
  0x8c, 0x8c, 0x21, 0xff,
  0x73, 0x73, 0x21, 0xff,
  0xbd, 0xbd, 0x39, 0xff,
  0x9c, 0x9c, 0x31, 0xff,
  0xad, 0xad, 0x39, 0xff,
  0x7b, 0x7b, 0x31, 0xff,
  0x7b, 0x7b, 0x42, 0xff,
  0x4a, 0x4a, 0x31, 0xff,
  0x7b, 0x7b, 0x5a, 0xff,
  0x29, 0x29, 0x21, 0xff,
  0x5a, 0x63, 0x39, 0xff,
  0x6b, 0x73, 0x4a, 0xff,
  0x7b, 0x94, 0x52, 0xff,
  0x8c, 0xad, 0x63, 0xff,
  0x84, 0x9c, 0x63, 0xff,
  0x31, 0x42, 0x29, 0xff,
  0x63, 0xa5, 0x5a, 0xff,
  0x4a, 0xd6, 0x4a, 0xff,
  0x39, 0x8c, 0x39, 0xff,
  0x4a, 0xb5, 0x4a, 0xff,
  0x5a, 0xc6, 0x5a, 0xff,
  0x39, 0x7b, 0x39, 0xff,
  0x31, 0x63, 0x31, 0xff,
  0x5a, 0xa5, 0x5a, 0xff,
  0x52, 0x94, 0x52, 0xff,
  0x4a, 0x63, 0x4a, 0xff,
  0x39, 0x73, 0x84, 0xff,
  0x21, 0x63, 0x7b, 0xff,
  0x4a, 0x73, 0x84, 0xff 
};

#ifdef SSG_LOAD_MDL_BGL_TEXTURE_SUPPORTED
// This really simple (raw paletted) format is used by older MSFS for textures
bool ssgLoadMDLTexture ( const char *fname, ssgTextureInfo* info )
{
  FILE *tfile;
  int index = 0;
  if ( (tfile = fopen(fname, "rb")) == NULL) {
    char *p = strrchr(fname,'_');
    if (p != 0) {
      *p = '\0';
      p++;
      index = atoi (p);
      if ( (tfile = fopen(fname, "rb")) == NULL) {
        ulSetError( UL_WARNING, "ssgLoadTexture: Failed to load '%s'.", fname );
        return false ;
      }
      p--;
      *p = '_';
    }
    else {
      ulSetError( UL_WARNING, "ssgLoadTexture: Failed to load '%s'.", fname );
      return false ;
    }
  }

  fseek(tfile, 0, SEEK_END);
  unsigned long file_length = ftell(tfile);

  if (file_length != 65536) {
    // this is not a MSFS-formatted texture, so it's probably a BMP
    fclose(tfile);
    return ssgLoadBMP( fname, info );
  } else {
    fseek(tfile, 0, SEEK_SET);

    unsigned char *texels = new unsigned char[256 * 256 * 4];
    int c = 0;
    for (int y = 0; y < 256; y++) {
      for (int x = 0; x < 256; x++) {
        unsigned char b;
        fread(&b, 1, 1, tfile);
        texels[c++] = ssgFsTexPalette[b*4    ];
        texels[c++] = ssgFsTexPalette[b*4 + 1];
        texels[c++] = ssgFsTexPalette[b*4 + 2];
        texels[c++] = (b<index)?0:255;
      }
    }
    
    fclose(tfile);

    if ( info != NULL )
    {
      info -> width = 256 ;
      info -> height = 256 ;
      info -> depth = 4 ;
      info -> alpha = TRUE ;  //??
    }

    return ssgMakeMipMaps ( texels, 256, 256, 4 ) ;
  }
}
#else

bool ssgLoadMDLTexture ( const char *fname, ssgTextureInfo* info )
{
  ulSetError ( UL_WARNING,
    "ssgLoadTexture: '%s' - MDL/BGL Texture support not configured", fname ) ;
  return false ;
}

#endif
