--TEST--
multiple binds
--FILE--
<?php
	include "connect.inc";
	
	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);

        maxdb_report (MAXDB_REPORT_OFF);
  	maxdb_query($link,"DROP TABLE IF EXISTS mbind");
        maxdb_report (MAXDB_REPORT_ERROR);
  	maxdb_query($link,"CREATE TABLE mbind (a int, b varchar(10))");

	$stmt = maxdb_prepare($link, "INSERT INTO mbind VALUES (?,?)");
	
	maxdb_bind_param($stmt, "is", $a, $b);

	$a = 1;
	$b = "foo";

	maxdb_execute($stmt);

	maxdb_bind_param($stmt, "is", $c, $d);

	$c = 2;
	$d = "bar";

	maxdb_execute($stmt);
	maxdb_stmt_close($stmt);

	$stmt = maxdb_prepare($link, "SELECT * FROM mbind");
	maxdb_execute($stmt);

	maxdb_bind_result($stmt, $e, $f);
	maxdb_fetch($stmt);

	maxdb_bind_result($stmt, $g, $h);
	maxdb_fetch($stmt);

	var_dump((array($e,$f,$g,$h)));

	maxdb_close($link);
?>
--EXPECT--
array(4) {
  [0]=>
  int(1)
  [1]=>
  string(3) "foo"
  [2]=>
  int(2)
  [3]=>
  string(3) "bar"
}
