--TEST--
maxdb fetch mixed values 2
--SKIPIF--
<?php require 'skipif.inc'; ?>
--INI--
precision=12
--FILE--
<?php
	include "connect.inc";
	
	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);

        maxdb_report (MAXDB_REPORT_OFF);
  	maxdb_query($link,"DROP TABLE test_bind_result");
        maxdb_report (MAXDB_REPORT_ERROR);

	maxdb_query($link,"CREATE TABLE test_bind_result(c1 smallint, c2 smallint, 
                                                        c3 int, c4 fixed(30), 
                                                        c5 float, c6 float,
                                                        c7 varchar(10), 
                                                        c8 varchar(10))");

  	maxdb_query($link,"INSERT INTO test_bind_result VALUES(120,2999,3999,54,
                                                              2.6,58.89,
                                                              '206','6.7')");

	$stmt = maxdb_prepare($link, "SELECT * FROM test_bind_result");
	maxdb_bind_result($stmt, $c1, $c2, $c3, $c4, $c5, $c6, $c7, $c8);
	maxdb_execute($stmt);
	maxdb_fetch($stmt);

	$test = array($c1,$c2,$c3,$c4,$c5,$c6,$c7,$c8);

	var_dump($test);

	maxdb_stmt_close($stmt);
	maxdb_close($link);
?>
--EXPECT--
array(8) {
  [0]=>
  int(120)
  [1]=>
  int(2999)
  [2]=>
  int(3999)
  [3]=>
  int(54)
  [4]=>
  float(2.6)
  [5]=>
  float(58.89)
  [6]=>
  string(3) "206"
  [7]=>
  string(3) "6.7"
}
