#!/bin/sh
# \
exec wish8.0 "$0" "$@"

#####################################################################

set test 0

if $test {
	source "tclpp.tcl"
}

#####################################################################

class Scrolled {
		variable scalar pwidg
		variable scalar cwidg
		variable scalar fwidg
		variable scalar hscroll
		variable scalar vscroll
		variable scalar filler

	proc Scrolled { widgVal args } {		
		set opts "-highlightthickness 0"
		
		# some frames and the canvas
		set pwidg [eval frame $widgVal $opts]		
		set ifwidg [eval frame $pwidg.if $opts]
		set hsfwidg [eval frame $pwidg.hsf $opts]
		set cwidg [eval canvas $ifwidg.c $opts]
		
		# this is to make the widget resize better
		$cwidg configure -width 1 -height 1
		eval $cwidg configure $args

		# the frame that is embedded in the canvas
		set fwidg [eval frame $cwidg.frame -bd 0 -relief raised]
		$cwidg create window 0 0 -window $fwidg -anchor nw

		# the scroll bars
		set hscroll [eval scrollbar $hsfwidg.hs -orient horizontal -command \"$cwidg xview\" $opts]
		set vscroll [eval scrollbar $ifwidg.vs -orient vertical -command \"$cwidg yview\" $opts]
		
		# the filler		
		set filler [button $hsfwidg.fill -width 15 -height 15 \
			-command "$this evalBounds" \
			-borderwidth 0 -padx 0 -pady 0 \
			-image [image create photo]]
		
		# now that we have scrollbars, set the canvas to use them
		$cwidg configure -xscrollcommand "$hscroll set" \
			-yscrollcommand "$vscroll set"

		# pack all the widgets
		::pack $ifwidg -side top -expand 1 -fill both
		::pack $cwidg -side left -expand 1 -fill both
		::pack $hscroll -side left -fill x -expand 1
		::pack $filler -side left
		::pack $hsfwidg -side top -fill x
		::pack $vscroll -side left -fill y
		
		$this makeScrollBindings $cwidg 0
	}
	
	proc ~Scrolled {} {
		destroy $pwidg
	}
	
	proc getWidg {} {
		return $fwidg
	}
	
	proc pack { args } {
		eval ::pack $pwidg $args
	}
	
	proc evalBounds {} {
		update
		set bounds [$cwidg bbox all]
		$cwidg configure -scrollregion $bounds
	}
	
	proc startDrag { xx yy } {
		$cwidg scan mark $xx $yy
	}
	
	proc doDrag { xx yy } {
		$cwidg scan dragto $xx $yy
	}
	
	# the rec arg is for recursively adding the scroll bindings
	# to all subwidgets... this doesn't work right yet
	proc makeScrollBindings { { widg "" } { rec 1 } } {
		if { $widg == "" } {
			set widg $cwidg
		}

		::bind $widg <2> "$this startDrag %x %y"
		::bind $widg <B2-Motion> "$this doDrag %x %y"	
		
		if { $rec } {
			foreach kid [winfo children $widg] {
				$this makeScrollBindings $kid 1
			}
		}
	}
}

#####################################################################
#####################################################################
#####################################################################

class ScrolledText {
		variable scalar pwidg
		variable scalar twidg
		variable scalar fwidg
		variable scalar hscroll
		variable scalar vscroll
		variable scalar filler

	proc ScrolledText { widgVal args } {
		set opts "-highlightthickness 0"
		
		# some frames and the canvas
		set pwidg [eval frame $widgVal $opts]		
		set ifwidg [eval frame $pwidg.if $opts]
		set hsfwidg [eval frame $pwidg.hsf $opts]
		set twidg [eval text $ifwidg.t $opts $args]
		
		# this is to make the widget resize better
# 		$twidg configure -width 1 -height 1
# 		eval $twidg configure $args

		# the frame that is embedded in the canvas
# 		set fwidg [eval frame $twidg.frame -bd 0 -relief raised]
# 		$twidg create window 0 0 -window $fwidg -anchor nw

		# the scroll bars
		set hscroll [eval scrollbar $hsfwidg.hs -orient horizontal -command \"$twidg xview\" $opts]
		set vscroll [eval scrollbar $ifwidg.vs -orient vertical -command \"$twidg yview\" $opts]
		
		# the filler		
		set filler [button $hsfwidg.fill -width 15 -height 15 \
			-command "" \
			-borderwidth 0 -padx 0 -pady 0 \
			-image [image create photo]]
		
		# now that we have scrollbars, set the canvas to use them
		$twidg configure -xscrollcommand "$hscroll set" \
			-yscrollcommand "$vscroll set"

		# pack all the widgets
		::pack $ifwidg -side top -expand 1 -fill both
		::pack $twidg -side left -expand 1 -fill both
		::pack $hscroll -side left -fill x -expand 1
		::pack $filler -side left
		::pack $hsfwidg -side top -fill x
		::pack $vscroll -side left -fill y
	}
	
	proc ~ScrolledText {} {
		destroy $pwidg
	}
	
	proc getWidg {} {
		return $twidg
	}
	
	proc pack { args } {
		eval ::pack $pwidg $args
	}
}


if { $test } {
	Scrolled scr .s
	set scr scr
	$scr pack -fill both -side left -expand 1

	set cont [$scr getWidg]

	foreach { a b c d e } { a b c d e f g h i j k l m n o p q r s t u v w x y z } {
		frame $cont.$a
		foreach butt " $a $b $c $d $e " {
			if { $butt != "" } {
				button $cont.$a.$butt -text $butt -command "$scr evalBounds"
				pack $cont.$a.$butt -side left
			}
		}
		pack $cont.$a -side top
	}
	
	$scr evalBounds
	wm geometry . 200x200+10+10
	
	ScrolledText scr2 .s2
	set scr scr2
	
	$scr pack -fill both -side left -expand 1
}

