/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-2000 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#include <sys/types.h>
#include <pwd.h>
#include <fcntl.h>
#include "main.h"

#if !defined __RH_CYGLINT__
extern void set_tty(int);
extern void create_passwd(void);
extern void pmanager(short);
#endif
extern void shost(int *, int);
extern void lhost(int *, short);
extern void set_vars_from_pftprc(FILE *, int *, int);
extern short get_var_from_pftprc(FILE *, const char *, char *, int);
extern void warranty(void);
extern short mycmp(char *, char *);
extern void help();
extern int printlist(char **, char *, short);
extern int getoffset(char *);
extern int extract_val_d(double *, char *, int);
extern int extract_val_i(unsigned int *, char *, int);
extern int extract_val_li(unsigned long *, char *, int);
extern void opt_err_handle(int);

off_t offset[SONAME];  /* hold all offsets of the beginning of files */

#if defined __RH_CYGLINT__
#define NO_SUCH_OPT() fprintf(stderr, "** This option is not implemented on this operating system!\n"); exit(1);
#endif

int argum(int argc, char **argv, int *portn)
{
   int _ISDIGIT_=0;
   int _MESSAGE_ONLY_=0;
   int mfs=0, len=0, count=0;
   char set_netbuffer=0, set_bandwidth=0, list_filters=0;
   char *gtmp=NULL, stmp[SONAME], *envtmp=NULL;
   char GIGABIT_ETHERNET=0;
   (*statstr)->usefilter = 0;
   *offset = -1;

   /*
    * Set the default maximum package size.
    */
   (*statstr)->bsize = BUFSIZE;

   /*
    * Please don't change this option.
    */
   if (argc == 2 && !mycmp(*(argv+1), "-H")) {
      char *blankline=NULL, *ctmp=NULL;
      MEM_CHECK((blankline = (char *)calloc(SONAME, sizeof(char))));
      for (ctmp=blankline; ctmp - blankline < (_WINCOLS_-45)/2; ctmp++) *ctmp = ' ';
      *ctmp='\0';
      fprintf(stderr, "[?25l[31m[H[J[%dH%s", _WINROWS_/2, blankline);
      free(blankline);
      fprintf(stderr, "This program is dedicated to Heather O'Rourke");
      fprintf(stderr, "[0m[%dH", _WINROWS_);
#if !defined __RH_CYGLINT__
      set_tty(2); fgetc(stdin); set_tty(0);
#else
      sleep(1);
#endif
      fprintf(stderr, "[?25h[H[J");
      exit(PFTP_NO_ERR);
   }
   else if (argc == 2 && !mycmp(*(argv+1), "-n")) {
#if !defined __RH_CYGLINT__
      pmanager(0);
#else
      NO_SUCH_OPT();
#endif
      exit(PFTP_NO_ERR);
   }
   else if (argc == 2 && *(*(argv+1)) == '-' && *(*(argv+1)+1) == 'N') {
      if (isdigit(*(*(argv+1)+2))) {
         (*statstr)->host_number = atoi((*(argv+1)+2));
      }
#if !defined __RH_CYGLINT__
      pmanager(1);
#else
      NO_SUCH_OPT();
#endif
      exit(PFTP_NO_ERR);
   }
   else if (argc == 2 && !mycmp(*(argv+1), "-nl")) {
      while (!*portn) {
         lhost(portn, 0);
#if !defined __RH_CYGLINT__
         pmanager(0);
#else
         NO_SUCH_OPT();
#endif
      }
   }
   else if (argc == 2 && !mycmp(*(argv+1), "-W")) {
#if !defined __RH_CYGLINT__
      fprintf(stderr, "[?25l");
      set_tty(2);
#endif
      warranty();
#if !defined __RH_CYGLINT__
      set_tty(0);
      fprintf(stderr, "[?25h\r");
#endif
      exit(PFTP_NO_ERR);
   }
   else if (argc == 1) {
      (*statstr)->_OPTIONS_=1;
      *portn=-1;
      set_vars_from_pftprc((FILE *)NULL, portn, 0);
      return 1;
   }
   else if (argc == 2 && (atoi(*(argv+1)) && strlen(*(argv+1)) < 7) && **(argv+1) != '-') {
      return 1;
   }
   else {
      int i, c, _NEXT_, cl=0;
      short clhosts=0;

      if (!mycmp(*(argv+1), "-h")) help();
      else if (**(argv+1) == '-' || !atoi(*(argv+1)) || strlen(*(argv+1)) > 5) {
         *portn=-1;
         set_vars_from_pftprc((FILE *)NULL, portn, 0);
         (*statstr)->_OPTIONS_ = 1;
         if (argc == 2 && !(**(argv+1) == '-')) {
            FILE *fp=NULL;
            char ch='\0', str[8];
            fprintf(stderr , "Add `%s' to your host name list (Y|n)? ", *(argv+1));
#if !defined __RH_CYGLINT__
            set_tty(1);
#endif
            if ((ch = fgetc(stdin)) != '\n') fputc('\n', stderr);
#if !defined __RH_CYGLINT__
            set_tty(0);
#endif
            if (ch != 'n') {
               if ((fp = fopen((*statstr)->home, "a")) == NULL) {
                  fprintf(stderr, "** %s: %s\n", (*statstr)->home, _PFTP_ERROR_ARRAY_);
                  exit(PFTP_OPEN_RC_ERR);
               }
               fprintf(stderr , "Enter a port number or press enter\nfor the default port number[%d]: ", *portn);
               if (fgets(str, 8, stdin)) {
                  *portn = atoi(str);
                  fprintf(stderr, "Adding the following line to `%s':\n", (*statstr)->home);
                  if (!*portn) {
                     fprintf(fp, "%s\n", *(argv+1));
                     fprintf(stderr, "%s\n", *(argv+1));
                  }
                  else {
                     fprintf(fp, "%s %d\n", *(argv+1), *portn);
                     fprintf(stderr, "%s %d\n", *(argv+1), *portn);
                  }
                  exit(PFTP_NO_ERR);
               }
               else exit(PFTP_FGET_STDIN_ERR);
            }
            fprintf(stderr, "Resource file `%s' is unchanged.\n", (*statstr)->home);
            exit(PFTP_NO_ERR);
         }
      }
      else {
         if (!(*portn = atoi(*(argv+1)))) *portn = 0;
         (*statstr)->_OPTIONS_ = 2;
      }

      while ((*statstr)->_OPTIONS_ < argc && *argv[(*statstr)->_OPTIONS_] == '-') {
         _NEXT_ = 1;
         clhosts = 0;
         if (!mycmp(argv[(*statstr)->_OPTIONS_], "-")) {
            (*statstr)->_STANDARD_INPUT_ = BIT_ONE;
            (*statstr)->_STDIN_BUFSIZ_ = 0;
         }
         for (i=1; _NEXT_ && (c = *(argv[(*statstr)->_OPTIONS_]+i)); i++) {
            switch(c) {
               case 'c':
                  /* get host names of accepted clients */
                  *stmp = 0;
                  envtmp = getenv("PFTPCLIENTS");
                  if (argc > (*statstr)->_OPTIONS_ + 1) {
                     if (!envtmp && (*argv[(*statstr)->_OPTIONS_+1] == '-' || argv[(*statstr)->_OPTIONS_][i+1])) {
                        if (!get_var_from_pftprc((FILE *)NULL, "PFTPCLIENTS", stmp, 0)) opt_err_handle(PFTP_OPT_PFTPCLIENTS);
                     }
                     else if (*argv[(*statstr)->_OPTIONS_+1] != '-') clhosts = 1;
                  }
                  else if (argc == (*statstr)->_OPTIONS_ + 1) {
                     if (!envtmp) {
                        if (!get_var_from_pftprc((FILE *)NULL, "PFTPCLIENTS", stmp, 0)) opt_err_handle(PFTP_OPT_PFTPCLIENTS);
                     }
                  }
                  if (!*_CLIENTHOSTNAME_ && isatty(2)) {
                     if (slfp) fprintf(slfp, "\n*** Connections are accepted from the following host(s) ***\n\n");
                  }
                  for (cl=0; cl < MAXCLIENTHOSTS && *(_CLIENTHOSTNAME_+cl); cl++);

                  /*
                   * Read from command line.
                   */
                  if (clhosts) {
                     for (; ++(*statstr)->_OPTIONS_ < argc && *argv[(*statstr)->_OPTIONS_] != '-'; cl++) {
                        if (!printlist(_CLIENTHOSTNAME_, argv[(*statstr)->_OPTIONS_], 0)) exit(PFTP_PRINTLIST_ERR);
                     }
                     if (!*_CLIENTHOSTNAME_) help();
                     _NEXT_ = 0;
                     (*statstr)->_OPTIONS_--;
                     continue;
                  }
                  /*
                   * Read from environment variable or resource file.
                   */
                  else if (envtmp || *stmp) {
                     char *tmp=NULL;
                     if (envtmp) {
                        strcpy(stmp, envtmp);
                     }
                     tmp = stmp;
                     if (!printlist(_CLIENTHOSTNAME_, tmp, 0)) exit(PFTP_PRINTLIST_ERR);
                     if (!*_CLIENTHOSTNAME_) help();
                  }
                  else help();
                  break;
               case 'w':
                  /*
                   * Get the size of the bandwidth
                   */
                  envtmp = getenv("PFTPBANDWID");
                  if (isdigit(argv[(*statstr)->_OPTIONS_][i+1])) {
                     i = extract_val_li((unsigned long *)&((*statstr)->_BANDWIDTH_), argv[(*statstr)->_OPTIONS_], i);
                  }
                  else if (!envtmp) set_bandwidth = 1;
                  else (*statstr)->_BANDWIDTH_ = (size_t) atol(envtmp);
                  break;
               case 'B':
                  /*
                   * Get the size of the net buffer.
                   */
                  cl = 0;
                  envtmp = getenv("PFTPNETBUF");
                  if (!(*statstr)->use_udp) {
                     if (argv[(*statstr)->_OPTIONS_][i+1] == 'B') {
                        cl = 1;
                        i++;
                     }
                     if (isdigit(argv[(*statstr)->_OPTIONS_][i+1])) {
                        i = extract_val_i((unsigned int *)&((*statstr)->bsize), argv[(*statstr)->_OPTIONS_], i);
                     }
                     else if (cl) (*statstr)->bsize = BIG_BUFSIZE;
                     else if (!envtmp) set_netbuffer = 1;
                     else (*statstr)->bsize = (size_t) atol(envtmp);
                  }
                  else {
                     fprintf(stderr, "** There is no net buffer size in UDP.\n");
                     exit(PFTP_MCLOPTION_ERR);
                  }
                  break;
               case 'p':
                  /*
                   * Server--Force sending all received data to stdout.
                   * Client--Print percentage of bytes sent per file.
                   */
                  (*statstr)->FORCE_STDOUT = BIT_ONE;
               case 'b':
                  /*
                   * Get and set string size.
                   */
                  if (isdigit(argv[(*statstr)->_OPTIONS_][i+1])) { 
                     i = extract_val_i((unsigned int *)&((*statstr)->_STDIN_BUFSIZ_), argv[(*statstr)->_OPTIONS_], i);
                  } 
                  else if (argv[(*statstr)->_OPTIONS_][i+1] == 'p' || argv[(*statstr)->_OPTIONS_][i+1] == 'b') {
                     (*statstr)->_STDIN_BUFSIZ_ = DEFAULT_STDOUT_BUFSIZ;
                     i++;
                  }
                  else {
                     (*statstr)->_STDIN_BUFSIZ_ = c == 'p' ? 0: DEFAULT_STDIN_BUFSIZ;
                  }
               case '-':
                  if (c == 'p') break;
                  (*statstr)->_STANDARD_INPUT_ = BIT_ONE;
                  if (c == '-') (*statstr)->_STDIN_BUFSIZ_ = 0;
                  break;
               case 'j':
                  (*statstr)->READFROMSTDIN = 1;
                  break;
               case 'e':
#if !defined __RH_CYGLINT__
                  create_passwd();
#else
                  NO_SUCH_OPT();
#endif
                  break;
               case 'f':
                  if ((cl = argv[(*statstr)->_OPTIONS_][i+1]) == 'S' || cl == 'C') {
                     list_filters = cl;
                     i++;
                     break;
                  }
                  else {
                     if (isdigit(argv[(*statstr)->_OPTIONS_][i+1])) {
                        i = extract_val_i((unsigned int *)&((*statstr)->usefilter), argv[(*statstr)->_OPTIONS_], i);
                     }
                     if (!(*statstr)->usefilter) (*statstr)->usefilter=1;
                  }
                  break;
               case 'M':
                  (*statstr)->delete_info = 0;
                  _MESSAGE_ONLY_ = 1;
                  MEM_CHECK((data_info = (char *)calloc(SONAME, sizeof(char))));
                  if (*(argv[(*statstr)->_OPTIONS_]+i+1) == '=') {
                     strcpy(data_info, (argv[(*statstr)->_OPTIONS_]+i+2));
                     for (; *(argv[(*statstr)->_OPTIONS_]+i+1); i++) {
                        *(argv[(*statstr)->_OPTIONS_]+i+1) = '\0';
                     }
                     _NEXT_ = 0;
                  }
                  else (*statstr)->delete_info = 1;
               case 'n':
                  if (c == 'n') {
                     if (*(argv[(*statstr)->_OPTIONS_]+i+1) == '=') {
                        MEM_CHECK((data_subject = (char *)calloc(SONAME, sizeof(char))));
                        strcpy(data_subject, (argv[(*statstr)->_OPTIONS_]+i+2));
                        strcat(data_subject, "\n");
                        /*
                         * Nobody else should see the subject.
                         */
                        for (; *(argv[(*statstr)->_OPTIONS_]+i+1); i++) {
                           *(argv[(*statstr)->_OPTIONS_]+i+1) = '\0';
                        }
                        _NEXT_ = 0;
                     }
                     else if (*(argv[(*statstr)->_OPTIONS_]+i+1) == 'n') {
                        MEM_CHECK((data_subject = (char *)calloc(SONAME, sizeof(char))));
                        fprintf(stdout, "Subject: ");
                        fgets(data_subject, SONAME, stdin);
                        i++;
                     }
                  }
#if !defined __RH_CYGLINT__
                  if (getpwuid(getuid())) {
                     strcpy((*statstr)->from, (char *)getpwuid(getuid())->pw_name);
                  }
#else
                  if (getuid()) {
                     sprintf((*statstr)->from, "%d", getuid());
                  }
#endif
                  else {
                     if (stderr) fprintf(stderr, "** Who are you?!\n");
                     exit(PFTP_UUSER_ERR);
                  }
                  if (!(*statstr)->_PFTP_DAEMON_) {
                     (*statstr)->_PFTP_DAEMON_ = BIT_TWO;
                     *portn = INETD_PORT;
                  }
                  break;
               case 'I':
                  /*
                   * Copy last time modifications of files
                   * and directories and directory permissions.
                   */
                  (*statstr)->send_file_info = (*statstr)->accept_file_info = 1;
                  break;
               case 'i':
                  /*
                   * Exit after first connection.
                   * This is meant for `inetd.conf'.
                   */
                  (*statstr)->_PFTP_DAEMON_ = BIT_TWO;
                  *portn = INETD_PORT;
               case 'd':
                  if (!getuid()) *portn = INETD_PORT;
                  /*
                   * Run as long as to be killed.
                   */
                  if (c == 'd') (*statstr)->_PFTP_DAEMON_ = BIT_ONE;
                  client_destdir = NULL;
                  MEM_CHECK((client_destdir = (char *)calloc(LONAME, sizeof(char))));
                  if (*(argv[(*statstr)->_OPTIONS_]+i+1) == '=') {
                     strcpy(client_destdir, (argv[(*statstr)->_OPTIONS_]+i+2));
                     /*
                      * Nobody else should see the destination directory.
                      */
                     for (; *(argv[(*statstr)->_OPTIONS_]+i+1); i++) {
                        *(argv[(*statstr)->_OPTIONS_]+i+1) = '\0';
                     }
                     _NEXT_ = 0;
                  }
                  else strcpy(client_destdir, "~");
                  break;
               case 'D':
                  if (*(argv[(*statstr)->_OPTIONS_]+i+1) == '=') {
                     char *destdir=NULL;
                     MEM_CHECK((destdir = (char *)calloc(LONAME, sizeof(char))));
                     *destdir = '\0';
#if !defined __RH_CYGLINT__
                     if (*(argv[(*statstr)->_OPTIONS_]+i+2) == '~') {
                        if (!getpwuid(getuid())) {
                           fprintf(stderr, "** getpwuid: %s\n", _PFTP_ERROR_ARRAY_);
                           exit(PFTP_UUSER_ERR);
                        }
                        strcpy(destdir, (char *)getpwuid(getuid())->pw_dir);
                        i++;
                     }
#endif
                     strcat(destdir, (argv[(*statstr)->_OPTIONS_]+i+2));
                     if (chdir(destdir) < 0) {
                        fprintf(stderr, "** %s: %s\n", (argv[(*statstr)->_OPTIONS_]+i+2), _PFTP_ERROR_ARRAY_);
                        exit(PFTP_CHDIR_ERR);
                     }
                     free(destdir);
                     /*
                      * Nobody else should see the destination directory.
                      */
                     for (; *(argv[(*statstr)->_OPTIONS_]+i+1); i++) {
                        *(argv[(*statstr)->_OPTIONS_]+i+1) = '\0';
                     }
                     _NEXT_ = 0;
                  }
                  else opt_err_handle(PFTP_OPT_NO_DIR);
                  break;
               case 'A':
                  if (isdigit(argv[(*statstr)->_OPTIONS_][i+1])) { 
                     i = extract_val_i((unsigned int *)&(*statstr)->maxclients, argv[(*statstr)->_OPTIONS_], i);
                  }
                  else {
                     fprintf(stderr, "** The number of accepted clients can be 1 to %d.\n", MAXCLIENTS);
                     exit(PFTP_MCLOPTION_ERR);
                  }
                  break;
               case 'a':
                  if (isdigit(argv[(*statstr)->_OPTIONS_][i+1])) { 
                     if (*offset < 0) i += getoffset((argv[(*statstr)->_OPTIONS_]+i+1)) + 1;
                     else help();
                  }
                  else (*statstr)->OVERWRITE = BIT_TWO;
                  break;
               case 'r':
                  (*statstr)->_RECURS_ = 1;
                  break;
               case 'o':
                  (*statstr)->single_connection = 1;
                  break;
               case 'l':
                  if (!isatty(0) || !isatty(1)) {
                     fprintf(stderr, "\n** Sorry, '-l' needs a tty for input and output!\n\n");
                     exit(PFTP_MCLOPTION_ERR);
                  }
                  else if (_ISDIGIT_ == 1) opt_err_handle(PFTP_OPT_LIST_OR_NUM);
                  else {
                     if ((*statstr)->_STANDARD_INPUT_ || !isatty(0)) opt_err_handle(PFTP_OPT_LIST);
                     lhost(portn, 0);
                     _ISDIGIT_ = 2;
                  }
                  break;
               case 'L':
                  MEM_CHECK(((*statstr)->SENDMAKELINKS = (char *)calloc(SONAME, sizeof(char))));
                  if (!tmpnam((*statstr)->SENDMAKELINKS)) {
                     sprintf((*statstr)->SENDMAKELINKS, "/tmp/pftp_make_links_%d", getpid());
                  }
                  if ((mfs = open((*statstr)->SENDMAKELINKS, O_CREAT|O_WRONLY, 0600)) < 0) {
                     fprintf(stderr, "Can't open file %s to temporary store the links.\n", (*statstr)->SENDMAKELINKS);
                     exit(PFTP_FILE_OPEN_ERR);
                  }
                  for (gtmp=PFTPLINKSCRIPTINIT, len=strlen(gtmp), count=0; len; len-=count, gtmp+=count) {
                     if ((count = write(mfs, gtmp, len)) < 0) {
                        fprintf(stderr, "** write: %s\n", _PFTP_ERROR_ARRAY_);
                        exit(PFTP_WRITETODISK_ERR);
                     }
                  }
                  close(mfs);
                  break;
               case 's':
                  (*statstr)->show_bytes = BIT_ONE;
                  (*statstr)->_SKIP_ = BIT_ONE;
                  (*statstr)->show_percent = 1;
                  break;
               case 'q':
                  slfp = NULL;
                  break;
               case 'K':
                  (*statstr)->KDE_FRONTEND = 1;
                  break;
               case 'P':
#if defined SO_PRIORITY
                  /*
                   * Set packet priority.
                   */
                  if (isdigit(argv[(*statstr)->_OPTIONS_][i+1])) {
                     i = extract_val_i((unsigned int *)&((*statstr)->priority), argv[(*statstr)->_OPTIONS_], i);
                  }
                  else (*statstr)->priority = PFTP_DEFAULT_PRIORITY;
#else
                  fprintf(stderr, "** Setting packet priority is not supported on this system.\n");
#endif
                  break;
               case 'S':
                  /*
                   * Sets the period of dropping datagrams.
                   */
                  if (isdigit(argv[(*statstr)->_OPTIONS_][i+1])) {
                     i = extract_val_li((unsigned long *)&((*statstr)->throw_away), argv[(*statstr)->_OPTIONS_], i);
                  }
                  else help();
                  break;
               case 'R':
                  (*statstr)->rename = 1;
                  break;
               case 'T':
                  /*
                   * Get the number of bytes to send during the test.
                   */
                  if (isdigit(argv[(*statstr)->_OPTIONS_][i+1])) {
                     i = extract_val_d((double *)&((*statstr)->testbsize), argv[(*statstr)->_OPTIONS_], i);
                  }
                  else (*statstr)->testbsize = 1L;
                  break;
               case 'G':
                  GIGABIT_ETHERNET = 1;
                  break;
               case 'F':
                  (*statstr)->autobitrate = 1;
                  break;
               case 'x':
                  (*statstr)->exit_afc = 1;
                  break;
#if defined IPV6_ADD_MEMBERSHIP || (defined IP_ADD_MEMBERSHIP && !defined HAVE_INET6)
               case 'm':
                  /*
                   * Receive/Send multicasted datagrams.
                   */
                  (*statstr)->multicast = 1;
                  if (argv[(*statstr)->_OPTIONS_][i+1] && !isdigit(argv[(*statstr)->_OPTIONS_][i+1])) {
                     switch (argv[(*statstr)->_OPTIONS_][i+1]) {
                        case 'g':
                           if (argv[(*statstr)->_OPTIONS_+1] && *argv[(*statstr)->_OPTIONS_+1] != '-') {
                              MEM_CHECK(((*statstr)->_MULTICASTGROUP_ = (char *)calloc(SONAME, sizeof(char))));
                              (*statstr)->_OPTIONS_++;
                              strcpy((*statstr)->_MULTICASTGROUP_, argv[(*statstr)->_OPTIONS_]);
                              if (!(*statstr)->use_udp) (*statstr)->bsize = DEFAULT_UDP_SIZE;
                              (*statstr)->use_udp = BIT_ONE;
                              _NEXT_ = 0;
                              continue;
                           }
                           else help();
                           break;
                        case 'i':
                           if (argv[(*statstr)->_OPTIONS_+1] && *argv[(*statstr)->_OPTIONS_+1] != '-') {
                              MEM_CHECK(((*statstr)->_INTERFACE_ = (char *)calloc(SONAME, sizeof(char))));
                              (*statstr)->_OPTIONS_++;
                              strcpy((*statstr)->_INTERFACE_, argv[(*statstr)->_OPTIONS_]);
                              if (!(*statstr)->use_udp) (*statstr)->bsize = DEFAULT_UDP_SIZE;
                              (*statstr)->use_udp = BIT_ONE;
                              _NEXT_ = 0;
                              continue;
                           }
                           else help();
                           break;
                        case 'l':
                           (*statstr)->mloop = 1;
                           i++;
                           break;
                        case 't':
                           i++;
                           if (isdigit(argv[(*statstr)->_OPTIONS_][i+1])) {
                              i = extract_val_i((unsigned int *)&((*statstr)->mttl), argv[(*statstr)->_OPTIONS_], i);
                           }
                           else help();
                           break;
                     }
                     if (!(*statstr)->use_udp) (*statstr)->bsize = DEFAULT_UDP_SIZE;
                     (*statstr)->use_udp = BIT_ONE;
                     break;
                  }
#endif
               case 'u':
                  if (isdigit(argv[(*statstr)->_OPTIONS_][i+1])) {
                     i = extract_val_i((unsigned int *)&((*statstr)->bsize), argv[(*statstr)->_OPTIONS_], i);
                  }
                  else (*statstr)->bsize = DEFAULT_UDP_SIZE;
                  (*statstr)->use_udp = BIT_ONE;
                  break;
               case 'v':
                  (*statstr)->verbose = BIT_ONE;
                  break;
               case 'h':
                  help();
                  break;
               default:
                  if (_ISDIGIT_ > 1 || !isdigit(c)) {
                     fprintf(stderr, "\n** Option `-%c' is not recognized by pftp!\n\n", c);
                     opt_err_handle(PFTP_OPT_UNKNOWN_OPT);
                  }
                  else if (!_ISDIGIT_) {
                     (*statstr)->host_number = atoi((argv[(*statstr)->_OPTIONS_]+i));
                     _ISDIGIT_ = 1;
                  }
                  break;
            }
         }
         if (i == 1) (*statstr)->_STANDARD_INPUT_ = 1;
         (*statstr)->_OPTIONS_++;
      }
   }
   if ((*statstr)->host_number) shost(portn, 0);
   else set_vars_from_pftprc((FILE *)NULL, portn, 0);

   /*
    * List our filters.
    */
   if (list_filters) {
      int i=0, j=0;
      char *tmp=NULL;
      /*
       * List all Server/Client filters.
       */
      if (list_filters == 'S') {
         tmp = getenv("PFTPSFILTER");
         if (!tmp) {
            MEM_CHECK((tmp = (char *)calloc(SONAME, sizeof(char))));
            if (!get_var_from_pftprc((FILE *)NULL, "PFTPSFILTER", tmp, 0)) {
               free(tmp);
               tmp = NULL;
            }
         }
      }
      else {
         tmp = getenv("PFTPCFILTER");
         if (!tmp) {
            MEM_CHECK((tmp = (char *)calloc(SONAME, sizeof(char))));
            if (!get_var_from_pftprc((FILE *)NULL, "PFTPCFILTER", tmp, 0)) {
               free(tmp);
               tmp = NULL;
            }
         }
      }
      if (!tmp) {
         fprintf(stderr, "** %s is not set.\n", list_filters == 'S'?"PFTPSFILTER":"PFTPCFILTER");
         exit(PFTP_FILTER_ERR);
      }
      for (j=0;*(tmp+j) == ' ' && *(tmp+j); j++);
      if (!*(tmp+j)) {
         fprintf(stderr, "** %s is empty.\n", list_filters == 'S'?"PFTPSFILTER":"PFTPCFILTER");
      }
      else {
         int skip_space=1;
         fprintf(stderr, "\n* List of %s filters:\n\n", list_filters == 'S'?"server":"client");
         fprintf(stderr, "      1) ");
         for (i=0,j=2; *(tmp+i); i++) {
            if (*(tmp+i) == ':') {
               fprintf(stderr, "\n      %d) ", j++);
               skip_space = 1;
            }
            else {
               if (*(tmp+i) == ' ' || *(tmp+i) == '\t') {
                  while(*(tmp+i) == ' ' || *(tmp+i) == '\t') i++;
                  if (!skip_space) i--;
               }
               skip_space = 0;
               fputc(*(tmp+i), stderr);
            }
         }
         fprintf(stderr, "\n\n");
      }
      exit(PFTP_NO_ERR);
   }

   /*
    * Set special values for Gigabit Ethernet links.
    * `-B' and `-bNUM' are ignored.
    */
   if (GIGABIT_ETHERNET) {
      if (!(*statstr)->use_udp) {
         size_t gigatmp=0;
         (*statstr)->bsize = DEFAULT_GIGABIT_NETSZ;
         (*statstr)->_STDIN_BUFSIZ_ = DEFAULT_GIGABIT_STRSZ;
         MEM_CHECK((gtmp = (char *)calloc(SONAME, sizeof(char))));
         if (get_var_from_pftprc((FILE *)NULL, "PFTPGIGASTR", gtmp, 0)) {
            if ((gigatmp = atol(gtmp))) (*statstr)->bsize = gigatmp;
         }
         if (get_var_from_pftprc((FILE *)NULL, "PFTPGIGANET", gtmp, 0)) {
            if ((gigatmp = atol(gtmp))) (*statstr)->_STDIN_BUFSIZ_ = gigatmp;
         }
         free(gtmp);
      }
      else opt_err_handle(PFTP_OPT_GIGA_UDP);
   }

   /*
    * Set the net buffer size.
    */ 
   else if (set_netbuffer) {
      MEM_CHECK((gtmp = (char *)calloc(SONAME, sizeof(char))));
      if (!get_var_from_pftprc((FILE *)NULL, "PFTPNETBUF", gtmp, 0)) {
         fprintf(stderr, "** Please set the variable PFTPNETBUF!\n");
         exit(PFTP_NETBUF_ERR);
      }
      (*statstr)->bsize = (size_t) atol(gtmp);
      free(gtmp);
   }

   /*
    * If not already set read bandwidth from file.
    */
   if (set_bandwidth) {
      MEM_CHECK((gtmp = (char *)calloc(SONAME, sizeof(char))));
      if (!get_var_from_pftprc((FILE *)NULL, "PFTPBANDWID", gtmp, 0)) {
         fprintf(stderr, "** Please set the variable PFTPBANDWID!\n");
         exit(PFTP_BANDWIDTH_ERR);
      }
      (*statstr)->_BANDWIDTH_ = (size_t) atol(gtmp);
      free(gtmp);
   }

   /*
    * If not already set adjust buffer to bandwidth.
    */
   if ((*statstr)->_BANDWIDTH_  && ((*statstr)->_BANDWIDTH_ < BUFSIZE) \
      && !(*statstr)->_STDIN_BUFSIZ_ && !(*statstr)->_STANDARD_INPUT_) {
      (*statstr)->_STDIN_BUFSIZ_ = (*statstr)->_BANDWIDTH_;
   }
   else if (!(*statstr)->_STDIN_BUFSIZ_ && !(*statstr)->_STANDARD_INPUT_ \
      && !(*statstr)->FORCE_STDOUT) {
      (*statstr)->_STDIN_BUFSIZ_ = DEFAULT_STDOUT_BUFSIZ;
   }

   /*
    * Indentify and check.
    */
   if(_ISDIGIT_) (*statstr)->_OPTIONS_--;
   if ((*statstr)->READFROMSTDIN) {
      (*statstr)->_STANDARD_INPUT_ = 0;
   }
   if ((*statstr)->testbsize && !(*statstr)->_STANDARD_INPUT_ \
      && !(*statstr)->_BANDWIDTH_ && !(*statstr)->use_udp) {
      fprintf(stderr, "\n******************** Net performance test ************************\n");
      fprintf(stderr, "**                                                              **\n");
      fprintf(stderr, "** You must specify `-b[NUM]' for a TCP based test respectively **\n");
      fprintf(stderr, "** `-u[NUM] for a UDP based test with NUM as string size to be  **\n");
      fprintf(stderr, "** sent/received.  You can additionally use option `-B[NUM]'    **\n");
#ifdef HAVE_INET6
      fprintf(stderr, "** to specify the net buffer size, set the bandwidth with       **\n");
      fprintf(stderr, "** `-w[NUM]', and set the datagram priority with `-P[NUM]'.     **\n");
#else
      fprintf(stderr, "** to specify the net buffer size and set the bandwidth with    **\n");
      fprintf(stderr, "** `-w[NUM]'.                                                   **\n");
#endif
      fprintf(stderr, "**                                                              **\n");
      fprintf(stderr, "******************************************************************\n\n");
      exit(PFTP_MCLOPTION_ERR);
   }
   if ((*statstr)->testbsize && (*statstr)->use_udp) (*statstr)->_STANDARD_INPUT_ = BIT_ONE;
   /*
    * If the program is running as the server return 1 else 
    * if the program is running as the client return 0.
    * Print a help message if an error occurs.
    */
   if ((*statstr)->use_udp && (*statstr)->_PFTP_DAEMON_) opt_err_handle(PFTP_OPT_DAEMON_UDP);
   else if ((*statstr)->use_udp && (*statstr)->usefilter) opt_err_handle(PFTP_OPT_FILTER_UDP);
   else if ((((argc == 2) && (!isalpha(argv[1][0]))) \
           || ((*statstr)->_OPTIONS_ == argc)) \
           && !_ISDIGIT_ \
           && (!(*statstr)->_BANDWIDTH_) && (*offset < 0) \
           && !(*statstr)->READFROMSTDIN \
           && !(*statstr)->SENDMAKELINKS \
           && !_MESSAGE_ONLY_ \
           && !*((*statstr)->from)) {
      if(((*statstr)->OVERWRITE && (*statstr)->_SKIP_)) opt_err_handle(PFTP_OPT_OVERWRT_SKIP);
#if defined __RH_CYGLINT__
      if ((*statstr)->_PFTP_DAEMON_) {
         fprintf(stderr, "** The daemon does not run on this operating system!\n");
         exit(1);
      }
#endif
      /*
       * Program is running as the server.
       */
      return 1;
   }
   else if ((*statstr)->OVERWRITE || (*statstr)->_SKIP_ \
           || *_CLIENTHOSTNAME_ || (*statstr)->FORCE_STDOUT \
           || (*statstr)->exit_afc) opt_err_handle(PFTP_OPT_USELESS);
   else if (_ISDIGIT_ > 1 && (*statstr)->_STANDARD_INPUT_) opt_err_handle(PFTP_OPT_LIST);
   else if ((*statstr)->_RECURS_ && (*statstr)->_STANDARD_INPUT_ \
           && !(*statstr)->testbsize) opt_err_handle(PFTP_OPT_RECURS_STDIN);
   else if (!_ISDIGIT_ && (((*statstr)->_RECURS_ && !(*statstr)->testbsize \
           && !(*statstr)->READFROMSTDIN && (*statstr)->_OPTIONS_ == argc - 1) \
           || (!(*statstr)->_STANDARD_INPUT_ && !(*statstr)->READFROMSTDIN \
           && ((argv[argc-1][0] == '-' || argv[argc-2][0] == '-') && !_MESSAGE_ONLY_) \
           && !((*statstr)->use_udp && (*statstr)->testbsize)) \
           || (((*statstr)->READFROMSTDIN || (*statstr)->_STANDARD_INPUT_ \
           || _MESSAGE_ONLY_) && (*statstr)->_OPTIONS_ == argc) \
           || (!(*statstr)->_STANDARD_INPUT_ && !(*statstr)->READFROMSTDIN \
           && argc < 3 - _MESSAGE_ONLY_))) opt_err_handle(PFTP_OPT_NO_HOST);
   else if ((*statstr)->_STANDARD_INPUT_ && argv[argc-1][0] != '-'  \
           && (_ISDIGIT_ || argv[argc-2][0] != '-')) opt_err_handle(PFTP_OPT_STDIN_FILES);
   else if ((*statstr)->rename && !(*statstr)->testbsize) opt_err_handle(PFTP_OPT_RENAME);
   else if ((*statstr)->use_udp && (*statstr)->usefilter) opt_err_handle(PFTP_OPT_FILTER_UDP);
   else if (_ISDIGIT_ && !_MESSAGE_ONLY_ && (*statstr)->_OPTIONS_ == argc - 1 \
           && !(*statstr)->READFROMSTDIN && !(*statstr)->_STANDARD_INPUT_) {
      opt_err_handle(PFTP_OPT_NO_FILES);
   }
#if !defined SO_PRIORITY
   else if ((*statstr)->priority) opt_err_handle(PFTP_OPT_PRIORITY);
#endif

   /*
    * Program is running as the client.
    */
   return 0;
}
