(** Wrapper around Perl [HTTP::Message] class.
  *
  * Copyright (C) 2003 Merjis Ltd.
  *
  * $Id: pl_HTTP_Headers.ml,v 1.2 2004/11/26 13:33:10 rich Exp $
  *)

open Perl

let _ = eval "use HTTP::Headers"

class http_headers sv =

object (self)

  method sv = sv

  method header key =
    string_of_sv (call_method sv "header" [sv_of_string key])
  method set_header key value =
    call_method_void sv "header" [sv_of_string key; sv_of_string value]

  method as_string =
    string_of_sv (call_method sv "as_string" [])

end
