/*
 * Copyright (C) 2002-2003  Jean-Charles Salzeber <jc@varspool.net>
 *
 * This file is part of penggy.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *                
 * $Id: log.h,v 1.14 2003/02/04 22:45:58 chupa Exp $
 *               
 */

#ifndef __LOG_H__
# define __LOG_H__

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#ifdef HAVE_SYSLOG_H
# include <syslog.h>
#endif

#if ENABLE_NLS
# include "gettext.h"
# define _(s) gettext(s)
#else
# define _(s) s
#endif

int init_log (void);
int log_daemon(void);
int log (int level, char *format, ...);
int debug (int level, char *format, ...);
void dump_raw (char *text, char *data, size_t size);

#define DEBUG_MAX      10

#endif /* __LOG_H__ */
