#include <qcombobox.h>

#include <iprovider.h>

#include <packagenotfoundexception.h>

#include "packagestatusplugin.h"

#include "installedfilterwidget.h"
#include "ipackagedb.h"

namespace NPlugin
{

/**
 * Constructors/Destructors
 */

PackageStatusPlugin::PackageStatusPlugin(NApt::IPackageDB* pPackageDB) :
	_title(tr("Package Status Plugin")),
	/// @todo implement descriptions here
	_briefDescription(tr("")),
	_description(tr("")),
	_installedFilter(ALL),
	_pPackageDB(pPackageDB)
{ 
	_pInstalledFilterWidget = 0;
	_stateToText[NApt::Package::INSTALLED] = "x";
	_stateToText[NApt::Package::NOT_INSTALLED] = "";
}

PackageStatusPlugin::~PackageStatusPlugin() 
{ 
	delete _pInstalledFilterWidget;
}

/////////////////////////////////////////////////////
// Plugin Interface
/////////////////////////////////////////////////////
 
void PackageStatusPlugin::init(IProvider* pProvider)
{
	QMainWindow* pWindow = pProvider->mainWindow();
	_pInstalledFilterWidget = new InstalledFilterWidget(pWindow, "Installed Filter Input");
	_pInstalledFilterWidget->show();
	_pHandleMaker = &pProvider->handleMaker();
	connect(_pInstalledFilterWidget->_pInstalledFilterInput, 
		SIGNAL(activated(int)), SLOT(onInstalledFilterChanged(int))
	);	
}

/////////////////////////////////////////////////////
// SearchPlugin Interface
/////////////////////////////////////////////////////

QWidget* PackageStatusPlugin::shortInputAndFeedbackWidget() const
{
	return _pInstalledFilterWidget;
}


bool PackageStatusPlugin::filterPackage(int packageID) const
{
	try 
	{
		NApt::Package::InstalledState state = getState(packageID);
		return _installedFilter == (InstalledState) state;	// does the state of the package match the on filtered by?
	}
	catch (const PackageNotFoundException& e)	// if the package is not in the database, it is not installed
	{
		return _installedFilter == NOT_INSTALLED;
	}
}

bool PackageStatusPlugin::isInactive() const
{
	return _installedFilter == ALL;
}

/////////////////////////////////////////////////////
// ShortInformationPlugin Interface
/////////////////////////////////////////////////////

const QString PackageStatusPlugin::shortInformationText(int packageID)
{
	return _stateToText[getState(packageID)];	// returns the text for the state of the package
}

/////////////////////////////////////////////////////
// PackageStatusPlugin functions
/////////////////////////////////////////////////////

NApt::Package::InstalledState PackageStatusPlugin::getState(int packageID) const
{
	try 
	{
		return _pPackageDB->getState(packageID);
	}
	catch (const PackageNotFoundException& e)
	{
		return NApt::Package::NOT_INSTALLED;
	}
}

void PackageStatusPlugin::onInstalledFilterChanged(int activated)
{
	switch (activated)
	{
		case 0:
			_installedFilter = ALL;
			break;
		case 1:
			_installedFilter = INSTALLED;
			break;
		case 2:
			_installedFilter = NOT_INSTALLED;
			break;
	}
	emit searchChanged(this);
}


}	// namespace NPlugin

