/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class InterruptTest
extends TestCase {
    static final long TIMEOUT = 3000L;
    static final int SLEEP = 1;
    static final int WAIT = 2;
    static final int READ = 3;
    static final int SOCKET_READ = 4;
    Interruptible thread;
    static /* synthetic */ Class class$org$javagroups$tests$InterruptTest;

    public void setUp() {
    }

    public void tearDown() {
    }

    String modeToString(int m) {
        switch (m) {
            case 1: {
                return "SLEEP";
            }
            case 2: {
                return "WAIT";
            }
            case 3: {
                return "READ";
            }
            case 4: {
                return "SOCKET_READ";
            }
        }
        return "<unknown>";
    }

    public void testSleepInterrupt() {
        this.thread = new SleeperThread(1);
        this.runTest(this.thread);
    }

    public void testWaitInterrupt() {
        this.thread = new SleeperThread(2);
        this.runTest(this.thread);
    }

    public void testSocketReadInterrupt() {
        this.thread = new SleeperThread(4);
        this.runTest(this.thread);
    }

    public void testReadInterrupt() {
        this.thread = new SleeperThread(3);
        this.runTest(this.thread);
    }

    void runTest(Interruptible t) {
        System.out.println();
        System.out.println("InterruptTest.runTest(" + this.modeToString(t.getMode()) + "): starting other thread");
        this.thread.start();
        System.out.println("InterruptTest.runTest(" + this.modeToString(t.getMode()) + "): starting other thread -- done");
        System.out.println("InterruptTest.runTest(" + this.modeToString(t.getMode()) + "): sleeping for 3000 msecs");
        this.sleep(3000L);
        System.out.println("InterruptTest.runTest(" + this.modeToString(t.getMode()) + "): sleeping -- done");
        System.out.println("InterruptTest.runTest(" + this.modeToString(t.getMode()) + "): interrupting other thread");
        this.thread.interrupt();
        System.out.println("InterruptTest.runTest(" + this.modeToString(t.getMode()) + "): interrupting other thread -- done");
        System.out.println("InterruptTest.runTest(" + this.modeToString(t.getMode()) + "): joining other thread (timeout=3000 msecs");
        this.thread.join(3000L);
        System.out.println("InterruptTest.runTest(" + this.modeToString(t.getMode()) + "): joining other thread -- done");
        System.out.println("InterruptTest.runTest(" + this.modeToString(t.getMode()) + "): thread.isAlive()=" + this.thread.isAlive());
        InterruptTest.assertTrue((boolean)(this.thread.isAlive() ^ true));
    }

    void sleep(long msecs) {
        try {
            Thread.currentThread();
            Thread.sleep(msecs);
        }
        catch (Exception ex) {
            System.err.println("InterruptTest.sleep(): " + ex);
        }
    }

    public static Test suite() {
        Class clazz = class$org$javagroups$tests$InterruptTest;
        if (clazz == null) {
            clazz = class$org$javagroups$tests$InterruptTest = InterruptTest.class$("[Lorg.javagroups.tests.InterruptTest;", false);
        }
        TestSuite s = new TestSuite(clazz);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)InterruptTest.suite());
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public InterruptTest(String name) {
        super(name);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SleeperThread
    implements Runnable,
    Interruptible {
        Thread t;
        int mode;
        DatagramSocket sock;

        public int getMode() {
            return this.mode;
        }

        public void start() {
            this.t = new Thread(this);
            this.t.start();
        }

        public void interrupt() {
            if (this.t != null) {
                this.t.interrupt();
            }
        }

        public void join(long msecs) {
            if (this.t != null && this.t.isAlive()) {
                try {
                    this.t.join(msecs);
                }
                catch (Exception ex) {
                    System.err.println("InterruptTest.SleepThread.join(): " + ex);
                }
            }
        }

        public boolean isAlive() {
            if (this.t != null) {
                return this.t.isAlive();
            }
            return false;
        }

        public void run() {
            switch (this.mode) {
                case 1: {
                    this.runSleep();
                    break;
                }
                case 2: {
                    this.runWait();
                    break;
                }
                case 3: {
                    this.runRead();
                    break;
                }
                case 4: {
                    this.runSocketRead();
                    break;
                }
            }
        }

        void runSleep() {
            try {
                Thread.currentThread();
                Thread.sleep(3000L);
            }
            catch (InterruptedException ex) {
                System.err.println("InterruptTest.SleeperThread.runSleep(): " + ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void runWait() {
            Object mutex = new Object();
            Object object = mutex;
            synchronized (object) {
                try {
                    mutex.wait();
                }
                catch (InterruptedException ex) {
                    System.err.println("InterruptTest.SleeperThread.runWait(): " + ex);
                }
                return;
            }
        }

        void runRead() {
            try {
                int c = System.in.read();
            }
            catch (Exception ex) {
                System.err.println("InterruptTest.SleeperThread.runRead(): " + ex);
            }
        }

        void runSocketRead() {
            byte[] buf = new byte[2];
            try {
                this.sock = new DatagramSocket(12345, InetAddress.getLocalHost());
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                this.sock.receive(packet);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }

        private final /* synthetic */ void this() {
            this.sock = null;
        }

        SleeperThread(int mode) {
            this.this();
            this.mode = mode;
        }
    }

    static interface Interruptible {
        public void start();

        public void interrupt();

        public void join(long var1);

        public boolean isAlive();

        public int getMode();
    }
}

