/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Properties;
import java.util.Vector;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.protocols.PerfHeader;
import org.javagroups.protocols.PerfObserver;
import org.javagroups.stack.Protocol;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PERF
extends Protocol {
    static final String name = "PERF";
    boolean details;
    Vector members;
    Vector protocols;

    public String getName() {
        return name;
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("details");
        if (str != null) {
            this.details = new Boolean(str);
            props.remove("details");
        }
        if (props.size() > 0) {
            System.err.println("PERF.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void start() throws Exception {
        this.protocols = this.stack != null ? this.stack.getProtocols() : null;
        this.setupObservers();
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                PerfHeader hdr = this.removePerfHeader(msg);
                if (hdr == null) break;
                hdr.setEndTime();
                hdr.setDone(name, 1);
                if (!Trace.trace) break;
                Trace.info("PERF.up()", hdr.printContents(this.details, this.protocols) + "\n---------------------------------\n");
                break;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    if (new_members != null && new_members.size() > 0) {
                        int i = 0;
                        while (i < new_members.size()) {
                            this.members.addElement(new_members.elementAt(i));
                            ++i;
                        }
                    }
                }
                this.passDown(evt);
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                this.initializeMessage(msg);
                break;
            }
        }
        this.passDown(evt);
    }

    void setupObservers() {
        Protocol p = null;
        Vector prots = this.protocols;
        PerfObserver po = null;
        if (prots == null) {
            System.err.println("PERF.setupObservers(): protocol stack is null");
            return;
        }
        int i = 0;
        while (i < prots.size()) {
            p = (Protocol)prots.elementAt(i);
            String pname = p.getName();
            if (pname != null) {
                po = new PerfObserver(pname);
                po.setProtocol(p);
                p.setObserver(po);
            }
            ++i;
        }
    }

    void initializeMessage(Message msg) {
        PerfHeader hdr = new PerfHeader(msg.getSrc(), msg.getDest());
        String pname = null;
        if (this.protocols == null) {
            System.err.println("PERF.initializeMessage(): 'protocols' variable is null");
            return;
        }
        int i = 0;
        while (i < this.protocols.size()) {
            Protocol p = (Protocol)this.protocols.elementAt(i);
            pname = p.getName();
            if (pname != null) {
                hdr.addEntry(pname);
            }
            ++i;
        }
        hdr.setReceived(name, 2);
        msg.putHeader(name, hdr);
    }

    PerfHeader removePerfHeader(Message m) {
        Header hdr = null;
        if (m == null || (hdr = m.removeHeader(name)) == null) {
            return null;
        }
        return (PerfHeader)hdr;
    }

    private final /* synthetic */ void this() {
        this.details = false;
        this.members = new Vector();
        this.protocols = null;
    }

    public PERF() {
        this.this();
    }
}

