/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.log;

import java.util.Date;
import org.javagroups.log.Format;

public abstract class Tracer {
    protected static String timestampFormat = null;
    protected String module;
    protected int level;
    protected boolean autoFlush;
    protected boolean closed;

    public static void setTimestampFormat(String format) {
        timestampFormat = format;
    }

    public String getModule() {
        return this.module;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean getAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
        if (autoFlush) {
            this.flush();
        }
    }

    public void print(String module, int level, String message) {
        if (level >= this.level) {
            this.doPrint(this.logString(module, level, message));
            if (this.autoFlush) {
                this.flush();
            }
        }
    }

    public void print(String module, int level, String identifier, String message) {
        if (level >= this.level) {
            this.doPrint(this.logString(module, level, identifier, message));
            if (this.autoFlush) {
                this.flush();
            }
        }
    }

    public void flush() {
        if (!this.closed) {
            this.doFlush();
        }
    }

    public void close() {
        if (!this.closed) {
            this.flush();
            this.doClose();
            this.closed = true;
        }
    }

    protected String logString(String module, int level, String message) {
        StringBuffer sb = new StringBuffer();
        sb.append("[").append(this.timestamp()).append("] [").append(Format.levelToString(level)).append("] ");
        sb.append(module).append(": ").append(message);
        return sb.toString();
    }

    protected String logString(String module, int level, String identifier, String message) {
        StringBuffer sb = new StringBuffer();
        sb.append("[").append(this.timestamp()).append("] [").append(Format.levelToString(level)).append("] ");
        sb.append("[").append(identifier).append("] ").append(module).append(": ").append(message);
        return sb.toString();
    }

    protected String timestamp() {
        return Format.formatTimestamp(new Date(), timestampFormat);
    }

    protected abstract void doPrint(String var1);

    protected abstract void doFlush();

    protected abstract void doClose();

    Tracer(String module, int level) {
        this.module = module;
        this.level = level;
        this.closed = false;
    }
}

