#ifndef NEUTRINO_WINDOW_PRIVATE_H
#define NEUTRINO_WINDOW_PRIVATE_H

#include <gtk/gtkliststore.h>

#include "neutrino-window.h"

#include "neutrino-jukebox-view.h"

#include "neutrino-file-browser.h"

#include "libegg/menu/egg-menu-merge.h"
#include "libegg/menu/egg-action-group.h"
#include "libegg/menu/egg-toggle-action.h"
#include "libegg/toolbar/eggtoolbar.h"

enum {
	NEUTRINO_VIEW_NONE = 0,
	NEUTRINO_VIEW_JUKEBOX,
	NEUTRINO_VIEW_LOCAL,
	NEUTRINO_VIEW_PLAYLIST
};
enum {
	NEUTRINO_DISPLAY_COL = 0,
	NEUTRINO_TYPE_COL,
	NEUTRINO_DATA_COL,
	NEUTRINO_ICON_COL,
	NEUTRINO_COLS
};

struct NeutrinoWindowDetails
{
	/* ui stuff */
	EggActionGroup *group;
	EggMenuMerge *merge;

	NeutrinoJukeboxView *view;
	NeutrinoFileBrowser *browser;

	GtkWidget *statusbar;
	guint statusclear;

	GtkListStore *store;
	GtkTreePath *jukeboxes_path;
	GtkWidget *list;
	
	/* main sidebar */
	GtkWidget *sidebar;

	GtkWidget *library;

	/* play queue display */
	GtkListStore *queue;

	guint total_tracks;
	guint total_playlists;
	guint total_datafiles;
	guint64 total_space;
	guint64 total_free;
	guint64 total_used;
};

void neutrino_window_initialise_menus( NeutrinoWindow *window );

#endif
