/*

Copyright (C) 2000, 2001, 2002 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include <netdude/nd_macros.h>
#include <netdude/nd_packet.h>
#include <netdude/nd_trace.h>
#include <netdude/nd_protocol_inst.h>
#include <netdude/nd_null_protocol.h>


static void
null_proto_init(void)
{
}

static GtkWidget *
null_proto_create_gui(ND_Trace *trace, ND_ProtoInfo *pinf)
{
  return NULL;
  TOUCH(trace);
  TOUCH(pinf);
}

static void     
null_proto_set_gui(const ND_Packet *packet, ND_ProtoInfo *pinf)
{
  return;
  TOUCH(packet);
  TOUCH(pinf);
}

static void     
null_proto_init_packet(ND_Packet *packet, guchar *data, guchar *data_end)
{
  return;
  TOUCH(packet);
  TOUCH(data);
  TOUCH(data_end);
}

static gboolean 
null_proto_header_complete(const ND_Packet *packet, guint nesting)
{
  return FALSE;
  TOUCH(packet);
  TOUCH(nesting);
}

static gboolean
null_proto_fix_packet(ND_Packet *packet, int index)
{
  return FALSE;
  TOUCH(packet);
  TOUCH(index);
}

static void
null_proto_init_state(ND_Trace *trace)
{
  return;
  TOUCH(trace);
}

static void       
null_proto_update_state(const ND_Packet *packet, int index)
{
  return;
  TOUCH(packet);
  TOUCH(index);
}

static void       
null_proto_update_tcpdump_line(const ND_Packet *packet, char *line)
{
  return;
  TOUCH(packet);
  TOUCH(line);
}

static void       
null_proto_free_state(ND_Trace *trace)
{
  return;
  trace = NULL;
}



void
nd_null_proto_hook_up(ND_Protocol *proto)
{
  if (!proto)
    return;

  proto->init_proto          = null_proto_init;
  proto->create_gui          = null_proto_create_gui;
  proto->set_gui             = null_proto_set_gui;
  proto->init_packet         = null_proto_init_packet;
  proto->header_complete     = null_proto_header_complete;
  proto->fix_packet          = null_proto_fix_packet;
  proto->init_state          = null_proto_init_state;
  proto->update_state        = null_proto_update_state;
  proto->update_tcpdump_line = null_proto_update_tcpdump_line;
  proto->free_state          = null_proto_free_state;
}

