/*
 *   Written by Bradley Broom (2004).
 *
 *   Copyright (c) 2004 Bradley Broom
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <math.h>
#include <string.h>
#include "MRI.h"
#include "vmedian.h"

struct LimitMaskData {
	MRI_Link *next;
	int	width;
	int	height;
};

static void
LimitMaskStart (void *private, int width, int height, int freedata)
{
	struct LimitMaskData *wd = private;

	wd->width = width;
	wd->height = height;
	(*wd->next->start) (wd->next->private, width, height, freedata);
}

static void
LimitMaskRow (void *private, void *data)
{
	struct LimitMaskData *wd = private;
	struct MRI_ScanLine *sl = data;
	int x;
	unsigned short *R = sl->R;
	unsigned short *G = sl->G;
	unsigned short *B = sl->B;

	memset (sl->masks, '\0', sizeof(sl->masks[0]) * wd->width);
	for (x = 0; x < wd->width; x++) {
		if (R[x] >= 0xF700) sl->masks[x] |= 1;
	}
	for (x = 0; x < wd->width; x++) {
		if (G[x] >= 0xF700) sl->masks[x] |= 2;
	}
	for (x = 0; x < wd->width; x++) {
		if (B[x] >= 0xF700) sl->masks[x] |= 4;
	}
	(*wd->next->row) (wd->next->private, sl);
}

static void
LimitMaskClose (void *private)
{
	struct LimitMaskData *wd = private;
	(*wd->next->close) (wd->next->private);
	free (wd->next);
	free (wd);
}

MRI_Link *
MRI_GenLimitMasker (MRI_Link *next)
{
	struct LimitMaskData *wd = malloc (sizeof (struct LimitMaskData));
	MRI_Link *ep = malloc (sizeof (*ep));
	if (wd == (struct LimitMaskData *)0 ||
	    ep == (MRI_Link *)0) {
		fprintf (stderr, "Error: unable to allocate memory!\n");
		exit (1);
	}
	ep->start = LimitMaskStart;
	ep->row = LimitMaskRow;
	ep->close = LimitMaskClose;
	ep->private = wd;
	wd->next = next;

	return ep;
}
