/*

    mp_iface.h

    Interface.

    mp - Programmer Text Editor

    Copyright (C) 1991-2001 Angel Ortega <angel@triptico.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    http://www.triptico.com

*/


extern int _mpi_shift;
extern int _mpi_reposition_cursor;
extern int _mpi_macro_index;
extern int _mpi_instant_x;
extern int _mpi_instant_y;
extern int _mpi_mark_column_80;
extern int _mpi_list_selection;
extern int _mpi_exit_requested;
extern char _mpi_template_file[1024];

extern int mpi_alt_color;
extern int mpi_mouse;
extern int mpi_monochrome;
extern int mpi_transp_mode;
extern int mpi_move_selecting;

extern char * MP_LICENSE;


void mpi_draw_all(mp_txt * txt);

void mpi_open(char * name, int reopen);
void mpi_save(mp_txt * txt);
void mpi_save_as(mp_txt * txt);
void mpi_close(mp_txt * txt);

int mpi_find_tag(char * tag, int select_only);
int mpi_insert_template(void);

int mpi_action(mp_txt * txt, int key);

int mpi_args_1(int argc, char * argv[]);
int mpi_args_2(int argc, char * argv[]);

void mpi_startup(void);
void mpi_shutdown(void);

/* #include LANG_FILE */
