#ifndef PARTICLEFOUNTAINS_H
#define PARTICLEFOUNTAINS_H

#include "Tools.h"
#include "MathTools.h"
#include "StaticDecorationBase.h"

//----------------------------------------------------------------------------
class ParticleFountainSurfaces : public OrientatingSurfacesBase
{
    SURFACES_SINGLETON_OBJECT(ParticleFountainSurfaces);
};



//----------------------------------------------------------------------------
#undef DECLARE_UPDATE_STATE
#define DECLARE_UPDATE_STATE(c) \
    class c; \
    friend class c; \
    class c : public UpdateState \
    { \
        STATE_OBJECT(c); \
      public: \
        c() {} \
        ~c() {} \
        void update(ParticleFountainBase *f); \
    }


//----------------------------------------------------------------------------
class ParticleFountainBase : public StaticDecorationBase,
                             public AnimatedDecorationBase,
                             public OrientatingDecorationBase
{
    //------------------------------------------------------------------------
    class UpdateState
    {
      protected:
        UpdateState() {}
      public:
        virtual ~UpdateState() {}

        virtual void update(ParticleFountainBase *f) = 0;
    };

    //------------------------------------------------------------------------
    DECLARE_UPDATE_STATE(Initial);
    DECLARE_UPDATE_STATE(InitialDelay);
    DECLARE_UPDATE_STATE(PermanentActivation);
    DECLARE_UPDATE_STATE(Activated);
    DECLARE_UPDATE_STATE(Deactivated);


  public:

    //------------------------------------------------------------------------
    class InitializationData
        : public StaticDecorationBase::InitializationData,
          public AnimatedDecorationBase::InitializationData,
          public OrientatingDecorationBase::InitializationData
    {
      public:
        InitializationData();
        InitializationData(const XMLNode *fountainNode);
        ~InitializationData();

        unsigned speed;
        unsigned lifeTime;
        unsigned scatter;
    };


    //------------------------------------------------------------------------
    virtual ~ParticleFountainBase();


    //------------------------------------------------------------------------
    inline const MATH_TOOLS::Vector &getParticleInitialVelocity() const
    {
        return m_particleInitialVelocity;
    }

    inline unsigned getParticleSpeed() const
    {
        return m_particleSpeed;
    }
    inline unsigned getParticleLifeTime() const
    {
        return m_particleLifeTime;
    }
    inline unsigned getParticleScatter() const
    {
        return m_particleScatter;
    }

    inline void setUpdateState(UpdateState *state)
    {
        m_updateState = state;
    }

    //------------------------------------------------------------------------
    void update();

    //------------------------------------------------------------------------
    void updateSurface();

    //------------------------------------------------------------------------
    static ParticleFountainBase *create(const InitializationData &init);
    static ParticleFountainBase *create(const XMLNode *fountainNode);

  protected:
    //------------------------------------------------------------------------
    ParticleFountainBase(const InitializationData &init);

    inline MATH_TOOLS::Vector &getParticleInitialVelocity()
    {
        return m_particleInitialVelocity;
    }

    unsigned m_frameCounter;
    unsigned m_createParticleCounter;

  private:
    //------------------------------------------------------------------------
    DECLARE_OBJECT_VISITOR_API();

    //------------------------------------------------------------------------
    unsigned m_particleSpeed;
    unsigned m_particleLifeTime;
    unsigned m_particleScatter;

    MATH_TOOLS::Vector m_particleInitialVelocity;

    UpdateState *m_updateState;
};

//----------------------------------------------------------------------------
class TopParticleFountain : public ParticleFountainBase
{
  public:
    TopParticleFountain(const InitializationData &init);
    ~TopParticleFountain();
};

//----------------------------------------------------------------------------
class BottomParticleFountain : public ParticleFountainBase
{
  public:
    BottomParticleFountain(const InitializationData &init);
    ~BottomParticleFountain();
};

//----------------------------------------------------------------------------
class LeftParticleFountain : public ParticleFountainBase
{
  public:
    LeftParticleFountain(const InitializationData &init);
    ~LeftParticleFountain();
};

//----------------------------------------------------------------------------
class RightParticleFountain : public ParticleFountainBase
{
  public:
    RightParticleFountain(const InitializationData &init);
    ~RightParticleFountain();
};

#endif //PARTICLEFOUNTAINS_H
