#ifndef MOVINGOBJECTBASE_H
#define MOVINGOBJECTBASE_H

#include "MathTools.h"
#include "ObjectBase.h"


//----------------------------------------------------------------------------
/**
 * Base class for all objects that move,
 * such as ships, projectiles, particles, etc.
 */
class MovingObjectBase : public ObjectBase
{
  public:
    //------------------------------------------------------------------------
    virtual ~MovingObjectBase();

    //------------------------------------------------------------------------
    /**
     * Update the x and y values for m_position
     * out m_fineXPosition and m_fineYPosition.
     */
    inline void updatePosition()
    {
        ObjectBase::setPosition(
            (Sint16)trunc(m_finePosition.getX()),
            (Sint16)trunc(m_finePosition.getY()));
    }

    /**
     * Overload ObjectBase::setPosition() to set the fine-scale position
     * stored in m_fineXPosition and m_fineYPosition.
     *
     * @param x The new x position.
     * @param y The new y position.
     */
    inline void setPosition(Sint16 x, Sint16 y)
    {
        m_finePosition.set(1.0 * x, 1.0 * y);
        ObjectBase::setPosition(x, y);
    }


    //------------------------------------------------------------------------
    /**
     * @return The current fine scale position.
     */
    inline const MATH_TOOLS::Vector &getFinePosition() const
    {
        return m_finePosition;
    }

    /**
     * @return The current fine scale position.
     */
    inline MATH_TOOLS::Vector &getFinePosition()
    {
        return m_finePosition;
    }

    //------------------------------------------------------------------------
    /**
     * @return The current fine scale velocity.
     */
    inline const MATH_TOOLS::Vector &getFineVelocity() const
    {
        return m_fineVelocity;
    }

    /**
     * @return The current fine scale velocity.
     */
    inline MATH_TOOLS::Vector &getFineVelocity()
    {
        return m_fineVelocity;
    }

  protected:
    //------------------------------------------------------------------------
    MovingObjectBase(const unsigned creatorId);

  private:
    //------------------------------------------------------------------------
    /// The current fine-scale velocity of this object.
    MATH_TOOLS::Vector m_fineVelocity;

    /// The object's fine-scale position.
    MATH_TOOLS::Vector m_finePosition;
};

#endif //MOVINGOBJECTBASE_H
