/***************************************************
	mined keyboard mapping table
	* originally generated with mkkbmap
	  from lib/kbmaps/cxterm/*/PY.tit
	* supplemented with word mappings
	  from UCDOSPY.tit
	* supplemented with punctuation mappings
	* corrected, updated and maintained by
	  吴咏炜 Wu Yongwei <yongwei@eastday.com>
	  (esp. Pinyin words, see below)
*/
struct keymap keymap_Pinyin [] = {
	{"!", "！"},
	{"#", "〃 々 〆 〇 〜 ￦"},
	{"$", "￥"},
	{"&", "―"},
	{"(", "（"},
	{")", "）"},
	{",", "，"},
	{".", "。"},
	{":", "："},
	{";", "；"},
	{"<", "〈"},
	{"<<", "《"},
	{">", "〉"},
	{">>", "》"},
	{"?", "？"},
	{"@", "・"},
	{"[", "【 〖 〔 「 『"},
	{"\\", "、"},
	{"]", "】 〗 〕 」 』"},
	{"^", "……"},
	{"_", "――"},
	{"«", "《"},
	{"»", "》"},
	{"€", "€ ＄ ￥ ￦ ￡ ￠ ￢ ￣"},

	{"a", "阿 啊 呵 腌 嗄 锕 吖"},
	{"ai", "爱 呆 哀 挨 碍 埃 癌 艾 唉 矮 哎 皑 蔼 隘 暧 霭 捱 嗳 瑷 嫒 锿 嗌 砹"},
	{"an", "安 案 按 暗 岸 俺 谙 黯 鞍 氨 庵 桉 鹌 胺 铵 揞 犴 埯 广 厂"},
	{"ang", "昂 肮 盎"},
	{"ao", "奥 澳 傲 熬 敖 嚣 凹 袄 懊 坳 嗷 拗 鏖 骜 鳌 翱 岙 廒 遨 獒 聱 媪 螯 鏊"},
	{"bai", "百 白 败 摆 伯 拜 柏 呗 掰 捭 佰 稗"},
	{"ban", "办 半 版 般 班 板 伴 搬 扮 斑 颁 瓣 拌 扳 绊 阪 坂 瘢 钣 舨 癍"},
	{"bang", "帮 邦 棒 膀 榜 傍 绑 磅 谤 浜 梆 镑 蚌 蒡"},
	{"ben", "本 奔 笨 苯 夯 畚 贲 锛 坌"},
	{"beng", "崩 甭 绷 蹦 迸 甏 泵 嘣 蚌"},
	{"biao", "表 标 彪 勺 镖 膘 骠 镳 裱 杓 飙 瘭 髟 飚 婊 飑 鳔"},
	{"bie", "别 憋 瘪 蹩 鳖"},
	{"bin", "宾 滨 彬 斌 鬓 缤 殡 濒 槟 摈 膑 傧 玢 豳 髌 镔"},
	{"bing", "并 病 兵 冰 饼 屏 丙 柄 秉 炳 槟 禀 邴 摒"},
	{"bu", "不 部 布 步 补 捕 堡 怖 卜 簿 哺 埔 卟 埠 钸 逋 醭 晡 瓿 钚"},
	{"ca", "擦 拆 嚓 礤"},
	{"cai", "才 采 菜 财 材 彩 裁 猜 蔡 踩 睬"},
	{"can", "参 餐 残 惨 灿 惭 掺 蚕 璨 孱 骖 黪 粲"},
	{"cang", "藏 苍 仓 沧 舱 伧"},
	{"cao", "草 操 曹 糙 嘈 槽 螬 艚 漕"},
	{"ce", "策 测 侧 厕 册 恻"},
	{"cen", "参 岑 涔"},
	{"ceng", "曾 层 蹭 噌"},
	{"cha", "查 察 差 茶 插 刹 叉 诧 茬 碴 喳 岔 嚓 衩 杈 楂 槎 檫 镲 搽 锸 猹 馇 汊 姹"},
	{"chai", "差 柴 拆 豺 钗 侪 虿 瘥"},
	{"chao", "超 朝 潮 炒 吵 抄 嘲 钞 绰 巢 剿 晁 焯 怊 耖"},
	{"che", "车 彻 撤 尺 扯 澈 掣 坼 砗"},
	{"chen", "称 陈 沉 晨 沈 尘 臣 趁 衬 辰 郴 秤 谶 琛 橙 忱 嗔 伧 抻 谌 宸 榇 龀 碜"},
	{"chong", "种 重 冲 充 涌 崇 虫 宠 憧 忡 艟 茺 舂 铳"},
	{"chou", "抽 愁 仇 丑 筹 臭 酬 绸 踌 瞅 惆 畴 稠 雠 俦 帱 瘳"},
	{"chuai", "揣 啜 踹 嘬 膪 搋"},
	{"chuan", "传 穿 川 船 串 喘 舛 遄 舡 巛 氚 椽 钏"},
	{"chuang", "创 窗 床 闯 幢 疮 怆"},
	{"chui", "吹 垂 炊 锤 捶 陲 椎 槌 棰"},
	{"chun", "春 纯 唇 蠢 醇 淳 椿 鹑 蝽 莼"},
	{"chuo", "绰 戳 啜 辍 踔 龊"},
	{"ci", "此 次 词 差 刺 辞 慈 磁 赐 瓷 兹 茨 伺 雌 祠 疵 呲 鹚 糍 茈"},
	{"cong", "从 匆 聪 丛 葱 囱 琮 淙 枞 苁 骢 璁"},
	{"cou", "凑 楱 辏 腠"},
	{"cu", "促 粗 簇 醋 卒 猝 蹴 蹙 徂 殂 蔟 酢"},
	{"cuan", "攒 窜 篡 蹿 撺 镩 汆 爨"},
	{"cui", "脆 衰 粹 催 摧 崔 萃 翠 瘁 悴 璀 隹 淬 毳 榱 啐"},
	{"cun", "存 村 寸 蹲 忖 皴"},
	{"cuo", "错 措 搓 挫 撮 磋 蹉 矬 嵯 脞 痤 瘥 鹾 厝 锉"},
	{"da", "大 打 达 答 搭 塔 瘩 嗒 沓 耷 褡 鞑 笪 靼 怛 妲 哒 疸"},
	{"dai", "大 代 带 待 戴 袋 呆 贷 逮 歹 殆 黛 怠 玳 岱 迨 傣 呔 骀 绐 埭 甙"},
	{"dang", "当 党 荡 档 挡 裆 铛 宕 凼 菪 谠 砀"},
	{"dao", "到 道 导 倒 岛 刀 悼 盗 蹈 捣 祷 叨 稻 焘 忉 帱 氘 纛"},
	{"de", "的 地 得 德 底 锝"},
	{"dei", "得"},
	{"deng", "等 登 灯 邓 凳 瞪 澄 蹬 噔 磴 戥 镫 簦 嶝"},
	{"dia", "嗲"},
	{"diao", "调 掉 鸟 吊 雕 刁 钓 凋 叼 貂 碉 铫 铞 鲷"},
	{"die", "爹 跌 叠 迭 碟 谍 蝶 喋 佚 踮 牒 耋 蹀 堞 瓞 揲 垤 鲽"},
	{"ding", "定 订 顶 丁 盯 钉 鼎 叮 町 铤 腚 酊 仃 锭 疔 啶 玎 碇 耵"},
	{"diu", "丢 铥"},
	{"dong", "动 东 懂 冬 洞 冻 董 栋 咚 恫 侗 氡 硐 鸫 岽 垌 峒 胨 胴"},
	{"dou", "都 读 斗 豆 抖 逗 兜 陡 窦 蔸 蚪 篼 痘"},
	{"du", "都 读 度 独 顿 毒 督 渡 肚 杜 睹 堵 赌 妒 嘟 渎 笃 牍 镀 犊 黩 髑 椟 芏 蠹"},
	{"duan", "断 段 短 端 锻 缎 煅 椴 簖"},
	{"dui", "对 队 堆 兑 敦 碓 憝 怼 镦"},
	{"dun", "顿 盾 吨 敦 蹲 钝 炖 遁 盹 沌 囤 墩 趸 镦 礅 砘"},
	{"duo", "多 度 夺 朵 躲 舵 堕 踱 咄 跺 哆 剁 惰 垛 驮 掇 铎 裰 哚 缍 沲 柁"},
	{"ei", "诶"},
	{"en", "恩 摁 蒽"},
	{"er", "而 二 儿 尔 耳 迩 饵 洱 鸸 珥 铒 鲕 贰 佴"},
	{"fa", "发 法 罚 乏 伐 阀 砝 筏 垡 珐"},
	{"fan", "反 饭 犯 翻 范 凡 烦 返 番 贩 繁 泛 帆 藩 幡 梵 樊 燔 蕃 畈 钒 蘩 矾 蹯"},
	{"fang", "方 放 房 访 防 仿 芳 妨 纺 彷 坊 肪 舫 钫 鲂 邡 枋"},
	{"fen", "分 份 纷 奋 愤 粉 氛 芬 坟 焚 粪 忿 吩 汾 棼 鼢 玢 酚 偾 瀵 鲼"},
	{"feng", "风 封 丰 峰 疯 锋 逢 奉 缝 凤 讽 冯 蜂 枫 烽 俸 砜 唪 酆 葑 沣"},
	{"fo", "佛"},
	{"fou", "否 缶"},
	{"ga", "夹 咖 尬 嘎 胳 噶 轧 伽 旮 钆 尕 尜"},
	{"gai", "改 该 概 盖 丐 钙 赅 芥 溉 垓 陔 戤"},
	{"gan", "感 干 敢 赶 甘 肝 杆 尴 赣 乾 橄 竿 秆 擀 坩 苷 柑 泔 矸 澉 疳 酐 淦 绀 旰"},
	{"gang", "刚 港 钢 岗 纲 缸 扛 杠 冈 肛 罡 戆 筻"},
	{"gao", "高 告 稿 搞 糕 膏 皋 羔 睾 槁 藁 缟 篙 镐 诰 槔 杲 郜 锆"},
	{"gen", "根 跟 亘 艮 哏 茛"},
	{"geng", "更 耿 耕 颈 庚 羹 梗 哽 赓 鲠 埂 绠"},
	{"gong", "工 公 共 红 供 功 攻 宫 贡 恭 巩 躬 龚 弓 拱 肱 汞 蚣 珙 觥"},
	{"gou", "句 够 购 构 狗 沟 勾 苟 钩 觏 篝 垢 佝 岣 诟 鞲 笱 枸 遘 媾 缑 彀"},
	{"gua", "括 挂 瓜 刮 寡 呱 褂 卦 剐 鸹 栝 胍 诖"},
	{"guai", "怪 乖 拐 掴"},
	{"guan", "关 观 管 官 馆 惯 冠 贯 罐 灌 棺 矜 莞 倌 纶 掼 盥 涫 鳏 鹳"},
	{"guang", "广 光 逛 犷 咣 胱 桄"},
	{"gun", "滚 棍 鲧 绲 磙 辊 衮"},
	{"guo", "国 过 果 锅 郭 裹 涡 帼 蝈 聒 馘 掴 埚 虢 呙 崞 猓 椁 蜾"},
	{"ha", "哈 虾 蛤 铪"},
	{"hai", "还 海 孩 害 嘿 咳 亥 骇 骸 嗨 胲 醢 氦"},
	{"hang", "行 航 巷 吭 杭 夯 沆 颃 绗 珩"},
	{"hao", "好 号 毫 豪 浩 耗 皓 嚎 昊 郝 壕 蒿 貉 灏 镐 嗥 嚆 薅 濠 蚝 颢"},
	{"hei", "黑 嘿 嗨"},
	{"hen", "很 恨 狠 痕"},
	{"heng", "行 横 衡 恒 哼 亨 蘅 珩 桁"},
	{"hng", "哼"},
	{"hong", "红 轰 洪 鸿 哄 宏 虹 弘 烘 泓 闳 薨 讧 蕻 訇 黉 荭"},
	{"hou", "后 候 後 厚 侯 喉 吼 猴 逅 糇 骺 堠 瘊 篌 鲎"},
	{"hua", "话 华 化 花 划 画 滑 哗 桦 豁 猾 砉 铧 骅"},
	{"huai", "划 怀 坏 徊 淮 槐 踝"},
	{"huang", "黄 皇 荒 晃 慌 煌 惶 恍 谎 璜 徨 簧 凰 幌 潢 蝗 蟥 遑 隍 肓 磺 癀 湟 篁 鳇"},
	{"hun", "婚 混 魂 昏 浑 馄 荤 诨 溷 阍 珲"},
	{"huo", "和 或 活 火 获 货 伙 祸 惑 霍 豁 夥 锪 耠 劐 钬 攉 藿 嚯 镬 蠖"},
	{"jiang", "将 讲 强 江 奖 降 蒋 疆 酱 姜 浆 僵 虹 匠 犟 缰 绛 桨 耩 礓 洚 豇 茳 糨"},
	{"jiong", "窘 炯 迥 扃 炅"},
	{"juan", "捐 圈 卷 倦 俊 眷 娟 隽 绢 鹃 涓 镌 锩 鄄 狷 桊 蠲"},
	{"jun", "军 均 君 俊 峻 钧 隽 筠 龟 菌 郡 骏 竣 麇 皲 捃 浚"},
	{"ka", "卡 咖 咯 喀 咔 佧 胩"},
	{"kai", "开 慨 凯 铠 揩 楷 恺 垲 蒈 锎 剀 锴 忾"},
	{"kan", "看 刊 侃 堪 砍 坎 嵌 槛 勘 瞰 龛 阚 莰 戡"},
	{"kang", "抗 康 慷 扛 炕 亢 糠 伉 闶 钪"},
	{"kao", "考 靠 铐 烤 拷 犒 栲 尻"},
	{"ken", "肯 恳 啃 垦 龈 裉"},
	{"keng", "坑 吭 铿"},
	{"kong", "空 恐 控 孔 倥 崆 箜"},
	{"kou", "口 扣 抠 寇 叩 蔻 眍 芤 筘"},
	{"ku", "苦 哭 库 裤 酷 枯 窟 骷 刳 堀 喾 绔"},
	{"kua", "夸 跨 垮 挎 胯 侉"},
	{"kuai", "会 快 块 筷 脍 蒯 哙 侩 狯 浍 郐"},
	{"kuan", "款 宽 髋"},
	{"kuang", "况 狂 矿 框 旷 眶 筐 匡 哐 邝 诓 夼 诳 圹 纩 贶"},
	{"kun", "困 昆 捆 坤 鲲 悃 髡 锟 醌 阃 琨"},
	{"kuo", "括 适 阔 扩 廓 栝 蛞"},
	{"la", "落 拉 蓝 啦 辣 腊 喇 垃 蜡 剌 邋 旯 瘌 砬"},
	{"lai", "来 赖 莱 睐 癞 籁 徕 涞 赉 铼 崃 濑"},
	{"lan", "兰 蓝 栏 烂 懒 览 滥 拦 篮 揽 澜 榄 婪 缆 斓 岚 阑 褴 镧 罱 谰 漤"},
	{"lang", "浪 狼 朗 郎 廊 琅 螂 榔 啷 莨 锒 稂 阆 蒗"},
	{"lao", "老 落 劳 络 牢 捞 姥 佬 潦 唠 烙 酪 涝 崂 痨 醪 铹 栳 铑 耢"},
	{"le", "了 乐 勒 肋 叻 泐 鳓 仂"},
	{"lei", "类 泪 累 雷 勒 蕾 垒 磊 擂 肋 儡 羸 诔 镭 嘞 檑 嫘 缧 酹 耒"},
	{"leng", "冷 愣 楞 棱 塄"},
	{"lia", "俩"},
	{"liang", "两 量 良 亮 辆 梁 俩 凉 粮 谅 粱 晾 踉 莨 墚 魉 椋 靓"},
	{"liao", "了 料 聊 疗 辽 僚 廖 寥 镣 潦 撩 撂 缭 燎 寮 嘹 钌 獠 鹩 蓼 尥"},
	{"lie", "列 烈 裂 劣 猎 咧 趔 冽 洌 捩 埒 躐 鬣"},
	{"lin", "林 临 秘 邻 琳 淋 霖 麟 凛 吝 鳞 磷 躏 赁 嶙 辚 檩 遴 粼 蔺 懔 瞵 啉 膦 廪"},
	{"liu", "六 留 流 陆 刘 溜 柳 碌 瘤 榴 浏 硫 琉 遛 馏 镏 骝 绺 锍 旒 熘 鎏 鹨"},
	{"lo", "咯"},
	{"long", "龙 弄 隆 笼 胧 拢 咙 聋 垄 珑 窿 陇 癃 茏 栊 泷 垅 砻"},
	{"lou", "楼 露 陋 漏 搂 喽 篓 偻 娄 髅 蝼 镂 蒌 嵝 耧 瘘"},
	{"luan", "乱 卵 峦 挛 孪 栾 銮 娈 滦 鸾 脔"},
	{"lue", "略 掠 锊"},
	{"lun", "论 轮 伦 沦 仑 抡 囵 纶"},
	{"lv", "律 旅 绿 率 虑 履 屡 侣 缕 驴 吕 榈 滤 捋 铝 褛 偻 闾 膂 氯 稆"},
	{"m", "呒"},
	{"ma", "么 马 吗 妈 码 麻 骂 嘛 摩 抹 玛 蚂 蟆 唛 杩 犸 嬷"},
	{"mai", "买 卖 麦 埋 迈 脉 霾 劢 荬"},
	{"man", "满 慢 漫 埋 曼 蛮 馒 瞒 蔓 颟 谩 墁 幔 螨 鞔 鳗 缦 熳 镘"},
	{"mang", "忙 茫 盲 芒 氓 莽 蟒 邙 漭 硭"},
	{"me", "么 麽"},
	{"men", "们 门 闷 扪 懑 焖 钔"},
	{"meng", "梦 蒙 猛 盟 朦 孟 氓 萌 勐 懵 檬 蠓 瞢 甍 礞 蜢 虻 艋 艨 锰"},
	{"mian", "面 免 棉 眠 缅 绵 勉 腼 冕 娩 湎 沔 眄 黾 渑"},
	{"miao", "妙 描 秒 庙 苗 渺 瞄 藐 缪 淼 缈 喵 眇 邈 鹋 杪"},
	{"mie", "灭 蔑 篾 咩 乜 蠛"},
	{"min", "民 敏 悯 闽 泯 珉 皿 抿 闵 苠 岷 缗 玟 愍 黾 鳘"},
	{"ming", "名 明 命 鸣 盟 铭 冥 茗 溟 酩 瞑 暝 螟"},
	{"miu", "谬 缪"},
	{"mou", "某 谋 牟 眸 缪 鍪 哞 侔 蛑"},
	{"mu", "目 母 木 模 幕 姆 慕 牧 墓 募 暮 牟 姥 亩 穆 睦 拇 沐 牡 仫 坶 苜 毪 钼"},
	{"n", "嗯 唔"},
	{"na", "那 南 拿 呢 哪 纳 娜 呐 捺 钠 镎 肭 衲"},
	{"nai", "哪 乃 奶 奈 耐 氖 艿 鼐 佴 萘 柰"},
	{"nan", "难 南 男 楠 喃 囡 囝 腩 蝻 赧"},
	{"nang", "囊 囔 馕 攮 曩"},
	{"nao", "脑 闹 努 恼 挠 瑙 淖 呶 猱 铙 孬 硇 蛲 垴"},
	{"ne", "呢 哪 呐 讷"},
	{"nei", "那 内 哪 馁"},
	{"nen", "嫩 恁"},
	{"neng", "能"},
	{"ng", "嗯 唔"},
	{"ni", "你 呢 尼 泥 尿 逆 倪 匿 拟 腻 妮 霓 昵 溺 旎 睨 鲵 坭 猊 怩 伲 祢 慝 铌"},
	{"nian", "年 念 廿 酿 粘 碾 捻 蔫 撵 拈 黏 鲶 鲇 辇 埝"},
	{"niang", "娘 酿"},
	{"niao", "鸟 尿 袅 溺 嬲 茑 脲"},
	{"nie", "捏 涅 聂 孽 蹑 嗫 啮 镊 镍 乜 陧 颞 臬 蘖"},
	{"nin", "您 恁"},
	{"ning", "宁 凝 拧 泞 咛 狞 柠 佞 聍 苎 甯"},
	{"niu", "牛 纽 扭 妞 钮 拗 忸 狃"},
	{"nong", "农 弄 浓 侬 哝 脓"},
	{"nou", "耨"},
	{"nu", "怒 努 奴 弩 驽 胬 孥"},
	{"nuan", "暖"},
	{"nue", "虐 疟"},
	{"nuo", "诺 娜 挪 懦 糯 喏 搦 傩 锘"},
	{"nv", "女 钕 恧 衄"},
	{"o", "哦 噢 喔"},
	{"ou", "区 欧 偶 殴 呕 鸥 讴 瓯 藕 沤 耦 怄"},
	{"pa", "派 怕 爬 帕 扒 趴 啪 琶 葩 耙 杷 钯 筢"},
	{"pai", "派 排 牌 迫 拍 徘 湃 俳 蒎 哌"},
	{"pan", "般 判 盘 番 盼 叛 胖 畔 潘 攀 扳 拚 蹒 磐 爿 蟠 襻 袢 泮"},
	{"pang", "旁 庞 胖 乓 膀 磅 彷 螃 滂 耪 逄"},
	{"pao", "跑 炮 抛 泡 袍 刨 咆 狍 疱 脬 庖 匏"},
	{"pei", "配 陪 培 佩 赔 沛 裴 呸 胚 醅 锫 辔 帔 旆 霈"},
	{"pen", "盆 喷 湓"},
	{"peng", "朋 鹏 碰 彭 捧 棚 蓬 膨 烹 抨 篷 砰 澎 怦 堋 蟛 嘭 硼"},
	{"pian", "便 片 篇 偏 骗 翩 扁 犏 谝 蹁 骈 缏 胼"},
	{"piao", "票 漂 飘 朴 瓢 嫖 瞟 骠 嘌 剽 螵 缥 莩 殍"},
	{"pie", "撇 瞥 氕 丿 苤"},
	{"pin", "品 贫 拼 频 聘 苹 拚 姘 嫔 榀 颦 牝"},
	{"ping", "平 评 瓶 凭 萍 乒 屏 冯 苹 坪 枰 娉 俜 鲆"},
	{"po", "破 迫 颇 繁 婆 坡 泊 朴 泼 魄 粕 珀 叵 攴 钷 笸 钋 陂 泺 鄱 皤"},
	{"pou", "剖 裒 掊"},
	{"qia", "卡 恰 洽 掐 伽 袷 葜 髂"},
	{"qiang", "将 强 枪 墙 抢 腔 呛 锵 跄 羌 蔷 戕 襁 樯 炝 蜣 嫱 锖 戗 羟 镪"},
	{"qie", "切 且 窃 怯 茄 趄 妾 砌 惬 伽 锲 挈 郄 箧 慊"},
	{"qin", "亲 钦 琴 侵 秦 勤 芹 擒 寝 覃 矜 沁 禽 噙 揿 檎 锓 芩 嗪 螓 衾 廑 溱 吣"},
	{"qing", "情 请 青 亲 清 轻 晴 庆 倾 卿 擎 顷 氢 罄 蜻 磬 謦 苘 圊 檠 黥 鲭 氰 箐 綮"},
	{"qiong", "穷 琼 穹 茕 邛 蛩 筇 跫 銎"},
	{"qiu", "求 球 秋 仇 邱 囚 丘 酋 龟 蚯 裘 俅 虬 鳅 逑 遒 赇 泅 楸 犰 湫 蝤 巯 鼽 糗"},
	{"quan", "全 权 圈 劝 泉 券 拳 犬 诠 颧 蜷 绻 荃 铨 痊 鬈 辁 悛 畎 醛 筌"},
	{"que", "却 确 缺 雀 瘸 榷 鹊 阕 阙 炔 悫"},
	{"qun", "群 裙 逡 麇"},
	{"ran", "然 染 燃 冉 髯 苒 蚺"},
	{"rang", "让 嚷 攘 壤 瓤 穰 禳"},
	{"rao", "扰 绕 饶 娆 桡 荛"},
	{"re", "热 若 惹 喏"},
	{"ren", "人 任 认 忍 仁 韧 刃 纫 饪 壬 仞 稔 葚 荏 妊 轫 衽"},
	{"reng", "仍 扔"},
	{"ri", "日"},
	{"rong", "容 荣 融 蓉 溶 绒 熔 榕 戎 嵘 茸 冗 肜 蝾 狨"},
	{"rou", "肉 柔 揉 蹂 鞣 糅"},
	{"ru", "如 入 辱 儒 乳 汝 褥 嚅 茹 濡 蠕 孺 缛 襦 颥 薷 蓐 洳 溽 铷"},
	{"ruan", "软 阮 朊"},
	{"rui", "瑞 锐 芮 睿 蕤 枘 蕊 蚋"},
	{"run", "润 闰"},
	{"ruo", "若 弱 偌 箬"},
	{"sa", "洒 撒 萨 卅 仨 飒 挲 脎"},
	{"sai", "思 赛 塞 腮 噻 鳃"},
	{"san", "三 散 伞 叁 毵 馓 糁 霰"},
	{"sang", "丧 桑 嗓 搡 磉 颡"},
	{"sao", "扫 骚 嫂 梢 臊 搔 缲 缫 鳋 埽 瘙"},
	{"se", "色 塞 涩 瑟 啬 铯 穑"},
	{"sen", "森"},
	{"seng", "僧"},
	{"sha", "杀 沙 啥 傻 厦 刹 纱 杉 莎 煞 砂 霎 嗄 挲 歃 鲨 唼 痧 裟 铩"},
	{"shai", "色 晒 筛 酾"},
	{"shang", "上 商 伤 尚 赏 汤 殇 裳 晌 觞 熵 墒 绱 垧"},
	{"shao", "少 绍 烧 召 稍 勺 哨 邵 梢 捎 韶 苕 鞘 潲 劭 杓 芍 蛸 筲 艄"},
	{"she", "社 设 折 舍 涉 射 摄 舌 蛇 奢 赦 慑 佘 赊 麝 畲 厍 滠 歙 猞"},
	{"shei", "谁"},
	{"sheng", "生 声 省 胜 升 圣 盛 乘 剩 牲 绳 甥 笙 渑 眚 嵊 晟"},
	{"shou", "手 受 收 首 授 守 熟 售 瘦 寿 兽 狩 绶 艏"},
	{"shua", "刷 耍 唰"},
	{"shuai", "率 衰 摔 甩 帅 蟀"},
	{"shuan", "涮 栓 拴 闩"},
	{"shuang", "双 爽 霜 孀 泷"},
	{"shui", "说 水 谁 税 睡"},
	{"shun", "顺 舜 瞬 吮"},
	{"shuo", "说 数 朔 硕 烁 铄 妁 蒴 槊 搠"},
	{"song", "送 松 宋 诵 耸 颂 讼 悚 怂 忪 淞 菘 崧 嵩 凇 竦"},
	{"sou", "搜 艘 嗽 擞 馊 薮 嗾 叟 嗖 溲 飕 锼 瞍 螋"},
	{"su", "苏 诉 速 素 俗 肃 宿 缩 塑 稣 溯 酥 粟 簌 夙 嗉 谡 僳 愫 涑 蔌 觫"},
	{"suan", "算 酸 蒜 狻"},
	{"sui", "岁 随 虽 碎 尿 遂 祟 隧 髓 邃 穗 隋 绥 睢 荽 燧 谇 眭 濉"},
	{"sun", "孙 损 笋 荪 狲 飧 榫 隼"},
	{"suo", "所 索 缩 锁 莎 琐 梭 嗦 唆 挲 娑 睃 唢 嗍 蓑 羧 桫"},
	{"ta", "他 她 它 踏 塔 塌 拓 榻 嗒 蹋 沓 遢 挞 鳎 闼 铊 趿 漯 溻 獭"},
	{"tai", "太 台 态 泰 抬 胎 汰 苔 呔 鲐 邰 薹 酞 骀 炱 跆 肽 钛"},
	{"tao", "讨 套 逃 涛 掏 陶 桃 淘 滔 叨 萄 焘 啕 韬 饕 洮 绦 鼗"},
	{"te", "特 忑 忒 慝 铽"},
	{"tei", "忒"},
	{"teng", "腾 疼 藤 誊 滕"},
	{"ti", "体 提 题 替 踢 梯 啼 涕 蹄 剔 剃 惕 屉 嚏 悌 醍 缇 鹈 锑 荑 倜 绨 逖 裼"},
	{"tian", "天 田 填 甜 添 腆 舔 恬 佃 钿 阗 畋 忝 殄 掭"},
	{"tiao", "条 调 跳 挑 迢 眺 鲦 佻 苕 窕 髫 粜 笤 龆 祧 蜩"},
	{"tie", "铁 贴 帖 餮 萜"},
	{"ting", "听 停 庭 厅 挺 亭 婷 廷 艇 町 霆 汀 铤 蜓 莛 梃 葶 烃"},
	{"tong", "同 通 统 痛 童 彤 筒 铜 桶 捅 桐 瞳 佟 恸 酮 恫 侗 砼 嗵 仝 垌 茼 峒 潼"},
	{"tou", "头 投 偷 透 钭 骰"},
	{"tu", "土 突 图 途 徒 屠 涂 吐 兔 秃 凸 荼 酴 钍 菟 堍"},
	{"tuan", "团 湍 抟 疃 彖"},
	{"tui", "推 退 腿 褪 颓 蜕 忒 煺"},
	{"tun", "吞 屯 饨 褪 臀 囤 豚 暾 氽"},
	{"wa", "瓦 挖 袜 娃 哇 凹 娲 蛙 洼 佤 腽"},
	{"wai", "外 歪 崴"},
	{"wang", "望 王 往 网 忘 亡 汪 芒 旺 枉 妄 惘 罔 尢 辋 魍"},
	{"wen", "文 问 闻 温 稳 吻 纹 蚊 雯 紊 瘟 汶 刎 阌 璺"},
	{"weng", "翁 瓮 嗡 蓊 蕹"},
	{"wo", "我 握 窝 卧 渥 沃 涡 斡 蜗 幄 喔 倭 挝 莴 肟 硪 龌"},
	{"xia", "下 夏 吓 峡 厦 侠 狭 霞 瞎 暇 虾 唬 辖 遐 匣 黠 瑕 呷 狎 柙 硖 瘕 罅"},
	{"xin", "心 新 信 欣 寻 辛 薪 馨 鑫 芯 衅 昕 忻 锌 歆 镡 囟"},
	{"xing", "行 性 形 兴 星 省 型 姓 幸 刑 醒 腥 杏 悻 惺 邢 猩 荇 擤 荥 饧 硎 陉"},
	{"xiong", "雄 兄 胸 凶 熊 匈 汹 芎"},
	{"xiu", "修 休 秀 袖 宿 臭 羞 绣 朽 锈 嗅 咻 貅 髹 馐 庥 鸺 岫 溴"},
	{"xue", "学 血 雪 削 穴 谑 靴 薛 踅 噱 泶 鳕"},
	{"yang", "样 洋 阳 央 杨 养 扬 仰 羊 痒 漾 泱 氧 鸯 秧 殃 恙 疡 烊 佯 鞅 怏 徉 炀 蛘"},
	{"yo", "育 哟 唷"},
	{"yong", "用 永 拥 勇 涌 踊 泳 庸 佣 咏 俑 雍 恿 甬 臃 邕 镛 痈 壅 鳙 饔 喁 墉 蛹 慵"},
	{"yue", "月 乐 越 约 阅 跃 曰 悦 说 岳 粤 钥 刖 瀹 栎 樾 龠 钺"},
	{"za", "杂 咱 扎 砸 咋 咂 匝 拶"},
	{"zai", "在 再 载 灾 仔 宰 哉 栽 崽 甾"},
	{"zan", "咱 赞 暂 攒 簪 糌 瓒 拶 昝 趱 錾"},
	{"zang", "藏 脏 葬 赃 臧 锗 奘 驵"},
	{"zao", "早 造 遭 糟 澡 灶 躁 噪 凿 枣 皂 燥 蚤 藻 缲 唣"},
	{"ze", "则 责 泽 择 侧 咋 啧 仄 迮 笮 箦 舴 帻 赜 昃"},
	{"zei", "贼"},
	{"zen", "怎 谮"},
	{"zeng", "曾 增 赠 综 憎 缯 罾 甑 锃"},
	{"zhai", "摘 择 债 侧 祭 宅 窄 斋 寨 翟 砦 瘵"},
	{"zhan", "战 展 站 占 颤 沾 斩 辗 粘 盏 崭 瞻 绽 蘸 湛 詹 毡 栈 谵 搌 旃"},
	{"zhang", "长 张 章 丈 掌 涨 帐 障 账 胀 仗 杖 彰 璋 蟑 樟 瘴 漳 嶂 鄣 獐 仉 幛 嫜"},
	{"zhao", "着 找 照 招 朝 赵 召 罩 嘲 兆 昭 爪 肇 沼 诏 钊 啁 棹 笊"},
	{"zhe", "这 着 者 折 哲 浙 遮 辙 辄 谪 蔗 蛰 褶 鹧 锗 磔 摺 蜇 赭 柘"},
	{"zhei", "这"},
	{"zheng", "政 正 证 整 争 征 丁 挣 郑 症 睁 徵 蒸 怔 筝 拯 铮 峥 狰 诤 鲭 钲 帧"},
	{"zhong", "中 种 重 众 终 钟 忠 衷 肿 仲 锺 踵 盅 冢 忪 舯 螽"},
	{"zhou", "周 州 洲 粥 舟 皱 骤 轴 宙 咒 昼 肘 帚 胄 纣 诌 绉 妯 碡 啁 荮 籀 繇 酎"},
	{"zhua", "抓 爪 挝"},
	{"zhuai", "转 曳 拽 嘬"},
	{"zhuan", "传 专 转 赚 撰 砖 沌 篆 啭 馔 颛"},
	{"zhuang", "装 状 壮 庄 撞 妆 幢 桩 奘 僮 戆"},
	{"zhui", "追 坠 缀 锥 赘 隹 椎 惴 骓 缒"},
	{"zhun", "准 屯 谆 窀 肫"},
	{"zhuo", "着 著 桌 捉 卓 琢 缴 灼 酌 拙 浊 濯 茁 啄 斫 镯 涿 焯 浞 倬 禚 诼 擢"},
	{"zong", "总 宗 纵 踪 综 棕 粽 鬃 偬 腙 枞"},
	{"zou", "走 奏 邹 揍 驺 鲰 诹 陬 鄹"},
	{"zu", "组 足 族 祖 租 阻 卒 诅 俎 镞 菹"},
	{"zuan", "赚 钻 攥 纂 躜 缵"},
	{"zui", "最 罪 嘴 堆 醉 咀 觜 蕞"},
	{"zun", "尊 遵 樽 鳟 撙"},
	{"zuo", "作 做 坐 座 左 昨 琢 佐 凿 撮 柞 嘬 怍 胙 唑 笮 阼 祚 酢"},

	{"ba", "把 八 吧 巴 爸 罢 拔 叭 芭 霸 靶 扒 疤 跋 坝 笆 耙 粑 灞 茇 菝 魃 岜 捌 钯 鲅"},
	{"bao", "报 保 包 暴 宝 抱 薄 胞 爆 炮 鲍 饱 堡 剥 曝 刨 瀑 褒 豹 雹 苞 葆 褓 孢 煲 鸨 龅 趵"},
	{"bei", "被 北 备 背 悲 辈 杯 倍 贝 碑 卑 臂 蓓 惫 悖 狈 呗 焙 鹎 孛 邶 陂 埤 碚 褙 鐾 鞴 萆 钡"},
	{"bi", "比 必 笔 毕 币 秘 避 闭 鼻 彼 逼 壁 臂 弊 辟 碧 鄙 拂 毙 蔽 庇 匕 璧 敝 泌 陛 弼 篦 婢 愎 痹 妣 濞 铋 裨 俾 髀 萆 薜 哔 狴 庳 秕 滗 舭 毖 吡 嬖 蓖 贲 畀 荸 埤 筚 箅 芘 襞 跸 荜"},
	{"bian", "编 便 边 变 遍 辩 辨 贬 鞭 辫 扁 卞 砭 苄 匾 汴 蝙 笾 碥 窆 褊 弁 鳊 忭 煸 缏"},
	{"bo", "百 般 波 播 博 伯 勃 薄 拨 泊 柏 剥 玻 驳 魄 卜 脖 搏 膊 饽 簸 掰 舶 跛 礴 菠 帛 铂 钵 渤 檗 钹 擘 箔 趵 孛 鹁 踣 亳 啵"},
	{"chan", "产 单 颤 缠 禅 蝉 馋 铲 搀 阐 掺 潺 忏 蟾 婵 谄 谗 廛 孱 澶 冁 躔 蒇 骣 觇 镡 羼"},
	{"chang", "长 场 常 唱 厂 尝 昌 肠 偿 畅 倡 倘 敞 怅 裳 娼 猖 嫦 伥 氅 徜 昶 鲳 阊 菖 苌 鬯 惝"},
	{"cheng", "成 城 程 称 承 诚 盛 乘 呈 撑 惩 澄 秤 瞠 橙 噌 逞 铛 丞 骋 埕 枨 塍 铖 裎 酲 柽 蛏"},
	{"chi", "吃 持 迟 尺 赤 斥 池 痴 齿 驰 耻 翅 匙 侈 哧 嗤 啻 弛 蚩 炽 笞 敕 叱 饬 踟 鸱 褫 豉 坻 墀 茌 篪 傺 媸 螭 彳 眵 魑 瘛"},
	{"chu", "出 处 除 初 楚 触 储 础 厨 畜 躇 橱 雏 矗 怵 锄 杵 搐 绌 黜 褚 蜍 蹰 刍 滁 楮 憷 亍 樗"},
	{"dan", "但 单 担 石 弹 淡 旦 蛋 胆 诞 丹 耽 惮 眈 啖 澹 掸 殚 箪 瘅 赕 疸 聃 氮 萏 郸 儋"},
	{"di", "的 地 第 提 底 低 帝 弟 敌 抵 递 滴 迪 蒂 堤 笛 缔 涤 嘀 诋 谛 狄 邸 睇 嫡 翟 砥 娣 棣 荻 羝 坻 柢 觌 骶 氐 绨 镝 碲 籴"},
	{"dian", "点 电 店 典 颠 甸 淀 垫 殿 滇 奠 惦 掂 碘 癫 巅 踮 佃 玷 簟 阽 坫 靛 钿 癜 丶"},
	{"e", "阿 额 俄 恶 饿 哦 鹅 扼 愕 遏 噩 娥 峨 呃 厄 鄂 讹 婀 蛾 轭 颚 鳄 锷 谔 屙 锇 阏 垩 腭 苊 鹗 萼 莪"},
	{"fei", "非 费 飞 废 肥 啡 沸 菲 肺 匪 诽 腓 扉 吠 霏 绯 妃 斐 翡 蜚 痱 淝 悱 鲱 篚 芾 狒 镄 榧"},
	{"fu", "夫 府 服 复 父 负 副 福 富 付 妇 附 佛 幅 伏 符 赴 腐 浮 扶 腹 抚 覆 肤 赋 弗 傅 辅 拂 甫 俯 斧 缚 咐 脯 袱 俘 敷 阜 芙 釜 孚 腑 匐 孵 辐 涪 讣 氟 桴 蜉 芾 苻 茯 莩 菔 幞 怫 拊 滏 黼 艴 麸 绂 绋 趺 祓 砩 黻 罘 蚨 跗 蝠 呋 凫 郛 稃 驸 赙 馥 蝮 鲋 鳆"},
	{"ge", "个 革 各 合 歌 格 哥 戈 盖 隔 葛 割 阁 胳 搁 疙 咯 鸽 蛤 嗝 骼 颌 屹 搿 膈 镉 纥 袼 仡 鬲 塥 圪 哿 舸 铬 硌 虼"},
	{"gu", "故 古 顾 股 鼓 姑 骨 固 孤 谷 估 雇 辜 贾 咕 呱 沽 箍 菇 汩 轱 锢 蛊 梏 鸪 毂 鹄 臌 瞽 罟 钴 觚 鹘 菰 蛄 嘏 诂 崮 酤 牿 牯 痼 鲴"},
	{"gui", "规 归 贵 鬼 桂 跪 柜 轨 瑰 诡 刽 龟 硅 闺 皈 傀 癸 圭 晷 簋 妫 鲑 匦 庋 宄 炔 刿 桧 炅 鳜"},
	{"han", "汉 喊 含 寒 汗 韩 憾 涵 函 翰 撼 罕 旱 捍 酣 悍 憨 晗 瀚 鼾 顸 阚 焊 蚶 焓 颔 菡 撖 邗 邯"},
	{"he", "和 何 合 河 喝 赫 核 吓 贺 盒 呵 禾 荷 鹤 壑 阂 褐 诃 涸 阖 嗬 貉 曷 颌 劾 盍 纥 蚵 翮 菏"},
	{"hu", "和 乎 护 呼 胡 户 戏 湖 忽 互 糊 虎 核 壶 狐 沪 惚 浒 唬 葫 弧 蝴 囫 瑚 斛 祜 猢 鹄 醐 戽 扈 唿 笏 琥 滹 鹕 轷 烀 冱 岵 怙 鹘 槲 觳 瓠 鹱 煳"},
	{"huan", "还 欢 换 环 缓 患 幻 唤 宦 焕 痪 寰 鬟 涣 浣 奂 桓 缳 豢 锾 郇 萑 圜 洹 擐 獾 漶 逭 鲩"},
	{"hui", "会 回 汇 挥 辉 灰 惠 毁 悔 恢 慧 溃 绘 徽 讳 贿 堕 徊 晦 秽 诲 诙 晖 彗 麾 烩 荟 卉 茴 喙 蛔 恚 洄 珲 蕙 哕 咴 浍 虺 缋 桧 隳 蟪"},
	{"ji", "其 几 期 给 己 机 记 革 及 系 计 即 基 济 辑 级 极 寄 际 技 集 纪 击 奇 急 激 继 既 积 籍 鸡 齐 吉 挤 迹 季 寂 绩 疾 饥 祭 缉 忌 剂 圾 姬 矶 肌 嫉 讥 藉 叽 脊 冀 稽 妓 棘 骥 畸 蓟 汲 悸 岌 伎 笈 跻 瘠 亟 诘 暨 霁 羁 稷 偈 戟 嵇 楫 唧 鲫 髻 荠 箕 觊 蒺 畿 虮 齑 殛 墼 佶 掎 芨 丌 麂 蕺 咭 嵴 芰 笄 哜 洎 乩 戢 屐 剞 跽 玑 鲚 赍 犄"},
	{"jia", "家 加 价 假 角 脚 架 甲 佳 驾 夹 嫁 搅 嘉 贾 缴 绞 饺 稼 矫 茄 佼 挟 狡 颊 剿 皎 侥 枷 珈 戛 迦 伽 浃 痂 胛 笳 荚 葭 钾 镓 嘏 郏 挢 岬 徼 湫 敫 铰 袈 瘕 恝 铗 袷 蛱 跏"},
	{"jian", "见 间 件 建 简 坚 监 减 渐 检 健 兼 剑 艰 肩 键 荐 浅 尖 鉴 剪 践 奸 捡 箭 舰 拣 贱 溅 煎 俭 槛 碱 歼 缄 茧 笺 柬 谏 蹇 僭 涧 菅 謇 硷 睑 锏 饯 毽 鲣 鞯 蒹 搛 谫 囝 湔 缣 枧 戬 戋 犍 裥 笕 翦 趼 楗 牮 鹣 腱 踺"},
	{"jiao", "教 交 觉 校 叫 较 角 脚 焦 骄 郊 轿 搅 嚼 胶 缴 绞 饺 椒 矫 娇 佼 狡 浇 跤 姣 窖 剿 侥 皎 蕉 酵 礁 鲛 徼 湫 敫 僬 鹪 峤 蛟 铰 艽 茭 挢 噍 醮"},
	{"jie", "界 解 接 结 价 节 街 姐 阶 介 借 戒 杰 届 皆 捷 截 洁 揭 劫 竭 藉 睫 桔 家 诫 楷 嗟 拮 孑 碣 秸 诘 桀 芥 偈 颉 讦 疖 疥 婕 羯 鲒 蚧 骱 喈"},
	{"jin", "进 今 金 近 尽 仅 紧 禁 劲 津 斤 谨 锦 筋 晋 巾 浸 襟 瑾 矜 靳 缙 烬 噤 觐 馑 堇 衿 荩 廑 妗 卺 赆 槿"},
	{"jing", "经 京 精 境 警 竟 静 惊 景 敬 睛 镜 劲 竞 净 井 径 晶 荆 兢 颈 憬 靖 鲸 泾 阱 儆 旌 痉 迳 茎 胫 腈 菁 粳 獍 肼 弪 婧 刭 靓"},
	{"jiu", "就 九 究 酒 久 旧 救 纠 揪 疚 舅 韭 赳 鸠 灸 咎 啾 臼 鹫 阄 僦 厩 玖 柩 桕 鬏"},
	{"ju", "车 局 据 且 居 句 举 具 剧 巨 聚 拒 俱 距 惧 菊 拘 柜 矩 桔 驹 鞠 咀 沮 瞿 锯 炬 飓 趄 掬 踽 踞 遽 橘 倨 疽 龃 屦 犋 裾 钜 苴 雎 鞫 椐 讵 苣 锔 狙 榘 莒 枸 榉 窭 醵 琚"},
	{"jue", "觉 绝 决 角 脚 嚼 掘 诀 崛 爵 抉 倔 獗 嗟 厥 蹶 攫 谲 矍 撅 噱 孓 橛 噘 珏 桷 劂 爝 镢 蕨 觖"},
	{"ke", "可 克 科 客 刻 课 颗 渴 柯 呵 棵 恪 咳 苛 磕 壳 坷 嗑 瞌 轲 稞 疴 蝌 溘 髁 钶 窠 颏 珂 岢 骒 缂 氪 锞 蚵"},
	{"kui", "亏 愧 溃 窥 魁 馈 睽 盔 逵 葵 奎 匮 傀 喟 聩 岿 馗 夔 篑 喹 悝 暌 隗 蒉 蝰 愦 揆 跬"},
	{"li", "里 理 力 利 立 李 历 离 例 礼 丽 励 黎 厉 璃 莉 哩 笠 粒 俐 漓 栗 狸 梨 隶 吏 沥 篱 厘 犁 雳 罹 莅 戾 鲤 俚 砺 藜 俪 蜊 黧 郦 痢 枥 逦 娌 詈 骊 荔 鳢 喱 鹂 嫠 蠡 鬲 鲡 悝 坜 苈 砾 藓 呖 唳 猁 溧 澧 栎 轹 蓠 傈 缡 疠 疬 蛎 锂 篥 粝 跞 醴"},
	{"lian", "联 连 脸 练 恋 怜 莲 廉 炼 帘 链 敛 涟 镰 殓 琏 楝 裢 裣 蠊 鲢 濂 臁 潋 蔹 奁"},
	{"ling", "领 令 另 灵 零 龄 凌 玲 铃 陵 岭 拎 伶 聆 囹 棱 菱 翎 苓 瓴 棂 绫 呤 柃 鲮 酃 泠 羚 蛉"},
	{"lu", "六 路 陆 录 卢 露 绿 鲁 炉 鹿 碌 庐 芦 噜 颅 禄 辘 卤 虏 麓 泸 赂 漉 戮 簏 轳 鹭 掳 潞 鲈 撸 栌 垆 胪 蓼 渌 鸬 逯 璐 辂 橹 镥 舻 氇"},
	{"luo", "落 罗 络 洛 逻 裸 骆 萝 螺 咯 锣 箩 摞 烙 捋 珞 骡 猡 镙 椤 倮 蠃 荦 瘰 泺 漯 脶 硌 雒"},
	{"mao", "毛 冒 猫 贸 矛 帽 貌 茅 茂 髦 卯 耄 瑁 锚 懋 袤 铆 峁 牦 蟊 泖 昴 茆 旄 蝥 瞀"},
	{"mei", "没 美 每 妹 眉 梅 媒 枚 魅 煤 昧 霉 谜 玫 媚 寐 糜 袂 酶 莓 嵋 楣 湄 猸 镅 浼 鹛 镁"},
	{"mi", "密 米 秘 迷 弥 谜 觅 眯 蜜 靡 咪 谧 泌 糜 汨 宓 麋 醚 弭 敉 芈 祢 脒 幂 縻 嘧 蘼 猕 糸"},
	{"mo", "没 无 万 默 莫 模 麽 末 冒 磨 摸 摩 寞 漠 墨 抹 魔 陌 脉 嘿 沫 膜 蓦 蘑 茉 馍 摹 貉 谟 嫫 秣 镆 殁 瘼 耱 貊 貘"},
	{"pi", "批 否 皮 坏 屁 披 疲 辟 啤 脾 匹 僻 劈 譬 坯 痞 癖 琵 毗 霹 噼 媲 郫 裨 纰 丕 鼙 圮 蚍 蜱 貔 陂 陴 砒 仳 埤 擗 吡 庀 邳 疋 芘 枇 罴 淠 铍 甓 睥"},
	{"pu", "普 暴 铺 扑 堡 朴 谱 浦 葡 蒲 仆 曝 脯 瀑 菩 溥 匍 璞 噗 圃 埔 氆 镨 蹼 镤 濮 莆"},
	{"qi", "起 其 期 气 七 奇 妻 企 器 汽 棋 齐 旗 弃 启 骑 欺 歧 岂 缉 戚 凄 泣 契 琪 乞 祈 漆 迄 脐 稽 栖 沏 祺 崎 祁 琦 蹊 砌 憩 淇 汔 亟 绮 讫 嘁 岐 萋 俟 杞 芪 荠 耆 槭 颀 芑 屺 欹 桤 綮 萁 蛴 蜞 綦 鳍 麒 蕲 柒 亓 骐 葺 畦 圻 碛"},
	{"qian", "前 钱 千 签 欠 牵 浅 潜 迁 谦 遣 歉 纤 嵌 乾 谴 铅 虔 钳 骞 倩 堑 黔 掮 茜 悭 芊 缱 愆 荨 芡 阡 佥 搴 褰 肷 钎 仟 犍 钤 岍 箝 鬈 扦 慊 椠"},
	{"qiao", "桥 悄 乔 巧 侨 瞧 敲 翘 俏 窍 雀 壳 峭 蕉 锹 撬 跷 憔 樵 鞘 橇 诮 愀 谯 荞 峤 缲 硗 鞒 劁"},
	{"qu", "去 取 区 曲 趣 屈 趋 驱 渠 躯 娶 觑 瞿 岖 戌 蛐 衢 蛆 癯 麴 阒 祛 磲 鸲 诎 蠼 劬 蕖 蘧 龋 苣 黢 璩 氍 朐"},
	{"shan", "山 单 善 闪 衫 删 煽 扇 陕 珊 禅 杉 擅 掺 膳 栅 讪 跚 汕 姗 赡 潸 缮 嬗 掸 膻 骟 芟 埏 剡 钐 鄯 舢 苫 髟 疝 蟮 鳝"},
	{"shen", "什 身 深 神 参 甚 申 审 沈 伸 慎 渗 绅 肾 呻 婶 莘 蜃 葚 娠 渖 矧 诜 砷 糁 谂 椹 胂 哂"},
	{"shi", "是 时 十 事 实 什 使 世 市 识 始 士 师 诗 式 失 史 视 似 示 食 室 势 试 石 释 施 适 氏 驶 饰 尸 拾 逝 湿 誓 狮 殖 嗜 蚀 嘘 屎 侍 匙 峙 仕 恃 柿 轼 矢 噬 拭 虱 弑 蓍 埘 莳 炻 谥 鲥 豕 贳 铈 螫 舐 筮 鲺 酾"},
	{"shu", "书 数 术 属 输 树 述 熟 束 署 殊 舒 叔 鼠 疏 淑 抒 薯 梳 暑 竖 蜀 恕 墅 孰 漱 枢 俞 赎 黍 蔬 曙 倏 庶 戍 塾 澍 姝 纾 秫 毹 殳 疋 菽 丨 沭 摅 腧"},
	{"si", "四 死 思 斯 司 似 食 私 丝 厕 寺 撕 肆 厮 嘶 伺 饲 嗣 祀 巳 驷 鸶 俟 汜 泗 厶 兕 蛳 咝 姒 澌 缌 耜 笥 锶"},
	{"tan", "谈 探 弹 坦 叹 坛 摊 贪 滩 毯 谭 潭 瘫 炭 覃 痰 忐 坍 袒 碳 澹 檀 昙 镡 郯 锬 钽"},
	{"tang", "堂 唐 汤 躺 糖 趟 倘 烫 淌 膛 塘 棠 搪 溏 螳 瑭 樘 螗 铴 醣 镗 耥 饧 傥 帑 羰"},
	{"tuo", "托 脱 拖 妥 魄 拓 陀 舵 驼 唾 椭 砣 驮 沱 跎 坨 鸵 乇 鼍 橐 佗 庹 铊 酡 柁 柝 箨"},
	{"wan", "万 完 晚 湾 玩 碗 弯 挽 顽 腕 婉 惋 蔓 宛 丸 蜿 莞 娩 畹 剜 豌 皖 纨 琬 脘 烷 芄 菀 绾"},
	{"wei", "为 位 未 委 维 味 围 卫 威 微 伟 谓 唯 遗 危 慰 尾 违 魏 玮 蔚 伪 畏 胃 喂 炜 韦 惟 巍 纬 萎 娓 苇 尉 帷 渭 猥 偎 薇 痿 猬 逶 帏 韪 煨 鲔 桅 潍 隈 圩 囗 诿 隗 崴 洧 葳 嵬 闱 沩 涠 艉 軎"},
	{"wu", "无 五 物 务 武 午 舞 亡 於 误 恶 吴 屋 伍 悟 吾 污 乌 雾 侮 捂 巫 毋 呜 诬 勿 梧 坞 戊 兀 唔 晤 芜 鹜 钨 妩 痦 鹉 忤 寤 骛 邬 牾 鼯 圬 浯 仵 阢 芴 庑 婺 怃 杌 焐 蜈 迕 鋈"},
	{"xi", "西 系 息 希 喜 席 习 细 戏 吸 洗 惜 稀 悉 析 夕 牺 袭 腊 昔 熙 兮 溪 隙 嘻 锡 晰 媳 樨 熄 膝 栖 郗 犀 禧 曦 奚 羲 蹊 唏 淅 嬉 皙 汐 徙 茜 玺 熹 烯 翕 蟋 屣 檄 浠 僖 穸 蜥 隰 觋 螅 铣 菥 葸 蓰 舾 矽 粞 硒 醯 欷 鼷 歙 饩 阋 禊 舄"},
	{"xian", "现 见 先 显 线 险 限 县 鲜 洗 献 闲 宪 陷 贤 仙 嫌 咸 羡 掀 弦 纤 娴 衔 馅 涎 舷 腺 跣 暹 岘 猃 蚬 筅 跹 莶 锨 鹇 痫 铣 氙 祆 籼 冼 藓 酰 苋 燹 霰"},
	{"xiang", "想 相 向 象 香 乡 像 响 项 享 降 箱 详 祥 巷 厢 湘 橡 翔 镶 飨 襄 饷 骧 葙 庠 鲞 芗 缃 蟓"},
	{"xiao", "小 笑 校 消 效 晓 销 潇 肖 萧 孝 宵 削 嚣 啸 逍 硝 霄 淆 哮 枭 骁 箫 筱 哓 枵 绡 魈 蛸 崤"},
	{"xie", "些 写 解 血 谢 叶 协 鞋 携 斜 泄 胁 契 歇 谐 邪 械 屑 卸 挟 懈 泻 亵 蟹 偕 邂 榭 撷 楔 瀣 蝎 颉 勰 薤 燮 躞 缬 獬 绁 廨 榍 渫"},
	{"xu", "许 续 需 须 徐 序 虚 绪 吁 蓄 叙 畜 嘘 恤 絮 浒 墟 旭 婿 栩 戌 诩 胥 酗 煦 砉 盱 糈 醑 顼 勖 洫 溆 圩 蓿"},
	{"xuan", "选 宣 旋 悬 券 喧 轩 玄 炫 渲 绚 眩 萱 漩 暄 璇 谖 铉 儇 痃 泫 煊 楦 癣 碹 揎 镟"},
	{"xun", "寻 询 训 迅 讯 巡 逊 循 旬 熏 勋 驯 荤 殉 醺 巽 徇 埙 荀 峋 洵 薰 汛 郇 曛 窨 恂 獯 浔 鲟 蕈 浚"},
	{"ya", "亚 压 雅 牙 呀 押 瞧 涯 讶 鸦 哑 鸭 匹 崖 丫 芽 衙 轧 痖 睚 娅 蚜 伢 疋 岈 琊 垭 揠 迓 桠 氩 砑"},
	{"yan", "眼 言 严 演 研 烟 验 延 沿 掩 颜 厌 炎 燕 阎 宴 盐 咽 岩 雁 殷 焰 艳 焉 淹 铅 衍 阉 奄 谚 俨 檐 蜒 彦 腌 焱 晏 唁 妍 砚 嫣 胭 湮 筵 堰 赝 餍 鼹 芫 偃 魇 闫 崦 厣 剡 恹 阏 兖 郾 琰 罨 鄢 谳 滟 阽 鼽 酽 菸"},
	{"yao", "要 约 摇 药 耀 遥 邀 腰 姚 咬 陶 尧 谣 瑶 窑 夭 肴 妖 吆 钥 侥 杳 窈 鹞 曜 舀 铫 幺 爻 徭 疟 繇 鳐 珧 轺 崾"},
	{"ye", "也 业 夜 爷 叶 野 页 液 耶 咽 邪 哗 曳 拽 揶 噎 烨 冶 椰 掖 腋 谒 邺 靥 晔 铘"},
	{"yi", "一 以 意 已 义 议 医 易 衣 艺 依 译 移 异 益 亦 亿 疑 遗 忆 宜 尾 椅 伊 仪 谊 抑 翼 矣 役 艾 乙 溢 毅 蛇 裔 逸 姨 夷 轶 怡 蚁 弈 倚 翌 颐 疫 绎 彝 咦 佚 奕 熠 贻 漪 诣 迤 弋 懿 呓 驿 咿 揖 旖 屹 痍 蛾 薏 噫 镒 刈 沂 臆 缢 邑 胰 猗 羿 钇 舣 劓 仡 酏 佾 埸 诒 圯 荑 壹 挹 嶷 饴 嗌 峄 怿 悒 铱 欹 殪 黟 苡 肄 镱 瘗 癔 翊 蜴 眙 翳"},
	{"yin", "因 音 引 印 烟 银 隐 饮 阴 姻 瘾 吟 寅 殷 淫 茵 荫 尹 蚓 垠 喑 湮 胤 鄞 氤 霪 圻 铟 狺 吲 夤 堙 龈 洇 茚 窨"},
	{"ying", "应 英 影 营 迎 硬 映 赢 盈 颖 鹰 婴 蝇 樱 莹 荧 膺 萤 萦 莺 罂 瀛 楹 缨 颍 嬴 鹦 瑛 茔 嘤 璎 荥 撄 郢 瘿 蓥 滢 潆 媵"},
	{"you", "有 又 由 友 游 右 油 优 邮 幽 尤 忧 犹 悠 幼 诱 佑 黝 攸 呦 酉 柚 鱿 莠 囿 鼬 铀 卣 猷 牖 铕 疣 蚰 蝣 釉 蝤 繇 莜 侑 莸 宥 蚴 尢"},
	{"yu", "于 与 语 育 余 遇 狱 雨 於 欲 预 予 鱼 玉 愈 谷 域 誉 吁 宇 蔚 寓 豫 愚 舆 粥 郁 喻 羽 娱 裕 愉 禹 浴 馀 御 逾 渔 渝 俞 萸 瑜 隅 驭 迂 尉 揄 圄 谕 榆 屿 淤 毓 虞 禺 谀 妪 腴 峪 竽 芋 妤 臾 欤 龉 觎 盂 昱 煜 熨 燠 窬 蝓 嵛 狳 伛 俣 舁 圉 庾 菀 蓣 饫 阈 鬻 瘐 窳 雩 瘀 纡 聿 钰 鹆 鹬 蜮"},
	{"yuan", "员 元 原 院 远 愿 园 源 圆 怨 缘 援 冤 袁 渊 苑 猿 鸳 辕 垣 媛 沅 橼 芫 爰 螈 鼋 眢 圜 鸢 箢 塬 垸 掾 瑗"},
	{"yun", "员 运 云 均 允 韵 晕 孕 匀 蕴 酝 筠 芸 耘 陨 纭 殒 愠 氲 狁 熨 郓 恽 昀 韫 郧"},
	{"zha", "查 炸 扎 咋 诈 乍 蜡 眨 渣 札 栅 喋 轧 闸 榨 喳 揸 柞 楂 哳 吒 铡 砟 齄 咤 痄 蚱"},
	{"zhen", "真 阵 镇 震 针 珍 圳 振 诊 枕 斟 贞 侦 赈 甄 臻 箴 疹 砧 桢 缜 畛 轸 胗 稹 祯 浈 溱 蓁 椹 榛 朕 鸩"},
	{"zhi", "之 只 知 至 制 识 直 治 指 支 志 职 致 值 织 纸 止 质 执 智 置 址 氏 枝 秩 植 旨 滞 徵 帜 稚 挚 汁 掷 殖 芝 吱 肢 脂 峙 侄 窒 蜘 趾 炙 痔 咫 芷 栉 枳 踯 桎 帙 栀 祉 轾 贽 痣 豸 卮 轵 埴 陟 郅 黹 忮 彘 骘 酯 摭 絷 跖 膣 雉 鸷 胝 蛭 踬 祗 觯"},
	{"zhu", "主 住 注 术 助 著 属 逐 诸 朱 驻 珠 祝 猪 筑 竹 煮 嘱 柱 烛 铸 株 瞩 蛛 伫 拄 贮 洙 诛 褚 铢 箸 蛀 茱 炷 躅 竺 杼 翥 渚 潴 麈 槠 橥 苎 侏 瘃 疰 邾 舳"},
	{"zi", "子 自 字 资 咨 紫 滋 仔 姿 吱 兹 孜 梓 渍 籽 姊 恣 滓 谘 龇 秭 呲 辎 锱 眦 笫 髭 淄 茈 觜 訾 缁 耔 鲻 嵫 赀 孳 粢 趑"},

	{"banlu", "伴侣"},
	{"bilu", "碧绿"},
	{"buan", "不安"},
	{"cwwyh", "常务委员会"},
	{"dange", "单个 耽搁"},
	{"dinglu", "定律"},
	{"douyou", "都有"},
	{"dulai", "都来"},
	{"falu", "法律"},
	{"feide", "非得"},
	{"fujiao", "佛教"},
	{"funu", "妇女"},
	{"gailu", "概率"},
	{"gelu", "格律"},
	{"guilu", "规律"},
	{"guinu", "闺女"},
	{"gulu", "顾虑"},
	{"hongdu", "洪都"},
	{"jindi", "劲敌"},
	{"jinlu", "劲旅"},
	{"kaolu", "考虑"},
	{"kee", "可恶"},
	{"konglu", "空虑"},
	{"lilu", "利率"},
	{"luban", "旅伴"},
	{"luci", "屡次"},
	{"ludian", "旅店"},
	{"lufei", "旅费"},
	{"luguan", "旅馆"},
	{"luhua", "绿化"},
	{"luke", "旅客"},
	{"luli", "履历"},
	{"luling", "率领"},
	{"luobu", "萝卜"},
	{"luse", "绿色"},
	{"lushe", "旅社"},
	{"lushi", "律师"},
	{"luxing", "旅行 履行"},
	{"luyou", "旅游"},
	{"luzhou", "绿洲"},
	{"nannu", "男女"},
	{"pinlu", "频率"},
	{"pmgh", "跑马观花"},
	{"qiangjin", "强劲"},
	{"qinglu", "轻率"},
	{"senglu", "僧侣"},
	{"shaonu", "少女"},
	{"sulu", "速率"},
	{"tanlu", "坦率"},
	{"wulu", "无虑"},
	{"xinglu", "行旅"},
	{"yilu", "一律 疑虑"},
	{"youlu", "忧虑"},
	{"yuanlu", "远虑"},
	{"yunlu", "韵律"},
	{"zinu", "子女"},

	/* Pinyin words */
	{"ahs", "安徽省"},
	{"aiban", "呆板"},
	{"aidai", "爱戴"},
	{"aidao", "哀悼"},
	{"aiguo", "爱国"},
	{"aihao", "爱好"},
	{"aihu", "爱护"},
	{"aijin", "挨近"},
	{"aimei", "暧昧"},
	{"aimu", "爱慕"},
	{"aiqing", "爱情"},
	{"aiqiu", "哀求"},
	{"airen", "爱人"},
	{"aixi", "爱惜"},
	{"aiyue", "哀乐"},
	{"aizheng", "癌症"},
	{"alb", "阿拉伯"},
	{"anan", "暗暗"},
	{"anbian", "岸边"},
	{"ancang", "暗藏"},
	{"andan", "黯淡"},
	{"anding", "安定"},
	{"anfang", "安放"},
	{"anggui", "昂贵"},
	{"angran", "昂然 盎然"},
	{"angshou", "昂首"},
	{"angyang", "昂扬"},
	{"angzang", "肮脏"},
	{"anhai", "暗害"},
	{"anhao", "暗号"},
	{"anhui", "安徽"},
	{"anjian", "案件"},
	{"anjing", "安静"},
	{"anma", "鞍马"},
	{"anmo", "按摩"},
	{"anna", "按捺"},
	{"anning", "安宁"},
	{"anpai", "安排"},
	{"anqi", "按期"},
	{"anqing", "案情"},
	{"anquan", "安全"},
	{"anran", "黯然 岸然"},
	{"ansha", "暗杀"},
	{"anshang", "暗伤"},
	{"anshi", "按时 暗示 暗室"},
	{"ansuan", "暗算"},
	{"anwei", "安慰"},
	{"anwen", "安稳"},
	{"anxiang", "暗想 安详"},
	{"anyu", "暗语 按语"},
	{"anzhao", "按照"},
	{"anzhi", "安置"},
	{"anzhong", "暗中"},
	{"anzhuang", "安装"},
	{"aohui", "懊悔"},
	{"aoman", "傲慢"},
	{"aomi", "奥秘"},
	{"aomiao", "奥妙"},
	{"aoxiang", "翱翔"},
	{"aoye", "熬夜"},
	{"ayh", "奥运会"},
	{"ayi", "阿姨"},
	{"baba", "爸爸"},
	{"babing", "把柄"},
	{"bacheng", "八成"},
	{"bachi", "把持"},
	{"badao", "霸道"},
	{"bafang", "八方"},
	{"bagao", "拔高"},
	{"bagong", "罢工"},
	{"bagu", "八股"},
	{"bagua", "八卦"},
	{"baguan", "罢官"},
	{"baiban", "百般"},
	{"baibei", "百倍 败北"},
	{"baibu", "摆布"},
	{"baichi", "白痴"},
	{"baidong", "摆动"},
	{"baidu", "摆渡"},
	{"baifang", "拜访"},
	{"baifen", "百分"},
	{"baigong", "白宫"},
	{"baihua", "白话"},
	{"baihuai", "败坏"},
	{"baihuo", "百货"},
	{"baijian", "拜见"},
	{"baijiang", "败将"},
	{"baijin", "白金"},
	{"baiju", "败局"},
	{"bailei", "败类"},
	{"bailu", "败露"},
	{"bainian", "拜年"},
	{"bainong", "摆弄"},
	{"baise", "白色"},
	{"baishe", "摆设"},
	{"baitian", "白天"},
	{"baituo", "摆脱 拜托"},
	{"baiwan", "百万"},
	{"baixing", "百姓"},
	{"baizhang", "败仗"},
	{"bajian", "拔尖"},
	{"bajie", "巴结 八届"},
	{"bale", "罢了"},
	{"bali", "巴黎"},
	{"balu", "八路"},
	{"bamian", "罢免"},
	{"banan", "办案"},
	{"banbai", "斑白"},
	{"banbo", "斑驳"},
	{"banben", "版本"},
	{"banbian", "半边"},
	{"banbu", "颁布"},
	{"banchang", "办厂"},
	{"banche", "班车"},
	{"banci", "班次"},
	{"bandao", "半岛"},
	{"bandian", "半点"},
	{"banfa", "办法 颁发"},
	{"banfang", "班房"},
	{"banghui", "帮会"},
	{"bangjia", "绑架"},
	{"bangjiao", "邦交"},
	{"banglian", "邦联"},
	{"bangmang", "帮忙"},
	{"bangong", "办公"},
	{"bangpai", "帮派"},
	{"bangqiang", "帮腔"},
	{"bangshou", "帮手"},
	{"bangwan", "傍晚"},
	{"bangxiong", "帮凶"},
	{"bangyang", "榜样"},
	{"bangzhu", "帮助"},
	{"banhua", "版画"},
	{"banji", "班级 班机"},
	{"banjie", "半截"},
	{"banjing", "半径"},
	{"banli", "办理"},
	{"banlv", "伴侣"},
	{"banmian", "版面"},
	{"bannian", "半年"},
	{"bannong", "搬弄"},
	{"banpei", "般配"},
	{"banquan", "版权"},
	{"banshi", "办事"},
	{"banshu", "板书"},
	{"banyue", "半月"},
	{"banyun", "搬运"},
	{"banzhang", "班长"},
	{"banzi", "班子"},
	{"banzou", "伴奏"},
	{"banzu", "班组"},
	{"baoan", "保安"},
	{"baoban", "包办"},
	{"baobao", "宝宝"},
	{"baobei", "宝贝"},
	{"baobi", "包庇"},
	{"baobian", "褒贬"},
	{"baobiao", "保镖 报表"},
	{"baocang", "包藏"},
	{"baochan", "包产"},
	{"baochi", "保持"},
	{"baochou", "报仇 报酬"},
	{"baocun", "保存"},
	{"baoda", "报答"},
	{"baodao", "报道 报导 报到"},
	{"baofa", "爆发 暴发"},
	{"baofei", "报废"},
	{"baofeng", "暴风"},
	{"baofu", "报复 抱负 包袱"},
	{"baogao", "报告"},
	{"baogong", "包工"},
	{"baoguan", "保管"},
	{"baoguang", "曝光"},
	{"baogui", "宝贵"},
	{"baohan", "包含 饱含 包涵"},
	{"baohe", "饱和"},
	{"baohu", "保护"},
	{"baojia", "报价"},
	{"baojian", "保健"},
	{"baojing", "报警"},
	{"baojun", "暴君"},
	{"baokan", "报刊"},
	{"baoku", "宝库"},
	{"baokuo", "包括"},
	{"baolan", "包揽"},
	{"baolei", "堡垒"},
	{"baoli", "暴力 暴利"},
	{"baoliu", "保留"},
	{"baolu", "暴露 曝露"},
	{"baoluan", "暴乱"},
	{"baoman", "饱满"},
	{"baomi", "保密"},
	{"baoming", "报名"},
	{"baomu", "保姆 报幕"},
	{"baopo", "爆破"},
	{"baoqian", "抱歉"},
	{"baoshe", "报社"},
	{"baoshi", "宝石 报失"},
	{"baoshou", "保守"},
	{"baota", "宝塔"},
	{"baotong", "报童"},
	{"baotou", "报头"},
	{"baotu", "暴徒"},
	{"baowei", "保卫 包围"},
	{"baoxian", "保险"},
	{"baoxiao", "报销"},
	{"baoxing", "暴行"},
	{"baoyang", "保养"},
	{"baoying", "报应"},
	{"baoyou", "保佑"},
	{"baoyu", "暴雨"},
	{"baoyuan", "抱怨"},
	{"baoza", "包扎"},
	{"baozang", "宝藏"},
	{"baozha", "爆炸"},
	{"baozhang", "保障"},
	{"baozheng", "保证"},
	{"baozhi", "报纸"},
	{"baozhong", "保重"},
	{"baozhu", "爆竹"},
	{"baozhuang", "包装"},
	{"baozi", "孢子"},
	{"baquan", "霸权"},
	{"bashe", "跋涉"},
	{"bashou", "把守 扒手"},
	{"bawang", "霸王"},
	{"bawo", "把握"},
	{"baxi", "把戏 巴西"},
	{"baxiu", "罢休"},
	{"bayue", "八月"},
	{"bazhan", "霸占"},
	{"bbd", "巴不得"},
	{"bbs", "并不是"},
	{"bbt", "半边天"},
	{"bby", "北冰洋"},
	{"bcp", "半成品"},
	{"bdb", "不得不"},
	{"bdfh", "标点符号"},
	{"bdl", "不得了 背地里"},
	{"bdt", "半导体"},
	{"beiai", "悲哀"},
	{"beian", "备案"},
	{"beibao", "背包"},
	{"beibi", "卑鄙"},
	{"beibian", "北边"},
	{"beibu", "北部 被捕"},
	{"beican", "悲惨"},
	{"beidong", "被动"},
	{"beifang", "北方"},
	{"beifen", "备份 悲愤 辈分"},
	{"beigao", "被告"},
	{"beiguan", "悲观"},
	{"beihai", "被害"},
	{"beihou", "背后"},
	{"beihuan", "悲欢"},
	{"beiji", "北极"},
	{"beijian", "备件 卑贱"},
	{"beijing", "北京 背景"},
	{"beiju", "悲剧"},
	{"beike", "备课"},
	{"beili", "背离"},
	{"beilie", "卑劣"},
	{"beimian", "北面"},
	{"beini", "悖逆"},
	{"beipan", "背叛"},
	{"beipo", "被迫"},
	{"beiqi", "背弃"},
	{"beishang", "悲伤"},
	{"beisong", "北宋 背诵"},
	{"beitao", "被套"},
	{"beitong", "悲痛"},
	{"beiwei", "北纬 卑微"},
	{"beiwen", "碑文"},
	{"beixin", "背心"},
	{"beiying", "背影"},
	{"beiyong", "备用"},
	{"beizhu", "备注"},
	{"benbao", "本报"},
	{"benbo", "奔波"},
	{"benbu", "本部"},
	{"benchang", "本厂"},
	{"benchi", "奔驰"},
	{"bendi", "本地"},
	{"benfang", "奔放"},
	{"benfen", "本分"},
	{"bengdai", "绷带"},
	{"bengfa", "迸发"},
	{"bengkui", "崩溃"},
	{"benglie", "崩裂 迸裂"},
	{"bengta", "崩塌"},
	{"benguo", "本国"},
	{"benjie", "本届"},
	{"benke", "本科"},
	{"benlai", "本来"},
	{"benling", "本领"},
	{"benliu", "奔流"},
	{"benming", "奔命"},
	{"benneng", "本能"},
	{"bennian", "本年"},
	{"benqian", "本钱"},
	{"benren", "本人"},
	{"bense", "本色"},
	{"benshen", "本身"},
	{"benshi", "本事"},
	{"benteng", "奔腾"},
	{"benwen", "本文"},
	{"benxiao", "本校"},
	{"benxing", "本性"},
	{"benyue", "本月"},
	{"benzhe", "本着"},
	{"benzhi", "本质 本职"},
	{"benzhong", "笨重"},
	{"benzhuo", "笨拙"},
	{"benzou", "奔走"},
	{"bfb", "百分比"},
	{"bfj", "半封建"},
	{"bfjx", "百废俱兴"},
	{"bfx", "暴风雪"},
	{"bfy", "暴风雨"},
	{"bgbj", "毕恭毕敬"},
	{"bgs", "办公室"},
	{"bgt", "办公厅"},
	{"bi'an", "彼岸"},
	{"bianbie", "辨别"},
	{"bianbo", "辩驳"},
	{"biance", "鞭策"},
	{"biancheng", "变成 编程"},
	{"bianchi", "鞭笞"},
	{"bianchui", "边陲"},
	{"biandang", "便当"},
	{"biandao", "编导"},
	{"biande", "变得"},
	{"biandi", "遍地 贬低"},
	{"biandong", "变动"},
	{"biandou", "扁豆"},
	{"biane", "匾额"},
	{"bianfang", "边防"},
	{"biange", "变革"},
	{"biangeng", "变更"},
	{"biangua", "变卦"},
	{"bianguan", "边关"},
	{"bianhan", "便函"},
	{"bianhao", "编号"},
	{"bianhu", "辩护"},
	{"bianhua", "变化"},
	{"bianhuan", "变换 变幻"},
	{"bianji", "编辑 边际"},
	{"bianjiang", "边疆"},
	{"bianjie", "辩解 边界"},
	{"bianjing", "边境"},
	{"bianli", "便利"},
	{"bianliang", "变量"},
	{"bianlun", "辩论"},
	{"bianma", "编码"},
	{"bianming", "辩明"},
	{"bianpai", "编排"},
	{"bianpao", "鞭炮"},
	{"bianqian", "变迁"},
	{"bianren", "辨认"},
	{"bianta", "鞭挞"},
	{"biantai", "变态"},
	{"biantian", "变天"},
	{"biantiao", "便条"},
	{"bianwei", "变为"},
	{"bianxi", "辨析"},
	{"bianxiang", "变相"},
	{"bianxie", "编写"},
	{"bianxin", "变心"},
	{"bianyan", "边沿"},
	{"bianyang", "变样"},
	{"bianyi", "编译 贬义 便衣"},
	{"bianyu", "便于"},
	{"bianyuan", "边缘 边远"},
	{"bianzao", "编造"},
	{"bianzhe", "编者"},
	{"bianzheng", "辩证"},
	{"bianzhi", "变质 编制 编织 贬值"},
	{"bianzhuan", "编撰"},
	{"bianzi", "辫子"},
	{"bianzu", "编组"},
	{"bianzuan", "编纂"},
	{"biaobai", "表白"},
	{"biaobang", "标榜"},
	{"biaoben", "标本"},
	{"biaobing", "标兵"},
	{"biaoceng", "表层"},
	{"biaoda", "表达"},
	{"biaodian", "标点"},
	{"biaoge", "表格"},
	{"biaohao", "标号"},
	{"biaoji", "标记"},
	{"biaojia", "标价"},
	{"biaojue", "表决"},
	{"biaoliang", "标量"},
	{"biaolu", "表露"},
	{"biaomian", "表面"},
	{"biaoming", "表明 标明"},
	{"biaoqian", "标签"},
	{"biaoqing", "表情"},
	{"biaoshi", "表示"},
	{"biaoshu", "表述"},
	{"biaotai", "表态"},
	{"biaoti", "标题"},
	{"biaoxian", "表现"},
	{"biaoyan", "表演"},
	{"biaoyang", "表扬"},
	{"biaoyu", "标语 表语"},
	{"biaozhang", "表彰"},
	{"biaozhi", "标志 标致"},
	{"biaozhun", "标准"},
	{"bibang", "臂膀"},
	{"bibei", "必备"},
	{"bibing", "弊病"},
	{"bici", "彼此"},
	{"bidiao", "笔调"},
	{"biding", "必定"},
	{"biduan", "弊端"},
	{"biecheng", "别称"},
	{"biechu", "别处"},
	{"biede", "别的"},
	{"biedong", "别动"},
	{"bieguan", "别管"},
	{"biehou", "别后"},
	{"biejiao", "憋脚"},
	{"biekan", "别看"},
	{"bieli", "别离"},
	{"bieming", "别名"},
	{"bieniu", "别扭"},
	{"bieqi", "憋气"},
	{"bieren", "别人"},
	{"bieshu", "别墅"},
	{"bieti", "别提"},
	{"bieyang", "别样"},
	{"biezhi", "别致"},
	{"bifa", "笔法"},
	{"bifan", "比反"},
	{"bifang", "比方"},
	{"bigong", "逼供"},
	{"biguan", "闭关"},
	{"bihu", "庇护"},
	{"bihua", "笔画"},
	{"bihui", "避讳"},
	{"biji", "笔记 笔迹"},
	{"bijia", "比价"},
	{"bijiang", "必将"},
	{"bijiao", "比较"},
	{"bijin", "逼近"},
	{"bijing", "毕竟"},
	{"bikai", "避开"},
	{"bikong", "碧空"},
	{"bilan", "碧蓝"},
	{"bilei", "壁垒"},
	{"bili", "比例"},
	{"bilv", "碧绿"},
	{"bimian", "避免"},
	{"biming", "笔名"},
	{"bimu", "闭幕"},
	{"binan", "避难"},
	{"binbin", "彬彬"},
	{"binfa", "鬓发"},
	{"binfen", "缤纷"},
	{"bingbao", "冰雹"},
	{"bingbian", "病变 兵变"},
	{"bingbu", "并不"},
	{"bingcheng", "秉承"},
	{"bingchuan", "冰川"},
	{"bingcun", "并存"},
	{"bingdong", "冰冻"},
	{"bingdu", "病毒"},
	{"bingfa", "并发"},
	{"bingfei", "并非"},
	{"bingfu", "禀赋"},
	{"binggong", "秉公"},
	{"binggu", "病故"},
	{"bingjia", "病假"},
	{"bingjian", "并肩"},
	{"bingjin", "并进"},
	{"bingju", "并举"},
	{"bingjun", "病菌"},
	{"bingleng", "冰冷"},
	{"bingli", "兵力"},
	{"binglian", "并联"},
	{"binglie", "并列"},
	{"bingma", "兵马"},
	{"bingmo", "病魔"},
	{"bingqi", "兵器"},
	{"bingqie", "并且"},
	{"bingqing", "病情"},
	{"bingquan", "兵权"},
	{"bingren", "病人"},
	{"bingshan", "冰山"},
	{"bingshuang", "冰霜"},
	{"bingtai", "病态"},
	{"bingtuan", "兵团"},
	{"binguan", "宾馆"},
	{"bingwei", "病危"},
	{"bingxing", "秉性 禀性 并行"},
	{"bingyi", "兵役"},
	{"bingyin", "病因"},
	{"bingying", "兵营"},
	{"bingyuan", "兵员"},
	{"bingzao", "病灶"},
	{"bingzhan", "兵站"},
	{"bingzhong", "兵种 并重"},
	{"bini", "比拟"},
	{"binjiao", "鬓角"},
	{"binlin", "濒临"},
	{"binqi", "摈弃"},
	{"binyu", "宾语"},
	{"bipo", "逼迫"},
	{"biran", "必然"},
	{"biru", "比如"},
	{"bisai", "比赛"},
	{"bise", "闭塞"},
	{"bisheng", "毕生 必胜"},
	{"bishi", "鄙视 比试 笔试"},
	{"bishou", "匕首"},
	{"bishu", "避暑"},
	{"biting", "笔挺"},
	{"biwu", "比武"},
	{"bixian", "避嫌"},
	{"bixu", "必须 必需"},
	{"bixue", "碧血"},
	{"biyao", "必要"},
	{"biye", "毕业"},
	{"biyi", "鄙夷 裨益"},
	{"biyu", "比喻"},
	{"bizhe", "笔者"},
	{"bizhen", "逼真"},
	{"bizhi", "笔直 比值"},
	{"bizhong", "比重"},
	{"bizu", "鼻祖"},
	{"bjb", "编辑部"},
	{"bjs", "北京市"},
	{"bjxj", "不拘小节"},
	{"bjz", "八进制"},
	{"bkb", "不可不"},
	{"bkfr", "不可否认"},
	{"bkqs", "百科全书"},
	{"bksy", "不可思议"},
	{"bld", "不列颠"},
	{"blh", "博览会"},
	{"blj", "八路军"},
	{"blw", "芭蕾舞"},
	{"bmh", "表面化"},
	{"bnb", "不能不"},
	{"boai", "博爱"},
	{"bobo", "伯伯 勃勃"},
	{"bochi", "驳斥"},
	{"boda", "博大"},
	{"bodao", "驳倒"},
	{"bode", "博得"},
	{"bodong", "波动"},
	{"bodou", "搏斗"},
	{"boduo", "剥夺"},
	{"bogu", "博古"},
	{"bohai", "渤海"},
	{"bohui", "驳回"},
	{"boji", "搏击"},
	{"bokuan", "拨款"},
	{"bolan", "博览"},
	{"bolang", "波浪"},
	{"boli", "玻璃"},
	{"bomu", "伯母"},
	{"boran", "勃然"},
	{"boruo", "薄弱"},
	{"boshi", "博士"},
	{"bosong", "播送"},
	{"botao", "波涛"},
	{"bowu", "博物"},
	{"boxue", "剥削 博学"},
	{"boyin", "播音"},
	{"bozhe", "波折"},
	{"bozhong", "播种"},
	{"bqsj", "不求甚解 不切实际"},
	{"bqzy", "霸权主义"},
	{"brhj", "薄弱环节"},
	{"brx", "必然性"},
	{"bsbs", "不三不四"},
	{"bsc", "办事处"},
	{"bsj", "本世纪"},
	{"bsy", "办事员"},
	{"bszr", "饱食终日"},
	{"btef", "半途而废"},
	{"btfx", "不同凡响"},
	{"btls", "遍体鳞伤"},
	{"bu'an", "不安"},
	{"bubi", "不必 不比"},
	{"bubian", "不变 不便"},
	{"bubing", "步兵"},
	{"bubu", "步步"},
	{"buceng", "不曾"},
	{"buchang", "补偿"},
	{"buchi", "不啻"},
	{"buchong", "补充"},
	{"bucuo", "不错"},
	{"buda", "不大"},
	{"budai", "不待"},
	{"budan", "不但"},
	{"budang", "不当"},
	{"bude", "不得"},
	{"budeng", "不等"},
	{"budiao", "步调"},
	{"buding", "补丁"},
	{"budong", "不动"},
	{"buduan", "不断"},
	{"budui", "不对 部队"},
	{"bufa", "不法 步伐"},
	{"bufan", "不凡"},
	{"bufang", "不妨"},
	{"bufen", "部分 不分"},
	{"bufu", "不服 不符"},
	{"bugai", "不该"},
	{"bugan", "不敢 不甘"},
	{"bugao", "布告"},
	{"bugou", "不够"},
	{"bugu", "不顾"},
	{"buguan", "不管"},
	{"buguo", "不过"},
	{"buhao", "不好"},
	{"buhui", "不会"},
	{"buji", "补给"},
	{"bujian", "部件"},
	{"bujie", "不借"},
	{"bujin", "不仅 不禁 不尽"},
	{"bujing", "布景"},
	{"bujiu", "不久 补救"},
	{"buju", "布局"},
	{"bukan", "不堪"},
	{"buke", "不可"},
	{"bukuai", "不快"},
	{"bukui", "不愧"},
	{"buli", "不理 不利"},
	{"buliang", "不良"},
	{"buliao", "不料"},
	{"bulv", "步履"},
	{"bulun", "不论"},
	{"buluo", "部落"},
	{"buman", "不满"},
	{"bumen", "部门"},
	{"bumian", "不免"},
	{"buneng", "不能"},
	{"bupa", "不怕"},
	{"bupin", "补品"},
	{"buping", "不平"},
	{"buqiang", "步枪"},
	{"buqu", "不屈"},
	{"buran", "不然"},
	{"buru", "不如"},
	{"bushao", "不少"},
	{"bushi", "不是 不识"},
	{"bushou", "部首"},
	{"bushu", "部属 部署"},
	{"butie", "补贴"},
	{"butong", "不同"},
	{"butuo", "不妥"},
	{"buwei", "部位 部委"},
	{"buwen", "不问"},
	{"buxi", "不惜 补习"},
	{"buxia", "部下"},
	{"buxing", "不行 不幸 步行"},
	{"buxiu", "不朽"},
	{"buxu", "不许"},
	{"buyang", "哺养"},
	{"buyao", "不要"},
	{"buyi", "不宜"},
	{"buyong", "不用"},
	{"buyu", "哺育"},
	{"buzai", "不在"},
	{"buzhang", "部长"},
	{"buzhen", "不振"},
	{"buzhi", "不只 不止 不知 不致 布置"},
	{"buzhou", "步骤"},
	{"buzhu", "补助"},
	{"buzhuo", "捕捉"},
	{"buzi", "步子"},
	{"buzu", "不足"},
	{"bwg", "博物馆"},
	{"bwzg", "保卫祖国"},
	{"bxly", "标新立异"},
	{"bxp", "必需品"},
	{"bxqy", "背信弃义"},
	{"bxsx", "不相上下"},
	{"bxws", "不学无术"},
	{"byc", "百叶窗"},
	{"byet", "不约而同"},
	{"byey", "不言而喻"},
	{"byj", "不要紧"},
	{"bykx", "边缘科学"},
	{"bysg", "半夜三更"},
	{"bytd", "别有天地"},
	{"byx", "必要性"},
	{"byzz", "不由自主"},
	{"bza", "编者按"},
	{"bzbj", "不着边际"},
	{"bzbn", "百折不挠"},
	{"bzf", "辩证法"},
	{"bzh", "标准化"},
	{"bzj", "标准件"},
	{"bzsc", "不知所措"},
	{"bzsd", "不择手段"},
	{"bzy", "不至于"},
	{"bzz", "标志着"},
	{"bzzf", "不正之风"},
	{"caibao", "财宝"},
	{"caice", "猜测"},
	{"caichan", "财产"},
	{"caidan", "菜单"},
	{"caidian", "彩电"},
	{"caiding", "裁定"},
	{"caifa", "财阀 采伐"},
	{"caifang", "采访"},
	{"caifeng", "裁缝"},
	{"caifu", "财富"},
	{"caigan", "才干"},
	{"caigou", "采购"},
	{"caihua", "才华"},
	{"caiji", "采集"},
	{"caijian", "裁减"},
	{"caijing", "财经"},
	{"caijue", "裁决"},
	{"caikuang", "采矿"},
	{"caili", "财力"},
	{"cailiao", "材料"},
	{"caimao", "财贸"},
	{"caina", "采纳"},
	{"caineng", "才能"},
	{"caipai", "彩排"},
	{"caipan", "裁判"},
	{"caipiao", "彩票"},
	{"caiqi", "才气"},
	{"caiqu", "采取"},
	{"caiquan", "财权 猜拳"},
	{"caise", "彩色"},
	{"caishi", "才是 才识"},
	{"caituan", "财团"},
	{"caiwu", "财物 财务"},
	{"caixie", "采撷"},
	{"caixue", "才学"},
	{"caiyao", "菜肴"},
	{"caiyi", "猜疑"},
	{"caiyong", "采用"},
	{"caiyuan", "财源"},
	{"caizheng", "财政"},
	{"caizhi", "才智"},
	{"caizhu", "财主"},
	{"caizi", "才子"},
	{"canan", "惨案"},
	{"canbai", "惨白"},
	{"canbao", "残暴"},
	{"candan", "惨淡"},
	{"canfei", "残废"},
	{"cangbai", "苍白"},
	{"cangcu", "仓促"},
	{"cangku", "仓库"},
	{"canglao", "苍老"},
	{"cangmang", "苍茫"},
	{"cangni", "藏匿"},
	{"cangqiong", "苍穹"},
	{"cangsang", "沧桑"},
	{"cangtian", "苍天"},
	{"canguan", "参观"},
	{"canhai", "残骸"},
	{"canji", "残疾"},
	{"canjia", "参加"},
	{"canjian", "参见"},
	{"canju", "残局 惨剧"},
	{"canjun", "参军"},
	{"cankan", "参看"},
	{"cankao", "参考"},
	{"canku", "残酷"},
	{"cankui", "惭愧"},
	{"canlan", "灿烂"},
	{"canmou", "参谋"},
	{"canque", "残缺"},
	{"canren", "残忍"},
	{"canruo", "孱弱"},
	{"cansha", "残杀"},
	{"cansheng", "残生"},
	{"canshi", "蚕食"},
	{"canshu", "参数"},
	{"cantong", "惨痛"},
	{"canyu", "参与 残余"},
	{"canyue", "参阅"},
	{"canzan", "参赞"},
	{"canzao", "惨遭"},
	{"canzhan", "参战"},
	{"canzhao", "参照"},
	{"canzheng", "参政"},
	{"canzhong", "惨重"},
	{"caoan", "草案"},
	{"caogao", "草稿"},
	{"caolao", "操劳"},
	{"caolian", "操练"},
	{"caomu", "草木"},
	{"caoni", "草拟"},
	{"caoqian", "草签"},
	{"caoshuai", "草率"},
	{"caoxin", "操心"},
	{"caoyuan", "草原"},
	{"caoza", "嘈杂"},
	{"caozong", "操纵"},
	{"caozuo", "操作"},
	{"cbd", "差不多"},
	{"cbhs", "成本核算"},
	{"cbs", "出版社"},
	{"ccbq", "层出不穷"},
	{"ccjy", "从长计议"},
	{"ccmm", "匆匆忙忙"},
	{"ccq", "存储器"},
	{"ccs", "长春市"},
	{"cczw", "除此之外"},
	{"cds", "成都市"},
	{"ceding", "测定"},
	{"cedong", "策动"},
	{"cefan", "策反"},
	{"cehua", "策划"},
	{"celiang", "测量"},
	{"celue", "策略"},
	{"cemian", "侧面"},
	{"cencen", "涔涔"},
	{"cengceng", "层层"},
	{"cengci", "层次"},
	{"cengjing", "曾经"},
	{"ceshi", "测试"},
	{"cesuo", "厕所"},
	{"ceyan", "测验"},
	{"cezhong", "侧重"},
	{"cfd", "出发点"},
	{"cffh", "充分发挥"},
	{"cgd", "唱高调"},
	{"cgdj", "从古到今"},
	{"chaban", "查办"},
	{"chabie", "差别"},
	{"chachi", "差池"},
	{"chacuo", "差错"},
	{"chadian", "差点"},
	{"chadui", "查对"},
	{"chae", "差额"},
	{"chafang", "查访 察访"},
	{"chafeng", "查封"},
	{"chahuo", "查获"},
	{"chaichuan", "拆穿"},
	{"chailang", "豺狼"},
	{"chaisan", "拆散"},
	{"chaishi", "差使"},
	{"chaixie", "拆卸"},
	{"chaiyou", "柴油"},
	{"chajia", "差价"},
	{"chaju", "差距"},
	{"chajue", "察觉"},
	{"chakan", "查看 察看"},
	{"chakao", "查考"},
	{"chaming", "查明"},
	{"chanchu", "铲除"},
	{"chandi", "产地"},
	{"chanfa", "阐发"},
	{"chanfu", "搀扶 产妇"},
	{"changan", "长安"},
	{"changchang", "常常"},
	{"changcheng", "长城"},
	{"changchun", "长春"},
	{"changda", "畅达"},
	{"changdao", "倡导"},
	{"changdu", "长度"},
	{"changduan", "长短"},
	{"changge", "唱歌"},
	{"changgui", "常规"},
	{"changhe", "场合"},
	{"changhuan", "偿还"},
	{"changjia", "厂家"},
	{"changjian", "常见"},
	{"changjiang", "长江"},
	{"changjiu", "长久"},
	{"changjue", "猖獗"},
	{"changkong", "长空"},
	{"changkuai", "畅快"},
	{"changkuang", "猖狂"},
	{"changmian", "场面 长眠"},
	{"changnian", "长年"},
	{"changpian", "长篇"},
	{"changqi", "长期"},
	{"changqu", "长驱"},
	{"changren", "常任"},
	{"changsha", "长沙"},
	{"changshang", "厂商"},
	{"changshi", "常识 尝试"},
	{"changshou", "长寿"},
	{"changshu", "常数"},
	{"changsuo", "场所"},
	{"changtan", "畅谈"},
	{"changtu", "长途"},
	{"changwang", "怅惘"},
	{"changwei", "常委"},
	{"changwen", "常温"},
	{"changwu", "常务"},
	{"changxiang", "畅想"},
	{"changxiao", "畅销"},
	{"changyang", "徜徉"},
	{"changyi", "倡议"},
	{"changyin", "畅饮"},
	{"changyong", "常用"},
	{"changyou", "常有 畅游"},
	{"changyuan", "长远"},
	{"changzhang", "厂长"},
	{"changzheng", "长征"},
	{"changzhi", "厂址"},
	{"changzhu", "常驻"},
	{"chanhuo", "掺和"},
	{"chanjia", "掺假"},
	{"chanjuan", "婵娟"},
	{"chanlian", "蝉联"},
	{"chanliang", "产量"},
	{"chanmian", "缠绵"},
	{"chanming", "阐明"},
	{"chanpin", "产品"},
	{"chanquan", "产权"},
	{"chanrao", "缠绕"},
	{"chansheng", "产生"},
	{"chanshi", "禅师"},
	{"chanshu", "阐述"},
	{"chanwu", "产物"},
	{"chanxiao", "产销"},
	{"chanye", "产业"},
	{"chanza", "掺杂"},
	{"chanzhi", "产值"},
	{"chaobao", "抄报"},
	{"chaochan", "超产"},
	{"chaochu", "超出"},
	{"chaodai", "朝代"},
	{"chaoe", "超额"},
	{"chaofeng", "嘲讽"},
	{"chaoguo", "超过"},
	{"chaoji", "超级"},
	{"chaojia", "吵架"},
	{"chaojie", "潮解"},
	{"chaoliu", "潮流"},
	{"chaolu", "抄录"},
	{"chaonao", "吵闹"},
	{"chaonong", "嘲弄"},
	{"chaoshi", "潮湿 超市"},
	{"chaoshui", "潮水"},
	{"chaosong", "抄送"},
	{"chaotuo", "超脱"},
	{"chaoxi", "抄袭"},
	{"chaoxian", "朝鲜"},
	{"chaoxiao", "嘲笑"},
	{"chaoxue", "巢穴"},
	{"chaoyang", "朝阳"},
	{"chaoye", "朝野"},
	{"chaoyue", "超越"},
	{"chaozhi", "超支"},
	{"chaqing", "查清"},
	{"chaqu", "插曲"},
	{"charu", "插入"},
	{"chashao", "查哨 叉烧"},
	{"chashou", "插手 查收"},
	{"chatu", "插图"},
	{"chawen", "查问"},
	{"chaxun", "查询"},
	{"chaye", "茶叶"},
	{"chayi", "差异"},
	{"chayue", "查阅"},
	{"chazheng", "查证"},
	{"chazi", "岔子"},
	{"chazu", "插足"},
	{"chedi", "彻底"},
	{"chehuo", "车祸"},
	{"chejian", "车间"},
	{"cheliang", "车辆"},
	{"chenai", "尘埃"},
	{"chendian", "沉淀"},
	{"chenfu", "沉浮"},
	{"chengbai", "成败"},
	{"chengban", "承办 惩办"},
	{"chengbao", "承包 呈报"},
	{"chengben", "成本"},
	{"chengcai", "成材"},
	{"chengche", "澄澈"},
	{"chengchu", "惩处 乘除"},
	{"chengdan", "承担"},
	{"chengdang", "承当"},
	{"chengdu", "程度 成都"},
	{"chengfa", "乘法 惩罚"},
	{"chengfen", "成分"},
	{"chenggong", "成功"},
	{"chenggui", "成规"},
	{"chengguo", "成果"},
	{"chenghao", "称号"},
	{"chenghu", "称呼"},
	{"chengji", "成绩 乘机"},
	{"chengjia", "成家"},
	{"chengjian", "成见"},
	{"chengjiao", "成交"},
	{"chengjie", "惩戒"},
	{"chengjiu", "成就"},
	{"chengke", "乘客"},
	{"chengken", "诚恳"},
	{"chengli", "成立"},
	{"chengliang", "乘凉"},
	{"chengming", "成名"},
	{"chengnian", "成年"},
	{"chengpi", "成批"},
	{"chengpin", "成品"},
	{"chengpu", "诚朴"},
	{"chengqiang", "逞强"},
	{"chengqing", "澄清"},
	{"chengqu", "城区"},
	{"chengquan", "成全"},
	{"chengran", "诚然"},
	{"chengren", "承认 成人"},
	{"chengse", "成色"},
	{"chengshi", "诚实 城市 成事"},
	{"chengshou", "承受"},
	{"chengshu", "成熟"},
	{"chengwei", "成为 称谓"},
	{"chengwen", "成文"},
	{"chengxian", "呈现 呈献"},
	{"chengxiang", "城乡"},
	{"chengxiao", "成效"},
	{"chengxin", "诚心"},
	{"chengxu", "程序 乘虚"},
	{"chengyao", "撑腰"},
	{"chengyi", "诚意"},
	{"chengyu", "成语"},
	{"chengyuan", "成员"},
	{"chengzan", "称赞"},
	{"chengzhang", "成长"},
	{"chengzhen", "城镇"},
	{"chengzhi", "诚挚"},
	{"chenji", "趁机 沉积 陈迹"},
	{"chenjin", "沉浸"},
	{"chenjing", "沉静"},
	{"chenjiu", "陈旧"},
	{"chenlie", "陈列"},
	{"chenlun", "沉沦"},
	{"chenmen", "沉闷"},
	{"chenmian", "沉湎"},
	{"chenmo", "沉默"},
	{"chenni", "沉溺"},
	{"chenshe", "陈设"},
	{"chenshu", "陈述"},
	{"chenshuo", "陈说"},
	{"chensi", "沉思"},
	{"chentong", "沉痛"},
	{"chentuo", "衬托"},
	{"chenxin", "称心"},
	{"chenyin", "沉吟"},
	{"chenying", "衬映"},
	{"chenzao", "趁早"},
	{"chenzhi", "称职"},
	{"chenzhong", "沉重"},
	{"chenzhuo", "沉着"},
	{"chepi", "扯皮 车皮"},
	{"chetui", "撤退"},
	{"chexiang", "车厢"},
	{"chexiao", "撤消"},
	{"chezhan", "车站"},
	{"chezhi", "撤职"},
	{"chibang", "翅膀"},
	{"chicheng", "驰骋 赤诚"},
	{"chicun", "尺寸"},
	{"chidao", "迟到 赤道"},
	{"chidu", "尺度"},
	{"chidun", "迟钝"},
	{"chifan", "吃饭"},
	{"chihe", "吃喝"},
	{"chihuan", "迟缓"},
	{"chijin", "吃紧"},
	{"chijing", "吃惊"},
	{"chijiu", "持久"},
	{"chiku", "吃苦"},
	{"chikui", "吃亏"},
	{"chili", "吃力"},
	{"chilie", "炽烈"},
	{"chilun", "齿轮"},
	{"chimi", "侈靡"},
	{"chiping", "持平"},
	{"chiqing", "痴情"},
	{"chire", "炽热"},
	{"chiru", "耻辱"},
	{"chitang", "池塘"},
	{"chixiao", "耻笑"},
	{"chixin", "赤心 痴心"},
	{"chixu", "持续"},
	{"chiyi", "迟疑"},
	{"chizao", "迟早"},
	{"chize", "斥责"},
	{"chizha", "叱咤"},
	{"chizhong", "持重"},
	{"chizi", "赤字"},
	{"chj", "催化剂"},
	{"chongai", "宠爱"},
	{"chongbai", "崇拜"},
	{"chongchi", "充斥"},
	{"chongci", "冲刺"},
	{"chongdan", "冲淡"},
	{"chongdang", "充当"},
	{"chongdie", "重叠"},
	{"chongdong", "冲动"},
	{"chonger", "宠儿"},
	{"chongfen", "充分"},
	{"chongfeng", "冲锋"},
	{"chongfu", "重复"},
	{"chonggao", "崇高"},
	{"chonghe", "重合"},
	{"chonghun", "重婚"},
	{"chongji", "冲击"},
	{"chongjian", "重建"},
	{"chongjing", "崇敬 憧憬"},
	{"chongman", "充满"},
	{"chongpei", "充沛"},
	{"chongpo", "冲破"},
	{"chongqing", "重庆"},
	{"chongshang", "崇尚"},
	{"chongshen", "重申"},
	{"chongshi", "充实"},
	{"chongshua", "冲刷"},
	{"chongtian", "冲天"},
	{"chongtu", "冲突"},
	{"chongwen", "重温"},
	{"chongxi", "冲洗"},
	{"chongxin", "重新"},
	{"chongyan", "重演"},
	{"chongyin", "重印"},
	{"chongyu", "充裕"},
	{"chongzu", "充足"},
	{"chouban", "筹办"},
	{"choubei", "筹备"},
	{"chouchang", "惆怅"},
	{"chouchu", "踌躇 抽搐"},
	{"choucuo", "筹措"},
	{"choudiao", "抽调"},
	{"choue", "丑恶"},
	{"chouhen", "仇恨"},
	{"chouhua", "丑化 筹划"},
	{"chouji", "筹集"},
	{"choujian", "筹建"},
	{"choujin", "酬金"},
	{"choukong", "抽空"},
	{"choulao", "酬劳"},
	{"choulou", "丑陋"},
	{"chouma", "筹码"},
	{"choumi", "稠密"},
	{"choumou", "筹谋"},
	{"chourong", "愁容"},
	{"chouxiang", "抽象"},
	{"chouxie", "酬谢"},
	{"chouye", "抽噎"},
	{"chuaiduo", "揣度"},
	{"chuaimo", "揣摩"},
	{"chuanbian", "传遍"},
	{"chuanbo", "传播 船舶"},
	{"chuanbu", "船埠"},
	{"chuancha", "穿插"},
	{"chuanda", "传达"},
	{"chuandan", "传单"},
	{"chuandao", "传导"},
	{"chuandi", "传递"},
	{"chuangban", "创办"},
	{"chuangdang", "闯荡"},
	{"chuanghu", "窗户"},
	{"chuangjian", "创建 创见"},
	{"chuangjin", "闯劲"},
	{"chuangju", "创举"},
	{"chuangkou", "窗口"},
	{"chuangli", "创立"},
	{"chuanglian", "窗帘"},
	{"chuangshi", "创始"},
	{"chuangxin", "创新"},
	{"chuangye", "创业"},
	{"chuangzao", "创造"},
	{"chuangzuo", "创作"},
	{"chuanlian", "串联"},
	{"chuanqi", "传奇 喘气"},
	{"chuanran", "传染"},
	{"chuanshou", "传授"},
	{"chuanshu", "传输"},
	{"chuanshuo", "传说"},
	{"chuansong", "传送"},
	{"chuantong", "传统 串通"},
	{"chuanxi", "喘息"},
	{"chuanxun", "传讯"},
	{"chuanyang", "传扬"},
	{"chuanyue", "传阅"},
	{"chuanzhen", "传真"},
	{"chuanzhi", "船只"},
	{"chuanzhuo", "穿着"},
	{"chuban", "出版"},
	{"chubang", "出榜"},
	{"chubei", "储备"},
	{"chubing", "出兵"},
	{"chubu", "初步"},
	{"chucang", "储藏"},
	{"chucha", "出差"},
	{"chuchan", "出产"},
	{"chuchang", "出场 出厂"},
	{"chuchu", "处处"},
	{"chuchuang", "橱窗"},
	{"chuci", "初次"},
	{"chucun", "储存"},
	{"chudeng", "初等"},
	{"chudong", "出动 触动"},
	{"chufa", "出发 触发 除法 处罚"},
	{"chufan", "触犯"},
	{"chufang", "出访"},
	{"chufei", "除非"},
	{"chufen", "处分"},
	{"chugui", "出轨"},
	{"chuhai", "出海"},
	{"chuifeng", "吹风"},
	{"chuifu", "吹拂"},
	{"chuilian", "锤炼"},
	{"chuiniu", "吹牛"},
	{"chuipeng", "吹捧"},
	{"chuiqing", "垂青"},
	{"chuixian", "垂涎"},
	{"chuixu", "吹嘘"},
	{"chuizhi", "垂直"},
	{"chuji", "初级 出击"},
	{"chujie", "出界"},
	{"chujing", "出境 处境"},
	{"chujue", "处决 触觉"},
	{"chukai", "除开"},
	{"chukou", "出口"},
	{"chulai", "出来"},
	{"chule", "除了"},
	{"chuli", "处理 出力 矗立"},
	{"chulian", "初恋"},
	{"chulong", "出笼"},
	{"chulu", "出路"},
	{"chuma", "出马"},
	{"chumai", "出卖"},
	{"chumian", "出面"},
	{"chuming", "出名 除名"},
	{"chumo", "出没"},
	{"chuna", "出纳"},
	{"chunbo", "春播"},
	{"chuncui", "纯粹"},
	{"chundu", "纯度"},
	{"chunfen", "春分"},
	{"chunfeng", "春风"},
	{"chungeng", "春耕"},
	{"chunguang", "春光"},
	{"chunhou", "醇厚"},
	{"chunhui", "春辉"},
	{"chunji", "春季"},
	{"chunjie", "春节 纯洁"},
	{"chunjing", "纯净"},
	{"chunli", "纯利"},
	{"chunpu", "淳朴"},
	{"chunqiu", "春秋"},
	{"chunse", "春色"},
	{"chunsun", "春笋"},
	{"chuntian", "春天"},
	{"chunu", "触怒"},
	{"chunv", "处女"},
	{"chunyi", "春意"},
	{"chunzhen", "纯真"},
	{"chunzheng", "纯正"},
	{"chuochuan", "戳穿"},
	{"chuohao", "绰号"},
	{"chuoqi", "啜泣"},
	{"chupin", "出品"},
	{"chuqi", "初期 出奇"},
	{"chuqin", "出勤"},
	{"chuqu", "出去"},
	{"churang", "出让"},
	{"churen", "出任"},
	{"churu", "出入"},
	{"chuse", "出色"},
	{"chushen", "出身 出神"},
	{"chusheng", "出生 畜生"},
	{"chushi", "出事 出世 处世 厨师"},
	{"chushou", "出售"},
	{"chusuo", "处所"},
	{"chuting", "出庭"},
	{"chutou", "锄头"},
	{"chutu", "出土"},
	{"chuwai", "除外"},
	{"chuxi", "出席 出息 除夕"},
	{"chuxian", "出现"},
	{"chuxiao", "初小"},
	{"chuxing", "雏形"},
	{"chuxu", "储蓄"},
	{"chuyi", "初一 刍议"},
	{"chuyu", "处于"},
	{"chuzhan", "初战"},
	{"chuzhang", "处长"},
	{"chuzhen", "出诊"},
	{"chuzheng", "出征"},
	{"chuzhi", "处置"},
	{"chuzhong", "初中"},
	{"chuzu", "出租"},
	{"ciai", "慈爱"},
	{"cibie", "辞别"},
	{"cichang", "磁场"},
	{"cidai", "磁带"},
	{"cidao", "磁道"},
	{"cidi", "此地"},
	{"cidian", "词典 辞典"},
	{"cier", "刺耳"},
	{"cigen", "词根"},
	{"cigu", "刺骨"},
	{"cihou", "此后"},
	{"cihui", "词汇"},
	{"ciji", "刺激"},
	{"cijiao", "赐教"},
	{"cike", "刺客"},
	{"cilei", "词类"},
	{"ciling", "辞令"},
	{"cipan", "磁盘"},
	{"cipin", "次品"},
	{"ciqi", "瓷器"},
	{"ciqu", "辞去"},
	{"cisha", "刺杀"},
	{"cishi", "此时"},
	{"cishu", "次数"},
	{"cisu", "词素"},
	{"citang", "祠堂"},
	{"citui", "辞退"},
	{"ciwai", "此外"},
	{"cixiang", "慈祥"},
	{"cixing", "辞行 词性"},
	{"cixiong", "雌雄"},
	{"cixu", "次序 词序"},
	{"ciyan", "刺眼"},
	{"ciyao", "次要"},
	{"ciyu", "词语 赐予"},
	{"cizhi", "此致 辞职"},
	{"cizhui", "词缀"},
	{"cizu", "词组"},
	{"cjdg", "超级大国"},
	{"cks", "参考书"},
	{"ckxx", "参考消息"},
	{"ckzl", "参考资料"},
	{"clpt", "触类旁通"},
	{"clwh", "藏龙卧虎"},
	{"cmc", "参谋长"},
	{"cmcz", "聪明才智"},
	{"cmhc", "出谋划策"},
	{"congci", "从此"},
	{"congcong", "匆匆"},
	{"congcu", "匆促"},
	{"conger", "从而"},
	{"congfan", "从犯"},
	{"conghui", "聪慧"},
	{"congjian", "从简"},
	{"congkuan", "从宽"},
	{"conglai", "从来"},
	{"conglin", "丛林"},
	{"congmang", "匆忙"},
	{"congming", "聪明"},
	{"congqian", "从前"},
	{"congrong", "从容"},
	{"congshi", "从事"},
	{"congshu", "丛书"},
	{"congsu", "从速"},
	{"congxin", "从新"},
	{"congyan", "从严"},
	{"congying", "聪颖"},
	{"congyu", "葱郁"},
	{"congzhong", "从中"},
	{"couhe", "凑合"},
	{"couqiao", "凑巧"},
	{"cpl", "成品率"},
	{"cqsw", "成千上万"},
	{"cqzr", "长驱直入"},
	{"crbp", "从容不迫"},
	{"crcw", "承认错误"},
	{"crdt", "趁热打铁"},
	{"csbj", "措手不及"},
	{"csl", "出生率"},
	{"csrh", "出神入化"},
	{"csrs", "出生入死"},
	{"css", "长沙市"},
	{"csy", "炊事员"},
	{"ctcw", "彻头彻尾"},
	{"ctsq", "垂头丧气"},
	{"cuanduo", "篡夺"},
	{"cuanfan", "窜犯"},
	{"cuangai", "篡改"},
	{"cuanquan", "篡权"},
	{"chuanwei", "篡位"},
	{"cubao", "粗暴"},
	{"cucao", "粗糙"},
	{"cuguang", "粗犷"},
	{"cuican", "摧残"},
	{"cuiruo", "脆弱"},
	{"cujin", "促进"},
	{"culu", "粗鲁"},
	{"cunchu", "存储"},
	{"cundang", "存档"},
	{"cunfang", "存放"},
	{"cunkuan", "存款"},
	{"cunluo", "村落"},
	{"cunwang", "存亡"},
	{"cunzai", "存在"},
	{"cunzhen", "村镇"},
	{"cunzhuang", "村庄"},
	{"cunzi", "村子"},
	{"cuoan", "错案"},
	{"cuobai", "挫败"},
	{"cuochu", "错处"},
	{"cuoci", "措辞"},
	{"cuoguai", "错怪"},
	{"cuoguo", "错过"},
	{"cuohe", "撮合"},
	{"cuojue", "错觉"},
	{"cuoshang", "磋商 挫伤"},
	{"cuoshi", "措施"},
	{"cuowu", "错误"},
	{"cuozhe", "挫折"},
	{"cuozong", "错综"},
	{"cuqian", "粗浅"},
	{"cushi", "促使"},
	{"cusu", "粗俗"},
	{"cuxin", "粗心"},
	{"cuzhuang", "粗壮"},
	{"cwh", "常委会"},
	{"cwwh", "常务委员会"},
	{"cwy", "乘务员"},
	{"cxcy", "诚心诚意"},
	{"cxkz", "程序控制"},
	{"cxsj", "程序设计"},
	{"cxx", "喘吁吁"},
	{"cyly", "长远利益"},
	{"czb", "财政部"},
	{"czfz", "错综复杂"},
	{"czgj", "操之过急"},
	{"czqc", "出租汽车"},
	{"czwj", "财政危机"},
	{"czx", "创造性"},
	{"czxt", "操作系统"},
	{"czy", "操作员"},
	{"czyh", "持之以恒"},
	{"daan", "答案"},
	{"dabai", "打败"},
	{"daban", "大办 大半 打扮"},
	{"dabian", "答辩"},
	{"dabo", "大伯"},
	{"dabu", "大部"},
	{"dacheng", "达成"},
	{"dadan", "大胆"},
	{"dadang", "搭档"},
	{"dadao", "大道 达到 打倒"},
	{"dadi", "大地 大敌 大抵"},
	{"daduan", "打断"},
	{"dadui", "大队"},
	{"daduo", "大多"},
	{"dafan", "大凡"},
	{"dafu", "大夫 大幅 答复"},
	{"dagai", "大概"},
	{"dagang", "大纲"},
	{"daguo", "大国"},
	{"dahai", "大海"},
	{"dahao", "大好"},
	{"dahe", "大河"},
	{"daheng", "大亨"},
	{"dahui", "大会"},
	{"daibiao", "代表"},
	{"daibu", "逮捕"},
	{"daici", "代词"},
	{"daidong", "带动"},
	{"daigong", "怠工"},
	{"daijia", "代价"},
	{"daikuan", "贷款"},
	{"dailai", "带来"},
	{"daili", "代理"},
	{"dailing", "带领"},
	{"dailu", "带路"},
	{"dailv", "黛绿"},
	{"daima", "代码"},
	{"daiman", "怠慢"},
	{"daiming", "待命"},
	{"daishu", "代数"},
	{"daiti", "代替"},
	{"daitou", "带头"},
	{"daitu", "歹徒"},
	{"daixiao", "戴孝"},
	{"daiyu", "待遇"},
	{"daizhi", "呆滞"},
	{"daizi", "呆子"},
	{"daji", "打击"},
	{"dajia", "大家"},
	{"dajiao", "打搅"},
	{"dajie", "大街 大捷 打劫"},
	{"dajiu", "搭救"},
	{"daju", "大局"},
	{"dajuan", "答卷"},
	{"dakai", "打开"},
	{"dala", "耷拉"},
	{"dali", "大力"},
	{"dalian", "大连"},
	{"daliang", "大量 打量"},
	{"dalu", "大陆"},
	{"dalue", "大略"},
	{"dama", "大妈"},
	{"danao", "大脑"},
	{"danbao", "担保"},
	{"danbo", "单薄 淡泊"},
	{"danchan", "单产"},
	{"danchen", "诞辰"},
	{"danchun", "单纯"},
	{"danci", "单词"},
	{"dandang", "担当"},
	{"dandiao", "单调"},
	{"dandu", "单独"},
	{"danfang", "单方"},
	{"danfu", "担负"},
	{"dan'gan", "单干 胆敢"},
	{"dangan", "档案"},
	{"dangchang", "当场"},
	{"dangchu", "当初"},
	{"dangdai", "当代"},
	{"dangdi", "当地"},
	{"dan'ge", "单个 耽搁"},
	{"dangfeng", "党风"},
	{"danggang", "党纲"},
	{"dangji", "当即 党纪 党籍"},
	{"dangjia", "当家"},
	{"dangjin", "当今"},
	{"dangju", "当局"},
	{"dangliang", "当量"},
	{"dangmian", "当面"},
	{"dangnei", "党内"},
	{"dangnian", "当年"},
	{"dangpai", "党派"},
	{"dangpu", "当铺"},
	{"dangqian", "当前"},
	{"dangran", "当然"},
	{"dangri", "当日"},
	{"dangshi", "当时"},
	{"dangtian", "当天"},
	{"dangtou", "当头"},
	{"dangtuan", "党团"},
	{"dangwan", "当晚"},
	{"dangwei", "党委"},
	{"dangxian", "当先"},
	{"dangxiao", "党校"},
	{"dangxin", "当心"},
	{"dangxing", "党性"},
	{"dangyang", "荡漾"},
	{"dangyuan", "党员"},
	{"dangyue", "当月"},
	{"dangzhang", "党章"},
	{"dangzhen", "当真"},
	{"dangzheng", "当政 党政"},
	{"dangzhong", "当中 当众"},
	{"dangzuo", "当作"},
	{"danjia", "单价 担架"},
	{"danliang", "胆量"},
	{"danlue", "胆略"},
	{"danmo", "淡漠"},
	{"danqie", "胆怯"},
	{"danqing", "丹青"},
	{"danran", "淡然"},
	{"danren", "担任"},
	{"danshen", "单身"},
	{"dansheng", "诞生"},
	{"danshi", "但是 胆识"},
	{"danti", "单体"},
	{"dantian", "丹田"},
	{"danwei", "单位"},
	{"danwu", "耽误"},
	{"danxiang", "单项"},
	{"danxiao", "胆小"},
	{"danxin", "担心"},
	{"danya", "淡雅"},
	{"danyao", "弹药"},
	{"danyi", "单一"},
	{"danyou", "担忧"},
	{"danyuan", "单元 但愿"},
	{"danzhi", "单质"},
	{"danzi", "担子 掸子 单字"},
	{"daobi", "倒闭"},
	{"daochu", "到处"},
	{"daoci", "悼词"},
	{"daoda", "到达"},
	{"daodan", "导弹"},
	{"daode", "道德"},
	{"daodi", "到底"},
	{"daoge", "倒戈"},
	{"daogui", "捣鬼"},
	{"daohui", "捣毁"},
	{"daolai", "到来"},
	{"daole", "到了"},
	{"daoli", "道理 倒立"},
	{"daolu", "道路"},
	{"daoluan", "捣乱"},
	{"daomei", "倒霉"},
	{"daonian", "叨念"},
	{"daoqian", "道歉"},
	{"daoqiang", "刀枪"},
	{"daoqie", "盗窃"},
	{"daoshi", "到时 导师"},
	{"daoshu", "倒数"},
	{"daoti", "导体"},
	{"daotui", "倒退"},
	{"daoyan", "导演"},
	{"daoyi", "道义"},
	{"daoyong", "盗用"},
	{"daoyu", "岛屿"},
	{"daozhi", "导致"},
	{"dapi", "大批"},
	{"dapo", "大破 打破"},
	{"daqi", "大气"},
	{"daqing", "大庆"},
	{"darao", "打扰"},
	{"dasao", "打扫"},
	{"dasha", "大厦"},
	{"dashan", "搭讪"},
	{"dashe", "大赦"},
	{"dashi", "大使 大事 大师 大势"},
	{"dasi", "大肆"},
	{"dasuan", "打算"},
	{"dati", "大体"},
	{"dating", "大厅 打听"},
	{"datong", "大同"},
	{"daxiao", "大小"},
	{"daxie", "大写 答谢"},
	{"daxuan", "大选"},
	{"daxue", "大学"},
	{"daye", "大业"},
	{"dayin", "打印 达因"},
	{"daying", "答应"},
	{"dayu", "大于"},
	{"dayuan", "大院"},
	{"dayue", "大约"},
	{"dazhang", "打仗"},
	{"dazhi", "大致"},
	{"dazhong", "大众"},
	{"dazi", "打字"},
	{"dbc", "代办处"},
	{"dbcs", "得不偿失"},
	{"dbf", "大部分"},
	{"dbgh", "电报挂号"},
	{"dbl", "大不了"},
	{"dblx", "大步流星"},
	{"dbq", "对不起"},
	{"dbt", "代表团"},
	{"dbx", "电冰箱"},
	{"dcwz", "到此为止"},
	{"dcx", "独创性"},
	{"dcyj", "调查研究"},
	{"dcyp", "打成一片"},
	{"ddh", "打电话"},
	{"ddj", "电动机"},
	{"ddq", "对得起"},
	{"ddqf", "跌宕起伏"},
	{"dds", "大多数"},
	{"decheng", "得逞"},
	{"dedang", "的当 得当"},
	{"dedao", "得到"},
	{"defen", "得分"},
	{"deguo", "德国"},
	{"dehua", "的话"},
	{"dejiang", "得奖"},
	{"dejiu", "得救"},
	{"dele", "得了"},
	{"deli", "得力"},
	{"dengchang", "登场"},
	{"dengdai", "等待"},
	{"dengdao", "等到"},
	{"dengguang", "灯光"},
	{"denghou", "等候"},
	{"dengji", "等级 登记"},
	{"dengjia", "等价"},
	{"dengju", "灯具"},
	{"dengmen", "登门"},
	{"dengmi", "灯谜"},
	{"dengpan", "登攀"},
	{"dengshan", "登山"},
	{"dengta", "灯塔"},
	{"dengtai", "登台"},
	{"dengtong", "等同"},
	{"dengxian", "等闲"},
	{"dengyu", "等于"},
	{"dengzai", "登载"},
	{"desheng", "得胜"},
	{"deshi", "得失"},
	{"deti", "得体"},
	{"dexing", "德行"},
	{"deyi", "得以 得意"},
	{"deyu", "德育"},
	{"dezhi", "得知 得志"},
	{"dezui", "得罪"},
	{"dfd", "大幅度"},
	{"dfm", "多方面 单方面"},
	{"dfs", "电风扇"},
	{"dgm", "大规模"},
	{"dgn", "多功能"},
	{"dgws", "大公无私"},
	{"dgzy", "帝国主义"},
	{"dhhm", "电话号码"},
	{"dhjy", "电化教育"},
	{"dht", "大会堂"},
	{"dianbao", "电报"},
	{"dianbo", "点播"},
	{"dianchang", "电场"},
	{"dianche", "电车"},
	{"dianchi", "电池"},
	{"dianchuan", "电传"},
	{"diandao", "颠倒"},
	{"diandeng", "电灯"},
	{"diandi", "点滴"},
	{"dianding", "奠定"},
	{"diandong", "电动"},
	{"dianfan", "典范"},
	{"dianfen", "淀粉"},
	{"dianfu", "垫付 颠覆"},
	{"diangan", "电感"},
	{"diangu", "典故"},
	{"dianhe", "电荷"},
	{"dianhu", "电弧"},
	{"dianhua", "电话"},
	{"dianhui", "电汇"},
	{"dianji", "电机 电极 奠基 惦记 典籍"},
	{"dianjiang", "点将"},
	{"dianjie", "电解"},
	{"dianjun", "殿军"},
	{"diankuang", "癫狂"},
	{"dianlan", "电缆"},
	{"dianli", "电力 电离 典礼"},
	{"dianliu", "电流"},
	{"dianlu", "电路"},
	{"diannao", "电脑"},
	{"dianneng", "电能"},
	{"dianpu", "店铺"},
	{"dianqi", "电气 电器"},
	{"dianran", "点燃"},
	{"dianrong", "电容"},
	{"dianshan", "电扇"},
	{"dianshi", "电视"},
	{"diantai", "电台"},
	{"dianti", "电梯"},
	{"diantou", "点头"},
	{"dianwang", "电网"},
	{"dianwei", "电位"},
	{"dianwu", "玷污"},
	{"dianxia", "殿下"},
	{"dianxian", "电线 癫痫"},
	{"dianxin", "电信"},
	{"dianxing", "典型"},
	{"dianxun", "电讯"},
	{"dianya", "电压"},
	{"dianying", "电影"},
	{"dianyuan", "店员"},
	{"dianzhen", "点阵"},
	{"dianzhui", "点缀"},
	{"dianzi", "电子 点子"},
	{"dianzu", "电阻"},
	{"diaobao", "碉堡"},
	{"diaobi", "凋敝"},
	{"diaocha", "调查"},
	{"diaoche", "吊车"},
	{"diaodong", "调动"},
	{"diaodu", "调度"},
	{"diaoer", "钓饵"},
	{"diaohuan", "调换 吊环 掉换"},
	{"diaoke", "雕刻"},
	{"diaoling", "凋零 调令"},
	{"diaoluo", "凋落 掉落"},
	{"diaonan", "刁难"},
	{"diaoqian", "调遣"},
	{"diaoren", "调任"},
	{"diaosu", "雕塑"},
	{"diaoxie", "凋谢"},
	{"diaoyan", "吊唁"},
	{"diaoyong", "调用"},
	{"diaoyu", "钓鱼"},
	{"diaozi", "调子"},
	{"diba", "第八"},
	{"diban", "地板"},
	{"dibu", "地步"},
	{"dichen", "低沉"},
	{"dichu", "抵触"},
	{"dida", "抵达"},
	{"didai", "地带"},
	{"didang", "低档 抵挡"},
	{"didao", "地道"},
	{"didi", "弟弟"},
	{"didian", "地点"},
	{"diduan", "地段"},
	{"didui", "敌对"},
	{"diedang", "跌宕"},
	{"diejiao", "跌跤"},
	{"dieqi", "迭起"},
	{"dier", "第二"},
	{"diexue", "喋血"},
	{"difang", "地方"},
	{"digu", "低估"},
	{"diguo", "敌国 帝国"},
	{"dihou", "敌后"},
	{"dihui", "诋毁 低回"},
	{"diji", "低级"},
	{"dijia", "递加"},
	{"dijian", "递减"},
	{"dijiao", "地窖 递交 缔交"},
	{"dijie", "缔结"},
	{"dijiu", "第九"},
	{"dijun", "敌军"},
	{"dikang", "抵抗"},
	{"dilao", "地牢"},
	{"dili", "地理"},
	{"dilie", "低劣"},
	{"diliu", "第六"},
	{"diluo", "低落"},
	{"dimao", "地貌"},
	{"dimian", "地面"},
	{"diming", "抵命"},
	{"dingan", "定案"},
	{"dingchan", "定产"},
	{"dingdan", "订单"},
	{"dingdang", "叮当"},
	{"dingdian", "顶点"},
	{"dingduo", "定夺"},
	{"dinge", "定额"},
	{"dingfeng", "顶峰 顶锋"},
	{"dinggou", "定购 订购"},
	{"dinghu", "订户"},
	{"dinghun", "订婚"},
	{"dinghuo", "订货"},
	{"dingjia", "定价"},
	{"dingju", "定局 定居"},
	{"dingli", "定理 订立 鼎立"},
	{"dingliang", "定量"},
	{"dinglv", "定律"},
	{"dingning", "叮咛"},
	{"dingqi", "定期"},
	{"dingran", "定然"},
	{"dingshao", "盯梢"},
	{"dingshi", "定时"},
	{"dingti", "顶替"},
	{"dingxing", "定性 定型"},
	{"dingyi", "定义"},
	{"dingyu", "定语"},
	{"dingyuan", "定员"},
	{"dingyue", "订阅"},
	{"dingzheng", "订正"},
	{"dingzhu", "叮嘱"},
	{"dingzhuang", "顶撞"},
	{"dingzi", "钉子"},
	{"dipai", "嫡派"},
	{"dipan", "地盘"},
	{"diqi", "第七"},
	{"diqin", "嫡亲"},
	{"diqing", "敌情"},
	{"diqiu", "地球"},
	{"diqu", "地区"},
	{"dique", "的确"},
	{"diren", "敌人"},
	{"disan", "第三"},
	{"dishi", "地势 第十"},
	{"dishui", "滴水"},
	{"disi", "第四"},
	{"ditie", "地铁"},
	{"ditu", "地图"},
	{"diudiao", "丢掉"},
	{"diulian", "丢脸"},
	{"diushi", "丢失"},
	{"diwei", "地位 敌伪"},
	{"diwu", "第五"},
	{"dixi", "底细 嫡系"},
	{"dixia", "地下 低下 底下"},
	{"dixing", "地形"},
	{"dixiong", "弟兄"},
	{"diyi", "第一 敌意"},
	{"diyu", "地域 抵御"},
	{"dizao", "缔造"},
	{"dizeng", "递增"},
	{"dizhen", "地震 敌阵"},
	{"dizhi", "地址 抵制 地质"},
	{"dizi", "底子 弟子"},
	{"djgf", "党纪国法"},
	{"djld", "当机立断"},
	{"djx", "独角戏"},
	{"dldd", "多劳多得"},
	{"dlfz", "大力发展"},
	{"dljq", "大力加强"},
	{"dlkz", "大力开展"},
	{"dlzz", "独立自主"},
	{"dms", "多面手"},
	{"dngh", "对内搞活"},
	{"dnl", "多年来"},
	{"dny", "东南亚"},
	{"dongbei", "东北"},
	{"dongbian", "东边"},
	{"dongbu", "东部"},
	{"dongcha", "洞察"},
	{"dongci", "动词"},
	{"dongdang", "动荡"},
	{"dongde", "懂得"},
	{"dongfang", "东方"},
	{"dongfeng", "东风"},
	{"donggong", "动工"},
	{"donghai", "东海"},
	{"donghe", "恫吓"},
	{"dongji", "动机 冬季"},
	{"dongjia", "东家"},
	{"dongjie", "冻结"},
	{"dongjing", "动静 东京"},
	{"dongli", "动力"},
	{"dongliang", "动量 栋梁"},
	{"dongluan", "动乱"},
	{"dongmai", "动脉"},
	{"dongnan", "东南"},
	{"dongou", "东欧"},
	{"dongren", "动人"},
	{"dongshen", "动身"},
	{"dongshi", "董事"},
	{"dongshou", "动手"},
	{"dongtai", "动态"},
	{"dongtian", "冬天"},
	{"dongting", "动听"},
	{"dongwu", "动物"},
	{"dongxi", "东西 洞悉"},
	{"dongxiang", "动向"},
	{"dongxin", "动心"},
	{"dongya", "东亚"},
	{"dongyang", "东洋"},
	{"dongyao", "动摇"},
	{"dongyong", "动用"},
	{"dongyuan", "动员"},
	{"dongzhe", "动辄"},
	{"dongzuo", "动作"},
	{"doufeng", "兜风"},
	{"dougong", "斗拱"},
	{"douhao", "逗号"},
	{"douliu", "逗留"},
	{"douqu", "逗趣"},
	{"doushi", "都是"},
	{"doushou", "兜售"},
	{"douzheng", "斗争"},
	{"douzhi", "斗志 斗智"},
	{"dpx", "地平线"},
	{"dscy", "第三产业"},
	{"dsj", "电视机"},
	{"dsn", "多少年"},
	{"dssw", "大失所望"},
	{"dst", "电视台"},
	{"dsxs", "低三下四"},
	{"dtb", "大踏步"},
	{"dtl", "到头来"},
	{"dts", "大体上"},
	{"dtxy", "大同小异"},
	{"duanbo", "短波"},
	{"duanchu", "短处"},
	{"duancu", "短促"},
	{"duanding", "断定"},
	{"duanduan", "短短"},
	{"duanjiao", "断交"},
	{"duanjue", "断绝"},
	{"duanlian", "锻炼"},
	{"duanlu", "短路"},
	{"duanluo", "段落"},
	{"duanping", "短评"},
	{"duanqi", "短期"},
	{"duanque", "短缺"},
	{"duanran", "断然"},
	{"duanshao", "煅烧"},
	{"duansong", "断送"},
	{"duantu", "短途"},
	{"duanwu", "端午"},
	{"duanxiang", "端详"},
	{"duanxiao", "短小"},
	{"duanyan", "断言"},
	{"duanyang", "端阳"},
	{"duanyu", "短语"},
	{"duanzan", "短暂"},
	{"duanzheng", "端正"},
	{"duanzhuang", "端庄"},
	{"dubao", "读报"},
	{"duben", "读本"},
	{"dubo", "赌博"},
	{"ducai", "独裁"},
	{"ducao", "毒草"},
	{"duchang", "独唱"},
	{"duchuang", "独创"},
	{"ducu", "督促"},
	{"duda", "毒打"},
	{"dudao", "独到"},
	{"duguo", "度过"},
	{"duhai", "毒害"},
	{"duhua", "毒化"},
	{"duhui", "都会"},
	{"duibi", "对比"},
	{"duibu", "队部"},
	{"duice", "对策"},
	{"duichen", "对称"},
	{"duici", "对此"},
	{"duidai", "对待"},
	{"duideng", "对等"},
	{"duidiao", "对调"},
	{"duifang", "对方"},
	{"duifu", "对付"},
	{"duihua", "对话"},
	{"duihuan", "兑换"},
	{"duijiang", "对讲"},
	{"duikang", "对抗"},
	{"duikou", "对口"},
	{"duilei", "对垒"},
	{"duili", "对立"},
	{"duilian", "对联"},
	{"duilie", "队列"},
	{"duiliu", "对流"},
	{"duimian", "对面"},
	{"duinei", "对内"},
	{"duiou", "对偶"},
	{"duishou", "对手"},
	{"duishu", "对数"},
	{"duiwai", "对外"},
	{"duiwu", "队伍"},
	{"duixian", "兑现"},
	{"duixiang", "对象"},
	{"duiying", "对应"},
	{"duiyu", "对于"},
	{"duiyuan", "队员"},
	{"duizhan", "堆栈"},
	{"duizhang", "队长"},
	{"duizhao", "对照"},
	{"duizheng", "对证"},
	{"duizhi", "对质 对峙"},
	{"duizhun", "对准"},
	{"dujin", "镀金"},
	{"dujue", "杜绝"},
	{"dukou", "渡口"},
	{"duli", "独立"},
	{"duliang", "度量"},
	{"dundian", "蹲点"},
	{"dunhao", "顿号"},
	{"dunji", "遁迹"},
	{"dunjiao", "钝角"},
	{"dunshi", "顿时 敦实"},
	{"duoban", "多半"},
	{"duobi", "躲避"},
	{"duobian", "多变 多边"},
	{"duocang", "躲藏"},
	{"duoci", "多次"},
	{"duode", "夺得"},
	{"duoduan", "多端"},
	{"duofang", "多方"},
	{"duokai", "躲开"},
	{"duokui", "多亏 夺魁"},
	{"duoluo", "堕落"},
	{"duolv", "多虑"},
	{"duome", "多么"},
	{"duomu", "夺目"},
	{"duonian", "多年"},
	{"duoqing", "多情"},
	{"duoqu", "夺取"},
	{"duoshao", "多少"},
	{"duoshi", "多事 掇拾"},
	{"duoshou", "舵手"},
	{"duoshu", "多数"},
	{"duoxie", "多谢"},
	{"duoxin", "多心"},
	{"duoxing", "惰性"},
	{"duoyang", "多样"},
	{"duoyu", "多余"},
	{"duozhong", "多种"},
	{"dupi", "肚皮"},
	{"dupin", "毒品"},
	{"duqi", "毒气"},
	{"duqu", "读取"},
	{"duri", "度日"},
	{"duru", "读入"},
	{"duse", "堵塞"},
	{"dushe", "毒蛇"},
	{"dushi", "都市"},
	{"dushou", "毒手"},
	{"dushu", "读数 读书"},
	{"dusu", "毒素"},
	{"dute", "独特"},
	{"duwu", "读物"},
	{"duyao", "毒药"},
	{"duzhan", "独占"},
	{"duzhe", "读者"},
	{"duzhi", "毒汁 渎职"},
	{"duzhu", "赌注"},
	{"duzhuan", "杜撰"},
	{"duzi", "独自"},
	{"dwh", "党委会"},
	{"dwkf", "对外开放"},
	{"dwmd", "敌我矛盾"},
	{"dwmy", "对外贸易"},
	{"dww", "大无畏"},
	{"dwy", "动物园"},
	{"dwzj", "当务之急"},
	{"dxp", "邓小平"},
	{"dxs", "大学生"},
	{"dxss", "大显身手"},
	{"dxy", "大西洋"},
	{"dyj", "打印机 大跃进"},
	{"dykw", "大有可为"},
	{"dyqn", "待业青年"},
	{"dyqx", "掉以轻心"},
	{"dyy", "电影院"},
	{"dyz", "大洋洲"},
	{"dyzw", "大有作为"},
	{"dzb", "党支部"},
	{"dzdy", "多种多样"},
	{"dzjg", "党政机关"},
	{"dzjj", "电子计算机"},
	{"dzjy", "多种经营"},
	{"dzqy", "断章取义"},
	{"dzr", "大自然"},
	{"dzt", "德智体"},
	{"dzx", "电子学"},
	{"dzxj", "电子显微镜"},
	{"dzy", "党中央"},
	{"eba", "恶霸"},
	{"edu", "恶毒"},
	{"egan", "恶感"},
	{"egun", "恶棍"},
	{"ehao", "噩耗"},
	{"ehua", "恶化"},
	{"ejg", "二极管"},
	{"ejz", "二进制"},
	{"elie", "恶劣"},
	{"emao", "鹅毛"},
	{"emeng", "噩梦"},
	{"emo", "恶魔"},
	{"emyx", "耳目一新"},
	{"enai", "恩爱"},
	{"enci", "恩赐"},
	{"endian", "恩典"},
	{"enhui", "恩惠"},
	{"enqing", "恩情"},
	{"erduo", "耳朵"},
	{"erge", "儿歌"},
	{"erguang", "耳光"},
	{"erhou", "而后 尔后"},
	{"erhuang", "二黄 二簧"},
	{"erjie", "二届"},
	{"erjin", "而今"},
	{"erkuang", "而况"},
	{"erqie", "而且"},
	{"ershi", "而是"},
	{"ertong", "儿童"},
	{"erxi", "儿戏"},
	{"erxin", "二心"},
	{"eryi", "而已"},
	{"eryu", "耳语"},
	{"eryue", "二月"},
	{"erzi", "儿子"},
	{"esha", "扼杀"},
	{"ewai", "额外"},
	{"ewan", "扼腕"},
	{"ewfd", "额外负担"},
	{"exi", "恶习"},
	{"exin", "恶心"},
	{"exing", "恶性"},
	{"exxh", "恶性循环"},
	{"eyao", "扼要"},
	{"eyun", "厄运"},
	{"ezha", "讹诈"},
	{"ezhi", "遏止"},
	{"fabao", "发报 法宝"},
	{"fabiao", "发表"},
	{"fabu", "发布"},
	{"facai", "发财"},
	{"fachou", "发愁"},
	{"fachu", "发出"},
	{"fada", "发达"},
	{"fadian", "发电 法典"},
	{"fading", "法定"},
	{"fadong", "发动"},
	{"fafang", "发放"},
	{"fafen", "发奋"},
	{"fafu", "发付"},
	{"faguan", "法官"},
	{"fagui", "法规"},
	{"faguo", "法国"},
	{"fahuang", "发慌"},
	{"fahui", "发挥"},
	{"fahuo", "发火"},
	{"faji", "发迹 法纪"},
	{"fajia", "发家"},
	{"fajiang", "发奖"},
	{"fajiao", "发酵"},
	{"fajin", "罚金"},
	{"fajue", "发觉 发掘"},
	{"fakuan", "罚款"},
	{"fakuang", "发狂"},
	{"falang", "法郎"},
	{"faling", "法令"},
	{"falv", "法律"},
	{"faluo", "发落"},
	{"faming", "发明"},
	{"fa'nan", "发难"},
	{"fanban", "翻版"},
	{"fanbi", "反比"},
	{"fanbo", "反驳"},
	{"fanbu", "帆布"},
	{"fanchang", "反常"},
	{"fanchou", "范畴 犯愁"},
	{"fanchuan", "帆船"},
	{"fandian", "饭店"},
	{"fandong", "反动 翻动"},
	{"fandui", "反对"},
	{"fanduo", "繁多"},
	{"faner", "反而"},
	{"fanfu", "反复"},
	{"fan'gan", "反感"},
	{"fangai", "妨碍"},
	{"fangan", "方案"},
	{"fangbei", "防备"},
	{"fangbian", "方便"},
	{"fangchao", "防潮"},
	{"fangcheng", "方程"},
	{"fangda", "放大"},
	{"fangdang", "放荡"},
	{"fangdao", "防盗"},
	{"fangfa", "方法"},
	{"fangfan", "防范"},
	{"fangfeng", "防风"},
	{"fangfu", "仿佛 防腐"},
	{"fanghai", "妨害"},
	{"fanghu", "防护"},
	{"fanghuo", "防火"},
	{"fangjia", "放假"},
	{"fangjian", "房间"},
	{"fangmian", "方面"},
	{"fangmu", "放牧"},
	{"fangong", "返工 反攻"},
	{"fangpi", "放屁"},
	{"fangqi", "放弃"},
	{"fangqu", "防区"},
	{"fangren", "放任"},
	{"fangshao", "放哨"},
	{"fangshe", "放射"},
	{"fangshi", "方式"},
	{"fangshou", "防守"},
	{"fangsi", "放肆"},
	{"fangsong", "放松 仿宋"},
	{"fangun", "翻滚"},
	{"fangwei", "方位 防卫"},
	{"fangwen", "访问"},
	{"fangwu", "房屋"},
	{"fangxia", "放下"},
	{"fangxian", "防线"},
	{"fangxiang", "方向 芳香"},
	{"fangxiao", "仿效"},
	{"fangxin", "放心"},
	{"fangxing", "放行"},
	{"fangyan", "方言"},
	{"fangyi", "防疫"},
	{"fangyu", "防御"},
	{"fangzao", "仿造"},
	{"fangzhao", "仿照"},
	{"fangzhen", "方针 仿真"},
	{"fangzhi", "防治 仿制 放置 防止 纺织"},
	{"fangzi", "房子"},
	{"fangzong", "放纵"},
	{"fangzu", "房租"},
	{"fanhao", "番号"},
	{"fanhua", "繁华"},
	{"fanhui", "反悔 返回"},
	{"fanji", "反击"},
	{"fankang", "反抗"},
	{"fankui", "反馈"},
	{"fanlan", "泛滥"},
	{"fanli", "范例 凡例"},
	{"fanlian", "翻脸"},
	{"fanmai", "贩卖"},
	{"fanmang", "繁忙"},
	{"fanmen", "烦闷"},
	{"fanmian", "反面"},
	{"fanmu", "反目"},
	{"fannao", "烦恼"},
	{"fanpan", "反叛"},
	{"fanqie", "番茄"},
	{"fanren", "犯人"},
	{"fanrong", "繁荣"},
	{"fanshe", "反射"},
	{"fanshen", "翻身"},
	{"fansheng", "繁盛"},
	{"fanshi", "凡是 凡事"},
	{"fansuo", "繁琐 烦琐"},
	{"fanteng", "翻腾"},
	{"fanti", "繁体"},
	{"fantong", "饭桶"},
	{"fanu", "发怒"},
	{"fanwan", "饭碗"},
	{"fanwei", "范围"},
	{"fanwen", "反问"},
	{"fanxiang", "反响"},
	{"fanxiao", "返销"},
	{"fanxing", "反省"},
	{"fanxiu", "翻修"},
	{"fanyan", "繁衍"},
	{"fanyi", "翻译"},
	{"fanyin", "翻印"},
	{"fanying", "反应 反映"},
	{"fanyu", "繁育"},
	{"fanyue", "翻越 翻阅"},
	{"fanyun", "贩运"},
	{"fanza", "繁杂"},
	{"fanzao", "烦燥"},
	{"fanzheng", "反正"},
	{"fanzhi", "反之 繁殖"},
	{"fanzhong", "繁重"},
	{"fanzi", "贩子"},
	{"fanzui", "犯罪"},
	{"fapei", "发配"},
	{"faqi", "发起"},
	{"faquan", "法权"},
	{"fashe", "发射"},
	{"fasheng", "发生"},
	{"fashi", "发誓"},
	{"fashou", "发售"},
	{"fating", "法庭"},
	{"faxian", "发现"},
	{"faxie", "发泄"},
	{"faxing", "发行"},
	{"fayan", "发言"},
	{"fayang", "发扬"},
	{"fayi", "法医"},
	{"fayu", "发育"},
	{"fayuan", "发源 法院"},
	{"faze", "法则"},
	{"fazhan", "发展"},
	{"fazhi", "法制 法治"},
	{"fazuo", "发作"},
	{"fbgs", "奋不顾身"},
	{"fblx", "分崩离析"},
	{"fcp", "副产品"},
	{"fdj", "发电机 发动机"},
	{"fdp", "反动派"},
	{"fdyb", "分道扬镳"},
	{"feibang", "诽谤 匪帮"},
	{"feiben", "飞奔"},
	{"feichang", "非常"},
	{"feichi", "飞驰"},
	{"feichu", "废除"},
	{"feidan", "非但"},
	{"feidei", "非得"},
	{"feidian", "沸点"},
	{"feifa", "非法"},
	{"feifan", "非凡"},
	{"feifu", "肺腑"},
	{"feihong", "绯红"},
	{"feihua", "废话"},
	{"feiji", "飞机"},
	{"feijian", "飞溅"},
	{"feijie", "费解"},
	{"feijin", "费劲"},
	{"feikuai", "飞快"},
	{"feili", "费力"},
	{"feiliao", "肥料 废料"},
	{"feipang", "肥胖"},
	{"feipin", "废品"},
	{"feiqi", "废弃"},
	{"feishen", "费神"},
	{"feishui", "废水"},
	{"feisu", "飞速"},
	{"feiteng", "沸腾"},
	{"feitu", "匪徒"},
	{"feiwo", "肥沃"},
	{"feiwu", "废物 飞舞"},
	{"feixiang", "飞翔"},
	{"feixin", "费心"},
	{"feixing", "飞行"},
	{"feixu", "废墟"},
	{"feiyang", "飞扬"},
	{"feiye", "扉页"},
	{"feiyi", "非议"},
	{"feiyong", "费用"},
	{"feiyue", "飞跃"},
	{"feizao", "肥皂"},
	{"feizhang", "飞涨"},
	{"feizhi", "废止"},
	{"feizhou", "非洲"},
	{"feizi", "妃子"},
	{"fenbei", "分贝"},
	{"fenbian", "分辩 分辨 粪便"},
	{"fenbie", "分别"},
	{"fenbu", "分布 分部"},
	{"fence", "分册"},
	{"fencun", "分寸"},
	{"fendan", "分担"},
	{"fende", "分得"},
	{"fendian", "分店"},
	{"fendou", "奋斗"},
	{"fendui", "分队"},
	{"fenfa", "分发 奋发"},
	{"fenfen", "纷纷 愤愤 忿忿"},
	{"fenfu", "吩咐"},
	{"fengbao", "风暴"},
	{"fengbei", "丰碑"},
	{"fengbi", "封闭"},
	{"fengbo", "风波"},
	{"fengchan", "丰产"},
	{"fengcheng", "奉承"},
	{"fengci", "讽刺"},
	{"fengcun", "封存"},
	{"fengdian", "疯癫"},
	{"fengdu", "风度"},
	{"fenge", "分割 分隔"},
	{"fengfa", "风发"},
	{"fengfan", "风帆"},
	{"fengfu", "丰富"},
	{"fenggao", "奉告"},
	{"fengge", "风格"},
	{"fenggong", "奉公"},
	{"fengguang", "风光"},
	{"fenghan", "风寒"},
	{"fenghua", "风化 风华"},
	{"fenghuan", "奉还"},
	{"fenghuang", "凤凰"},
	{"fenghuo", "烽火"},
	{"fengjian", "封建"},
	{"fengjing", "风景"},
	{"fengkuang", "疯狂"},
	{"fenglang", "风浪"},
	{"fengli", "风力"},
	{"fengliu", "风流"},
	{"fengman", "丰满"},
	{"fengmang", "锋芒"},
	{"fengmao", "风貌"},
	{"fengming", "奉命"},
	{"fengnian", "丰年"},
	{"fengong", "分工"},
	{"fengpei", "奉陪"},
	{"fengqi", "风气"},
	{"fengqing", "风情"},
	{"fengqu", "风趣"},
	{"fengquan", "奉劝"},
	{"fengren", "缝纫"},
	{"fengsao", "风骚"},
	{"fengsha", "风沙"},
	{"fengshang", "风尚"},
	{"fengsheng", "风声 丰盛"},
	{"fengshou", "丰收"},
	{"fengshuang", "风霜"},
	{"fengshui", "风水"},
	{"fengshuo", "丰硕"},
	{"fengsi", "奉祀"},
	{"fengsu", "风俗"},
	{"fengsuo", "封锁"},
	{"fengtan", "风瘫 疯瘫"},
	{"fengtiao", "封条"},
	{"fengtou", "风头"},
	{"fenguan", "分管"},
	{"fengwei", "风味"},
	{"fengxi", "缝隙"},
	{"fengxian", "风险 奉献"},
	{"fengxiang", "风向"},
	{"fengxing", "风行 奉行"},
	{"fengyong", "蜂拥"},
	{"fengyun", "风云 风韵"},
	{"fengzai", "风灾"},
	{"fengzi", "疯子 风姿"},
	{"fenhao", "分号 分毫"},
	{"fenhong", "分红 粉红"},
	{"fenhua", "分化"},
	{"fenhui", "分会 焚毁"},
	{"fenji", "分级"},
	{"fenjie", "分解 分界"},
	{"fenjin", "奋进"},
	{"fenju", "分居"},
	{"fenkai", "分开 愤慨"},
	{"fenlei", "分类"},
	{"fenli", "分离 奋力"},
	{"fenliang", "分量"},
	{"fenlie", "分裂"},
	{"fenluan", "纷乱"},
	{"fenmian", "分娩"},
	{"fenmiao", "分秒"},
	{"fenming", "分明"},
	{"fenmo", "粉末"},
	{"fenmu", "坟墓"},
	{"fennei", "分内"},
	{"fennu", "愤怒"},
	{"fenpai", "分派"},
	{"fenpei", "分配"},
	{"fenpi", "分批"},
	{"fenqi", "分期 分歧 奋起"},
	{"fenqing", "分清"},
	{"fenqu", "分区"},
	{"fensan", "分散"},
	{"fenshao", "焚烧"},
	{"fenshu", "分数"},
	{"fenshuo", "分说"},
	{"fensui", "粉碎"},
	{"fentan", "分摊"},
	{"fentu", "粪土"},
	{"fenwai", "分外"},
	{"fenwei", "氛围"},
	{"fenxi", "分析"},
	{"fenyong", "奋勇"},
	{"fenzang", "分赃"},
	{"fenzhan", "奋战"},
	{"fenzhi", "分支"},
	{"fenzi", "分子"},
	{"fenzu", "分组"},
	{"ffdc", "丰富多彩"},
	{"fftq", "奋发图强"},
	{"fgls", "反过来说"},
	{"fgm", "反革命"},
	{"fhsl", "发号施令"},
	{"fhzm", "风华正茂"},
	{"fjs", "福建省"},
	{"fjsh", "封建社会"},
	{"fjzd", "封建制度"},
	{"fjzy", "封建主义"},
	{"flfq", "翻来覆去"},
	{"flgw", "法律顾问"},
	{"fmbz", "分秒必争"},
	{"fmcz", "发明创造"},
	{"fojiao", "佛教"},
	{"fouding", "否定"},
	{"foujue", "否决"},
	{"fouren", "否认"},
	{"fouze", "否则"},
	{"fpl", "废品率"},
	{"fqws", "废寝忘食"},
	{"frj", "缝纫机"},
	{"frsx", "发人深省"},
	{"fsl", "分水岭"},
	{"ftfd", "翻天复地"},
	{"ftxk", "非同小可"},
	{"ftz", "繁体字"},
	{"fubai", "腐败"},
	{"fubi", "复辟"},
	{"fucha", "复查"},
	{"fuchen", "浮沉"},
	{"fuchi", "扶持"},
	{"fuchu", "付出"},
	{"fuci", "副词"},
	{"fucong", "服从"},
	{"fudai", "附带"},
	{"fudan", "负担"},
	{"fudao", "辅导"},
	{"fudiao", "浮雕"},
	{"fudong", "浮动"},
	{"fudu", "幅度"},
	{"fufa", "复发 伏法"},
	{"fufu", "夫妇"},
	{"fugai", "覆盖"},
	{"fugao", "讣告"},
	{"fugui", "富贵"},
	{"fuhao", "符号"},
	{"fuhe", "附和 符合 负荷"},
	{"fuhua", "腐化 浮华"},
	{"fuhui", "附会"},
	{"fuhuo", "复活 俘获"},
	{"fuji", "伏击"},
	{"fujia", "附加"},
	{"fujian", "附件 福建"},
	{"fujin", "附近"},
	{"fukan", "副刊 俯瞰"},
	{"fukua", "浮夸"},
	{"fukuan", "付款"},
	{"fulan", "腐烂"},
	{"fuli", "福利 浮力 富丽"},
	{"fulian", "妇联"},
	{"fulu", "附录 俘虏"},
	{"fumie", "覆灭"},
	{"fumo", "覆没"},
	{"fumu", "父母"},
	{"funong", "富农"},
	{"funv", "妇女"},
	{"fupin", "扶贫"},
	{"fuqi", "服气 福气 夫妻 付讫"},
	{"fuqian", "肤浅"},
	{"fuqiang", "富强"},
	{"fuqin", "父亲"},
	{"furao", "富饶"},
	{"furen", "夫人 妇人"},
	{"furong", "芙蓉"},
	{"furu", "妇孺"},
	{"fushang", "负伤"},
	{"fushe", "辐射"},
	{"fushi", "复试 腐蚀 俯视 服饰 服侍"},
	{"fushou", "副手"},
	{"fushu", "复数 负数 附属 富庶 服输"},
	{"fushui", "赋税"},
	{"fute", "伏特"},
	{"fuwang", "覆亡"},
	{"fuweng", "富翁"},
	{"fuwu", "服务"},
	{"fuxi", "复习"},
	{"fuxian", "浮现 赋闲"},
	{"fuxiang", "浮想"},
	{"fuxin", "复信"},
	{"fuxiu", "腐朽"},
	{"fuxu", "抚恤"},
	{"fuyan", "敷衍"},
	{"fuyang", "扶养 抚养 俯仰"},
	{"fuye", "副业"},
	{"fuyi", "服役"},
	{"fuyin", "复印"},
	{"fuyou", "富有 赋有"},
	{"fuyu", "赋于 抚育 富裕 赋予"},
	{"fuyuan", "复员 复原"},
	{"fuyue", "负约"},
	{"fuza", "复杂"},
	{"fuzai", "负载"},
	{"fuze", "附则 负责"},
	{"fuzhai", "负债"},
	{"fuzhang", "付帐"},
	{"fuzhe", "覆辙"},
	{"fuzhi", "复制 扶植"},
	{"fuzhong", "附中"},
	{"fuzhou", "福州 抚州"},
	{"fuzhu", "附注 辅助 扶助"},
	{"fuzhuang", "服装"},
	{"fuzhuo", "附着"},
	{"fuzu", "富足"},
	{"fuzui", "服罪"},
	{"fuzuo", "辅佐"},
	{"fwb", "服务部"},
	{"fwtd", "服务态度"},
	{"fwy", "服务员"},
	{"fxwa", "方兴未艾"},
	{"fydx", "奋勇当先"},
	{"fyf", "翻一番"},
	{"fyfy", "风言风语"},
	{"fygd", "发扬光大"},
	{"fyj", "复印机"},
	{"fyr", "发言人"},
	{"fytz", "风雨同舟"},
	{"fywk", "负隅顽抗"},
	{"fzf", "房租费"},
	{"fzl", "副总理"},
	{"fzp", "纺织品"},
	{"fzs", "福州市"},
	{"fzy", "反作用 副作用"},
	{"fzz", "负责制"},
	{"fzzj", "发展中国家"},
	{"gab", "公安部"},
	{"gaibian", "改变 改编"},
	{"gaidang", "该当"},
	{"gaidao", "改道"},
	{"gaidong", "改动"},
	{"gaige", "改革"},
	{"gaiguan", "改观"},
	{"gaiguo", "改过"},
	{"gaihui", "改悔"},
	{"gaijian", "改建"},
	{"gaijin", "改进"},
	{"gaikuang", "概况"},
	{"gaikuo", "概括"},
	{"gailiang", "改良"},
	{"gailun", "概论"},
	{"gailv", "概率"},
	{"gaimao", "概貌"},
	{"gainian", "概念"},
	{"gaiqi", "改期"},
	{"gaishan", "改善"},
	{"gaishu", "概述"},
	{"gaitan", "概叹"},
	{"gaitian", "改天"},
	{"gaixuan", "改选"},
	{"gaiyao", "概要"},
	{"gaizao", "改造"},
	{"gaizheng", "改正"},
	{"gaizhuang", "改装"},
	{"gaizu", "改组"},
	{"gaj", "公安局"},
	{"ganbu", "干部"},
	{"ganchu", "感触"},
	{"gancui", "干脆"},
	{"gandang", "敢当 甘当"},
	{"gandao", "感到"},
	{"gandong", "感动"},
	{"ganen", "感恩"},
	{"ganga", "尴尬"},
	{"gangao", "港澳"},
	{"gangcai", "刚才 钢材"},
	{"ganggang", "刚刚"},
	{"ganghao", "刚好"},
	{"gangkou", "港口"},
	{"gangling", "纲领"},
	{"gangshao", "岗哨"},
	{"gangtie", "钢铁"},
	{"gangwan", "港湾"},
	{"gangwei", "岗位"},
	{"gangwu", "港务"},
	{"gangyao", "刚要 纲要"},
	{"gangyi", "刚毅"},
	{"ganhan", "干旱"},
	{"ganhua", "感化"},
	{"ganhuo", "干活 肝火"},
	{"ganji", "感激"},
	{"ganjin", "干劲 赶紧"},
	{"ganjing", "干净"},
	{"ganjue", "感觉"},
	{"gankai", "感慨"},
	{"ganku", "甘苦"},
	{"gankuai", "赶快"},
	{"ganma", "干嘛"},
	{"ganmang", "赶忙"},
	{"ganmao", "感冒"},
	{"ganqing", "感情"},
	{"ganran", "感染"},
	{"ganrao", "干扰"},
	{"ganshe", "干涉"},
	{"ganshi", "干事"},
	{"ganshou", "感受"},
	{"gansu", "甘肃"},
	{"gantan", "感叹"},
	{"ganxian", "干线"},
	{"ganxiang", "感想 敢想"},
	{"ganxie", "感谢"},
	{"ganxin", "甘心"},
	{"ganxing", "感性"},
	{"ganying", "感应"},
	{"ganyu", "敢于 干预"},
	{"ganyuan", "甘愿"},
	{"ganzao", "干燥"},
	{"ganzhao", "感召"},
	{"ganzhou", "赣州"},
	{"ganzuo", "敢做"},
	{"gaoai", "高矮"},
	{"gaoang", "高昂"},
	{"gaobie", "告别"},
	{"gaochan", "高产"},
	{"gaochao", "高超 高潮"},
	{"gaocheng", "告成"},
	{"gaoci", "告辞"},
	{"gaoda", "高大"},
	{"gaodang", "高档"},
	{"gaodeng", "高等"},
	{"gaodi", "高地 高低"},
	{"gaodian", "糕点"},
	{"gaodu", "高度"},
	{"gaofa", "告发"},
	{"gaofeng", "高峰"},
	{"gaogao", "高高"},
	{"gaoge", "高歌"},
	{"gaogui", "高贵"},
	{"gaohan", "高喊"},
	{"gaohao", "搞好"},
	{"gaohu", "高呼"},
	{"gaohuai", "搞坏"},
	{"gaoji", "高级 告急"},
	{"gaojia", "高价"},
	{"gaojian", "高见 稿件"},
	{"gaojie", "告捷 告诫"},
	{"gaoling", "高龄"},
	{"gaolou", "高楼"},
	{"gaomi", "告密"},
	{"gaoming", "高明"},
	{"gaoneng", "高能"},
	{"gaopan", "高攀"},
	{"gaopin", "高频"},
	{"gaoqiang", "高强"},
	{"gaoshan", "高山"},
	{"gaoshang", "高尚"},
	{"gaoshen", "高深"},
	{"gaoshi", "告示"},
	{"gaosong", "高耸"},
	{"gaosu", "高速 告诉"},
	{"gaowen", "高温"},
	{"gaoxiao", "高小 高校"},
	{"gaoxing", "高兴"},
	{"gaoyao", "膏药"},
	{"gaoyuan", "高原"},
	{"gaozhang", "高涨"},
	{"gaozhao", "高招"},
	{"gaozhong", "高中 告终"},
	{"gaozhuang", "告状"},
	{"gaozi", "稿子"},
	{"gatb", "港澳同胞"},
	{"gbd", "怪不得"},
	{"gbm", "各部门"},
	{"gbw", "各部委"},
	{"gbyq", "供不应求"},
	{"gbzf", "故步自封"},
	{"gcd", "共产党"},
	{"gcdy", "共产党员"},
	{"gcs", "工程师"},
	{"gcsb", "顾此失彼"},
	{"gczx", "贯彻执行"},
	{"gczy", "共产主义"},
	{"gdf", "各地方"},
	{"gdjq", "各大军区"},
	{"gds", "广东省"},
	{"gdsp", "高档商品"},
	{"gdw", "各单位"},
	{"gdyx", "高等院校"},
	{"gdzc", "固定资产"},
	{"gebi", "隔壁 戈壁"},
	{"gebie", "个别"},
	{"gechang", "歌唱"},
	{"gechu", "各处 革除"},
	{"geda", "疙瘩"},
	{"gede", "歌德"},
	{"gedi", "各地"},
	{"gediao", "格调"},
	{"geduan", "隔断"},
	{"gege", "个个 各个"},
	{"geguo", "各国"},
	{"gehe", "隔阂"},
	{"gehou", "歌喉"},
	{"gei", "给"},
	{"geji", "各级"},
	{"gejie", "各界"},
	{"geju", "格局 割据"},
	{"gejue", "隔绝"},
	{"gelei", "各类"},
	{"geli", "隔离"},
	{"gelie", "割裂"},
	{"gelv", "格律"},
	{"geming", "革命"},
	{"gemo", "隔膜"},
	{"genben", "根本"},
	{"genchu", "根除"},
	{"gendi", "根底"},
	{"gengdi", "耕地"},
	{"gengdie", "更迭"},
	{"gengdong", "更动"},
	{"gengduo", "更多"},
	{"genggai", "更改 梗概"},
	{"genggao", "更高"},
	{"genghuan", "更换"},
	{"gengjia", "更加"},
	{"gengwei", "更为"},
	{"gengxiang", "颈项"},
	{"gengxin", "更新"},
	{"gengyan", "哽咽"},
	{"gengyun", "耕耘"},
	{"gengzheng", "更正"},
	{"gengzhi", "耿直"},
	{"gengzhong", "耕种"},
	{"gengzu", "梗阻"},
	{"gengzuo", "耕作"},
	{"genji", "根基"},
	{"genju", "根据"},
	{"genqian", "跟前"},
	{"gensui", "跟随"},
	{"genyuan", "根源"},
	{"genzhi", "根治"},
	{"genzhuo", "跟着"},
	{"genzi", "根子"},
	{"genzong", "跟踪"},
	{"geqian", "搁浅"},
	{"gequ", "歌曲"},
	{"geren", "个人"},
	{"geshi", "格式"},
	{"gesong", "歌颂"},
	{"geti", "个体"},
	{"gewai", "格外"},
	{"gewei", "各位"},
	{"gewu", "歌舞"},
	{"gexia", "阁下"},
	{"gexiang", "各项"},
	{"gexin", "革新"},
	{"gexing", "个性"},
	{"geyan", "格言"},
	{"geyang", "各样"},
	{"geyong", "歌咏"},
	{"gezhi", "搁置"},
	{"gezhong", "各种"},
	{"gezu", "各族"},
	{"gfb", "国防部"},
	{"gfm", "各方面"},
	{"ggbr", "格格不入"},
	{"ggdd", "归根到底"},
	{"ggjd", "归根结底"},
	{"ggjj", "恭恭敬敬"},
	{"ggls", "滚瓜烂熟"},
	{"ghg", "共和国"},
	{"ghgy", "各行各业"},
	{"gjdw", "各级党委"},
	{"gjld", "各级领导"},
	{"gjly", "国家利益"},
	{"gjs", "工具书"},
	{"gkq", "国库券"},
	{"gkld", "孤苦伶仃"},
	{"gklh", "鬼哭狼嚎"},
	{"glgw", "孤陋寡闻"},
	{"gmd", "国民党"},
	{"gmh", "革命化"},
	{"gmj", "革命家"},
	{"gmjj", "国民经济"},
	{"gmll", "光明磊落"},
	{"gmrb", "光明日报"},
	{"gmsy", "顾名思义"},
	{"gmxk", "刮目相看"},
	{"gmzd", "光明正大"},
	{"gnb", "工农兵"},
	{"gnw", "国内外"},
	{"gny", "工农业"},
	{"gongan", "公安"},
	{"gongbao", "公报"},
	{"gongben", "工本"},
	{"gongbu", "公布"},
	{"gongcha", "公差"},
	{"gongchang", "工厂"},
	{"gongchen", "功臣"},
	{"gongcheng", "工程"},
	{"gongchu", "共处"},
	{"gongci", "供词"},
	{"gongcun", "共存"},
	{"gongdao", "公道"},
	{"gongde", "公德 功德"},
	{"gongdi", "工地 公敌"},
	{"gongdian", "宫殿"},
	{"gongdu", "攻读"},
	{"gongfei", "公费"},
	{"gongfen", "公愤"},
	{"gongfu", "工夫 功夫"},
	{"gonggao", "公告"},
	{"gonggong", "公共"},
	{"gonggu", "巩固"},
	{"gongguan", "公关"},
	{"gonghai", "公害"},
	{"gonghan", "公函"},
	{"gonghe", "共和"},
	{"gonghui", "工会"},
	{"gongji", "供给 共计 攻击 功绩"},
	{"gongjia", "公家"},
	{"gongjin", "公斤"},
	{"gongjing", "恭敬"},
	{"gongju", "工具"},
	{"gongkai", "公开"},
	{"gongke", "功课"},
	{"gongkuan", "公款"},
	{"gonglao", "功劳"},
	{"gongli", "公理 公里 公历"},
	{"gonglu", "公路"},
	{"gonglv", "功率"},
	{"gongmin", "公民"},
	{"gongming", "共鸣"},
	{"gongmu", "公墓"},
	{"gongneng", "功能"},
	{"gongnong", "工农"},
	{"gongping", "公平"},
	{"gongpu", "公仆"},
	{"gongqiu", "供求"},
	{"gongqu", "工区"},
	{"gongran", "公然"},
	{"gongren", "工人 公认 供认"},
	{"gongshang", "工伤"},
	{"gongshe", "公社"},
	{"gongshen", "公审"},
	{"gongshi", "工时 公事 共事 公式"},
	{"gongshu", "公署"},
	{"gongsi", "公司 公私"},
	{"gongsu", "公诉"},
	{"gongting", "宫廷"},
	{"gongtong", "共同"},
	{"gongwei", "恭维"},
	{"gongwen", "公文"},
	{"gongwu", "公物 公务"},
	{"gongxi", "恭喜"},
	{"gongxian", "贡献"},
	{"gongxiao", "工效 功效 供销"},
	{"gongxing", "共性"},
	{"gongxu", "工序 共需"},
	{"gongxun", "功勋"},
	{"gongyang", "供养"},
	{"gongye", "工业"},
	{"gongyi", "工艺"},
	{"gongying", "供应"},
	{"gongyong", "公用"},
	{"gongyou", "共有"},
	{"gongyuan", "公元 公园"},
	{"gongyue", "公约"},
	{"gongyun", "公允"},
	{"gongzhai", "公债"},
	{"gongzhang", "公章"},
	{"gongzhen", "共振"},
	{"gongzheng", "工整 公正 公证"},
	{"gongzhi", "供职"},
	{"gongzhong", "公众"},
	{"gongzi", "工资"},
	{"gongzuo", "工作"},
	{"goucheng", "构成"},
	{"gouda", "勾搭"},
	{"goudang", "勾当"},
	{"gouhe", "沟壑"},
	{"gouhua", "勾画"},
	{"goujian", "构件"},
	{"goujie", "勾结"},
	{"goulian", "勾连"},
	{"goumai", "购买"},
	{"gouqie", "苟且"},
	{"gousi", "构思"},
	{"goutong", "沟通"},
	{"gouxiao", "勾销 购销"},
	{"gouyin", "勾引"},
	{"gouzao", "构造"},
	{"gouzhi", "购置"},
	{"gouzi", "钩子"},
	{"gqj", "国庆节"},
	{"gqt", "共青团"},
	{"grb", "光荣榜"},
	{"gsgy", "各式各样"},
	{"gsrc", "骨瘦如柴"},
	{"gss", "甘肃省"},
	{"gsy", "工商业"},
	{"gth", "个体户"},
	{"gthm", "改头换面"},
	{"gtkl", "高谈阔论"},
	{"guafen", "瓜分"},
	{"guage", "瓜葛"},
	{"guahao", "挂号"},
	{"guaichuan", "乖舛"},
	{"guaili", "乖戾"},
	{"guaipi", "乖僻"},
	{"guaiqiao", "乖巧"},
	{"guaiwu", "怪物"},
	{"guaiyi", "怪异"},
	{"guaizhang", "拐杖"},
	{"guaming", "挂名"},
	{"guanbi", "关闭"},
	{"guance", "观测"},
	{"guancha", "观察"},
	{"guanche", "贯彻"},
	{"guanchuan", "贯穿"},
	{"guandao", "管道"},
	{"guandi", "官邸"},
	{"guandian", "观点"},
	{"guanfang", "官方"},
	{"guangai", "灌溉"},
	{"guangbiao", "光标"},
	{"guangbo", "广播 广博"},
	{"guangcai", "光彩"},
	{"guangchang", "广场"},
	{"guangda", "光大 广大"},
	{"guangdong", "广东"},
	{"guangdu", "广度"},
	{"guangfan", "广泛"},
	{"guanggao", "广告"},
	{"guanggu", "光顾"},
	{"guanghua", "光滑"},
	{"guanghui", "光辉"},
	{"guangjing", "光景"},
	{"guangkuo", "广阔"},
	{"guangmang", "光芒"},
	{"guangmao", "广袤"},
	{"guangming", "光明"},
	{"guangpan", "光盘"},
	{"guangpu", "光谱"},
	{"guangrong", "光荣"},
	{"guanguang", "观光"},
	{"guangxi", "广西"},
	{"guangxian", "光线"},
	{"guangyi", "广义"},
	{"guangyin", "光阴"},
	{"guangzhou", "广州"},
	{"guanhuai", "关怀"},
	{"guanian", "挂念"},
	{"guanjia", "管家"},
	{"guanjian", "关键"},
	{"guanjiao", "管教"},
	{"guanjie", "关节"},
	{"guanjun", "冠军"},
	{"guanka", "关卡"},
	{"guankan", "观看"},
	{"guankou", "关口"},
	{"guanli", "管理 贯例 惯例 官吏"},
	{"guanlian", "关联"},
	{"guanliao", "官僚"},
	{"guanmen", "关门"},
	{"guanmo", "观摩"},
	{"guanmu", "灌木"},
	{"guanneng", "官能"},
	{"guannian", "观念"},
	{"guanqie", "关切"},
	{"guanshang", "观赏"},
	{"guanshi", "管事"},
	{"guanshu", "管束 灌输"},
	{"guanshui", "灌水 关税"},
	{"guansi", "官司"},
	{"guantong", "贯通"},
	{"guantou", "关头"},
	{"guanwang", "观望"},
	{"guanxi", "关系"},
	{"guanxia", "管辖"},
	{"guanxian", "官衔"},
	{"guanxin", "关心"},
	{"guanxing", "惯性"},
	{"guanya", "关押"},
	{"guanyong", "惯用"},
	{"guanyu", "关于"},
	{"guanyuan", "官员"},
	{"guanzhan", "观战"},
	{"guanzhao", "关照"},
	{"guanzhi", "管制 观止"},
	{"guanzhong", "观众"},
	{"guanzhu", "关注 贯注"},
	{"guanzi", "馆子"},
	{"guashi", "挂失"},
	{"guashuai", "挂帅"},
	{"guchui", "鼓吹"},
	{"guci", "故此"},
	{"gudai", "古代"},
	{"gudan", "孤单"},
	{"gudi", "故地"},
	{"gudian", "古典"},
	{"guding", "固定"},
	{"gudong", "鼓动 股东 古董"},
	{"gudu", "孤独 咕嘟"},
	{"guer", "孤儿"},
	{"gufen", "股份"},
	{"gufu", "辜负"},
	{"gugan", "骨干"},
	{"gugong", "雇工 故宫"},
	{"guguai", "古怪"},
	{"guhuo", "蛊惑"},
	{"guibian", "诡辩"},
	{"guibin", "贵宾"},
	{"guibing", "归并"},
	{"guicheng", "规程"},
	{"guidang", "归档"},
	{"guidao", "轨道"},
	{"guiding", "规定"},
	{"guidui", "归队"},
	{"guifan", "规范"},
	{"guige", "规格"},
	{"guigong", "归公 归功"},
	{"guiguan", "桂冠"},
	{"guiguo", "归国"},
	{"guihua", "规划 鬼话"},
	{"guihuan", "归还"},
	{"guiji", "诡计 轨迹"},
	{"guijian", "贵贱"},
	{"guijie", "归结 规诫"},
	{"guijiu", "归咎"},
	{"guiju", "规矩"},
	{"guili", "瑰丽"},
	{"guilian", "鬼脸"},
	{"guilie", "龟裂"},
	{"guilv", "规律"},
	{"guimi", "诡秘"},
	{"guimo", "规模"},
	{"guina", "归纳"},
	{"guinv", "闺女"},
	{"guiquan", "规劝"},
	{"guiren", "贵人"},
	{"guishu", "归属"},
	{"guisuo", "龟缩"},
	{"guitai", "柜台"},
	{"guixiu", "闺秀"},
	{"guiyu", "归于"},
	{"guize", "规则"},
	{"guizhang", "规章"},
	{"guizhong", "贵重"},
	{"guizhou", "贵州"},
	{"guizi", "鬼子"},
	{"guizu", "贵族"},
	{"guizui", "归罪"},
	{"guji", "顾及 估计 古迹 顾忌"},
	{"gujia", "估价"},
	{"gujin", "古今"},
	{"gujiu", "古旧 故旧"},
	{"guju", "故居"},
	{"guke", "顾客"},
	{"guku", "孤苦"},
	{"gulao", "古老"},
	{"guli", "孤立 鼓励"},
	{"guliang", "估量"},
	{"gulv", "顾虑"},
	{"gumo", "估摸"},
	{"gundong", "滚动"},
	{"guniang", "姑娘"},
	{"gunong", "雇农"},
	{"guntang", "滚烫"},
	{"gunzi", "棍子"},
	{"guoban", "过半"},
	{"guoce", "国策"},
	{"guochan", "国产"},
	{"guocheng", "过程"},
	{"guocuo", "过错"},
	{"guodu", "过度 过渡"},
	{"guoduan", "果断"},
	{"guofa", "国法"},
	{"guofang", "国防"},
	{"guofen", "过分"},
	{"guofu", "果腹"},
	{"guogan", "果敢"},
	{"guoge", "国歌"},
	{"guoguan", "过关"},
	{"guohou", "过后"},
	{"guohui", "国会"},
	{"guoji", "国际 国籍"},
	{"guojia", "国家"},
	{"guojie", "国界"},
	{"guojing", "国境"},
	{"guoku", "国库"},
	{"guolai", "过来"},
	{"guoliang", "过量"},
	{"guolu", "锅炉"},
	{"guolv", "过滤 过虑"},
	{"guomin", "国民"},
	{"guomu", "过目 果木"},
	{"guonan", "国难"},
	{"guonei", "国内"},
	{"guopi", "果皮"},
	{"guopin", "果品"},
	{"guoqi", "国旗 过期"},
	{"guoqing", "国情 国庆"},
	{"guoqu", "过去"},
	{"guoran", "果然"},
	{"guoshao", "过少"},
	{"guoshen", "过甚"},
	{"guosheng", "过剩"},
	{"guoshi", "过时 国事 过失 果实"},
	{"guotou", "过头"},
	{"guowai", "国外"},
	{"guowang", "国王"},
	{"guowen", "过问"},
	{"guowu", "国务"},
	{"guoxi", "过细"},
	{"guoyao", "国药"},
	{"guoying", "国营 过硬"},
	{"guoyu", "过于"},
	{"guoyuan", "果园"},
	{"guozhen", "果真"},
	{"guozi", "锅子"},
	{"gupan", "顾盼"},
	{"gupi", "孤僻"},
	{"gupiao", "股票"},
	{"guqi", "骨气"},
	{"guqie", "姑且"},
	{"guquan", "顾全"},
	{"guran", "固然"},
	{"guren", "古人"},
	{"gurou", "骨肉"},
	{"gushi", "故事 股市"},
	{"gushou", "固守"},
	{"gusuan", "估算"},
	{"guti", "固体"},
	{"gutou", "骨头"},
	{"gutu", "故土"},
	{"guwen", "顾问 古文"},
	{"guwu", "谷物 鼓舞"},
	{"guxi", "姑息"},
	{"guxiang", "故乡"},
	{"guyi", "故意"},
	{"guyong", "雇佣"},
	{"guyou", "固有"},
	{"guyuan", "雇员"},
	{"guzhang", "鼓掌 故障"},
	{"guzhi", "固执"},
	{"gwmj", "拐弯抹角"},
	{"gwwy", "国务委员"},
	{"gwy", "国务院"},
	{"gxgz", "改邪归正"},
	{"gxhd", "更新换代"},
	{"gxqs", "各行其事"},
	{"gxrs", "感性认识"},
	{"gxzz", "广西壮族"},
	{"gyh", "工业化"},
	{"gylc", "工艺流程"},
	{"gyms", "工艺美术"},
	{"gyp", "工业品 工艺品"},
	{"gys", "贵阳市"},
	{"gyz", "公有制"},
	{"gzgy", "各种各样"},
	{"gzjb", "工资级别"},
	{"gzrm", "各族人民"},
	{"gzs", "工作上 广州市 贵州省"},
	{"gzwz", "各自为政"},
	{"gzyz", "高瞻远瞩"},
	{"gzz", "工作者"},
	{"hada", "哈达"},
	{"haian", "海岸"},
	{"haiba", "海拔"},
	{"haibao", "海报"},
	{"haichong", "害虫"},
	{"haichu", "害处"},
	{"haidao", "海岛"},
	{"haigang", "海港"},
	{"haiguan", "海关"},
	{"haihao", "还好"},
	{"haijiang", "海疆"},
	{"haijun", "海军"},
	{"hailang", "海浪"},
	{"haimian", "海绵"},
	{"haipa", "害怕"},
	{"haishang", "海上"},
	{"haishi", "还是"},
	{"haiwai", "海外"},
	{"haiwan", "海湾"},
	{"haixia", "海峡"},
	{"haixiao", "海啸"},
	{"haixiu", "害羞"},
	{"haiyang", "海洋"},
	{"haiyao", "还要"},
	{"haiyou", "还有"},
	{"haiyu", "海域"},
	{"haiyuan", "海员"},
	{"haizi", "孩子"},
	{"hama", "蛤蟆"},
	{"hanchao", "寒潮"},
	{"hanchen", "寒碜"},
	{"handai", "寒带"},
	{"hangbiao", "航标"},
	{"hangcheng", "航程"},
	{"hangchuan", "航船"},
	{"hangdang", "行当"},
	{"hangdao", "航道"},
	{"hanghai", "航海"},
	{"hangjia", "行家"},
	{"hangju", "行距"},
	{"hangkong", "航空"},
	{"hanglie", "行列"},
	{"hanglu", "航路"},
	{"hangmo", "航模"},
	{"hangou", "函购"},
	{"hanguo", "韩国"},
	{"hangqing", "行情"},
	{"hangtian", "航天"},
	{"hangxian", "航线"},
	{"hangxiang", "航向"},
	{"hangxing", "航行"},
	{"hangyun", "航运"},
	{"hangzhou", "杭州"},
	{"hanhu", "含糊"},
	{"hanhun", "含混"},
	{"hanji", "旱季"},
	{"hanjian", "函件 罕见 汉奸"},
	{"hanjiao", "喊叫"},
	{"hanjie", "焊接"},
	{"hanleng", "寒冷"},
	{"hanlin", "翰林"},
	{"hanliu", "寒流"},
	{"hanshou", "函授"},
	{"hanshu", "函数"},
	{"hanshui", "酣睡"},
	{"hansuan", "寒酸"},
	{"hanwei", "捍卫"},
	{"hanxu", "含蓄"},
	{"hanxuan", "寒暄"},
	{"hanyang", "涵养"},
	{"hanyi", "含义 涵义"},
	{"hanyu", "汉语"},
	{"hanyuan", "含冤"},
	{"hanzai", "旱灾"},
	{"hanzi", "汉字"},
	{"hanzu", "汉族"},
	{"haobi", "好比"},
	{"haobu", "毫不"},
	{"haobuhao", "好不好"},
	{"haocheng", "号称"},
	{"haochu", "好处"},
	{"haoda", "浩大"},
	{"haodai", "好歹"},
	{"haodang", "浩荡"},
	{"haode", "好的"},
	{"haofan", "浩繁"},
	{"haofei", "耗费"},
	{"haogan", "好感"},
	{"haohan", "好汉"},
	{"haohua", "豪华"},
	{"haohuai", "好坏"},
	{"haojiao", "号角"},
	{"haojie", "耗竭 豪杰 浩劫"},
	{"haokan", "好看"},
	{"haoli", "毫厘"},
	{"haoling", "号令"},
	{"haoma", "号码"},
	{"haomai", "豪迈"},
	{"haomao", "毫毛"},
	{"haomi", "毫米"},
	{"haomiao", "浩淼"},
	{"haoqi", "好奇"},
	{"haoqiang", "豪强"},
	{"haoqing", "豪情"},
	{"haoren", "好人"},
	{"haoshen", "豪绅"},
	{"haosheng", "毫升"},
	{"haoshi", "好事"},
	{"haoshuang", "豪爽"},
	{"haosi", "好似"},
	{"haosun", "耗损"},
	{"haotao", "号啕"},
	{"haoting", "好听"},
	{"haowan", "好玩"},
	{"haowu", "毫无"},
	{"haoxiang", "好像"},
	{"haoxie", "好些"},
	{"haoyang", "好样"},
	{"haoyi", "好意"},
	{"haozhao", "号召"},
	{"haozhuan", "好转"},
	{"hbcx", "汇编程序"},
	{"hbhl", "货币回笼"},
	{"hblt", "货币流通"},
	{"hbs", "河北省 湖北省"},
	{"hbyy", "汇编语言"},
	{"hdc", "喝倒彩"},
	{"hdhs", "或多或少"},
	{"hdq", "海淀区"},
	{"heai", "和蔼"},
	{"heb", "哈尔滨"},
	{"heban", "合办"},
	{"hebao", "荷包"},
	{"hebei", "河北"},
	{"hebi", "何必"},
	{"hebing", "合并"},
	{"hebs", "哈尔滨市"},
	{"hebu", "何不"},
	{"hecai", "喝彩"},
	{"hechang", "合唱 何尝"},
	{"hecheng", "合成"},
	{"hechi", "呵斥"},
	{"hechu", "何处"},
	{"hechuan", "河川"},
	{"hechuang", "河床"},
	{"heci", "贺词"},
	{"hedeng", "何等"},
	{"hedian", "贺电"},
	{"heding", "核定"},
	{"hedui", "核对"},
	{"hefa", "合法"},
	{"hefang", "何妨"},
	{"hefei", "合肥"},
	{"hege", "合格"},
	{"hehao", "和好"},
	{"hehe", "呵呵 赫赫"},
	{"hehu", "合乎"},
	{"hehuo", "合伙"},
	{"heian", "黑暗"},
	{"heibai", "黑白"},
	{"heibang", "黑帮"},
	{"heihei", "嘿嘿"},
	{"heiren", "黑人"},
	{"heise", "黑色"},
	{"heishi", "黑市"},
	{"heiye", "黑夜"},
	{"heji", "合计 核计"},
	{"hejie", "和解"},
	{"hejin", "合金"},
	{"heku", "何苦"},
	{"hekuang", "何况"},
	{"heli", "合理 合力"},
	{"heliu", "合流 河流"},
	{"hemou", "合谋"},
	{"hemu", "和睦"},
	{"henan", "河南"},
	{"hendu", "狠毒"},
	{"henduo", "很多"},
	{"henei", "河内"},
	{"hengcai", "横财"},
	{"hengchi", "哼哧"},
	{"hengfu", "横幅"},
	{"henggen", "横亘"},
	{"hengguan", "横贯"},
	{"henghuo", "横祸"},
	{"hengjia", "横加"},
	{"hengliang", "衡量"},
	{"hengman", "横蛮"},
	{"hengpi", "横批"},
	{"hengqi", "衡器"},
	{"hengsao", "横扫"},
	{"hengshu", "横竖"},
	{"hengxin", "恒心"},
	{"hengxing", "横行 恒星"},
	{"henhao", "很好"},
	{"henian", "贺年"},
	{"henji", "痕迹"},
	{"henkuai", "很快"},
	{"henxin", "狠心"},
	{"henzhua", "狠抓"},
	{"heping", "和平"},
	{"heqi", "和气"},
	{"hequ", "河渠"},
	{"heran", "赫然"},
	{"heshan", "河山"},
	{"heshang", "和尚"},
	{"heshi", "合适 核实"},
	{"hesuan", "合算 核算"},
	{"hetan", "河滩"},
	{"hetong", "合同"},
	{"hexi", "贺喜"},
	{"hexie", "和谐"},
	{"hexin", "核心 贺信"},
	{"hexu", "和煦"},
	{"heyi", "何以"},
	{"heying", "合影 合营"},
	{"hezhun", "核准"},
	{"hezi", "合资 赫兹"},
	{"hezuo", "合作"},
	{"hfqy", "合法权益"},
	{"hfs", "合肥市"},
	{"hgsj", "宏观世界"},
	{"hgws", "化公为私"},
	{"hgwy", "好高务远"},
	{"hgyb", "核工业部"},
	{"hgzs", "海关总署"},
	{"hgzy", "后顾之忧"},
	{"hhht", "呼和浩特"},
	{"hhll", "轰轰烈烈"},
	{"hjhs", "换句话说"},
	{"hjsd", "黄金时代"},
	{"hjws", "环境卫生"},
	{"hjyr", "后继有人"},
	{"hksl", "海枯石烂"},
	{"hlh", "合理化"},
	{"hlht", "糊里糊涂"},
	{"hlj", "黑龙江"},
	{"hljb", "汗流浃背"},
	{"hlw", "互联网"},
	{"hmgl", "汗马功劳"},
	{"hnd", "海南岛"},
	{"hns", "河南省 湖南省"},
	{"hongchen", "红尘"},
	{"hongdong", "轰动"},
	{"hongfeng", "洪峰"},
	{"hongfu", "洪福"},
	{"honggou", "鸿沟"},
	{"hongguan", "宏观"},
	{"hongguang", "红光"},
	{"honghua", "红花"},
	{"hongjun", "红军"},
	{"hongli", "红利"},
	{"hongliang", "洪亮"},
	{"honglong", "轰隆"},
	{"honglun", "宏论"},
	{"hongmao", "鸿毛"},
	{"hongming", "轰鸣"},
	{"hongpian", "哄骗"},
	{"hongqi", "红旗"},
	{"hongren", "红人"},
	{"hongse", "红色"},
	{"hongshui", "洪水"},
	{"hongtai", "哄抬"},
	{"hongtu", "宏图"},
	{"hongwei", "宏伟"},
	{"hongxing", "红星"},
	{"hongyang", "弘扬"},
	{"hongyuan", "宏愿"},
	{"hongyun", "鸿运 红晕"},
	{"hongzha", "轰炸"},
	{"hongzhi", "宏旨"},
	{"houbei", "后备 后辈"},
	{"houbian", "后边"},
	{"houbo", "厚薄"},
	{"houbu", "候补"},
	{"houchen", "后尘"},
	{"houdai", "后代"},
	{"houdao", "厚道"},
	{"houdu", "厚度"},
	{"houdun", "后盾"},
	{"houfang", "后方"},
	{"houguo", "后果"},
	{"houhuan", "后患"},
	{"houhui", "后悔"},
	{"houji", "后记"},
	{"houjin", "后进 后劲"},
	{"houlai", "后来"},
	{"houlong", "喉咙"},
	{"houmen", "后门"},
	{"houmian", "后面"},
	{"houqi", "后期"},
	{"houqin", "后勤"},
	{"houren", "后人"},
	{"houshe", "喉舌"},
	{"houshi", "厚实"},
	{"housi", "后嗣"},
	{"houtai", "后台"},
	{"houtian", "后天"},
	{"houtui", "后退"},
	{"houxu", "后续"},
	{"houxuan", "候选"},
	{"houyi", "后裔"},
	{"houzhui", "后缀"},
	{"hpgc", "和平共处"},
	{"hpj", "黄埔江"},
	{"hqb", "后勤部"},
	{"hqhc", "何去何从"},
	{"hqhl", "合情合理"},
	{"hry", "好容易"},
	{"hsdm", "好事多磨"},
	{"hslx", "胡思乱想"},
	{"hsmy", "浑水摸鱼"},
	{"htgb", "航天工业部"},
	{"hthn", "昏头昏脑"},
	{"htt", "红彤彤"},
	{"htxd", "欢天喜地"},
	{"huabao", "画报"},
	{"huabei", "华北"},
	{"huabian", "哗变"},
	{"huabing", "话柄"},
	{"huabo", "划拨"},
	{"huace", "划策 画册"},
	{"huadong", "华东"},
	{"huaduo", "花朵"},
	{"huaer", "花儿"},
	{"huafei", "化肥 花费"},
	{"huafen", "划分"},
	{"huagong", "化工"},
	{"huagui", "华贵"},
	{"huahe", "化合"},
	{"huahui", "花卉"},
	{"huaibao", "怀抱"},
	{"huaibei", "淮北"},
	{"huaichu", "坏处"},
	{"huaidan", "坏蛋"},
	{"huaigu", "怀古"},
	{"huaihai", "淮海"},
	{"huaihen", "怀恨"},
	{"huaijiu", "怀旧"},
	{"huainan", "淮南"},
	{"huainian", "怀念"},
	{"huairen", "坏人"},
	{"huaishi", "坏事"},
	{"huaiyi", "怀疑"},
	{"huaizhe", "怀着"},
	{"huaji", "滑稽"},
	{"huajia", "画家"},
	{"huaju", "话剧"},
	{"huala", "哗啦"},
	{"hualang", "画廊"},
	{"huali", "华丽"},
	{"huamian", "画面"},
	{"huaming", "化名"},
	{"huanan", "华南"},
	{"huanchang", "欢畅"},
	{"huanchong", "缓冲"},
	{"huandeng", "幻灯"},
	{"huandu", "欢度"},
	{"huanfa", "焕发"},
	{"huangan", "磺胺"},
	{"huangchao", "皇朝"},
	{"huangdan", "荒诞"},
	{"huangdang", "晃荡"},
	{"huangdi", "皇帝"},
	{"huangfei", "荒废"},
	{"huanghai", "黄海"},
	{"huanghe", "黄河"},
	{"huanghu", "恍惚"},
	{"huanghua", "谎话"},
	{"huanghun", "黄昏"},
	{"huangjin", "黄金"},
	{"huangli", "皇历"},
	{"huangliang", "荒凉"},
	{"huangluan", "荒乱 慌乱"},
	{"huangmang", "慌忙"},
	{"huangmiu", "荒谬"},
	{"huangran", "恍然"},
	{"huangse", "黄色"},
	{"huangshan", "黄山"},
	{"huangshang", "皇上"},
	{"huangtang", "荒唐"},
	{"huangu", "环顾"},
	{"huanguan", "宦官"},
	{"huangyan", "谎言"},
	{"huangzhang", "慌张"},
	{"huangzi", "幌子"},
	{"huanhe", "缓和"},
	{"huanhu", "欢呼"},
	{"huanhuan", "环环"},
	{"huani", "滑腻"},
	{"huaniao", "花鸟"},
	{"huanji", "还给 缓急"},
	{"huanjia", "还价"},
	{"huanjie", "环节"},
	{"huanjing", "环境 幻境 幻景"},
	{"huanju", "欢聚"},
	{"huanjue", "幻觉"},
	{"huanle", "欢乐"},
	{"huanman", "缓慢"},
	{"huannan", "患难"},
	{"huanqi", "唤起 缓期"},
	{"huanqing", "欢庆"},
	{"huanqiu", "环球 寰球"},
	{"huanqu", "换取"},
	{"huanrao", "环绕"},
	{"huansan", "涣散"},
	{"huansheng", "欢声"},
	{"huanshi", "环视"},
	{"huansong", "欢送"},
	{"huansuan", "换算"},
	{"huanteng", "欢腾"},
	{"huanxi", "欢喜"},
	{"huanxiang", "幻想"},
	{"huanxiao", "欢笑"},
	{"huanxin", "欢心 欢欣"},
	{"huanxing", "环行 缓刑 唤醒"},
	{"huanying", "幻影 欢迎"},
	{"huanyu", "寰宇"},
	{"huanyuan", "还原"},
	{"huanzhe", "患者"},
	{"huapo", "滑坡"},
	{"huaqiang", "花腔"},
	{"huaqiao", "华侨"},
	{"huaqing", "划清"},
	{"huaquan", "花圈 划拳"},
	{"huaran", "哗然"},
	{"huaren", "华人"},
	{"huase", "花色"},
	{"huashen", "化身"},
	{"huashi", "化石"},
	{"huasuan", "划算"},
	{"huati", "话题"},
	{"huatou", "滑头"},
	{"huawen", "花纹"},
	{"huaxia", "华夏"},
	{"huaxian", "化纤"},
	{"huaxiang", "画像"},
	{"huaxu", "花絮"},
	{"huaxue", "化学"},
	{"huaya", "画押"},
	{"huayan", "化验"},
	{"huayang", "花样"},
	{"huayi", "华裔"},
	{"huayin", "话音"},
	{"huayu", "话语"},
	{"huayuan", "花园"},
	{"huazhan", "画展"},
	{"huazhao", "花招"},
	{"huazhong", "华中"},
	{"huazhuang", "化装 化妆"},
	{"hubei", "湖北"},
	{"huche", "胡扯"},
	{"huchou", "狐臭"},
	{"hudie", "蝴蝶"},
	{"hudu", "弧度"},
	{"huer", "忽而"},
	{"huhan", "呼喊"},
	{"huhao", "呼号"},
	{"huhuan", "呼唤"},
	{"huhui", "互惠"},
	{"huian", "灰暗"},
	{"huibao", "回报 汇报"},
	{"huibi", "回避"},
	{"huibian", "汇编"},
	{"huichang", "会场"},
	{"huichao", "回潮"},
	{"huichen", "灰尘"},
	{"huichun", "回春"},
	{"huicui", "荟萃"},
	{"huida", "回答"},
	{"huidang", "回荡"},
	{"huidian", "回电"},
	{"huidui", "汇兑"},
	{"huifa", "挥发"},
	{"huifei", "汇费"},
	{"huifeng", "会风"},
	{"huifu", "回复 恢复"},
	{"huigai", "悔改"},
	{"huigu", "回顾 惠顾"},
	{"huiguo", "悔过"},
	{"huihe", "会合 回合 汇合"},
	{"huihen", "悔恨"},
	{"huihong", "恢弘"},
	{"huihua", "会话 回话 绘画"},
	{"huihuai", "毁坏"},
	{"huihuang", "辉煌"},
	{"huihuo", "挥霍"},
	{"huiji", "会集 回击 汇集"},
	{"huijia", "回家"},
	{"huijian", "会见"},
	{"huiju", "会聚 汇聚"},
	{"huikou", "回扣"},
	{"huikuan", "汇款"},
	{"huilai", "回来"},
	{"huilong", "回笼"},
	{"huilu", "贿赂"},
	{"huilv", "汇率"},
	{"huimian", "会面"},
	{"huimie", "毁灭"},
	{"huimin", "回民"},
	{"huinong", "溃脓"},
	{"huipiao", "汇票"},
	{"huiqu", "回去"},
	{"huisa", "挥洒"},
	{"huise", "灰色 晦涩"},
	{"huishi", "回事"},
	{"huishou", "回收 回首"},
	{"huitan", "会谈"},
	{"huitang", "会堂"},
	{"huitong", "会同"},
	{"huitou", "回头"},
	{"huiwei", "回味"},
	{"huiwu", "会晤 挥舞 悔悟"},
	{"huixia", "麾下"},
	{"huixiang", "回想 回响"},
	{"huixie", "诙谐"},
	{"huixin", "灰心"},
	{"huixing", "彗星"},
	{"huiyan", "会演 汇演"},
	{"huiyi", "会议 回忆"},
	{"huiyin", "回音"},
	{"huiying", "辉映"},
	{"huiyuan", "会员"},
	{"huizhan", "会战"},
	{"huizhang", "徽章"},
	{"huizhen", "会诊"},
	{"huizhi", "绘制"},
	{"huizhuan", "回转"},
	{"huizong", "汇总"},
	{"huizu", "回族"},
	{"huji", "户籍"},
	{"hujiao", "呼叫"},
	{"hukou", "户口 虎口"},
	{"huli", "护理 互利"},
	{"hulian", "互联"},
	{"hulin", "护林"},
	{"hulu", "呼噜"},
	{"huluan", "胡乱"},
	{"hulue", "忽略"},
	{"humian", "互勉"},
	{"hunan", "湖南"},
	{"hunao", "胡闹"},
	{"hunchen", "昏沉"},
	{"hunhe", "混合"},
	{"hunhou", "浑厚"},
	{"hunhuang", "昏黄"},
	{"hunji", "混迹"},
	{"hunli", "婚礼"},
	{"hunluan", "混乱"},
	{"hunong", "糊弄"},
	{"hunpei", "婚配"},
	{"hunru", "混入"},
	{"hunshen", "浑身"},
	{"huntong", "混同"},
	{"hunxiao", "混淆"},
	{"hunyin", "婚姻"},
	{"hunyong", "昏庸"},
	{"hunza", "混杂"},
	{"hunzhang", "混帐"},
	{"hunzhuo", "混浊 浑浊"},
	{"huoba", "火把"},
	{"huoban", "伙伴"},
	{"huobao", "火暴"},
	{"huobi", "货币"},
	{"huochai", "火柴"},
	{"huoche", "火车"},
	{"huoda", "豁达"},
	{"huode", "获得"},
	{"huodi", "霍地"},
	{"huodong", "活动"},
	{"huofang", "伙房"},
	{"huogen", "祸根"},
	{"huohai", "祸害"},
	{"huohou", "火候"},
	{"huohua", "火化 火花"},
	{"huohuan", "祸患"},
	{"huohuo", "活活"},
	{"huoji", "伙计"},
	{"huojian", "火箭"},
	{"huojing", "火警"},
	{"huoju", "火炬"},
	{"huokeng", "火坑"},
	{"huoli", "活力"},
	{"huoluan", "霍乱"},
	{"huopo", "活泼"},
	{"huoqu", "获取"},
	{"huoran", "豁然"},
	{"huose", "货色"},
	{"huoshan", "火山"},
	{"huosheng", "获胜"},
	{"huoshi", "或是 伙食"},
	{"huoshou", "祸首"},
	{"huotong", "伙同"},
	{"huowu", "货物"},
	{"huoxi", "获悉"},
	{"huoxian", "火线 活现"},
	{"huoxu", "或许"},
	{"huoyao", "火药"},
	{"huoye", "活页"},
	{"huoyue", "活跃"},
	{"huoyun", "货运"},
	{"huozai", "火灾"},
	{"huozang", "火葬"},
	{"huoze", "或则"},
	{"huozhe", "或者"},
	{"huozhun", "获准"},
	{"hupo", "湖泊 琥珀"},
	{"huran", "忽然"},
	{"husheng", "呼声"},
	{"hushi", "护士 忽视"},
	{"hushui", "湖水"},
	{"hushuo", "胡说"},
	{"husong", "护送"},
	{"hutong", "胡同 互通"},
	{"hutou", "户头"},
	{"hutu", "糊涂"},
	{"huwei", "护卫"},
	{"huxi", "呼吸"},
	{"huxiang", "互相"},
	{"huxiao", "呼啸"},
	{"huxue", "虎穴"},
	{"huyang", "护养"},
	{"huying", "呼应"},
	{"huyu", "呼吁"},
	{"huzhao", "护照"},
	{"huzhu", "互助"},
	{"hwyw", "毫无疑问"},
	{"hxah", "互相爱护"},
	{"hxbd", "横行霸道"},
	{"hxbz", "互相帮助"},
	{"hxgw", "欢欣鼓舞"},
	{"hxr", "候选人"},
	{"hzh", "合作化"},
	{"hzs", "杭州市"},
	{"hzwl", "化整为零"},
	{"jbgc", "基本国策"},
	{"jbs", "基本上"},
	{"jbwj", "据不完全统计"},
	{"jbzs", "饥不择食"},
	{"jcbx", "坚持不懈"},
	{"jcdl", "集成电路"},
	{"jcs", "基础上"},
	{"jdbf", "绝大部分"},
	{"jdby", "坚定不移"},
	{"jdds", "绝大多数"},
	{"jdh", "鉴定会 绝对化"},
	{"jdq", "经得起"},
	{"jdsg", "见多识广"},
	{"jdxs", "精打细算"},
	{"jels", "接二连三"},
	{"jfh", "解放后"},
	{"jfj", "解放军"},
	{"jfjb", "解放军报"},
	{"jfq", "解放前"},
	{"jgck", "仅供参考"},
	{"jggg", "机构改革"},
	{"jgny", "坚固耐用"},
	{"jhtb", "襟怀坦白"},
	{"jhx", "计划性"},
	{"jhz", "叫花子"},
	{"ji'an", "吉安"},
	{"jiaban", "加班 甲板"},
	{"jiabei", "加倍"},
	{"jiabin", "嘉宾"},
	{"jiachong", "甲虫"},
	{"jiachu", "家畜"},
	{"jiadang", "家当"},
	{"jiadi", "家底"},
	{"jiading", "假定"},
	{"jiafa", "加法"},
	{"jiafang", "家访"},
	{"jiage", "价格"},
	{"jiagong", "加工"},
	{"jiahua", "佳话"},
	{"jiahuo", "家伙"},
	{"jiaji", "加急"},
	{"jiajiang", "嘉奖"},
	{"jiajiao", "家教"},
	{"jiajie", "嫁接 佳节 假借"},
	{"jiajin", "加紧"},
	{"jiajing", "家境"},
	{"jiaju", "家具 加剧"},
	{"jiake", "夹克"},
	{"jiakuai", "加快"},
	{"jialun", "加仑"},
	{"jiama", "加码"},
	{"jiamao", "假冒"},
	{"jiamen", "家门"},
	{"jiami", "加密"},
	{"jiamian", "加冕"},
	{"jiamu", "价目"},
	{"jianao", "煎熬"},
	{"jianbao", "简报"},
	{"jianbian", "渐变 简便 简编"},
	{"jianbie", "鉴别"},
	{"jianbing", "兼并 尖兵"},
	{"jiancai", "剪裁 剪彩"},
	{"jiance", "检测"},
	{"jiancha", "检查 检察 监察"},
	{"jianchan", "减产"},
	{"jiancheng", "建成 简称"},
	{"jianchi", "坚持"},
	{"jiandan", "简单"},
	{"jiandang", "建党"},
	{"jiandi", "减低"},
	{"jiandian", "检点"},
	{"jiandie", "间谍"},
	{"jianding", "坚定 鉴定"},
	{"jiandu", "监督"},
	{"jianduan", "间断 尖端 简短"},
	{"jiandui", "舰队"},
	{"jianer", "健儿"},
	{"jianfa", "减法"},
	{"jianfu", "肩负"},
	{"jiangbei", "奖杯"},
	{"jiangchang", "疆场"},
	{"jiangcheng", "奖惩"},
	{"jiangchi", "僵持"},
	{"jiangdi", "降低"},
	{"jiange", "间隔"},
	{"jianggao", "讲稿"},
	{"jianghu", "江湖"},
	{"jianghua", "僵化 讲话"},
	{"jiangji", "降级"},
	{"jiangjia", "降价"},
	{"jiangjie", "讲解 疆界"},
	{"jiangjin", "将近 奖金"},
	{"jiangjiu", "讲究"},
	{"jiangju", "僵局"},
	{"jiangjun", "将军"},
	{"jiangke", "讲课"},
	{"jianglai", "将来"},
	{"jiangli", "讲理 奖励"},
	{"jianglin", "降临"},
	{"jiangling", "将领"},
	{"jiangluo", "降落"},
	{"jiangnan", "江南"},
	{"jiangpin", "奖品"},
	{"jiangping", "讲评"},
	{"jiangquan", "奖券"},
	{"jiangshan", "江山"},
	{"jiangshi", "讲师 僵尸"},
	{"jiangshou", "讲授"},
	{"jiangshu", "讲述"},
	{"jiangshui", "降水"},
	{"jiangsu", "江苏"},
	{"jiangtai", "讲台"},
	{"jiangtan", "讲坛"},
	{"jiangtu", "疆土"},
	{"jiangu", "坚固 兼顾"},
	{"jianguan", "监管"},
	{"jianguo", "建国"},
	{"jiangwen", "降温"},
	{"jiangxi", "江西 讲习"},
	{"jiangxin", "匠心"},
	{"jiangxue", "讲学"},
	{"jiangyan", "讲演"},
	{"jiangyao", "将要"},
	{"jiangyi", "讲义"},
	{"jiangying", "僵硬"},
	{"jiangzhang", "奖章"},
	{"jiangzuo", "讲座"},
	{"jianhu", "监护"},
	{"jianhua", "简化"},
	{"jianhuo", "间或"},
	{"jianji", "奸计 歼击 剪辑"},
	{"jianjia", "减价"},
	{"jianjian", "渐渐"},
	{"jianjiang", "健将"},
	{"jianjiao", "建交"},
	{"jianjie", "间接 见解 简介 简洁 简捷"},
	{"jianjin", "渐进 监禁"},
	{"jianju", "检举 艰巨"},
	{"jianjue", "坚决"},
	{"jiankang", "健康"},
	{"jianke", "尖刻"},
	{"jianku", "坚苦 艰苦"},
	{"jianlao", "监牢"},
	{"jianli", "建立 尖利 简历"},
	{"jianlian", "简练"},
	{"jianlou", "简陋"},
	{"jianlue", "简略"},
	{"jianmei", "健美"},
	{"jianmian", "减免"},
	{"jianmie", "歼灭"},
	{"jianming", "简明"},
	{"jianmo", "缄默"},
	{"jiannan", "艰难"},
	{"jianpan", "键盘"},
	{"jianpin", "简拼"},
	{"jianpu", "简朴 俭朴"},
	{"jianqiang", "坚强"},
	{"jianqing", "减轻"},
	{"jianquan", "健全"},
	{"jianren", "兼任 坚韧"},
	{"jianrong", "兼容"},
	{"jianrui", "尖锐"},
	{"jianruo", "减弱"},
	{"jianse", "艰涩"},
	{"jianshang", "鉴赏"},
	{"jianshao", "减少"},
	{"jianshe", "建设"},
	{"jianshen", "艰深"},
	{"jianshi", "见识 坚实 监视"},
	{"jianshu", "建树"},
	{"jiansu", "减速"},
	{"jiansuo", "检索"},
	{"jianta", "践踏"},
	{"jiantan", "健谈"},
	{"jiantao", "检讨"},
	{"jianti", "简体"},
	{"jianting", "舰艇"},
	{"jiantui", "减退"},
	{"jianwang", "健忘"},
	{"jianwen", "间文 见闻"},
	{"jianxi", "间隙 奸细"},
	{"jianxian", "艰险"},
	{"jianxiao", "见效"},
	{"jianxie", "间歇 简写"},
	{"jianxin", "坚信 艰辛"},
	{"jianxing", "减刑"},
	{"jianxiu", "检修"},
	{"jianxun", "简讯"},
	{"jianyan", "检验"},
	{"jianyao", "简要"},
	{"jianyi", "建议 坚毅 简易"},
	{"jianyin", "奸淫"},
	{"jianying", "坚硬 剪影"},
	{"jianyu", "鉴于 监狱"},
	{"jianyuan", "减员"},
	{"jianyue", "检阅"},
	{"jianzao", "建造"},
	{"jianze", "简则"},
	{"jianzhen", "坚贞"},
	{"jianzhi", "监制 简直 兼职"},
	{"jianzhu", "建筑"},
	{"jianzhuang", "简装 健壮"},
	{"jiaoao", "骄傲"},
	{"jiaoban", "搅拌"},
	{"jiaobian", "狡辩"},
	{"jiaocai", "教材"},
	{"jiaocha", "交叉"},
	{"jiaocheng", "教程"},
	{"jiaocuo", "交错"},
	{"jiaoda", "较大"},
	{"jiaodai", "交代"},
	{"jiaodao", "教导"},
	{"jiaodian", "交点 焦点"},
	{"jiaoding", "校订"},
	{"jiaodu", "角度"},
	{"jiaodui", "校对"},
	{"jiaoduo", "较多"},
	{"jiaoer", "焦耳"},
	{"jiaofeng", "交锋"},
	{"jiaofu", "交付"},
	{"jiaogen", "脚跟"},
	{"jiaoguan", "浇灌"},
	{"jiaogui", "娇贵"},
	{"jiaohan", "叫喊"},
	{"jiaohao", "较好 叫好"},
	{"jiaohua", "狡猾"},
	{"jiaohuan", "交换 叫唤"},
	{"jiaohui", "教诲"},
	{"jiaohuo", "缴获"},
	{"jiaoji", "交际"},
	{"jiaojian", "矫健"},
	{"jiaojie", "交接 交界"},
	{"jiaoku", "叫苦"},
	{"jiaokuai", "较快"},
	{"jiaolian", "教练"},
	{"jiaoliang", "较量"},
	{"jiaoliu", "交流"},
	{"jiaoluan", "搅乱"},
	{"jiaoluo", "角落"},
	{"jiaoma", "叫骂"},
	{"jiaomen", "角门"},
	{"jiaomie", "剿灭"},
	{"jiaomu", "酵母"},
	{"jiaona", "交纳 缴纳"},
	{"jiaonen", "娇嫩"},
	{"jiaopei", "交配"},
	{"jiaoqi", "骄气"},
	{"jiaoqing", "交情"},
	{"jiaoqu", "郊区"},
	{"jiaorang", "叫嚷"},
	{"jiaose", "角色"},
	{"jiaoshe", "交涉"},
	{"jiaoshi", "教师"},
	{"jiaoshou", "教授"},
	{"jiaosuo", "教唆"},
	{"jiaota", "脚踏"},
	{"jiaotan", "交谈"},
	{"jiaotang", "教堂"},
	{"jiaoti", "交替"},
	{"jiaotiao", "教条"},
	{"jiaotong", "交通"},
	{"jiaowai", "郊外"},
	{"jiaowang", "交往"},
	{"jiaowei", "较为"},
	{"jiaoxia", "狡黠"},
	{"jiaoxiao", "叫嚣"},
	{"jiaoxing", "侥幸 绞刑"},
	{"jiaoxue", "教学"},
	{"jiaoxun", "教训"},
	{"jiaoyang", "教养 骄阳"},
	{"jiaoyi", "教益 交易"},
	{"jiaoyu", "教育"},
	{"jiaoyuan", "教员"},
	{"jiaozha", "狡诈"},
	{"jiaozheng", "校正"},
	{"jiaozhu", "脚注 角逐 浇铸"},
	{"jiaozhun", "校准"},
	{"jiaozhuo", "焦灼"},
	{"jiaozong", "娇纵"},
	{"jiaozuo", "叫做"},
	{"jiapu", "家谱"},
	{"jiaqi", "假期"},
	{"jiaqian", "价钱"},
	{"jiaqiang", "加强"},
	{"jiari", "假日"},
	{"jiaru", "加入 假如"},
	{"jiaruo", "假若"},
	{"jiashang", "加上"},
	{"jiashe", "假设"},
	{"jiashen", "加深"},
	{"jiashi", "假使 架势 驾驶"},
	{"jiashu", "家属"},
	{"jiashuo", "假说"},
	{"jiasu", "加速"},
	{"jiasuo", "枷锁"},
	{"jiating", "家庭"},
	{"jiaxiang", "家乡 假想"},
	{"jiaye", "家业"},
	{"jiayi", "加以"},
	{"jiayin", "佳音"},
	{"jiayong", "家用"},
	{"jiayou", "加油"},
	{"jiayu", "驾驭"},
	{"jiayuan", "家园"},
	{"jiaza", "夹杂"},
	{"jiazai", "加载"},
	{"jiazhang", "家长"},
	{"jiazhi", "价值"},
	{"jiazhong", "加重"},
	{"jiazhuang", "假装 嫁妆"},
	{"jiazi", "架子"},
	{"jiazu", "家族"},
	{"jibai", "击败"},
	{"jiban", "羁绊"},
	{"jibei", "几倍"},
	{"jiben", "基本"},
	{"jibi", "击毙"},
	{"jibie", "级别"},
	{"jibing", "疾病"},
	{"jice", "计策"},
	{"jiceng", "基层"},
	{"jicha", "稽查"},
	{"jichang", "机场"},
	{"jicheng", "集成 继承"},
	{"jichou", "计酬"},
	{"jichu", "基础"},
	{"jichuang", "机床"},
	{"jici", "几次"},
	{"jicu", "急促"},
	{"jicun", "积存 寄存"},
	{"jida", "极大"},
	{"jidai", "亟待"},
	{"jidang", "激荡"},
	{"jide", "记得"},
	{"jidi", "基地"},
	{"jidian", "机电 极点"},
	{"jidiao", "基调"},
	{"jidong", "激动 机动"},
	{"jidu", "极度 几度 即度 季度 基督 嫉妒 忌妒"},
	{"jiduan", "极端"},
	{"ji'e", "饥饿"},
	{"jiean", "结案"},
	{"jiebai", "洁白"},
	{"jieban", "接班"},
	{"jiebao", "捷报"},
	{"jiebei", "戒备"},
	{"jiecai", "结彩"},
	{"jiecao", "节操"},
	{"jieceng", "阶层"},
	{"jiechi", "劫持"},
	{"jiechu", "杰出 解除 接触 戒除"},
	{"jiechuan", "揭穿"},
	{"jiecun", "结存"},
	{"jieda", "解答"},
	{"jiedai", "接待 借贷"},
	{"jiedao", "街道"},
	{"jiedong", "解冻"},
	{"jieduan", "阶段 截断"},
	{"jiefa", "揭发"},
	{"jiefang", "借方 解放 街坊"},
	{"jiegou", "结构"},
	{"jiegu", "解雇 借故"},
	{"jieguo", "结果"},
	{"jiehe", "结合 结核"},
	{"jiehun", "结婚"},
	{"jieji", "阶级"},
	{"jiejian", "接见 节俭 借鉴"},
	{"jiejiao", "结交"},
	{"jiejie", "姐姐"},
	{"jiejin", "接近 竭尽"},
	{"jiejing", "结晶 捷径 洁净"},
	{"jiejiu", "解救"},
	{"jieju", "结局"},
	{"jiejue", "解决 孑孓"},
	{"jiekai", "解开 揭开"},
	{"jieke", "解渴"},
	{"jiekou", "接口 借口"},
	{"jiekuan", "借款"},
	{"jieli", "竭力"},
	{"jielian", "接连"},
	{"jielu", "揭露"},
	{"jielun", "结论"},
	{"jielv", "戒律"},
	{"jiemen", "解闷"},
	{"jiemeng", "结盟"},
	{"jiemian", "界面"},
	{"jiemu", "节目 揭幕"},
	{"jiena", "接纳"},
	{"jiepin", "解聘"},
	{"jiepou", "解剖"},
	{"jieqi", "节气"},
	{"jieqia", "接洽"},
	{"jiequ", "截取"},
	{"jier", "既而"},
	{"jieri", "节日"},
	{"jieru", "介入"},
	{"jiesan", "解散"},
	{"jieshao", "介绍"},
	{"jiesheng", "节省"},
	{"jieshi", "解释 揭示 结实 届时"},
	{"jieshou", "接受 接收 解手"},
	{"jieshu", "结束"},
	{"jieshuo", "解说"},
	{"jiesuan", "结算"},
	{"jieti", "解体 阶梯 接替"},
	{"jietou", "接头 街头"},
	{"jietuo", "解脱"},
	{"jiewei", "结尾 解围"},
	{"jiewen", "接吻"},
	{"jiexi", "解析"},
	{"jiexian", "界线 界限"},
	{"jiexiao", "揭晓"},
	{"jieyan", "戒严"},
	{"jieye", "结业"},
	{"jieyi", "介意"},
	{"jieying", "接应"},
	{"jieyu", "结余"},
	{"jieyue", "节约"},
	{"jiezhang", "结帐"},
	{"jiezhao", "接着"},
	{"jiezhi", "节制 介质 戒指 借支 截止"},
	{"jiezhu", "借助"},
	{"jiezou", "节奏"},
	{"jiezuo", "杰作"},
	{"jifa", "激发 技法"},
	{"jifen", "激愤 积分"},
	{"jifeng", "讥讽"},
	{"jige", "几个 及格"},
	{"jigong", "技工 记功"},
	{"jigou", "机构"},
	{"jigu", "叽咕"},
	{"jiguan", "机关 籍贯"},
	{"jiguang", "极光 激光"},
	{"jiguo", "记过"},
	{"jihao", "极好 记号"},
	{"jihe", "集合 几何 稽核"},
	{"jihu", "几乎"},
	{"jihua", "计划 激化"},
	{"jihuang", "饥荒"},
	{"jihui", "机会 集会 击毁 忌讳"},
	{"jiji", "积极"},
	{"jijian", "机件 计件 急件 击剑"},
	{"jijiang", "即将"},
	{"jijiao", "计较"},
	{"jijie", "季节"},
	{"jijin", "急进 基金"},
	{"jijing", "机警 即景 寂静"},
	{"jijiu", "急救"},
	{"jiju", "积聚 急剧 急遽 寄居"},
	{"jikan", "季刊"},
	{"jike", "即刻"},
	{"jiku", "疾苦"},
	{"jikui", "击溃"},
	{"jilei", "积累"},
	{"jili", "极力 吉利 激励"},
	{"jilia", "伎俩"},
	{"jiliang", "计量"},
	{"jiliao", "寂寥"},
	{"jilie", "激烈"},
	{"jilin", "吉林"},
	{"jiling", "机灵"},
	{"jiliu", "激流"},
	{"jilu", "记录 纪录 辑录"},
	{"jiluo", "击落"},
	{"jilv", "纪律"},
	{"jimang", "急忙"},
	{"jimi", "机密"},
	{"jimo", "寂寞"},
	{"jimou", "计谋"},
	{"jina", "缉拿"},
	{"jinan", "济南"},
	{"jinbi", "禁闭"},
	{"jinbiao", "锦标"},
	{"jinbu", "进步"},
	{"jinchen", "浸沉"},
	{"jincheng", "进程"},
	{"jinchu", "进出"},
	{"jincou", "紧凑"},
	{"jindai", "近代"},
	{"jindu", "进度"},
	{"jine", "金额"},
	{"jineng", "机能 技能"},
	{"jiner", "进而"},
	{"jinfan", "进犯"},
	{"jingai", "敬爱"},
	{"jingbao", "警报"},
	{"jingbei", "警备"},
	{"jingbing", "精兵"},
	{"jingcai", "精彩"},
	{"jingcha", "警察"},
	{"jingchang", "经常"},
	{"jingcui", "精粹"},
	{"jingdi", "劲敌"},
	{"jingdian", "静电 经典"},
	{"jingdong", "惊动"},
	{"jingdu", "精度"},
	{"jingfei", "经费"},
	{"jinggan", "精干 竟敢"},
	{"jinggao", "警告"},
	{"jingguo", "经过"},
	{"jinghua", "净化 精华"},
	{"jingji", "经济 竞技 荆棘"},
	{"jingjian", "精简"},
	{"jingjie", "境界 警戒"},
	{"jingjiu", "经久"},
	{"jingkong", "惊恐"},
	{"jingli", "经历 精力 经理 敬礼"},
	{"jinglian", "精练"},
	{"jingliang", "精良"},
	{"jingluo", "经络"},
	{"jinglv", "劲旅"},
	{"jingmei", "精美"},
	{"jingmi", "精密"},
	{"jingming", "精明"},
	{"jingong", "进攻"},
	{"jingpei", "敬佩"},
	{"jingpi", "精辟"},
	{"jingqi", "景气 惊奇"},
	{"jingqiao", "精巧"},
	{"jingque", "精确"},
	{"jingran", "竟然"},
	{"jingsai", "竞赛"},
	{"jingse", "景色"},
	{"jingshang", "经商"},
	{"jingshen", "精神"},
	{"jingshou", "经手 经受"},
	{"jingsui", "精髓"},
	{"jingtai", "静态"},
	{"jingtan", "惊叹"},
	{"jingti", "晶体 警惕"},
	{"jingtong", "精通"},
	{"jingtou", "镜头"},
	{"jingu", "筋骨 禁锢"},
	{"jinguan", "尽管"},
	{"jinguo", "巾帼"},
	{"jingwei", "经委 警卫 敬畏"},
	{"jingwu", "景物"},
	{"jingxi", "精细 京戏"},
	{"jingxian", "惊险"},
	{"jingxiang", "景象"},
	{"jingxiao", "经销"},
	{"jingxin", "经心 精心 惊心"},
	{"jingxing", "惊醒"},
	{"jingxuan", "竞选"},
	{"jingya", "惊讶"},
	{"jingyan", "经验"},
	{"jingyang", "敬仰"},
	{"jingying", "经营 晶莹"},
	{"jingyou", "经由"},
	{"jingyu", "境遇"},
	{"jingzhan", "精湛"},
	{"jingzheng", "竞争"},
	{"jingzhi", "精制 径直 精致 静止 净值 竟址"},
	{"jingzhong", "净重"},
	{"jingzi", "镜子"},
	{"jingzuo", "静坐"},
	{"jinhai", "近海"},
	{"jinhou", "今后"},
	{"jinhu", "近乎"},
	{"jinhua", "进化"},
	{"jinian", "纪念 几年"},
	{"jinji", "晋级 紧急"},
	{"jinjiao", "近郊"},
	{"jinjin", "紧紧 仅仅"},
	{"jinjun", "进军"},
	{"jinkou", "进口"},
	{"jinkuai", "尽快"},
	{"jinkuang", "近况"},
	{"jinlai", "进来 近来"},
	{"jinli", "尽力"},
	{"jinliang", "尽量 斤两"},
	{"jinling", "禁令"},
	{"jinmi", "紧密"},
	{"jinnian", "近年 今年"},
	{"jinpai", "金牌"},
	{"jinpo", "紧迫"},
	{"jinqi", "近期"},
	{"jinqian", "近前 金钱"},
	{"jinqing", "尽情"},
	{"jinqu", "进去 进取 禁区"},
	{"jinri", "近日 今日"},
	{"jinrong", "金融"},
	{"jinru", "进入 浸入"},
	{"jinshen", "谨慎"},
	{"jinsheng", "晋升"},
	{"jinshi", "今是 尽是 近视"},
	{"jinshu", "金属"},
	{"jinsi", "近似"},
	{"jinsuo", "紧缩"},
	{"jintian", "今天"},
	{"jintie", "津贴"},
	{"jintou", "尽头 劲头 浸透"},
	{"jintui", "进退"},
	{"jinwan", "今晚"},
	{"jinxi", "今昔"},
	{"jinxin", "尽心"},
	{"jinxing", "进行"},
	{"jinxiu", "进修 锦秀"},
	{"jinyan", "谨严"},
	{"jinyao", "紧要"},
	{"jinzhan", "进展"},
	{"jinzhang", "紧张"},
	{"jinzhao", "今朝"},
	{"jinzhe", "紧着"},
	{"jinzhi", "禁止 尽职"},
	{"jinzhu", "进驻"},
	{"jinzi", "金子"},
	{"jiongpo", "窘迫"},
	{"jiongran", "迥然"},
	{"jipo", "击破 急迫"},
	{"jiqi", "及其 极其 激起 机器"},
	{"jiqiang", "机枪"},
	{"jiqiao", "技巧"},
	{"jiqie", "急切"},
	{"jiqing", "激情"},
	{"jiqu", "汲取"},
	{"jiquan", "集权"},
	{"jiran", "既然"},
	{"jiren", "己任 继任"},
	{"jiri", "即日 吉日"},
	{"jirou", "肌肉"},
	{"jishao", "极少"},
	{"jisheng", "寄生"},
	{"jishi", "即是 及时 几时 计时 即时 即使 记事 基石 集市"},
	{"jishu", "级数 基数 计数 记述 技术"},
	{"jisi", "祭祀"},
	{"jisu", "激素 急速"},
	{"jisuan", "计算"},
	{"jiti", "机体 集体 肌体"},
	{"jitian", "几天"},
	{"jituan", "集团"},
	{"jituo", "寄托"},
	{"jiucan", "就餐"},
	{"jiucha", "纠察"},
	{"jiuchan", "纠缠"},
	{"jiuci", "就此"},
	{"jiudi", "就地"},
	{"jiufan", "就范"},
	{"jiufen", "纠纷"},
	{"jiuge", "纠葛"},
	{"jiuguo", "救国"},
	{"jiuhe", "纠合"},
	{"jiuhu", "救护"},
	{"jiuhui", "就会 酒会"},
	{"jiuhuo", "救火"},
	{"jiuji", "救济 救急 纠集 鸠集"},
	{"jiujiang", "九江"},
	{"jiujie", "九届"},
	{"jiujin", "就近"},
	{"jiujing", "酒精 究竟"},
	{"jiuming", "救命"},
	{"jiusheng", "救生"},
	{"jiushi", "就是 就事"},
	{"jiuwang", "救亡"},
	{"jiuwei", "久违"},
	{"jiuwo", "酒窝"},
	{"jiuxi", "酒席"},
	{"jiuxian", "救险"},
	{"jiuxin", "揪心"},
	{"jiuxing", "救星"},
	{"jiuxu", "就绪"},
	{"jiuxue", "就学"},
	{"jiuyang", "久仰"},
	{"jiuyao", "就要"},
	{"jiuye", "就业"},
	{"jiuyuan", "久远"},
	{"jiuyue", "九月"},
	{"jiuzai", "救灾"},
	{"jiuzheng", "纠正"},
	{"jiuzhi", "就职 救治"},
	{"jiuzhou", "九洲"},
	{"jiuzhu", "救助"},
	{"jiuzuo", "就座"},
	{"jiwei", "极为 纪委"},
	{"jixian", "极限"},
	{"jixiang", "迹象 吉祥"},
	{"jixiao", "讥笑"},
	{"jixie", "机械"},
	{"jixing", "记性 急性 畸形 即兴"},
	{"jixiong", "吉凶"},
	{"jixu", "继续 积蓄 记叙 急需 几许"},
	{"jixun", "集训"},
	{"jiya", "积压 羁押"},
	{"jiyang", "给养"},
	{"jiyao", "机要 纪要"},
	{"jiyi", "给以 记忆 技艺"},
	{"jiyin", "基因"},
	{"jiyong", "急用"},
	{"jiyu", "基于 急于 机遇 给予 寄予 觊觎"},
	{"jiyuan", "纪元"},
	{"jiyue", "集约"},
	{"jizai", "记载"},
	{"jizao", "及早 急躁"},
	{"jizeng", "激增"},
	{"jizhang", "记帐"},
	{"jizhe", "记者"},
	{"jizhen", "集镇"},
	{"jizhi", "机制 及至 机智"},
	{"jizhong", "集中 击中"},
	{"jizhu", "记住"},
	{"jizhun", "基准"},
	{"jizi", "集资"},
	{"jjhs", "经济核算 聚精会神"},
	{"jjjj", "将计就计"},
	{"jjjz", "戒骄戒躁"},
	{"jjnl", "近几年来"},
	{"jjql", "竭尽全力"},
	{"jjr", "节假日"},
	{"jjx", "积极性"},
	{"jjxy", "经济效益"},
	{"jjyy", "兢兢业业"},
	{"jjzb", "精简整编"},
	{"jjzz", "叽叽喳喳"},
	{"jkfd", "艰苦奋斗"},
	{"jkn", "尽可能"},
	{"jks", "教科书"},
	{"jlb", "俱乐部"},
	{"jld", "交流电"},
	{"jls", "吉林省"},
	{"jlwm", "价廉物美"},
	{"jlx", "纪律性"},
	{"jnb", "纪念碑"},
	{"jnl", "几年来 近年来"},
	{"jnp", "纪念品"},
	{"jns", "济南市"},
	{"jpc", "吉普车"},
	{"jqbq", "坚强不屈"},
	{"jqfl", "奖勤罚懒"},
	{"jqr", "机器人"},
	{"jqzz", "急起直追"},
	{"jrbt", "截然不同"},
	{"jrx", "兼容性"},
	{"jscd", "积少成多"},
	{"jsgs", "金山公司"},
	{"jsgy", "集思广益"},
	{"jshf", "精神焕发"},
	{"jsj", "计算机"},
	{"jsjm", "尽善尽美"},
	{"jsmy", "集市贸易"},
	{"jsr", "介绍人"},
	{"jss", "就是说 计算所 江苏省"},
	{"jswm", "举世闻名"},
	{"jsx", "介绍信"},
	{"jsy", "技术员"},
	{"jsyy", "骄奢淫逸"},
	{"jszx", "计算中心"},
	{"jtb", "交通部"},
	{"jtcs", "家庭出身"},
	{"jtdd", "惊天动地"},
	{"jtds", "具体地说"},
	{"jtg", "晶体管"},
	{"jtgj", "交通工具"},
	{"jtsd", "脚踏实地"},
	{"jtsl", "具体说来"},
	{"juanjin", "卷进"},
	{"juankuan", "捐款"},
	{"juanlian", "眷恋"},
	{"juannian", "眷念"},
	{"juanqu", "捐躯"},
	{"juanru", "卷入"},
	{"juanshu", "眷属"},
	{"juanxian", "捐献"},
	{"juanyan", "卷烟"},
	{"juanzhi", "卷帙"},
	{"juanzhu", "捐助"},
	{"juanzong", "卷宗"},
	{"juban", "举办"},
	{"jubei", "具备"},
	{"juben", "剧本"},
	{"jubian", "巨变"},
	{"jubu", "局部 拘捕"},
	{"juchang", "剧场"},
	{"juci", "据此"},
	{"juda", "巨大"},
	{"judong", "举动"},
	{"juduo", "居多"},
	{"ju'e", "巨额"},
	{"juebie", "诀别"},
	{"juebu", "决不 绝不"},
	{"juece", "决策"},
	{"juecha", "觉察"},
	{"juede", "觉得"},
	{"jueding", "决定"},
	{"jueduan", "决断"},
	{"juedui", "绝对"},
	{"jueji", "绝迹"},
	{"juejiang", "倔强"},
	{"juejiao", "绝交"},
	{"juejing", "绝径 绝境"},
	{"jueju", "绝句"},
	{"juelie", "决裂"},
	{"juelu", "绝路"},
	{"juemi", "绝密"},
	{"juemiao", "绝妙"},
	{"jueqi", "崛起"},
	{"jueqiao", "诀窍"},
	{"juesai", "决赛"},
	{"jueshi", "绝食"},
	{"juesi", "决死"},
	{"juesuan", "决算"},
	{"juewang", "绝望"},
	{"juewei", "爵位"},
	{"juewu", "觉悟"},
	{"juexin", "决心"},
	{"juexing", "觉醒"},
	{"jueyi", "决议"},
	{"jueyuan", "绝缘"},
	{"jueze", "抉择"},
	{"juezhan", "决战"},
	{"juezhao", "绝招"},
	{"juezheng", "绝症"},
	{"jufu", "巨幅"},
	{"jugong", "居功 鞠躬"},
	{"juhao", "句号"},
	{"juhe", "聚合"},
	{"juhua", "句话"},
	{"juhui", "聚会"},
	{"juji", "聚集"},
	{"jujiang", "巨匠"},
	{"jujin", "拘谨"},
	{"jujue", "拒绝 咀嚼"},
	{"juli", "距离 举例"},
	{"julie", "剧烈"},
	{"juliu", "拘留"},
	{"jumian", "局面"},
	{"jumin", "居民"},
	{"jumu", "剧目"},
	{"juncao", "军操"},
	{"junchen", "君臣"},
	{"jundeng", "均等"},
	{"jundui", "军队"},
	{"junfa", "军法 军阀"},
	{"junfu", "军服"},
	{"jungang", "军港"},
	{"jungong", "军工 竣工"},
	{"junheng", "均衡"},
	{"junhuo", "军火"},
	{"juni", "拘泥"},
	{"junji", "军机 军纪"},
	{"junjian", "军舰"},
	{"junjie", "俊杰"},
	{"junken", "军垦"},
	{"junliang", "军粮"},
	{"junling", "军令"},
	{"junma", "骏马"},
	{"junmin", "军民"},
	{"junqi", "军旗"},
	{"junqiao", "峻峭 俊俏"},
	{"junqu", "军区"},
	{"junquan", "军权"},
	{"junren", "军人"},
	{"junshi", "军事 军师"},
	{"junshu", "军属"},
	{"juntuan", "军团"},
	{"junwei", "军委"},
	{"junxian", "军衔"},
	{"junxiao", "军校"},
	{"junxie", "军械"},
	{"junxin", "军心"},
	{"junxiu", "俊秀"},
	{"junxu", "军需"},
	{"junxun", "军训"},
	{"junyi", "军医"},
	{"junying", "军营"},
	{"junyong", "军用"},
	{"junyou", "军邮"},
	{"junyun", "均匀"},
	{"junzhang", "军长"},
	{"junzheng", "军政"},
	{"junzhu", "君主"},
	{"junzhuang", "军装"},
	{"junzi", "君子"},
	{"juquan", "俱全"},
	{"juran", "居然 遽然"},
	{"jusang", "沮丧"},
	{"jushi", "局势"},
	{"jushou", "举手"},
	{"jushu", "拘束"},
	{"jushuo", "据说"},
	{"juti", "具体"},
	{"jutuan", "剧团"},
	{"juxi", "据悉"},
	{"juxian", "局限"},
	{"juxin", "居心"},
	{"juxing", "举行 矩形 巨型"},
	{"juyou", "具有 据有"},
	{"juyuan", "剧院"},
	{"juzhang", "局长"},
	{"juzhao", "剧照"},
	{"juzhi", "举止"},
	{"juzhong", "居中 剧终"},
	{"juzhu", "巨著 居住"},
	{"juzi", "句子"},
	{"jwsz", "节外生枝"},
	{"jxdp", "惊心动魄"},
	{"jxgm", "继续革命"},
	{"jxh", "机械化"},
	{"jxs", "江西省"},
	{"jxsw", "谨小慎微"},
	{"jxx", "局限性"},
	{"jyb", "教育部 进一步"},
	{"jydq", "家用电器"},
	{"jyfz", "教育方针"},
	{"jyhx", "家喻户晓"},
	{"jyjj", "加以解决"},
	{"jyl", "记忆力"},
	{"jyqj", "精益求精"},
	{"jys", "教研室"},
	{"jyyw", "见义勇为"},
	{"jzg", "旧中国"},
	{"jzw", "建筑物"},
	{"kacha", "喀嚓"},
	{"kache", "卡车"},
	{"kafei", "咖啡"},
	{"kaiban", "开办"},
	{"kaibian", "开遍"},
	{"kaicai", "开采"},
	{"kaichang", "开场"},
	{"kaiche", "开车"},
	{"kaichu", "开除"},
	{"kaichuang", "开创"},
	{"kaidao", "开导 开刀"},
	{"kaidong", "开动"},
	{"kaiduan", "开端"},
	{"kaifa", "开发"},
	{"kaifang", "开放"},
	{"kaifeng", "开封"},
	{"kaifu", "开赴"},
	{"kaige", "凯歌"},
	{"kaiguan", "开关"},
	{"kaihang", "开航"},
	{"kaihu", "开户"},
	{"kaihua", "开花"},
	{"kaihuai", "开怀"},
	{"kaihuang", "开荒"},
	{"kaihui", "开会"},
	{"kaijue", "开掘"},
	{"kaiken", "开垦"},
	{"kaikou", "开口"},
	{"kaikuang", "开矿"},
	{"kaikuo", "开阔"},
	{"kailang", "开朗 开郎"},
	{"kailu", "开路"},
	{"kaiming", "开明"},
	{"kaimo", "楷模"},
	{"kaimu", "开幕"},
	{"kaipao", "开炮"},
	{"kaipi", "开辟"},
	{"kaiqi", "开启"},
	{"kaiqiang", "开枪"},
	{"kaiqiao", "开窍"},
	{"kaishe", "开设"},
	{"kaishi", "开始"},
	{"kaiting", "开庭"},
	{"kaitou", "开头"},
	{"kaituo", "开脱 开拓"},
	{"kaiwai", "开外"},
	{"kaixiao", "开销"},
	{"kaixin", "开心"},
	{"kaixuan", "凯旋"},
	{"kaixue", "开学"},
	{"kaiyan", "开颜"},
	{"kaiye", "开业"},
	{"kaizhan", "开战 开展"},
	{"kaizhang", "开张"},
	{"kaizhi", "开支"},
	{"kance", "勘测"},
	{"kancha", "勘察"},
	{"kanchu", "看出"},
	{"kandai", "看待"},
	{"kandao", "看到"},
	{"kandeng", "刊登"},
	{"kanfa", "看法 砍伐"},
	{"kangfen", "亢奋"},
	{"kangfu", "康复"},
	{"kangheng", "抗衡"},
	{"kangji", "抗击"},
	{"kangjin", "亢进"},
	{"kangju", "抗拒"},
	{"kangli", "伉俪"},
	{"kangri", "抗日"},
	{"kanguan", "看管"},
	{"kangyi", "抗议"},
	{"kanjian", "看见"},
	{"kanke", "坎坷"},
	{"kanlai", "看来"},
	{"kanqi", "看齐"},
	{"kantou", "刊头"},
	{"kanwang", "看望"},
	{"kanwu", "刊物 勘误"},
	{"kanyang", "看样"},
	{"kanzai", "刊载"},
	{"kanzhe", "看着"},
	{"kaobei", "拷贝"},
	{"kaobian", "靠边"},
	{"kaocha", "考查 考察"},
	{"kaohe", "考核"},
	{"kaojin", "靠近"},
	{"kaojiu", "考究"},
	{"kaolong", "靠拢"},
	{"kaolv", "考虑"},
	{"kaoqin", "考勤"},
	{"kaoshan", "靠山"},
	{"kaoshi", "考试"},
	{"kaoti", "考题"},
	{"kaoyan", "考验"},
	{"kaozheng", "考证"},
	{"kapian", "卡片"},
	{"kbg", "看不惯"},
	{"kbq", "看不起"},
	{"kbrh", "刻不容缓"},
	{"kcbg", "开诚布公"},
	{"kczy", "矿产资源"},
	{"kdh", "扩大化"},
	{"keai", "可爱"},
	{"keban", "科班"},
	{"keben", "课本"},
	{"kebi", "可比"},
	{"kebo", "刻薄"},
	{"kebu", "可不"},
	{"keche", "客车"},
	{"kecheng", "课程"},
	{"kechi", "可耻"},
	{"kefeng", "可风"},
	{"kefou", "可否"},
	{"kefu", "克服"},
	{"keguan", "可观 客观"},
	{"kegui", "可贵"},
	{"kehao", "可好"},
	{"kehen", "可恨"},
	{"kehua", "刻画"},
	{"keji", "克己 客机 科技"},
	{"kejian", "可见"},
	{"kejiao", "科教"},
	{"kejing", "可敬"},
	{"kejiu", "窠臼"},
	{"keju", "科举"},
	{"kekao", "可靠"},
	{"keke", "苛刻"},
	{"kekou", "可口 克扣"},
	{"keku", "刻苦"},
	{"kela", "克拉"},
	{"kelang", "克朗"},
	{"keli", "颗粒"},
	{"kelian", "可怜"},
	{"kemu", "科目"},
	{"kending", "肯定"},
	{"keneng", "可能"},
	{"kengdao", "坑道"},
	{"kenghai", "坑害"},
	{"kengqiang", "铿锵"},
	{"kenqie", "恳切"},
	{"kenqiu", "恳求"},
	{"kenzhi", "垦殖"},
	{"kepa", "可怕"},
	{"kepeng", "磕碰"},
	{"kepu", "科普"},
	{"keqi", "客气 克期"},
	{"keqin", "可亲"},
	{"kequ", "可取"},
	{"keren", "客人"},
	{"keri", "克日"},
	{"keshang", "客商"},
	{"keshi", "可是 科室"},
	{"ketang", "课堂"},
	{"ketao", "客套"},
	{"keti", "课题 客体"},
	{"keting", "客厅"},
	{"ketou", "磕头"},
	{"kewang", "渴望"},
	{"kewu", "可恶"},
	{"kexi", "可惜"},
	{"kexiao", "可笑"},
	{"kexing", "可行"},
	{"kexue", "科学"},
	{"keyan", "科研"},
	{"keyi", "可以 可疑 刻意"},
	{"keyuan", "科员"},
	{"kezhang", "科长"},
	{"kezhi", "克制 可知"},
	{"kfby", "狂风暴雨"},
	{"kjfg", "克己奉公"},
	{"kjs", "科技司"},
	{"kkpx", "苦口婆心"},
	{"kms", "昆明市"},
	{"knx", "可能性"},
	{"kongbai", "空白"},
	{"kongbu", "恐怖"},
	{"kongchai", "控拆"},
	{"kongdong", "空洞"},
	{"konge", "空额"},
	{"kongfa", "空乏"},
	{"konggao", "控告"},
	{"konghan", "空喊"},
	{"konghe", "恐吓"},
	{"konghua", "空话"},
	{"konghuang", "恐慌"},
	{"kongjian", "空间"},
	{"kongjiang", "空降"},
	{"kongju", "恐惧"},
	{"kongjun", "空军"},
	{"kongkuang", "空旷"},
	{"konglong", "恐龙"},
	{"kongpa", "恐怕"},
	{"kongqi", "空气"},
	{"kongqian", "空前"},
	{"kongque", "孔雀"},
	{"kongsu", "控诉"},
	{"kongtan", "空谈"},
	{"kongtou", "空头"},
	{"kongwen", "空文"},
	{"kongxi", "空隙"},
	{"kongxian", "空闲"},
	{"kongxiang", "空想"},
	{"kongxu", "空虚"},
	{"kongyun", "空运"},
	{"kongzhi", "控制"},
	{"kongzhong", "空中"},
	{"kouan", "口岸"},
	{"koubai", "叩拜"},
	{"koucai", "口才"},
	{"kouchu", "扣除"},
	{"kouchuan", "口传"},
	{"koufu", "口服"},
	{"kougong", "口供"},
	{"kouhao", "口号"},
	{"kouhong", "口红"},
	{"koujiao", "口角"},
	{"koujing", "口径"},
	{"koujue", "口诀"},
	{"kouling", "口令"},
	{"kouliu", "扣留"},
	{"kouqi", "口气"},
	{"kouqiang", "口腔"},
	{"koushao", "口哨"},
	{"koushi", "口试"},
	{"koushu", "口述"},
	{"koutou", "口头 叩头"},
	{"kouxin", "口信"},
	{"kouya", "扣押"},
	{"kouyu", "口语"},
	{"kql", "看起来"},
	{"krxh", "口若悬河"},
	{"ksxf", "口是心非"},
	{"kuabu", "跨步"},
	{"kuada", "夸大"},
	{"kuadu", "跨度"},
	{"kuaiji", "会计"},
	{"kuaile", "快乐"},
	{"kuaisu", "快速"},
	{"kuanchang", "宽敞"},
	{"kuanchuo", "宽绰"},
	{"kuanda", "宽大"},
	{"kuandai", "宽待 款待"},
	{"kuandu", "宽度"},
	{"kuangcang", "矿藏"},
	{"kuangchan", "矿产"},
	{"kuangfeng", "狂风"},
	{"kuanggong", "矿工 旷工"},
	{"kuangjing", "矿井"},
	{"kuangkuang", "框框"},
	{"kuanglang", "哐啷"},
	{"kuangqie", "况且"},
	{"kuangqu", "矿区"},
	{"kuangquan", "矿泉"},
	{"kuangre", "狂热"},
	{"kuangshan", "矿山"},
	{"kuangshi", "矿石"},
	{"kuangtu", "框图"},
	{"kuanguang", "宽广"},
	{"kuangwang", "狂妄"},
	{"kuangwu", "矿物"},
	{"kuangye", "旷野"},
	{"kuanhong", "宽宏"},
	{"kuanhou", "宽厚"},
	{"kuankuo", "宽阔"},
	{"kuanrong", "宽容"},
	{"kuanshi", "款式"},
	{"kuanshu", "宽恕"},
	{"kuanxiang", "款项"},
	{"kuanxin", "宽心"},
	{"kuanyu", "宽裕"},
	{"kuatai", "垮台"},
	{"kuayue", "跨越"},
	{"kuazhang", "夸张"},
	{"kucha", "裤衩"},
	{"kucun", "库存"},
	{"kuhan", "哭喊"},
	{"kuiben", "亏本"},
	{"kuice", "窥测"},
	{"kuidai", "亏待"},
	{"kuijiu", "愧疚"},
	{"kuikong", "亏空"},
	{"kuisun", "亏损"},
	{"kuiwu", "魁梧"},
	{"kuiyang", "溃疡"},
	{"kujie", "枯竭"},
	{"kulun", "库仑"},
	{"kumen", "苦闷"},
	{"kumu", "枯木"},
	{"kunan", "苦难"},
	{"kunao", "苦恼"},
	{"kune", "困厄"},
	{"kunfa", "困乏"},
	{"kunhuo", "困惑"},
	{"kunjing", "困境"},
	{"kunku", "困苦"},
	{"kunming", "昆明"},
	{"kunnan", "困难"},
	{"kuobie", "阔别"},
	{"kuochong", "扩充"},
	{"kuochuo", "阔绰"},
	{"kuoda", "扩大"},
	{"kuohao", "括号"},
	{"kuojian", "扩建"},
	{"kuolao", "阔佬"},
	{"kuoqi", "阔气"},
	{"kuozhan", "扩展"},
	{"kuozhang", "扩张"},
	{"kuqi", "哭泣"},
	{"kushu", "酷暑"},
	{"kutou", "苦头"},
	{"kuwei", "苦维 枯萎"},
	{"kuxing", "酷刑"},
	{"kuyu", "苦于"},
	{"kuzao", "枯燥"},
	{"kxez", "可想而知"},
	{"kxj", "科学家"},
	{"kxjs", "科学技术"},
	{"kxx", "可行性"},
	{"kxy", "科学院"},
	{"kyb", "科研部"},
	{"kyjl", "开源节流"},
	{"kyz", "看样子"},
	{"laba", "喇叭"},
	{"laibin", "来宾"},
	{"laidao", "来到"},
	{"laifan", "来犯"},
	{"laifang", "来访"},
	{"laihan", "来函"},
	{"laihui", "来回"},
	{"laili", "来历"},
	{"lailin", "来临"},
	{"laipi", "赖皮"},
	{"lairi", "来日"},
	{"laishi", "来势"},
	{"laitou", "来头"},
	{"laiwang", "来往"},
	{"laixin", "来信"},
	{"laiyuan", "来源"},
	{"laizhe", "来者"},
	{"laizi", "来自 癞子"},
	{"lajiao", "辣椒"},
	{"lalong", "拉拢"},
	{"lama", "喇嘛"},
	{"lamei", "腊梅"},
	{"lanben", "蓝本"},
	{"landai", "懒怠"},
	{"landiao", "滥调"},
	{"landuo", "懒惰"},
	{"langan", "栏杆"},
	{"langbei", "狼狈"},
	{"langchao", "浪潮"},
	{"langdang", "浪荡"},
	{"langdu", "朗读"},
	{"langfei", "浪费"},
	{"langji", "狼藉"},
	{"langman", "浪漫"},
	{"langsong", "朗诵"},
	{"langtou", "浪头 榔头"},
	{"langzhong", "郎中"},
	{"lanhua", "兰花"},
	{"lanjie", "拦截"},
	{"lanlv", "褴褛"},
	{"lanman", "烂漫"},
	{"lansan", "懒散"},
	{"lanse", "蓝色"},
	{"lansheng", "缆绳"},
	{"lanshu", "烂熟"},
	{"lantian", "蓝天"},
	{"lantu", "蓝图"},
	{"lanwei", "阑尾"},
	{"lanyao", "拦腰"},
	{"lanyong", "滥用"},
	{"lanzhou", "兰州"},
	{"laoban", "老板 老伴"},
	{"laoben", "老本"},
	{"laodong", "劳动"},
	{"laogong", "老公"},
	{"laogu", "牢固"},
	{"laohan", "老汉"},
	{"laohua", "老化"},
	{"laoji", "牢记"},
	{"laojia", "劳驾"},
	{"laokao", "牢靠"},
	{"laoku", "劳苦"},
	{"laolao", "牢牢"},
	{"laolei", "劳累"},
	{"laoli", "劳力"},
	{"laolian", "老练"},
	{"laolong", "牢笼"},
	{"laomo", "劳模"},
	{"laonian", "老年"},
	{"laopo", "老婆"},
	{"laoren", "老人"},
	{"laosao", "牢骚"},
	{"laoshao", "老少"},
	{"laoshi", "老实 老师 老是"},
	{"laoxiang", "老乡"},
	{"laoye", "老爷"},
	{"laoyin", "烙印"},
	{"laozhi", "劳支"},
	{"laozi", "劳资"},
	{"laozuo", "劳作"},
	{"layue", "腊月"},
	{"lbbk", "狼狈不堪"},
	{"lbcx", "力不从心"},
	{"lbj", "来不及"},
	{"lbl", "来不了"},
	{"lbq", "了不起"},
	{"ldbx", "劳动保险"},
	{"ldj", "来得及"},
	{"ldl", "劳动量 劳动力"},
	{"ldmy", "灵丹妙药"},
	{"ldmz", "拉丁美洲"},
	{"ldz", "劳动者"},
	{"ldzf", "劳动致富"},
	{"leguan", "乐观"},
	{"leibie", "类别"},
	{"leici", "类次"},
	{"leida", "雷达"},
	{"leiguan", "雷管"},
	{"leihen", "泪痕"},
	{"leihua", "泪花"},
	{"leiji", "累积 累计"},
	{"leijin", "累进"},
	{"leiluo", "磊落"},
	{"leinian", "累年"},
	{"leisi", "类似"},
	{"leitai", "擂台"},
	{"leitong", "雷同"},
	{"leitui", "类推"},
	{"leixing", "类型"},
	{"leiyu", "雷雨"},
	{"leiyue", "累月"},
	{"leizhui", "累赘"},
	{"leling", "勒令"},
	{"lengcang", "冷藏"},
	{"lengdan", "冷淡"},
	{"lenggong", "冷宫"},
	{"lengjiao", "棱角"},
	{"lengjing", "冷静"},
	{"lengluo", "冷落"},
	{"lengmen", "冷门"},
	{"lengmo", "冷漠"},
	{"lengnuan", "冷暖"},
	{"lengpi", "冷僻"},
	{"lengqi", "冷气"},
	{"lengque", "冷却"},
	{"lengshui", "冷水"},
	{"lengyu", "冷遇"},
	{"lequ", "乐趣"},
	{"lesuo", "勒索"},
	{"leyi", "乐意"},
	{"leyuan", "乐园"},
	{"lgx", "拉关系"},
	{"lhg", "联合国"},
	{"lhh", "联合会"},
	{"lhn", "氯化钠"},
	{"lhq", "氯化氢"},
	{"lhs", "两回事"},
	{"lht", "联合体"},
	{"li'an", "立案"},
	{"lianai", "恋爱"},
	{"lianbang", "联邦"},
	{"lianbing", "练兵"},
	{"lianbo", "联播"},
	{"lianda", "练达"},
	{"liandui", "连队"},
	{"liangang", "炼钢"},
	{"liangban", "两半"},
	{"liangbian", "量变 两边 两便"},
	{"liangce", "两侧"},
	{"liangci", "两次"},
	{"liangdi", "两地"},
	{"liangdu", "量度"},
	{"liangfang", "良方"},
	{"liangguang", "两广"},
	{"lianghao", "良好"},
	{"liangji", "两极 良机"},
	{"liangjie", "谅解"},
	{"liangju", "量具"},
	{"liangkuai", "凉快"},
	{"liangli", "两立"},
	{"liangmian", "两面"},
	{"liangong", "练功"},
	{"liangqi", "两栖 两讫"},
	{"liangqiang", "踉跄"},
	{"liangquan", "两全"},
	{"liangshi", "粮食"},
	{"liangshou", "两手"},
	{"liangshuang", "凉爽"},
	{"liangtang", "亮堂"},
	{"liangtou", "两头"},
	{"lianguan", "连贯"},
	{"liangxiang", "亮相"},
	{"liangxin", "良心"},
	{"liangxing", "两性 量刑"},
	{"liangyang", "两样"},
	{"liangyou", "粮油"},
	{"liangyuan", "良缘"},
	{"liangzhan", "粮站"},
	{"liangzhe", "两者"},
	{"liangzhong", "两重 良种"},
	{"liangzi", "量子"},
	{"lianhe", "联合"},
	{"lianhuan", "联欢"},
	{"lianjia", "廉价"},
	{"lianjie", "连接 联结 廉洁"},
	{"lianjun", "联军"},
	{"lianlei", "连累"},
	{"lianluo", "联络"},
	{"lianmang", "连忙"},
	{"lianmei", "联袂"},
	{"lianmeng", "联盟"},
	{"lianmian", "连绵"},
	{"lianmin", "怜悯"},
	{"liannian", "连年"},
	{"lianpian", "联翩"},
	{"lianpu", "脸谱"},
	{"lianri", "连日"},
	{"lianru", "炼乳"},
	{"liansai", "联赛"},
	{"lianse", "脸色"},
	{"liansuo", "连锁"},
	{"lianwu", "练武"},
	{"lianxi", "联系 练习 怜惜"},
	{"lianxiang", "联想"},
	{"lianxu", "连续"},
	{"lianyi", "涟漪"},
	{"lianyin", "联姻"},
	{"lianying", "联营"},
	{"lianyou", "炼油"},
	{"lianyun", "联运"},
	{"lianzai", "连载"},
	{"lianzhui", "连缀"},
	{"liaobo", "撩拨"},
	{"liaocao", "潦草"},
	{"liaocheng", "疗程"},
	{"liaodao", "料到 潦倒"},
	{"liaoding", "料定"},
	{"liaojie", "了解"},
	{"liaokuo", "辽阔"},
	{"liaoli", "料理"},
	{"liaoliang", "嘹亮"},
	{"liaoliao", "寥寥"},
	{"liaoluan", "缭乱"},
	{"liaoluo", "寥落"},
	{"liaoning", "辽宁"},
	{"liaoque", "了却"},
	{"liaoshi", "了事"},
	{"liaotian", "聊天"},
	{"liaoxiang", "料想"},
	{"liaoyang", "疗养"},
	{"liba", "篱笆"},
	{"libai", "礼拜"},
	{"libi", "利弊"},
	{"libian", "里边"},
	{"licai", "理财 理睬"},
	{"lichang", "立场"},
	{"licheng", "里程 历程"},
	{"lichun", "立春"},
	{"lici", "历次"},
	{"lidai", "历代"},
	{"lidang", "理当"},
	{"lidong", "立冬"},
	{"liebian", "裂变"},
	{"lieche", "列车"},
	{"liechu", "列出"},
	{"liedao", "列岛"},
	{"liefeng", "裂缝"},
	{"lieguo", "列国"},
	{"liehuo", "烈火"},
	{"lieji", "劣迹"},
	{"lieju", "列举"},
	{"liekai", "裂开"},
	{"liekou", "裂口"},
	{"liening", "列宁"},
	{"lieqi", "猎奇"},
	{"lieqiang", "列强"},
	{"liequ", "猎取"},
	{"lieri", "烈日"},
	{"lieru", "列入"},
	{"lieshen", "劣绅"},
	{"lieshi", "烈士 劣势"},
	{"lieshu", "烈属"},
	{"liewen", "裂纹"},
	{"liexi", "列席"},
	{"liexing", "烈性"},
	{"lifa", "立法"},
	{"lifang", "立方"},
	{"lifu", "礼服"},
	{"ligong", "立功"},
	{"lihai", "厉害 利害"},
	{"lihei", "黧黑"},
	{"lihua", "理化 礼花"},
	{"lihui", "理会"},
	{"lihun", "离婚"},
	{"liji", "立即"},
	{"lijie", "理解 礼节 历届"},
	{"liju", "力矩"},
	{"likai", "离开"},
	{"like", "立刻 理科"},
	{"likui", "理亏"},
	{"lilai", "历来"},
	{"lili", "历历"},
	{"liliang", "力量"},
	{"lilun", "理论 立论"},
	{"lilv", "利率"},
	{"limao", "礼貌"},
	{"limian", "里面"},
	{"limin", "利民 黎民"},
	{"liming", "黎明"},
	{"linba", "淋巴"},
	{"linbie", "临别"},
	{"linbing", "淋病"},
	{"linchang", "林场"},
	{"linchuang", "临床"},
	{"lindao", "临到"},
	{"lingai", "令爱"},
	{"lingchen", "凌晨"},
	{"lingdan", "灵丹"},
	{"lingdao", "领导"},
	{"lingdi", "领地"},
	{"lingdian", "零点"},
	{"lingding", "伶仃"},
	{"lingdui", "领队"},
	{"linggan", "灵感"},
	{"linghai", "领海"},
	{"linghang", "领航"},
	{"linghui", "领会"},
	{"linghun", "灵魂"},
	{"linghuo", "灵活"},
	{"lingji", "灵机"},
	{"lingjian", "零件"},
	{"lingjiao", "领教"},
	{"lingjie", "灵杰"},
	{"lingkong", "领空 凌空"},
	{"linglong", "玲珑"},
	{"lingluan", "零乱 凌乱"},
	{"linglue", "领略"},
	{"lingmin", "灵敏"},
	{"lingmu", "陵墓"},
	{"lingqiao", "灵巧"},
	{"lingqu", "领取"},
	{"lingren", "令人"},
	{"lingru", "凌辱"},
	{"lingsan", "零散"},
	{"lingshi", "领事"},
	{"lingshou", "领受"},
	{"lingsi", "领司"},
	{"lingsui", "零碎"},
	{"lingtang", "灵堂"},
	{"lingtou", "零头"},
	{"lingtu", "领土"},
	{"linguang", "磷光"},
	{"lingwai", "另外"},
	{"lingwu", "领悟"},
	{"lingxian", "领先 领衔"},
	{"lingxing", "零星"},
	{"lingxiu", "领袖"},
	{"lingxuan", "另选"},
	{"lingyan", "灵验"},
	{"lingyu", "领域 囹圄"},
	{"lingzun", "令尊"},
	{"linhuo", "磷火"},
	{"linian", "历年"},
	{"linjie", "临界"},
	{"linjin", "临近 邻近"},
	{"linli", "邻里 淋漓"},
	{"linlie", "凛冽"},
	{"linmo", "临摹"},
	{"linong", "里弄"},
	{"linshang", "鳞伤"},
	{"linshi", "临时"},
	{"linsi", "临死"},
	{"linxi", "吝惜"},
	{"linxing", "临行"},
	{"linye", "林业"},
	{"linzhan", "临战"},
	{"linzhong", "临终"},
	{"lipao", "礼炮"},
	{"lipeng", "李鹏"},
	{"lipin", "礼品"},
	{"liqi", "力气 离奇"},
	{"liqiu", "力求 立秋"},
	{"liren", "历任"},
	{"liru", "例如"},
	{"lirun", "利润"},
	{"lisan", "离散"},
	{"lishi", "理事 历史"},
	{"lishu", "隶属"},
	{"litang", "礼堂"},
	{"liti", "立体 例题"},
	{"litu", "力图"},
	{"liubu", "留步"},
	{"liuchan", "流产"},
	{"liuchang", "流畅"},
	{"liucheng", "流程"},
	{"liuchuan", "流传"},
	{"liucuan", "流窜"},
	{"liuda", "溜达"},
	{"liudong", "流动"},
	{"liudu", "流毒"},
	{"liufang", "流放"},
	{"liujie", "六届"},
	{"liulan", "浏览"},
	{"liuli", "流利"},
	{"liulian", "留恋 流连"},
	{"liulu", "流露"},
	{"liuluo", "流落"},
	{"liumang", "流氓"},
	{"liunian", "留念"},
	{"liushi", "流失 流逝"},
	{"liuti", "流体"},
	{"liutong", "流通"},
	{"liuwang", "流亡"},
	{"liuxie", "流泻"},
	{"liuxin", "留心"},
	{"liuxing", "流行 流星"},
	{"liuxue", "留学 流血"},
	{"liuyan", "流言 留言"},
	{"liuyang", "留洋"},
	{"liuying", "留影"},
	{"liuyong", "留用"},
	{"liuyu", "流域"},
	{"liuyue", "六月"},
	{"liuzhuan", "流转"},
	{"liwai", "例外"},
	{"liwu", "礼物"},
	{"lixi", "利息"},
	{"lixia", "立夏"},
	{"lixiang", "理想"},
	{"lixin", "立新 离心"},
	{"lixing", "理性 力行 厉行"},
	{"lixiu", "离休"},
	{"liyi", "立意 利益 离异"},
	{"liyong", "利用"},
	{"liyou", "理由"},
	{"lizheng", "力争 立正"},
	{"lizhi", "理智 立志 离职"},
	{"lizi", "例子 粒子"},
	{"lizu", "立足"},
	{"ljbx", "屡见不鲜"},
	{"ljfh", "两极分化"},
	{"ljsj", "逻辑设计"},
	{"ljsw", "逻辑思维"},
	{"ljx", "逻辑性"},
	{"ljyd", "灵机一动"},
	{"lldf", "落落大方"},
	{"llh", "拦路虎"},
	{"llqm", "来龙去脉"},
	{"llss", "零零碎碎"},
	{"llww", "来来往往"},
	{"lmbd", "联绵不断"},
	{"lmd", "灵敏度"},
	{"lns", "辽宁省"},
	{"lnzy", "列宁主义"},
	{"longdong", "隆冬"},
	{"longduan", "垄断"},
	{"longlong", "隆隆"},
	{"longluo", "笼络"},
	{"longtong", "笼统"},
	{"longzhao", "笼罩"},
	{"longzhong", "隆重"},
	{"loudong", "漏洞"},
	{"loudou", "漏斗"},
	{"loukong", "镂空"},
	{"louluo", "喽啰"},
	{"louwang", "漏网"},
	{"lrfc", "来日方长"},
	{"lrlh", "来人来函"},
	{"lrzz", "了如指掌"},
	{"lsdr", "理所当然"},
	{"lsfy", "连锁反应"},
	{"lsg", "领事馆"},
	{"lsh", "理事会"},
	{"lshz", "络腮胡子"},
	{"lsnj", "力所能及"},
	{"lss", "拉萨市"},
	{"lsx", "流水线"},
	{"lsyy", "良师益友"},
	{"luanchao", "卵巢"},
	{"luanlun", "乱伦"},
	{"luanzi", "乱子"},
	{"lubiao", "路标"},
	{"lucheng", "路程"},
	{"luchu", "露出"},
	{"ludi", "陆地 露底"},
	{"lueduo", "掠夺"},
	{"lugu", "露骨"},
	{"luguo", "路过"},
	{"luhuo", "炉火"},
	{"lujing", "路径"},
	{"luju", "路局"},
	{"lujun", "陆军"},
	{"lumang", "鲁莽"},
	{"lumian", "露面"},
	{"lunchu", "论处"},
	{"lunchuan", "轮船"},
	{"lundian", "论点"},
	{"lundiao", "论调"},
	{"lundun", "伦敦"},
	{"lunhuan", "轮换"},
	{"lunju", "论据"},
	{"lunkuo", "轮廓"},
	{"lunli", "论理 伦理"},
	{"lunliu", "轮流"},
	{"lunshu", "论述"},
	{"luntai", "轮胎"},
	{"luntan", "论坛"},
	{"lunwei", "沦为"},
	{"lunwen", "论文"},
	{"lunxian", "沦陷"},
	{"lunxun", "轮训"},
	{"lunzhan", "论战"},
	{"lunzheng", "论正 论证"},
	{"lunzhou", "轮轴"},
	{"lunzhu", "论著"},
	{"luobo", "萝卜"},
	{"luocheng", "落成"},
	{"luoding", "螺钉"},
	{"luohan", "罗汉"},
	{"luohou", "落后"},
	{"luohu", "落户"},
	{"luoji", "逻辑"},
	{"luokong", "落空"},
	{"luokuan", "落款"},
	{"luokuang", "箩筐"},
	{"luolie", "罗列"},
	{"luoma", "罗马"},
	{"luomo", "落寞"},
	{"luomu", "螺母"},
	{"luopan", "罗盘"},
	{"luopo", "落泊"},
	{"luoshi", "落实"},
	{"luoshuan", "螺栓"},
	{"luoti", "裸体"},
	{"luotuo", "骆驼"},
	{"luowang", "罗网"},
	{"luowen", "螺纹"},
	{"luowu", "落伍"},
	{"luoxuan", "落选 螺旋"},
	{"luoyi", "络绎"},
	{"luqu", "录取"},
	{"luren", "路人"},
	{"lushan", "庐山"},
	{"lutian", "露天"},
	{"lutu", "路途"},
	{"luxian", "路线"},
	{"luxiang", "录像"},
	{"luxu", "陆续"},
	{"luyin", "录音"},
	{"luyong", "录用"},
	{"luzhu", "露珠"},
	{"luzi", "路子 炉子"},
	{"lvban", "旅伴"},
	{"lvcheng", "旅程"},
	{"lvci", "屡次"},
	{"lvdian", "旅店"},
	{"lvfei", "旅费"},
	{"lvguan", "旅馆"},
	{"lvhua", "绿化"},
	{"lvke", "旅客"},
	{"lvli", "履历"},
	{"lvse", "绿色"},
	{"lvshe", "旅社"},
	{"lvshi", "律师"},
	{"lvtu", "旅途"},
	{"lvxing", "旅行 履行"},
	{"lvyin", "绿荫"},
	{"lvyou", "旅游"},
	{"lvzhou", "绿洲"},
	{"lxap", "另行安排"},
	{"lxgs", "例行公事"},
	{"lxr", "联系人"},
	{"lxs", "留学生"},
	{"lxtz", "另行通知"},
	{"lxxh", "良性循环"},
	{"lyb", "林业部 老一辈"},
	{"lyfm", "另一方面"},
	{"lyjh", "劳逸结合"},
	{"lyl", "利用率"},
	{"lyt", "老一套"},
	{"lyyd", "留有余地"},
	{"lzbj", "来者不拒"},
	{"lzd", "立足点"},
	{"lzq", "老中青"},
	{"lzqz", "理直气壮"},
	{"lzs", "兰州市"},
	{"lzx", "两重性"},
	{"lyz", "老样子"},
	{"maan", "马鞍"},
	{"mabi", "麻痹"},
	{"mada", "马达"},
	{"mafan", "麻烦"},
	{"mafang", "麻纺"},
	{"mafeng", "麻风 马蜂"},
	{"mahu", "马虎"},
	{"maiban", "买办"},
	{"maibo", "脉搏"},
	{"maibu", "迈步"},
	{"maicang", "埋藏"},
	{"maichong", "脉冲"},
	{"maidong", "脉动"},
	{"maifu", "埋伏"},
	{"maiguo", "卖国"},
	{"mailuo", "脉络"},
	{"maimai", "买卖"},
	{"maiming", "卖命"},
	{"maimo", "埋没"},
	{"mainong", "卖弄"},
	{"maitou", "埋头"},
	{"maiyin", "卖淫"},
	{"maiyuan", "埋怨"},
	{"maizang", "埋葬"},
	{"maizhang", "买帐"},
	{"maizuo", "卖座"},
	{"mali", "马力 麻利"},
	{"malu", "马路"},
	{"mama", "妈妈"},
	{"mamu", "麻木"},
	{"manchang", "漫长"},
	{"manglu", "忙碌"},
	{"mangmang", "莽莽"},
	{"mangmu", "盲目"},
	{"mangran", "茫然"},
	{"mangren", "盲人"},
	{"mangyu", "忙于"},
	{"mangyuan", "莽原"},
	{"manheng", "蛮横"},
	{"manhua", "漫画"},
	{"manhuai", "满怀"},
	{"manma", "谩骂"},
	{"manmu", "满目"},
	{"manqiang", "满腔"},
	{"manyan", "蔓延"},
	{"manyi", "满意"},
	{"manzai", "满载"},
	{"manzu", "满足"},
	{"maobing", "毛病"},
	{"maocao", "毛糙"},
	{"maochong", "冒充"},
	{"maoding", "铆钉"},
	{"maodun", "矛盾"},
	{"maofan", "冒犯"},
	{"maofang", "毛纺"},
	{"maohao", "冒号"},
	{"maojian", "冒尖"},
	{"maojin", "冒进"},
	{"maokeng", "茅坑"},
	{"maoli", "毛利"},
	{"maomei", "冒昧"},
	{"maomi", "茂密"},
	{"maopai", "冒牌"},
	{"maopi", "毛坯"},
	{"maoran", "贸然"},
	{"maosheng", "茂盛"},
	{"maoshi", "冒失"},
	{"maotou", "矛头"},
	{"maoxian", "冒险"},
	{"maoyi", "贸易"},
	{"maoyu", "冒雨"},
	{"maozhong", "毛重"},
	{"maozi", "帽子"},
	{"mashang", "马上"},
	{"matong", "马桶"},
	{"matou", "码头"},
	{"maxi", "马戏"},
	{"mazhen", "麻疹"},
	{"mazui", "麻醉"},
	{"mbl", "免不了"},
	{"mbsf", "明辨是非"},
	{"mbzh", "满不在乎"},
	{"mbzs", "默不作声"},
	{"mcfy", "满城风雨"},
	{"mdd", "目的地"},
	{"mdkd", "目瞪口呆"},
	{"mdx", "描淡写"},
	{"mebx", "秘而不宣"},
	{"meici", "每次"},
	{"meidang", "每当"},
	{"meide", "美德"},
	{"meifa", "没法"},
	{"meifeng", "每逢"},
	{"meige", "每个"},
	{"meiguan", "美观"},
	{"meigui", "玫瑰"},
	{"meiguo", "美国"},
	{"meihao", "美好"},
	{"meihua", "美化"},
	{"meijie", "媒介 眉睫"},
	{"meiju", "枚举"},
	{"meikuang", "煤矿"},
	{"meilan", "霉烂"},
	{"meili", "魅力 美丽"},
	{"meiman", "美满"},
	{"meimao", "眉毛 美貌"},
	{"meimei", "妹妹"},
	{"meimiao", "美妙"},
	{"meimu", "眉目"},
	{"meinian", "每年"},
	{"meiqi", "煤气"},
	{"meiren", "每人"},
	{"meiri", "每日"},
	{"meirong", "美容"},
	{"meishao", "眉梢"},
	{"meishi", "每时"},
	{"meishu", "美术"},
	{"meishuo", "媒妁"},
	{"meitan", "煤炭"},
	{"meitian", "每天 煤田"},
	{"meixue", "美学"},
	{"meiyong", "没用"},
	{"meiyou", "没有 煤油"},
	{"meiyuan", "美元"},
	{"meiyue", "每月"},
	{"meizhi", "没治"},
	{"meizhou", "每周"},
	{"menfang", "门房"},
	{"mengbi", "蒙蔽"},
	{"mengfa", "萌发"},
	{"menggu", "蒙古"},
	{"mengguo", "盟国"},
	{"menghuan", "梦幻"},
	{"menghun", "蒙混"},
	{"mengjian", "梦见"},
	{"mengjin", "猛进"},
	{"mengjing", "梦境"},
	{"menglie", "猛烈"},
	{"menglong", "蒙胧"},
	{"mengmei", "蒙昧"},
	{"mengran", "猛然"},
	{"mengsheng", "萌生"},
	{"mengshi", "猛士"},
	{"mengshou", "蒙受"},
	{"mengxiang", "梦想 梦乡"},
	{"mengxing", "猛醒"},
	{"mengya", "萌芽"},
	{"mengyou", "盟友"},
	{"mengyue", "盟约"},
	{"mengzeng", "猛增"},
	{"menhu", "门户"},
	{"menkan", "门槛"},
	{"menlu", "门路"},
	{"menpai", "门牌"},
	{"menpiao", "门票"},
	{"menqi", "闷气"},
	{"menzhen", "门诊"},
	{"mfqs", "名副其实"},
	{"mfsw", "眉飞色舞"},
	{"mgx", "没关系"},
	{"mgz", "蒙古族"},
	{"mhgg", "蒙混过关"},
	{"mianbu", "面部"},
	{"mianchu", "免除"},
	{"miande", "免得"},
	{"miandui", "面对"},
	{"miane", "面额"},
	{"mianhua", "棉花"},
	{"mianhuai", "缅怀"},
	{"mianji", "面积"},
	{"mianju", "面具"},
	{"miankong", "面孔"},
	{"mianli", "勉励"},
	{"mianlian", "绵连"},
	{"mianlin", "面临"},
	{"mianmao", "面貌"},
	{"mianmian", "面面 绵绵"},
	{"mianmu", "面目"},
	{"mianpang", "面庞"},
	{"mianqian", "面前"},
	{"mianqiang", "勉强"},
	{"mianrong", "面容"},
	{"mianse", "面色"},
	{"miansha", "棉纱"},
	{"mianshou", "面授"},
	{"mianshui", "免税"},
	{"miantan", "面谈"},
	{"miantian", "腼腆"},
	{"mianxiang", "面向"},
	{"mianxing", "免刑"},
	{"mianxu", "棉絮"},
	{"mianyan", "绵延"},
	{"mianyi", "面议 免疫"},
	{"mianzhao", "面罩"},
	{"mianzhi", "免职"},
	{"mianzi", "面子"},
	{"miaobiao", "秒表"},
	{"miaohui", "描绘"},
	{"miaoling", "妙龄"},
	{"miaomang", "渺茫"},
	{"miaomo", "描摹"},
	{"miaoshi", "藐视"},
	{"miaoshu", "描述"},
	{"miaotiao", "苗条"},
	{"miaotou", "苗头"},
	{"miaoxie", "描写"},
	{"miaozhun", "瞄准"},
	{"mibu", "弥补"},
	{"midi", "谜底"},
	{"midu", "密度"},
	{"miehuo", "灭火"},
	{"mieji", "灭迹"},
	{"miejue", "灭绝"},
	{"miekou", "灭口"},
	{"mieshi", "蔑视"},
	{"miewang", "灭亡"},
	{"mifei", "靡费"},
	{"mifeng", "密封 蜜蜂 眯缝"},
	{"mihang", "迷航"},
	{"mihu", "迷糊"},
	{"mihuo", "迷惑"},
	{"miji", "密集"},
	{"mijian", "密件"},
	{"mijin", "迷津"},
	{"mijue", "秘诀"},
	{"milan", "糜烂"},
	{"milian", "迷恋"},
	{"miling", "密令"},
	{"milu", "迷路"},
	{"mima", "密码"},
	{"miman", "迷漫 弥漫"},
	{"mimi", "秘密 汨汨"},
	{"mimian", "谜面"},
	{"mimou", "密谋"},
	{"minban", "民办"},
	{"minbing", "民兵"},
	{"minfa", "民法"},
	{"minfen", "民愤"},
	{"minfeng", "民风"},
	{"mingan", "敏感"},
	{"mingbai", "明白"},
	{"mingce", "名册"},
	{"mingcheng", "名称"},
	{"mingchu", "明处"},
	{"mingci", "名次 名词"},
	{"mingdan", "名单"},
	{"mingdeng", "明灯"},
	{"minge", "民歌 名额"},
	{"minggui", "名贵"},
	{"mingji", "铭记"},
	{"mingjia", "名家"},
	{"mingke", "铭刻"},
	{"mingkuai", "明快"},
	{"minglang", "明朗"},
	{"mingli", "名利"},
	{"mingliang", "明亮"},
	{"mingliao", "明了"},
	{"mingling", "命令"},
	{"mingliu", "名流"},
	{"mingma", "明码"},
	{"mingmei", "明媚"},
	{"mingming", "明明"},
	{"mingmu", "名目"},
	{"mingnian", "明年"},
	{"mingpai", "名牌"},
	{"mingpian", "名片"},
	{"mingqi", "名气"},
	{"mingque", "明确"},
	{"mingren", "名人 明人"},
	{"mingsheng", "名胜 名声"},
	{"mingtang", "名堂"},
	{"mingtian", "明天"},
	{"mingwang", "名望"},
	{"mingwen", "明文"},
	{"mingxi", "明细"},
	{"mingxian", "明显"},
	{"mingxie", "鸣谢"},
	{"mingxing", "明星"},
	{"mingyan", "名言"},
	{"mingyi", "名义"},
	{"mingyu", "名誉"},
	{"mingyun", "命运"},
	{"mingzhi", "明知 明智"},
	{"mingzhu", "明珠 名著"},
	{"mingzi", "名字"},
	{"minhang", "民航"},
	{"minjian", "民间"},
	{"minjie", "敏捷"},
	{"minjing", "民警"},
	{"minqing", "民情"},
	{"minrui", "敏锐"},
	{"minshi", "民事"},
	{"minxin", "民心"},
	{"minyi", "民意"},
	{"minyong", "民用"},
	{"minyun", "民运"},
	{"minzheng", "民政"},
	{"minzhong", "民众"},
	{"minzhu", "民主"},
	{"minzu", "民族"},
	{"miqie", "密切"},
	{"miren", "迷人"},
	{"mishi", "迷失"},
	{"mishu", "秘书"},
	{"mitan", "密探"},
	{"mitu", "迷途"},
	{"miulun", "谬论"},
	{"miuwu", "谬误"},
	{"miwang", "迷惘"},
	{"miwu", "迷雾"},
	{"mixin", "迷信"},
	{"miyou", "密友"},
	{"miyu", "谜语"},
	{"miyue", "蜜月"},
	{"mks", "马克思"},
	{"mkyx", "眉开眼笑"},
	{"mlzy", "马列主义"},
	{"mmcf", "满面春风"},
	{"mmhh", "马马虎虎"},
	{"mmjd", "面面俱到"},
	{"mmqm", "莫名其妙"},
	{"mmww", "默默无闻"},
	{"mmzd", "明目张胆"},
	{"moai", "默哀"},
	{"mobu", "莫不"},
	{"moca", "摩擦"},
	{"moceng", "磨蹭"},
	{"moda", "莫大"},
	{"modao", "磨刀"},
	{"modeng", "摩登"},
	{"modi", "摸底"},
	{"mofan", "模范"},
	{"mofang", "模仿"},
	{"mofei", "莫非"},
	{"mogui", "魔鬼"},
	{"mohu", "模糊"},
	{"moji", "墨迹"},
	{"mokuai", "模块"},
	{"moli", "磨砺"},
	{"molian", "磨练"},
	{"moliao", "末了"},
	{"molu", "末路"},
	{"moluo", "没落"},
	{"momie", "磨灭"},
	{"momo", "默默 脉脉"},
	{"monan", "磨难"},
	{"moni", "模拟"},
	{"moqi", "末期 默契"},
	{"moran", "默然 漠然"},
	{"moren", "默认"},
	{"mori", "末日"},
	{"moru", "莫如"},
	{"mosha", "抹杀 抹煞"},
	{"moshao", "末梢"},
	{"mosheng", "陌生"},
	{"moshi", "模式"},
	{"moshou", "没收"},
	{"moshu", "魔术"},
	{"mosun", "磨损"},
	{"mosuo", "摸索"},
	{"mote", "模特"},
	{"motuo", "摩托"},
	{"moudi", "某地"},
	{"mouge", "某个"},
	{"mouhai", "谋害"},
	{"mouhua", "谋划"},
	{"moujun", "某军"},
	{"mouli", "牟利"},
	{"moulue", "谋略"},
	{"mouqiu", "谋求"},
	{"mouqu", "牟取"},
	{"mousha", "谋杀"},
	{"mousheng", "谋生"},
	{"mouxie", "某些"},
	{"mowei", "末尾"},
	{"moxie", "默写 摹写"},
	{"moxing", "模型"},
	{"moxu", "默许"},
	{"moyang", "模样"},
	{"mozhang", "魔掌"},
	{"mozi", "模子"},
	{"mqcz", "摩拳擦掌"},
	{"mqhs", "妙趣横生"},
	{"msb", "门市部"},
	{"mscg", "墨守成规"},
	{"msgj", "名胜古迹"},
	{"mshc", "妙手回春"},
	{"msk", "莫斯科"},
	{"msm", "没什么"},
	{"msmk", "每时每刻"},
	{"msz", "秘书长"},
	{"mszs", "没事找事"},
	{"mtc", "摩托车"},
	{"mtgz", "埋头工作"},
	{"mtkg", "埋头苦干"},
	{"muai", "母爱"},
	{"mubei", "墓碑"},
	{"mubiao", "目标"},
	{"mucai", "木材"},
	{"mucao", "牧草"},
	{"muce", "目测"},
	{"muchang", "牧场"},
	{"muci", "目次"},
	{"mudan", "牡丹"},
	{"mudi", "目的"},
	{"muge", "牧歌"},
	{"muguang", "目光"},
	{"muhou", "幕后"},
	{"muji", "目击 募集"},
	{"muke", "木刻"},
	{"muliao", "木料 幕僚"},
	{"mulu", "目录"},
	{"mumin", "牧民"},
	{"mune", "木讷"},
	{"muou", "木偶"},
	{"muqian", "目前"},
	{"muqin", "母亲"},
	{"muqu", "牧区"},
	{"muran", "木然"},
	{"muse", "暮色"},
	{"mushi", "牧师"},
	{"musong", "目送"},
	{"mutong", "牧童"},
	{"muye", "牧业"},
	{"muyu", "沐浴"},
	{"mycy", "民意测验"},
	{"mysc", "贸易市场"},
	{"myxd", "贸易协定"},
	{"mzb", "民政部"},
	{"mzbz", "美中不足"},
	{"mzd", "毛泽东"},
	{"mzeg", "满载而归"},
	{"mzgf", "明知故犯"},
	{"mzp", "毛织品"},
	{"mzwr", "目中无人"},
	{"mzx", "毛主席"},
	{"nabian", "那边"},
	{"nacui", "纳粹"},
	{"naer", "那儿 哪儿"},
	{"nage", "那个 哪个"},
	{"nahan", "呐喊"},
	{"nahui", "哪会"},
	{"naifan", "耐烦"},
	{"naihe", "奈何"},
	{"naijiu", "耐久"},
	{"nailao", "耐劳"},
	{"nainai", "奶奶"},
	{"naixin", "耐心"},
	{"naixing", "耐性"},
	{"naiyong", "耐用"},
	{"naiyou", "奶油"},
	{"naizhi", "乃至"},
	{"nali", "那里 哪里"},
	{"name", "那么"},
	{"nanban", "难办"},
	{"nanbei", "南北"},
	{"nanbian", "南边"},
	{"nanchan", "难产"},
	{"nanchang", "南昌"},
	{"nanchu", "难处"},
	{"nandao", "难道"},
	{"nande", "难得"},
	{"nandian", "难点"},
	{"nandu", "难度"},
	{"naneng", "哪能"},
	{"nanfang", "南方"},
	{"nanfei", "南非"},
	{"nanfen", "难分"},
	{"nanfeng", "南风"},
	{"nangkuo", "囊括"},
	{"nanguai", "难怪"},
	{"nanguan", "难关"},
	{"nanguo", "难过 南国"},
	{"nanhai", "男孩 南海"},
	{"nanhuo", "南货"},
	{"nanji", "南极"},
	{"nanjie", "难解"},
	{"nanjing", "南京"},
	{"nankan", "难看 难堪"},
	{"nanmian", "南面 难免"},
	{"nanmin", "难民"},
	{"nanning", "南宁"},
	{"nannv", "男女"},
	{"nanran", "赧然"},
	{"nanren", "男人"},
	{"nanse", "难色"},
	{"nansheng", "男生"},
	{"nanshi", "难事"},
	{"nanshou", "难受"},
	{"nanshuo", "难说"},
	{"nanti", "难题"},
	{"nanting", "难听"},
	{"nanwei", "难为"},
	{"nanxing", "男性"},
	{"nanya", "南亚"},
	{"nanyang", "南洋"},
	{"nanyi", "难以"},
	{"nanyou", "难友"},
	{"nanyu", "难于"},
	{"naodai", "脑袋"},
	{"naohai", "脑海"},
	{"naohuo", "恼火"},
	{"naojin", "脑筋"},
	{"naoju", "闹剧"},
	{"naoshi", "闹事"},
	{"napa", "哪怕"},
	{"naru", "纳入"},
	{"nashi", "那时"},
	{"nashou", "拿手"},
	{"nashui", "纳税"},
	{"naxie", "那些 哪些"},
	{"naxin", "纳新"},
	{"nayang", "那样 哪样"},
	{"nazhong", "那种"},
	{"ncl", "年产量"},
	{"ncp", "农产品"},
	{"ncs", "南昌市"},
	{"nds", "难道说"},
	{"neibu", "内部"},
	{"neicun", "内存"},
	{"neidi", "内地"},
	{"neige", "内阁"},
	{"neihan", "内涵"},
	{"neihang", "内行"},
	{"neihong", "内讧"},
	{"neijian", "内奸"},
	{"neijiu", "内疚"},
	{"neike", "内科"},
	{"neiluan", "内乱"},
	{"neimu", "内幕"},
	{"neiqin", "内勤"},
	{"neirong", "内容"},
	{"neiwai", "内外"},
	{"neixiao", "内销"},
	{"neixin", "内心"},
	{"neiyin", "内因"},
	{"neiying", "内应"},
	{"neizai", "内在"},
	{"nengdong", "能动"},
	{"nengfou", "能否"},
	{"nenggan", "能干"},
	{"nenggou", "能够"},
	{"nengli", "能力"},
	{"nengliang", "能量"},
	{"nengnai", "能耐"},
	{"nengren", "能人"},
	{"nengshou", "能手"},
	{"nengyuan", "能源"},
	{"nengzhe", "能者"},
	{"nfcp", "农副产品"},
	{"nflq", "年富力强"},
	{"ngqj", "能工巧匠"},
	{"nianchu", "年初"},
	{"niandai", "年代"},
	{"niandao", "念叨"},
	{"niandi", "年底"},
	{"niandu", "年度"},
	{"nianfen", "年份"},
	{"nianhua", "年华 年画"},
	{"nianji", "年级 年纪"},
	{"nianjian", "年鉴"},
	{"nianlai", "年来"},
	{"nianli", "年利 年历"},
	{"nianliang", "拈量"},
	{"nianling", "年龄"},
	{"nianmai", "年迈"},
	{"niannian", "年年"},
	{"nianqing", "年青 年轻"},
	{"niansui", "年岁"},
	{"niantou", "年头 念头"},
	{"nianxian", "年限"},
	{"nianyue", "年月"},
	{"nianzao", "酿造"},
	{"nianzhong", "年终"},
	{"niaokan", "鸟瞰"},
	{"nicha", "逆差"},
	{"nichu", "你处"},
	{"nide", "你的"},
	{"niding", "拟定 拟订"},
	{"niezao", "捏造"},
	{"nifan", "腻烦"},
	{"nijiang", "泥浆"},
	{"nijing", "逆境"},
	{"nikeng", "泥坑"},
	{"niliu", "逆流"},
	{"nimen", "你们"},
	{"ninggu", "凝固"},
	{"ningjie", "凝结"},
	{"ningjing", "宁静"},
	{"ningju", "凝聚"},
	{"ningke", "宁可"},
	{"ningken", "宁肯"},
	{"ninglian", "凝练"},
	{"ningri", "宁日"},
	{"ningshi", "凝视"},
	{"ningwang", "凝望"},
	{"ningxia", "宁夏"},
	{"ningyuan", "宁愿"},
	{"nining", "泥泞"},
	{"nisu", "泥塑"},
	{"niudai", "纽带"},
	{"niudu", "牛犊"},
	{"niukou", "纽扣"},
	{"niunai", "牛奶"},
	{"niuyue", "纽约"},
	{"niuzai", "牛仔"},
	{"niuzhuan", "扭转"},
	{"niwei", "腻味"},
	{"niwo", "你我"},
	{"niyi", "拟议"},
	{"nizhao", "泥沼"},
	{"nizhuan", "逆转"},
	{"njnf", "难解难分"},
	{"njs", "南京市"},
	{"njz", "南极洲"},
	{"nkwy", "扭亏为盈"},
	{"nlld", "脑力劳动"},
	{"nltr", "年老体弱"},
	{"nmg", "内蒙古"},
	{"nmsc", "农贸市场"},
	{"nmx", "那么些"},
	{"nmy", "那么样"},
	{"nnbw", "念念不忘"},
	{"nnkg", "难能可贵"},
	{"nns", "南宁市"},
	{"nongbao", "脓包"},
	{"nongcun", "农村"},
	{"nongdu", "浓度"},
	{"nongfu", "农妇"},
	{"nonghou", "浓厚"},
	{"nonghui", "农会"},
	{"nonghuo", "农活"},
	{"nongju", "农具"},
	{"nongli", "农历"},
	{"nonglin", "农林"},
	{"nongmang", "农忙"},
	{"nongmin", "农民"},
	{"nongqing", "弄清"},
	{"nongshi", "农时"},
	{"nongyao", "农药"},
	{"nongye", "农业"},
	{"nongyi", "农艺"},
	{"nongyu", "浓郁"},
	{"nqh", "年轻化"},
	{"nqr", "年轻人"},
	{"nsh", "那时候"},
	{"nshd", "能说会道"},
	{"nslf", "南斯拉夫"},
	{"nsnx", "能上能下"},
	{"nsxz", "逆水行舟"},
	{"ntsl", "农田水利"},
	{"nuanhe", "暖和"},
	{"nuanliu", "暖流"},
	{"nuanqi", "暖气"},
	{"nubi", "奴婢"},
	{"nucai", "奴才"},
	{"nuedai", "虐待"},
	{"nueji", "虐疾"},
	{"nuhou", "怒吼"},
	{"nuhua", "奴化"},
	{"nuhuo", "怒火"},
	{"nuli", "努力 奴隶"},
	{"nuoyan", "诺言"},
	{"nuoyong", "挪用"},
	{"nupu", "奴仆"},
	{"nver", "女儿"},
	{"nvgong", "女工"},
	{"nvhai", "女孩"},
	{"nvren", "女人"},
	{"nvse", "女色"},
	{"nvshi", "女士"},
	{"nvxing", "女性"},
	{"nvxu", "女婿"},
	{"nvzi", "女子"},
	{"nzk", "牛仔裤"},
	{"nzw", "农作物"},
	{"orx", "偶然性"},
	{"ouda", "殴打"},
	{"ouer", "偶尔"},
	{"ouge", "讴歌"},
	{"ouhe", "偶合 耦合"},
	{"oumu", "欧姆"},
	{"ouqi", "怄气"},
	{"ouran", "偶然"},
	{"ouse", "藕色"},
	{"oushu", "偶数"},
	{"outu", "呕吐"},
	{"ouyang", "欧阳"},
	{"ouzhou", "欧洲"},
	{"paiban", "排版 拍板"},
	{"paibi", "排比"},
	{"paibie", "派别"},
	{"paichang", "排场"},
	{"paichi", "排斥"},
	{"paichu", "排除"},
	{"paidui", "排队"},
	{"paihao", "牌号"},
	{"paihuai", "徘徊"},
	{"paiji", "排挤"},
	{"paijia", "牌价"},
	{"pailie", "排列"},
	{"paimai", "拍卖"},
	{"paiqian", "派遣"},
	{"paiqiu", "排球"},
	{"paisheng", "派生"},
	{"paitou", "派头"},
	{"paiwai", "排外"},
	{"paixie", "排泄"},
	{"paiyan", "排演"},
	{"paizhao", "牌照"},
	{"panbian", "叛变"},
	{"panbie", "判别"},
	{"panchan", "盘缠"},
	{"pancun", "盘存"},
	{"pandang", "叛党"},
	{"pandeng", "攀登"},
	{"pandian", "盘点"},
	{"panding", "判定"},
	{"panduan", "判断"},
	{"panfu", "攀附"},
	{"pangbian", "旁边"},
	{"pangda", "庞大"},
	{"pangen", "盘亘"},
	{"pangguan", "旁观"},
	{"pangguang", "膀胱"},
	{"panghuang", "彷徨"},
	{"pangting", "旁听"},
	{"pangtong", "旁通"},
	{"pangtuo", "滂沱"},
	{"pangza", "庞杂"},
	{"panju", "盘踞"},
	{"panjue", "判决"},
	{"panluan", "叛乱"},
	{"panming", "判明"},
	{"panni", "叛逆"},
	{"panqu", "盘曲"},
	{"panshan", "蹒跚"},
	{"panshi", "磐石"},
	{"pansuan", "盘算"},
	{"pantao", "蟠桃"},
	{"pantu", "叛徒"},
	{"pantuo", "盘陀"},
	{"panwang", "盼望"},
	{"panxing", "判刑"},
	{"panxuan", "盘旋"},
	{"paobing", "炮兵"},
	{"paobu", "跑步"},
	{"paodan", "炮弹"},
	{"paodao", "跑道"},
	{"paoguang", "抛光"},
	{"paohuo", "炮火"},
	{"paoji", "炮击"},
	{"paomao", "抛锚"},
	{"paomo", "泡沫"},
	{"paoqi", "抛弃"},
	{"paoshou", "炮手"},
	{"paotai", "炮台"},
	{"paoting", "炮艇"},
	{"paoxiao", "咆哮"},
	{"paoying", "泡影"},
	{"paozhang", "炮仗"},
	{"paozhi", "炮制"},
	{"pashou", "扒手"},
	{"pasi", "怕死"},
	{"pbbk", "疲惫不堪"},
	{"pbjd", "迫不急待"},
	{"pcmx", "破除迷信"},
	{"pdhl", "平等互利"},
	{"peiban", "陪伴"},
	{"peibei", "配备"},
	{"peiben", "赔本"},
	{"peichang", "赔偿"},
	{"peichen", "陪衬"},
	{"peifang", "配方"},
	{"peifu", "佩服"},
	{"peihe", "配合"},
	{"peiji", "配给"},
	{"peijian", "配件"},
	{"peijiao", "配角"},
	{"peikuan", "赔款"},
	{"peili", "赔礼"},
	{"peiou", "配偶"},
	{"peishen", "陪审"},
	{"peisong", "陪送"},
	{"peitai", "胚胎"},
	{"peitao", "配套"},
	{"peitong", "陪同"},
	{"peixun", "培训"},
	{"peiyang", "培养"},
	{"peiyin", "配音"},
	{"peiyu", "培育"},
	{"peiyue", "配乐"},
	{"peizang", "陪葬"},
	{"peizhi", "配制 配置 培植"},
	{"pendi", "盆地"},
	{"pengbei", "碰杯"},
	{"pengbi", "碰壁"},
	{"pengbo", "蓬勃"},
	{"pengchang", "捧场"},
	{"pengji", "抨击"},
	{"penglai", "蓬莱"},
	{"pengluan", "蓬乱"},
	{"pengpai", "澎湃"},
	{"pengren", "烹饪"},
	{"pengsha", "硼砂"},
	{"pengsong", "蓬松"},
	{"pengtiao", "烹调"},
	{"pengyou", "朋友"},
	{"pengzhang", "膨胀"},
	{"penjian", "喷溅"},
	{"penjing", "盆景"},
	{"penshe", "喷射"},
	{"penti", "喷嚏"},
	{"pfgl", "平方公里"},
	{"pfqs", "平分秋色"},
	{"pgcj", "盘根错节"},
	{"piancha", "偏差"},
	{"pianduan", "片断 片段"},
	{"pianfei", "偏废"},
	{"pianfu", "篇幅"},
	{"pianji", "偏激"},
	{"pianjian", "偏见"},
	{"pianju", "骗局"},
	{"pianke", "片刻"},
	{"pianli", "偏离"},
	{"pianmian", "片面"},
	{"pianpang", "偏旁"},
	{"pianpi", "偏僻"},
	{"pianpo", "偏颇"},
	{"pianqu", "骗取"},
	{"pianren", "骗人"},
	{"pianshu", "骗术"},
	{"piantan", "偏袒"},
	{"pianxian", "翩跹"},
	{"pianxiang", "偏向"},
	{"pianyi", "便宜 偏移"},
	{"pianzhang", "篇章"},
	{"pianzhou", "扁舟"},
	{"pianzi", "骗子"},
	{"piaobo", "漂泊"},
	{"piaofang", "票房"},
	{"piaofu", "漂浮"},
	{"piaojia", "票价"},
	{"piaoju", "票据"},
	{"piaoliang", "漂亮"},
	{"piaoling", "飘零"},
	{"piaoliu", "漂流"},
	{"piaoluo", "飘落"},
	{"piaomian", "票面"},
	{"piaomiao", "飘渺"},
	{"piaopo", "飘泊"},
	{"piaoqie", "剽窃"},
	{"piaoran", "飘然"},
	{"piaosan", "飘散"},
	{"piaoyang", "飘扬"},
	{"piaoyao", "飘摇"},
	{"piaoyou", "飘游"},
	{"pibei", "疲惫"},
	{"pibo", "批驳"},
	{"pifa", "批发"},
	{"pifu", "皮肤 批复"},
	{"pige", "皮革"},
	{"pigu", "屁股"},
	{"pijuan", "疲倦"},
	{"pilao", "疲劳"},
	{"pilou", "纰漏"},
	{"pilu", "披露"},
	{"pinchang", "品尝"},
	{"pinchuan", "频传"},
	{"pincou", "拼凑"},
	{"pindai", "频带"},
	{"pindao", "频道"},
	{"pinde", "品德"},
	{"pinfa", "贫乏"},
	{"pinfan", "频繁"},
	{"pingan", "平安"},
	{"pingbi", "评比 屏蔽"},
	{"pingchang", "平常"},
	{"pingchuan", "平川"},
	{"pingdan", "平淡"},
	{"pingdeng", "平等"},
	{"pingdi", "平地"},
	{"pingding", "平定 评定"},
	{"pinge", "品格"},
	{"pingfan", "平反 平凡"},
	{"pingfang", "平方"},
	{"pingfen", "平分 评分"},
	{"pinggong", "评功"},
	{"pingheng", "平衡"},
	{"pingji", "评级"},
	{"pingjia", "平价 评价"},
	{"pingjiang", "评奖"},
	{"pingjie", "凭借"},
	{"pingjing", "平静"},
	{"pingjun", "平均"},
	{"pingkong", "凭空"},
	{"pingli", "评理"},
	{"pinglun", "评论"},
	{"pingmian", "平面"},
	{"pingmin", "平民"},
	{"pingmu", "屏幕"},
	{"pingpan", "评判"},
	{"pingpang", "乒乓"},
	{"pingping", "平平"},
	{"pingrang", "平壤"},
	{"pingri", "平日"},
	{"pingshi", "平时"},
	{"pingshou", "平手"},
	{"pingshuo", "评说"},
	{"pingsu", "平素"},
	{"pingtan", "平坦 乒坛"},
	{"pingwen", "平稳"},
	{"pingxi", "平息"},
	{"pingxiang", "萍乡"},
	{"pingxing", "平行"},
	{"pingyi", "平易 评议"},
	{"pingyong", "平庸"},
	{"pingyuan", "平原"},
	{"pingze", "平仄"},
	{"pingzhang", "屏障"},
	{"pingzhe", "凭着"},
	{"pingzheng", "平整 凭证"},
	{"pingzhu", "评注"},
	{"pinhan", "贫寒"},
	{"pinji", "品级"},
	{"pinkun", "贫困"},
	{"pinlv", "频率"},
	{"pinmao", "品貌"},
	{"pinming", "拼命 品名"},
	{"pinping", "品评"},
	{"pinqing", "聘请"},
	{"pinqiong", "贫穷"},
	{"pinren", "聘任"},
	{"pinshu", "聘书"},
	{"pinxie", "拼写"},
	{"pinxing", "品行 品性"},
	{"pinyin", "拼音"},
	{"pinzhi", "品质"},
	{"pinzhong", "品种"},
	{"pipan", "批判"},
	{"pipei", "匹配"},
	{"piping", "批评"},
	{"piqi", "脾气"},
	{"piru", "譬如"},
	{"piruan", "疲软"},
	{"pishi", "批示"},
	{"pita", "疲沓"},
	{"piwei", "脾胃"},
	{"pixing", "脾性"},
	{"piyao", "辟谣"},
	{"piyu", "批语"},
	{"piyue", "批阅"},
	{"pizhu", "批注"},
	{"pizhun", "批准"},
	{"pjs", "平均数"},
	{"pjzj", "披荆斩棘"},
	{"ply", "评论员"},
	{"pmdx", "披麻戴孝"},
	{"poan", "破案"},
	{"pochan", "破产"},
	{"pochu", "破除"},
	{"podu", "坡度"},
	{"pofu", "泼妇"},
	{"poge", "破格"},
	{"pohai", "迫害"},
	{"pohuai", "破坏"},
	{"pohuo", "破获"},
	{"pojin", "迫近"},
	{"pojiu", "破旧"},
	{"pola", "泼辣"},
	{"polan", "破烂"},
	{"poli", "魄力 破例"},
	{"polie", "破裂"},
	{"pomie", "破灭"},
	{"poqie", "迫切"},
	{"poshi", "迫使"},
	{"posui", "破碎"},
	{"posun", "破损"},
	{"potu", "破土"},
	{"poujie", "剖解"},
	{"pouxi", "剖析"},
	{"pozhan", "破绽"},
	{"ppbb", "蓬蓬勃勃"},
	{"pptt", "普普通通"},
	{"prwr", "旁若无人"},
	{"pth", "普通话"},
	{"ptlm", "抛头露面"},
	{"pubian", "普遍"},
	{"pucha", "普查"},
	{"puchi", "扑哧"},
	{"puda", "扑打"},
	{"pugai", "铺盖"},
	{"puji", "普及"},
	{"puping", "铺平"},
	{"puren", "仆人"},
	{"pusa", "菩萨"},
	{"pushe", "铺设"},
	{"pushi", "朴实"},
	{"pusu", "朴素"},
	{"putao", "葡萄"},
	{"putong", "普通 扑通"},
	{"puwei", "铺位"},
	{"puxie", "谱写"},
	{"puxuan", "普选"},
	{"puzhang", "铺张"},
	{"puzhao", "普照"},
	{"puzhi", "朴直"},
	{"pxdy", "披星戴月"},
	{"pyjr", "平易近人"},
	{"pyzm", "拼音字母"},
	{"pzlf", "铺张浪费"},
	{"qad", "亲爱的"},
	{"qbs", "情报所"},
	{"qbw", "千百万"},
	{"qbwh", "千变万化"},
	{"qcbd", "取长补短"},
	{"qcbl", "千锤百炼"},
	{"qdhc", "恰到好处"},
	{"qedz", "取而代之"},
	{"qeyj", "轻而易举"},
	{"qfbj", "千方百计"},
	{"qgjl", "清规戒律"},
	{"qgjx", "勤工俭学"},
	{"qgxd", "旗鼓相当"},
	{"qgy", "轻工业"},
	{"qgyb", "轻工业部"},
	{"qgzx", "勤工助学"},
	{"qhlb", "权衡利弊"},
	{"qhnx", "骑虎难下"},
	{"qhs", "青海省"},
	{"qhzb", "青红皂白"},
	{"qiadang", "恰当"},
	{"qiahao", "恰好"},
	{"qianbei", "前辈"},
	{"qianbian", "前边"},
	{"qianbo", "浅薄"},
	{"qiancai", "钱财"},
	{"qianchan", "欠产"},
	{"qiancheng", "前程"},
	{"qiandao", "签到"},
	{"qiandi", "前敌"},
	{"qianding", "签订"},
	{"qianfa", "签发"},
	{"qianfan", "遣返"},
	{"qianfang", "前方"},
	{"qiangbi", "墙壁 枪毙"},
	{"qiangbian", "强辩"},
	{"qiangda", "强大"},
	{"qiangdan", "枪弹"},
	{"qiangdao", "强盗"},
	{"qiangdiao", "强调 腔调"},
	{"qiangdu", "强度"},
	{"qiangduo", "抢夺"},
	{"qianggong", "强攻"},
	{"qiangguo", "强国"},
	{"qianghua", "强化"},
	{"qiangjia", "强加"},
	{"qiangjian", "强奸"},
	{"qiangjie", "抢劫"},
	{"qiangjing", "强劲"},
	{"qiangjiu", "抢救"},
	{"qiangjue", "枪决"},
	{"qianglie", "强烈"},
	{"qiangpo", "强迫"},
	{"qiangquan", "强权"},
	{"qiangruo", "强弱"},
	{"qiangsha", "枪杀"},
	{"qiangsheng", "强盛"},
	{"qiangu", "千古"},
	{"qiangua", "牵挂"},
	{"qiangwei", "蔷薇"},
	{"qiangxian", "抢险"},
	{"qiangxing", "强行"},
	{"qiangying", "强硬"},
	{"qiangzhan", "强占"},
	{"qiangzhe", "强者"},
	{"qiangzhi", "强制 枪支"},
	{"qiangzhuang", "强壮"},
	{"qianhou", "前后"},
	{"qianjin", "前进"},
	{"qianjing", "前景"},
	{"qianjiu", "迁就 歉疚"},
	{"qianju", "迁居"},
	{"qiankun", "乾坤"},
	{"qianli", "千里 前例 潜力"},
	{"qianlian", "牵连"},
	{"qianlie", "前列"},
	{"qianlou", "浅陋"},
	{"qianmian", "前面"},
	{"qianming", "签名"},
	{"qiannian", "前年"},
	{"qianqi", "前期"},
	{"qianqiu", "千秋"},
	{"qianqu", "前驱"},
	{"qianque", "欠缺"},
	{"qianren", "前人 前任"},
	{"qianruo", "纤弱"},
	{"qianshao", "前哨"},
	{"qianshe", "牵涉"},
	{"qianshou", "歉收"},
	{"qianshu", "签署"},
	{"qiansong", "遣送"},
	{"qianti", "前提"},
	{"qiantian", "前天"},
	{"qiantiao", "欠条"},
	{"qiantu", "前途"},
	{"qianwa", "千瓦"},
	{"qianwan", "千万"},
	{"qianwang", "前往"},
	{"qianxi", "前夕 纤细"},
	{"qianxian", "前线 浅显"},
	{"qianxu", "谦虚"},
	{"qianxun", "谦逊"},
	{"qianyan", "前言 前沿"},
	{"qianye", "前夜"},
	{"qianyi", "歉意 迁移"},
	{"qianyin", "牵引"},
	{"qianzai", "潜在"},
	{"qianze", "谴责"},
	{"qianzhe", "前者"},
	{"qianzheng", "签证"},
	{"qianzhi", "牵制 钳制"},
	{"qianzi", "签字"},
	{"qianzou", "前奏"},
	{"qiaobao", "侨胞"},
	{"qiaocui", "憔悴"},
	{"qiaodun", "桥墩"},
	{"qiaoji", "巧计"},
	{"qiaojian", "瞧见"},
	{"qiaoju", "侨居"},
	{"qiaoliang", "桥梁"},
	{"qiaomen", "窍门"},
	{"qiaomiao", "巧妙"},
	{"qiaopai", "桥牌"},
	{"qiaoqian", "乔迁"},
	{"qiaoran", "悄然"},
	{"qiaowu", "侨务"},
	{"qiaozha", "敲诈"},
	{"qiasi", "恰似"},
	{"qiatan", "洽谈"},
	{"qibu", "岂不 起步"},
	{"qicai", "器材 奇才"},
	{"qican", "凄惨"},
	{"qicao", "起草"},
	{"qiche", "汽车 骑车"},
	{"qicheng", "启程"},
	{"qichu", "起初 凄楚"},
	{"qici", "其次"},
	{"qidai", "期待 脐带"},
	{"qidan", "岂但"},
	{"qidi", "启迪"},
	{"qidian", "起点"},
	{"qidong", "启动"},
	{"qidu", "气度"},
	{"qiean", "窃案"},
	{"qieduan", "切断"},
	{"qiehe", "切合"},
	{"qieju", "窃据"},
	{"qiequ", "窃取"},
	{"qieruo", "怯弱"},
	{"qieshen", "切身"},
	{"qieshi", "切实"},
	{"qieti", "切题"},
	{"qieting", "窃听"},
	{"qiexiao", "切削"},
	{"qieyi", "惬意"},
	{"qifa", "启发"},
	{"qifei", "起飞 岂非"},
	{"qifen", "气愤 气氛"},
	{"qifu", "欺负"},
	{"qigai", "气概 乞丐"},
	{"qigan", "岂敢"},
	{"qigong", "气功"},
	{"qiguai", "奇怪"},
	{"qiguan", "器官"},
	{"qihao", "旗号"},
	{"qihei", "漆黑"},
	{"qihou", "气候"},
	{"qihuo", "期货"},
	{"qiji", "契机 奇迹"},
	{"qijian", "期间 起见 器件"},
	{"qijie", "七届"},
	{"qijin", "迄今"},
	{"qilai", "起来"},
	{"qiliang", "凄凉"},
	{"qiling", "欺凌"},
	{"qiliu", "气流"},
	{"qilu", "歧路"},
	{"qima", "起码 骑马"},
	{"qimeng", "启蒙"},
	{"qimiao", "奇妙"},
	{"qimin", "器皿"},
	{"qinai", "亲爱"},
	{"qinbi", "亲笔"},
	{"qineng", "岂能"},
	{"qinfan", "侵犯"},
	{"qinfen", "勤奋"},
	{"qingbai", "清白 青白"},
	{"qingbao", "情报"},
	{"qingcao", "情操 青草"},
	{"qingcha", "清查"},
	{"qingche", "清澈"},
	{"qingchu", "清楚 清除"},
	{"qingchun", "青春"},
	{"qingcui", "青翠"},
	{"qingdan", "清单"},
	{"qingdao", "青岛 倾倒"},
	{"qingdian", "清点"},
	{"qingdiao", "情调"},
	{"qingfu", "轻浮"},
	{"qinggong", "青工"},
	{"qinghai", "青海"},
	{"qinghe", "庆贺"},
	{"qinghua", "清华"},
	{"qinghuai", "情怀"},
	{"qinghuan", "清还"},
	{"qingjia", "请假"},
	{"qingjian", "请柬"},
	{"qingjiao", "请教"},
	{"qingjie", "情节 清洁"},
	{"qingjing", "情景"},
	{"qingke", "请客 顷刻"},
	{"qingkong", "晴空"},
	{"qingkuai", "轻快"},
	{"qingkuang", "情况"},
	{"qinglai", "青睐"},
	{"qinglang", "晴朗"},
	{"qingli", "情理 清理"},
	{"qinglv", "情侣"},
	{"qingmie", "轻蔑"},
	{"qingnian", "青年"},
	{"qingqi", "氢气"},
	{"qingqiao", "轻巧"},
	{"qingqiu", "请求"},
	{"qingqu", "情趣"},
	{"qingshan", "青山"},
	{"qingshi", "请示"},
	{"qingshuai", "轻率"},
	{"qingshuang", "清爽"},
	{"qingsong", "青松 轻松"},
	{"qingsu", "倾诉 情愫"},
	{"qingtian", "青天 晴天"},
	{"qingting", "倾听"},
	{"qingtu", "倾吐"},
	{"qingwen", "请问"},
	{"qingxiang", "倾向"},
	{"qingxiao", "倾销"},
	{"qingxing", "情形 清醒"},
	{"qingxu", "情绪"},
	{"qingyi", "情谊 轻易"},
	{"qingying", "轻盈"},
	{"qingyuan", "情愿 请愿"},
	{"qingzhan", "请战"},
	{"qingzhong", "轻重"},
	{"qingzhu", "倾注 庆祝"},
	{"qingzui", "请罪"},
	{"qinhai", "侵害"},
	{"qinjian", "勤俭"},
	{"qinjin", "亲近"},
	{"qinjuan", "亲眷"},
	{"qinkuai", "勤快"},
	{"qinlao", "勤劳"},
	{"qinli", "亲历"},
	{"qinlin", "亲临"},
	{"qinlue", "侵略"},
	{"qinmi", "亲密"},
	{"qinmian", "勤勉"},
	{"qinpei", "钦佩"},
	{"qinqi", "亲戚"},
	{"qinqie", "亲切"},
	{"qinre", "亲热"},
	{"qinren", "亲人"},
	{"qinru", "侵入"},
	{"qinshen", "亲身"},
	{"qinshi", "侵蚀 寝室"},
	{"qinshou", "亲手"},
	{"qinshu", "亲属"},
	{"qintun", "侵吞"},
	{"qinwu", "勤务"},
	{"qinxin", "亲信"},
	{"qinyan", "亲眼"},
	{"qinyou", "亲友"},
	{"qinzhan", "侵占"},
	{"qinzi", "亲自"},
	{"qiongguo", "穷国"},
	{"qiongku", "穷苦"},
	{"qiongkun", "穷困"},
	{"qionglong", "穹隆"},
	{"qiongqi", "穷期"},
	{"qiongren", "穷人"},
	{"qiongtu", "穷途"},
	{"qipai", "气派"},
	{"qipian", "欺骗"},
	{"qipo", "气魄"},
	{"qiqiu", "乞求"},
	{"qiqu", "崎岖"},
	{"qiquan", "齐全"},
	{"qiran", "凄然"},
	{"qise", "起色 气色"},
	{"qishi", "其实 起始 启事 气势 启示 歧视"},
	{"qishu", "奇数"},
	{"qishui", "汽水"},
	{"qisi", "气死"},
	{"qisu", "起诉"},
	{"qita", "其他 其它"},
	{"qite", "奇特"},
	{"qiti", "气体"},
	{"qiting", "汽艇"},
	{"qitu", "企图 歧途"},
	{"qiubo", "秋播"},
	{"qiuchang", "球场"},
	{"qiufan", "囚犯"},
	{"qiufeng", "秋风"},
	{"qiuji", "秋季"},
	{"qiujiao", "求教"},
	{"qiujin", "囚禁"},
	{"qiujiu", "求救"},
	{"qiuling", "丘陵"},
	{"qiuqian", "秋千"},
	{"qiuqing", "求情"},
	{"qiuquan", "求全"},
	{"qiuse", "秋色"},
	{"qiushi", "求实"},
	{"qiushou", "秋收"},
	{"qiutian", "秋天"},
	{"qiuxue", "求学"},
	{"qiuzhan", "求战"},
	{"qiuzheng", "求证"},
	{"qiuzhi", "求知"},
	{"qiuzhu", "求助"},
	{"qiwang", "期望"},
	{"qiwei", "气味"},
	{"qiwen", "气温 奇闻"},
	{"qiwu", "欺侮"},
	{"qixi", "气息 栖息"},
	{"qixian", "起先 期限"},
	{"qixiang", "气象"},
	{"qixie", "器械"},
	{"qixin", "齐心"},
	{"qiya", "气压 欺压"},
	{"qiyan", "气焰"},
	{"qiye", "企业"},
	{"qiyi", "起义 歧义"},
	{"qiyin", "起因"},
	{"qiyong", "启用"},
	{"qiyou", "汽油"},
	{"qiyu", "其余"},
	{"qiyuan", "起源"},
	{"qiyue", "七月 契约"},
	{"qizha", "欺诈"},
	{"qizhi", "气质 旗帜"},
	{"qizhong", "其中 器重"},
	{"qizi", "妻子 旗子"},
	{"qjjg", "勤俭建国"},
	{"qjjy", "勤俭节约"},
	{"qjwz", "迄今为止"},
	{"qjy", "取决于"},
	{"qjyf", "千钧一发"},
	{"qkds", "旗开得胜"},
	{"qlyf", "全力以赴"},
	{"qlzf", "勤劳致富"},
	{"qlzx", "千里之行"},
	{"qmwj", "亲密无间"},
	{"qnr", "青年人"},
	{"qpyl", "千篇一律"},
	{"qqcc", "清清楚楚"},
	{"qqkk", "勤勤恳恳"},
	{"qqss", "切切实实 确确实实"},
	{"qqxf", "恰恰相反"},
	{"qqzb", "求全责备"},
	{"qrqf", "恰如其分"},
	{"qrzt", "欺人之谈"},
	{"qsbj", "七手八脚"},
	{"qsgz", "全神贯注"},
	{"qsj", "全世界"},
	{"qskx", "切实可行"},
	{"qsly", "切身利益"},
	{"qsn", "青少年"},
	{"qswl", "千丝万缕"},
	{"qsww", "前所未闻"},
	{"qswy", "前所未有"},
	{"qsxx", "气势汹汹"},
	{"qtbj", "齐头并进"},
	{"qtgl", "奇谈怪论"},
	{"qtwx", "千头万绪"},
	{"qtx", "前提下"},
	{"quanbu", "全部"},
	{"quandang", "全党"},
	{"quandao", "劝导"},
	{"quanfu", "蜷伏"},
	{"quangao", "劝告"},
	{"quanguo", "全国"},
	{"quanheng", "权衡"},
	{"quanhui", "全会"},
	{"quanji", "拳击"},
	{"quanjie", "劝解 劝诫"},
	{"quanju", "全局"},
	{"quanjun", "全军"},
	{"quanli", "全力 权利 权力"},
	{"quanmao", "全貌"},
	{"quanmian", "全面 劝勉"},
	{"quanmin", "全民"},
	{"quanneng", "全能"},
	{"quannian", "全年"},
	{"quanpan", "全盘"},
	{"quanpin", "全拼"},
	{"quanqiu", "全球"},
	{"quanqu", "蜷曲"},
	{"quanquan", "全权 拳拳"},
	{"quanran", "全然"},
	{"quansheng", "全胜"},
	{"quanshu", "权术"},
	{"quanshui", "泉水"},
	{"quanshuo", "劝说"},
	{"quantao", "圈套"},
	{"quanti", "全体"},
	{"quantou", "拳头"},
	{"quanwei", "权威 劝慰"},
	{"quanwen", "全文"},
	{"quanxian", "全县 权限"},
	{"quanxiao", "全校"},
	{"quanyi", "权益 权宜"},
	{"quanyou", "劝诱"},
	{"quanyu", "痊愈"},
	{"quanzhi", "劝止"},
	{"quanzu", "劝阻"},
	{"qubie", "区别"},
	{"qucai", "屈才"},
	{"quchu", "驱除"},
	{"qudai", "取代"},
	{"qudao", "渠道"},
	{"qude", "取得"},
	{"qudi", "取缔"},
	{"qudiao", "曲调"},
	{"qudong", "驱动"},
	{"quebao", "确保"},
	{"quedian", "缺点"},
	{"queding", "确定"},
	{"quefa", "缺乏"},
	{"quekou", "缺口"},
	{"queli", "确立"},
	{"queqie", "确切"},
	{"queren", "确认"},
	{"queshao", "缺少"},
	{"quesheng", "缺省"},
	{"queshi", "确实"},
	{"quexi", "缺席"},
	{"quexian", "缺陷"},
	{"quexin", "确信"},
	{"quezao", "确凿"},
	{"quezi", "瘸子"},
	{"qufen", "区分"},
	{"qufu", "屈服"},
	{"qugan", "躯干"},
	{"quhua", "区划"},
	{"qujie", "曲解"},
	{"qujing", "取经"},
	{"qujue", "取决"},
	{"quke", "躯壳"},
	{"qule", "取乐"},
	{"qundai", "裙带"},
	{"qundao", "群岛"},
	{"qunian", "去年"},
	{"qunzhong", "群众"},
	{"ququ", "区区"},
	{"quru", "屈辱"},
	{"qusan", "驱散"},
	{"qushe", "取舍"},
	{"qusheng", "取胜"},
	{"qushi", "去世 驱使 趋势"},
	{"quti", "躯体"},
	{"quwei", "区位 区委 趣味"},
	{"quxian", "区县"},
	{"quxiang", "去向 趋向"},
	{"quxiao", "取消"},
	{"quxin", "取信"},
	{"quyi", "曲艺"},
	{"quyu", "区域"},
	{"quzhang", "区长"},
	{"quzhe", "曲折"},
	{"quzhi", "屈指"},
	{"quzhu", "驱逐"},
	{"quzi", "曲子"},
	{"qxgz", "奇形怪状"},
	{"qxqy", "全心全意"},
	{"qxt", "气象台"},
	{"qxwq", "气象万千"},
	{"qxxl", "齐心协力"},
	{"qycl", "岂有此理"},
	{"qyhg", "前因后果"},
	{"qyky", "情有可原"},
	{"qyl", "强有力"},
	{"qzbd", "求之不得"},
	{"qzbj", "取之不尽"},
	{"qzhj", "轻重缓急"},
	{"qzsh", "气壮山河"},
	{"qzwq", "千真万确"},
	{"randian", "燃点"},
	{"raner", "然而"},
	{"rangbu", "让步"},
	{"rangwei", "让位"},
	{"rangxian", "让贤"},
	{"ranhou", "然后"},
	{"ranliao", "燃料 染料"},
	{"ranran", "冉冉"},
	{"ranshao", "燃烧"},
	{"raoluan", "扰乱"},
	{"rcey", "如此而已"},
	{"rcjj", "人才济济"},
	{"reai", "热爱"},
	{"rechao", "热潮"},
	{"rechen", "热忱"},
	{"recheng", "热诚"},
	{"redai", "热带"},
	{"rehu", "热乎"},
	{"rehuo", "热火"},
	{"reliang", "热量"},
	{"relie", "热烈"},
	{"renao", "热闹"},
	{"rencai", "人才"},
	{"renci", "人次 仁慈"},
	{"rencuo", "认错"},
	{"renda", "人大"},
	{"rendai", "韧带"},
	{"rendao", "人道"},
	{"rende", "认得"},
	{"rending", "认定"},
	{"rengdiao", "扔掉"},
	{"renge", "人格"},
	{"rengjiu", "仍旧"},
	{"rengong", "人工"},
	{"rengou", "认购"},
	{"rengran", "仍然"},
	{"renhe", "任何"},
	{"renjia", "人家"},
	{"renjian", "人间"},
	{"renjie", "人杰"},
	{"renke", "认可"},
	{"renkou", "人口"},
	{"renlei", "人类"},
	{"renli", "人力"},
	{"renmen", "人们"},
	{"renmian", "任免"},
	{"renmin", "人民"},
	{"renming", "任命"},
	{"rennai", "忍耐"},
	{"renping", "任凭"},
	{"renqi", "任期"},
	{"renqing", "认清"},
	{"renquan", "人权"},
	{"renran", "荏苒"},
	{"renrang", "忍让"},
	{"renren", "人人"},
	{"renshen", "人参"},
	{"rensheng", "人生"},
	{"renshi", "人事 人士 认识"},
	{"renshou", "人手 忍受"},
	{"renshu", "认输"},
	{"rentong", "忍痛"},
	{"renwei", "认为 人为"},
	{"renwu", "人物 任务"},
	{"renxin", "人心 忍心"},
	{"renxuan", "人选"},
	{"renyi", "任意 仁义"},
	{"renyong", "任用"},
	{"renyuan", "人员"},
	{"renzhang", "认帐"},
	{"renzhen", "认真"},
	{"renzhi", "人质 任职"},
	{"renzui", "认罪"},
	{"renzuo", "认作"},
	{"reqie", "热切"},
	{"reqing", "热情"},
	{"reshi", "惹事"},
	{"rexian", "热线"},
	{"rexin", "热心"},
	{"rexue", "热血"},
	{"rezhong", "热衷"},
	{"rghc", "人工合成"},
	{"rhct", "热火朝天"},
	{"rhh", "热乎乎"},
	{"rhty", "如虎添翼"},
	{"ribao", "日报"},
	{"riben", "日本"},
	{"richan", "日产"},
	{"richang", "日常"},
	{"richeng", "日程"},
	{"riguang", "日光"},
	{"rihou", "日后"},
	{"riji", "日记"},
	{"rijiu", "日久"},
	{"rili", "日历"},
	{"riluo", "日落"},
	{"rinei", "日内"},
	{"riqi", "日期"},
	{"rishi", "日食"},
	{"riye", "日夜"},
	{"riyi", "日益"},
	{"riyong", "日用"},
	{"rizhao", "日照"},
	{"rizhong", "日中"},
	{"rizi", "日子"},
	{"rjb", "软件包"},
	{"rjdl", "人杰地灵"},
	{"rjqc", "人尽其才"},
	{"rjsk", "如饥似渴"},
	{"rjtc", "日久天长"},
	{"rlry", "任劳任怨"},
	{"rlyk", "热泪盈眶"},
	{"rmb", "人民币"},
	{"rmdh", "人民代表大会"},
	{"rmrb", "人民日报"},
	{"rmzj", "燃眉之急"},
	{"rongdian", "熔点"},
	{"rongguang", "容光"},
	{"ronghe", "融合"},
	{"ronghua", "溶化 熔化 融化"},
	{"ronghui", "融会"},
	{"ronghuo", "荣获"},
	{"rongji", "容积"},
	{"rongjie", "溶解"},
	{"rongliang", "容量"},
	{"rongma", "戎马"},
	{"rongmao", "容貌"},
	{"rongna", "容纳"},
	{"rongqia", "融洽"},
	{"rongren", "容忍"},
	{"rongru", "荣辱"},
	{"rongshen", "容身"},
	{"rongxian", "绒线"},
	{"rongxing", "荣幸"},
	{"rongxu", "容许"},
	{"rongyao", "荣耀"},
	{"rongye", "溶液"},
	{"rongyi", "容易"},
	{"rongyu", "荣誉"},
	{"rongzhi", "溶质"},
	{"rouhe", "柔和"},
	{"rouma", "肉麻"},
	{"rouruan", "柔软"},
	{"routi", "肉体"},
	{"rrwx", "任人为贤"},
	{"rryy", "日日夜夜"},
	{"rsg", "人生观"},
	{"rsl", "认识论"},
	{"rssf", "惹事生非"},
	{"rsss", "如上所述"},
	{"ruangu", "软骨"},
	{"ruanjian", "软件"},
	{"ruanjin", "软禁"},
	{"ruanpan", "软盘"},
	{"ruchang", "如常"},
	{"ruci", "如此"},
	{"rudang", "入党"},
	{"rudong", "蠕动"},
	{"rufang", "乳房"},
	{"ruguo", "如果"},
	{"ruhe", "如何"},
	{"ruili", "锐利"},
	{"ruixue", "瑞雪"},
	{"ruiyi", "锐意"},
	{"rujia", "儒家"},
	{"rujin", "如今"},
	{"ruma", "辱骂"},
	{"rumen", "入门"},
	{"rumi", "入迷"},
	{"runhua", "润滑"},
	{"ruodian", "弱点"},
	{"ruogan", "若干"},
	{"ruoshi", "若是"},
	{"ruoxiao", "弱小"},
	{"ruqi", "如期"},
	{"ruqin", "入侵"},
	{"ruruo", "如若"},
	{"rusheng", "儒生"},
	{"rushou", "入手"},
	{"rutong", "如同"},
	{"ruxia", "如下"},
	{"ruxuan", "入选"},
	{"ruyi", "如意"},
	{"ruyuan", "如愿"},
	{"ruzhang", "入帐"},
	{"ruzuo", "入座"},
	{"rwqs", "若无其事"},
	{"rykw", "人言可畏"},
	{"ryp", "日用品"},
	{"ryss", "若有所思"},
	{"rzcq", "人之常情"},
	{"sahuang", "撒谎"},
	{"saiche", "赛车"},
	{"saizi", "塞子"},
	{"sajiao", "撒娇"},
	{"sanbu", "散步 散布"},
	{"sanfa", "散发"},
	{"sanfei", "三废"},
	{"sangming", "丧命"},
	{"sangshi", "丧失"},
	{"sanguo", "三国"},
	{"sanhao", "三好"},
	{"sanhui", "散会"},
	{"sanjiao", "三角"},
	{"sanjie", "三届"},
	{"sanshi", "散失"},
	{"sanwen", "散文"},
	{"sanyue", "三月"},
	{"saochu", "扫除"},
	{"saodang", "扫荡"},
	{"saodi", "扫地"},
	{"saodong", "骚动"},
	{"saoluan", "骚乱"},
	{"saomiao", "扫描"},
	{"saomu", "扫墓"},
	{"saorao", "骚扰"},
	{"saoyang", "瘙痒"},
	{"saozhou", "扫帚"},
	{"satuo", "洒脱"},
	{"sbd", "说不定 舍不得"},
	{"sbgq", "说不过去"},
	{"sbl", "说不来"},
	{"sbs", "是不是 时不时 说不上"},
	{"sbss", "数不胜数"},
	{"sbxs", "素不相识"},
	{"sbyj", "身不由己"},
	{"scjz", "上层建筑"},
	{"scl", "生产力 生产率"},
	{"scp", "水产品"},
	{"scs", "四川省"},
	{"sctj", "市场调节"},
	{"scxx", "市场信息"},
	{"sdhp", "生动活泼"},
	{"sds", "山东省"},
	{"sdz", "水电站"},
	{"sebj", "视而不见"},
	{"secai", "色彩"},
	{"sediao", "色调"},
	{"semang", "色盲"},
	{"senglv", "僧侣"},
	{"senlin", "森林"},
	{"senyan", "森严"},
	{"seqing", "色情"},
	{"sese", "瑟瑟"},
	{"sey", "十二月"},
	{"seze", "色泽"},
	{"sfb", "司法部"},
	{"sffm", "赏罚分明"},
	{"sfl", "说服力"},
	{"sfq", "手风琴"},
	{"sfwc", "三番五次"},
	{"sgxh", "四个现代化"},
	{"sgy", "手工业"},
	{"shabai", "煞白"},
	{"shache", "刹车 煞车"},
	{"shafa", "沙发"},
	{"shagua", "傻瓜"},
	{"shahuang", "沙皇"},
	{"shaitai", "晒台"},
	{"shajin", "砂烬"},
	{"shalong", "沙龙"},
	{"shamo", "沙漠"},
	{"shana", "刹那"},
	{"shanao", "山坳"},
	{"shanban", "舢板"},
	{"shanbei", "陕北"},
	{"shanchang", "擅长"},
	{"shanchu", "删除"},
	{"shanchuan", "山川"},
	{"shandi", "山地"},
	{"shandian", "闪电"},
	{"shandong", "扇动 煽动 山东"},
	{"shanfeng", "山峰"},
	{"shangai", "删改"},
	{"shangang", "山岗 山冈"},
	{"shangban", "上班"},
	{"shangbao", "上报"},
	{"shangbian", "上边"},
	{"shangbiao", "商标"},
	{"shangbu", "上部"},
	{"shangce", "上策"},
	{"shangceng", "上层"},
	{"shangchang", "商场"},
	{"shangci", "上次 赏赐"},
	{"shangdang", "上当"},
	{"shangdeng", "上等"},
	{"shangdi", "上帝"},
	{"shangdian", "商店"},
	{"shangdiao", "上调"},
	{"shangding", "商定"},
	{"shangfang", "上访"},
	{"shanggan", "伤感"},
	{"shanggao", "上告"},
	{"shangguang", "赏光"},
	{"shanghai", "上海 伤害"},
	{"shanghang", "商行"},
	{"shangji", "上级 上集"},
	{"shangjin", "上进"},
	{"shangkong", "上空"},
	{"shanglai", "上来"},
	{"shangliang", "商量"},
	{"shangliu", "上流"},
	{"shangmen", "上门"},
	{"shangmian", "上面"},
	{"shangnian", "上年"},
	{"shangou", "山沟"},
	{"shangpin", "商品"},
	{"shangqia", "商洽"},
	{"shangqian", "上前"},
	{"shangqie", "尚且"},
	{"shangqu", "上去"},
	{"shangque", "商榷"},
	{"shangren", "商人 上任"},
	{"shangshan", "上山"},
	{"shangsheng", "上升"},
	{"shangshi", "赏识"},
	{"shangshu", "上述"},
	{"shangsi", "上司"},
	{"shangsu", "上诉"},
	{"shangtan", "商谈"},
	{"shangtao", "商讨"},
	{"shanguang", "闪光"},
	{"shangwen", "上文"},
	{"shangwu", "上午 商务"},
	{"shangxia", "上下"},
	{"shangxian", "上限"},
	{"shangxin", "伤心"},
	{"shangxun", "上旬"},
	{"shangyan", "上演"},
	{"shangye", "商业"},
	{"shangyi", "商议"},
	{"shangying", "上映"},
	{"shangyou", "上游"},
	{"shangzhang", "上涨"},
	{"shangzhen", "上阵"},
	{"shangzhou", "上周"},
	{"shanhe", "山河"},
	{"shanhou", "善后"},
	{"shanjie", "删节"},
	{"shanliang", "善良"},
	{"shanlin", "山林"},
	{"shanling", "山岭"},
	{"shanmai", "山脉"},
	{"shanmu", "杉木"},
	{"shanqu", "山区 扇区"},
	{"shanshui", "山水"},
	{"shanshuo", "闪烁"},
	{"shantou", "山头"},
	{"shanxi", "山西 陕西"},
	{"shanyang", "赡养"},
	{"shanyao", "闪耀"},
	{"shanyi", "善意"},
	{"shanyu", "善于"},
	{"shanzha", "山楂"},
	{"shanzhan", "善战"},
	{"shanzi", "擅自"},
	{"shaobing", "哨兵"},
	{"shaogong", "艄公"},
	{"shaohui", "烧毁"},
	{"shaojian", "少见"},
	{"shaoka", "哨卡"},
	{"shaoliang", "少量"},
	{"shaonian", "少年"},
	{"shaonv", "少女"},
	{"shaoshang", "烧伤"},
	{"shaoshu", "少数"},
	{"shaosuo", "哨所"},
	{"shaowei", "稍微"},
	{"shaoxu", "少许 稍许"},
	{"shaoye", "少爷"},
	{"shaoyou", "少有"},
	{"shaoyu", "少于"},
	{"shaozhuang", "少壮"},
	{"shaya", "沙哑"},
	{"shayan", "傻眼"},
	{"shayu", "鲨鱼"},
	{"shazi", "傻子"},
	{"shebei", "设备"},
	{"shecheng", "射程"},
	{"shechi", "奢侈"},
	{"shede", "舍得"},
	{"shefa", "设法"},
	{"shefu", "慑服"},
	{"shegou", "赊购"},
	{"shehua", "奢华"},
	{"shehui", "社会"},
	{"sheji", "社稷 涉及 设计 射击 舍己"},
	{"shejiao", "社交"},
	{"sheli", "设立"},
	{"shelie", "涉猎"},
	{"shelun", "社论"},
	{"shemi", "奢靡"},
	{"shenao", "深奥"},
	{"shenbao", "申报"},
	{"shenbian", "身边 申辩"},
	{"shencai", "身材 神采"},
	{"shencha", "审查"},
	{"shenchen", "深沉"},
	{"shenchu", "深处 审处"},
	{"shending", "审定"},
	{"shendu", "深度"},
	{"shener", "甚而"},
	{"shenfen", "身分 身份"},
	{"shengcai", "生财"},
	{"shengchan", "生产"},
	{"shengcheng", "生成"},
	{"shengchu", "牲畜"},
	{"shengcun", "生存"},
	{"shengda", "盛大"},
	{"shengde", "省得"},
	{"shengdi", "胜地"},
	{"shengdian", "盛典"},
	{"shengdiao", "声调"},
	{"shengdong", "生动"},
	{"shengfen", "省份"},
	{"shengfu", "胜负 省府"},
	{"shenggen", "生根"},
	{"shenghua", "升华"},
	{"shenghui", "省会 盛会"},
	{"shenghuo", "生活"},
	{"shengji", "生机 生计 升级"},
	{"shengjie", "圣洁"},
	{"shengjing", "圣经"},
	{"shengkai", "盛开"},
	{"shengkou", "牲口"},
	{"shengkuang", "盛况"},
	{"shengli", "生理 胜利 省力"},
	{"shenglue", "省略"},
	{"shengming", "生命 声明 盛名"},
	{"shengpa", "生怕"},
	{"shengpi", "生僻"},
	{"shengping", "生平"},
	{"shengqi", "升旗"},
	{"shengqian", "生前 升迁"},
	{"shengqing", "盛情"},
	{"shengqu", "生趣 省去"},
	{"shengren", "胜任"},
	{"shengri", "生日"},
	{"shengshi", "省事 盛事 声势"},
	{"shengshu", "生疏"},
	{"shengsi", "生死 胜似"},
	{"shengsu", "胜诉"},
	{"shengsuo", "绳索"},
	{"shengtai", "生态"},
	{"shengtao", "声讨"},
	{"shengwang", "声望"},
	{"shengwei", "省委"},
	{"shengwu", "生物"},
	{"shengxi", "生息"},
	{"shengxia", "剩下 盛夏"},
	{"shengxian", "圣贤"},
	{"shengxiao", "生效 生肖"},
	{"shengxing", "盛行"},
	{"shengya", "生涯"},
	{"shengyi", "生意"},
	{"shengyin", "声音"},
	{"shengyu", "生于 生育 胜于 声誉 剩余"},
	{"shengyuan", "声援"},
	{"shengzhang", "生长 省长 声张 胜仗"},
	{"shengzhi", "生殖 圣旨"},
	{"shengzhuang", "盛装"},
	{"shenhe", "审核"},
	{"shenhou", "深厚"},
	{"shenhua", "深化 神话"},
	{"shenhuo", "甚或"},
	{"shenji", "审计"},
	{"shenjing", "神经"},
	{"shenke", "深刻"},
	{"shenli", "审理"},
	{"shenme", "什么"},
	{"shenmei", "审美"},
	{"shenmi", "神秘"},
	{"shenming", "申明"},
	{"shenpan", "审判"},
	{"shenpang", "身旁"},
	{"shenpi", "审批"},
	{"shenqi", "神气 神奇"},
	{"shenqian", "深浅"},
	{"shenqie", "深切"},
	{"shenqing", "深情 申请"},
	{"shenqu", "身躯"},
	{"shenru", "深入 渗入"},
	{"shensheng", "神圣"},
	{"shenshi", "身世 绅士"},
	{"shenshou", "伸手"},
	{"shenshu", "申述"},
	{"shensu", "神速 申诉"},
	{"shensuo", "伸缩"},
	{"shentai", "神态"},
	{"shenti", "身体"},
	{"shentong", "神通"},
	{"shentou", "渗透"},
	{"shenwen", "审问"},
	{"shenxian", "神仙"},
	{"shenxue", "神学 申雪"},
	{"shenxun", "审讯"},
	{"shenyang", "沈阳"},
	{"shenyi", "审议"},
	{"shenyin", "呻吟"},
	{"shenying", "身影"},
	{"shenyuan", "深远 申冤"},
	{"shenyue", "审阅"},
	{"shenzao", "深造"},
	{"shenzhang", "伸张"},
	{"shenzhen", "深圳"},
	{"shenzhi", "甚至"},
	{"shenzhong", "深重 慎重"},
	{"shenzhou", "神州"},
	{"sheqi", "舍弃"},
	{"sheqian", "赊欠"},
	{"sheshi", "设施"},
	{"shetuan", "社团"},
	{"shewang", "奢望"},
	{"shexian", "射线 涉嫌"},
	{"shexiang", "设想"},
	{"shexiao", "赊销"},
	{"sheyan", "设宴"},
	{"sheying", "摄影"},
	{"sheyuan", "社员"},
	{"shezhang", "社长"},
	{"shezhi", "设置"},
	{"shezu", "涉足"},
	{"shgd", "社会公德"},
	{"shibai", "失败"},
	{"shibi", "势必"},
	{"shibian", "事变"},
	{"shibiao", "师表"},
	{"shibie", "识别"},
	{"shibushi", "是不是"},
	{"shice", "失策 史册"},
	{"shicha", "视察"},
	{"shichang", "时常 失常 市场"},
	{"shichen", "时辰"},
	{"shichuan", "失传"},
	{"shicong", "侍从"},
	{"shidai", "时代 世代"},
	{"shidang", "适当"},
	{"shide", "是的"},
	{"shidi", "实地"},
	{"shidian", "试点"},
	{"shidiao", "失调 失掉"},
	{"shiduan", "事端"},
	{"shiduo", "拾掇"},
	{"shier", "时而"},
	{"shifan", "示范 师范"},
	{"shifang", "施放 释放"},
	{"shifei", "是非"},
	{"shifen", "时分 十分"},
	{"shifeng", "侍奉"},
	{"shifou", "是否"},
	{"shifu", "师傅"},
	{"shigan", "实干"},
	{"shige", "是个 诗歌"},
	{"shigong", "施工"},
	{"shigu", "事故 世故 尸骨"},
	{"shiguan", "使馆"},
	{"shiguang", "时光"},
	{"shihao", "嗜好"},
	{"shihe", "适合"},
	{"shihou", "时候 事后 侍候"},
	{"shihuan", "使唤"},
	{"shihui", "实惠"},
	{"shihuo", "失火"},
	{"shiji", "时机 事迹 实际 世纪 试剂 史籍"},
	{"shijia", "施加 市价"},
	{"shijian", "时间 事件 世间 实践"},
	{"shijiao", "视角 市郊"},
	{"shijie", "使节 世界 十届"},
	{"shijin", "使劲 什锦 失禁"},
	{"shijing", "市井"},
	{"shiju", "时局"},
	{"shijue", "视觉"},
	{"shike", "时刻 石刻"},
	{"shikuai", "市侩"},
	{"shikuang", "实况"},
	{"shili", "事理 实力 事例 势利 失利 势力 视力 示例"},
	{"shilian", "失恋"},
	{"shiliang", "适量 矢量"},
	{"shiling", "拾零 失灵 适龄"},
	{"shima", "是吗"},
	{"shimao", "时髦"},
	{"shimi", "失密"},
	{"shimin", "市民"},
	{"shiming", "使命"},
	{"shinei", "市内 室内"},
	{"shipian", "诗篇"},
	{"shipin", "食品 视频"},
	{"shipo", "识破"},
	{"shiqi", "时期"},
	{"shiqian", "事前"},
	{"shiqie", "失窃"},
	{"shiqing", "事情 实情"},
	{"shiqu", "失去 市区 时区"},
	{"shiren", "诗人"},
	{"shirong", "市容"},
	{"shirun", "湿润"},
	{"shiruo", "示弱"},
	{"shisan", "失散"},
	{"shise", "失色"},
	{"shishe", "施舍"},
	{"shisheng", "师生 失声"},
	{"shishi", "事实 时时 时事 失事 实施 失实 逝世"},
	{"shishishang", "事实上"},
	{"shishou", "尸首 失守"},
	{"shishu", "实数 施属"},
	{"shisu", "世俗"},
	{"shisuan", "失算"},
	{"shitai", "事态"},
	{"shitan", "试探"},
	{"shitang", "食堂"},
	{"shiti", "实体 尸体"},
	{"shitou", "石头 势头"},
	{"shituan", "试图"},
	{"shiwan", "十万"},
	{"shiwang", "失望"},
	{"shiwei", "市委 示威"},
	{"shiwu", "事物 食物 失误 实物 事务 时务 饰物 十五"},
	{"shixi", "实习"},
	{"shixian", "事先 视线 实现"},
	{"shixiang", "试想 事项"},
	{"shixiao", "实效 试销"},
	{"shixin", "失信"},
	{"shixing", "实行 试行 施行"},
	{"shixiu", "失修"},
	{"shixue", "实学 史学"},
	{"shiyan", "实验 试验 食言 誓言"},
	{"shiyang", "式样"},
	{"shiye", "事业 实业 失业 视野"},
	{"shiyi", "时宜 事宜 示意 诗意 适宜 释疑"},
	{"shiying", "适应"},
	{"shiyong", "使用 实用 试用 适用"},
	{"shiyou", "事由 石油 誓由"},
	{"shiyu", "适于"},
	{"shiyuan", "誓愿"},
	{"shiyue", "十月 失约"},
	{"shizai", "实在"},
	{"shizhan", "实战 施展"},
	{"shizhang", "市长 师长"},
	{"shizhe", "使者 侍者"},
	{"shizhen", "失真 市镇"},
	{"shizheng", "市政"},
	{"shizhi", "试制 实质 市制 食指 失职"},
	{"shizhong", "适中 示众 始终"},
	{"shizhuang", "时装"},
	{"shizi", "师资"},
	{"shizu", "十足 实足 失足 始祖"},
	{"shoubei", "守备"},
	{"shoubiao", "手表"},
	{"shoubing", "收兵"},
	{"shoucang", "收藏"},
	{"shouce", "手册"},
	{"shouchang", "首倡"},
	{"shouchen", "寿辰"},
	{"shoucheng", "收成"},
	{"shouchuang", "首创"},
	{"shouci", "首次"},
	{"shoucun", "收存"},
	{"shoudan", "寿诞"},
	{"shoudao", "受到"},
	{"shoudi", "守敌"},
	{"shoudu", "首度 首都"},
	{"shouduan", "手段"},
	{"shoufa", "守法"},
	{"shoufan", "首犯"},
	{"shoufu", "收复 收服 首府 首富"},
	{"shougan", "手感"},
	{"shougao", "手稿"},
	{"shouge", "收割"},
	{"shougou", "收购"},
	{"shouhai", "受害"},
	{"shouhou", "守候"},
	{"shouhu", "守护"},
	{"shouhui", "收回 受贿"},
	{"shouhuo", "收获"},
	{"shouji", "收集 手机"},
	{"shoujia", "售价"},
	{"shoujiang", "受奖 授奖"},
	{"shoujiao", "手脚 收缴"},
	{"shoujie", "首届"},
	{"shoujiu", "守旧"},
	{"shouju", "收据"},
	{"shouke", "授课"},
	{"shouli", "受理"},
	{"shoulian", "收敛"},
	{"shouling", "首领"},
	{"shouliu", "收留"},
	{"shoulu", "收录"},
	{"shoumai", "收买"},
	{"shouming", "授命 寿命"},
	{"shounao", "首脑"},
	{"shoupi", "首批"},
	{"shouquan", "授权"},
	{"shourong", "收容"},
	{"shouru", "收入"},
	{"shouruan", "手软"},
	{"shouruo", "瘦弱"},
	{"shoushi", "首饰"},
	{"shoushu", "手术"},
	{"shousuo", "收缩"},
	{"shoutiao", "收条"},
	{"shouting", "收听"},
	{"shouwei", "收尾 首尾"},
	{"shouxian", "首先"},
	{"shouxiang", "首相"},
	{"shouxiao", "瘦小 收效"},
	{"shouxu", "手续"},
	{"shouxue", "瘦削"},
	{"shouyang", "收养"},
	{"shouyao", "首要"},
	{"shouyi", "受益 收益 兽医"},
	{"shouyong", "受用"},
	{"shouyu", "授予"},
	{"shouze", "守则"},
	{"shouzhang", "首长"},
	{"shouzhi", "收支"},
	{"shouzuo", "首座"},
	{"shs", "生活上 上海市"},
	{"shuaibai", "衰败"},
	{"shuaida", "摔打"},
	{"shuaijiao", "摔交"},
	{"shuaijie", "衰竭"},
	{"shuailao", "衰老"},
	{"shuairuo", "衰弱"},
	{"shuaitui", "衰退"},
	{"shuaiwang", "衰亡"},
	{"shuailing", "率领"},
	{"shuaixian", "率先"},
	{"shualai", "耍赖"},
	{"shuangbian", "双边"},
	{"shuangfang", "双方"},
	{"shuanghuang", "双簧"},
	{"shuangkou", "爽口"},
	{"shuangkuai", "爽快"},
	{"shuanglang", "爽朗"},
	{"shuangpin", "双拼"},
	{"shuangzhong", "双重"},
	{"shuanong", "耍弄"},
	{"shuaxi", "刷洗"},
	{"shuaxin", "刷新"},
	{"shubao", "书报"},
	{"shuben", "书本"},
	{"shucai", "蔬菜"},
	{"shuchang", "舒畅"},
	{"shuchu", "输出"},
	{"shucong", "树丛"},
	{"shudao", "疏导"},
	{"shudian", "书店"},
	{"shue", "数额"},
	{"shufa", "抒发 书法"},
	{"shufang", "书房"},
	{"shufu", "舒服 束缚"},
	{"shuguang", "曙光"},
	{"shuhan", "蜀汉"},
	{"shuhu", "疏忽 倏忽"},
	{"shuhua", "书画"},
	{"shuidao", "水稻"},
	{"shuidian", "水电"},
	{"shuifen", "水分"},
	{"shuiguo", "水果"},
	{"shuihuo", "水火"},
	{"shuijiao", "睡觉"},
	{"shuijing", "水晶"},
	{"shuiku", "水库"},
	{"shuili", "水利"},
	{"shuiliu", "水流"},
	{"shuimian", "睡眠"},
	{"shuiping", "水平"},
	{"shuishou", "税收"},
	{"shuiwu", "税务"},
	{"shuixia", "水下"},
	{"shuixing", "水性"},
	{"shuiyuan", "水源"},
	{"shuizai", "水灾"},
	{"shuizhi", "谁知"},
	{"shuji", "书记 书籍"},
	{"shujia", "暑假"},
	{"shujian", "书简"},
	{"shuju", "数据"},
	{"shukan", "书刊"},
	{"shuli", "数理 树立 竖立"},
	{"shulian", "熟练"},
	{"shuliang", "数量"},
	{"shulie", "数列"},
	{"shulou", "疏漏"},
	{"shuluo", "数落"},
	{"shuma", "数码"},
	{"shumian", "书面"},
	{"shumin", "庶民"},
	{"shumu", "数目 书目 树木"},
	{"shunbian", "顺便"},
	{"shuncha", "顺差"},
	{"shunci", "顺次"},
	{"shuncong", "顺从"},
	{"shundang", "顺当"},
	{"shundao", "顺道"},
	{"shunfeng", "顺风"},
	{"shuniu", "枢纽"},
	{"shunli", "顺利"},
	{"shunlu", "顺路"},
	{"shunshi", "瞬时 顺势"},
	{"shunxin", "顺心"},
	{"shunxu", "顺序"},
	{"shunying", "顺应"},
	{"shunzhuo", "顺着"},
	{"shuodao", "说到 说道"},
	{"shuodong", "说动"},
	{"shuofa", "说法"},
	{"shuofu", "说服"},
	{"shuoguo", "硕果"},
	{"shuohua", "说话"},
	{"shuojiao", "说教"},
	{"shuoming", "说明"},
	{"shuoqing", "说情"},
	{"shuoshi", "硕士"},
	{"shuping", "述评"},
	{"shuqi", "署期 暑期"},
	{"shuqing", "抒情"},
	{"shuren", "熟人"},
	{"shuru", "输入"},
	{"shusan", "疏散"},
	{"shushi", "属实 熟识 舒适"},
	{"shushou", "束手"},
	{"shushu", "叔叔"},
	{"shushuo", "数说 述说"},
	{"shusong", "输送 疏松"},
	{"shutan", "舒坦"},
	{"shutong", "疏通"},
	{"shuxi", "熟悉"},
	{"shuxiang", "属相"},
	{"shuxin", "舒心 书信"},
	{"shuxing", "属性"},
	{"shuxue", "数学"},
	{"shuyu", "属于 术语"},
	{"shuyuan", "疏远"},
	{"shuzhan", "舒展"},
	{"shuzhi", "数值 树脂"},
	{"shuzhuang", "梳妆"},
	{"shuzi", "数字"},
	{"shuzui", "赎罪"},
	{"shy", "售货员"},
	{"shzy", "社会主义"},
	{"siban", "死板"},
	{"sibian", "四边"},
	{"sibie", "死别"},
	{"sichao", "思潮"},
	{"sichou", "丝绸"},
	{"sichu", "四处"},
	{"sichuan", "四川"},
	{"sidang", "死党"},
	{"sidi", "死敌"},
	{"sifa", "司法"},
	{"sifang", "四方"},
	{"sihai", "四海"},
	{"sihao", "丝毫"},
	{"sihou", "嗣后"},
	{"sihu", "似乎"},
	{"sihua", "四化"},
	{"sihuan", "死缓"},
	{"sihui", "撕毁"},
	{"sihuo", "死活"},
	{"siji", "四季 司机"},
	{"sijiao", "私交"},
	{"sijie", "四届"},
	{"sikao", "思考"},
	{"sili", "私利"},
	{"siliao", "私了"},
	{"siling", "司令"},
	{"silu", "思路"},
	{"simian", "四面"},
	{"sinian", "思念 私念"},
	{"siqu", "死去"},
	{"siren", "私人"},
	{"sishang", "死伤"},
	{"sishi", "私事 死尸"},
	{"sishui", "死水"},
	{"sisuo", "思索"},
	{"siti", "四体"},
	{"situn", "私吞"},
	{"siwang", "死亡"},
	{"siwei", "思维"},
	{"siwen", "斯文"},
	{"sixia", "私下"},
	{"sixiang", "思想 四项"},
	{"sixin", "死心 私心"},
	{"sixing", "肆行 死刑"},
	{"siyou", "私有"},
	{"siyu", "私欲"},
	{"siyuan", "寺院"},
	{"siyue", "四月"},
	{"sizhe", "死者"},
	{"sizhou", "四周"},
	{"sizi", "私自"},
	{"sizui", "死罪"},
	{"sjbm", "拾金不昧"},
	{"sjbz", "身经百战"},
	{"sjc", "书记处"},
	{"sjg", "世界观"},
	{"sjjr", "舍己救人"},
	{"sjk", "数据库"},
	{"sjq", "省军区"},
	{"sjqd", "杀鸡取蛋"},
	{"sjs", "实际上 设计所 试金石"},
	{"sjwr", "舍己为人"},
	{"sjy", "设计院"},
	{"sjyb", "随机应变"},
	{"sjz", "十进制 石家庄"},
	{"skez", "适可而止"},
	{"slh", "数理化"},
	{"slj", "收录机"},
	{"sljz", "十六进制"},
	{"sll", "湿漉漉"},
	{"slws", "三令五申"},
	{"sly", "司令员"},
	{"smbf", "四面八方"},
	{"smjl", "手忙脚乱"},
	{"sml", "生命力"},
	{"sms", "说明书"},
	{"smy", "什么样"},
	{"smyl", "深谋远虑"},
	{"smz", "数目字"},
	{"songbang", "松绑"},
	{"songbie", "送别"},
	{"songchi", "松弛"},
	{"songdong", "松动"},
	{"songge", "颂歌"},
	{"songjin", "松劲"},
	{"songkuai", "松快"},
	{"songli", "耸立 送礼"},
	{"songsan", "松散"},
	{"songtao", "松涛"},
	{"songxie", "松懈"},
	{"songyang", "颂扬"},
	{"songyong", "怂恿"},
	{"songzang", "送葬"},
	{"songzhong", "送终"},
	{"soucha", "搜查"},
	{"souji", "搜集"},
	{"sousuo", "搜索"},
	{"souxun", "搜寻"},
	{"spc", "售票处"},
	{"spgy", "食品工业"},
	{"spx", "水平线"},
	{"sqbb", "生气勃勃"},
	{"sqhy", "诗情画意"},
	{"sqlr", "盛气凌人"},
	{"sqsj", "山穷水尽"},
	{"sqsm", "十全十美"},
	{"sqyz", "首屈一指"},
	{"srb", "四人帮"},
	{"srlj", "损人利己"},
	{"srqc", "深入浅出"},
	{"ssby", "莎士比亚"},
	{"ssef", "似是而非"},
	{"sskk", "时时刻刻"},
	{"sslc", "姗姗来迟"},
	{"ssqs", "实事求是"},
	{"sss", "事实上"},
	{"sssd", "随时随地"},
	{"sssz", "善始善终"},
	{"sstz", "顺水推舟"},
	{"stgs", "四通公司"},
	{"stjt", "四通集团"},
	{"stlx", "身体力行"},
	{"stph", "生态平衡"},
	{"suanchu", "酸楚"},
	{"suanfa", "算法"},
	{"suanji", "算计"},
	{"suanle", "算了"},
	{"suanpan", "算盘"},
	{"suanshu", "算术"},
	{"suanteng", "酸疼"},
	{"suantong", "酸痛"},
	{"sucai", "素材"},
	{"sucheng", "速成"},
	{"sudan", "苏丹"},
	{"sudu", "速度"},
	{"suhua", "俗话"},
	{"suibi", "随笔"},
	{"suibian", "随便"},
	{"suichu", "随处"},
	{"suicong", "随从"},
	{"suidi", "随地"},
	{"suihe", "随和"},
	{"suihou", "随后"},
	{"suiji", "随机 随即"},
	{"suiran", "虽然"},
	{"suishen", "随身"},
	{"suishi", "随时"},
	{"suishou", "随手"},
	{"suishu", "岁数"},
	{"suishuo", "虽说"},
	{"suitong", "随同"},
	{"suixin", "随心"},
	{"suixing", "随行"},
	{"suiyi", "随意 遂意"},
	{"suiyue", "岁月"},
	{"suize", "虽则"},
	{"suizhe", "随着"},
	{"suku", "诉苦"},
	{"sulian", "苏联"},
	{"suliao", "塑料"},
	{"sulv", "速率"},
	{"sumiao", "素描"},
	{"sumu", "肃穆"},
	{"sunhai", "损害"},
	{"sunhao", "损耗"},
	{"sunhuai", "损坏"},
	{"sunshang", "损伤"},
	{"sunshi", "损失"},
	{"sunzi", "孙子"},
	{"suode", "所得"},
	{"suoduan", "缩短"},
	{"suojian", "缩减"},
	{"suolian", "锁链"},
	{"suoneng", "所能"},
	{"suoqu", "索取"},
	{"suoshi", "唆使"},
	{"suoshu", "所属"},
	{"suosui", "琐碎"},
	{"suowei", "所为 所谓"},
	{"suoxiao", "缩小"},
	{"suoxie", "缩写 琐屑"},
	{"suoxing", "索性"},
	{"suoyi", "所以"},
	{"suoyin", "索引"},
	{"suoying", "缩影"},
	{"suoyou", "所有"},
	{"suozai", "所在"},
	{"suozhang", "所长"},
	{"suozhi", "所至"},
	{"suozi", "梭子"},
	{"suqing", "肃清"},
	{"suqu", "苏区"},
	{"sushe", "宿舍"},
	{"sushu", "素数"},
	{"sushuo", "诉说"},
	{"susong", "诉讼"},
	{"suxiao", "速效"},
	{"suxie", "速写"},
	{"suxing", "苏醒"},
	{"suyang", "素养"},
	{"suying", "宿营"},
	{"suyuan", "溯源 宿愿 夙愿"},
	{"suzao", "塑造"},
	{"suzhan", "速战"},
	{"suzhi", "素质"},
	{"suzhou", "苏州"},
	{"swa", "苏维埃"},
	{"swj", "税务局"},
	{"swzd", "手舞足蹈"},
	{"sxd", "少先队"},
	{"sxjk", "身心健康"},
	{"sxs", "思想上 山西省 陕西省"},
	{"sxtd", "死心塌地"},
	{"sxwb", "顺息万变"},
	{"sxwd", "所向无敌"},
	{"sxx", "思想性"},
	{"syb", "商业部"},
	{"sybe", "说一不二"},
	{"syj", "收音机"},
	{"syjb", "杀一儆百"},
	{"syjz", "使用价值"},
	{"syq", "所有权"},
	{"sys", "沈阳市"},
	{"syx", "实用性"},
	{"syxs", "睡眼惺忪"},
	{"syy", "十一月"},
	{"syz", "所有制 私有制"},
	{"szjr", "时至今日"},
	{"szry", "始终如一"},
	{"szsw", "所作所为"},
	{"szy", "甚至于"},
	{"tabu", "踏步"},
	{"tade", "他的 它的 她的"},
	{"tafang", "塌方"},
	{"taibei", "台北"},
	{"taici", "台词"},
	{"taidu", "态度"},
	{"taifeng", "台风"},
	{"taijie", "台阶"},
	{"taiping", "太平"},
	{"tairan", "泰然"},
	{"taishan", "泰山"},
	{"taishi", "态势"},
	{"taitai", "太太"},
	{"taitou", "抬头"},
	{"taiwan", "台湾"},
	{"taiyang", "太阳"},
	{"taiyuan", "太原"},
	{"tam", "天安门"},
	{"tamen", "他们 它们 她们"},
	{"tanbai", "坦白"},
	{"tance", "探测"},
	{"tancheng", "坦诚"},
	{"tanfang", "探访"},
	{"tanfeng", "谈锋"},
	{"tanfu", "叹服"},
	{"tangbu", "倘不"},
	{"tangci", "搪瓷"},
	{"tangong", "弹弓"},
	{"tangruo", "倘若"},
	{"tangsai", "搪塞"},
	{"tangshang", "烫伤"},
	{"tangtang", "堂堂"},
	{"tangtu", "唐突"},
	{"tanhe", "弹劾"},
	{"tanhu", "袒护"},
	{"tanhua", "谈话"},
	{"tanhuan", "瘫痪"},
	{"tanjiu", "探究"},
	{"tanke", "坦克"},
	{"tanlan", "贪婪"},
	{"tanlun", "谈论"},
	{"tanpai", "摊派"},
	{"tanpan", "谈判"},
	{"tanqi", "叹气"},
	{"tanqin", "探亲 弹琴"},
	{"tanran", "坦然"},
	{"tanshuai", "坦率"},
	{"tansuo", "探索"},
	{"tantao", "探讨"},
	{"tantian", "谈天"},
	{"tanting", "探听"},
	{"tantu", "贪图 谈吐 滩涂"},
	{"tanwang", "探望"},
	{"tanwen", "探问"},
	{"tanwu", "贪污"},
	{"tanxi", "叹息"},
	{"tanxian", "探险"},
	{"tanxin", "谈心"},
	{"tanxing", "弹性"},
	{"tanxun", "探询"},
	{"tanzang", "贪赃"},
	{"taoben", "逃奔"},
	{"taobi", "逃避"},
	{"taobing", "逃兵"},
	{"taocuan", "逃窜"},
	{"taodun", "逃遁"},
	{"taofa", "讨伐"},
	{"taofan", "讨饭"},
	{"taogou", "套购"},
	{"taohao", "讨好"},
	{"taohuan", "讨还"},
	{"taojia", "讨价"},
	{"taoli", "桃李"},
	{"taolue", "韬略"},
	{"taolun", "讨论"},
	{"taoming", "逃命"},
	{"taonan", "逃难"},
	{"taopao", "逃跑"},
	{"taoqi", "淘气"},
	{"taosheng", "逃生"},
	{"taotai", "淘汰"},
	{"taotao", "滔滔"},
	{"taotuo", "逃脱"},
	{"taowang", "逃亡"},
	{"taoyan", "讨厌"},
	{"taoye", "陶冶"},
	{"taozi", "桃子"},
	{"taozou", "逃走"},
	{"taozui", "陶醉"},
	{"taqing", "踏青"},
	{"taren", "他人"},
	{"tashi", "踏实"},
	{"tashuo", "他说"},
	{"taxiang", "他乡"},
	{"tblj", "挑拨离间"},
	{"tbs", "台北市"},
	{"tby", "贪便宜"},
	{"tcjg", "统筹兼顾"},
	{"tdb", "铁道部"},
	{"tdgg", "土地改革"},
	{"tdxl", "同等学历"},
	{"tebie", "特别"},
	{"techan", "特产"},
	{"techang", "特长"},
	{"techu", "特出"},
	{"teci", "特此"},
	{"teda", "特大"},
	{"tedeng", "特等"},
	{"tedi", "特地"},
	{"tedian", "特点"},
	{"teding", "特定"},
	{"teji", "特级 特技 特急"},
	{"tejiang", "特将"},
	{"tekan", "特刊"},
	{"tekuai", "特快"},
	{"teli", "特例"},
	{"tengai", "疼爱"},
	{"tengda", "腾达"},
	{"tengxie", "誊写"},
	{"tepai", "特派"},
	{"tequ", "特区"},
	{"tequan", "特权"},
	{"tes", "托儿所"},
	{"tese", "特色"},
	{"teshi", "特使"},
	{"teshu", "特殊"},
	{"tewei", "特为"},
	{"tewu", "特务"},
	{"texiao", "特效"},
	{"texie", "特写"},
	{"texing", "特性"},
	{"teyao", "特邀"},
	{"teyi", "特意"},
	{"teyou", "特有"},
	{"teyue", "特约"},
	{"tezheng", "特征"},
	{"tezhi", "特制"},
	{"tezhong", "特种"},
	{"tezx", "铤而走险"},
	{"tfmj", "突飞猛进"},
	{"tfw", "铁饭碗"},
	{"tggk", "同甘共苦"},
	{"thd", "提货单"},
	{"thry", "谈何容易"},
	{"tianbao", "填报"},
	{"tianbian", "天边"},
	{"tianbiao", "填表"},
	{"tianbu", "填补"},
	{"tiancai", "天才 甜菜"},
	{"tianchang", "天长"},
	{"tianchong", "填充"},
	{"tiandi", "天地 田地"},
	{"tiane", "天鹅"},
	{"tianfu", "天府 天赋"},
	{"tianji", "天机 天际"},
	{"tianjia", "添加"},
	{"tianjin", "天津"},
	{"tianjing", "恬静"},
	{"tiankong", "天空 填空"},
	{"tianli", "天理"},
	{"tianliang", "天良 天亮"},
	{"tianmei", "甜美"},
	{"tianmi", "甜蜜"},
	{"tianming", "天明"},
	{"tianping", "天平"},
	{"tianqi", "天气"},
	{"tianqiao", "天桥"},
	{"tianran", "天然"},
	{"tianrang", "天壤"},
	{"tianse", "天色"},
	{"tianshang", "天上"},
	{"tiansheng", "天生"},
	{"tianshi", "天使"},
	{"tiantang", "天堂"},
	{"tianti", "天体"},
	{"tiantian", "天天"},
	{"tiantou", "甜头"},
	{"tianwen", "天文"},
	{"tianxia", "天下"},
	{"tianxian", "天险 天仙"},
	{"tianxing", "天性"},
	{"tianya", "天涯"},
	{"tianye", "田野"},
	{"tianzhen", "天真"},
	{"tianzhi", "天职 添置"},
	{"tianzi", "天资"},
	{"tiaoba", "挑拔"},
	{"tiaodong", "跳动 挑动"},
	{"tiaodou", "挑逗"},
	{"tiaogao", "跳高"},
	{"tiaohe", "调和"},
	{"tiaoji", "调剂"},
	{"tiaojian", "条件"},
	{"tiaojie", "调解 调节"},
	{"tiaokuan", "条款"},
	{"tiaoli", "调理 条理 条例"},
	{"tiaoling", "条令"},
	{"tiaopei", "调配"},
	{"tiaoti", "挑剔"},
	{"tiaoting", "调停"},
	{"tiaowen", "条文"},
	{"tiaowu", "跳舞"},
	{"tiaoxi", "调戏"},
	{"tiaoxin", "挑衅"},
	{"tiaoxuan", "挑选"},
	{"tiaoyue", "条约"},
	{"tiaozhan", "挑战"},
	{"tiaozheng", "调整"},
	{"tiaozi", "条子"},
	{"tibo", "提拨"},
	{"ticai", "题材 体裁"},
	{"ticao", "体操"},
	{"ticha", "体察"},
	{"tichang", "提倡"},
	{"ticheng", "提成"},
	{"tichu", "提出 剔除"},
	{"tici", "题词"},
	{"tidai", "替代"},
	{"tidui", "梯队"},
	{"tiebu", "贴补"},
	{"tiedao", "铁道"},
	{"tiejin", "贴近"},
	{"tielu", "铁路"},
	{"tieqie", "贴切"},
	{"tieshen", "贴身"},
	{"tiezheng", "铁证"},
	{"tifa", "提法"},
	{"tifang", "提防"},
	{"tigang", "提纲"},
	{"tigao", "提高"},
	{"tige", "体格"},
	{"tigong", "提供"},
	{"tihuan", "替换"},
	{"tihui", "体会"},
	{"tihuo", "提货"},
	{"tiji", "体积"},
	{"tijia", "提价"},
	{"tili", "体力 体例"},
	{"tilian", "提炼"},
	{"tiliang", "体谅"},
	{"timian", "体面"},
	{"timing", "提名 题名"},
	{"timu", "题目"},
	{"tingba", "挺拔"},
	{"tingban", "停办"},
	{"tingbo", "停泊"},
	{"tingchan", "停产"},
	{"tingcong", "听从"},
	{"tingdun", "停顿"},
	{"tinggong", "停工"},
	{"tinggua", "挺括"},
	{"tinghou", "听候"},
	{"tinghua", "听话"},
	{"tinghuo", "停火"},
	{"tingjian", "听见"},
	{"tingju", "厅局"},
	{"tingjue", "听觉"},
	{"tingliu", "停留"},
	{"tingping", "听凭"},
	{"tingqu", "听取"},
	{"tingren", "听任"},
	{"tingshuo", "听说"},
	{"tingxin", "听信"},
	{"tingzhang", "厅长"},
	{"tingzhi", "停止 停职 停滞"},
	{"tingzhong", "听众"},
	{"tiqi", "提起"},
	{"tiqian", "提前"},
	{"tiqu", "提取"},
	{"tisheng", "提升"},
	{"tishi", "提示"},
	{"titan", "体坛"},
	{"titie", "体贴"},
	{"tiwen", "提问 体温"},
	{"tixi", "体系"},
	{"tixian", "体现"},
	{"tixing", "体型 提醒"},
	{"tiyan", "体验"},
	{"tiyao", "提要"},
	{"tiyi", "提议"},
	{"tiyu", "体育"},
	{"tizhi", "体制 体质"},
	{"tizi", "题字"},
	{"tjb", "统计表"},
	{"tjfs", "条件反射"},
	{"tjhj", "讨价还价"},
	{"tjjq", "囤积居奇"},
	{"tjs", "天津市"},
	{"tjx", "条件下"},
	{"tlh", "讨论会"},
	{"tlj", "拖拉机"},
	{"tmd", "他们的"},
	{"tmh", "同盟会"},
	{"tndb", "天南地北"},
	{"tongban", "同伴"},
	{"tongbao", "同胞 通报"},
	{"tongbei", "同辈"},
	{"tongbing", "通病"},
	{"tongbu", "同步"},
	{"tongchang", "通常"},
	{"tongcheng", "通称 统称"},
	{"tongchi", "痛斥"},
	{"tongchou", "统筹"},
	{"tongchu", "痛楚"},
	{"tongchuang", "同窗"},
	{"tongdao", "同道 通道"},
	{"tongdeng", "同等"},
	{"tongdian", "通电"},
	{"tongdie", "通牒"},
	{"tongdu", "通读"},
	{"tonggao", "通告"},
	{"tonggou", "统购"},
	{"tongguo", "通过"},
	{"tonghang", "通航"},
	{"tonghen", "痛恨"},
	{"tonghua", "同化 通话 童话"},
	{"tonghui", "痛悔"},
	{"tonghun", "通婚"},
	{"tongji", "统计 通辑 痛击"},
	{"tongju", "同居"},
	{"tongku", "痛苦 痛哭"},
	{"tongkuai", "痛快"},
	{"tongliao", "同僚"},
	{"tongling", "通令"},
	{"tongmeng", "同盟"},
	{"tongnian", "同年 童年"},
	{"tongqi", "同期 通气"},
	{"tongqing", "同情"},
	{"tongrong", "通融"},
	{"tongshang", "同上 通商"},
	{"tongshi", "同时 同事"},
	{"tongshu", "统属"},
	{"tongshuai", "统帅"},
	{"tongshun", "通顺"},
	{"tongsu", "通俗"},
	{"tongwang", "通往"},
	{"tongwu", "痛恶"},
	{"tongxi", "痛惜"},
	{"tongxia", "统辖"},
	{"tongxiang", "通向 同乡"},
	{"tongxiao", "统销 通宵 通晓"},
	{"tongxin", "同心 痛心 通信"},
	{"tongxing", "同行 通行 同性"},
	{"tongxue", "同学"},
	{"tongxun", "通讯"},
	{"tongyang", "同样"},
	{"tongyi", "同意 统一"},
	{"tongyong", "通用"},
	{"tongyou", "通邮"},
	{"tongzhan", "统战"},
	{"tongzhi", "同志 统治 通知"},
	{"touan", "投案"},
	{"touban", "头版"},
	{"touben", "投奔"},
	{"toubiao", "投标"},
	{"touchan", "投产"},
	{"touche", "透彻"},
	{"toudeng", "头等"},
	{"toufang", "投放"},
	{"touji", "投机"},
	{"toukao", "投靠"},
	{"toulan", "投篮 偷懒"},
	{"toulu", "头颅 透露"},
	{"toumian", "头面"},
	{"touming", "透明"},
	{"toumu", "头目"},
	{"tounao", "头脑"},
	{"toupiao", "投票"},
	{"touqi", "透气"},
	{"touru", "投入"},
	{"toushen", "投身"},
	{"toushi", "透视"},
	{"toutong", "头痛"},
	{"touxian", "偷闲"},
	{"touxiang", "投降"},
	{"touxu", "头绪"},
	{"touying", "投影"},
	{"touzhi", "投掷"},
	{"touzi", "头子 投资"},
	{"tpk", "突破口"},
	{"tpy", "太平洋"},
	{"tqdl", "通情达理"},
	{"tqyb", "天气预报"},
	{"trxj", "突然袭击"},
	{"tscl", "妥善处理"},
	{"tsdw", "通俗读物"},
	{"tsec", "挺身而出"},
	{"tsg", "图书馆"},
	{"ttbj", "滔滔不绝"},
	{"ttkk", "痛痛快快"},
	{"tts", "团体赛"},
	{"ttss", "踏踏实实"},
	{"tu'an", "图案"},
	{"tuanji", "湍急"},
	{"tuanjie", "团结"},
	{"tuanju", "团聚"},
	{"tuanliu", "湍流"},
	{"tuanti", "团体"},
	{"tuanyuan", "团员 团圆"},
	{"tuanzhang", "团长"},
	{"tubian", "突变"},
	{"tubiao", "图表"},
	{"tuchan", "土产"},
	{"tuchu", "突出"},
	{"tudi", "土地 徒弟"},
	{"tufei", "土匪"},
	{"tugai", "土改 涂改"},
	{"tuhua", "图画 土话"},
	{"tuibian", "蜕变"},
	{"tuibu", "退步"},
	{"tuice", "推测"},
	{"tuichi", "推迟"},
	{"tuichong", "推崇"},
	{"tuichu", "退出"},
	{"tuidao", "推导"},
	{"tuidong", "推动"},
	{"tuiduan", "推断"},
	{"tuifan", "推翻"},
	{"tuifei", "颓废"},
	{"tuiguang", "推广"},
	{"tuihua", "退化 蜕化"},
	{"tuihui", "退回"},
	{"tuijian", "推荐"},
	{"tuijin", "推进"},
	{"tuiju", "推举"},
	{"tuikai", "推开"},
	{"tuili", "推理"},
	{"tuilun", "推论"},
	{"tuiqiao", "推敲"},
	{"tuique", "推却 退却"},
	{"tuirang", "推让 退让"},
	{"tuisang", "颓丧"},
	{"tuise", "退色"},
	{"tuisuan", "推算"},
	{"tuisuo", "退缩"},
	{"tuitang", "颓唐"},
	{"tuituo", "推托"},
	{"tuiwei", "推诿"},
	{"tuiwu", "退伍"},
	{"tuixiang", "推向"},
	{"tuixiao", "推销"},
	{"tuixie", "推卸"},
	{"tuixing", "推行"},
	{"tuixiu", "退休"},
	{"tuixue", "退学"},
	{"tuiyi", "推移"},
	{"tuizhi", "退职"},
	{"tuji", "突击"},
	{"tujie", "图解"},
	{"tujing", "途径"},
	{"tulao", "徒劳"},
	{"tuli", "图例"},
	{"tulu", "吐露"},
	{"tunbing", "吞并"},
	{"tunji", "囤积"},
	{"tunmo", "吞没"},
	{"tuntu", "吞吐"},
	{"tuobei", "驼背"},
	{"tuobu", "拓补"},
	{"tuochu", "脱出"},
	{"tuodang", "妥当"},
	{"tuogui", "脱轨"},
	{"tuohuang", "拓荒"},
	{"tuojie", "脱节"},
	{"tuola", "拖拉"},
	{"tuoli", "脱离"},
	{"tuoma", "唾骂"},
	{"tuoqi", "唾弃"},
	{"tuoshan", "妥善"},
	{"tuoshen", "脱身"},
	{"tuoxie", "妥协"},
	{"tuoyan", "拖延"},
	{"tuoye", "唾液"},
	{"tupian", "图片"},
	{"tupo", "突破"},
	{"tuqi", "突起"},
	{"turan", "突然 徒然"},
	{"turang", "土壤"},
	{"tusha", "屠杀"},
	{"tushou", "徒手"},
	{"tushu", "图书"},
	{"tutan", "吐痰"},
	{"tuwei", "突围"},
	{"tuwu", "突兀"},
	{"tuxiang", "图像"},
	{"tuxing", "图形 徒刑"},
	{"tuzhang", "图章"},
	{"tuzhi", "图纸"},
	{"tuzhong", "途中"},
	{"tuzhu", "土著"},
	{"tuzi", "秃子"},
	{"twdq", "贪污盗窃"},
	{"tws", "台湾省"},
	{"twsh", "贪污受贿"},
	{"txdd", "提心吊胆"},
	{"txs", "通讯社"},
	{"txtd", "同心同德"},
	{"txxl", "同心协力"},
	{"txzf", "推心置腹"},
	{"tyc", "体育场"},
	{"tydl", "体育锻炼"},
	{"tyg", "体育馆"},
	{"tyjw", "腾云驾雾"},
	{"tyn", "太阳能"},
	{"tys", "太原市"},
	{"tywf", "天衣无缝"},
	{"tyx", "通用性"},
	{"tyyd", "体育运动"},
	{"tzb", "团支部"},
	{"tzbq", "停滞不前"},
	{"tzm", "同志们"},
	{"tzrh", "天灾人祸"},
	{"tzrz", "听之任之"},
	{"tzs", "通知书"},
	{"waibi", "外币"},
	{"waibian", "外边"},
	{"waibiao", "外表"},
	{"waibin", "外宾"},
	{"waibu", "外部"},
	{"waichuan", "外传"},
	{"waicun", "外存"},
	{"waidi", "外地"},
	{"waidiao", "外调"},
	{"waifeng", "歪风"},
	{"waiguan", "外观"},
	{"waiguo", "外国"},
	{"waihang", "外行"},
	{"waihui", "外汇"},
	{"waijia", "外加"},
	{"waijiao", "外交"},
	{"waijie", "外界"},
	{"waijing", "外景"},
	{"waike", "外科"},
	{"waikuai", "外快"},
	{"wailiu", "外流"},
	{"waimao", "外貌 外贸"},
	{"waimian", "外面"},
	{"waiqin", "外勤"},
	{"waiqu", "歪曲"},
	{"waishang", "外商 外伤"},
	{"waishe", "外设"},
	{"waisheng", "外省 外甥"},
	{"waishi", "外事"},
	{"waiwei", "外围"},
	{"waiwen", "外文"},
	{"waixian", "外线"},
	{"waixiao", "外销"},
	{"waixie", "歪斜"},
	{"waiyan", "外延"},
	{"waiyin", "外因"},
	{"waiyu", "外语"},
	{"waiyuan", "外援"},
	{"waizai", "外在"},
	{"waizhai", "外债"},
	{"waizi", "外资"},
	{"wajie", "瓦解"},
	{"wajue", "挖掘"},
	{"waku", "挖苦"},
	{"wali", "瓦砾"},
	{"wanban", "万般"},
	{"wanbao", "晚报"},
	{"wanbei", "完备"},
	{"wanbi", "完毕"},
	{"wancan", "晚餐"},
	{"wancheng", "完成"},
	{"wandai", "万代"},
	{"wandi", "顽敌"},
	{"wandun", "万吨"},
	{"wane", "万恶"},
	{"wanfan", "晚饭"},
	{"wanfen", "万分"},
	{"wangchang", "往常"},
	{"wangchao", "王朝"},
	{"wangdiao", "忘掉"},
	{"wangdong", "妄动"},
	{"wangfa", "枉法"},
	{"wangfan", "往返"},
	{"wangfei", "枉费"},
	{"wangfu", "往复"},
	{"wangguo", "王国 亡国"},
	{"wanghou", "往后"},
	{"wanghuai", "忘怀"},
	{"wangji", "忘记 旺季"},
	{"wanglai", "往来"},
	{"wangliang", "魍魉"},
	{"wangluo", "网络"},
	{"wangming", "亡命"},
	{"wangnian", "往年"},
	{"wangong", "完工"},
	{"wangque", "忘却"},
	{"wangran", "枉然 惘然"},
	{"wangri", "往日"},
	{"wangsheng", "旺盛"},
	{"wangshi", "往事"},
	{"wangtu", "妄图"},
	{"wangu", "万古 顽固"},
	{"wangwang", "往往 汪汪"},
	{"wangwo", "忘我"},
	{"wangxi", "往昔"},
	{"wangxiang", "妄想"},
	{"wangyang", "汪洋"},
	{"wangye", "网页"},
	{"wangyuan", "望远"},
	{"wangzi", "王子"},
	{"wanhao", "完好"},
	{"wanhui", "晚会 挽回"},
	{"wanhun", "晚婚"},
	{"wanjian", "晚间"},
	{"wanjie", "完结"},
	{"wanjiu", "挽救"},
	{"wanju", "玩具"},
	{"wankang", "顽抗"},
	{"wanle", "完了"},
	{"wanli", "挽力"},
	{"wanlu", "弯路"},
	{"wanmei", "完美"},
	{"wanneng", "万能"},
	{"wannian", "万年 晚年"},
	{"wannong", "玩弄"},
	{"wanqi", "晚期"},
	{"wanqiang", "顽强"},
	{"wanqu", "弯曲"},
	{"wanquan", "完全"},
	{"wanshan", "完善"},
	{"wanshang", "晚上 玩赏"},
	{"wanshi", "万事 万世"},
	{"wanshua", "玩耍"},
	{"wansui", "万岁"},
	{"wanwan", "万万"},
	{"wanwu", "万物"},
	{"wanxia", "晚霞"},
	{"wanxiang", "万象"},
	{"wanxiao", "玩笑"},
	{"wanxing", "万幸"},
	{"wanyan", "婉言"},
	{"wanyi", "万一"},
	{"wanyuan", "万元"},
	{"wanzheng", "完整 顽症"},
	{"wanzhong", "万众"},
	{"wanzhuan", "宛转"},
	{"wasi", "瓦斯"},
	{"wate", "瓦特"},
	{"wawa", "娃娃"},
	{"wbsb", "外部设备"},
	{"wbzd", "微不足道"},
	{"wcbf", "五彩缤纷"},
	{"wcjj", "无产阶级"},
	{"wclj", "微处理机"},
	{"wcz", "无产者"},
	{"wdyz", "无动于衷"},
	{"weiba", "尾巴"},
	{"weibei", "违背"},
	{"weibi", "未必 威逼"},
	{"weibo", "微波 微薄"},
	{"weiceng", "未曾"},
	{"weichang", "未尝"},
	{"weichi", "维持"},
	{"weici", "为此"},
	{"weida", "伟大"},
	{"weidao", "味道"},
	{"weidu", "纬度 唯独"},
	{"weie", "巍峨"},
	{"weifa", "违法"},
	{"weifan", "违反 违犯"},
	{"weifeng", "威风"},
	{"weigan", "桅杆"},
	{"weiguan", "微观"},
	{"weiguo", "卫国 诿过"},
	{"weihai", "危害"},
	{"weihe", "为何"},
	{"weihu", "维护"},
	{"weiji", "危及 微机 危机 危急"},
	{"weijian", "围歼"},
	{"weijiao", "围剿"},
	{"weijie", "慰藉"},
	{"weijin", "违禁"},
	{"weijing", "未经"},
	{"weiju", "畏惧"},
	{"weikang", "违抗"},
	{"weike", "未可"},
	{"weikong", "唯恐 惟恐"},
	{"weikou", "胃口"},
	{"weilai", "未来"},
	{"weilao", "慰劳"},
	{"weile", "为了"},
	{"weili", "威力"},
	{"weimi", "委靡"},
	{"weimian", "未免"},
	{"weimiao", "微妙"},
	{"weimu", "帷幕"},
	{"weinan", "危难 畏难"},
	{"weineng", "未能"},
	{"weipai", "委派"},
	{"weiqi", "为期"},
	{"weiqie", "畏怯"},
	{"weiqu", "委曲 委屈"},
	{"weiran", "未然 巍然"},
	{"weirao", "围绕"},
	{"weiren", "伟人 委任"},
	{"weiruo", "微弱"},
	{"weishe", "威慑"},
	{"weisheng", "卫生 尾声"},
	{"weishenme", "为什么"},
	{"weishi", "卫士 威势"},
	{"weishou", "为首"},
	{"weishu", "为数"},
	{"weisui", "尾随 未遂"},
	{"weisuo", "畏缩 萎缩 猥琐"},
	{"weituo", "委托"},
	{"weiwan", "委婉"},
	{"weiwang", "危亡"},
	{"weiwei", "巍巍"},
	{"weiwen", "慰问"},
	{"weiwu", "唯物 威武"},
	{"weixi", "微细"},
	{"weixia", "威吓"},
	{"weixian", "危险"},
	{"weixiao", "微小 微笑"},
	{"weixie", "威协 威胁 猥亵"},
	{"weixin", "维新 唯心 违心 威信"},
	{"weixing", "微型 卫星"},
	{"weixiu", "维修"},
	{"weiyan", "威严"},
	{"weiye", "伟业"},
	{"weiyi", "唯一 位移"},
	{"weiyu", "位于 谓语"},
	{"weiyuan", "委员"},
	{"weizhi", "为止 位置 未知"},
	{"weizhong", "为重"},
	{"weizhu", "为主"},
	{"weizhuang", "伪装"},
	{"wenben", "文本"},
	{"wenbing", "瘟病"},
	{"wenbu", "稳步"},
	{"wenda", "问答"},
	{"wendang", "稳当 文档"},
	{"wending", "稳定"},
	{"wendu", "温度"},
	{"wengu", "稳固"},
	{"wenhao", "问好"},
	{"wenhe", "温和 吻合"},
	{"wenhua", "文化"},
	{"wenjian", "文件 稳健"},
	{"wenjin", "问津"},
	{"wenjing", "文静"},
	{"wenju", "文具"},
	{"wenke", "文科"},
	{"wenmang", "文盲"},
	{"wenming", "文明 闻名"},
	{"wennuan", "温暖"},
	{"wenping", "文凭"},
	{"wenren", "文人"},
	{"wenrou", "温柔"},
	{"wenshi", "问世"},
	{"wentan", "文坛"},
	{"wenti", "问题 文体"},
	{"wentuo", "稳妥"},
	{"wenwu", "文物"},
	{"wenxian", "文献"},
	{"wenxuan", "文选"},
	{"wenxue", "文学"},
	{"wenxun", "问讯 闻讯"},
	{"wenyi", "文艺 瘟疫"},
	{"wenyu", "文娱"},
	{"wenzhai", "文摘"},
	{"wenzhang", "文章"},
	{"wenzhong", "稳重"},
	{"wenzi", "文字"},
	{"wenzui", "问罪"},
	{"wesw", "望而生畏"},
	{"wfed", "闻风而动"},
	{"wflj", "违法乱纪"},
	{"wfxq", "歪风邪气"},
	{"wgzx", "温故知新"},
	{"whb", "文化部 文汇报"},
	{"whg", "文化馆 文化宫"},
	{"whs", "武汉市"},
	{"whsh", "五湖四海"},
	{"whsy", "忘乎所以"},
	{"whwn", "问寒问暖"},
	{"whyl", "文化娱乐"},
	{"whzs", "玩忽职守"},
	{"wjb", "外交部"},
	{"wjl", "无纪律"},
	{"wjsm", "五讲四美"},
	{"wjws", "无拘无束"},
	{"wkfg", "无可奉告"},
	{"wkfy", "无可非议"},
	{"wknh", "无可奈何"},
	{"wlmq", "乌鲁木齐"},
	{"wlqn", "无理取闹"},
	{"wlqs", "五劳七伤"},
	{"wlrh", "无论如何"},
	{"wmjl", "物美价廉"},
	{"wml", "误码率"},
	{"wmlm", "文明礼貌"},
	{"wmyx", "无名英雄"},
	{"wnwl", "无能为力"},
	{"wocang", "窝藏"},
	{"wochuang", "卧床"},
	{"wodang", "我党"},
	{"wodao", "卧倒"},
	{"wode", "我的"},
	{"wogong", "窝工"},
	{"woguo", "我国"},
	{"wojun", "我军"},
	{"women", "我们"},
	{"wonang", "窝囊"},
	{"wosheng", "我省"},
	{"woxiao", "我校"},
	{"wqby", "为期不远"},
	{"wqbz", "乌七八糟"},
	{"wqwj", "无穷无尽"},
	{"wrqt", "误入歧途"},
	{"wsb", "卫生部"},
	{"wsbd", "纹丝不动"},
	{"wsdj", "万事大吉"},
	{"wsjb", "万事俱备"},
	{"wsm", "为什么"},
	{"wsw", "无所谓"},
	{"wsyw", "为所欲为"},
	{"wszw", "无所作为"},
	{"wubei", "吾辈"},
	{"wubi", "无比 五笔 务必 舞弊"},
	{"wubian", "无边"},
	{"wubu", "无不"},
	{"wucai", "五彩"},
	{"wucan", "午餐"},
	{"wucha", "误差"},
	{"wuchang", "无常 无偿 舞场 武昌"},
	{"wuchi", "无耻"},
	{"wucong", "无从"},
	{"wuda", "武打"},
	{"wudao", "舞蹈"},
	{"wudi", "无敌"},
	{"wudong", "舞动"},
	{"wudou", "武斗"},
	{"wuduan", "武断"},
	{"wufa", "无法"},
	{"wufan", "午饭"},
	{"wufang", "无妨"},
	{"wufei", "无非"},
	{"wugong", "武功"},
	{"wugou", "污垢"},
	{"wugu", "无故"},
	{"wuguan", "无关 五官 武官"},
	{"wuhai", "无害 诬害"},
	{"wuhan", "武汉"},
	{"wuhe", "无何"},
	{"wuhei", "乌黑"},
	{"wuhu", "五湖 呜呼"},
	{"wuhui", "误会 舞会 污秽"},
	{"wuji", "无及 无机"},
	{"wujia", "物价"},
	{"wujian", "无间 物件"},
	{"wujie", "误解 五届"},
	{"wujin", "五金"},
	{"wukui", "无愧"},
	{"wulai", "无赖 诬赖"},
	{"wuli", "无理 物理 无礼 物力 武力"},
	{"wuliao", "无聊"},
	{"wulun", "无论"},
	{"wumie", "污蔑 诬蔑"},
	{"wunai", "无奈"},
	{"wuneng", "无能"},
	{"wuning", "毋宁"},
	{"wunong", "务农"},
	{"wupin", "物品"},
	{"wuqi", "无期 五七 武器"},
	{"wuqing", "无情"},
	{"wuqiong", "无穷"},
	{"wuqu", "舞曲"},
	{"wuquan", "无权"},
	{"wuran", "污染"},
	{"wuren", "无任"},
	{"wuru", "污辱 侮辱"},
	{"wuse", "物色"},
	{"wushang", "无上 误伤"},
	{"wusheng", "无声"},
	{"wushi", "午时 务使 无视 误事 务实"},
	{"wushu", "无数 武术"},
	{"wushuang", "无双"},
	{"wushui", "午睡"},
	{"wusi", "五四 无私"},
	{"wutai", "舞台"},
	{"wuti", "无题 物体"},
	{"wuting", "舞厅"},
	{"wuwei", "无为 无谓"},
	{"wuwu", "无物"},
	{"wuxi", "无锡"},
	{"wuxia", "无暇"},
	{"wuxian", "无限 诬陷"},
	{"wuxiao", "无效"},
	{"wuxing", "五星"},
	{"wuxiu", "午休"},
	{"wuxu", "无须 无需 务虚"},
	{"wuye", "午夜"},
	{"wuyi", "五一 无益 无疑"},
	{"wuyin", "无垠"},
	{"wuyong", "无用 毋庸"},
	{"wuyu", "无余"},
	{"wuyuan", "无缘"},
	{"wuyue", "五月"},
	{"wuzheng", "物证"},
	{"wuzhi", "无知 物质"},
	{"wuzhuang", "武装"},
	{"wuzi", "物资 兀自 误字"},
	{"wuzui", "无罪"},
	{"wwbz", "无微不至"},
	{"wwl", "唯物论"},
	{"wxcd", "卧薪尝胆"},
	{"wxd", "无线电"},
	{"wxj", "微型机"},
	{"wxl", "唯心论"},
	{"wxwk", "问心无愧"},
	{"wyr", "玩意儿"},
	{"wyh", "委员会"},
	{"wywg", "无缘无故"},
	{"wyz", "委员长"},
	{"wzl", "误字率"},
	{"wzqz", "无足轻重"},
	{"wzs", "未知数"},
	{"wzwq", "完整无缺"},
	{"xald", "心安理得"},
	{"xas", "西安市"},
	{"xbq", "西半球"},
	{"xbx", "行不行"},
	{"xbzx", "相比之下"},
	{"xcb", "宣传部"},
	{"xcdx", "新陈代谢"},
	{"xcp", "新产品 畜产品"},
	{"xcq", "西城区"},
	{"xcww", "喜出望外"},
	{"xdey", "相对而言"},
	{"xdh", "现代化"},
	{"xdr", "想当然"},
	{"xdwc", "相对误差"},
	{"xdwk", "先睹为快"},
	{"xesx", "形而上学"},
	{"xeyj", "显而易见"},
	{"xfgj", "西方国家"},
	{"xfp", "消费品"},
	{"xfsf", "想方设法"},
	{"xfzr", "先发制人"},
	{"xgcl", "兴高采烈"},
	{"xhs", "新华社"},
	{"xhsd", "新华书店"},
	{"xi'an", "西安"},
	{"xiaai", "狭隘"},
	{"xiaban", "下班"},
	{"xiabei", "下辈"},
	{"xiabian", "下边"},
	{"xiace", "下策"},
	{"xiaceng", "下层"},
	{"xiachang", "下场"},
	{"xiachen", "下沉"},
	{"xiaci", "下次 瑕疵"},
	{"xiada", "下达"},
	{"xiadao", "吓倒"},
	{"xiadeng", "下等"},
	{"xiadu", "下毒"},
	{"xiafa", "下发"},
	{"xiafang", "下放"},
	{"xiagu", "峡谷"},
	{"xiaguang", "霞光"},
	{"xiahua", "瞎话"},
	{"xiai", "喜爱"},
	{"xiaji", "下级 下集 夏季"},
	{"xiajiang", "下降"},
	{"xiake", "侠客"},
	{"xialai", "下来"},
	{"xialian", "下联"},
	{"xialiang", "夏粮"},
	{"xialie", "下列"},
	{"xialing", "下令"},
	{"xialiu", "下流"},
	{"xialuo", "下落"},
	{"xiama", "下马"},
	{"xiamen", "厦门"},
	{"xiamian", "下面"},
	{"xianbao", "献宝"},
	{"xianbei", "先辈"},
	{"xianchang", "现场"},
	{"xiancheng", "现成 县城"},
	{"xianchou", "献丑"},
	{"xianci", "献词"},
	{"xiancun", "现存"},
	{"xiandai", "现代"},
	{"xiandao", "先导"},
	{"xiande", "显得"},
	{"xiandi", "险地"},
	{"xianding", "限定"},
	{"xiandu", "限度"},
	{"xianduan", "线段"},
	{"xiane", "限额 险恶"},
	{"xianfa", "宪法"},
	{"xianfeng", "先锋 险峰"},
	{"xiangai", "相爱"},
	{"xiangbi", "相比 想必"},
	{"xiangcha", "相差"},
	{"xiangchen", "相称"},
	{"xiangchu", "相处"},
	{"xiangchuan", "相传"},
	{"xiangchun", "香醇"},
	{"xiangcun", "乡村"},
	{"xiangdang", "相当"},
	{"xiangdao", "向导"},
	{"xiangdeng", "相等"},
	{"xiangdui", "相对"},
	{"xiangfa", "想法"},
	{"xiangfan", "相反"},
	{"xiangfang", "相仿"},
	{"xianggan", "相干"},
	{"xianggang", "香港"},
	{"xiangge", "相隔"},
	{"xianggu", "香菇"},
	{"xiangguan", "相关"},
	{"xianghao", "相好"},
	{"xianghu", "相互"},
	{"xiangji", "相继"},
	{"xiangjia", "相加"},
	{"xiangjian", "相见 相减"},
	{"xiangjiao", "相交 橡胶"},
	{"xiangjin", "相近 详尽"},
	{"xiangkou", "巷口"},
	{"xianglai", "向来"},
	{"xianglian", "相连"},
	{"xiangliang", "向量 响亮"},
	{"xiangmao", "相貌"},
	{"xiangmu", "项目"},
	{"xiangnian", "想念"},
	{"xiangpian", "相片"},
	{"xiangqi", "想起"},
	{"xiangqing", "详情"},
	{"xiangshang", "向上"},
	{"xiangsheng", "相声 响声"},
	{"xiangshi", "相识 翔实"},
	{"xiangshou", "享受"},
	{"xiangsi", "相思 相似"},
	{"xiangtian", "香甜"},
	{"xiangtong", "相同"},
	{"xiangtou", "相投"},
	{"xiangui", "显贵"},
	{"xiangwang", "向往"},
	{"xiangxi", "详细"},
	{"xiangxia", "向下 乡下"},
	{"xiangxian", "象限"},
	{"xiangxiang", "想象"},
	{"xiangxin", "相信"},
	{"xiangyan", "香烟"},
	{"xiangyi", "相依 相宜"},
	{"xiangying", "相应 相映 响应"},
	{"xiangyong", "享用"},
	{"xiangyu", "相遇"},
	{"xiangyue", "相约"},
	{"xiangzhen", "乡镇"},
	{"xiangzheng", "象征"},
	{"xiangzi", "箱子"},
	{"xianhai", "陷害"},
	{"xianhe", "显赫"},
	{"xianhong", "鲜红"},
	{"xianhou", "先后"},
	{"xianhua", "鲜花 献花 闲话"},
	{"xianhui", "贤惠"},
	{"xianji", "献计 献技"},
	{"xianjian", "显见"},
	{"xianjie", "衔接"},
	{"xianjin", "先进 现金"},
	{"xianjing", "险境 陷阱"},
	{"xiankuan", "现款"},
	{"xiankuang", "现况"},
	{"xianli", "先例 献礼"},
	{"xianlie", "先烈"},
	{"xianlu", "线路 显露"},
	{"xianmei", "鲜美"},
	{"xianming", "鲜明 贤明"},
	{"xianmu", "羡慕 显目"},
	{"xianneng", "贤能"},
	{"xianqi", "先期 掀起 限期 嫌弃"},
	{"xianqian", "先前 先遣"},
	{"xianqing", "险情"},
	{"xianqu", "先驱"},
	{"xianran", "显然"},
	{"xianren", "贤人 闲人 现任"},
	{"xianru", "陷入"},
	{"xiansan", "闲散"},
	{"xianshen", "献身"},
	{"xiansheng", "先生"},
	{"xianshi", "现实 显示 先是"},
	{"xianshu", "娴熟"},
	{"xiansuo", "线索"},
	{"xiantan", "闲谈 险滩"},
	{"xiantian", "先天"},
	{"xiantiao", "线条"},
	{"xianwei", "县委 纤维"},
	{"xianxian", "显现"},
	{"xianxiang", "现象"},
	{"xianxing", "现行"},
	{"xianxue", "鲜血"},
	{"xianyan", "显眼 鲜艳"},
	{"xianyao", "显要 险要 显耀"},
	{"xianyi", "现役 嫌疑"},
	{"xianyou", "现有"},
	{"xianyu", "限于"},
	{"xianza", "闲杂"},
	{"xianzai", "现在"},
	{"xianzhang", "县长 宪章"},
	{"xianzhi", "限制 先知 闲置 闲职"},
	{"xianzhu", "显著"},
	{"xianzhuang", "现状"},
	{"xianzu", "险阻"},
	{"xiaobao", "小报"},
	{"xiaobei", "小辈"},
	{"xiaobing", "笑柄"},
	{"xiaochen", "消沉"},
	{"xiaochu", "消除"},
	{"xiaodu", "消毒"},
	{"xiaofa", "效法"},
	{"xiaofan", "小贩"},
	{"xiaofang", "消防"},
	{"xiaofei", "消费"},
	{"xiaofeng", "校风"},
	{"xiaogui", "小鬼"},
	{"xiaoguo", "效果"},
	{"xiaohai", "小孩"},
	{"xiaohao", "消耗"},
	{"xiaohua", "消化 笑话"},
	{"xiaohui", "小惠 销毁"},
	{"xiaohun", "销魂"},
	{"xiaoji", "消极"},
	{"xiaojian", "削减"},
	{"xiaojie", "小结 小姐"},
	{"xiaojing", "孝敬"},
	{"xiaokan", "校刊"},
	{"xiaokang", "小康"},
	{"xiaolao", "效劳"},
	{"xiaoli", "效力"},
	{"xiaolu", "销路"},
	{"xiaolv", "效率"},
	{"xiaomie", "消灭"},
	{"xiaomo", "消磨"},
	{"xiaoneng", "效能"},
	{"xiaoqi", "消气"},
	{"xiaoqian", "消遣"},
	{"xiaorong", "笑容"},
	{"xiaoruo", "削弱"},
	{"xiaosa", "潇洒"},
	{"xiaoshe", "校舍"},
	{"xiaoshi", "小时 消失 消逝"},
	{"xiaoshou", "消瘦 销售"},
	{"xiaoshu", "小数"},
	{"xiaoshuo", "小说"},
	{"xiaotiao", "萧条"},
	{"xiaoxi", "消息"},
	{"xiaoxiang", "肖像"},
	{"xiaoxin", "小心"},
	{"xiaoxiong", "枭雄"},
	{"xiaoxue", "小学"},
	{"xiaoyan", "效验"},
	{"xiaoyao", "逍遥"},
	{"xiaoyi", "效益"},
	{"xiaoying", "效应"},
	{"xiaoyou", "校友"},
	{"xiaoyu", "小于"},
	{"xiaoyuan", "校园"},
	{"xiaozang", "销赃"},
	{"xiaozhang", "校长 嚣张"},
	{"xiaozhong", "效忠"},
	{"xiaozu", "小组"},
	{"xiaqing", "下情"},
	{"xiaqu", "下去 辖区"},
	{"xiashou", "下手 夏收"},
	{"xiashu", "下属"},
	{"xiashui", "下水"},
	{"xiatai", "下台"},
	{"xiatian", "夏天"},
	{"xiawen", "下文"},
	{"xiawu", "下午"},
	{"xiaxian", "下限"},
	{"xiaxiang", "下乡 遐想"},
	{"xiayi", "狭义"},
	{"xiayou", "下游"},
	{"xiazhai", "狭窄"},
	{"xiazhi", "夏至"},
	{"xiazhong", "夏种"},
	{"xibao", "喜报 细胞"},
	{"xibei", "西北"},
	{"xibian", "西边"},
	{"xibo", "稀薄 锡箔"},
	{"xican", "西餐"},
	{"xidi", "洗涤"},
	{"xidong", "翕动"},
	{"xidu", "吸毒"},
	{"xiechu", "写出"},
	{"xiecong", "协从"},
	{"xiedai", "携带"},
	{"xiedao", "邪道"},
	{"xiediao", "协调"},
	{"xieding", "协定"},
	{"xiedu", "亵渎"},
	{"xiee", "邪恶"},
	{"xiehe", "协和 谐和"},
	{"xiehui", "协会"},
	{"xiejue", "谢绝"},
	{"xieli", "协力"},
	{"xielou", "泄漏"},
	{"xielu", "邪路 泄露"},
	{"xiemi", "泄密"},
	{"xienian", "邪念"},
	{"xiepo", "胁迫"},
	{"xieqi", "邪气"},
	{"xieshang", "协商"},
	{"xiesheng", "写生"},
	{"xieshou", "携手"},
	{"xieshuo", "邪说"},
	{"xietong", "协同"},
	{"xiexi", "歇息"},
	{"xiexie", "谢谢"},
	{"xieyi", "协议"},
	{"xieyin", "谐音"},
	{"xieyue", "协约"},
	{"xiezai", "卸载"},
	{"xiezhao", "写照"},
	{"xiezhu", "协助"},
	{"xiezi", "鞋子"},
	{"xiezuo", "写作 协作"},
	{"xifang", "西方"},
	{"xifeng", "西风"},
	{"xifu", "西服 吸附 媳妇"},
	{"xiguan", "习惯"},
	{"xihan", "西汉 稀罕"},
	{"xihuan", "喜欢"},
	{"xiji", "袭击"},
	{"xijie", "细节 洗劫"},
	{"xiju", "喜剧 戏剧"},
	{"xijuan", "席卷"},
	{"xijun", "细菌"},
	{"xili", "犀利"},
	{"xilian", "洗练"},
	{"xilie", "系列"},
	{"xiluo", "奚落"},
	{"ximie", "熄灭"},
	{"xinai", "心爱"},
	{"xinan", "西南"},
	{"xinchun", "新春"},
	{"xindai", "信贷"},
	{"xinde", "心得"},
	{"xinfan", "心烦"},
	{"xinfu", "心服 信服"},
	{"xingan", "心甘"},
	{"xingban", "兴办"},
	{"xingbie", "性别 姓别"},
	{"xingchang", "刑场"},
	{"xingchen", "星辰"},
	{"xingcheng", "形成 行程"},
	{"xingdong", "行动"},
	{"xinger", "幸而"},
	{"xingfa", "刑法 刑罚"},
	{"xingfen", "兴奋"},
	{"xingfu", "幸福"},
	{"xingge", "性格"},
	{"xinghao", "幸好 型号"},
	{"xinghui", "行贿"},
	{"xinghuo", "星火"},
	{"xingji", "性急 形迹"},
	{"xingjian", "兴建"},
	{"xingjing", "行径"},
	{"xingjun", "行军"},
	{"xingkong", "星空"},
	{"xingkui", "幸亏"},
	{"xingli", "行李"},
	{"xinglv", "行旅"},
	{"xingmian", "幸免"},
	{"xingming", "性命 姓名"},
	{"xingmu", "醒目"},
	{"xingneng", "性能"},
	{"xingqi", "行期 兴起 星期"},
	{"xingqing", "性情"},
	{"xingqiu", "星球"},
	{"xingqu", "兴趣"},
	{"xingrong", "形容"},
	{"xingshang", "行商"},
	{"xingsheng", "兴盛"},
	{"xingshi", "行使 行事 行驶 形式 幸事 刑事 形势 姓氏"},
	{"xingshu", "行署"},
	{"xingshuai", "兴衰"},
	{"xingsong", "惺忪"},
	{"xingtai", "形态"},
	{"xingti", "形体"},
	{"xingwang", "兴亡 兴旺"},
	{"xingwei", "行为"},
	{"xingwen", "行文"},
	{"xingwu", "醒悟"},
	{"xingxiang", "形象"},
	{"xingxiao", "行销"},
	{"xingxing", "星星"},
	{"xingxiong", "行凶"},
	{"xingxiu", "兴修"},
	{"xingye", "行业 星夜"},
	{"xingyun", "幸运"},
	{"xingzheng", "行政"},
	{"xingzhi", "性质 兴致"},
	{"xingzhuang", "形状"},
	{"xingzou", "行走"},
	{"xinhao", "信号"},
	{"xinhen", "心狠"},
	{"xinhuang", "心慌"},
	{"xini", "细腻"},
	{"xining", "西宁"},
	{"xinji", "心急"},
	{"xinjian", "信件"},
	{"xinjiang", "新疆"},
	{"xinjin", "新近"},
	{"xinju", "新居"},
	{"xinkan", "心坎"},
	{"xinku", "辛苦"},
	{"xinlai", "信赖"},
	{"xinlao", "辛劳"},
	{"xinli", "心理 心里"},
	{"xinling", "心灵"},
	{"xinmu", "心目"},
	{"xinnian", "信念"},
	{"xinong", "戏弄"},
	{"xinqi", "新奇"},
	{"xinqin", "辛勤"},
	{"xinqing", "心情"},
	{"xinqu", "新区"},
	{"xinren", "新人 信任"},
	{"xinshang", "欣赏"},
	{"xinsheng", "新生 心声"},
	{"xinshi", "新事 新式"},
	{"xinshu", "新书"},
	{"xinshui", "薪水"},
	{"xinsuan", "心酸 辛酸"},
	{"xinteng", "心疼"},
	{"xintian", "心田"},
	{"xintiao", "心跳"},
	{"xintou", "心头"},
	{"xinwei", "欣慰"},
	{"xinwen", "新闻"},
	{"xinxi", "心细 信息 欣喜"},
	{"xinxian", "新鲜"},
	{"xinxiang", "心想 信箱 馨香"},
	{"xinxin", "信心"},
	{"xinxing", "新型 新星 新兴"},
	{"xinxu", "心虚"},
	{"xinxue", "心血"},
	{"xinyang", "信仰"},
	{"xinyi", "心意 新异"},
	{"xinying", "新颖"},
	{"xinyong", "信用"},
	{"xinyu", "新余 信誉"},
	{"xinyuan", "心愿"},
	{"xinzang", "心脏"},
	{"xinzhi", "新址"},
	{"xinzhong", "心中"},
	{"xiongbian", "雄辩"},
	{"xiongbing", "雄兵"},
	{"xiongcan", "凶残"},
	{"xiongdi", "兄弟"},
	{"xionge", "凶恶"},
	{"xiongguan", "雄关"},
	{"xionghen", "凶狠"},
	{"xionghou", "雄厚"},
	{"xionghuai", "胸怀"},
	{"xiongjian", "雄健"},
	{"xiongkou", "胸口"},
	{"xiongmao", "熊猫"},
	{"xiongmeng", "凶猛"},
	{"xiongnu", "匈奴"},
	{"xiongqi", "凶器"},
	{"xiongsha", "凶杀"},
	{"xiongshi", "雄师"},
	{"xiongshou", "凶手"},
	{"xiongtang", "胸膛"},
	{"xiongwei", "雄伟"},
	{"xiongxin", "雄心"},
	{"xiongyong", "汹涌"},
	{"xiongzhuang", "雄壮"},
	{"xiongzi", "雄姿"},
	{"xiou", "西欧"},
	{"xiqi", "稀奇 习气 喜气 吸气"},
	{"xiqing", "喜庆"},
	{"xiqu", "吸取 戏曲"},
	{"xiri", "昔日"},
	{"xirou", "息肉"},
	{"xisheng", "牺牲"},
	{"xishao", "稀少"},
	{"xishi", "西施 西式 喜事 稀释 稀世"},
	{"xishou", "吸收"},
	{"xishu", "系数"},
	{"xishua", "洗刷"},
	{"xishun", "吸吮"},
	{"xisu", "习俗"},
	{"xiti", "习题"},
	{"xitian", "西天"},
	{"xitong", "系统"},
	{"xiubu", "修补"},
	{"xiucai", "秀才"},
	{"xiuchi", "羞耻"},
	{"xiuci", "修辞"},
	{"xiuding", "修订"},
	{"xiufu", "修复"},
	{"xiugai", "修改"},
	{"xiujian", "修建 修剪"},
	{"xiujue", "嗅觉"},
	{"xiuke", "休克"},
	{"xiukui", "羞愧"},
	{"xiuli", "修理 秀丽"},
	{"xiuqi", "秀气"},
	{"xiuru", "羞辱"},
	{"xiuse", "羞涩"},
	{"xiushi", "修饰"},
	{"xiuxi", "休息"},
	{"xiuxiang", "休想"},
	{"xiuyang", "修养 休养"},
	{"xiuzao", "修造"},
	{"xiuzhang", "袖章"},
	{"xiuzhen", "袖珍"},
	{"xiuzheng", "修正"},
	{"xiuzhu", "修筑"},
	{"xiwang", "希望"},
	{"xiwei", "席位 细微"},
	{"xiwen", "西文 檄文"},
	{"xixi", "嘻嘻"},
	{"xixiao", "细小"},
	{"xixin", "细心 悉心"},
	{"xixun", "喜讯"},
	{"xiyan", "吸烟"},
	{"xiyang", "西洋"},
	{"xiyi", "西医"},
	{"xiyin", "吸引"},
	{"xiyou", "稀有"},
	{"xiyuan", "戏院"},
	{"xiyue", "喜悦"},
	{"xizang", "西藏"},
	{"xizao", "洗澡"},
	{"xize", "细则"},
	{"xizhi", "细致"},
	{"xizuo", "习作"},
	{"xjd", "现阶段"},
	{"xjs", "新技术"},
	{"xjxc", "献计献策"},
	{"xjzm", "先见之明"},
	{"xkkh", "信口开河"},
	{"xlcb", "兴利除弊"},
	{"xlh", "系列化"},
	{"xlht", "稀里糊涂"},
	{"xlxf", "狭路相逢"},
	{"xmy", "畜牧业"},
	{"xmyz", "心满意足"},
	{"xns", "西宁市"},
	{"xpy", "小朋友"},
	{"xqk", "向前看"},
	{"xqyy", "喜气洋洋"},
	{"xrhj", "先人后己"},
	{"xsdz", "兴师动众"},
	{"xse", "销售额"},
	{"xsfz", "刑事犯罪"},
	{"xsh", "小时候"},
	{"xsq", "新时期"},
	{"xssw", "新生事物"},
	{"xszy", "形式主义"},
	{"xtbl", "相提并论"},
	{"xtdz", "小题大做"},
	{"xuanan", "悬案"},
	{"xuanang", "轩昂"},
	{"xuanba", "选拔"},
	{"xuanbu", "宣布"},
	{"xuancai", "选材"},
	{"xuanchang", "选场"},
	{"xuancheng", "宣称"},
	{"xuanchuan", "宣传"},
	{"xuanding", "选定"},
	{"xuandu", "宣读"},
	{"xuangao", "宣告"},
	{"xuangou", "选购"},
	{"xuangua", "悬挂"},
	{"xuanhu", "玄乎"},
	{"xuanhua", "喧哗"},
	{"xuanji", "选集"},
	{"xuanjiang", "宣讲"},
	{"xuanju", "选举"},
	{"xuanlan", "绚烂"},
	{"xuanli", "绚丽"},
	{"xuanlu", "选录"},
	{"xuanlv", "旋律"},
	{"xuanmin", "选民"},
	{"xuannao", "喧闹"},
	{"xuannian", "悬念"},
	{"xuanpai", "选派"},
	{"xuanpan", "宣判"},
	{"xuanpei", "选配"},
	{"xuanpiao", "选票"},
	{"xuanqu", "选区 选取"},
	{"xuanrang", "喧嚷"},
	{"xuanshi", "宣誓"},
	{"xuanshou", "选手"},
	{"xuanshu", "悬殊"},
	{"xuanwo", "旋涡"},
	{"xuanxu", "玄虚"},
	{"xuanya", "悬崖"},
	{"xuanyan", "宣言"},
	{"xuanyang", "宣扬"},
	{"xuanyao", "炫耀"},
	{"xuanyong", "选用"},
	{"xuanze", "选择"},
	{"xuanzhan", "宣战"},
	{"xuanzhong", "选种"},
	{"xuanzhuan", "旋转"},
	{"xuduo", "许多"},
	{"xuebao", "学报"},
	{"xuebu", "学部"},
	{"xuechao", "学潮"},
	{"xuefei", "学费"},
	{"xuefeng", "学风"},
	{"xuefu", "学府"},
	{"xuehan", "血汗"},
	{"xuehao", "学好"},
	{"xuehui", "学会"},
	{"xueji", "学籍 血迹"},
	{"xueke", "学科"},
	{"xuelei", "血泪"},
	{"xueli", "学历"},
	{"xueling", "学龄"},
	{"xuenian", "学年"},
	{"xuepai", "学派"},
	{"xueqi", "学期"},
	{"xuerou", "血肉"},
	{"xuesheng", "学生"},
	{"xueshi", "学时 学识 学士"},
	{"xueshu", "学术 血书"},
	{"xueshuo", "学说"},
	{"xuetong", "血统"},
	{"xuetu", "学徒"},
	{"xuewei", "学位"},
	{"xuewen", "学问"},
	{"xuexi", "学习 血洗"},
	{"xuexiao", "学校"},
	{"xueya", "血压"},
	{"xueye", "学业 血液"},
	{"xueyou", "学友"},
	{"xueyuan", "学员 学院"},
	{"xueyun", "血晕"},
	{"xuezhan", "血战"},
	{"xuezhe", "学者"},
	{"xuezhi", "学制"},
	{"xugou", "虚构"},
	{"xuhao", "序号"},
	{"xuji", "蓄积"},
	{"xujia", "虚假"},
	{"xujiu", "叙旧"},
	{"xuke", "许可"},
	{"xulie", "序列"},
	{"xulun", "绪论"},
	{"xuming", "虚名"},
	{"xumu", "序幕 畜牧"},
	{"xunbu", "巡捕"},
	{"xuncha", "巡查"},
	{"xunchang", "寻常"},
	{"xunfu", "驯服"},
	{"xunguo", "殉国"},
	{"xunhang", "巡航"},
	{"xunhuan", "循环"},
	{"xunhui", "巡回"},
	{"xuni", "虚拟"},
	{"xunji", "寻机"},
	{"xunjie", "迅捷 训诫"},
	{"xunjing", "巡警"},
	{"xunjue", "勋爵"},
	{"xunlian", "训练"},
	{"xunluo", "巡逻"},
	{"xunmei", "洵妹"},
	{"xunmeng", "迅猛"},
	{"xunqiu", "寻求"},
	{"xunse", "逊色"},
	{"xunshi", "巡视"},
	{"xunsi", "徇私"},
	{"xunsu", "迅速"},
	{"xuntao", "熏陶"},
	{"xunuo", "许诺"},
	{"xunwen", "讯问 询问"},
	{"xunxin", "寻衅"},
	{"xunxu", "循序"},
	{"xunzhang", "勋章"},
	{"xunzhao", "寻找"},
	{"xunzhi", "殉职 寻址"},
	{"xuqiu", "需求"},
	{"xuqu", "序曲"},
	{"xurong", "虚荣"},
	{"xuruo", "虚弱"},
	{"xushe", "虚设"},
	{"xushi", "叙事 虚实"},
	{"xushu", "序数 虚数 叙述"},
	{"xushuo", "叙说"},
	{"xuwei", "虚伪"},
	{"xuwen", "序文"},
	{"xuxin", "虚心"},
	{"xuyan", "序言"},
	{"xuyao", "需要"},
	{"xuyu", "须臾"},
	{"xuyuan", "许愿"},
	{"xuzhi", "须知"},
	{"xwhz", "秀外慧中"},
	{"xwq", "宣武区"},
	{"xxcl", "信息处理"},
	{"xxjj", "循序见进"},
	{"xxkk", "辛辛苦苦"},
	{"xxl", "信息量"},
	{"xxrr", "熙熙攘攘"},
	{"xxs", "小学生"},
	{"xxxr", "欣欣向荣"},
	{"xxyy", "小心翼翼"},
	{"xyb", "下一步"},
	{"xycz", "胸有成竹"},
	{"xyj", "洗衣机"},
	{"xys", "小意思"},
	{"xywc", "习以为常"},
	{"xyx", "新颖性"},
	{"xzbb", "兴致勃勃"},
	{"xzg", "新中国"},
	{"xzqy", "行政区域"},
	{"xzst", "雪中送炭"},
	{"xzws", "心中无数"},
	{"xzx", "选择性"},
	{"xzys", "心中有数"},
	{"xzyx", "行之有效"},
	{"yaba", "哑巴"},
	{"yachi", "牙齿"},
	{"yadao", "压倒"},
	{"yafu", "压服"},
	{"yaguan", "牙关 雅观"},
	{"yajia", "压价"},
	{"yajin", "押金"},
	{"yajun", "亚军"},
	{"yali", "压力"},
	{"yanan", "沿岸 延安"},
	{"yanban", "严办"},
	{"yanbi", "掩蔽"},
	{"yanbian", "演变"},
	{"yancao", "烟草"},
	{"yanchang", "延长 演唱"},
	{"yancheng", "严惩"},
	{"yanchi", "延迟"},
	{"yanchu", "演出"},
	{"yandian", "唁电"},
	{"yandong", "严冬"},
	{"yane", "厌恶"},
	{"yanfan", "厌烦"},
	{"yangai", "掩盖"},
	{"yangban", "样板"},
	{"yangben", "样本"},
	{"yangcai", "洋财"},
	{"yangcheng", "养成"},
	{"yange", "沿革 严格"},
	{"yangguang", "阳光"},
	{"yanghang", "洋行"},
	{"yanghu", "养护"},
	{"yanghua", "氧化"},
	{"yangliao", "养料"},
	{"yangliu", "杨柳"},
	{"yangmian", "仰面"},
	{"yangmin", "殃民"},
	{"yangmu", "仰慕"},
	{"yangpin", "样品"},
	{"yangqi", "洋气 扬弃"},
	{"yangqin", "扬琴"},
	{"yangqiu", "央求"},
	{"yangshang", "养伤"},
	{"yangshi", "样式"},
	{"yangtai", "阳台"},
	{"yanguang", "眼光"},
	{"yangwang", "仰望"},
	{"yangwu", "洋务"},
	{"yangxiang", "洋相"},
	{"yangyan", "扬言"},
	{"yangyang", "样样"},
	{"yangyi", "洋溢"},
	{"yangyu", "养育"},
	{"yangzhi", "养殖"},
	{"yangzi", "样子"},
	{"yanhai", "沿海"},
	{"yanhan", "严寒"},
	{"yanhong", "眼红"},
	{"yanhou", "咽喉"},
	{"yanhu", "掩护"},
	{"yanhua", "眼花"},
	{"yanhuan", "延缓"},
	{"yanhui", "宴会"},
	{"yanhuo", "焰火"},
	{"yanjiang", "演讲"},
	{"yanjie", "眼界"},
	{"yanjin", "严禁 严谨"},
	{"yanjing", "眼镜 眼睛"},
	{"yanjiu", "研究"},
	{"yanjun", "严峻"},
	{"yankan", "眼看"},
	{"yanku", "严酷"},
	{"yankuang", "眼眶"},
	{"yanlei", "眼泪"},
	{"yanli", "眼力 严厉 艳丽"},
	{"yanlian", "眼帘"},
	{"yanliang", "眼亮"},
	{"yanlu", "言路 沿路"},
	{"yanlun", "言论"},
	{"yanmai", "掩埋"},
	{"yanmi", "严密"},
	{"yanming", "严明"},
	{"yanmu", "烟幕"},
	{"yannian", "延年"},
	{"yanqi", "延期"},
	{"yanqian", "眼前"},
	{"yanqing", "宴请"},
	{"yanran", "俨然"},
	{"yanre", "炎热"},
	{"yanse", "眼色 颜色"},
	{"yanshen", "延伸"},
	{"yanshi", "岩石 演示 掩饰"},
	{"yanshou", "验收 严守 延寿"},
	{"yanshuo", "演说"},
	{"yansu", "严肃"},
	{"yansuan", "演算"},
	{"yantan", "言谈"},
	{"yantao", "研讨"},
	{"yantu", "沿途"},
	{"yanwang", "阎王"},
	{"yanwu", "延误 烟雾"},
	{"yanxi", "宴席 筵席 演习 沿袭"},
	{"yanxia", "眼下"},
	{"yanxian", "沿线"},
	{"yanxing", "言行 严刑"},
	{"yanxu", "延续"},
	{"yanyang", "艳阳"},
	{"yanyi", "演义 演绎"},
	{"yanying", "掩映"},
	{"yanyong", "沿用"},
	{"yanyu", "言语"},
	{"yanyuan", "演员"},
	{"yanzhan", "厌战"},
	{"yanzhe", "沿着"},
	{"yanzheng", "验证"},
	{"yanzhi", "研制"},
	{"yanzhong", "严重"},
	{"yanzou", "演奏"},
	{"yaobai", "摇摆"},
	{"yaobao", "腰包"},
	{"yaobu", "要不"},
	{"yaochuan", "谣传"},
	{"yaode", "要得"},
	{"yaodian", "要点"},
	{"yaodong", "摇动 窑洞"},
	{"yaogan", "遥感"},
	{"yaoguai", "妖怪"},
	{"yaohai", "要害"},
	{"yaohan", "摇撼"},
	{"yaohuang", "摇晃"},
	{"yaojian", "要件"},
	{"yaojin", "要紧"},
	{"yaokong", "摇控 遥控"},
	{"yaolan", "摇篮"},
	{"yaoling", "要领"},
	{"yaome", "要么"},
	{"yaomo", "妖魔"},
	{"yaomu", "要目"},
	{"yaoqing", "邀请"},
	{"yaoqiu", "要求"},
	{"yaosai", "要塞"},
	{"yaoshi", "要是 钥匙"},
	{"yaosu", "要素"},
	{"yaotiao", "窈窕"},
	{"yaotou", "摇头"},
	{"yaowen", "要闻"},
	{"yaowu", "药物"},
	{"yaoxie", "要挟"},
	{"yaoyan", "耀眼 谣言 妖艳"},
	{"yaozhe", "夭折"},
	{"yaozhi", "要职"},
	{"yapian", "鸦片"},
	{"yapo", "压迫"},
	{"yaqiang", "压强"},
	{"yasuo", "压缩"},
	{"yaxing", "雅兴"},
	{"yayang", "压仰"},
	{"yayi", "压抑"},
	{"yayun", "押韵"},
	{"yazha", "压榨"},
	{"yazhi", "压制 雅致"},
	{"yazhou", "亚洲"},
	{"yazi", "鸭子"},
	{"yazuo", "雅座"},
	{"ybd", "要不得"},
	{"ybf", "一部分"},
	{"ybr", "要不然"},
	{"ybs", "要不是"},
	{"ybsl", "一般说来"},
	{"yby", "要不要"},
	{"ybz", "一辈子 一把抓 用不着"},
	{"ycbd", "扬长避短"},
	{"ycdy", "一锤定音"},
	{"yckj", "由此可见"},
	{"ycs", "银川市"},
	{"ycts", "与此同时"},
	{"yczr", "有偿转让"},
	{"ydb", "邮电部"},
	{"ydd", "有道德"},
	{"ydj", "邮电局"},
	{"ydq", "一刀切"},
	{"ydy", "运动员 印度洋"},
	{"ydzy", "因地制宜"},
	{"yecan", "野餐"},
	{"yecha", "夜叉"},
	{"yehuo", "野火"},
	{"yeji", "业绩"},
	{"yejian", "夜间"},
	{"yejin", "冶金"},
	{"yeli", "夜里"},
	{"yelian", "冶练"},
	{"yeman", "野蛮"},
	{"yemu", "夜幕"},
	{"yese", "夜色"},
	{"yeshi", "也是 夜市"},
	{"yeshou", "野兽"},
	{"yeti", "液体"},
	{"yewai", "野外"},
	{"yewan", "夜晚"},
	{"yewu", "业务"},
	{"yexiao", "夜校 夜宵"},
	{"yexin", "野心"},
	{"yexing", "野性"},
	{"yexu", "也许"},
	{"yey", "幼儿园"},
	{"yeye", "爷爷"},
	{"yeying", "野营"},
	{"yeyu", "业余"},
	{"yezhan", "野战"},
	{"yezi", "叶子"},
	{"yfm", "一方面"},
	{"yfwe", "一分为二"},
	{"yfyw", "阳奉阴违"},
	{"ygel", "一概而论"},
	{"yglz", "一国两制"},
	{"ygnr", "一股脑儿"},
	{"ygyj", "有根有据"},
	{"yhll", "眼花缭乱"},
	{"yhtc", "有何特长"},
	{"yhzh", "银行帐号"},
	{"yhzs", "炎黄子孙"},
	{"yian", "议案 疑案"},
	{"yiban", "一半 一般 一斑"},
	{"yibian", "一边 以便"},
	{"yibiao", "仪表"},
	{"yibing", "一并"},
	{"yibu", "异步"},
	{"yichan", "遗产"},
	{"yichang", "异常"},
	{"yicheng", "议程"},
	{"yichu", "益处"},
	{"yichuan", "遗传"},
	{"yici", "一次 依次"},
	{"yicong", "依从"},
	{"yidai", "一代 一带"},
	{"yidan", "一旦"},
	{"yidian", "一点"},
	{"yiding", "一定"},
	{"yidong", "移动"},
	{"yidu", "一度 遗毒"},
	{"yiduan", "一端 臆断"},
	{"yifa", "一发 依法"},
	{"yifen", "义愤"},
	{"yifu", "衣服 依附"},
	{"yigai", "一概"},
	{"yige", "一个"},
	{"yigong", "一共"},
	{"yigu", "已故"},
	{"yiguan", "一贯"},
	{"yihan", "遗憾"},
	{"yihen", "遗恨"},
	{"yihou", "以后"},
	{"yihui", "一会 议会"},
	{"yihuo", "疑惑"},
	{"yiji", "以及 异己 遗迹"},
	{"yijia", "议价"},
	{"yijian", "意见"},
	{"yijiao", "移交"},
	{"yijie", "一届"},
	{"yijin", "衣襟"},
	{"yijing", "已经 意境 一经"},
	{"yijiu", "依旧"},
	{"yiju", "一举 依据 移居"},
	{"yijue", "议决"},
	{"yikao", "依靠 倚靠"},
	{"yike", "一刻 医科"},
	{"yikuai", "一块"},
	{"yilai", "以来 依赖"},
	{"yilan", "一览"},
	{"yili", "一例 毅力 屹立"},
	{"yilian", "一连"},
	{"yiliao", "意料 医疗"},
	{"yiliu", "遗留"},
	{"yilou", "遗漏"},
	{"yilun", "议论"},
	{"yilv", "一律 疑虑"},
	{"yimian", "一面 以免"},
	{"yimiao", "疫苗"},
	{"yimin", "移民"},
	{"yinan", "疑难 阴暗"},
	{"yinbi", "隐蔽"},
	{"yinbiao", "音标"},
	{"yincang", "隐藏"},
	{"yinchen", "阴沉"},
	{"yinchuan", "银川"},
	{"yinci", "因此"},
	{"yindao", "引导"},
	{"yindiao", "音调"},
	{"yindu", "印度 引渡"},
	{"yinei", "以内"},
	{"yiner", "因而"},
	{"yinfa", "印发"},
	{"yinfu", "音符"},
	{"yingbang", "英镑"},
	{"yingbi", "硬币"},
	{"yingbian", "应变"},
	{"yingchen", "映衬"},
	{"yingchou", "应酬"},
	{"yingchun", "迎春"},
	{"yingdang", "应当"},
	{"yingde", "赢得"},
	{"yinger", "婴儿"},
	{"yingfang", "营房"},
	{"yingfeng", "迎风"},
	{"yingfu", "应付"},
	{"yinggai", "应该"},
	{"yingguo", "英国"},
	{"yinghua", "樱花"},
	{"yinghun", "英魂"},
	{"yingji", "应急"},
	{"yingjian", "硬件"},
	{"yingjie", "迎接 应届 英杰"},
	{"yingjiu", "营救"},
	{"yingjun", "英俊"},
	{"yingkui", "盈亏"},
	{"yingli", "赢利 盈利"},
	{"yinglie", "英烈"},
	{"yingmian", "迎面"},
	{"yingming", "英明"},
	{"yingpan", "硬盘"},
	{"yingpian", "影片"},
	{"yingpin", "硬拼"},
	{"yingshe", "影射 映射"},
	{"yingtao", "樱桃"},
	{"yingtou", "迎头"},
	{"yinguo", "因果"},
	{"yingwen", "英文"},
	{"yingxiang", "影响 影像"},
	{"yingxing", "硬性"},
	{"yingxiong", "英雄"},
	{"yingyang", "营养"},
	{"yingyao", "应邀"},
	{"yingye", "营业"},
	{"yingyong", "应用 英勇"},
	{"yingyou", "应有"},
	{"yingyu", "英语 盈余"},
	{"yingzao", "营造"},
	{"yingzhan", "应战 迎战"},
	{"yingzhao", "映照"},
	{"yingzheng", "应征"},
	{"yingzi", "影子 英姿"},
	{"yinhang", "银行"},
	{"yinhao", "引号"},
	{"yinhong", "殷红"},
	{"yinhuan", "隐患"},
	{"yinhui", "淫秽"},
	{"yinhun", "阴魂"},
	{"yinian", "意念"},
	{"yiniang", "姨娘"},
	{"yinji", "阴极"},
	{"yinjian", "印鉴"},
	{"yinjin", "引进"},
	{"yinli", "引力 阴历"},
	{"yinliang", "阴凉"},
	{"yinlu", "引路"},
	{"yinman", "隐瞒"},
	{"yinmou", "阴谋"},
	{"yinmu", "银幕"},
	{"yinni", "隐慝"},
	{"yinpai", "银牌"},
	{"yinqi", "引起"},
	{"yinqie", "殷切"},
	{"yinqin", "殷勤"},
	{"yinqing", "引擎"},
	{"yinren", "引人"},
	{"yinshi", "饮食"},
	{"yinshua", "印刷"},
	{"yinshui", "饮水"},
	{"yinsu", "因素"},
	{"yintian", "阴天"},
	{"yintui", "引退"},
	{"yinwei", "因为 淫威"},
	{"yinxian", "阴险"},
	{"yinxiang", "印象 音响"},
	{"yinxin", "音信"},
	{"yinxun", "因循"},
	{"yinyan", "引言"},
	{"yinying", "阴影"},
	{"yinyong", "引用"},
	{"yinyou", "引诱"},
	{"yinyu", "阴雨 阴郁 隐语 隐喻 引语 音域 淫雨"},
	{"yinyuan", "姻缘"},
	{"yinyue", "音乐 隐约"},
	{"yinzheng", "引证 印证"},
	{"yipian", "一片"},
	{"yipie", "一瞥"},
	{"yiqi", "一起 一齐 义气 意气 仪器 遗弃"},
	{"yiqian", "以前"},
	{"yiqie", "一切"},
	{"yiran", "依然 亦然 毅然"},
	{"yiren", "艺人 宜人"},
	{"yirong", "遗容"},
	{"yishang", "以上"},
	{"yisheng", "一生 医生"},
	{"yishi", "一时 一事 意识 议事 逸事 仪式 医师 医士 遗失"},
	{"yishou", "一手"},
	{"yishu", "遗书 艺术"},
	{"yisi", "意思"},
	{"yiti", "一体 议题 遗体"},
	{"yitian", "一天"},
	{"yitong", "一同 异同"},
	{"yitou", "一头"},
	{"yitu", "意图"},
	{"yituan", "疑团"},
	{"yiwai", "以外 意外"},
	{"yiwan", "亿万"},
	{"yiwang", "以往 遗忘"},
	{"yiwei", "以为 意味"},
	{"yiwen", "意文 疑问 译文"},
	{"yiwu", "一无 义务 遗物 医务 贻误"},
	{"yixia", "以下 一下"},
	{"yixian", "一线"},
	{"yixiang", "一向 一项 意向 遗像"},
	{"yixie", "一些"},
	{"yixin", "一心 疑心"},
	{"yixing", "异性"},
	{"yixue", "医学"},
	{"yiyan", "一言 义演 遗言"},
	{"yiyang", "一样"},
	{"yiyao", "医药"},
	{"yiyi", "意义 异议"},
	{"yiyong", "义勇"},
	{"yiyu", "易于"},
	{"yiyuan", "议员 意愿 医院 遗愿"},
	{"yiyun", "疑云"},
	{"yizai", "一再"},
	{"yizao", "一早 臆造"},
	{"yizhang", "依仗 仪仗"},
	{"yizhao", "一朝 衣着 依照"},
	{"yizhen", "一阵"},
	{"yizhong", "一种"},
	{"yizhu", "遗嘱"},
	{"yizhuo", "衣着"},
	{"yjh", "研究会"},
	{"yjl", "有纪律"},
	{"yjs", "研究生 研究所 研究室"},
	{"yjxr", "养精蓄锐"},
	{"yjy", "研究员"},
	{"yjys", "拥军优属"},
	{"yjzc", "一技之长"},
	{"ykq", "一口气"},
	{"ylb", "一览表"},
	{"ylfr", "以理服人"},
	{"yls", "阅览室"},
	{"ylx", "有理想"},
	{"yly", "有利于 越来越"},
	{"ymgd", "有目共睹"},
	{"ymlr", "一目了然"},
	{"ymy", "有没有"},
	{"yns", "云南省"},
	{"yongbao", "拥抱"},
	{"yongbie", "永别"},
	{"yongbu", "永不"},
	{"yongchu", "用处"},
	{"yongdu", "用度"},
	{"yongfa", "用法"},
	{"yongfei", "用费"},
	{"yonggan", "勇敢"},
	{"yonggong", "用功"},
	{"yongheng", "永恒"},
	{"yonghu", "用户 拥护"},
	{"yongji", "拥挤"},
	{"yongjiu", "永久"},
	{"yongju", "用具"},
	{"yongjue", "永诀"},
	{"yongli", "用力"},
	{"yonglu", "庸碌"},
	{"yongmeng", "勇猛"},
	{"yongpin", "用品"},
	{"yongqi", "勇气"},
	{"yongshi", "勇士"},
	{"yongsu", "庸俗"},
	{"yongtan", "咏叹"},
	{"yongtu", "用途"},
	{"yongxian", "涌现"},
	{"yongxin", "用心"},
	{"yongyi", "用意"},
	{"yongyou", "拥有"},
	{"yongyu", "用于 勇于"},
	{"yongyuan", "永远"},
	{"yongyue", "踊跃"},
	{"youai", "有碍 友爱"},
	{"youan", "幽暗"},
	{"youbang", "友邦"},
	{"youbian", "右边"},
	{"youchou", "忧愁"},
	{"youci", "由此"},
	{"youcuo", "有错"},
	{"youdai", "有待 优待"},
	{"youdao", "诱导"},
	{"youde", "有的"},
	{"youdeng", "优等"},
	{"youdian", "有点 邮电 优点"},
	{"youfa", "诱发"},
	{"yougong", "有功"},
	{"youguan", "有关"},
	{"youhai", "有害"},
	{"youhao", "友好"},
	{"youhua", "优化 油画"},
	{"youhui", "幽会 优惠"},
	{"youhuo", "诱惑"},
	{"youji", "有机 游击"},
	{"youjin", "有劲"},
	{"youjing", "幽静"},
	{"youjiu", "悠久"},
	{"youju", "邮局"},
	{"youlai", "由来"},
	{"youlan", "游览"},
	{"youlao", "有劳"},
	{"youli", "有利 有力 游离"},
	{"youliang", "优良"},
	{"youlie", "优劣"},
	{"youling", "幽灵"},
	{"youlv", "忧虑"},
	{"youmei", "优美"},
	{"youmiao", "幼苗"},
	{"youming", "有名"},
	{"youmo", "幽默"},
	{"youpai", "右派"},
	{"youpian", "诱骗"},
	{"youpiao", "邮票"},
	{"youqi", "尤其 油漆"},
	{"youqing", "友情 右倾"},
	{"youqu", "有趣"},
	{"youran", "油然"},
	{"youru", "犹如"},
	{"youse", "有色"},
	{"yousheng", "优胜"},
	{"youshi", "有时 有事 有失 优势"},
	{"youshu", "有数"},
	{"youshui", "油水"},
	{"yousuo", "有所"},
	{"youwang", "有望"},
	{"youwei", "有为"},
	{"youxi", "游戏"},
	{"youxian", "有限 优先 悠闲"},
	{"youxiao", "有效 幼小"},
	{"youxie", "有些"},
	{"youxin", "有心"},
	{"youxing", "游行"},
	{"youxiu", "优秀"},
	{"youya", "幽雅"},
	{"youyang", "悠扬"},
	{"youyao", "又要"},
	{"youyi", "有益 优异 友谊"},
	{"youyong", "有用 游泳"},
	{"youyu", "由于 犹豫 忧郁"},
	{"youyuan", "悠远"},
	{"youyue", "优越"},
	{"youzheng", "邮政"},
	{"youzhi", "优质 幼稚"},
	{"youzhong", "由衷"},
	{"youzi", "邮资"},
	{"yqby", "有求必应"},
	{"yqwl", "有气无力"},
	{"yrej", "迎刃而解"},
	{"yrey", "因人而异"},
	{"yrzm", "引人注目"},
	{"ysj", "艺术家"},
	{"yst", "印刷体"},
	{"ysxt", "意识形态"},
	{"yszx", "衣食住行"},
	{"yszz", "以身作则"},
	{"ytyl", "有条有理"},
	{"yuanben", "原本"},
	{"yuanbo", "渊博"},
	{"yuanchou", "冤仇"},
	{"yuanda", "远大"},
	{"yuandan", "元旦"},
	{"yuandi", "园地"},
	{"yuanding", "园丁"},
	{"yuandong", "远东"},
	{"yuanfang", "远方"},
	{"yuanfen", "缘分"},
	{"yuangao", "原告"},
	{"yuangu", "缘故"},
	{"yuanhua", "圆滑"},
	{"yuanji", "原籍"},
	{"yuanjia", "冤家"},
	{"yuanjian", "元件 远见"},
	{"yuanjin", "远近"},
	{"yuanjing", "远景"},
	{"yuanjiu", "援救"},
	{"yuanlai", "原来"},
	{"yuanli", "原理"},
	{"yuanliang", "原谅"},
	{"yuanliao", "原料"},
	{"yuanlv", "远虑"},
	{"yuanman", "圆满"},
	{"yuanmei", "原煤"},
	{"yuanmou", "远谋"},
	{"yuanqi", "远期"},
	{"yuanqu", "冤屈"},
	{"yuanquan", "源泉"},
	{"yuanshi", "原始 远视"},
	{"yuanshou", "元首"},
	{"yuanshuai", "元帅"},
	{"yuansu", "元素"},
	{"yuanwai", "援外"},
	{"yuanwang", "愿望 冤枉"},
	{"yuanxian", "原先"},
	{"yuanxiao", "远销 元宵 院校"},
	{"yuanxing", "原形"},
	{"yuanyan", "怨言"},
	{"yuanye", "原野"},
	{"yuanyi", "愿意 园艺"},
	{"yuanyin", "原因 援引"},
	{"yuanyou", "原有 原油 缘由 远游"},
	{"yuanyuan", "远远 渊源"},
	{"yuanyue", "元月"},
	{"yuanze", "原则"},
	{"yuanzhang", "院长"},
	{"yuanzheng", "远征"},
	{"yuanzhu", "援助"},
	{"yuanzi", "原子 院子"},
	{"yubao", "预报"},
	{"yubei", "预备"},
	{"yuben", "愚笨"},
	{"yubu", "余步"},
	{"yuce", "预测"},
	{"yuchun", "愚蠢"},
	{"yudao", "遇到"},
	{"yuding", "预定 预订"},
	{"yudu", "余毒"},
	{"yuebao", "月报"},
	{"yuechu", "月初"},
	{"yuedi", "月底"},
	{"yueding", "约定"},
	{"yuedu", "月度 阅读"},
	{"yuedui", "乐队"},
	{"yuefa", "约法"},
	{"yuefen", "月份"},
	{"yuefu", "岳父"},
	{"yueguang", "月光"},
	{"yuegui", "越轨"},
	{"yuehui", "约会"},
	{"yuejie", "越界"},
	{"yuejin", "跃进"},
	{"yuejing", "越境"},
	{"yuelaiyue", "越来越"},
	{"yuelan", "阅览"},
	{"yueli", "阅历"},
	{"yueliang", "月亮"},
	{"yuemo", "月末 约莫"},
	{"yuemu", "岳母"},
	{"yuenan", "越南"},
	{"yuepu", "乐谱"},
	{"yueqi", "乐器"},
	{"yueqiu", "月球"},
	{"yuequ", "乐曲"},
	{"yuese", "月色"},
	{"yueshi", "越是 月食"},
	{"yueshu", "约束"},
	{"yuetai", "月台"},
	{"yuetuan", "乐团"},
	{"yueya", "月牙"},
	{"yueyou", "约有"},
	{"yuezhang", "乐章"},
	{"yufang", "预防"},
	{"yufeng", "预风"},
	{"yufu", "预付"},
	{"yugan", "预感"},
	{"yugao", "预告"},
	{"yugou", "预购"},
	{"yuhai", "遇害"},
	{"yuhang", "宇航"},
	{"yuhui", "与会 迂回 语汇 余晖"},
	{"yuji", "雨季 预计"},
	{"yujian", "遇见 预见"},
	{"yuju", "语句 豫剧 渔具 雨具"},
	{"yukuai", "愉快"},
	{"yule", "娱乐"},
	{"yulei", "鱼雷"},
	{"yuliao", "预料"},
	{"yulu", "雨露"},
	{"yulun", "舆论"},
	{"yumei", "愚昧"},
	{"yumiao", "育苗"},
	{"yumou", "预谋"},
	{"yunan", "遇难"},
	{"yuncai", "云彩"},
	{"yuncang", "蕴藏"},
	{"yunchen", "匀称"},
	{"yundong", "运动"},
	{"yundou", "熨斗 芸豆"},
	{"yunhai", "云海"},
	{"yunhe", "运河"},
	{"yunluo", "陨落"},
	{"yunlv", "韵律"},
	{"yunnan", "云南"},
	{"yunnian", "酝酿"},
	{"yunnuo", "允诺"},
	{"yunong", "愚弄"},
	{"yunqi", "运气"},
	{"yunshu", "运输"},
	{"yunsuan", "运算"},
	{"yunti", "云梯"},
	{"yunwang", "运往"},
	{"yunwei", "韵味"},
	{"yunwu", "云雾"},
	{"yunxia", "云霞"},
	{"yunxing", "运行"},
	{"yunxu", "允许"},
	{"yunyong", "运用"},
	{"yunyu", "孕育"},
	{"yunzai", "运载"},
	{"yunzhuan", "运转"},
	{"yuqi", "与其 语气 预期"},
	{"yushen", "预审"},
	{"yushi", "于是 预示"},
	{"yushou", "预售 驭手"},
	{"yushui", "雨水"},
	{"yusuan", "预算"},
	{"yuwang", "欲望 渔网"},
	{"yuwen", "语文 与闻"},
	{"yuxi", "预习"},
	{"yuxian", "预先 遇险"},
	{"yuxiang", "预想"},
	{"yuyan", "语言 预言 寓言 预演"},
	{"yuyi", "予以"},
	{"yuyu", "寓于"},
	{"yuyue", "愉悦"},
	{"yuzhao", "预兆"},
	{"yuzhi", "预支"},
	{"yuzhou", "宇宙"},
	{"ywfg", "义无反顾"},
	{"ywh", "有文化"},
	{"ywlx", "业务联系"},
	{"ywz", "意味着"},
	{"yxgs", "有限公司"},
	{"yxl", "一系列"},
	{"yxq", "有效期"},
	{"yxy", "医学院"},
	{"yxyy", "一心一意"},
	{"yybb", "原原本本"},
	{"yyc", "游泳池"},
	{"yye", "营业额"},
	{"yyjr", "夜以继日"},
	{"yykx", "应用科学"},
	{"yyt", "一言堂"},
	{"yywj", "引以为戒"},
	{"yyx", "优越性"},
	{"yyy", "营业员"},
	{"yyyy", "隐隐约约"},
	{"yyzr", "运用自如"},
	{"yzam", "拥政爱民"},
	{"yzn", "原子能"},
	{"yzs", "已知数"},
	{"yzy", "有助于"},
	{"yzyl", "言之有理"},
	{"zaiban", "再版"},
	{"zaibu", "再不"},
	{"zaichang", "在场"},
	{"zaidu", "再度"},
	{"zaige", "宰割"},
	{"zaihai", "灾害"},
	{"zaihao", "再好"},
	{"zaihu", "在乎"},
	{"zaihuang", "灾荒"},
	{"zaihui", "再会"},
	{"zaihuo", "灾祸"},
	{"zaijian", "再见"},
	{"zaili", "在理"},
	{"zaimin", "灾民"},
	{"zainan", "灾难"},
	{"zaipei", "栽培"},
	{"zaiqi", "再起"},
	{"zaiqing", "灾情"},
	{"zaiqu", "灾区"},
	{"zaisan", "再三"},
	{"zaishi", "在世"},
	{"zaishuo", "再说"},
	{"zaiti", "载体"},
	{"zaixia", "在下"},
	{"zaixian", "再现"},
	{"zaixiang", "宰相"},
	{"zaiyi", "在意"},
	{"zaiyu", "在于"},
	{"zaizao", "再造"},
	{"zaize", "再则"},
	{"zaizhi", "在职 再植"},
	{"zaji", "杂技"},
	{"zaliang", "杂粮"},
	{"zaluan", "杂乱"},
	{"zancheng", "赞成"},
	{"zanding", "暂定"},
	{"zange", "赞歌"},
	{"zangkuan", "赃款"},
	{"zangsong", "葬送"},
	{"zangwu", "赃物"},
	{"zangzu", "藏族"},
	{"zanian", "杂念"},
	{"zanmei", "赞美"},
	{"zanmen", "咱们"},
	{"zanqie", "暂且"},
	{"zanque", "暂缺"},
	{"zanshang", "赞赏"},
	{"zanshi", "暂时"},
	{"zansong", "赞颂"},
	{"zantan", "赞叹"},
	{"zanting", "暂停"},
	{"zantong", "赞同"},
	{"zanxing", "暂行"},
	{"zanyang", "赞扬"},
	{"zanyong", "暂用"},
	{"zanzhu", "赞助"},
	{"zaocan", "早餐"},
	{"zaochen", "早晨"},
	{"zaocheng", "造成"},
	{"zaochuan", "凿穿"},
	{"zaoci", "造次 造词"},
	{"zaodao", "遭到 早稻"},
	{"zaofan", "造反 早饭"},
	{"zaofu", "造福"},
	{"zaogao", "糟糕"},
	{"zaohua", "造化"},
	{"zaojia", "造价"},
	{"zaojiu", "造就"},
	{"zaolin", "造林"},
	{"zaonian", "早年"},
	{"zaopo", "糟粕"},
	{"zaoqi", "早期"},
	{"zaori", "早日"},
	{"zaoshang", "早上"},
	{"zaoshou", "遭受"},
	{"zaoshuai", "早衰"},
	{"zaota", "糟蹋"},
	{"zaowan", "早晚"},
	{"zaoxing", "造型"},
	{"zaoyang", "遭殃"},
	{"zaoyao", "造谣"},
	{"zaoyi", "造诣 早已"},
	{"zaoyin", "噪音"},
	{"zaoyu", "遭遇"},
	{"zaozi", "造字"},
	{"zata", "杂沓"},
	{"zatan", "杂谈"},
	{"zawen", "杂文"},
	{"zazhi", "杂质 杂志"},
	{"zbzy", "资本主义"},
	{"zcjj", "资产阶级"},
	{"zcl", "增长率"},
	{"zcmb", "总参谋部"},
	{"zcsx", "真才实学"},
	{"zdh", "自动化"},
	{"zdjc", "自动检测"},
	{"zdjs", "自动检索"},
	{"zdkz", "自动控制"},
	{"zdq", "主动权"},
	{"zds", "招待所"},
	{"zdsl", "总的说来"},
	{"zdx", "主动性"},
	{"zebei", "责备"},
	{"zecheng", "责成"},
	{"zefa", "责罚"},
	{"zeguai", "责怪"},
	{"zeling", "责令"},
	{"zema", "责骂"},
	{"zengbu", "增补"},
	{"zengchan", "增产"},
	{"zengchang", "增长"},
	{"zengda", "增大"},
	{"zengding", "增订"},
	{"zengduo", "增多"},
	{"zenggao", "增高"},
	{"zenghen", "憎恨"},
	{"zengjia", "增加"},
	{"zengjian", "增减"},
	{"zengjin", "增进"},
	{"zengliang", "增量"},
	{"zengpin", "赠品"},
	{"zengqiang", "增强"},
	{"zengshan", "增删"},
	{"zengshe", "增设"},
	{"zengsong", "赠送"},
	{"zengtian", "增添"},
	{"zengyan", "赠言"},
	{"zengyi", "增益"},
	{"zengyuan", "增援"},
	{"zenme", "怎么"},
	{"zennai", "怎奈"},
	{"zenyang", "怎样"},
	{"zeren", "责任"},
	{"zewen", "责问"},
	{"zeyz", "总而言之"},
	{"zfdm", "争分夺秒"},
	{"zfxd", "针锋相对"},
	{"zfyk", "自负盈亏"},
	{"zgc", "中关村"},
	{"zgfy", "自告奋勇"},
	{"zggd", "中国共产党"},
	{"zgh", "总工会"},
	{"zgr", "中国人 自个儿"},
	{"zgtd", "中国特色的"},
	{"zgyh", "中国银行"},
	{"zgyl", "自古以来"},
	{"zgzf", "中国政府"},
	{"zgzy", "中共中央"},
	{"zhadan", "炸弹"},
	{"zhagen", "扎根"},
	{"zhahui", "炸毁"},
	{"zhailu", "摘录"},
	{"zhaiquan", "债权"},
	{"zhaiwu", "债务"},
	{"zhaixiao", "窄小"},
	{"zhaiyao", "摘要"},
	{"zhaji", "札记"},
	{"zhanbai", "战败"},
	{"zhanbao", "战报"},
	{"zhanbei", "战备"},
	{"zhanchang", "战场"},
	{"zhanchi", "展翅"},
	{"zhanchu", "展出"},
	{"zhandi", "战地"},
	{"zhandou", "战斗"},
	{"zhanfan", "战犯"},
	{"zhangai", "障碍"},
	{"zhangang", "站岗"},
	{"zhangbei", "长辈"},
	{"zhangben", "账本"},
	{"zhangcheng", "章程"},
	{"zhangda", "长大"},
	{"zhange", "战歌"},
	{"zhangfa", "章法"},
	{"zhangfang", "帐房"},
	{"zhangfu", "丈夫"},
	{"zhangguan", "掌管"},
	{"zhanghao", "帐号"},
	{"zhangjie", "章节"},
	{"zhangmu", "帐目"},
	{"zhangong", "战功"},
	{"zhangquan", "掌权"},
	{"zhangtie", "张贴"},
	{"zhangu", "战鼓"},
	{"zhanguang", "沾光"},
	{"zhanguo", "战国 战果"},
	{"zhangwang", "张望"},
	{"zhangwo", "掌握"},
	{"zhangyang", "张扬"},
	{"zhanhao", "战壕"},
	{"zhanhou", "战后"},
	{"zhanji", "战机 战绩"},
	{"zhanju", "战局 占据"},
	{"zhankai", "展开"},
	{"zhankuang", "战况"},
	{"zhanlan", "展览"},
	{"zhanli", "站立 战栗"},
	{"zhanling", "占领"},
	{"zhanlue", "战略"},
	{"zhanma", "战马"},
	{"zhanpin", "展品"},
	{"zhanqu", "战区"},
	{"zhanran", "沾染"},
	{"zhansheng", "战胜"},
	{"zhanshi", "战时 战事 战士 展示"},
	{"zhanshu", "战术"},
	{"zhanwang", "展望"},
	{"zhanxian", "战线 展现"},
	{"zhanxiao", "展销"},
	{"zhanxin", "崭新"},
	{"zhanyang", "瞻仰"},
	{"zhanyi", "战役"},
	{"zhanyong", "占用"},
	{"zhanyou", "占有 战友"},
	{"zhanzhang", "站长"},
	{"zhanzheng", "战争"},
	{"zhanzhuan", "辗转"},
	{"zhaoban", "照办 照搬"},
	{"zhaobiao", "招标"},
	{"zhaochang", "照常"},
	{"zhaochao", "照抄"},
	{"zhaodai", "招待"},
	{"zhaofa", "照发"},
	{"zhaogong", "招工"},
	{"zhaogu", "照顾"},
	{"zhaohu", "招呼"},
	{"zhaohuan", "召唤"},
	{"zhaohui", "照会 召回 朝晖"},
	{"zhaoji", "着急 招集 召集"},
	{"zhaojia", "招架"},
	{"zhaokai", "召开"},
	{"zhaokao", "招考"},
	{"zhaolan", "招揽"},
	{"zhaoli", "着力 照例"},
	{"zhaoliao", "照料"},
	{"zhaoluo", "着落"},
	{"zhaomi", "着迷"},
	{"zhaoming", "照明"},
	{"zhaopian", "照片"},
	{"zhaopin", "招聘"},
	{"zhaoqi", "朝气"},
	{"zhaore", "招惹"},
	{"zhaoshe", "照射"},
	{"zhaosheng", "招生"},
	{"zhaoshou", "着手 招手 招收"},
	{"zhaotie", "招贴"},
	{"zhaoxi", "朝夕"},
	{"zhaoxia", "朝霞"},
	{"zhaoxiang", "着想 照相"},
	{"zhaoxue", "昭雪"},
	{"zhaoxun", "找寻"},
	{"zhaoyan", "着眼"},
	{"zhaoyang", "照样 朝阳"},
	{"zhaoyao", "照耀"},
	{"zhaoying", "照应"},
	{"zhaozhan", "招展"},
	{"zhaozhi", "招致"},
	{"zhaozhong", "着重"},
	{"zhaozhuo", "照着"},
	{"zhapian", "诈骗"},
	{"zhaqu", "榨取 诈取"},
	{"zhashi", "扎实"},
	{"zhayao", "炸药"},
	{"zhazi", "渣滓"},
	{"zheban", "这般"},
	{"zhebian", "这边"},
	{"zheci", "这次"},
	{"zhedang", "遮挡"},
	{"zhedian", "这点"},
	{"zhedie", "折叠"},
	{"zhefu", "折服"},
	{"zhegai", "遮盖"},
	{"zhege", "这个"},
	{"zhehe", "折合"},
	{"zhejiang", "浙江"},
	{"zhejiu", "折旧"},
	{"zhekou", "折扣"},
	{"zheli", "这里 哲理"},
	{"zheme", "这么"},
	{"zhemo", "折磨"},
	{"zhenai", "珍爱"},
	{"zhenbao", "珍宝"},
	{"zhenbian", "针砭"},
	{"zhencang", "珍藏"},
	{"zhencao", "贞操"},
	{"zhencha", "侦察"},
	{"zhencheng", "真诚"},
	{"zhendang", "震荡"},
	{"zhendi", "阵地 真谛"},
	{"zhendong", "震动"},
	{"zhenduan", "诊断"},
	{"zhendui", "针对"},
	{"zhenfen", "振奋"},
	{"zhengba", "争霸"},
	{"zhengbei", "整备"},
	{"zhengbi", "正比"},
	{"zhengbian", "政变 争辩 整编"},
	{"zhengbing", "征兵"},
	{"zhengce", "政策"},
	{"zhengchang", "正常"},
	{"zhengchao", "争吵"},
	{"zhengcheng", "征程"},
	{"zhengchi", "争持"},
	{"zhengda", "正大"},
	{"zhengdang", "正当 政党 整党"},
	{"zhengdao", "正道"},
	{"zhengduan", "争端"},
	{"zhengdun", "整顿"},
	{"zhengduo", "争夺"},
	{"zhengfa", "蒸发 政法"},
	{"zhengfan", "正反"},
	{"zhengfeng", "整风"},
	{"zhengfu", "政府 征服"},
	{"zhenggai", "整改"},
	{"zhengge", "整个"},
	{"zhenggou", "征购"},
	{"zhengguang", "争光"},
	{"zhenggui", "正规 正轨"},
	{"zhenghao", "正好"},
	{"zhengji", "征集"},
	{"zhengjian", "证件 政见"},
	{"zhengjie", "整洁"},
	{"zhengju", "证据"},
	{"zhengli", "整理"},
	{"zhenglun", "争论 政论"},
	{"zhengmian", "正面"},
	{"zhengming", "争鸣 证明"},
	{"zhengpai", "正派"},
	{"zhengpin", "征聘"},
	{"zhengqi", "整齐 争气 蒸气"},
	{"zhengqiao", "正巧"},
	{"zhengqiu", "征求"},
	{"zhengqu", "争取"},
	{"zhengquan", "政权"},
	{"zhengque", "正确"},
	{"zhengren", "证人"},
	{"zhengshi", "正式 正是 正视 证实"},
	{"zhengshou", "征收"},
	{"zhengshu", "整数 证书"},
	{"zhengshui", "征税"},
	{"zhengtao", "整套"},
	{"zhengti", "整体 正题"},
	{"zhengtian", "整天"},
	{"zhengtiao", "征调"},
	{"zhengtong", "正统"},
	{"zhengtu", "征途"},
	{"zhengui", "珍贵"},
	{"zhengwei", "政委"},
	{"zhengwen", "正文 征文"},
	{"zhengwu", "政务"},
	{"zhengxian", "争先"},
	{"zhengxie", "政协"},
	{"zhengxing", "整形"},
	{"zhengxiu", "整修"},
	{"zhengxun", "征询"},
	{"zhengyan", "争艳"},
	{"zhengye", "正业"},
	{"zhengyi", "正义 争议"},
	{"zhengyong", "征用"},
	{"zhengyue", "正月"},
	{"zhengzai", "正在"},
	{"zhengzha", "挣扎"},
	{"zhengzheng", "整整"},
	{"zhengzhi", "政治 争执 正直"},
	{"zhengzhong", "正中 郑重"},
	{"zhengzhou", "郑州"},
	{"zhengzhuang", "症状"},
	{"zhengzong", "正宗"},
	{"zhenhan", "震撼"},
	{"zhenji", "侦缉"},
	{"zhenjia", "真假"},
	{"zhenjiao", "阵脚"},
	{"zhenjie", "贞节"},
	{"zhenjing", "镇静 震惊"},
	{"zhenkong", "真空"},
	{"zhenli", "真理"},
	{"zhenliao", "诊疗"},
	{"zhenpin", "珍品"},
	{"zhenqi", "珍奇"},
	{"zhenqie", "真切"},
	{"zhenqing", "真情"},
	{"zhenque", "真确"},
	{"zhenren", "真人"},
	{"zhenrong", "阵容"},
	{"zhenshi", "真实 真是 阵势 珍视"},
	{"zhentan", "侦探"},
	{"zhenwang", "阵亡"},
	{"zhenxi", "珍惜"},
	{"zhenxian", "阵线"},
	{"zhenxiang", "真相"},
	{"zhenxing", "振兴"},
	{"zhenya", "镇压"},
	{"zhenzhen", "阵阵"},
	{"zhenzheng", "真正"},
	{"zhenzhi", "真挚 真知"},
	{"zhenzhong", "珍重"},
	{"zhenzhu", "珍珠"},
	{"zhenzhuo", "斟酌"},
	{"zhenzuo", "振作"},
	{"zheshi", "这是 这时"},
	{"zheteng", "折腾"},
	{"zhexie", "这些"},
	{"zhexue", "哲学"},
	{"zheyan", "遮掩"},
	{"zheyang", "这样"},
	{"zhezhong", "这种 折中"},
	{"zhian", "治安"},
	{"zhiban", "值班"},
	{"zhibao", "植保"},
	{"zhibei", "置备"},
	{"zhibian", "质变"},
	{"zhibiao", "指标"},
	{"zhibie", "职别"},
	{"zhibu", "支部"},
	{"zhicai", "制裁"},
	{"zhicheng", "支撑 职称"},
	{"zhichi", "支持"},
	{"zhichu", "指出 支出"},
	{"zhici", "至此 值此"},
	{"zhida", "直达"},
	{"zhidang", "只当"},
	{"zhidao", "知道 指导 直到"},
	{"zhide", "只得 值得"},
	{"zhidi", "质地"},
	{"zhidian", "指点"},
	{"zhiding", "制定 指定 制订"},
	{"zhidu", "制度"},
	{"zhidui", "支队"},
	{"zhiduo", "至多"},
	{"zhifa", "执法 知法"},
	{"zhifu", "支付"},
	{"zhigong", "职工"},
	{"zhigu", "只顾"},
	{"zhiguan", "直观"},
	{"zhiguo", "治国"},
	{"zhihao", "只好"},
	{"zhihou", "之后"},
	{"zhihui", "指挥 智慧"},
	{"zhiji", "知己"},
	{"zhijia", "指甲"},
	{"zhijian", "之间 只见"},
	{"zhijiao", "指教"},
	{"zhijie", "直接 枝节 肢解"},
	{"zhijin", "至今"},
	{"zhijing", "直径 止境 致敬"},
	{"zhijue", "知觉"},
	{"zhili", "智力 治理 致力"},
	{"zhiliang", "质量"},
	{"zhiliao", "治疗"},
	{"zhiling", "指令"},
	{"zhiliu", "直流 支流"},
	{"zhima", "芝麻"},
	{"zhimin", "殖民"},
	{"zhiming", "致命 指明 知名"},
	{"zhimou", "智谋"},
	{"zhinan", "指南"},
	{"zhinang", "智囊"},
	{"zhinei", "之内"},
	{"zhineng", "只能 职能 智能"},
	{"zhipa", "只怕"},
	{"zhipai", "指派"},
	{"zhipei", "支配"},
	{"zhipiao", "支票"},
	{"zhipin", "制品"},
	{"zhiqi", "志气"},
	{"zhiqian", "之前 支前"},
	{"zhiqin", "值勤 执勤"},
	{"zhiqing", "知情 知青"},
	{"zhiqu", "志趣 知趣"},
	{"zhiquan", "职权"},
	{"zhiri", "值日"},
	{"zhisang", "治丧"},
	{"zhishang", "之上 直上 至上"},
	{"zhishao", "至少"},
	{"zhisheng", "制胜 之声"},
	{"zhishi", "只是 指使 致使 知事 指示 知识 指数"},
	{"zhishu", "支书 直属 植树"},
	{"zhishuang", "直爽"},
	{"zhishui", "治水"},
	{"zhishuo", "直说"},
	{"zhisi", "致死"},
	{"zhiwai", "之外"},
	{"zhiwang", "指望"},
	{"zhiwei", "职位"},
	{"zhiwen", "质问"},
	{"zhiwu", "植物 职务"},
	{"zhixi", "窒息"},
	{"zhixia", "之下"},
	{"zhixian", "直线"},
	{"zhixiang", "志向"},
	{"zhixin", "知心"},
	{"zhixing", "执行"},
	{"zhixu", "只许 秩序"},
	{"zhiyan", "直言"},
	{"zhiyao", "只要"},
	{"zhiye", "职业"},
	{"zhiyi", "之一 致意 旨意"},
	{"zhiyin", "知音 指引"},
	{"zhiyou", "只有"},
	{"zhiyu", "至于 置于 智育"},
	{"zhiyuan", "志愿 支援 职员"},
	{"zhiyue", "制约"},
	{"zhizao", "制造"},
	{"zhize", "指责 职责"},
	{"zhizhang", "纸张 职掌"},
	{"zhizhao", "执照"},
	{"zhizheng", "执政 指正"},
	{"zhizhi", "制止 直至"},
	{"zhizhong", "之中"},
	{"zhizhu", "支助 支柱"},
	{"zhizu", "知足"},
	{"zhizuo", "制作"},
	{"zhm", "走后门"},
	{"zhmg", "中华民国"},
	{"zhmz", "中华民族"},
	{"zhongai", "钟爱"},
	{"zhongban", "重办"},
	{"zhongbing", "重兵"},
	{"zhongbu", "中部"},
	{"zhongcai", "仲裁"},
	{"zhongceng", "中层"},
	{"zhongchang", "衷肠"},
	{"zhongcheng", "忠诚"},
	{"zhongda", "重大"},
	{"zhongdan", "重担"},
	{"zhongdeng", "中等"},
	{"zhongdi", "重地"},
	{"zhongdian", "重点 终点"},
	{"zhongdong", "中东"},
	{"zhongduan", "中断 终端"},
	{"zhongdui", "中队"},
	{"zhongduo", "众多"},
	{"zhongfan", "重犯"},
	{"zhonggao", "忠告"},
	{"zhonggong", "中共"},
	{"zhongguo", "中国"},
	{"zhonghou", "忠厚"},
	{"zhonghua", "中华"},
	{"zhongji", "终极 中级"},
	{"zhongjia", "重价"},
	{"zhongjian", "中间 中坚"},
	{"zhongjiang", "中奖"},
	{"zhongjie", "终结"},
	{"zhongjiu", "终究 终久"},
	{"zhongju", "终局"},
	{"zhongken", "中肯"},
	{"zhonglei", "种类"},
	{"zhongli", "中立"},
	{"zhongliang", "重量"},
	{"zhongliao", "终了"},
	{"zhongliu", "肿瘤 中流"},
	{"zhongmei", "中美"},
	{"zhongmu", "众目"},
	{"zhongnian", "中年 终年"},
	{"zhongqiu", "中秋"},
	{"zhongren", "重任"},
	{"zhongri", "中日 终日"},
	{"zhongshang", "中伤 重赏"},
	{"zhongshen", "终身"},
	{"zhongsheng", "终生"},
	{"zhongshi", "重视 忠实 中式"},
	{"zhongshu", "中枢"},
	{"zhongshuo", "众说"},
	{"zhongsu", "中苏"},
	{"zhongtian", "终天"},
	{"zhongtu", "中途"},
	{"zhongtuo", "重托"},
	{"zhongwai", "中外"},
	{"zhongwei", "重围"},
	{"zhongwen", "中文"},
	{"zhongwu", "中午"},
	{"zhongxi", "中西"},
	{"zhongxin", "中心 忠心 衷心"},
	{"zhongxing", "中性"},
	{"zhongxue", "中学"},
	{"zhongxun", "中旬"},
	{"zhongyan", "忠言"},
	{"zhongyang", "中央"},
	{"zhongyao", "重要 中药"},
	{"zhongyi", "中医"},
	{"zhongyong", "重用 中庸"},
	{"zhongyou", "中游"},
	{"zhongyu", "终于 忠于"},
	{"zhongzhen", "忠贞"},
	{"zhongzhi", "中止 种植 终止"},
	{"zhongzhong", "种种"},
	{"zhongzhuan", "中专"},
	{"zhongzu", "种族"},
	{"zhoudao", "周到"},
	{"zhouji", "周济"},
	{"zhouma", "咒骂"},
	{"zhoumi", "周密"},
	{"zhoumo", "周末"},
	{"zhouqi", "周期"},
	{"zhouquan", "周全"},
	{"zhouwei", "周围"},
	{"zhouxuan", "周旋"},
	{"zhouye", "昼夜"},
	{"zhouzhe", "周折"},
	{"zhouzhi", "周知"},
	{"zhouzhuan", "周转"},
	{"zhqb", "总后勤部"},
	{"zhrg", "中华人民共和国"},
	{"zhuahao", "抓好"},
	{"zhuajin", "抓紧"},
	{"zhuanbian", "转变"},
	{"zhuanbo", "转播"},
	{"zhuanchang", "专长"},
	{"zhuancheng", "专程"},
	{"zhuanda", "转达"},
	{"zhuanfa", "转发"},
	{"zhuangao", "转告"},
	{"zhuangban", "装扮"},
	{"zhuangbei", "装备"},
	{"zhuangda", "壮大"},
	{"zhuangding", "装订"},
	{"zhuangguan", "壮观"},
	{"zhuanghuang", "装潢"},
	{"zhuangjia", "装甲 庄稼"},
	{"zhuangju", "壮举"},
	{"zhuangkuang", "状况"},
	{"zhuangkuo", "壮阔"},
	{"zhuangli", "壮丽"},
	{"zhuanglie", "壮烈"},
	{"zhuangpei", "装配"},
	{"zhuangshi", "装饰"},
	{"zhuangtai", "状态"},
	{"zhuangxie", "装卸"},
	{"zhuangyan", "庄严"},
	{"zhuangyuan", "庄园"},
	{"zhuangyun", "装运"},
	{"zhuangzhi", "装置 壮志"},
	{"zhuangzhong", "庄重"},
	{"zhuanhua", "转化"},
	{"zhuanhuan", "转换"},
	{"zhuanji", "转给"},
	{"zhuanjia", "专家"},
	{"zhuanke", "专科"},
	{"zhuanli", "专利"},
	{"zhuanmen", "专门"},
	{"zhuanrang", "转让"},
	{"zhuanti", "专题"},
	{"zhuanxiang", "转向"},
	{"zhuanxin", "专心"},
	{"zhuanyan", "转眼"},
	{"zhuanye", "专业"},
	{"zhuanyi", "转移"},
	{"zhuanyou", "转悠"},
	{"zhuanyuan", "专员"},
	{"zhuanzai", "转载"},
	{"zhuanzhe", "转折"},
	{"zhuanzheng", "转正 专政"},
	{"zhuanzhi", "专制 专职"},
	{"zhuanzhu", "专注 专著"},
	{"zhuban", "主办"},
	{"zhubu", "逐步"},
	{"zhucang", "贮藏"},
	{"zhuce", "注册"},
	{"zhuchang", "助长"},
	{"zhuchi", "主持"},
	{"zhuci", "主次"},
	{"zhudao", "主导"},
	{"zhuding", "注定"},
	{"zhudong", "主动"},
	{"zhudui", "主队"},
	{"zhufan", "主犯"},
	{"zhufang", "住房"},
	{"zhufu", "祝福 嘱咐"},
	{"zhuge", "逐个"},
	{"zhugong", "主攻 助工"},
	{"zhuguan", "主观 主管"},
	{"zhuibu", "追捕"},
	{"zhuicha", "追查"},
	{"zhuidao", "追悼"},
	{"zhuigan", "追赶"},
	{"zhuihui", "坠毁"},
	{"zhuijia", "追加"},
	{"zhuijiu", "追究"},
	{"zhuiqiu", "追求"},
	{"zhuiren", "追认"},
	{"zhuisu", "追溯"},
	{"zhuisui", "追随"},
	{"zhuiwen", "追问"},
	{"zhuizhu", "追逐"},
	{"zhuizong", "追踪"},
	{"zhuji", "主机"},
	{"zhujian", "逐渐 主见"},
	{"zhujiang", "主将 主讲"},
	{"zhujiao", "主角 主教"},
	{"zhujie", "注解"},
	{"zhujiu", "祝酒"},
	{"zhuli", "主力 助理"},
	{"zhulian", "株连"},
	{"zhuliang", "主粮"},
	{"zhuliu", "主流 驻留"},
	{"zhuming", "著名"},
	{"zhumou", "主谋"},
	{"zhumu", "注目 瞩目"},
	{"zhunbei", "准备"},
	{"zhunian", "逐年"},
	{"zhunque", "准确"},
	{"zhunsheng", "准绳"},
	{"zhunshi", "准时"},
	{"zhunxu", "准许"},
	{"zhunze", "准则"},
	{"zhuolie", "拙劣"},
	{"zhuomo", "琢磨"},
	{"zhuonong", "捉弄"},
	{"zhuoqing", "酌情"},
	{"zhuoyue", "卓越"},
	{"zhuozhuang", "茁壮"},
	{"zhuquan", "主权"},
	{"zhuren", "主人 主任"},
	{"zhuru", "诸如"},
	{"zhuse", "注色"},
	{"zhushi", "注视 注释"},
	{"zhushou", "助手"},
	{"zhusu", "住宿"},
	{"zhusuan", "珠算"},
	{"zhuti", "主题 主体"},
	{"zhutiao", "逐条"},
	{"zhutuo", "嘱托"},
	{"zhuwei", "诸位"},
	{"zhuxi", "主席"},
	{"zhuxiao", "注销"},
	{"zhuyao", "主要"},
	{"zhuyi", "主意 注意 主义 逐一"},
	{"zhuyuan", "祝愿"},
	{"zhuyue", "逐月"},
	{"zhuzai", "主宰"},
	{"zhuzao", "铸造"},
	{"zhuzha", "驻扎"},
	{"zhuzhai", "住宅"},
	{"zhuzhang", "主张"},
	{"zhuzhi", "住址"},
	{"zhuzhong", "注重"},
	{"zhuzuo", "著作"},
	{"ziai", "自爱"},
	{"zibai", "自白"},
	{"zibei", "自卑"},
	{"ziben", "资本"},
	{"zichan", "资产"},
	{"zichang", "滋长"},
	{"zicheng", "自称"},
	{"zichuan", "自传"},
	{"zicong", "自从"},
	{"zidi", "子弟"},
	{"zidian", "字典"},
	{"zidong", "自动"},
	{"zifa", "自发"},
	{"zifei", "自费"},
	{"zifeng", "自封"},
	{"zifu", "字符 自负"},
	{"zige", "资格"},
	{"zigen", "字根"},
	{"zihao", "自豪"},
	{"ziji", "自己 自给 字迹"},
	{"zijie", "字节"},
	{"zijin", "资金"},
	{"zijiu", "自救"},
	{"ziju", "自居"},
	{"zijue", "自觉"},
	{"ziku", "字库"},
	{"zikua", "自夸"},
	{"zili", "自理 资历"},
	{"ziliao", "资料"},
	{"ziman", "自满"},
	{"zimian", "自勉"},
	{"zimu", "字母 字幕"},
	{"zinv", "子女"},
	{"ziqiang", "自强"},
	{"ziran", "自然"},
	{"zirun", "滋润"},
	{"zisha", "自杀"},
	{"zishen", "自身"},
	{"zishi", "姿势"},
	{"zishu", "自述"},
	{"zisi", "自私"},
	{"zitai", "姿态"},
	{"ziti", "字体"},
	{"zitie", "字帖"},
	{"ziwei", "滋味 自卫"},
	{"ziwen", "自问"},
	{"ziwo", "自我"},
	{"zixi", "仔细"},
	{"zixin", "自信"},
	{"zixiu", "自修"},
	{"zixu", "自叙"},
	{"zixuan", "自选"},
	{"zixue", "自学"},
	{"zixun", "咨询"},
	{"ziyang", "滋养"},
	{"ziyou", "自由"},
	{"ziyuan", "资源 自愿"},
	{"zizhao", "自找"},
	{"zizhi", "自治"},
	{"zizhong", "自重"},
	{"zizhu", "资助"},
	{"zizun", "自尊"},
	{"zizi", "孜孜"},
	{"zjbb", "正经八百"},
	{"zjld", "直截了当"},
	{"zjs", "浙江省"},
	{"zjss", "这就是说"},
	{"zjw", "中纪委"},
	{"zjzl", "再接再厉"},
	{"zjzy", "自觉自愿"},
	{"zjzz", "自给自足"},
	{"zlb", "中联部"},
	{"zlf", "专利法"},
	{"zlgl", "质量管理"},
	{"zlgs", "自力更生"},
	{"zlh", "展览会"},
	{"zlkf", "智力开发"},
	{"zlq", "专利权"},
	{"zmgh", "走马观花"},
	{"zmn", "丈母娘"},
	{"zmrs", "知名人士"},
	{"zmx", "这么些"},
	{"zmy", "这么样 怎么样"},
	{"zongbu", "总部"},
	{"zongcai", "总裁"},
	{"zongcan", "总参"},
	{"zongdui", "总队"},
	{"zonge", "总额"},
	{"zonggang", "总纲"},
	{"zonggong", "总共"},
	{"zongguan", "纵贯"},
	{"zonghe", "总和 综合"},
	{"zongheng", "纵横"},
	{"zonghou", "总后"},
	{"zongji", "总计 踪迹"},
	{"zongjiao", "宗教"},
	{"zongjie", "总结"},
	{"zongju", "总局"},
	{"zongkuo", "总括"},
	{"zongli", "总理"},
	{"zonglun", "总论"},
	{"zongpai", "宗派"},
	{"zongqing", "纵情"},
	{"zongshen", "纵深"},
	{"zongshi", "总是 纵使"},
	{"zongshu", "总数"},
	{"zongsuan", "总算"},
	{"zongti", "总体"},
	{"zongtong", "总统"},
	{"zongwu", "总务"},
	{"zongying", "踪影"},
	{"zongzhang", "总帐"},
	{"zongzheng", "总政"},
	{"zongzhi", "总之 宗旨"},
	{"zoufang", "走访"},
	{"zouhong", "邹虹"},
	{"zousi", "走私"},
	{"zouxiao", "奏效"},
	{"zqcl", "酌情处理"},
	{"zqn", "中青年"},
	{"zqpb", "朝气蓬勃"},
	{"zqww", "准确无误"},
	{"zqx", "正确性"},
	{"zrcl", "诸如此类"},
	{"zrg", "责任感"},
	{"zrj", "自然界"},
	{"zrw", "主人翁"},
	{"zrx", "责任心"},
	{"zrz", "责任制"},
	{"zsc", "再生产"},
	{"zsex", "自上而下"},
	{"zsfz", "知识分子"},
	{"zsh", "这时候 知识化"},
	{"zshj", "指手画脚"},
	{"zshs", "株式会社"},
	{"zsj", "总书记"},
	{"zsp", "装饰品"},
	{"zsss", "综上所述"},
	{"zsy", "之所以"},
	{"zszz", "自始至终 众所周知"},
	{"zth", "座谈会"},
	{"zuai", "阻碍"},
	{"zuanyan", "钻研"},
	{"zucheng", "组成"},
	{"zudang", "阻挡"},
	{"zuge", "组阁"},
	{"zugou", "足够"},
	{"zuguo", "祖国"},
	{"zuhe", "组合"},
	{"zuichu", "最初"},
	{"zuida", "最大"},
	{"zuidi", "最低"},
	{"zuie", "罪恶"},
	{"zuifan", "罪犯"},
	{"zuigao", "最高"},
	{"zuiguo", "罪过"},
	{"zuihao", "最好"},
	{"zuihou", "最后"},
	{"zuihuai", "最坏"},
	{"zuijia", "最佳"},
	{"zuijin", "最近"},
	{"zuilian", "嘴脸"},
	{"zuiming", "罪名"},
	{"zuinie", "罪孽"},
	{"zuiren", "罪人"},
	{"zuixian", "最先"},
	{"zuixiao", "最小"},
	{"zuixin", "最新 醉心"},
	{"zuixing", "罪行"},
	{"zuize", "罪责"},
	{"zuizheng", "罪证"},
	{"zuizhong", "最终"},
	{"zuizhuang", "罪状"},
	{"zuji", "阻击"},
	{"zujie", "租界 租借"},
	{"zulan", "阻拦"},
	{"zuli", "阻力"},
	{"zulin", "租赁"},
	{"zunao", "阻挠"},
	{"zuncong", "遵从"},
	{"zungui", "尊贵"},
	{"zunjing", "尊敬"},
	{"zunshou", "遵守"},
	{"zunxun", "遵循"},
	{"zunyan", "尊严"},
	{"zunzhao", "遵照"},
	{"zunzhong", "尊重"},
	{"zuoan", "作案"},
	{"zuobi", "作弊"},
	{"zuobian", "左边"},
	{"zuobiao", "坐标"},
	{"zuodao", "做到"},
	{"zuofa", "作法 做法"},
	{"zuofei", "作废"},
	{"zuofeng", "作风"},
	{"zuogong", "做工"},
	{"zuoguai", "作怪"},
	{"zuohao", "做好"},
	{"zuojia", "作家"},
	{"zuoke", "作客"},
	{"zuole", "作乐"},
	{"zuoluan", "作乱"},
	{"zuoluo", "坐落"},
	{"zuopai", "左派"},
	{"zuopin", "作品"},
	{"zuoqing", "左倾"},
	{"zuoren", "做人"},
	{"zuori", "昨日"},
	{"zuoshi", "做事 坐视"},
	{"zuotan", "座谈"},
	{"zuotian", "昨天"},
	{"zuowan", "昨晚"},
	{"zuowei", "作为 座位 坐位"},
	{"zuowen", "作文"},
	{"zuowu", "作物"},
	{"zuoye", "作业 昨夜"},
	{"zuoyong", "作用"},
	{"zuoyou", "左右"},
	{"zuozhan", "作战"},
	{"zuozhe", "作者"},
	{"zuozheng", "作证 佐证"},
	{"zuozhu", "作主 做主"},
	{"zuozuo", "做作"},
	{"zuqiu", "足球"},
	{"zuse", "阻塞"},
	{"zushi", "祖师"},
	{"zuxian", "祖先"},
	{"zuzhang", "组长"},
	{"zuzhi", "组织 阻止"},
	{"zuzong", "祖宗"},
	{"zwhz", "中外合资"},
	{"zwpd", "责无旁贷"},
	{"zxb", "中宣部"},
	{"zxc", "自行车"},
	{"zxes", "自下而上"},
	{"zxgg", "忠心耿耿"},
	{"zxh", "展销会"},
	{"zxj", "照相机"},
	{"zxkh", "争先恐后"},
	{"zxs", "中学生"},
	{"zxt", "主席团"},
	{"zxx", "中小学 自信心"},
	{"zybt", "中央办公厅"},
	{"zyd", "着眼点"},
	{"zydk", "专业对口"},
	{"zydt", "中央电视台"},
	{"zygw", "中央各部委"},
	{"zyh", "专业化 专业户"},
	{"zyjw", "中央军委"},
	{"zym", "座右铭"},
	{"zyqh", "中央全会"},
	{"zyrt", "中央人民广播电台"},
	{"zysc", "中央书记处"},
	{"zywh", "中央委员会"},
	{"zywy", "中央委员"},
	{"zyx", "重要性"},
	{"zyyy", "主要原因"},
	{"zyzj", "中央政治局"},
	{"zyzs", "专业知识"},
	{"zzb", "中组部 组织部 政治部"},
	{"zzbj", "孜孜不倦"},
	{"zzc", "政治处"},
	{"zzd", "转折点"},
	{"zzdw", "置之度外"},
	{"zzj", "政治局"},
	{"zzq", "自治区"},
	{"zzrs", "蒸蒸日上"},
	{"zzs", "组织上 郑州市"},
	{"zzx", "组织性 自尊心"},
	{"zzzb", "总政治部"},
	{"yizhi", "一直 一致 以至 以致 意志 抑制 医治 抑止 移植 遗址"},

	{NIL_PTR}
};
