/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */
/*
 * simple expandable array
 * $Id: array.h,v 1.4 1999/12/20 19:51:27 kos Exp $
 */

#ifndef _ARRAY_H
#define _ARRAY_H

#define ARRAY_CHUNK 128

typedef struct array {
  void *data;
  int allocelem;
  int nelem;
  int sizelem;
} array;

/* Exported */
array *array_init_hint(array *, int sizelem, int hint);
array *array_init(int sizelem);
int array_add(array *, void *data);
#define array_nelems(x) (x ? (x)->nelem : 0)
int array_nuke(array *);
void * array_get(array *, int which );
int array_zero(array *);
int array_delete(array *, int which);

#endif
