/*!
  @defgroup   IOManagement I/O Management
*/
/*!
  @file     IOMan_Types.hpp
  @author   TorstenS
  @ingroup  IOManagement
  @brief    Basic types of this component
  @see            

\if EMIT_LICENCE
    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif
*/


#ifndef IOMAN_TYPES_HPP
#define IOMAN_TYPES_HPP

#include "KernelCommon/Kernel_Common.hpp"
#include "SAPDBCommon/SAPDB_EnhancedTypes.hpp"

#include "SAPDBCommon/Tracing/SAPDBTrace_Topic.hpp"
#include "SAPDBCommon/Diagnostics/SAPDBDiag_CheckTopic.hpp"


/// external reference of IOManager trace
extern SAPDBTrace_Topic     IOMan_Trace;

/// external reference of IOManager checks
extern SAPDBDiag_CheckTopic IOMan_Check;

/* -----------------------------------------------------------------------*/
/*!
   @brief   Logical volume number
 */
/* -----------------------------------------------------------------------*/

typedef SAPDB_Invalidatable<SAPDB_Int2, SAPDB_MAX_INT2>
IOMan_DeviceNo;

/* -----------------------------------------------------------------------*/
/*!
   @brief   Logical block offset on volume
 */
/* -----------------------------------------------------------------------*/

typedef SAPDB_Invalidatable<SAPDB_Int4, SAPDB_MAX_INT4>
IOMan_BlockNo;

/* -----------------------------------------------------------------------*/
/*!
   @brief   Number of blocks
 */
/* -----------------------------------------------------------------------*/

typedef SAPDB_Int4 IOMan_BlockCount;

/* -----------------------------------------------------------------------*/
/*!
   @brief   ReturnCodes of component I/O Manager
 */
/* -----------------------------------------------------------------------*/

typedef enum
{
    IOMan_Okay = 0,
    IOMan_NotConfigured,
    IOMan_AttachFailed,
    IOMan_ConfigurationCorrupted,
    IOMan_FormatFailed,
    IOMan_BadVolume,
    IOMan_VolumeCapacityMismatch,
    IOMan_ReadError,
    IOMan_WriteError,
    IOMan_BadInfoPage,
    IOMan_NoConverterEntry,
    IOMan_BadDataPage,
    IOMan_NotPreparedForMigration,
    IOMan_NoMoreMemory,
    IOMan_PageNoOutOfRange
} IOMan_ReturnCode;

#endif // IOMAN_TYPES_HPP

