/*----------------------------------------------------------------------------

   libtunepimp -- The MusicBrainz tagging library.  
                  Let a thousand taggers bloom!
   
   Copyright (C) Robert Kaye 2003
   
   This file is part of libtunepimp.

   libtunepimp is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   libtunepimp is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with libtunepimp; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   $Id: tunepimp_wrapper.c,v 1.4 2004/03/25 10:12:43 robert Exp $

----------------------------------------------------------------------------*/
#include <Python.h>
#include "pytunepimp.h"
#include "../../config.h"

typedef struct {
  PyObject_HEAD
  tunepimp_t *tp;
} py_tp;

PyObject * py_tp_raise_exception(const char * format, ...)
{
    char exceptionMsg[1024];
    va_list ap;
    
    va_start(ap, format);
    vsnprintf(exceptionMsg, 1024, format, ap);
    va_end(ap);
    PyErr_SetString(Py_TunePimpError, exceptionMsg);
    return NULL;
}

/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.20
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGPYTHON

#include "Python.h"

/*************************************************************** -*- c -*-
 * python/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Python_TypeRegister
#define SWIG_TypeCheck       SWIG_Python_TypeCheck
#define SWIG_TypeCast        SWIG_Python_TypeCast
#define SWIG_TypeDynamicCast SWIG_Python_TypeDynamicCast
#define SWIG_TypeName        SWIG_Python_TypeName
#define SWIG_TypeQuery       SWIG_Python_TypeQuery
#define SWIG_TypeClientData  SWIG_Python_TypeClientData
#define SWIG_PackData        SWIG_Python_PackData 
#define SWIG_UnpackData      SWIG_Python_UnpackData 


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = swig_type_list;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  int i;
  unsigned char *u = (unsigned char *) ptr;
  register unsigned char uu;
  for (i = 0; i < sz; i++,u++) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  int i;
  for (i = 0; i < sz; i++, u++) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/***********************************************************************
 * python.swg
 *
 *     This file contains the runtime support for Python modules
 *     and includes code for managing global variables and pointer
 *     type checking.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 ************************************************************************/

#include "Python.h"

#ifdef __cplusplus
extern "C" {
#endif

#define SWIG_PY_INT     1
#define SWIG_PY_FLOAT   2
#define SWIG_PY_STRING  3
#define SWIG_PY_POINTER 4
#define SWIG_PY_BINARY  5

/* Flags for pointer conversion */

#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

/* Exception handling in wrappers */
#define SWIG_fail   goto fail

/* Constant information structure */
typedef struct swig_const_info {
    int type;
    char *name;
    long lvalue;
    double dvalue;
    void   *pvalue;
    swig_type_info **ptype;
} swig_const_info;

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Python_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Python_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Python_MustGetPtr(p, type, argnum, flags)

/* Python-specific SWIG API */
#define SWIG_newvarlink() \
  SWIG_Python_newvarlink()
#define SWIG_addvarlink(p, name, get_attr, set_attr) \
  SWIG_Python_addvarlink(p, name, get_attr, set_attr)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Python_ConvertPacked(obj, ptr, sz, ty, flags)
#define SWIG_NewPackedObj(ptr, sz, type) \
  SWIG_Python_NewPackedObj(ptr, sz, type)
#define SWIG_InstallConstants(d, constants) \
  SWIG_Python_InstallConstants(d, constants)

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(int)               SWIG_Python_ConvertPtr(PyObject *, void **, swig_type_info *, int);
SWIGIMPORT(PyObject *)        SWIG_Python_NewPointerObj(void *, swig_type_info *,int own);
SWIGIMPORT(void *)            SWIG_Python_MustGetPtr(PyObject *, swig_type_info *, int, int);
SWIGIMPORT(PyObject *)        SWIG_Python_newvarlink(void);
SWIGIMPORT(void)              SWIG_Python_addvarlink(PyObject *, char *, PyObject *(*)(void), int (*)(PyObject *));
SWIGIMPORT(int)               SWIG_Python_ConvertPacked(PyObject *, void *, int sz, swig_type_info *, int);
SWIGIMPORT(PyObject *)        SWIG_Python_NewPackedObj(void *, int sz, swig_type_info *);
SWIGIMPORT(void)              SWIG_Python_InstallConstants(PyObject *d, swig_const_info constants[]);

#else

/* -----------------------------------------------------------------------------
 * global variable support code.
 * ----------------------------------------------------------------------------- */

typedef struct swig_globalvar {   
  char       *name;                  /* Name of global variable */
  PyObject *(*get_attr)(void);       /* Return the current value */
  int       (*set_attr)(PyObject *); /* Set the value */
  struct swig_globalvar *next;
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar *vars;
} swig_varlinkobject;

static PyObject *
swig_varlink_repr(swig_varlinkobject *v) {
  v = v;
  return PyString_FromString("<Global variables>");
}

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags) {
  swig_globalvar  *var;
  flags = flags;
  fprintf(fp,"Global variables { ");
  for (var = v->vars; var; var=var->next) {
    fprintf(fp,"%s", var->name);
    if (var->next) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n) {
  swig_globalvar *var = v->vars;
  while (var) {
    if (strcmp(var->name,n) == 0) {
      return (*var->get_attr)();
    }
    var = var->next;
  }
  PyErr_SetString(PyExc_NameError,"Unknown C global variable");
  return NULL;
}

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p) {
  swig_globalvar *var = v->vars;
  while (var) {
    if (strcmp(var->name,n) == 0) {
      return (*var->set_attr)(p);
    }
    var = var->next;
  }
  PyErr_SetString(PyExc_NameError,"Unknown C global variable");
  return 1;
}

statichere PyTypeObject varlinktype = {
  PyObject_HEAD_INIT(0)              
  0,
  (char *)"swigvarlink",              /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */
SWIGRUNTIME(PyObject *)
SWIG_Python_newvarlink(void) {
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  result->vars = 0;
  result->ob_refcnt = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGRUNTIME(void)
SWIG_Python_addvarlink(PyObject *p, char *name, PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p)) {
  swig_varlinkobject *v;
  swig_globalvar *gv;
  v= (swig_varlinkobject *) p;
  gv = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  gv->name = (char *) malloc(strlen(name)+1);
  strcpy(gv->name,name);
  gv->get_attr = get_attr;
  gv->set_attr = set_attr;
  gv->next = v->vars;
  v->vars = gv;
}

/* Convert a pointer value */
SWIGRUNTIME(int)
SWIG_Python_ConvertPtr(PyObject *obj, void **ptr, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  char  *c = 0;
  static PyObject *SWIG_this = 0;
  int    newref = 0;
  PyObject  *pyobj = 0;

  if (!obj) return 0;
  if (obj == Py_None) {
    *ptr = 0;
    return 0;
  }
#ifdef SWIG_COBJECT_TYPES
  if (!(PyCObject_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_FromString("this");
    pyobj = obj;
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyCObject_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  }  
  *ptr = PyCObject_AsVoidPtr(obj);
  c = (char *) PyCObject_GetDesc(obj);
  if (newref) Py_DECREF(obj);
  goto cobject;
#else
  if (!(PyString_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_FromString("this");
    pyobj = obj;
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyString_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  } 
  c = PyString_AsString(obj);
  /* Pointer values must start with leading underscore */
  if (*c != '_') {
    *ptr = (void *) 0;
    if (strcmp(c,"NULL") == 0) {
      if (newref) { Py_DECREF(obj); }
      return 0;
    } else {
      if (newref) { Py_DECREF(obj); }
      goto type_error;
    }
  }
  c++;
  c = SWIG_UnpackData(c,ptr,sizeof(void *));
  if (newref) { Py_DECREF(obj); }
#endif

#ifdef SWIG_COBJECT_TYPES
cobject:
#endif

  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
    *ptr = SWIG_TypeCast(tc,(void*) *ptr);
  }

  if ((pyobj) && (flags & SWIG_POINTER_DISOWN)) {
    PyObject *zero = PyInt_FromLong(0);
    PyObject_SetAttrString(pyobj,(char*)"thisown",zero);
    Py_DECREF(zero);
  }
  return 0;

type_error:
  if (flags & SWIG_POINTER_EXCEPTION) {
    if (ty && c) {
      char *temp = (char *) malloc(64+strlen(ty->name)+strlen(c));
      sprintf(temp,"Type error. Got %s, expected %s", c, ty->name);
      PyErr_SetString(PyExc_TypeError, temp);
      free((char *) temp);
    } else {
      PyErr_SetString(PyExc_TypeError,"Expected a pointer");
    }
  }
  return -1;
}

/* Convert a pointer value, signal an exception on a type mismatch */
SWIGRUNTIME(void *)
SWIG_Python_MustGetPtr(PyObject *obj, swig_type_info *ty, int argnum, int flags) {
  void *result;
  SWIG_Python_ConvertPtr(obj, &result, ty, flags | SWIG_POINTER_EXCEPTION);
  return result;
}

/* Convert a packed value value */
SWIGRUNTIME(int)
SWIG_Python_ConvertPacked(PyObject *obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  char  *c = 0;

  if ((!obj) || (!PyString_Check(obj))) goto type_error;
  c = PyString_AsString(obj);
  /* Pointer values must start with leading underscore */
  if (*c != '_') goto type_error;
  c++;
  c = SWIG_UnpackData(c,ptr,sz);
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
  }
  return 0;

type_error:

  if (flags) {
    if (ty && c) {
      char *temp = (char *) malloc(64+strlen(ty->name)+strlen(c));
      sprintf(temp,"Type error. Got %s, expected %s", c, ty->name);
      PyErr_SetString(PyExc_TypeError, temp);
      free((char *) temp);
    } else {
      PyErr_SetString(PyExc_TypeError,"Expected a pointer");
    }
  }
  return -1;
}

/* Create a new pointer object */
SWIGRUNTIME(PyObject *)
SWIG_Python_NewPointerObj(void *ptr, swig_type_info *type, int own) {
  PyObject *robj;
  if (!ptr) {
    Py_INCREF(Py_None);
    return Py_None;
  }
#ifdef SWIG_COBJECT_TYPES
  robj = PyCObject_FromVoidPtrAndDesc((void *) ptr, (char *) type->name, NULL);
#else
  {
    char result[1024];
    char *r = result;
    *(r++) = '_';
    r = SWIG_PackData(r,&ptr,sizeof(void *));
    strcpy(r,type->name);
    robj = PyString_FromString(result);
  }
#endif
  if (!robj || (robj == Py_None)) return robj;
  if (type->clientdata) {
    PyObject *inst;
    PyObject *args = Py_BuildValue((char*)"(O)", robj);
    Py_DECREF(robj);
    inst = PyObject_CallObject((PyObject *) type->clientdata, args);
    Py_DECREF(args);
    if (inst) {
      if (own) {
        PyObject *n = PyInt_FromLong(1);
        PyObject_SetAttrString(inst,(char*)"thisown",n);
        Py_DECREF(n);
      }
      robj = inst;
    }
  }
  return robj;
}

SWIGRUNTIME(PyObject *)
SWIG_Python_NewPackedObj(void *ptr, int sz, swig_type_info *type) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  strcpy(r,type->name);
  return PyString_FromString(result);
}

/* Install Constants */
SWIGRUNTIME(void)
SWIG_Python_InstallConstants(PyObject *d, swig_const_info constants[]) {
  int i;
  PyObject *obj;
  for (i = 0; constants[i].type; i++) {
    switch(constants[i].type) {
    case SWIG_PY_INT:
      obj = PyInt_FromLong(constants[i].lvalue);
      break;
    case SWIG_PY_FLOAT:
      obj = PyFloat_FromDouble(constants[i].dvalue);
      break;
    case SWIG_PY_STRING:
      obj = PyString_FromString((char *) constants[i].pvalue);
      break;
    case SWIG_PY_POINTER:
      obj = SWIG_NewPointerObj(constants[i].pvalue, *(constants[i]).ptype,0);
      break;
    case SWIG_PY_BINARY:
      obj = SWIG_NewPackedObj(constants[i].pvalue, constants[i].lvalue, *(constants[i].ptype));
      break;
    default:
      obj = 0;
      break;
    }
    if (obj) {
      PyDict_SetItemString(d,constants[i].name,obj);
      Py_DECREF(obj);
    }
  }
}

#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { PyErr_SetString(PyExc_RuntimeError, (char *) msg ); goto fail; } else

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_a_32__char swig_types[0] 
#define  SWIGTYPE_track swig_types[1] 
#define  SWIGTYPE_tunepimp swig_types[2] 
#define  SWIGTYPE_p_short swig_types[3] 
#define  SWIGTYPE_p_albumtrackresult swig_types[4] 
#define  SWIGTYPE_p_albumresult swig_types[5] 
#define  SWIGTYPE_p_artistresult swig_types[6] 
#define  SWIGTYPE_p_result swig_types[7] 
#define  SWIGTYPE_p_metadata swig_types[8] 
#define  SWIGTYPE_p_int swig_types[9] 
#define  SWIGTYPE_p_p_int swig_types[10] 
static swig_type_info *swig_types[12];

/* -------- TYPES TABLE (END) -------- */


/*-----------------------------------------------
              @(target):= _tunepimp.so
  ------------------------------------------------*/
#define SWIG_init    init_tunepimp

#define SWIG_name    "_tunepimp"

#include <tunepimp/tp_c.h>     


static PyObject* t_output_helper(PyObject* target, PyObject* o) {
    PyObject*   o2;
    PyObject*   o3;

    if (!target) {                   
        target = o;
    } else if (target == Py_None) {  
        Py_DECREF(Py_None);
        target = o;
    } else {                         
        if (!PyTuple_Check(target)) {
            o2 = target;
            target = PyTuple_New(1);
            PyTuple_SetItem(target, 0, o2);
        }
        o3 = PyTuple_New(1);            
        PyTuple_SetItem(o3, 0, o);      

        o2 = target;
        target = PySequence_Concat(o2, o3); 
        Py_DECREF(o2);                      
        Py_DECREF(o3);
    }
    return target;
}

#ifdef __cplusplus
extern "C" {
#endif
static PyObject *_wrap_metadata_artist_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:metadata_artist_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    {
        if (arg1->artist) free((char*)arg1->artist);
        if (arg2) {
            arg1->artist = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->artist,arg2);
        } else {
            arg1->artist = 0;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_artist_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_artist_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *) ((arg1)->artist);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_sortName_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:metadata_sortName_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    {
        if (arg1->sortName) free((char*)arg1->sortName);
        if (arg2) {
            arg1->sortName = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->sortName,arg2);
        } else {
            arg1->sortName = 0;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_sortName_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_sortName_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *) ((arg1)->sortName);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_album_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:metadata_album_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    {
        if (arg1->album) free((char*)arg1->album);
        if (arg2) {
            arg1->album = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->album,arg2);
        } else {
            arg1->album = 0;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_album_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_album_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *) ((arg1)->album);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_track_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:metadata_track_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    {
        if (arg1->track) free((char*)arg1->track);
        if (arg2) {
            arg1->track = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->track,arg2);
        } else {
            arg1->track = 0;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_track_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_track_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *) ((arg1)->track);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_trackNum_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:metadata_trackNum_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if (arg1) (arg1)->trackNum = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_trackNum_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_trackNum_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int) ((arg1)->trackNum);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_variousArtist_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:metadata_variousArtist_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if (arg1) (arg1)->variousArtist = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_variousArtist_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_variousArtist_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int) ((arg1)->variousArtist);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_artistId_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:metadata_artistId_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    {
        if (arg1->artistId) free((char*)arg1->artistId);
        if (arg2) {
            arg1->artistId = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->artistId,arg2);
        } else {
            arg1->artistId = 0;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_artistId_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_artistId_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *) ((arg1)->artistId);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_albumId_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:metadata_albumId_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    {
        if (arg1->albumId) free((char*)arg1->albumId);
        if (arg2) {
            arg1->albumId = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->albumId,arg2);
        } else {
            arg1->albumId = 0;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_albumId_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_albumId_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *) ((arg1)->albumId);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_trackId_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:metadata_trackId_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    {
        if (arg1->trackId) free((char*)arg1->trackId);
        if (arg2) {
            arg1->trackId = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->trackId,arg2);
        } else {
            arg1->trackId = 0;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_trackId_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_trackId_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *) ((arg1)->trackId);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_fileTrm_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:metadata_fileTrm_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    {
        if (arg1->fileTrm) free((char*)arg1->fileTrm);
        if (arg2) {
            arg1->fileTrm = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->fileTrm,arg2);
        } else {
            arg1->fileTrm = 0;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_fileTrm_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_fileTrm_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *) ((arg1)->fileTrm);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_albumArtistId_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:metadata_albumArtistId_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    {
        if (arg1->albumArtistId) free((char*)arg1->albumArtistId);
        if (arg2) {
            arg1->albumArtistId = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->albumArtistId,arg2);
        } else {
            arg1->albumArtistId = 0;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_albumArtistId_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_albumArtistId_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *) ((arg1)->albumArtistId);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_duration_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    unsigned long arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:metadata_duration_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    arg2 = (unsigned long) PyInt_AsLong(obj1);
    if (PyErr_Occurred()) SWIG_fail;
    if (arg1) (arg1)->duration = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_duration_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    unsigned long result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_duration_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (unsigned long) ((arg1)->duration);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_albumType_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:metadata_albumType_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if (arg1) (arg1)->albumType = (TPAlbumType)arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_albumType_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_albumType_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    resultobj = PyInt_FromLong((long)(arg1)->albumType);
    return resultobj;
    fail:
    return NULL;
}

static PyObject *_wrap_metadata_albumStatus_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:metadata_albumStatus_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if (arg1) (arg1)->albumStatus = (TPAlbumStatus)arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_albumStatus_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_albumStatus_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    resultobj = PyInt_FromLong((long)(arg1)->albumStatus);
    return resultobj;
    fail:
    return NULL;
}

static PyObject *_wrap_metadata_releaseYear_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:metadata_releaseYear_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if (arg1) (arg1)->releaseYear = (int)arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_releaseYear_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_releaseYear_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    resultobj = PyInt_FromLong((long)(arg1)->releaseYear);
    return resultobj;
    fail:
    return NULL;
}

static PyObject *_wrap_metadata_releaseMonth_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:metadata_releaseMonth_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if (arg1) (arg1)->releaseMonth = (int)arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_releaseMonth_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_releaseMonth_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    resultobj = PyInt_FromLong((long)(arg1)->releaseMonth);
    return resultobj;
    fail:
    return NULL;
}

static PyObject *_wrap_metadata_releaseDay_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:metadata_releaseDay_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if (arg1) (arg1)->releaseDay = (int)arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_releaseDay_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_releaseDay_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    resultobj = PyInt_FromLong((long)(arg1)->releaseDay);
    return resultobj;
    fail:
    return NULL;
}

static PyObject *_wrap_metadata_releaseCountry_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:metadata_releaseCountry_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    {
        if (arg2) {
            strcpy((char*)arg1->releaseCountry,arg2);
        } else {
            arg1->releaseCountry[0] = 0;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}

static PyObject *_wrap_metadata_releaseCountry_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_releaseCountry_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *) ((arg1)->releaseCountry);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}

static PyObject *_wrap_metadata_fileFormat_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:metadata_fileFormat_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    {
        if (arg1->fileFormat) free((char*)arg1->fileFormat);
        if (arg2) {
            arg1->fileFormat = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->fileFormat,arg2);
        } else {
            arg1->fileFormat = 0;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_fileFormat_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_fileFormat_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *) ((arg1)->fileFormat);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_numTRMIds_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:metadata_numTRMIds_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if (arg1) (arg1)->numTRMIds = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_metadata_numTRMIds_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:metadata_numTRMIds_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int) ((arg1)->numTRMIds);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_metadata(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_metadata")) goto fail;
    result = (metadata_t *)calloc(1, sizeof(metadata_t));
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_metadata, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_metadata(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_metadata",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    free((char *) arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * metadata_swigregister(PyObject *self, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_metadata, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_artistresult_relevance_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    artistresult_t *arg1 = (artistresult_t *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:artistresult_relevance_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_artistresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if (arg1) (arg1)->relevance = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_artistresult_relevance_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    artistresult_t *arg1 = (artistresult_t *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:artistresult_relevance_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_artistresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int) ((arg1)->relevance);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_artistresult_name_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    artistresult_t *arg1 = (artistresult_t *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:artistresult_name_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_artistresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    {
        if (arg1->name) free((char*)arg1->name);
        if (arg2) {
            arg1->name = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->name,arg2);
        } else {
            arg1->name = 0;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_artistresult_name_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    artistresult_t *arg1 = (artistresult_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:artistresult_name_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_artistresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *) ((arg1)->name);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_artistresult_sortName_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    artistresult_t *arg1 = (artistresult_t *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:artistresult_sortName_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_artistresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    {
        if (arg1->sortName) free((char*)arg1->sortName);
        if (arg2) {
            arg1->sortName = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->sortName,arg2);
        } else {
            arg1->sortName = 0;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_artistresult_sortName_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    artistresult_t *arg1 = (artistresult_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:artistresult_sortName_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_artistresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *) ((arg1)->sortName);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_artistresult_id_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    artistresult_t *arg1 = (artistresult_t *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:artistresult_id_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_artistresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    {
        if (arg1->id) free((char*)arg1->id);
        if (arg2) {
            arg1->id = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->id,arg2);
        } else {
            arg1->id = 0;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_artistresult_id_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    artistresult_t *arg1 = (artistresult_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:artistresult_id_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_artistresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *) ((arg1)->id);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_artistresult(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    artistresult_t *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_artistresult")) goto fail;
    result = (artistresult_t *) calloc(1, sizeof(artistresult_t));
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_artistresult, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_artistresult(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    artistresult_t *arg1 = (artistresult_t *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_artistresult",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_artistresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    free((char *) arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * artistresult_swigregister(PyObject *self, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_artistresult, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_albumresult_relevance_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:albumresult_relevance_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if (arg1) (arg1)->relevance = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumresult_relevance_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:albumresult_relevance_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int) ((arg1)->relevance);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumresult_name_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:albumresult_name_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    {
        if (arg1->name) free((char*)arg1->name);
        if (arg2) {
            arg1->name = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->name,arg2);
        } else {
            arg1->name = 0;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumresult_name_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:albumresult_name_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *) ((arg1)->name);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumresult_id_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:albumresult_id_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    {
        if (arg1->id) free((char*)arg1->id);
        if (arg2) {
            arg1->id = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->id,arg2);
        } else {
            arg1->id = 0;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumresult_id_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:albumresult_id_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *) ((arg1)->id);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumresult_numTracks_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:albumresult_numTracks_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if (arg1) (arg1)->numTracks = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumresult_numTracks_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:albumresult_numTracks_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int) ((arg1)->numTracks);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumresult_numCDIndexIds_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:albumresult_numCDIndexIds_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if (arg1) (arg1)->numCDIndexIds = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumresult_numCDIndexIds_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:albumresult_numCDIndexIds_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int) ((arg1)->numCDIndexIds);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumresult_isVA_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:albumresult_isVA_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if (arg1) (arg1)->isVA = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumresult_isVA_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:albumresult_isVA_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int) ((arg1)->isVA);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumresult_status_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    PyObject * obj0 = 0 ;
    int arg2;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:albumresult_status_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if (arg1) (arg1)->status = (TPAlbumStatus)arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumresult_status_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:albumresult_status_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;

    resultobj = PyInt_FromLong((long)(arg1)->status);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumresult_type_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:albumresult_type_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if (arg1) (arg1)->type = (TPAlbumType)arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumresult_type_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:albumresult_type_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;

    resultobj = PyInt_FromLong((long)arg1->type);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumresult_artist_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    artistresult_t *arg2 = (artistresult_t *) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:albumresult_artist_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_artistresult,SWIG_POINTER_EXCEPTION | SWIG_POINTER_DISOWN )) == -1) SWIG_fail;
    if (arg1) (arg1)->artist = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumresult_artist_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    artistresult_t *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:albumresult_artist_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (artistresult_t *) ((arg1)->artist);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_artistresult, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_albumresult(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_albumresult")) goto fail;
    result = (albumresult_t *) calloc(1, sizeof(albumresult_t));
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_albumresult, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_albumresult(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumresult_t *arg1 = (albumresult_t *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_albumresult",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    free((char *) arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * albumresult_swigregister(PyObject *self, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_albumresult, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_albumtrackresult_relevance_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumtrackresult_t *arg1 = (albumtrackresult_t *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:albumtrackresult_relevance_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumtrackresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if (arg1) (arg1)->relevance = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumtrackresult_relevance_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumtrackresult_t *arg1 = (albumtrackresult_t *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:albumtrackresult_relevance_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumtrackresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int) ((arg1)->relevance);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumtrackresult_name_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumtrackresult_t *arg1 = (albumtrackresult_t *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:albumtrackresult_name_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumtrackresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    {
        if (arg1->name) free((char*)arg1->name);
        if (arg2) {
            arg1->name = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->name,arg2);
        } else {
            arg1->name = 0;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumtrackresult_name_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumtrackresult_t *arg1 = (albumtrackresult_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:albumtrackresult_name_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumtrackresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *) ((arg1)->name);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumtrackresult_id_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumtrackresult_t *arg1 = (albumtrackresult_t *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:albumtrackresult_id_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumtrackresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    {
        if (arg1->id) free((char*)arg1->id);
        if (arg2) {
            arg1->id = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->id,arg2);
        } else {
            arg1->id = 0;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumtrackresult_id_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumtrackresult_t *arg1 = (albumtrackresult_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:albumtrackresult_id_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumtrackresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (char *) ((arg1)->id);
    
    resultobj = result ? PyString_FromString(result) : Py_BuildValue((char*)"");
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumtrackresult_numTRMIds_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumtrackresult_t *arg1 = (albumtrackresult_t *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:albumtrackresult_numTRMIds_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumtrackresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if (arg1) (arg1)->numTRMIds = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumtrackresult_numTRMIds_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumtrackresult_t *arg1 = (albumtrackresult_t *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:albumtrackresult_numTRMIds_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumtrackresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int) ((arg1)->numTRMIds);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumtrackresult_trackNum_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumtrackresult_t *arg1 = (albumtrackresult_t *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:albumtrackresult_trackNum_set",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumtrackresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if (arg1) (arg1)->trackNum = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumtrackresult_trackNum_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumtrackresult_t *arg1 = (albumtrackresult_t *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:albumtrackresult_trackNum_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumtrackresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int) ((arg1)->trackNum);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumtrackresult_duration_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumtrackresult_t *arg1 = (albumtrackresult_t *) 0 ;
    unsigned long arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:albumtrackresult_duration_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumtrackresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    arg2 = (unsigned long) PyInt_AsLong(obj1);
    if (PyErr_Occurred()) SWIG_fail;
    if (arg1) (arg1)->duration = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumtrackresult_duration_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumtrackresult_t *arg1 = (albumtrackresult_t *) 0 ;
    unsigned long result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:albumtrackresult_duration_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumtrackresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (unsigned long) ((arg1)->duration);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumtrackresult_artist_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumtrackresult_t *arg1 = (albumtrackresult_t *) 0 ;
    artistresult_t *arg2 = (artistresult_t *) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:albumtrackresult_artist_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumtrackresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_artistresult,SWIG_POINTER_EXCEPTION | SWIG_POINTER_DISOWN )) == -1) SWIG_fail;
    if (arg1) (arg1)->artist = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumtrackresult_artist_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumtrackresult_t *arg1 = (albumtrackresult_t *) 0 ;
    artistresult_t *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:albumtrackresult_artist_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumtrackresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (artistresult_t *) ((arg1)->artist);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_artistresult, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumtrackresult_album_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumtrackresult_t *arg1 = (albumtrackresult_t *) 0 ;
    albumresult_t *arg2 = (albumresult_t *) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:albumtrackresult_album_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumtrackresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_albumresult,SWIG_POINTER_EXCEPTION | SWIG_POINTER_DISOWN )) == -1) SWIG_fail;
    if (arg1) (arg1)->album = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_albumtrackresult_album_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumtrackresult_t *arg1 = (albumtrackresult_t *) 0 ;
    albumresult_t *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:albumtrackresult_album_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumtrackresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (albumresult_t *) ((arg1)->album);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_albumresult, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_albumtrackresult(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumtrackresult_t *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_albumtrackresult")) goto fail;
    result = (albumtrackresult_t *)calloc(1, sizeof(albumtrackresult_t));
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_albumtrackresult, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_albumtrackresult(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    albumtrackresult_t *arg1 = (albumtrackresult_t *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_albumtrackresult",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_albumtrackresult,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    free((char *) arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * albumtrackresult_swigregister(PyObject *self, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_albumtrackresult, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}

static PyObject *_wrap_tp_New(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    char *arg2 ;
    int  arg3;
    tunepimp_t result;
    
    if(!PyArg_ParseTuple(args,(char *)"ssi:tp_New",&arg1,&arg2,&arg3)) goto fail;
    result = (tunepimp_t)tp_NewWithArgs((char const *)arg1,(char const *)arg2, arg3);

    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_tunepimp, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_Delete(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_Delete",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_Delete(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetVersion(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int *arg2 = (int *) 0 ;
    int *arg3 = (int *) 0 ;
    int *arg4 = (int *) 0 ;
    int temp2 ;
    int temp3 ;
    int temp4 ;
    PyObject * obj0 = 0 ;
    
    arg2 = &temp2;
    arg3 = &temp3;
    arg4 = &temp4;
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetVersion",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_GetVersion(arg1,arg2,arg3,arg4);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    {
        PyObject *o = PyInt_FromLong((long) (*arg2));
        resultobj = t_output_helper(resultobj,o);
    }
    {
        PyObject *o = PyInt_FromLong((long) (*arg3));
        resultobj = t_output_helper(resultobj,o);
    }
    {
        PyObject *o = PyInt_FromLong((long) (*arg4));
        resultobj = t_output_helper(resultobj,o);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetUserInfo(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    char *arg2 ;
    char *arg3 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oss:tp_SetUserInfo",&obj0,&arg2,&arg3)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetUserInfo(arg1,(char const *)arg2,(char const *)arg3);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}

const int tempSize = 255;

static PyObject *_wrap_tp_GetUserInfo(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    PyObject * obj0 = 0 ;
    char *user = malloc(tempSize);
    char *passwd = malloc(tempSize);
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetUserInfo",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;

    tp_GetUserInfo(arg1, user, tempSize, passwd, tempSize);
    
    resultobj = Py_BuildValue("ss", user, passwd);
    Py_INCREF(resultobj); 
    free(user);
    free(passwd);

    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetUseUTF8(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tp_SetUseUTF8",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetUseUTF8(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetUseUTF8(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetUseUTF8",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tp_GetUseUTF8(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetServer(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    char *arg2 ;
    short arg3 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Osh:tp_SetServer",&obj0,&arg2,&arg3)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetServer(arg1,(char const *)arg2,arg3);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetServer(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    PyObject * obj0 = 0 ;
    char *server = malloc(tempSize);
    short port;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetServer",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_GetServer(arg1,server, tempSize, &port);

    resultobj = Py_BuildValue("si", server, port);
    Py_INCREF(resultobj); 
    free(server);

    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetProxy(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    char *arg2 ;
    short arg3 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Osh:tp_SetProxy",&obj0,&arg2,&arg3)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetProxy(arg1,(char const *)arg2,arg3);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetProxy(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    PyObject * obj0 = 0 ;
    char *server = malloc(tempSize);
    short port;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetProxy",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_GetProxy(arg1,server, tempSize, &port);

    resultobj = Py_BuildValue("si", server, port);
    Py_INCREF(resultobj); 
    free(server);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetNumSupportedExtensions(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetNumSupportedExtensions",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tp_GetNumSupportedExtensions(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetSupportedExtensions(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    PyObject * obj0 = 0 ;
    char  ext[32][32];
    int num, i;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetSupportedExtensions",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;

    num = tp_GetNumSupportedExtensions(arg1);
    tp_GetSupportedExtensions(arg1,(char (*)[32])ext);
    
    resultobj = PyTuple_New(num);
    for(i = 0; i < num; i++)
        PyTuple_SetItem(resultobj, i, Py_BuildValue("s", ext[i]));

    Py_INCREF(resultobj); 
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetAnalyzerPriority(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    PyObject * obj0 = 0 ;
    int arg2;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tp_SetAnalyzerPriority",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;

    tp_SetAnalyzerPriority(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetAnalyzerPriority(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetAnalyzerPriority",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;

    resultobj = PyInt_FromLong((long)tp_GetAnalyzerPriority(arg1));
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetAutoFileLookup(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tp_SetAutoFileLookup",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetAutoFileLookup(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetAutoFileLookup(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetAutoFileLookup",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tp_GetAutoFileLookup(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}

static PyObject *_wrap_tp_GetNotification(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    TPCallbackEnum type;
    int fileId;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetNotification",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;

    result = (int)tp_GetNotification(arg1,&type,&fileId);
    
    resultobj = Py_BuildValue("iii", (long)result, (int)type, fileId);
    Py_INCREF(resultobj); 

    return resultobj;
    fail:
    return NULL;
}

const int messageLen = 1024;

static PyObject *_wrap_tp_GetStatus(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    char *status = malloc(messageLen);
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetStatus",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;

    result = (int)tp_GetStatus(arg1,status,messageLen);
    
    resultobj = Py_BuildValue("ls", (long)result, status);
    free(status);
    Py_INCREF(resultobj); 
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetError(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    PyObject * obj0 = 0 ;
    char *err = malloc(messageLen);
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetError",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;

    tp_GetError(arg1,err,messageLen);
    resultobj = Py_BuildValue("s", err);
    free(err);
    Py_INCREF(resultobj); 
    return resultobj;
    
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetDebug(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tp_SetDebug",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetDebug(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetDebug(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetDebug",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tp_GetDebug(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_AddFile(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    char *arg2 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:tp_AddFile",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tp_AddFile(arg1,(char const *)arg2);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_AddDir(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    char *arg2 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:tp_AddDir",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tp_AddDir(arg1,(char const *)arg2);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_Remove(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tp_Remove",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_Remove(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetNumFiles(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetNumFiles",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tp_GetNumFiles(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetNumUnsubmitted(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetNumUnsubmitted",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tp_GetNumUnsubmitted(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetNumUnsavedItems(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetNumUnsavedItems",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tp_GetNumUnsavedItems(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetTrackCounts(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    int i, counts[10];
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetTrackCounts",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;

    result = (int)tp_GetTrackCounts(arg1,counts,10);
    
    resultobj = PyTuple_New(result);
    for(i = 0; i < result; i++)
        PyTuple_SetItem(resultobj, i, Py_BuildValue("i", counts[i]));

    Py_INCREF(resultobj); 
    return resultobj;
    fail:
    return NULL;
}

/* TODO: returns a list with an extra comma. Hmmm. */
static PyObject *_wrap_tp_GetFileIds(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    PyObject * obj0 = 0 ;
    int i, *counts, result;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetFileIds",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;

    result = tp_GetNumFileIds(arg1);
    counts = malloc(sizeof(int) * result);
    tp_GetFileIds(arg1,counts,result);
    resultobj = PyTuple_New(result);
    for(i = 0; i < result; i++)
        PyTuple_SetItem(resultobj, i, Py_BuildValue("i", counts[i]));

    Py_INCREF(resultobj); 
    free(counts);
    return resultobj;
    
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetTrack(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int arg2 ;
    track_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tp_GetTrack",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (track_t)tp_GetTrack(arg1,arg2);
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_track, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_ReleaseTrack(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    track_t arg2 = (track_t) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:tp_ReleaseTrack",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_ReleaseTrack(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_Wake(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    track_t arg2 = (track_t) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:tp_Wake",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_Wake(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SelectResult(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    track_t arg2 = (track_t) 0 ;
    int arg3 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOi:tp_SelectResult",&obj0,&obj1,&arg3)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    
    resultobj = PyInt_FromLong((long)tp_SelectResult(arg1,arg2,arg3));
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_Misidentified(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tp_Misidentified",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_Misidentified(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_IdentifyAgain(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tp_IdentifyAgain",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_IdentifyAgain(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_WriteTags(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    PyObject * arg2 = 0 ;
    int result;
    PyObject * obj0 = 0 ;
    int *fileIds = NULL, num, i;
   
    if(!PyArg_ParseTuple(args,(char *)"OO:tp_WriteTags",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;

    num = PyTuple_Size(arg2);
    if (num)
    {
        fileIds = malloc(sizeof(int) * num);

        for(i = 0; i < num; i++)
            fileIds[i] = PyInt_AsLong(PyTuple_GetItem(arg2, i));
    }

    result = (int)tp_WriteTags(arg1,fileIds, num);
    
    resultobj = PyInt_FromLong((long)result);
    if (fileIds)
        free(fileIds);

    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_AddTRMSubmission(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    char *arg2 ;
    char *arg3 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oss:tp_AddTRMSubmission",&obj0,&arg2,&arg3)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_AddTRMSubmission(arg1,(char const *)arg2,(char const *)arg3);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SubmitTRMs(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_SubmitTRMs",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    
    resultobj = PyInt_FromLong((long)tp_SubmitTRMs(arg1));
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetRenameFiles(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tp_SetRenameFiles",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetRenameFiles(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetRenameFiles(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetRenameFiles",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tp_GetRenameFiles(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetMoveFiles(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tp_SetMoveFiles",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetMoveFiles(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetMoveFiles(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetMoveFiles",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tp_GetMoveFiles(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetWriteID3v1(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tp_SetWriteID3v1",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetWriteID3v1(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetWriteID3v1(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetWriteID3v1",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tp_GetWriteID3v1(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetClearTags(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tp_SetClearTags",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetClearTags(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetClearTags(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetClearTags",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tp_GetClearTags(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetFileMask(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:tp_SetFileMask",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetFileMask(arg1,(char const *)arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetFileMask(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    PyObject * obj0 = 0 ;
    char *temp = malloc(tempSize);

    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetFileMask",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;

    tp_GetFileMask(arg1,temp,tempSize);
   
    resultobj = Py_BuildValue("s", temp);
    Py_INCREF(resultobj); 
    free(temp);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetVariousFileMask(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:tp_SetVariousFileMask",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetVariousFileMask(arg1,(char const *)arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetVariousFileMask(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    PyObject * obj0 = 0 ;
    char *temp = malloc(tempSize);
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetVariousFileMask",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_GetVariousFileMask(arg1,temp,tempSize);
   
    resultobj = Py_BuildValue("s", temp);
    Py_INCREF(resultobj); 
    free(temp);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetAllowedFileCharacters(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:tp_SetAllowedFileCharacters",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetAllowedFileCharacters(arg1,(char const *)arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetAllowedFileCharacters(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    PyObject * obj0 = 0 ;
    char *temp = malloc(tempSize);
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetAllowedFileCharacters",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_GetAllowedFileCharacters(arg1,temp,tempSize);

    resultobj = Py_BuildValue("s", temp);
    Py_INCREF(resultobj); 
    free(temp);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetDestDir(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:tp_SetDestDir",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetDestDir(arg1,(char const *)arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetDestDir(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    PyObject * obj0 = 0 ;
    char *temp = malloc(tempSize);
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetDestDir",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_GetDestDir(arg1,temp,tempSize);
    
    resultobj = Py_BuildValue("s", temp);
    Py_INCREF(resultobj); 
    free(temp);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetTopSrcDir(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Os:tp_SetTopSrcDir",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetTopSrcDir(arg1,(char const *)arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetTopSrcDir(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    PyObject * obj0 = 0 ;
    char *temp = malloc(tempSize);
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetTopSrcDir",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_GetTopSrcDir(arg1,temp,tempSize);
    
    resultobj = Py_BuildValue("s", temp);
    Py_INCREF(resultobj); 
    free(temp);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetTRMCollisionThreshold(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tp_SetTRMCollisionThreshold",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetTRMCollisionThreshold(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetTRMCollisionThreshold(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetTRMCollisionThreshold",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tp_GetTRMCollisionThreshold(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetMinTRMThreshold(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tp_SetMinTRMThreshold",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetMinTRMThreshold(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetMinTRMThreshold(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetMinTRMThreshold",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tp_GetMinTRMThreshold(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetAutoSaveThreshold(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tp_SetAutoSaveThreshold",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetAutoSaveThreshold(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetAutoSaveThreshold(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetAutoSaveThreshold",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tp_GetAutoSaveThreshold(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetMaxFileNameLen(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tp_SetMaxFileNameLen",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetMaxFileNameLen(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetMaxFileNameLen(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetMaxFileNameLen",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tp_GetMaxFileNameLen(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_SetAutoRemovedSavedFiles(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tp_SetAutoRemovedSavedFiles",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tp_SetAutoRemovedSavedFiles(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetAutoRemovedSavedFiles(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tp_GetAutoRemovedSavedFiles",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tp_GetAutoRemovedSavedFiles(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tp_GetRecognizedFileList(PyObject *self, PyObject *args) {
    PyObject *resultobj, *list;
    tunepimp_t arg1 = (tunepimp_t) 0 ;
    int arg2 ;
    int result, i;
    PyObject * obj0 = 0 ;
    int num; 
    int *fileIds = NULL;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tp_GetRecognizedFileList",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;

    result = (int)tp_GetRecognizedFileList(arg1,arg2,&fileIds,&num);
    list = PyTuple_New(num);

    if (num > 0)
    {
        for(i = 0; i < num; i++)
            PyTuple_SetItem(list, i, Py_BuildValue("i", fileIds[i]));

        tp_DeleteRecognizedFileList(arg1,fileIds);
    }
    resultobj = Py_BuildValue("iO", result, list);
    Py_INCREF(resultobj); 

    return resultobj;
    fail:
    return NULL;
}

static PyObject *_wrap_tr_GetStatus(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    track_t arg1 = (track_t) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tr_GetStatus",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    
    resultobj = PyInt_FromLong((long)tr_GetStatus(arg1));
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tr_SetStatus(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    track_t arg1 = (track_t) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"Oi:tr_SetStatus",&obj0,&arg2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tr_SetStatus(arg1,(TPFileStatus)arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tr_GetFileName(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    track_t arg1 = (track_t) 0 ;
    PyObject * obj0 = 0 ;
    char *fileName = malloc(tempSize);
    
    if(!PyArg_ParseTuple(args,(char *)"O:tr_GetFileName",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tr_GetFileName(arg1,fileName,tempSize);
   
    resultobj = Py_BuildValue("s", fileName);
    Py_INCREF(resultobj); 
    free(fileName);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tr_GetTRM(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    track_t arg1 = (track_t) 0 ;
    PyObject * obj0 = 0 ;
    char *trm = malloc(tempSize);
    
    if(!PyArg_ParseTuple(args,(char *)"O:tr_GetTRM",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tr_GetTRM(arg1,trm,tempSize);
    
    resultobj = Py_BuildValue("s",trm);
    Py_INCREF(resultobj); 
    free(trm);
    return resultobj;
    fail:
    return NULL;
}

static PyObject *_wrap_tr_GetLocalMetadata(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    track_t arg1 = (track_t) 0 ;
    metadata_t *arg2 = (metadata_t *) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;

    if(!PyArg_ParseTuple(args,(char *)"OO:tr_GetLocalMetadata",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tr_GetLocalMetadata(arg1,arg2);

    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}

static PyObject *_wrap_tr_SetLocalMetadata(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    track_t arg1 = (track_t) 0 ;
    metadata_t *arg2 = (metadata_t *) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:tr_SetLocalMetadata",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tr_SetLocalMetadata(arg1,(metadata_t const *)arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tr_GetServerMetadata(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    track_t arg1 = (track_t) 0 ;
    metadata_t *arg2 = (metadata_t *) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:tr_GetServerMetadata",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tr_GetServerMetadata(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tr_SetServerMetadata(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    track_t arg1 = (track_t) 0 ;
    metadata_t *arg2 = (metadata_t *) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:tr_SetServerMetadata",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **) &arg2, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tr_SetServerMetadata(arg1,(metadata_t const *)arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tr_GetError(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    track_t arg1 = (track_t) 0 ;
    PyObject * obj0 = 0 ;
    char *err = malloc(tempSize);
    
    if(!PyArg_ParseTuple(args,(char *)"O:tr_GetError",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tr_GetError(arg1,err,tempSize);
    
    resultobj = Py_BuildValue("s", err);
    Py_INCREF(resultobj); 
    free(err);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tr_GetSimilarity(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    track_t arg1 = (track_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tr_GetSimilarity",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tr_GetSimilarity(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tr_HasChanged(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    track_t arg1 = (track_t) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tr_HasChanged",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    result = (int)tr_HasChanged(arg1);
    
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
    fail:
    return NULL;
}

static PyObject *_wrap_tr_GetResults(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    track_t arg1 = (track_t) 0 ;
    result_t *results = (result_t *) 0 ;
    PyObject * list = 0 ;
    PyObject * obj0 = 0 ;
    int num = 0, i;
    TPResultType type;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tr_GetResults",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;

    num = tr_GetNumResults(arg1);
    results = malloc(sizeof(result_t *) * num);
    tr_GetResults(arg1,&type,results,&num);

    list = PyTuple_New(num);
    if (num > 0)
    {
        for(i = 0; i < num; i++)
            switch(type)
            {
                case eArtistList:
                    PyTuple_SetItem(list, i, SWIG_NewPointerObj((void *)results[i], SWIGTYPE_p_artistresult, 0));
                    break;
                case eAlbumList:
                    PyTuple_SetItem(list, i, SWIG_NewPointerObj((void *)results[i], SWIGTYPE_p_albumresult, 0));
                    break;
                case eTrackList:
                    PyTuple_SetItem(list, i, SWIG_NewPointerObj((void *)results[i], SWIGTYPE_p_albumtrackresult, 0));
                    break;
               case eMatchedTrack:
                    // TODO Handle this case
                    break;
               case eNone:
                    // TODO Handle this case
                    break;
            }
    }
    rs_Delete(type, results, num);
    free(results);

    resultobj = Py_BuildValue("iO", (int)type, list);
    Py_INCREF(resultobj); 
    
    return resultobj;
    fail:
    return NULL;
}

static PyObject *_wrap_tr_Lock(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    track_t arg1 = (track_t) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tr_Lock",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tr_Lock(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_tr_Unlock(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    track_t arg1 = (track_t) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:tr_Unlock",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, 0, SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    tr_Unlock(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_md_New(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *result;
    
    if(!PyArg_ParseTuple(args,(char *)":md_New")) goto fail;
    result = (metadata_t *)md_New();
    
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_metadata, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_md_Delete(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:md_Delete",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    md_Delete(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_md_Clear(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    metadata_t *arg1 = (metadata_t *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:md_Clear",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **) &arg1, SWIGTYPE_p_metadata,SWIG_POINTER_EXCEPTION | 0 )) == -1) SWIG_fail;
    md_Clear(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_md_ConvertToAlbumStatus(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    
    if(!PyArg_ParseTuple(args,(char *)"s:md_ConvertToAlbumStatus",&arg1)) goto fail;
    resultobj = PyInt_FromLong((long)md_ConvertToAlbumStatus((char const *)arg1));
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_md_ConvertToAlbumType(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    
    if(!PyArg_ParseTuple(args,(char *)"s:md_ConvertToAlbumType",&arg1)) goto fail;

    resultobj = PyInt_FromLong((long)md_ConvertToAlbumType((char const *)arg1));
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_md_ConvertFromAlbumStatus(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *text = malloc(tempSize);
    int arg1;
    
    if(!PyArg_ParseTuple(args,(char *)"i:md_ConvertFromAlbumStatus",&arg1)) goto fail;
    md_ConvertFromAlbumStatus(arg1,text,tempSize);
    
    resultobj = Py_BuildValue("s", text);
    Py_INCREF(resultobj); 
    free(text);

    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_md_ConvertFromAlbumType(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    int arg1 ;
    char *text = malloc(tempSize);
    
    if(!PyArg_ParseTuple(args,(char *)"i:md_ConvertFromAlbumType",&arg1)) goto fail;
    md_ConvertFromAlbumType(arg1,text,tempSize);
    
    resultobj = Py_BuildValue("s", text);
    Py_INCREF(resultobj); 
    free(text);

    return resultobj;
    fail:
    return NULL;
}



static PyMethodDef SwigMethods[] = {
	 { (char *)"metadata_artist_set", _wrap_metadata_artist_set, METH_VARARGS },
	 { (char *)"metadata_artist_get", _wrap_metadata_artist_get, METH_VARARGS },
	 { (char *)"metadata_sortName_set", _wrap_metadata_sortName_set, METH_VARARGS },
	 { (char *)"metadata_sortName_get", _wrap_metadata_sortName_get, METH_VARARGS },
	 { (char *)"metadata_album_set", _wrap_metadata_album_set, METH_VARARGS },
	 { (char *)"metadata_album_get", _wrap_metadata_album_get, METH_VARARGS },
	 { (char *)"metadata_track_set", _wrap_metadata_track_set, METH_VARARGS },
	 { (char *)"metadata_track_get", _wrap_metadata_track_get, METH_VARARGS },
	 { (char *)"metadata_trackNum_set", _wrap_metadata_trackNum_set, METH_VARARGS },
	 { (char *)"metadata_trackNum_get", _wrap_metadata_trackNum_get, METH_VARARGS },
	 { (char *)"metadata_variousArtist_set", _wrap_metadata_variousArtist_set, METH_VARARGS },
	 { (char *)"metadata_variousArtist_get", _wrap_metadata_variousArtist_get, METH_VARARGS },
	 { (char *)"metadata_artistId_set", _wrap_metadata_artistId_set, METH_VARARGS },
	 { (char *)"metadata_artistId_get", _wrap_metadata_artistId_get, METH_VARARGS },
	 { (char *)"metadata_albumId_set", _wrap_metadata_albumId_set, METH_VARARGS },
	 { (char *)"metadata_albumId_get", _wrap_metadata_albumId_get, METH_VARARGS },
	 { (char *)"metadata_trackId_set", _wrap_metadata_trackId_set, METH_VARARGS },
	 { (char *)"metadata_trackId_get", _wrap_metadata_trackId_get, METH_VARARGS },
	 { (char *)"metadata_albumArtistId_set", _wrap_metadata_albumArtistId_set, METH_VARARGS },
	 { (char *)"metadata_albumArtistId_get", _wrap_metadata_albumArtistId_get, METH_VARARGS },
	 { (char *)"metadata_fileTrm_set", _wrap_metadata_fileTrm_set, METH_VARARGS },
	 { (char *)"metadata_fileTrm_get", _wrap_metadata_fileTrm_get, METH_VARARGS },
	 { (char *)"metadata_duration_set", _wrap_metadata_duration_set, METH_VARARGS },
	 { (char *)"metadata_duration_get", _wrap_metadata_duration_get, METH_VARARGS },
	 { (char *)"metadata_albumType_set", _wrap_metadata_albumType_set, METH_VARARGS },
	 { (char *)"metadata_albumType_get", _wrap_metadata_albumType_get, METH_VARARGS },
	 { (char *)"metadata_albumType_set", _wrap_metadata_albumStatus_set, METH_VARARGS },
	 { (char *)"metadata_albumType_get", _wrap_metadata_albumStatus_get, METH_VARARGS },
	 { (char *)"metadata_releaseYear_set", _wrap_metadata_releaseYear_set, METH_VARARGS },
	 { (char *)"metadata_releaseYear_get", _wrap_metadata_releaseYear_get, METH_VARARGS },
	 { (char *)"metadata_releaseMonth_set", _wrap_metadata_releaseMonth_set, METH_VARARGS },
	 { (char *)"metadata_releaseMonth_get", _wrap_metadata_releaseMonth_get, METH_VARARGS },
	 { (char *)"metadata_releaseDay_set", _wrap_metadata_releaseDay_set, METH_VARARGS },
	 { (char *)"metadata_releaseDay_get", _wrap_metadata_releaseDay_get, METH_VARARGS },
	 { (char *)"metadata_releaseCountry_set", _wrap_metadata_releaseCountry_set, METH_VARARGS },
	 { (char *)"metadata_releaseCountry_get", _wrap_metadata_releaseCountry_get, METH_VARARGS },
	 { (char *)"metadata_fileFormat_set", _wrap_metadata_fileFormat_set, METH_VARARGS },
	 { (char *)"metadata_fileFormat_get", _wrap_metadata_fileFormat_get, METH_VARARGS },
	 { (char *)"metadata_numTRMIds_set", _wrap_metadata_numTRMIds_set, METH_VARARGS },
	 { (char *)"metadata_numTRMIds_get", _wrap_metadata_numTRMIds_get, METH_VARARGS },
	 { (char *)"new_metadata", _wrap_new_metadata, METH_VARARGS },
	 { (char *)"delete_metadata", _wrap_delete_metadata, METH_VARARGS },
	 { (char *)"metadata_swigregister", metadata_swigregister, METH_VARARGS },
	 { (char *)"artistresult_relevance_set", _wrap_artistresult_relevance_set, METH_VARARGS },
	 { (char *)"artistresult_relevance_get", _wrap_artistresult_relevance_get, METH_VARARGS },
	 { (char *)"artistresult_name_set", _wrap_artistresult_name_set, METH_VARARGS },
	 { (char *)"artistresult_name_get", _wrap_artistresult_name_get, METH_VARARGS },
	 { (char *)"artistresult_sortName_set", _wrap_artistresult_sortName_set, METH_VARARGS },
	 { (char *)"artistresult_sortName_get", _wrap_artistresult_sortName_get, METH_VARARGS },
	 { (char *)"artistresult_id_set", _wrap_artistresult_id_set, METH_VARARGS },
	 { (char *)"artistresult_id_get", _wrap_artistresult_id_get, METH_VARARGS },
	 { (char *)"new_artistresult", _wrap_new_artistresult, METH_VARARGS },
	 { (char *)"delete_artistresult", _wrap_delete_artistresult, METH_VARARGS },
	 { (char *)"artistresult_swigregister", artistresult_swigregister, METH_VARARGS },
	 { (char *)"albumresult_relevance_set", _wrap_albumresult_relevance_set, METH_VARARGS },
	 { (char *)"albumresult_relevance_get", _wrap_albumresult_relevance_get, METH_VARARGS },
	 { (char *)"albumresult_name_set", _wrap_albumresult_name_set, METH_VARARGS },
	 { (char *)"albumresult_name_get", _wrap_albumresult_name_get, METH_VARARGS },
	 { (char *)"albumresult_id_set", _wrap_albumresult_id_set, METH_VARARGS },
	 { (char *)"albumresult_id_get", _wrap_albumresult_id_get, METH_VARARGS },
	 { (char *)"albumresult_numTracks_set", _wrap_albumresult_numTracks_set, METH_VARARGS },
	 { (char *)"albumresult_numTracks_get", _wrap_albumresult_numTracks_get, METH_VARARGS },
	 { (char *)"albumresult_numCDIndexIds_set", _wrap_albumresult_numCDIndexIds_set, METH_VARARGS },
	 { (char *)"albumresult_numCDIndexIds_get", _wrap_albumresult_numCDIndexIds_get, METH_VARARGS },
	 { (char *)"albumresult_isVA_set", _wrap_albumresult_isVA_set, METH_VARARGS },
	 { (char *)"albumresult_isVA_get", _wrap_albumresult_isVA_get, METH_VARARGS },
	 { (char *)"albumresult_status_set", _wrap_albumresult_status_set, METH_VARARGS },
	 { (char *)"albumresult_status_get", _wrap_albumresult_status_get, METH_VARARGS },
	 { (char *)"albumresult_type_set", _wrap_albumresult_type_set, METH_VARARGS },
	 { (char *)"albumresult_type_get", _wrap_albumresult_type_get, METH_VARARGS },
	 { (char *)"albumresult_artist_set", _wrap_albumresult_artist_set, METH_VARARGS },
	 { (char *)"albumresult_artist_get", _wrap_albumresult_artist_get, METH_VARARGS },
	 { (char *)"new_albumresult", _wrap_new_albumresult, METH_VARARGS },
	 { (char *)"delete_albumresult", _wrap_delete_albumresult, METH_VARARGS },
	 { (char *)"albumresult_swigregister", albumresult_swigregister, METH_VARARGS },
	 { (char *)"albumtrackresult_relevance_set", _wrap_albumtrackresult_relevance_set, METH_VARARGS },
	 { (char *)"albumtrackresult_relevance_get", _wrap_albumtrackresult_relevance_get, METH_VARARGS },
	 { (char *)"albumtrackresult_name_set", _wrap_albumtrackresult_name_set, METH_VARARGS },
	 { (char *)"albumtrackresult_name_get", _wrap_albumtrackresult_name_get, METH_VARARGS },
	 { (char *)"albumtrackresult_id_set", _wrap_albumtrackresult_id_set, METH_VARARGS },
	 { (char *)"albumtrackresult_id_get", _wrap_albumtrackresult_id_get, METH_VARARGS },
	 { (char *)"albumtrackresult_numTRMIds_set", _wrap_albumtrackresult_numTRMIds_set, METH_VARARGS },
	 { (char *)"albumtrackresult_numTRMIds_get", _wrap_albumtrackresult_numTRMIds_get, METH_VARARGS },
	 { (char *)"albumtrackresult_trackNum_set", _wrap_albumtrackresult_trackNum_set, METH_VARARGS },
	 { (char *)"albumtrackresult_trackNum_get", _wrap_albumtrackresult_trackNum_get, METH_VARARGS },
	 { (char *)"albumtrackresult_duration_set", _wrap_albumtrackresult_duration_set, METH_VARARGS },
	 { (char *)"albumtrackresult_duration_get", _wrap_albumtrackresult_duration_get, METH_VARARGS },
	 { (char *)"albumtrackresult_artist_set", _wrap_albumtrackresult_artist_set, METH_VARARGS },
	 { (char *)"albumtrackresult_artist_get", _wrap_albumtrackresult_artist_get, METH_VARARGS },
	 { (char *)"albumtrackresult_album_set", _wrap_albumtrackresult_album_set, METH_VARARGS },
	 { (char *)"albumtrackresult_album_get", _wrap_albumtrackresult_album_get, METH_VARARGS },
	 { (char *)"new_albumtrackresult", _wrap_new_albumtrackresult, METH_VARARGS },
	 { (char *)"delete_albumtrackresult", _wrap_delete_albumtrackresult, METH_VARARGS },
	 { (char *)"albumtrackresult_swigregister", albumtrackresult_swigregister, METH_VARARGS },
	 { (char *)"New", _wrap_tp_New, METH_VARARGS },
	 { (char *)"Delete", _wrap_tp_Delete, METH_VARARGS },
	 { (char *)"GetVersion", _wrap_tp_GetVersion, METH_VARARGS },
	 { (char *)"SetUserInfo", _wrap_tp_SetUserInfo, METH_VARARGS },
	 { (char *)"GetUserInfo", _wrap_tp_GetUserInfo, METH_VARARGS },
	 { (char *)"SetUseUTF8", _wrap_tp_SetUseUTF8, METH_VARARGS },
	 { (char *)"GetUseUTF8", _wrap_tp_GetUseUTF8, METH_VARARGS },
	 { (char *)"SetServer", _wrap_tp_SetServer, METH_VARARGS },
	 { (char *)"GetServer", _wrap_tp_GetServer, METH_VARARGS },
	 { (char *)"SetProxy", _wrap_tp_SetProxy, METH_VARARGS },
	 { (char *)"GetProxy", _wrap_tp_GetProxy, METH_VARARGS },
	 { (char *)"GetNumSupportedExtensions", _wrap_tp_GetNumSupportedExtensions, METH_VARARGS },
	 { (char *)"GetSupportedExtensions", _wrap_tp_GetSupportedExtensions, METH_VARARGS },
	 { (char *)"SetAnalyzerPriority", _wrap_tp_SetAnalyzerPriority, METH_VARARGS },
	 { (char *)"GetAnalyzerPriority", _wrap_tp_GetAnalyzerPriority, METH_VARARGS },
	 { (char *)"SetAutoFileLookup", _wrap_tp_SetAutoFileLookup, METH_VARARGS },
	 { (char *)"GetAutoFileLookup", _wrap_tp_GetAutoFileLookup, METH_VARARGS },
	 { (char *)"GetNotification", _wrap_tp_GetNotification, METH_VARARGS },
	 { (char *)"GetStatus", _wrap_tp_GetStatus, METH_VARARGS },
	 { (char *)"GetError", _wrap_tp_GetError, METH_VARARGS },
	 { (char *)"SetDebug", _wrap_tp_SetDebug, METH_VARARGS },
	 { (char *)"GetDebug", _wrap_tp_GetDebug, METH_VARARGS },
	 { (char *)"AddFile", _wrap_tp_AddFile, METH_VARARGS },
	 { (char *)"AddDir", _wrap_tp_AddDir, METH_VARARGS },
	 { (char *)"Remove", _wrap_tp_Remove, METH_VARARGS },
	 { (char *)"GetNumFiles", _wrap_tp_GetNumFiles, METH_VARARGS },
	 { (char *)"GetNumUnsubmitted", _wrap_tp_GetNumUnsubmitted, METH_VARARGS },
	 { (char *)"GetNumUnsavedItems", _wrap_tp_GetNumUnsavedItems, METH_VARARGS },
	 { (char *)"GetTrackCounts", _wrap_tp_GetTrackCounts, METH_VARARGS },
	 { (char *)"GetFileIds", _wrap_tp_GetFileIds, METH_VARARGS },
	 { (char *)"GetTrack", _wrap_tp_GetTrack, METH_VARARGS },
	 { (char *)"ReleaseTrack", _wrap_tp_ReleaseTrack, METH_VARARGS },
	 { (char *)"Wake", _wrap_tp_Wake, METH_VARARGS },
	 { (char *)"SelectResult", _wrap_tp_SelectResult, METH_VARARGS },
	 { (char *)"Misidentified", _wrap_tp_Misidentified, METH_VARARGS },
	 { (char *)"IdentifyAgain", _wrap_tp_IdentifyAgain, METH_VARARGS },
	 { (char *)"WriteTags", _wrap_tp_WriteTags, METH_VARARGS },
	 { (char *)"AddTRMSubmission", _wrap_tp_AddTRMSubmission, METH_VARARGS },
	 { (char *)"SubmitTRMs", _wrap_tp_SubmitTRMs, METH_VARARGS },
	 { (char *)"SetRenameFiles", _wrap_tp_SetRenameFiles, METH_VARARGS },
	 { (char *)"GetRenameFiles", _wrap_tp_GetRenameFiles, METH_VARARGS },
	 { (char *)"SetMoveFiles", _wrap_tp_SetMoveFiles, METH_VARARGS },
	 { (char *)"GetMoveFiles", _wrap_tp_GetMoveFiles, METH_VARARGS },
	 { (char *)"SetWriteID3v1", _wrap_tp_SetWriteID3v1, METH_VARARGS },
	 { (char *)"GetWriteID3v1", _wrap_tp_GetWriteID3v1, METH_VARARGS },
	 { (char *)"SetClearTags", _wrap_tp_SetClearTags, METH_VARARGS },
	 { (char *)"GetClearTags", _wrap_tp_GetClearTags, METH_VARARGS },
	 { (char *)"SetFileMask", _wrap_tp_SetFileMask, METH_VARARGS },
	 { (char *)"GetFileMask", _wrap_tp_GetFileMask, METH_VARARGS },
	 { (char *)"SetVariousFileMask", _wrap_tp_SetVariousFileMask, METH_VARARGS },
	 { (char *)"GetVariousFileMask", _wrap_tp_GetVariousFileMask, METH_VARARGS },
	 { (char *)"SetAllowedFileCharacters", _wrap_tp_SetAllowedFileCharacters, METH_VARARGS },
	 { (char *)"GetAllowedFileCharacters", _wrap_tp_GetAllowedFileCharacters, METH_VARARGS },
	 { (char *)"SetDestDir", _wrap_tp_SetDestDir, METH_VARARGS },
	 { (char *)"GetDestDir", _wrap_tp_GetDestDir, METH_VARARGS },
	 { (char *)"SetTopSrcDir", _wrap_tp_SetTopSrcDir, METH_VARARGS },
	 { (char *)"GetTopSrcDir", _wrap_tp_GetTopSrcDir, METH_VARARGS },
	 { (char *)"SetTRMCollisionThreshold", _wrap_tp_SetTRMCollisionThreshold, METH_VARARGS },
	 { (char *)"GetTRMCollisionThreshold", _wrap_tp_GetTRMCollisionThreshold, METH_VARARGS },
	 { (char *)"SetMinTRMThreshold", _wrap_tp_SetMinTRMThreshold, METH_VARARGS },
	 { (char *)"GetMinTRMThreshold", _wrap_tp_GetMinTRMThreshold, METH_VARARGS },
	 { (char *)"SetAutoSaveThreshold", _wrap_tp_SetAutoSaveThreshold, METH_VARARGS },
	 { (char *)"GetAutoSaveThreshold", _wrap_tp_GetAutoSaveThreshold, METH_VARARGS },
	 { (char *)"SetMaxFileNameLen", _wrap_tp_SetMaxFileNameLen, METH_VARARGS },
	 { (char *)"GetMaxFileNameLen", _wrap_tp_GetMaxFileNameLen, METH_VARARGS },
	 { (char *)"SetAutoRemovedSavedFiles", _wrap_tp_SetAutoRemovedSavedFiles, METH_VARARGS },
	 { (char *)"GetAutoRemovedSavedFiles", _wrap_tp_GetAutoRemovedSavedFiles, METH_VARARGS },
	 { (char *)"GetRecognizedFileList", _wrap_tp_GetRecognizedFileList, METH_VARARGS },
	 { (char *)"GetTrackStatus", _wrap_tr_GetStatus, METH_VARARGS },
	 { (char *)"SetTrackStatus", _wrap_tr_SetStatus, METH_VARARGS },
	 { (char *)"GetFileName", _wrap_tr_GetFileName, METH_VARARGS },
	 { (char *)"GetTRM", _wrap_tr_GetTRM, METH_VARARGS },
	 { (char *)"GetLocalMetadata", _wrap_tr_GetLocalMetadata, METH_VARARGS },
	 { (char *)"SetLocalMetadata", _wrap_tr_SetLocalMetadata, METH_VARARGS },
	 { (char *)"GetServerMetadata", _wrap_tr_GetServerMetadata, METH_VARARGS },
	 { (char *)"SetServerMetadata", _wrap_tr_SetServerMetadata, METH_VARARGS },
	 { (char *)"GetTrackError", _wrap_tr_GetError, METH_VARARGS },
	 { (char *)"GetSimilarity", _wrap_tr_GetSimilarity, METH_VARARGS },
	 { (char *)"HasChanged", _wrap_tr_HasChanged, METH_VARARGS },
	 { (char *)"GetResults", _wrap_tr_GetResults, METH_VARARGS },
	 { (char *)"Lock", _wrap_tr_Lock, METH_VARARGS },
	 { (char *)"Unlock", _wrap_tr_Unlock, METH_VARARGS },
	 { (char *)"Clear", _wrap_md_Clear, METH_VARARGS },
	 { (char *)"ConvertToAlbumStatus", _wrap_md_ConvertToAlbumStatus, METH_VARARGS },
	 { (char *)"ConvertToAlbumType", _wrap_md_ConvertToAlbumType, METH_VARARGS },
	 { (char *)"ConvertFromAlbumStatus", _wrap_md_ConvertFromAlbumStatus, METH_VARARGS },
	 { (char *)"ConvertFromAlbumType", _wrap_md_ConvertFromAlbumType, METH_VARARGS },
	 { NULL, NULL }
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_a_32__char[] = {{"_p_a_32__char", 0, "char (*)[32]", 0},{"_p_a_32__char"},{0}};
static swig_type_info _swigt__track[] = {{"_track", 0, "track", 0},{"_tunepimp"},{"_track"},{0}};
static swig_type_info _swigt__tunepimp[] = {{"_tunepimp", 0, "tunepimp", 0},{"_tunepimp"},{"_track"},{0}};
static swig_type_info _swigt__p_short[] = {{"_p_short", 0, "short *", 0},{"_p_short"},{0}};
static swig_type_info _swigt__p_albumtrackresult[] = {{"_p_albumtrackresult", 0, "albumtrackresult *", 0},{"_p_albumtrackresult"},{0}};
static swig_type_info _swigt__p_albumresult[] = {{"_p_albumresult", 0, "albumresult *", 0},{"_p_albumresult"},{0}};
static swig_type_info _swigt__p_artistresult[] = {{"_p_artistresult", 0, "artistresult *", 0},{"_p_artistresult"},{0}};
static swig_type_info _swigt__p_result[] = {{"_p_result", 0, "result *", 0},{"_p_result"},{0}};
static swig_type_info _swigt__p_metadata[] = {{"_p_metadata", 0, "metadata *", 0},{"_p_metadata"},{0}};
static swig_type_info _swigt__p_int[] = {{"_p_int", 0, "int *", 0},{"_p_int"},{0}};
static swig_type_info _swigt__p_p_int[] = {{"_p_p_int", 0, "int **", 0},{"_p_p_int"},{0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_a_32__char, 
_swigt__track, 
_swigt__tunepimp, 
_swigt__p_short, 
_swigt__p_albumtrackresult, 
_swigt__p_albumresult, 
_swigt__p_artistresult, 
_swigt__p_result, 
_swigt__p_metadata, 
_swigt__p_int, 
_swigt__p_p_int, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

static swig_const_info swig_const_table[] = {
{0}};

#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) SWIG_init(void) 
{
    static PyObject *SWIG_globals = 0; 
    static int       typeinit = 0;
    PyObject *m, *d;
    int       i;

    if (!SWIG_globals) SWIG_globals = SWIG_newvarlink();
    m = Py_InitModule((char *) SWIG_name, SwigMethods);
    d = PyModule_GetDict(m);
  
    Py_TunePimpError = PyErr_NewException("musicbrainz.TunePimpError", NULL, NULL);
    PyDict_SetItemString(d, "TunePimpError", Py_TunePimpError);
    PyDict_SetItemString(d, "__version__", PyString_FromString(VERSION));
    
    if (!typeinit) {
        for (i = 0; swig_types_initial[i]; i++) {
            swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        }
        typeinit = 1;
    }
    SWIG_InstallConstants(d,swig_const_table);
    
}

