#ifndef S11N_NS_DEFAULT_REGISTRATIONS_H_INCLUDED
#define S11N_NS_DEFAULT_REGISTRATIONS_H_INCLUDED 1
////////////////////////////////////////////////////////////////////////
// a set of default proxy installations used by the s11n framework
// License: Public Domain
// Author: stephan@wanderinghorse.net
////////////////////////////////////////////////////////////////////////

#include <S11N_NS/data_node_functor.h>
#include <S11N_NS/data_node_algo.h>

#define S11N_STREAMABLES_PROXY S11N_NS::streamable_type_serializer_proxy

#define S11N_TYPE char
#define S11N_NAME "char"
#define S11N_SERIALIZE_FUNCTOR S11N_STREAMABLES_PROXY
#include <s11n/reg_proxy.h>

#define S11N_TYPE bool
#define S11N_NAME "bool"
#define S11N_SERIALIZE_FUNCTOR S11N_STREAMABLES_PROXY
#include <s11n/reg_proxy.h>

#define S11N_TYPE int
#define S11N_NAME "int"
#define S11N_SERIALIZE_FUNCTOR S11N_STREAMABLES_PROXY
#include <s11n/reg_proxy.h>

#define S11N_TYPE size_t
#define S11N_NAME "size_t"
#define S11N_SERIALIZE_FUNCTOR S11N_STREAMABLES_PROXY
#include <s11n/reg_proxy.h>

#define S11N_TYPE float
#define S11N_NAME "float"
#define S11N_SERIALIZE_FUNCTOR S11N_STREAMABLES_PROXY
#include <s11n/reg_proxy.h>

#define S11N_TYPE double
#define S11N_NAME "double"
#define S11N_SERIALIZE_FUNCTOR S11N_STREAMABLES_PROXY
#include <s11n/reg_proxy.h>

#define S11N_TYPE long
#define S11N_NAME "long"
#define S11N_SERIALIZE_FUNCTOR S11N_STREAMABLES_PROXY
#include <s11n/reg_proxy.h>

#define S11N_TYPE std::string
#define S11N_NAME "std::string"
#define S11N_SERIALIZE_FUNCTOR S11N_STREAMABLES_PROXY
#include <s11n/reg_proxy.h>


#undef S11N_STREAMABLES_PROXY
#endif // S11N_NS_DEFAULT_REGISTRATIONS_H_INCLUDED
